/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.battle;

import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.UncivSound;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.UnitType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\fH\u0016J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\bJ\b\u0010\u001a\u001a\u00020\fH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u001a\u0010!\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\b\u0010\"\u001a\u00020\bH\u0016J\u0010\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u000eH\u0016J\u0010\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u001cH\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\fH\u0016J\b\u0010*\u001a\u00020\u001cH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006+"}, d2={"Lcom/unciv/logic/battle/MapUnitCombatant;", "Lcom/unciv/logic/battle/ICombatant;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "(Lcom/unciv/logic/map/mapunit/MapUnit;)V", "getUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "canAttack", "", "getAttackSound", "Lcom/unciv/models/UncivSound;", "getAttackingStrength", "", "getCivInfo", "Lcom/unciv/logic/civilization/Civilization;", "getDefendingStrength", "attackedByRanged", "getHealth", "getMatchingUniques", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/unique/Unique;", "uniqueType", "Lcom/unciv/models/ruleset/unique/UniqueType;", "conditionalState", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "checkCivUniques", "getMaxHealth", "getName", "", "getTile", "Lcom/unciv/logic/map/tile/Tile;", "getUnitType", "Lcom/unciv/models/ruleset/unit/UnitType;", "hasUnique", "isDefeated", "isInvisible", "to", "matchesFilter", "filter", "takeDamage", "", "damage", "toString", "core"})
public final class MapUnitCombatant
implements ICombatant {
    @NotNull
    private final MapUnit unit;

    public MapUnitCombatant(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        this.unit = unit;
    }

    @NotNull
    public final MapUnit getUnit() {
        return this.unit;
    }

    @Override
    public int getHealth() {
        return this.unit.getHealth();
    }

    @Override
    public int getMaxHealth() {
        return 100;
    }

    @Override
    @NotNull
    public Civilization getCivInfo() {
        return this.unit.getCiv();
    }

    @Override
    @NotNull
    public Tile getTile() {
        return this.unit.getTile();
    }

    @Override
    @NotNull
    public String getName() {
        return this.unit.getName();
    }

    @Override
    public boolean isDefeated() {
        return this.unit.getHealth() <= 0;
    }

    @Override
    public boolean isInvisible(@NotNull Civilization to) {
        Intrinsics.checkNotNullParameter(to, "to");
        return this.unit.isInvisible(to);
    }

    @Override
    public boolean canAttack() {
        return this.unit.canAttack();
    }

    @Override
    public boolean matchesFilter(@NotNull String filter2) {
        Intrinsics.checkNotNullParameter(filter2, "filter");
        return this.unit.matchesFilter(filter2);
    }

    @Override
    @NotNull
    public UncivSound getAttackSound() {
        String it = this.unit.getBaseUnit().getAttackSound();
        boolean bl = false;
        return it == null ? UncivSound.Companion.getClick() : new UncivSound(it);
    }

    @Override
    public void takeDamage(int damage) {
        this.unit.takeDamage(damage);
    }

    @Override
    public int getAttackingStrength() {
        return this.isRanged() ? this.unit.getBaseUnit().getRangedStrength() : this.unit.getBaseUnit().getStrength();
    }

    @Override
    public int getDefendingStrength(boolean attackedByRanged) {
        return this.unit.isEmbarked() && !this.isCivilian() ? this.unit.getCiv().getEra().getEmbarkDefense() : (this.isRanged() && attackedByRanged ? this.unit.getBaseUnit().getRangedStrength() : this.unit.getBaseUnit().getStrength());
    }

    @Override
    @NotNull
    public UnitType getUnitType() {
        return this.unit.getType();
    }

    @NotNull
    public String toString() {
        return this.unit.getName() + " of " + this.unit.getCiv().getCivName();
    }

    @NotNull
    public final Sequence<Unique> getMatchingUniques(@NotNull UniqueType uniqueType, @NotNull StateForConditionals conditionalState, boolean checkCivUniques) {
        Intrinsics.checkNotNullParameter((Object)uniqueType, "uniqueType");
        Intrinsics.checkNotNullParameter(conditionalState, "conditionalState");
        return this.unit.getMatchingUniques(uniqueType, conditionalState, checkCivUniques);
    }

    public final boolean hasUnique(@NotNull UniqueType uniqueType, @Nullable StateForConditionals conditionalState) {
        Intrinsics.checkNotNullParameter((Object)uniqueType, "uniqueType");
        return conditionalState == null ? MapUnit.hasUnique$default(this.unit, uniqueType, null, false, 6, null) : MapUnit.hasUnique$default(this.unit, uniqueType, conditionalState, false, 4, null);
    }

    public static /* synthetic */ boolean hasUnique$default(MapUnitCombatant mapUnitCombatant, UniqueType uniqueType, StateForConditionals stateForConditionals, int n, Object object) {
        if ((n & 2) != 0) {
            stateForConditionals = null;
        }
        return mapUnitCombatant.hasUnique(uniqueType, stateForConditionals);
    }

    @Override
    public boolean isMelee() {
        return ICombatant.DefaultImpls.isMelee(this);
    }

    @Override
    public boolean isRanged() {
        return ICombatant.DefaultImpls.isRanged(this);
    }

    @Override
    public boolean isAirUnit() {
        return ICombatant.DefaultImpls.isAirUnit(this);
    }

    @Override
    public boolean isWaterUnit() {
        return ICombatant.DefaultImpls.isWaterUnit(this);
    }

    @Override
    public boolean isLandUnit() {
        return ICombatant.DefaultImpls.isLandUnit(this);
    }

    @Override
    public boolean isCity() {
        return ICombatant.DefaultImpls.isCity(this);
    }

    @Override
    public boolean isCivilian() {
        return ICombatant.DefaultImpls.isCivilian(this);
    }
}

