/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.battle;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.battle.AirInterception;
import com.unciv.logic.battle.Battle;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.battle.Nuke;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.CivilopediaAction;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJP\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r2\u0006\u0010\u000e\u001a\u00020\f2\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\bH\u0002JZ\u0010\u0012\u001a.\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r0\u00132\u0006\u0010\u000e\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J(\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\"\u001a\u00020\u001c*\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0002\u00a8\u0006%"}, d2={"Lcom/unciv/logic/battle/Nuke;", "", "()V", "NUKE", "", "attacker", "Lcom/unciv/logic/battle/MapUnitCombatant;", "targetTile", "Lcom/unciv/logic/map/tile/Tile;", "addNukeNotifications", "notifyDeclaredWarCivs", "Ljava/util/ArrayList;", "Lcom/unciv/logic/civilization/Civilization;", "Lkotlin/collections/ArrayList;", "attackingCiv", "hitCivsTerritory", "applyPillageAndFallout", "tile", "declareWarOnHitCivs", "Lkotlin/Pair;", "hitTiles", "Lkotlin/sequences/Sequence;", "doNukeExplosionDamageToCity", "targetedCity", "Lcom/unciv/logic/city/City;", "nukeStrength", "", "damageModifierFromMissingResource", "", "doNukeExplosionForTile", "isGroundZero", "", "mayUseNuke", "nuke", "getAggregateModifier", "uniqueType", "Lcom/unciv/models/ruleset/unique/UniqueType;", "core"})
public final class Nuke {
    @NotNull
    public static final Nuke INSTANCE = new Nuke();

    private Nuke() {
    }

    public final boolean mayUseNuke(@NotNull MapUnitCombatant nuke, @NotNull Tile targetTile) {
        Intrinsics.checkNotNullParameter(nuke, "nuke");
        Intrinsics.checkNotNullParameter(targetTile, "targetTile");
        if (Intrinsics.areEqual(nuke.getTile(), targetTile)) {
            return false;
        }
        if (!targetTile.isVisible(nuke.getCivInfo())) {
            return false;
        }
        Ref.BooleanRef canNuke = new Ref.BooleanRef();
        canNuke.element = true;
        Civilization attackerCiv = nuke.getCivInfo();
        int blastRadius = nuke.getUnit().getNukeBlastRadius();
        Iterator<Tile> iterator2 = targetTile.getTilesInDistance(blastRadius).iterator();
        while (iterator2.hasNext()) {
            Tile tile = iterator2.next();
            Nuke.mayUseNuke$checkDefenderCiv(attackerCiv, canNuke, tile.getOwner());
            ICombatant iCombatant = Battle.INSTANCE.getMapCombatantOfTile(tile);
            Nuke.mayUseNuke$checkDefenderCiv(attackerCiv, canNuke, iCombatant != null ? iCombatant.getCivInfo() : null);
        }
        return canNuke.element;
    }

    public final void NUKE(@NotNull MapUnitCombatant attacker, @NotNull Tile targetTile) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Intrinsics.checkNotNullParameter(targetTile, "targetTile");
        Civilization attackingCiv = attacker.getCivInfo();
        Object object = (Unique)SequencesKt.firstOrNull(MapUnit.getMatchingUniques$default(attacker.getUnit(), UniqueType.NuclearWeapon, null, false, 6, null));
        if (object == null || (object = ((Unique)object).getParams()) == null || (object = (String)object.get(0)) == null) {
            return;
        }
        int nukeStrength = Integer.parseInt((String)object);
        Object object2 = (Unique)SequencesKt.firstOrNull(MapUnit.getMatchingUniques$default(attacker.getUnit(), UniqueType.BlastRadius, null, false, 6, null));
        int blastRadius = object2 != null && (object2 = ((Unique)object2).getParams()) != null && (object2 = (String)object2.get(0)) != null ? Integer.parseInt((String)object2) : 2;
        Sequence<Tile> hitTiles = targetTile.getTilesInDistance(blastRadius);
        Pair<ArrayList<Civilization>, ArrayList<Civilization>> pair = this.declareWarOnHitCivs(attackingCiv, hitTiles, attacker, targetTile);
        ArrayList<Civilization> hitCivsTerritory = pair.component1();
        ArrayList<Civilization> notifyDeclaredWarCivs = pair.component2();
        this.addNukeNotifications(targetTile, attacker, notifyDeclaredWarCivs, attackingCiv, hitCivsTerritory);
        if (attacker.isDefeated()) {
            return;
        }
        attacker.getUnit().getAttacksSinceTurnStart().add(new Vector2(targetTile.getPosition()));
        Object object3 = hitTiles.iterator();
        while (object3.hasNext()) {
            Tile tile = object3.next();
            this.doNukeExplosionForTile(attacker, tile, nukeStrength, Intrinsics.areEqual(targetTile, tile));
        }
        if (MapUnit.hasUnique$default(attacker.getUnit(), UniqueType.SelfDestructs, null, false, 6, null)) {
            MapUnit.destroy$default(attacker.getUnit(), false, 1, null);
        }
        object3 = attackingCiv.getKnownCivs().iterator();
        while (object3.hasNext()) {
            Civilization civ = (Civilization)object3.next();
            DiplomacyManager diplomacyManager = civ.getDiplomacyManager(attackingCiv);
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.setModifier(DiplomaticModifiers.UsedNuclearWeapons, -50.0f);
        }
        if (!attacker.isDefeated()) {
            object3 = attacker.getUnit();
            ((MapUnit)object3).setAttacksThisTurn(((MapUnit)object3).getAttacksThisTurn() + 1);
        }
    }

    private final void addNukeNotifications(Tile targetTile, MapUnitCombatant attacker, ArrayList<Civilization> notifyDeclaredWarCivs, Civilization attackingCiv, ArrayList<Civilization> hitCivsTerritory) {
        String[] stringArray;
        NotificationAction[] notificationActionArray = new NotificationAction[]{new LocationAction(targetTile.getPosition()), new CivilopediaAction("Units/" + attacker.getName())};
        Sequence<NotificationAction> nukeNotificationAction = SequencesKt.sequenceOf(notificationActionArray);
        if (attacker.isDefeated()) {
            for (Civilization defendingCiv : notifyDeclaredWarCivs) {
                String[] stringArray2 = new String[]{defendingCiv.getCivName(), "OtherIcons/Pillage", attacker.getName()};
                attackingCiv.addNotification("After an attempted attack by our [" + attacker.getName() + "], [" + defendingCiv + "] has declared war on us!", nukeNotificationAction, Notification.NotificationCategory.Diplomacy, stringArray2);
            }
            return;
        }
        for (Civilization defendingCiv : notifyDeclaredWarCivs) {
            stringArray = new String[]{defendingCiv.getCivName(), "OtherIcons/Pillage", attacker.getName()};
            attackingCiv.addNotification("After being hit by our [" + attacker.getName() + "], [" + defendingCiv + "] has declared war on us!", nukeNotificationAction, Notification.NotificationCategory.Diplomacy, stringArray);
        }
        for (Civilization otherCiv : attackingCiv.getGameInfo().getCivilizations()) {
            if (!otherCiv.isAlive() || Intrinsics.areEqual(otherCiv, attackingCiv)) continue;
            if (hitCivsTerritory.contains(otherCiv)) {
                stringArray = new String[]{attackingCiv.getCivName(), "OtherIcons/Pillage", attacker.getName()};
                otherCiv.addNotification("A(n) [" + attacker.getName() + "] from [" + attackingCiv.getCivName() + "] has exploded in our territory!", nukeNotificationAction, Notification.NotificationCategory.War, stringArray);
                continue;
            }
            if (otherCiv.knows(attackingCiv)) {
                stringArray = new String[]{attackingCiv.getCivName(), "OtherIcons/Pillage", attacker.getName()};
                otherCiv.addNotification("A(n) [" + attacker.getName() + "] has been detonated by [" + attackingCiv.getCivName() + "]!", nukeNotificationAction, Notification.NotificationCategory.War, stringArray);
                continue;
            }
            stringArray = new String[]{"OtherIcons/Pillage", attacker.getName()};
            otherCiv.addNotification("A(n) [" + attacker.getName() + "] has been detonated by an unkown civilization!", nukeNotificationAction, Notification.NotificationCategory.War, stringArray);
        }
    }

    private final Pair<ArrayList<Civilization>, ArrayList<Civilization>> declareWarOnHitCivs(Civilization attackingCiv, Sequence<Tile> hitTiles, MapUnitCombatant attacker, Tile targetTile) {
        ArrayList<Civilization> notifyDeclaredWarCivs = new ArrayList<Civilization>();
        ArrayList<Civilization> hitCivsTerritory = new ArrayList<Civilization>();
        Iterator iterator2 = SequencesKt.distinct(SequencesKt.mapNotNull(hitTiles, declareWarOnHitCivs.1.INSTANCE)).iterator();
        while (iterator2.hasNext()) {
            Civilization hitCiv = (Civilization)iterator2.next();
            hitCivsTerritory.add(hitCiv);
            Nuke.declareWarOnHitCivs$tryDeclareWar(attackingCiv, notifyDeclaredWarCivs, hitCiv);
        }
        iterator2 = SequencesKt.filter(SequencesKt.distinct(SequencesKt.map(SequencesKt.flatMap(hitTiles, declareWarOnHitCivs.2.INSTANCE), declareWarOnHitCivs.3.INSTANCE)), (Function1)new Function1<Civilization, Boolean>(attackingCiv){
            final /* synthetic */ Civilization $attackingCiv;
            {
                this.$attackingCiv = $attackingCiv;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return !Intrinsics.areEqual(it, this.$attackingCiv);
            }
        }).iterator();
        while (iterator2.hasNext()) {
            Civilization civWhoseUnitWasAttacked = (Civilization)iterator2.next();
            Nuke.declareWarOnHitCivs$tryDeclareWar(attackingCiv, notifyDeclaredWarCivs, civWhoseUnitWasAttacked);
            if (!attacker.getUnit().getBaseUnit().isAirUnit() || attacker.isDefeated()) continue;
            AirInterception.INSTANCE.tryInterceptAirAttack$core(attacker, targetTile, civWhoseUnitWasAttacked, null);
        }
        return new Pair<ArrayList<Civilization>, ArrayList<Civilization>>(hitCivsTerritory, notifyDeclaredWarCivs);
    }

    private final void doNukeExplosionForTile(MapUnitCombatant attacker, Tile tile, int nukeStrength, boolean isGroundZero) {
        float damageModifierFromMissingResource = 1.0f;
        HashMap<String, Integer> civResources = attacker.getCivInfo().getCivResourcesByName();
        for (String resource2 : attacker.getUnit().getResourceRequirementsPerTurn().keySet()) {
            Integer n = civResources.get(resource2);
            Intrinsics.checkNotNull(n);
            if (((Number)n).intValue() >= 0 || attacker.getCivInfo().isBarbarian()) continue;
            damageModifierFromMissingResource *= 0.5f;
        }
        float buildingModifier = 1.0f;
        City city2 = tile.getCity();
        if (city2 != null && Intrinsics.areEqual(tile.getPosition(), city2.getLocation())) {
            buildingModifier = this.getAggregateModifier(city2, UniqueType.GarrisonDamageFromNukes);
            this.doNukeExplosionDamageToCity(city2, nukeStrength, damageModifierFromMissingResource);
            Battle.postBattleNotifications$core$default(Battle.INSTANCE, attacker, new CityCombatant(city2), city2.getCenterTile(), null, null, 24, null);
            Battle.INSTANCE.destroyIfDefeated(city2.getCiv(), attacker.getCivInfo(), city2.getLocation());
        }
        for (MapUnit unit : SequencesKt.toList(tile.getUnits())) {
            int damage = (int)((float)(isGroundZero || nukeStrength >= 2 ? 100 : (nukeStrength == 1 ? 30 + Random.Default.nextInt(40) + Random.Default.nextInt(40) : 20 + Random.Default.nextInt(30))) * buildingModifier * damageModifierFromMissingResource + Math.ulp(1.0f));
            MapUnitCombatant defender = new MapUnitCombatant(unit);
            if (unit.isCivilian()) {
                if (unit.getHealth() - damage <= 40) {
                    MapUnit.destroy$default(unit, false, 1, null);
                }
            } else {
                defender.takeDamage(damage);
            }
            Battle.postBattleNotifications$core$default(Battle.INSTANCE, attacker, defender, defender.getTile(), null, null, 24, null);
            Battle.destroyIfDefeated$default(Battle.INSTANCE, defender.getCivInfo(), attacker.getCivInfo(), null, 4, null);
        }
        if (tile.isCityCenter()) {
            return;
        }
        if (Tile.terrainHasUnique$default(tile, UniqueType.DestroyableByNukesChance, null, 2, null)) {
            for (Terrain terrainFeature : tile.getTerrainFeatureObjects()) {
                Iterator iterator2 = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)terrainFeature, UniqueType.DestroyableByNukesChance, null, 2, null).iterator();
                while (iterator2.hasNext()) {
                    Unique unique = (Unique)iterator2.next();
                    float chance = Float.parseFloat(unique.getParams().get(0)) / 100.0f;
                    if (!(chance > 0.0f && isGroundZero) && Random.Default.nextFloat() >= chance) continue;
                    tile.removeTerrainFeature(terrainFeature.getName());
                    this.applyPillageAndFallout(tile);
                }
            }
        } else if (isGroundZero || Random.Default.nextFloat() < 0.5f) {
            this.applyPillageAndFallout(tile);
        }
    }

    private final void applyPillageAndFallout(Tile tile) {
        if (tile.getUnpillagedImprovement() != null) {
            TileImprovement tileImprovement = tile.getTileImprovement();
            Intrinsics.checkNotNull(tileImprovement);
            if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)tileImprovement, UniqueType.Irremovable, null, 2, null)) {
                TileImprovement tileImprovement2 = tile.getTileImprovement();
                Intrinsics.checkNotNull(tileImprovement2);
                if (IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)tileImprovement2, UniqueType.Unpillagable, null, 2, null)) {
                    tile.removeImprovement();
                } else {
                    tile.setPillaged();
                }
            }
        }
        if (tile.getUnpillagedRoad() != RoadStatus.None) {
            tile.setPillaged();
        }
        if (tile.isWater() || tile.isImpassible() || tile.getTerrainFeatures().contains("Fallout")) {
            return;
        }
        tile.addTerrainFeature("Fallout");
    }

    private final void doNukeExplosionDamageToCity(City targetedCity, int nukeStrength, float damageModifierFromMissingResource) {
        float f;
        if ((nukeStrength > 2 || nukeStrength > 1 && targetedCity.getPopulation().getPopulation() < 5) && targetedCity.canBeDestroyed(true)) {
            City.destroyCity$default(targetedCity, false, 1, null);
            return;
        }
        CityCombatant cityCombatant = new CityCombatant(targetedCity);
        cityCombatant.takeDamage((int)((float)cityCombatant.getHealth() * 0.5f * damageModifierFromMissingResource));
        float f2 = (float)targetedCity.getPopulation().getPopulation() * this.getAggregateModifier(targetedCity, UniqueType.PopulationLossFromNukes);
        switch (nukeStrength) {
            case 0: {
                f = 0.0f;
                break;
            }
            case 1: {
                f = (float)(30 + Random.Default.nextInt(20) + Random.Default.nextInt(20)) / 100.0f;
                break;
            }
            case 2: {
                f = (float)(60 + Random.Default.nextInt(10) + Random.Default.nextInt(10)) / 100.0f;
                break;
            }
            default: {
                f = 1.0f;
            }
        }
        int populationLoss = RangesKt.coerceAtMost((int)(f2 * f), targetedCity.getPopulation().getPopulation() - 1);
        targetedCity.getPopulation().addPopulation(-populationLoss);
    }

    private final float getAggregateModifier(City $this$getAggregateModifier, UniqueType uniqueType) {
        float modifier = 1.0f;
        Iterator iterator2 = City.getMatchingUniques$default($this$getAggregateModifier, uniqueType, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            if (!City.matchesFilter$default($this$getAggregateModifier, unique.getParams().get(1), null, 2, null)) continue;
            modifier *= FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        return modifier;
    }

    private static final void mayUseNuke$checkDefenderCiv(Civilization attackerCiv, Ref.BooleanRef canNuke, Civilization defenderCiv) {
        if (defenderCiv == null) {
            return;
        }
        if (Intrinsics.areEqual(defenderCiv, attackerCiv) || defenderCiv.isDefeated()) {
            return;
        }
        if (defenderCiv.isBarbarian()) {
            return;
        }
        DiplomacyManager diplomacyManager = attackerCiv.getDiplomacyManager(defenderCiv);
        boolean bl = diplomacyManager != null ? diplomacyManager.canAttack() : false;
        if (bl) {
            return;
        }
        canNuke.element = false;
    }

    private static final void declareWarOnHitCivs$tryDeclareWar(Civilization $attackingCiv, ArrayList<Civilization> notifyDeclaredWarCivs, Civilization civSuffered) {
        if (!Intrinsics.areEqual(civSuffered, $attackingCiv) && civSuffered.knows($attackingCiv)) {
            DiplomacyManager diplomacyManager = civSuffered.getDiplomacyManager($attackingCiv);
            Intrinsics.checkNotNull(diplomacyManager);
            if (diplomacyManager.getDiplomaticStatus() != DiplomaticStatus.War) {
                DiplomacyManager diplomacyManager2 = $attackingCiv.getDiplomacyManager(civSuffered);
                Intrinsics.checkNotNull(diplomacyManager2);
                DiplomacyManager.declareWar$default(diplomacyManager2, null, 1, null);
                if (!notifyDeclaredWarCivs.contains(civSuffered)) {
                    notifyDeclaredWarCivs.add(civSuffered);
                }
            }
        }
    }
}

