/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.battle;

import com.unciv.logic.battle.AttackableTile;
import com.unciv.logic.battle.Battle;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.battle.TargetHelper;
import com.unciv.logic.city.City;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.PathsToTilesWithinTurn;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJB\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0004J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0016\u001a\u00020\u0017J2\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\u00190\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u001c\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0012H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/unciv/logic/battle/TargetHelper;", "", "()V", "containsAttackableEnemy", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "combatant", "Lcom/unciv/logic/battle/ICombatant;", "getAttackableEnemies", "Ljava/util/ArrayList;", "Lcom/unciv/logic/battle/AttackableTile;", "Lkotlin/collections/ArrayList;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "unitDistanceToTiles", "Lcom/unciv/logic/map/mapunit/movement/PathsToTilesWithinTurn;", "tilesToCheck", "", "stayOnTile", "getBombardableTiles", "Lkotlin/sequences/Sequence;", "city", "Lcom/unciv/logic/city/City;", "getTilesToAttackFromWhenUnitMoves", "Lkotlin/Pair;", "", "unitMustBeSetUp", "tileContainsAttackableEnemy", "core"})
@SourceDebugExtension(value={"SMAP\nTargetHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetHelper.kt\ncom/unciv/logic/battle/TargetHelper\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n2159#2,2:148\n2159#2,2:150\n1549#3:152\n1620#3,3:153\n*S KotlinDebug\n*F\n+ 1 TargetHelper.kt\ncom/unciv/logic/battle/TargetHelper\n*L\n120#1:148,2\n127#1:150,2\n136#1:152\n136#1:153,3\n*E\n"})
public final class TargetHelper {
    @NotNull
    public static final TargetHelper INSTANCE = new TargetHelper();

    private TargetHelper() {
    }

    @NotNull
    public final ArrayList<AttackableTile> getAttackableEnemies(@NotNull MapUnit unit, @NotNull PathsToTilesWithinTurn unitDistanceToTiles, @Nullable List<Tile> tilesToCheck, boolean stayOnTile) {
        Sequence<Pair<Tile, Float>> sequence;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(unitDistanceToTiles, "unitDistanceToTiles");
        int rangeOfAttack = unit.getRange();
        ArrayList<AttackableTile> attackableTiles2 = new ArrayList<AttackableTile>();
        boolean unitMustBeSetUp = MapUnit.hasUnique$default(unit, UniqueType.MustSetUp, null, false, 6, null);
        if (stayOnTile || unit.getBaseUnit().getMovesLikeAirUnits()) {
            Pair[] pairArray = new Pair[]{new Pair<Tile, Float>(unit.getCurrentTile(), Float.valueOf(unit.getCurrentMovement()))};
            sequence = SequencesKt.sequenceOf(pairArray);
        } else {
            sequence = this.getTilesToAttackFromWhenUnitMoves(unitDistanceToTiles, unitMustBeSetUp, unit);
        }
        Sequence<Pair<Tile, Float>> tilesToAttackFrom = sequence;
        HashSet tilesWithEnemies = new HashSet();
        HashSet tilesWithoutEnemies = new HashSet();
        Iterator<Pair<Tile, Float>> iterator2 = tilesToAttackFrom.iterator();
        while (iterator2.hasNext()) {
            Pair<Tile, Float> pair = iterator2.next();
            Tile reachableTile = pair.component1();
            float movementLeft = ((Number)pair.component2()).floatValue();
            if (unit.getBaseUnit().isMelee() && unit.isEscorting()) {
                MapUnit escortingUnit;
                Intrinsics.checkNotNull(unit.getOtherEscortUnit());
                if (!escortingUnit.getMovement().canReachInCurrentTurn(reachableTile)) continue;
                float f = escortingUnit.getCurrentMovement();
                Object object = UnitMovement.getDistanceToTiles$default(escortingUnit.getMovement(), false, null, null, false, 15, null).get((Object)reachableTile);
                Intrinsics.checkNotNull(object);
                if (f - ((UnitMovement.ParentTileAndTotalDistance)object).getTotalDistance() <= 0.0f) continue;
            }
            Sequence<Tile> tilesInAttackRange = unit.getBaseUnit().isMelee() ? reachableTile.getNeighbors() : (MapUnit.hasUnique$default(unit, UniqueType.IndirectFire, null, false, 6, null) || unit.getBaseUnit().getMovesLikeAirUnits() ? reachableTile.getTilesInDistance(rangeOfAttack) : CollectionsKt.asSequence((Iterable)reachableTile.getTileMap().getViewableTiles(reachableTile.getPosition(), rangeOfAttack, true)));
            Iterator<Tile> iterator3 = tilesInAttackRange.iterator();
            while (iterator3.hasNext()) {
                Tile tile = iterator3.next();
                if (Intrinsics.areEqual(tile, reachableTile)) continue;
                if (tilesWithEnemies.contains(tile)) {
                    ((Collection)attackableTiles2).add(new AttackableTile(reachableTile, tile, movementLeft, Battle.INSTANCE.getMapCombatantOfTile(tile)));
                    continue;
                }
                if (tilesWithoutEnemies.contains(tile)) continue;
                if (this.tileContainsAttackableEnemy(unit, tile, tilesToCheck) || unit.isPreparingAirSweep()) {
                    ((Collection)tilesWithEnemies).add(tile);
                    ((Collection)attackableTiles2).add(new AttackableTile(reachableTile, tile, movementLeft, Battle.INSTANCE.getMapCombatantOfTile(tile)));
                    continue;
                }
                ((Collection)tilesWithoutEnemies).add(tile);
            }
        }
        return attackableTiles2;
    }

    public static /* synthetic */ ArrayList getAttackableEnemies$default(TargetHelper targetHelper, MapUnit mapUnit, PathsToTilesWithinTurn pathsToTilesWithinTurn, List list2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            list2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return targetHelper.getAttackableEnemies(mapUnit, pathsToTilesWithinTurn, list2, bl);
    }

    private final Sequence<Pair<Tile, Float>> getTilesToAttackFromWhenUnitMoves(PathsToTilesWithinTurn unitDistanceToTiles, boolean unitMustBeSetUp, MapUnit unit) {
        return SequencesKt.filter(SequencesKt.filter(SequencesKt.map(MapsKt.asSequence(unitDistanceToTiles), (Function1)new Function1<Map.Entry<? extends Tile, ? extends UnitMovement.ParentTileAndTotalDistance>, Pair<? extends Tile, ? extends Float>>(unitMustBeSetUp, unit){
            final /* synthetic */ boolean $unitMustBeSetUp;
            final /* synthetic */ MapUnit $unit;
            {
                this.$unitMustBeSetUp = $unitMustBeSetUp;
                this.$unit = $unit;
                super(1);
            }

            @NotNull
            public final Pair<Tile, Float> invoke(@NotNull Map.Entry<Tile, UnitMovement.ParentTileAndTotalDistance> entry) {
                Intrinsics.checkNotNullParameter(entry, "<name for destructuring parameter 0>");
                Tile tile = entry.getKey();
                UnitMovement.ParentTileAndTotalDistance distance = entry.getValue();
                boolean movementPointsToExpendAfterMovement = this.$unitMustBeSetUp;
                boolean movementPointsToExpendHere = this.$unitMustBeSetUp && !this.$unit.isSetUpForSiege();
                boolean movementPointsToExpendBeforeAttack = Intrinsics.areEqual(tile, this.$unit.getCurrentTile()) ? movementPointsToExpendHere : movementPointsToExpendAfterMovement;
                float movementLeft = this.$unit.getCurrentMovement() - distance.getTotalDistance() - (float)movementPointsToExpendBeforeAttack;
                return new Pair<Tile, Float>(tile, Float.valueOf(movementLeft));
            }
        }), getTilesToAttackFromWhenUnitMoves.2.INSTANCE), (Function1)new Function1<Pair<? extends Tile, ? extends Float>, Boolean>(unit){
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Pair<Tile, Float> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getFirst(), this.$unit.getTile()) || UnitMovement.canMoveTo$default(this.$unit.getMovement(), it.getFirst(), false, false, false, 14, null);
            }
        });
    }

    private final boolean tileContainsAttackableEnemy(MapUnit unit, Tile tile, List<Tile> tilesToCheck) {
        List<Tile> list2 = tilesToCheck;
        if (!(list2 != null ? (Collection)list2 : (Collection)unit.getCiv().getViewableTiles()).contains(tile) || !this.containsAttackableEnemy(tile, new MapUnitCombatant(unit))) {
            return false;
        }
        ICombatant mapCombatant = Battle.INSTANCE.getMapCombatantOfTile(tile);
        return !unit.getBaseUnit().isMelee() || !(mapCombatant instanceof MapUnitCombatant) || !((MapUnitCombatant)mapCombatant).getUnit().isCivilian() || UnitMovement.canPassThrough$default(unit.getMovement(), tile, false, 2, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean containsAttackableEnemy(@NotNull Tile tile, @NotNull ICombatant combatant) {
        void $this$mapTo$iv$iv;
        Object element$iv;
        Object it;
        Iterator iterator2;
        boolean $i$f$none;
        Sequence $this$none$iv;
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(combatant, "combatant");
        if (combatant instanceof MapUnitCombatant && ((MapUnitCombatant)combatant).getUnit().isEmbarked() && !MapUnitCombatant.hasUnique$default((MapUnitCombatant)combatant, UniqueType.AttackOnSea, null, 2, null)) {
            if (tile.isWater()) return false;
            if (combatant.isRanged()) {
                return false;
            }
        }
        ICombatant iCombatant = Battle.INSTANCE.getMapCombatantOfTile(tile);
        if (iCombatant == null) {
            return false;
        }
        ICombatant tileCombatant = iCombatant;
        if (Intrinsics.areEqual(tileCombatant.getCivInfo(), combatant.getCivInfo())) {
            return false;
        }
        if (tileCombatant instanceof CityCombatant && ((CityCombatant)tileCombatant).getCity().getHasJustBeenConquered()) {
            return false;
        }
        if (!combatant.getCivInfo().isAtWarWith(tileCombatant.getCivInfo())) {
            return false;
        }
        if (combatant instanceof MapUnitCombatant && combatant.isLandUnit() && combatant.isMelee() && tile.isWater() && !combatant.getCivInfo().getTech().getUnitsCanEmbark() && !((MapUnitCombatant)combatant).getUnit().getCache().getCanMoveOnWater()) {
            return false;
        }
        if (combatant instanceof MapUnitCombatant && MapUnitCombatant.hasUnique$default((MapUnitCombatant)combatant, UniqueType.CannotAttack, null, 2, null)) {
            return false;
        }
        if (combatant instanceof MapUnitCombatant) {
            Sequence $this$containsAttackableEnemy_u24lambda_u241 = MapUnit.getMatchingUniques$default(((MapUnitCombatant)combatant).getUnit(), UniqueType.CanOnlyAttackUnits, null, false, 6, null);
            boolean bl = false;
            if (SequencesKt.any($this$containsAttackableEnemy_u24lambda_u241)) {
                $this$none$iv = $this$containsAttackableEnemy_u24lambda_u241;
                $i$f$none = false;
                iterator2 = $this$none$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return false;
                    element$iv = iterator2.next();
                    it = (Unique)element$iv;
                    boolean bl2 = false;
                } while (!tileCombatant.matchesFilter(((Unique)it).getParams().get(0)));
                boolean bl3 = false;
                if (bl3) {
                    return false;
                }
            }
            boolean bl4 = false;
            if (bl4) {
                return false;
            }
        }
        if (combatant instanceof MapUnitCombatant) {
            Sequence $this$containsAttackableEnemy_u24lambda_u243 = MapUnit.getMatchingUniques$default(((MapUnitCombatant)combatant).getUnit(), UniqueType.CanOnlyAttackTiles, null, false, 6, null);
            boolean bl = false;
            if (SequencesKt.any($this$containsAttackableEnemy_u24lambda_u243)) {
                $this$none$iv = $this$containsAttackableEnemy_u24lambda_u243;
                $i$f$none = false;
                iterator2 = $this$none$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return false;
                    element$iv = iterator2.next();
                    it = (Unique)element$iv;
                    boolean bl5 = false;
                } while (!Tile.matchesFilter$default(tile, ((Unique)it).getParams().get(0), null, false, 6, null));
                boolean bl6 = false;
                if (bl6) {
                    return false;
                }
            }
            boolean bl7 = false;
            if (bl7) {
                return false;
            }
        }
        if (!tileCombatant.isInvisible(combatant.getCivInfo())) return true;
        if (tile.isCityCenter()) return true;
        if (!(combatant instanceof MapUnitCombatant)) return false;
        Iterable $this$map$iv = combatant.getCivInfo().getViewableInvisibleUnitsTiles();
        boolean $i$f$map = false;
        Iterable bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Tile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl8 = false;
            collection.add(((Tile)it).getPosition());
        }
        if (!((List)destination$iv$iv).contains(tile.getPosition())) return false;
        return true;
    }

    @NotNull
    public final Sequence<Tile> getBombardableTiles(@NotNull City city2) {
        Intrinsics.checkNotNullParameter(city2, "city");
        return SequencesKt.filter(city2.getCenterTile().getTilesInDistance(city2.getBombardRange()), (Function1)new Function1<Tile, Boolean>(city2){
            final /* synthetic */ City $city;
            {
                this.$city = $city;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isVisible(this.$city.getCiv()) && TargetHelper.INSTANCE.containsAttackableEnemy(it, new CityCombatant(this.$city));
            }
        });
    }
}

