/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.city;

import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.city.StatTreeNode;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Counter;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.Specialist;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.StatMap;
import com.unciv.models.stats.Stats;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.utils.DebugUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\b\u0010'\u001a\u00020\u001cH\u0002J\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,J\u0018\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020\u0015H\u0002J\b\u00100\u001a\u00020\u001cH\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u001cH\u0002J\u000e\u00104\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u001cJ\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u000209J\u0010\u0010:\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020)H\u0002J\b\u0010<\u001a\u00020\u000eH\u0002J\b\u0010=\u001a\u00020\u000eH\u0002J\b\u0010>\u001a\u00020\u000eH\u0002J\u0010\u0010?\u001a\u00020\u000e2\u0006\u0010@\u001a\u00020\u001cH\u0002J\u0016\u0010A\u001a\u00020\u000e2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00150CH\u0002J\b\u0010D\u001a\u00020\u000eH\u0002J\b\u0010E\u001a\u00020\u0006H\u0002J\u0018\u0010F\u001a\u00020\u000e2\u0006\u0010G\u001a\u00020\u00152\b\b\u0002\u0010H\u001a\u00020IJ\u0010\u0010J\u001a\u00020\u00062\u0006\u0010+\u001a\u00020,H\u0002J\u0006\u0010K\u001a\u00020)J\u000e\u0010L\u001a\u00020)2\u0006\u0010M\u001a\u000206J.\u0010N\u001a\u00020&2\b\b\u0002\u0010+\u001a\u00020,2\b\b\u0002\u0010O\u001a\u00020)2\b\b\u0002\u0010P\u001a\u00020)2\b\b\u0002\u0010H\u001a\u00020IJ\u0010\u0010Q\u001a\u00020&2\u0006\u0010R\u001a\u00020\u0006H\u0002J\u000e\u0010S\u001a\u00020&2\u0006\u0010R\u001a\u00020\u0006J\u0010\u0010T\u001a\u00020&2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010U\u001a\u00020&2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010O\u001a\u00020&2\b\b\u0002\u0010H\u001a\u00020IR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R6\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000e0\u0014j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u000e`\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR6\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001c0\u0014j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001c`\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0018\"\u0004\b\u001e\u0010\u001aR\u001a\u0010\u001f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\b\"\u0004\b!\u0010\nR\u001a\u0010\"\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0010\"\u0004\b$\u0010\u0012\u00a8\u0006V"}, d2={"Lcom/unciv/logic/city/CityStats;", "", "city", "Lcom/unciv/logic/city/City;", "(Lcom/unciv/logic/city/City;)V", "baseStatTree", "Lcom/unciv/logic/city/StatTreeNode;", "getBaseStatTree", "()Lcom/unciv/logic/city/StatTreeNode;", "setBaseStatTree", "(Lcom/unciv/logic/city/StatTreeNode;)V", "getCity", "()Lcom/unciv/logic/city/City;", "currentCityStats", "Lcom/unciv/models/stats/Stats;", "getCurrentCityStats", "()Lcom/unciv/models/stats/Stats;", "setCurrentCityStats", "(Lcom/unciv/models/stats/Stats;)V", "finalStatList", "Ljava/util/LinkedHashMap;", "", "Lkotlin/collections/LinkedHashMap;", "getFinalStatList", "()Ljava/util/LinkedHashMap;", "setFinalStatList", "(Ljava/util/LinkedHashMap;)V", "happinessList", "", "getHappinessList", "setHappinessList", "statPercentBonusTree", "getStatPercentBonusTree", "setStatPercentBonusTree", "statsFromTiles", "getStatsFromTiles", "setStatsFromTiles", "addStatPercentBonusesFromBuildings", "", "calcFoodEaten", "canConvertFoodToProduction", "", "food", "currentConstruction", "Lcom/unciv/models/ruleset/IConstruction;", "constructionMatchesFilter", "construction", "filter", "getBuildingMaintenanceCosts", "getGrowthBonus", "Lcom/unciv/models/stats/StatMap;", "totalFood", "getProductionFromExcessiveFood", "getRoadTypeOfConnectionToCapital", "Lcom/unciv/logic/map/tile/RoadStatus;", "getStatConversionRate", "stat", "Lcom/unciv/models/stats/Stat;", "getStatPercentBonusesFromGoldenAge", "isGoldenAge", "getStatPercentBonusesFromPuppetCity", "getStatPercentBonusesFromRailroad", "getStatPercentBonusesFromUnitSupply", "getStatsFromProduction", "production", "getStatsFromSpecialists", "specialists", "Lcom/unciv/models/Counter;", "getStatsFromTradeRoute", "getStatsFromUniquesBySource", "getStatsOfSpecialist", "specialistName", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "getStatsPercentBonusesFromUniquesBySource", "hasExtraAnnexUnhappiness", "isConnectedToCapital", "roadType", "update", "updateTileStats", "updateCivStats", "updateBaseStatList", "statsFromBuildings", "updateCityHappiness", "updateFinalStatList", "updateStatPercentBonusList", "core"})
@SourceDebugExtension(value={"SMAP\nCityStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityStats.kt\ncom/unciv/logic/city/CityStats\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,642:1\n1549#2:643\n1620#2,3:644\n1549#2:656\n1620#2,3:657\n1549#2:661\n1620#2,3:662\n1549#2:665\n1620#2,3:666\n1549#2:669\n1620#2,3:670\n179#3,2:647\n526#4:649\n511#4,6:650\n1#5:660\n*S KotlinDebug\n*F\n+ 1 CityStats.kt\ncom/unciv/logic/city/CityStats\n*L\n116#1:643\n116#1:644,3\n513#1:656\n513#1:657,3\n562#1:661\n562#1:662,3\n579#1:665\n579#1:666,3\n603#1:669\n603#1:670,3\n125#1:647,2\n197#1:649\n197#1:650,6\n*E\n"})
public final class CityStats {
    @NotNull
    private final City city;
    @NotNull
    private StatTreeNode baseStatTree;
    @NotNull
    private StatTreeNode statPercentBonusTree;
    @NotNull
    private LinkedHashMap<String, Stats> finalStatList;
    @NotNull
    private LinkedHashMap<String, Float> happinessList;
    @NotNull
    private Stats statsFromTiles;
    @NotNull
    private Stats currentCityStats;

    public CityStats(@NotNull City city2) {
        Intrinsics.checkNotNullParameter(city2, "city");
        this.city = city2;
        this.baseStatTree = new StatTreeNode();
        this.statPercentBonusTree = new StatTreeNode();
        this.finalStatList = new LinkedHashMap();
        this.happinessList = new LinkedHashMap();
        this.statsFromTiles = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        this.currentCityStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
    }

    @NotNull
    public final City getCity() {
        return this.city;
    }

    @NotNull
    public final StatTreeNode getBaseStatTree() {
        return this.baseStatTree;
    }

    public final void setBaseStatTree(@NotNull StatTreeNode statTreeNode) {
        Intrinsics.checkNotNullParameter(statTreeNode, "<set-?>");
        this.baseStatTree = statTreeNode;
    }

    @NotNull
    public final StatTreeNode getStatPercentBonusTree() {
        return this.statPercentBonusTree;
    }

    public final void setStatPercentBonusTree(@NotNull StatTreeNode statTreeNode) {
        Intrinsics.checkNotNullParameter(statTreeNode, "<set-?>");
        this.statPercentBonusTree = statTreeNode;
    }

    @NotNull
    public final LinkedHashMap<String, Stats> getFinalStatList() {
        return this.finalStatList;
    }

    public final void setFinalStatList(@NotNull LinkedHashMap<String, Stats> linkedHashMap) {
        Intrinsics.checkNotNullParameter(linkedHashMap, "<set-?>");
        this.finalStatList = linkedHashMap;
    }

    @NotNull
    public final LinkedHashMap<String, Float> getHappinessList() {
        return this.happinessList;
    }

    public final void setHappinessList(@NotNull LinkedHashMap<String, Float> linkedHashMap) {
        Intrinsics.checkNotNullParameter(linkedHashMap, "<set-?>");
        this.happinessList = linkedHashMap;
    }

    @NotNull
    public final Stats getStatsFromTiles() {
        return this.statsFromTiles;
    }

    public final void setStatsFromTiles(@NotNull Stats stats2) {
        Intrinsics.checkNotNullParameter(stats2, "<set-?>");
        this.statsFromTiles = stats2;
    }

    @NotNull
    public final Stats getCurrentCityStats() {
        return this.currentCityStats;
    }

    public final void setCurrentCityStats(@NotNull Stats stats2) {
        Intrinsics.checkNotNullParameter(stats2, "<set-?>");
        this.currentCityStats = stats2;
    }

    private final Stats getStatsFromTradeRoute() {
        Stats stats2 = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        City city2 = Civilization.getCapital$default(this.city.getCiv(), false, 1, null);
        Intrinsics.checkNotNull(city2);
        City capitalForTradeRoutePurposes = city2;
        if (!Intrinsics.areEqual(this.city, capitalForTradeRoutePurposes) && City.isConnectedToCapital$default(this.city, null, 1, null)) {
            stats2.setGold((float)capitalForTradeRoutePurposes.getPopulation().getPopulation() * 0.15f + (float)this.city.getPopulation().getPopulation() * 1.1f - 1.0f);
            Iterator iterator2 = City.getMatchingUniques$default(this.city, UniqueType.StatsFromTradeRoute, null, false, 6, null).iterator();
            while (iterator2.hasNext()) {
                Unique unique = (Unique)iterator2.next();
                stats2.add(unique.getStats());
            }
            Stats percentageStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
            Iterator<Object> iterator3 = City.getMatchingUniques$default(this.city, UniqueType.StatPercentFromTradeRoutes, null, false, 6, null).iterator();
            while (iterator3.hasNext()) {
                Unique unique = (Unique)iterator3.next();
                Stat stat = Stat.valueOf(unique.getParams().get(1));
                percentageStats.set(stat, percentageStats.get(stat) + Float.parseFloat(unique.getParams().get(0)));
            }
            iterator3 = stats2.iterator();
            while (iterator3.hasNext()) {
                Stat stat = ((Stats.StatValuePair)iterator3.next()).component1();
                stats2.set(stat, stats2.get(stat) * FormattingExtensionsKt.toPercent(percentageStats.get(stat)));
            }
        }
        return stats2;
    }

    /*
     * WARNING - void declaration
     */
    private final Stats getStatsFromProduction(float production) {
        void $this$mapTo$iv$iv;
        Stats stats2 = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        Iterable $this$map$iv = Stat.Companion.getStatsWithCivWideField();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Stat stat = (Stat)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        if (((List)destination$iv$iv).contains(this.city.getCityConstructions().getCurrentConstructionFromQueue())) {
            Stat stat = Stat.valueOf(this.city.getCityConstructions().getCurrentConstructionFromQueue());
            stats2.set(stat, production * this.getStatConversionRate(stat));
        }
        return stats2;
    }

    public final float getStatConversionRate(@NotNull Stat stat) {
        Object v0;
        float conversionRate;
        block2: {
            Intrinsics.checkNotNullParameter((Object)stat, "stat");
            conversionRate = 0.25f;
            Sequence $this$firstOrNull$iv = Civilization.getMatchingUniques$default(this.city.getCiv(), UniqueType.ProductionToCivWideStatConversionBonus, null, 2, null);
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Unique it = (Unique)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getParams().get(0), stat.name())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Unique conversionUnique = v0;
        if (conversionUnique != null) {
            conversionRate *= FormattingExtensionsKt.toPercent(conversionUnique.getParams().get(1));
        }
        return conversionRate;
    }

    private final Stats getStatPercentBonusesFromRailroad() {
        Stats stats2 = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        TileImprovement tileImprovement = this.city.getRuleset().getRailroadImprovement();
        if (tileImprovement == null) {
            return stats2;
        }
        TileImprovement railroadImprovement2 = tileImprovement;
        String techEnablingRailroad = railroadImprovement2.getTechRequired();
        if ((techEnablingRailroad == null || this.city.getCiv().getTech().isResearched(techEnablingRailroad)) && (this.city.isCapital() || this.isConnectedToCapital(RoadStatus.Railroad))) {
            stats2.setProduction(stats2.getProduction() + 25.0f);
        }
        return stats2;
    }

    private final void addStatPercentBonusesFromBuildings(StatTreeNode statPercentBonusTree) {
        LocalUniqueCache localUniqueCache = new LocalUniqueCache(false, 1, null);
        Iterator<Building> iterator2 = this.city.getCityConstructions().getBuiltBuildings().iterator();
        while (iterator2.hasNext()) {
            Building building = iterator2.next();
            String[] stringArray = new String[]{"Buildings", building.getName()};
            statPercentBonusTree.addStats(building.getStatPercentageBonuses(this.city, localUniqueCache), stringArray);
        }
    }

    private final Stats getStatPercentBonusesFromPuppetCity() {
        Stats stats2 = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        if (this.city.isPuppet()) {
            stats2.setScience(stats2.getScience() - 25.0f);
            stats2.setCulture(stats2.getCulture() - 25.0f);
        }
        return stats2;
    }

    private final StatMap getGrowthBonus(float totalFood) {
        StatMap growthSources = new StatMap();
        StateForConditionals stateForConditionals = new StateForConditionals(this.city.getCiv(), this.city, null, null, null, null, null, null, null, false, 1020, null);
        Iterator iterator2 = City.getMatchingUniques$default(this.city, UniqueType.GrowthPercentBonus, stateForConditionals, false, 4, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            if (!City.matchesFilter$default(this.city, unique.getParams().get(1), null, 2, null)) continue;
            growthSources.add(unique.getSourceNameForUser(), new Stats(0.0f, Float.parseFloat(unique.getParams().get(0)) / 100.0f * totalFood, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 125, null));
        }
        return growthSources;
    }

    public final boolean hasExtraAnnexUnhappiness() {
        if (Intrinsics.areEqual(this.city.getCiv().getCivName(), this.city.getFoundingCiv()) || this.city.isPuppet()) {
            return false;
        }
        return !City.containsBuildingUnique$default(this.city, UniqueType.RemoveAnnexUnhappiness, null, 2, null);
    }

    @NotNull
    public final Stats getStatsOfSpecialist(@NotNull String specialistName, @NotNull LocalUniqueCache localUniqueCache) {
        Unique unique;
        Intrinsics.checkNotNullParameter(specialistName, "specialistName");
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        Specialist specialist = this.city.getRuleset().getSpecialists().get(specialistName);
        if (specialist == null) {
            return new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        }
        Specialist specialist2 = specialist;
        Stats stats2 = specialist2.cloneStats();
        Iterator iterator2 = LocalUniqueCache.forCityGetMatchingUniques$default(localUniqueCache, this.city, UniqueType.StatsFromSpecialist, null, 4, null).iterator();
        while (iterator2.hasNext()) {
            unique = (Unique)iterator2.next();
            if (!City.matchesFilter$default(this.city, unique.getParams().get(1), null, 2, null)) continue;
            stats2.add(unique.getStats());
        }
        iterator2 = LocalUniqueCache.forCityGetMatchingUniques$default(localUniqueCache, this.city, UniqueType.StatsFromObject, null, 4, null).iterator();
        while (iterator2.hasNext()) {
            unique = (Unique)iterator2.next();
            if (!Intrinsics.areEqual(unique.getParams().get(1), specialistName)) continue;
            stats2.add(unique.getStats());
        }
        return stats2;
    }

    public static /* synthetic */ Stats getStatsOfSpecialist$default(CityStats cityStats, String string, LocalUniqueCache localUniqueCache, int n, Object object) {
        if ((n & 2) != 0) {
            localUniqueCache = new LocalUniqueCache(false);
        }
        return cityStats.getStatsOfSpecialist(string, localUniqueCache);
    }

    /*
     * WARNING - void declaration
     */
    private final Stats getStatsFromSpecialists(Counter<String> specialists) {
        void $this$filterTo$iv$iv;
        Stats stats2 = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        LocalUniqueCache localUniqueCache = new LocalUniqueCache(false, 1, null);
        Map $this$filter$iv = specialists;
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(((Number)it.getValue()).intValue() > 0)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        for (Map.Entry entry : destination$iv$iv.entrySet()) {
            stats2.add(this.getStatsOfSpecialist((String)entry.getKey(), localUniqueCache).times(((Number)entry.getValue()).intValue()));
        }
        return stats2;
    }

    private final StatTreeNode getStatsFromUniquesBySource() {
        Unique unique;
        StatTreeNode sourceToStats = new StatTreeNode();
        List<Unique> cityStateStatsMultipliers = SequencesKt.toList(Civilization.getMatchingUniques$default(this.city.getCiv(), UniqueType.BonusStatsFromCityStates, null, 2, null));
        Iterator iterator2 = City.getMatchingUniques$default(this.city, UniqueType.StatsPerCity, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            unique = (Unique)iterator2.next();
            if (!City.matchesFilter$default(this.city, unique.getParams().get(1), null, 2, null)) continue;
            CityStats.getStatsFromUniquesBySource$addUniqueStats(cityStateStatsMultipliers, sourceToStats, unique);
        }
        iterator2 = City.getMatchingUniques$default(this.city, UniqueType.StatsPerPopulation, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            unique = (Unique)iterator2.next();
            if (!City.matchesFilter$default(this.city, unique.getParams().get(2), null, 2, null)) continue;
            float amountOfEffects = this.city.getPopulation().getPopulation() / Integer.parseInt(unique.getParams().get(1));
            Stats stats2 = unique.getStats().times(amountOfEffects);
            String[] stringArray = new String[2];
            stringArray[0] = unique.getSourceNameForUser();
            String string = unique.getSourceObjectName();
            if (string == null) {
                string = "";
            }
            stringArray[1] = string;
            sourceToStats.addStats(stats2, stringArray);
        }
        iterator2 = City.getMatchingUniques$default(this.city, UniqueType.StatsFromCitiesOnSpecificTiles, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            unique = (Unique)iterator2.next();
            if (!Tile.matchesTerrainFilter$default(this.city.getCenterTile(), unique.getParams().get(1), null, 2, null)) continue;
            CityStats.getStatsFromUniquesBySource$addUniqueStats(cityStateStatsMultipliers, sourceToStats, unique);
        }
        return sourceToStats;
    }

    private final Stats getStatPercentBonusesFromGoldenAge(boolean isGoldenAge) {
        Stats stats2 = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        if (isGoldenAge) {
            stats2.setProduction(stats2.getProduction() + 20.0f);
            stats2.setCulture(stats2.getCulture() + 20.0f);
        }
        return stats2;
    }

    private final StatTreeNode getStatsPercentBonusesFromUniquesBySource(IConstruction currentConstruction) {
        Unique unique;
        Unique unique2;
        StatTreeNode sourceToStats = new StatTreeNode();
        Iterator iterator2 = City.getMatchingUniques$default(this.city, UniqueType.StatPercentBonus, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            unique2 = (Unique)iterator2.next();
            CityStats.getStatsPercentBonusesFromUniquesBySource$addUniqueStats$3(sourceToStats, unique2, Stat.valueOf(unique2.getParams().get(1)), Float.parseFloat(unique2.getParams().get(0)));
        }
        iterator2 = City.getMatchingUniques$default(this.city, UniqueType.StatPercentBonusCities, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            unique2 = (Unique)iterator2.next();
            if (!City.matchesFilter$default(this.city, unique2.getParams().get(2), null, 2, null)) continue;
            CityStats.getStatsPercentBonusesFromUniquesBySource$addUniqueStats$3(sourceToStats, unique2, Stat.valueOf(unique2.getParams().get(1)), Float.parseFloat(unique2.getParams().get(0)));
        }
        Sequence uniquesToCheck = currentConstruction instanceof BaseUnit ? City.getMatchingUniques$default(this.city, UniqueType.PercentProductionUnits, null, false, 6, null) : (currentConstruction instanceof Building && ((Building)currentConstruction).isAnyWonder() ? City.getMatchingUniques$default(this.city, UniqueType.PercentProductionWonders, null, false, 6, null) : (currentConstruction instanceof Building && !((Building)currentConstruction).isAnyWonder() ? City.getMatchingUniques$default(this.city, UniqueType.PercentProductionBuildings, null, false, 6, null) : SequencesKt.emptySequence()));
        Iterator iterator3 = uniquesToCheck.iterator();
        while (iterator3.hasNext()) {
            unique = (Unique)iterator3.next();
            if (!this.constructionMatchesFilter(currentConstruction, unique.getParams().get(1)) || !City.matchesFilter$default(this.city, unique.getParams().get(2), null, 2, null)) continue;
            CityStats.getStatsPercentBonusesFromUniquesBySource$addUniqueStats$3(sourceToStats, unique, Stat.Production, Float.parseFloat(unique.getParams().get(0)));
        }
        iterator3 = City.getMatchingUniques$default(this.city, UniqueType.StatPercentFromReligionFollowers, null, false, 6, null).iterator();
        while (iterator3.hasNext()) {
            unique = (Unique)iterator3.next();
            CityStats.getStatsPercentBonusesFromUniquesBySource$addUniqueStats$3(sourceToStats, unique, Stat.valueOf(unique.getParams().get(1)), Math.min(Float.parseFloat(unique.getParams().get(0)) * (float)this.city.getReligion().getFollowersOfOurReligion(), Float.parseFloat(unique.getParams().get(2))));
        }
        if (currentConstruction instanceof Building) {
            IsPartOfGameInfoSerialization isPartOfGameInfoSerialization = Civilization.getCapital$default(this.city.getCiv(), false, 1, null);
            boolean bl = isPartOfGameInfoSerialization != null && (isPartOfGameInfoSerialization = ((City)isPartOfGameInfoSerialization).getCityConstructions()) != null ? ((CityConstructions)isPartOfGameInfoSerialization).isBuilt(currentConstruction.getName()) : false;
            if (bl) {
                iterator3 = City.getMatchingUniques$default(this.city, UniqueType.PercentProductionBuildingsInCapital, null, false, 6, null).iterator();
                while (iterator3.hasNext()) {
                    unique = (Unique)iterator3.next();
                    CityStats.getStatsPercentBonusesFromUniquesBySource$addUniqueStats$3(sourceToStats, unique, Stat.Production, Float.parseFloat(unique.getParams().get(0)));
                }
            }
        }
        return sourceToStats;
    }

    private final Stats getStatPercentBonusesFromUnitSupply() {
        Stats stats2 = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        int supplyDeficit = this.city.getCiv().getStats().getUnitSupplyDeficit();
        if (supplyDeficit > 0) {
            stats2.setProduction(this.city.getCiv().getStats().getUnitSupplyProductionPenalty());
        }
        return stats2;
    }

    private final boolean constructionMatchesFilter(IConstruction construction2, String filter2) {
        if (construction2 instanceof Building) {
            return ((Building)construction2).matchesFilter(filter2);
        }
        if (construction2 instanceof BaseUnit) {
            return ((BaseUnit)construction2).matchesFilter(filter2);
        }
        return false;
    }

    public final boolean isConnectedToCapital(@NotNull RoadStatus roadType) {
        Intrinsics.checkNotNullParameter(roadType, "roadType");
        if (this.city.getCiv().getCities().size() < 2) {
            return false;
        }
        return roadType == RoadStatus.Railroad ? this.city.isConnectedToCapital(isConnectedToCapital.1.INSTANCE) : City.isConnectedToCapital$default(this.city, null, 1, null);
    }

    @NotNull
    public final RoadStatus getRoadTypeOfConnectionToCapital() {
        return this.isConnectedToCapital(RoadStatus.Railroad) ? RoadStatus.Railroad : (this.isConnectedToCapital(RoadStatus.Road) ? RoadStatus.Road : RoadStatus.None);
    }

    private final float getBuildingMaintenanceCosts() {
        float buildingsMaintenance = this.city.getCityConstructions().getMaintenanceCosts();
        if (!this.city.getCiv().isHuman()) {
            buildingsMaintenance *= this.city.getCiv().getGameInfo().getDifficulty().getAiBuildingMaintenanceModifier();
        }
        Iterator iterator2 = City.getMatchingUniques$default(this.city, UniqueType.BuildingMaintenance, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            buildingsMaintenance *= FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        return buildingsMaintenance;
    }

    public final void updateTileStats(@NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        Stats stats2 = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        Sequence workedTiles2 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.city.getTilesInRange()), (Function1)new Function1<Tile, Boolean>(this){
            final /* synthetic */ CityStats this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                boolean bl;
                block4: {
                    block3: {
                        Intrinsics.checkNotNullParameter(it, "it");
                        if (Intrinsics.areEqual(this.this$0.getCity().getLocation(), it.getPosition()) || this.this$0.getCity().isWorked(it)) break block3;
                        if (!Intrinsics.areEqual(it.getOwningCity(), this.this$0.getCity())) break block4;
                        TileImprovement tileImprovement = it.getUnpillagedTileImprovement();
                        boolean bl2 = tileImprovement != null ? IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)tileImprovement, UniqueType.TileProvidesYieldWithoutPopulation, null, 2, null) : false;
                        if (!bl2 && !Tile.terrainHasUnique$default(it, UniqueType.TileProvidesYieldWithoutPopulation, null, 2, null)) break block4;
                    }
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
        });
        Iterator iterator2 = workedTiles2.iterator();
        while (iterator2.hasNext()) {
            Tile tile = (Tile)iterator2.next();
            if (tile.isBlockaded() && this.city.isWorked(tile)) {
                this.city.getWorkedTiles().remove(tile.getPosition());
                this.city.getLockedTiles().remove(tile.getPosition());
                this.city.setUpdateCitizens(true);
                continue;
            }
            Stats tileStats2 = tile.getStats().getTileStats(this.city, this.city.getCiv(), localUniqueCache);
            stats2.add(tileStats2);
        }
        this.statsFromTiles = stats2;
    }

    public static /* synthetic */ void updateTileStats$default(CityStats cityStats, LocalUniqueCache localUniqueCache, int n, Object object) {
        if ((n & 1) != 0) {
            localUniqueCache = new LocalUniqueCache(false, 1, null);
        }
        cityStats.updateTileStats(localUniqueCache);
    }

    public final void updateCityHappiness(@NotNull StatTreeNode statsFromBuildings) {
        float happinessFromSpecialists;
        Object unique;
        Intrinsics.checkNotNullParameter(statsFromBuildings, "statsFromBuildings");
        Civilization civInfo = this.city.getCiv();
        LinkedHashMap newHappinessList = new LinkedHashMap();
        float unhappinessModifier = civInfo.getDifficulty().getUnhappinessModifier();
        if (!civInfo.isHuman()) {
            unhappinessModifier *= civInfo.getGameInfo().getDifficulty().getAiUnhappinessModifier();
        }
        float unhappinessFromCity = -3.0f;
        if (this.hasExtraAnnexUnhappiness()) {
            unhappinessFromCity -= 2.0f;
        }
        float uniqueUnhappinessModifier = 0.0f;
        Iterator iterator2 = Civilization.getMatchingUniques$default(civInfo, UniqueType.UnhappinessFromCitiesPercentage, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            unique = (Unique)iterator2.next();
            uniqueUnhappinessModifier += Float.parseFloat(((Unique)unique).getParams().get(0));
        }
        ((Map)newHappinessList).put("Cities", Float.valueOf(unhappinessFromCity * unhappinessModifier * FormattingExtensionsKt.toPercent(uniqueUnhappinessModifier)));
        float unhappinessFromCitizens = this.city.getPopulation().getPopulation();
        unique = City.getMatchingUniques$default(this.city, UniqueType.UnhappinessFromPopulationTypePercentageChange, null, false, 6, null).iterator();
        while (unique.hasNext()) {
            Unique unique2 = (Unique)unique.next();
            if (!City.matchesFilter$default(this.city, unique2.getParams().get(2), null, 2, null)) continue;
            unhappinessFromCitizens += Float.parseFloat(unique2.getParams().get(0)) / 100.0f * (float)this.city.getPopulation().getPopulationFilterAmount(unique2.getParams().get(1));
        }
        if (this.hasExtraAnnexUnhappiness()) {
            unhappinessFromCitizens *= 2.0f;
        }
        if (unhappinessFromCitizens < 0.0f) {
            unhappinessFromCitizens = 0.0f;
        }
        ((Map)newHappinessList).put("Population", Float.valueOf(-unhappinessFromCitizens * unhappinessModifier));
        if (this.hasExtraAnnexUnhappiness()) {
            ((Map)newHappinessList).put("Occupied City", Float.valueOf(-2.0f));
        }
        if ((happinessFromSpecialists = (float)((int)this.getStatsFromSpecialists(this.city.getPopulation().getNewSpecialists()).getHappiness())) > 0.0f) {
            Float object = Float.valueOf(happinessFromSpecialists);
            ((Map)newHappinessList).put("Specialists", object);
        }
        ((Map)newHappinessList).put("Buildings", Float.valueOf((int)statsFromBuildings.getTotalStats().getHappiness()));
        ((Map)newHappinessList).put("Tile yields", Float.valueOf(this.statsFromTiles.getHappiness()));
        StatTreeNode happinessBySource = this.getStatsFromUniquesBySource();
        for (Map.Entry entry : ((Map)happinessBySource.getChildren()).entrySet()) {
            String source = (String)entry.getKey();
            StatTreeNode stats2 = (StatTreeNode)entry.getValue();
            if (stats2.getTotalStats().getHappiness() == 0.0f) continue;
            if (!newHappinessList.containsKey(source)) {
                ((Map)newHappinessList).put(source, Float.valueOf(0.0f));
            }
            Map map2 = newHappinessList;
            Object v = newHappinessList.get(source);
            Intrinsics.checkNotNull(v);
            map2.put(source, Float.valueOf(((Number)v).floatValue() + stats2.getTotalStats().getHappiness()));
        }
        this.happinessList = newHappinessList;
    }

    private final void updateBaseStatList(StatTreeNode statsFromBuildings) {
        StatTreeNode newBaseStatTree = new StatTreeNode();
        StatMap newBaseStatList = new StatMap();
        float f = this.city.getPopulation().getPopulation();
        float f2 = this.city.getPopulation().getFreePopulation();
        String[] stringArray = new String[]{"Population"};
        newBaseStatTree.addStats(new Stats(f2, 0.0f, 0.0f, f, 0.0f, 0.0f, 0.0f, 118, null), stringArray);
        ((Map)newBaseStatList).put("Tile yields", this.statsFromTiles);
        ((Map)newBaseStatList).put("Specialists", this.getStatsFromSpecialists(this.city.getPopulation().getNewSpecialists()));
        ((Map)newBaseStatList).put("Trade routes", this.getStatsFromTradeRoute());
        ((Map)newBaseStatTree.getChildren()).put("Buildings", statsFromBuildings);
        for (Map.Entry entry : ((Map)newBaseStatList).entrySet()) {
            String source = (String)entry.getKey();
            Stats stats2 = (Stats)entry.getValue();
            String[] stringArray2 = new String[]{source};
            newBaseStatTree.addStats(stats2, stringArray2);
        }
        newBaseStatTree.add(this.getStatsFromUniquesBySource());
        this.baseStatTree = newBaseStatTree;
    }

    private final void updateStatPercentBonusList(IConstruction currentConstruction) {
        StatTreeNode newStatsBonusTree = new StatTreeNode();
        String[] stringArray = new String[]{"Golden Age"};
        newStatsBonusTree.addStats(this.getStatPercentBonusesFromGoldenAge(this.city.getCiv().getGoldenAges().isGoldenAge()), stringArray);
        this.addStatPercentBonusesFromBuildings(newStatsBonusTree);
        stringArray = new String[]{"Railroad"};
        newStatsBonusTree.addStats(this.getStatPercentBonusesFromRailroad(), stringArray);
        stringArray = new String[]{"Puppet City"};
        newStatsBonusTree.addStats(this.getStatPercentBonusesFromPuppetCity(), stringArray);
        stringArray = new String[]{"Unit Supply"};
        newStatsBonusTree.addStats(this.getStatPercentBonusesFromUnitSupply(), stringArray);
        newStatsBonusTree.add(this.getStatsPercentBonusesFromUniquesBySource(currentConstruction));
        if (DebugUtils.INSTANCE.getSUPERCHARGED()) {
            Stats stats2 = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
            for (Stat stat : Stat.values()) {
                stats2.set(stat, 10000.0f);
            }
            String[] stringArray2 = new String[]{"Supercharged"};
            newStatsBonusTree.addStats(stats2, stringArray2);
        }
        this.statPercentBonusTree = newStatsBonusTree;
    }

    public final void update(@NotNull IConstruction currentConstruction, boolean updateTileStats2, boolean updateCivStats, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(currentConstruction, "currentConstruction");
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        if (updateTileStats2) {
            this.updateTileStats(localUniqueCache);
        }
        StatTreeNode statsFromBuildings = this.city.getCityConstructions().getStats(localUniqueCache);
        this.updateBaseStatList(statsFromBuildings);
        this.updateCityHappiness(statsFromBuildings);
        this.updateStatPercentBonusList(currentConstruction);
        this.updateFinalStatList(currentConstruction);
        Stats newCurrentCityStats = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        for (Stats stat : this.finalStatList.values()) {
            Intrinsics.checkNotNull(stat);
            newCurrentCityStats.add(stat);
        }
        this.currentCityStats = newCurrentCityStats;
        if (updateCivStats) {
            this.city.getCiv().updateStatsForNextTurn();
        }
    }

    public static /* synthetic */ void update$default(CityStats cityStats, IConstruction iConstruction, boolean bl, boolean bl2, LocalUniqueCache localUniqueCache, int n, Object object) {
        if ((n & 1) != 0) {
            iConstruction = cityStats.city.getCityConstructions().getCurrentConstruction();
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            localUniqueCache = new LocalUniqueCache(false, 1, null);
        }
        cityStats.update(iConstruction, bl, bl2, localUniqueCache);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateFinalStatList(IConstruction currentConstruction) {
        void $this$mapTo$iv$iv;
        Unique growthNullifyingUnique;
        void $this$mapTo$iv$iv2;
        boolean bl;
        Iterable it;
        boolean bl2;
        Object object;
        void $this$mapTo$iv$iv3;
        Object $this$map$iv;
        Iterable<Stats.StatValuePair> entry22;
        StatMap newFinalStatList = new StatMap();
        for (Map.Entry object2 : ((Map)this.baseStatTree.getChildren()).entrySet()) {
            String key = (String)object2.getKey();
            StatTreeNode value = (StatTreeNode)object2.getValue();
            ((Map)newFinalStatList).put(key, value.getTotalStats().clone());
        }
        Stats statPercentBonusesSum = this.statPercentBonusTree.getTotalStats();
        for (Iterable<Stats.StatValuePair> entry22 : newFinalStatList.values()) {
            entry22.setProduction(entry22.getProduction() * FormattingExtensionsKt.toPercent(statPercentBonusesSum.getProduction()));
        }
        Collection<Stats> collection = newFinalStatList.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        entry22 = collection;
        Object d = this;
        boolean $i$f$map22 = false;
        void var7_24 = $this$map$iv;
        Object destination$iv$iv232 = (String[])new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it2;
            Stats stats2 = (Stats)item$iv$iv;
            object = destination$iv$iv232;
            bl2 = false;
            object.add(Float.valueOf(it2.getProduction()));
        }
        Stats stats3 = ((CityStats)d).getStatsFromProduction(CollectionsKt.sumOfFloat((List)destination$iv$iv232));
        if (!stats3.isEmpty()) {
            void $this$updateFinalStatList_u24lambda_u245;
            Object $i$f$map22 = $this$map$iv = new StatTreeNode();
            d = this;
            boolean bl222 = false;
            $this$updateFinalStatList_u24lambda_u245.getChildren().putAll((Map<String, StatTreeNode>)this.baseStatTree.getChildren());
            destination$iv$iv232 = new String[]{"Production"};
            $this$updateFinalStatList_u24lambda_u245.addStats(stats3, (String)destination$iv$iv232);
            ((CityStats)d).baseStatTree = $this$map$iv;
            ((Map)newFinalStatList).put("Construction", stats3);
        }
        for (Stats entry3 : newFinalStatList.values()) {
            entry3.setGold(entry3.getGold() * FormattingExtensionsKt.toPercent(statPercentBonusesSum.getGold()));
            entry3.setCulture(entry3.getCulture() * FormattingExtensionsKt.toPercent(statPercentBonusesSum.getCulture()));
            entry3.setFood(entry3.getFood() * FormattingExtensionsKt.toPercent(statPercentBonusesSum.getFood()));
            entry3.setFaith(entry3.getFaith() * FormattingExtensionsKt.toPercent(statPercentBonusesSum.getFaith()));
        }
        if (IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)this.city.getRuleset().getModOptions(), UniqueType.ConvertGoldToScience, null, 2, null)) {
            Collection<Stats> collection2 = newFinalStatList.values();
            Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
            Object entry3 = collection2;
            double bl222 = 0.0;
            Iterator $i$f$mapTo22 = entry3.iterator();
            while ($i$f$mapTo22.hasNext()) {
                Object item$iv$iv;
                Iterator iterator2 = $i$f$mapTo22.next();
                item$iv$iv = (Stats)((Object)iterator2);
                double d2 = bl222;
                boolean $i$a$-sumOfDouble-CityStats$updateFinalStatList$amountConverted$232 = false;
                double unit = ((Stats)it).getGold();
                bl222 = d2 + unit;
            }
            float amountConverted = (int)(bl222 * (double)this.city.getCiv().getTech().getGoldPercentConvertedToScience());
            if (amountConverted > 0.0f) {
                entry3 = newFinalStatList;
                String bl222 = "Gold -> Science";
                float destination$iv$iv232 = -amountConverted;
                destination$iv$iv232 = new Stats(0.0f, 0.0f, destination$iv$iv232, amountConverted, 0.0f, 0.0f, 0.0f, 115, null);
                entry3.put(bl222, destination$iv$iv232);
            }
        }
        for (Stats entry4 : newFinalStatList.values()) {
            entry4.setScience(entry4.getScience() * FormattingExtensionsKt.toPercent(statPercentBonusesSum.getScience()));
        }
        Iterator<Stats> amountConverted = SequencesKt.distinct(SequencesKt.map(City.getMatchingUniques$default(this.city, UniqueType.NullifiesStat, null, false, 6, null), updateFinalStatList.2.INSTANCE)).iterator();
        while (amountConverted.hasNext()) {
            void $this$updateFinalStatList_u24lambda_u248;
            Pair entry4 = (Pair)((Object)amountConverted.next());
            Unique unique = (Unique)entry4.component1();
            Stat statToBeRemoved = (Stat)((Object)entry4.component2());
            Collection<Stats> collection3 = newFinalStatList.values();
            Intrinsics.checkNotNullExpressionValue(collection3, "<get-values>(...)");
            it = collection3;
            double $i$a$-sumOfDouble-CityStats$updateFinalStatList$amountConverted$232 = 0.0;
            for (Object t : it) {
                void it3;
                Stats stats4 = (Stats)t;
                double d3 = $i$a$-sumOfDouble-CityStats$updateFinalStatList$amountConverted$232;
                bl = false;
                double d4 = it3.get(statToBeRemoved);
                $i$a$-sumOfDouble-CityStats$updateFinalStatList$amountConverted$232 = d3 + d4;
            }
            double removedAmount = $i$a$-sumOfDouble-CityStats$updateFinalStatList$amountConverted$232;
            Iterable $i$a$-sumOfDouble-CityStats$updateFinalStatList$amountConverted$232 = it = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
            object = unique.getSourceNameForUser();
            d = newFinalStatList;
            bl2 = false;
            $this$updateFinalStatList_u24lambda_u248.set(statToBeRemoved, -((float)removedAmount));
            Unit unit = Unit.INSTANCE;
            ((StatMap)d).add((String)object, (Stats)it);
        }
        float foodEaten = this.calcFoodEaten();
        Object object2 = newFinalStatList.get((Object)"Population");
        Intrinsics.checkNotNull(object2);
        Stats entry4 = (Stats)object2;
        entry4.setFood(entry4.getFood() - foodEaten);
        Collection<Stats> collection4 = newFinalStatList.values();
        Intrinsics.checkNotNullExpressionValue(collection4, "<get-values>(...)");
        Iterable $this$map$iv2 = collection4;
        boolean $i$f$map3 = false;
        Iterable removedAmount = $this$map$iv2;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it4;
            Iterator iterator3 = (Stats)item$iv$iv;
            d = destination$iv$iv;
            boolean bl3 = false;
            d.add(Float.valueOf(it4.getFood()));
        }
        float totalFood = CollectionsKt.sumOfFloat((List)destination$iv$iv);
        if (totalFood > 0.0f) {
            void $this$mapTo$iv$iv4;
            StatMap growthBonuses = this.getGrowthBonus(totalFood);
            for (Map.Entry growthBonus : ((Map)growthBonuses).entrySet()) {
                newFinalStatList.add('[' + (String)growthBonus.getKey() + "] ([Growth])", (Stats)growthBonus.getValue());
            }
            if (this.city.isWeLoveTheKingDayActive() && this.city.getCiv().getHappiness() >= 0) {
                Stats weLoveTheKingFood = new Stats(0.0f, totalFood / (float)4, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 125, null);
                newFinalStatList.add("We Love The King Day", weLoveTheKingFood);
            }
            Collection<Stats> collection5 = newFinalStatList.values();
            Intrinsics.checkNotNullExpressionValue(collection5, "<get-values>(...)");
            Iterable $this$map$iv3 = collection5;
            boolean $i$f$map4 = false;
            destination$iv$iv = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv4) {
                void it5;
                Stats bl3 = (Stats)item$iv$iv;
                d = destination$iv$iv3;
                boolean bl32 = false;
                d.add(Float.valueOf(it5.getFood()));
            }
            totalFood = CollectionsKt.sumOfFloat((List)destination$iv$iv3);
        }
        float buildingsMaintenance = this.getBuildingMaintenanceCosts();
        ((Map)newFinalStatList).put("Maintenance", new Stats(0.0f, 0.0f, -((float)((int)buildingsMaintenance)), 0.0f, 0.0f, 0.0f, 0.0f, 123, null));
        if (this.canConvertFoodToProduction(totalFood, currentConstruction)) {
            ((Map)newFinalStatList).put("Excess food to production", new Stats(this.getProductionFromExcessiveFood(totalFood), -totalFood, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 124, null));
        }
        if ((growthNullifyingUnique = (Unique)SequencesKt.firstOrNull(City.getMatchingUniques$default(this.city, UniqueType.NullifiesGrowth, null, false, 6, null))) != null) {
            Collection<Stats> collection6 = newFinalStatList.values();
            Intrinsics.checkNotNullExpressionValue(collection6, "<get-values>(...)");
            Iterable destination$iv$iv3 = collection6;
            double $i$f$mapTo4 = 0.0;
            for (Object it5 : destination$iv$iv3) {
                void it6;
                Stats bl32 = (Stats)it5;
                double d4 = $i$f$mapTo4;
                bl = false;
                double d5 = it6.get(Stat.Food);
                $i$f$mapTo4 = d4 + d5;
            }
            double amountToRemove = -$i$f$mapTo4;
            newFinalStatList.add(growthNullifyingUnique.getSourceNameForUser(), new Stats(0.0f, (float)amountToRemove, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 125, null));
        }
        if (this.city.isInResistance()) {
            newFinalStatList.clear();
        }
        Collection<Stats> collection7 = newFinalStatList.values();
        Intrinsics.checkNotNullExpressionValue(collection7, "<get-values>(...)");
        Iterable $this$map$iv4 = collection7;
        boolean $i$f$map5 = false;
        Iterable destination$iv$iv3 = $this$map$iv4;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv4, 10));
        boolean $i$f$mapTo5 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Stats it6 = (Stats)item$iv$iv;
            d = destination$iv$iv4;
            bl = false;
            d.add(Float.valueOf(it2.getProduction()));
        }
        if (CollectionsKt.sumOfFloat((List)destination$iv$iv4) < 1.0f) {
            ((Map)newFinalStatList).put("Production", new Stats(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 126, null));
        }
        this.finalStatList = newFinalStatList;
    }

    public final boolean canConvertFoodToProduction(float food, @NotNull IConstruction currentConstruction) {
        Intrinsics.checkNotNullParameter(currentConstruction, "currentConstruction");
        return food > 0.0f && currentConstruction instanceof INonPerpetualConstruction && IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)((Object)currentConstruction), UniqueType.ConvertFoodToProductionWhenConstructed, null, 2, null);
    }

    public final float getProductionFromExcessiveFood(float food) {
        return food >= 4.0f ? 2.0f + (float)((int)(food / 4.0f)) : (food >= 2.0f ? 2.0f : (food >= 1.0f ? 1.0f : 0.0f));
    }

    private final float calcFoodEaten() {
        float foodEaten = (float)this.city.getPopulation().getPopulation() * (float)2;
        float foodEatenBySpecialists = 2.0f * (float)this.city.getPopulation().getNumberOfSpecialists();
        Iterator iterator2 = City.getMatchingUniques$default(this.city, UniqueType.FoodConsumptionBySpecialists, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            if (!City.matchesFilter$default(this.city, unique.getParams().get(1), null, 2, null)) continue;
            foodEatenBySpecialists *= FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        return foodEaten -= 2.0f * (float)this.city.getPopulation().getNumberOfSpecialists() - foodEatenBySpecialists;
    }

    private static final void getStatsFromUniquesBySource$addUniqueStats(List<Unique> cityStateStatsMultipliers, StatTreeNode sourceToStats, Unique unique) {
        Stats stats2 = unique.getStats().clone();
        if (unique.getSourceObjectType() == UniqueTarget.CityState) {
            for (Unique multiplierUnique : cityStateStatsMultipliers) {
                Stat stat = Stat.valueOf(multiplierUnique.getParams().get(1));
                stats2.set(stat, stats2.get(stat) * FormattingExtensionsKt.toPercent(multiplierUnique.getParams().get(0)));
            }
        }
        String[] stringArray = new String[2];
        stringArray[0] = unique.getSourceNameForUser();
        String string = unique.getSourceObjectName();
        if (string == null) {
            string = "";
        }
        stringArray[1] = string;
        sourceToStats.addStats(stats2, stringArray);
    }

    private static final void getStatsPercentBonusesFromUniquesBySource$addUniqueStats$3(StatTreeNode sourceToStats, Unique unique, Stat stat, float amount) {
        Stats stats2 = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null).add(stat, amount);
        String[] stringArray = new String[2];
        stringArray[0] = unique.getSourceNameForUser();
        String string = unique.getSourceObjectName();
        if (string == null) {
            string = "";
        }
        stringArray[1] = string;
        sourceToStats.addStats(stats2, stringArray);
    }
}

