/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.city.managers;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.automation.Automation;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.city.managers.CityExpansionManager;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.components.extensions.CollectionExtensionsKt;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014J\u0006\u0010\u0018\u001a\u00020\u0000J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u001aJ\u0006\u0010\u001b\u001a\u00020\nJ\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010!\u001a\u00020\u0012J\u0006\u0010\"\u001a\u00020\u0012J\u000e\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010$\u001a\u00020\nR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/unciv/logic/city/managers/CityExpansionManager;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "()V", "city", "Lcom/unciv/logic/city/City;", "getCity", "()Lcom/unciv/logic/city/City;", "setCity", "(Lcom/unciv/logic/city/City;)V", "cultureStored", "", "getCultureStored", "()I", "setCultureStored", "(I)V", "addNewTileWithCulture", "Lcom/badlogic/gdx/math/Vector2;", "buyTile", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "canBuyTile", "", "chooseNewTileToOwn", "clone", "getChoosableTiles", "Lkotlin/sequences/Sequence;", "getCultureToNextTile", "getGoldCostOfTile", "nextTurn", "culture", "", "relinquishOwnership", "reset", "setTransients", "takeOwnership", "tilesClaimed", "core"})
@SourceDebugExtension(value={"SMAP\nCityExpansionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityExpansionManager.kt\ncom/unciv/logic/city/managers/CityExpansionManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1774#2,4:219\n1247#3,2:223\n2159#3,2:225\n1839#3,14:227\n1#4:241\n*S KotlinDebug\n*F\n+ 1 CityExpansionManager.kt\ncom/unciv/logic/city/managers/CityExpansionManager\n*L\n34#1:219,4\n64#1:223,2\n72#1:225,2\n111#1:227,14\n*E\n"})
public final class CityExpansionManager
implements IsPartOfGameInfoSerialization {
    public transient City city;
    private int cultureStored;

    @NotNull
    public final City getCity() {
        City city2 = this.city;
        if (city2 != null) {
            return city2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("city");
        return null;
    }

    public final void setCity(@NotNull City city2) {
        Intrinsics.checkNotNullParameter(city2, "<set-?>");
        this.city = city2;
    }

    public final int getCultureStored() {
        return this.cultureStored;
    }

    public final void setCultureStored(int n) {
        this.cultureStored = n;
    }

    @NotNull
    public final CityExpansionManager clone() {
        CityExpansionManager toReturn = new CityExpansionManager();
        toReturn.cultureStored = this.cultureStored;
        return toReturn;
    }

    public final int tilesClaimed() {
        int n;
        Sequence tilesAroundCity2 = SequencesKt.map(this.getCity().getCenterTile().getNeighbors(), tilesClaimed.tilesAroundCity.1.INSTANCE);
        Iterable $this$count$iv = this.getCity().getTiles();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Vector2 it = (Vector2)element$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual(it, this.getCity().getLocation()) && !SequencesKt.contains(tilesAroundCity2, it)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    public final int getCultureToNextTile() {
        double cultureToNextTile = (double)6 * Math.pow((double)Math.max(0, this.tilesClaimed()) + 1.4813, 1.3);
        cultureToNextTile *= (double)this.getCity().getCiv().getGameInfo().getSpeed().getCultureCostModifier();
        if (this.getCity().getCiv().isCityState()) {
            cultureToNextTile *= (double)1.5f;
        }
        Iterator iterator2 = City.getMatchingUniques$default(this.getCity(), UniqueType.BorderGrowthPercentage, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            if (!City.matchesFilter$default(this.getCity(), unique.getParams().get(1), null, 2, null)) continue;
            cultureToNextTile *= (double)FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        return MathKt.roundToInt(cultureToNextTile);
    }

    public final boolean canBuyTile(@NotNull Tile tile) {
        boolean bl;
        block9: {
            Intrinsics.checkNotNullParameter(tile, "tile");
            if (this.getCity().isPuppet() || this.getCity().isBeingRazed()) {
                bl = false;
            } else if (tile.getOwner() != null) {
                bl = false;
            } else if (this.getCity().isInResistance()) {
                bl = false;
            } else if (!this.getCity().getTilesInRange().contains(tile)) {
                bl = false;
            } else {
                Sequence<Tile> $this$any$iv = tile.getNeighbors();
                boolean $i$f$any = false;
                Iterator<Tile> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    Tile element$iv;
                    Tile it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getCity(), this.getCity())) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void buyTile(@NotNull Tile tile) {
        boolean bl;
        int goldCost;
        block3: {
            Intrinsics.checkNotNullParameter(tile, "tile");
            goldCost = this.getGoldCostOfTile(tile);
            Sequence<Tile> $this$none$iv = tile.getNeighbors();
            boolean $i$f$none = false;
            Iterator<Tile> iterator2 = $this$none$iv.iterator();
            while (iterator2.hasNext()) {
                Tile element$iv;
                Tile it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getCity(), this.getCity())) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        if (bl) {
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0000\b\n\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"com/unciv/logic/city/managers/CityExpansionManager$buyTile$TriedToBuyNonContiguousTileException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "msg", "", "(Ljava/lang/String;)V", "core"})
            public final class TriedToBuyNonContiguousTileException
            extends Exception {
                public TriedToBuyNonContiguousTileException(@NotNull String msg) {
                    Intrinsics.checkNotNullParameter(msg, "msg");
                    super(msg);
                }
            }
            throw new TriedToBuyNonContiguousTileException(this.getCity() + " tried to buy " + tile + ", but it owns none of the neighbors");
        }
        if (this.getCity().getCiv().getGold() < goldCost && !this.getCity().getCiv().getGameInfo().getGameParameters().getGodMode()) {
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0000\b\n\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"com/unciv/logic/city/managers/CityExpansionManager$buyTile$NotEnoughGoldToBuyTileException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "msg", "", "(Ljava/lang/String;)V", "core"})
            public final class NotEnoughGoldToBuyTileException
            extends Exception {
                public NotEnoughGoldToBuyTileException(@NotNull String msg) {
                    Intrinsics.checkNotNullParameter(msg, "msg");
                    super(msg);
                }
            }
            throw new NotEnoughGoldToBuyTileException(this.getCity() + " tried to buy " + tile + ", but lacks gold (cost " + goldCost + ", has " + this.getCity().getCiv().getGold() + ')');
        }
        this.getCity().getCiv().addGold(-goldCost);
        this.takeOwnership(tile);
        this.getCity().reassignPopulationDeferred();
    }

    public final int getGoldCostOfTile(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        int baseCost = 50;
        int distanceFromCenter = tile.aerialDistanceTo(this.getCity().getCenterTile());
        double cost = (double)(baseCost * (distanceFromCenter - 1)) + (double)this.tilesClaimed() * 5.0;
        cost *= (double)this.getCity().getCiv().getGameInfo().getSpeed().getGoldCostModifier();
        Iterator iterator2 = City.getMatchingUniques$default(this.getCity(), UniqueType.TileCostPercentage, null, false, 6, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            if (!City.matchesFilter$default(this.getCity(), unique.getParams().get(1), null, 2, null)) continue;
            cost *= (double)FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        return MathKt.roundToInt(cost);
    }

    @NotNull
    public final Sequence<Tile> getChoosableTiles() {
        return SequencesKt.filter(this.getCity().getCenterTile().getTilesInDistance(this.getCity().getExpandRange()), getChoosableTiles.1.INSTANCE);
    }

    @Nullable
    public final Tile chooseNewTileToOwn() {
        Tile tile;
        LocalUniqueCache localUniqueCache = new LocalUniqueCache(false, 1, null);
        Sequence<Tile> $this$minByOrNull$iv = this.getChoosableTiles();
        boolean $i$f$minByOrNull = false;
        Iterator<Tile> iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            tile = null;
        } else {
            Tile minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                tile = minElem$iv;
            } else {
                Tile it = minElem$iv;
                boolean bl = false;
                int minValue$iv = Automation.INSTANCE.rankTileForExpansion$core(it, this.getCity(), localUniqueCache);
                do {
                    Tile e$iv;
                    Tile it2 = e$iv = iterator$iv.next();
                    $i$a$-minByOrNull-CityExpansionManager$chooseNewTileToOwn$1 = false;
                    int v$iv = Automation.INSTANCE.rankTileForExpansion$core(it2, this.getCity(), localUniqueCache);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                tile = minElem$iv;
            }
        }
        return tile;
    }

    public final void reset() {
        Tile tile;
        Iterator<Tile> iterator2 = this.getCity().getTiles().iterator();
        while (iterator2.hasNext()) {
            tile = iterator2.next();
            this.relinquishOwnership(tile);
        }
        this.takeOwnership(this.getCity().getCenterTile());
        iterator2 = SequencesKt.filter(this.getCity().getCenterTile().getTilesInDistance(1), reset.1.INSTANCE).iterator();
        while (iterator2.hasNext()) {
            tile = iterator2.next();
            this.takeOwnership(tile);
        }
    }

    private final Vector2 addNewTileWithCulture() {
        Tile chosenTile = this.chooseNewTileToOwn();
        if (chosenTile != null) {
            this.cultureStored -= this.getCultureToNextTile();
            this.takeOwnership(chosenTile);
            return chosenTile.getPosition();
        }
        return null;
    }

    public final void relinquishOwnership(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        this.getCity().setTiles(CollectionExtensionsKt.withoutItem(this.getCity().getTiles(), tile.getPosition()));
        for (City city2 : this.getCity().getCiv().getCities()) {
            if (!city2.isWorked(tile)) continue;
            city2.getPopulation().stopWorkingTile(tile.getPosition());
            city2.getPopulation().autoAssignPopulation$core();
        }
        tile.getImprovementFunctions().removeCreatesOneImprovementMarker();
        tile.setOwningCity(null);
        this.getCity().getCiv().getCache().updateOurTiles();
        CityStats.update$default(this.getCity().getCityStats(), null, false, false, null, 15, null);
        tile.getHistory().recordRelinquishOwnership(tile);
    }

    public final void takeOwnership(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!(!tile.isCityCenter())) {
            boolean $i$a$-check-CityExpansionManager$takeOwnership$22 = false;
            String $i$a$-check-CityExpansionManager$takeOwnership$22 = "Trying to found a city in a tile that already has one";
            throw new IllegalStateException($i$a$-check-CityExpansionManager$takeOwnership$22.toString());
        }
        if (tile.getCity() != null) {
            City city2 = tile.getCity();
            Intrinsics.checkNotNull(city2);
            city2.getExpansion().relinquishOwnership(tile);
        }
        this.getCity().setTiles(CollectionExtensionsKt.withItem(this.getCity().getTiles(), tile.getPosition()));
        tile.setOwningCity(this.getCity());
        this.getCity().getPopulation().autoAssignPopulation$core();
        this.getCity().getCiv().getCache().updateOurTiles();
        CityStats.update$default(this.getCity().getCityStats(), null, false, false, null, 15, null);
        for (MapUnit unit : SequencesKt.toList(tile.getUnits())) {
            if (!unit.getCiv().getDiplomacyFunctions().canPassThroughTiles(this.getCity().getCiv())) {
                unit.getMovement().teleportToClosestMoveableTile();
                continue;
            }
            if (!Intrinsics.areEqual(unit.getCiv(), this.getCity().getCiv()) || !unit.isSleeping() || !unit.getCache().getHasUniqueToBuildImprovements() && !unit.getCache().getHasUniqueToCreateWaterImprovements()) continue;
            unit.setDue(true);
            unit.setAction(null);
        }
        tile.getHistory().recordTakeOwnership(tile);
    }

    public final void nextTurn(float culture) {
        Vector2 location;
        this.cultureStored += (int)culture;
        if (this.cultureStored >= this.getCultureToNextTile() && (location = this.addNewTileWithCulture()) != null) {
            Object[] objectArray = new Vector2[]{location, this.getCity().getLocation()};
            Sequence<LocationAction> locations = LocationAction.Companion.invoke((Vector2[])objectArray);
            objectArray = new String[]{"StatIcons/Culture"};
            this.getCity().getCiv().addNotification('[' + this.getCity().getName() + "] has expanded its borders!", locations, Notification.NotificationCategory.Cities, (String[])objectArray);
        }
    }

    public final void setTransients() {
        Sequence<Tile> tiles2 = this.getCity().getTiles();
        Iterator<Tile> iterator2 = tiles2.iterator();
        while (iterator2.hasNext()) {
            Tile tile = iterator2.next();
            tile.setOwningCity(this.getCity());
        }
    }
}

