/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.diplomacy;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.automation.civilization.NextTurnAutomation;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.DiplomacyAction;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.MapUnitAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.Proximity;
import com.unciv.logic.civilization.diplomacy.CityStateFunctions;
import com.unciv.logic.civilization.diplomacy.CityStatePersonality;
import com.unciv.logic.civilization.diplomacy.DeclareWarReason;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.civilization.diplomacy.WarType;
import com.unciv.logic.civilization.managers.TechManager;
import com.unciv.logic.civilization.managers.UnitManager;
import com.unciv.logic.civilization.transients.CivInfoTransientCache;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Spy;
import com.unciv.models.SpyAction;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.Speed;
import com.unciv.models.ruleset.nation.CityStateType;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueMap;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.Stat;
import com.unciv.ui.components.extensions.CollectionExtensionsKt;
import com.unciv.ui.screens.victoryscreen.RankingType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\f\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0003J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0003J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J(\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\bJ\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0017J\u0006\u0010&\u001a\u00020\"J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030(J>\u0010)\u001a\u001e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\"0*j\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\"`,2\u0006\u0010-\u001a\u00020\u00032\b\b\u0002\u0010.\u001a\u00020\r2\b\b\u0002\u0010/\u001a\u00020\rJ\u0018\u00100\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u00032\b\b\u0002\u0010.\u001a\u00020\rJ\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00102\u001a\u000203J\u000e\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\u0003J\u000e\u00106\u001a\u00020\b2\u0006\u00105\u001a\u00020\u0003J\u0006\u00107\u001a\u00020\"J\u0006\u00108\u001a\u00020\bJ\u0016\u00109\u001a\u00020\"2\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\"J$\u0010<\u001a\u00020\r2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020+2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020+0AJ\u000e\u0010B\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0003J\u000e\u0010C\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0003J\u0016\u0010D\u001a\u00020\b2\u0006\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\"J\u0018\u0010E\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010F\u001a\u00020\rJ\u000e\u0010G\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J\u000e\u0010H\u001a\u00020\b2\u0006\u0010-\u001a\u00020\u0003J\u000e\u0010I\u001a\u00020\b2\u0006\u0010-\u001a\u00020\u0003J\u0006\u0010J\u001a\u00020\"J\u0006\u0010K\u001a\u00020\bJ\u0006\u0010L\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006M"}, d2={"Lcom/unciv/logic/civilization/diplomacy/CityStateFunctions;", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "(Lcom/unciv/logic/civilization/Civilization;)V", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "addProtectorCiv", "", "otherCiv", "askForUnitGifts", "attacker", "canBeMarriedBy", "", "canProvideStat", "statType", "Lcom/unciv/models/stats/Stat;", "cityStateAttacked", "cityStateBullied", "bully", "cityStateDestroyed", "diplomaticMarriage", "getCityStateBonuses", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/unique/Unique;", "cityStateType", "Lcom/unciv/models/ruleset/nation/CityStateType;", "relationshipLevel", "Lcom/unciv/logic/civilization/diplomacy/RelationshipLevel;", "uniqueType", "Lcom/unciv/models/ruleset/unique/UniqueType;", "getCityStateResourcesForAlly", "Lcom/unciv/models/ruleset/tile/ResourceSupplyList;", "getDiplomaticMarriageCost", "", "getFreeTechForCityState", "getNotificationActions", "Lcom/unciv/logic/civilization/NotificationAction;", "getNumThreateningBarbarians", "getProtectorCivs", "", "getTributeModifiers", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "demandingCiv", "demandingWorker", "requireWholeList", "getTributeWillingness", "getUniquesProvidedByCityStates", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "giveGreatPersonToPatron", "receivingCiv", "giveMilitaryUnitToPatron", "goldGainedByTribute", "holdElections", "influenceGainedByGift", "donorCiv", "giftAmount", "initCityState", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "startingEra", "unusedMajorCivs", "", "otherCivCanPledgeProtection", "otherCivCanWithdrawProtection", "receiveGoldGift", "removeProtectorCiv", "forced", "threateningBarbarianKilledBy", "tributeGold", "tributeWorker", "turnsForGreatPersonFromCityState", "updateAllyCivForCityState", "updateDiplomaticRelationshipForCityState", "core"})
@SourceDebugExtension(value={"SMAP\nCityStateFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityStateFunctions.kt\ncom/unciv/logic/civilization/diplomacy/CityStateFunctions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,762:1\n766#2:763\n857#2,2:764\n1549#2:766\n1620#2,3:767\n766#2:770\n857#2,2:771\n766#2:773\n857#2,2:774\n1747#2,3:777\n766#2:780\n857#2,2:781\n766#2:783\n857#2,2:784\n1549#2:786\n1620#2,3:787\n766#2:797\n857#2,2:798\n766#2:800\n857#2,2:801\n1747#2,3:805\n1054#2:808\n766#2:819\n857#2,2:820\n1774#2,4:822\n288#2,2:826\n1855#2,2:831\n1855#2,2:833\n1#3:776\n526#4:790\n511#4,6:791\n526#4:809\n511#4,6:810\n1313#5,2:803\n1268#5,3:816\n1268#5,3:828\n*S KotlinDebug\n*F\n+ 1 CityStateFunctions.kt\ncom/unciv/logic/civilization/diplomacy/CityStateFunctions\n*L\n38#1:763\n38#1:764,2\n38#1:766\n38#1:767,3\n57#1:770\n57#1:771,2\n75#1:773\n75#1:774,2\n100#1:777,3\n123#1:780\n123#1:781,2\n211#1:783\n211#1:784,2\n212#1:786\n212#1:787,3\n296#1:797\n296#1:798,2\n369#1:800\n369#1:801,2\n414#1:805,3\n432#1:808\n532#1:819\n532#1:820,2\n535#1:822,4\n543#1:826,2\n594#1:831,2\n700#1:833,2\n272#1:790\n272#1:791,6\n486#1:809\n486#1:810,6\n380#1:803,2\n518#1:816,3\n545#1:828,3\n*E\n"})
public final class CityStateFunctions {
    @NotNull
    private final Civilization civInfo;

    public CityStateFunctions(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.civInfo = civInfo;
    }

    @NotNull
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final boolean initCityState(@NotNull Ruleset ruleset, @NotNull String startingEra, @NotNull Collection<String> unusedMajorCivs) {
        block7: {
            Intrinsics.checkNotNullParameter(ruleset, "ruleset");
            Intrinsics.checkNotNullParameter(startingEra, "startingEra");
            Intrinsics.checkNotNullParameter(unusedMajorCivs, "unusedMajorCivs");
            v0 = ruleset.getTileResources().values();
            Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
            $this$filter$iv = v0;
            $i$f$filter = false;
            var7_7 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (TileResource)element$iv$iv;
                $i$a$-filter-CityStateFunctions$initCityState$allMercantileResources$1 = false;
                Intrinsics.checkNotNull(it);
                if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.CityStateOnlyResource, null, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                it = (TileResource)item$iv$iv /* !! */ ;
                var18_16 = destination$iv$iv;
                $i$a$-map-CityStateFunctions$initCityState$allMercantileResources$2 = false;
                var18_16.add(it.getName());
            }
            allMercantileResources = (List)destination$iv$iv;
            uniqueTypes = new HashSet<E>();
            v1 = ruleset.getNations().get(this.civInfo.getCivName());
            Intrinsics.checkNotNull(v1);
            nation = v1;
            v2 = ((Map)ruleset.getCityStateTypes()).get(nation.getCityStateType());
            Intrinsics.checkNotNull(v2);
            cityStateType = (CityStateType)v2;
            CollectionsKt.addAll((Collection)uniqueTypes, SequencesKt.mapNotNull(cityStateType.getFriendBonusUniqueMap().getAllUniques(), initCityState.1.INSTANCE));
            CollectionsKt.addAll((Collection)uniqueTypes, SequencesKt.mapNotNull(cityStateType.getAllyBonusUniqueMap().getAllUniques(), initCityState.2.INSTANCE));
            this.civInfo.setCityStatePersonality(ArraysKt.random(CityStatePersonality.values(), (Random)Random.Default));
            if (uniqueTypes.contains((Object)UniqueType.CityStateUniqueLuxury)) {
                this.civInfo.setCityStateResource((String)CollectionsKt.randomOrNull(allMercantileResources, Random.Default));
            }
            if (!uniqueTypes.contains((Object)UniqueType.CityStateMilitaryUnits)) break block7;
            v3 = ruleset.getUnits().values();
            Intrinsics.checkNotNullExpressionValue(v3, "<get-values>(...)");
            $this$filter$iv = v3;
            $i$f$filter = false;
            item$iv$iv /* !! */  = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (BaseUnit)element$iv$iv;
                $i$a$-filter-CityStateFunctions$initCityState$possibleUnits$1 = false;
                if (it.availableInEra(ruleset, startingEra) || it.getUniqueTo() == null || !CollectionsKt.contains((Iterable)unusedMajorCivs, it.getUniqueTo())) ** GOTO lbl-1000
                v4 = ruleset.getUnitTypes().get(it.getUnitType());
                Intrinsics.checkNotNull(v4);
                if (v4.isLandUnit() && (it.getStrength() > 0 || it.getRangedStrength() > 0)) {
                    v5 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = false;
                }
                if (!v5) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            possibleUnits = (List)destination$iv$iv;
            if (((Collection)possibleUnits).isEmpty() == false) {
                this.civInfo.setCityStateUniqueUnit(((BaseUnit)CollectionsKt.random(possibleUnits, Random.Default)).getName());
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void holdElections() {
        Civilization winner2;
        void $this$filterTo$iv$iv;
        this.civInfo.addFlag("TurnsTillCityStateElection", this.civInfo.getGameInfo().getRuleset().getModOptions().getConstants().getCityStateElectionTurns());
        City city2 = Civilization.getCapital$default(this.civInfo, false, 1, null);
        if (city2 == null) {
            return;
        }
        City capital = city2;
        Iterable $this$filter$iv = capital.getEspionage().getAllStationedSpies();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Spy it = (Spy)element$iv$iv;
            boolean bl = false;
            if (!(it.getAction() == SpyAction.RiggingElections)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List spies = (List)destination$iv$iv;
        if (spies.isEmpty()) {
            return;
        }
        List parties = CollectionsKt.toMutableList(spies);
        parties.add(null);
        float randomSeed = capital.getLocation().x * capital.getLocation().y + 123.0f * (float)this.civInfo.getGameInfo().getTurns();
        Spy spy = (Spy)CollectionExtensionsKt.randomWeighted(parties, RandomKt.Random((int)randomSeed), (Function1)new Function1<Spy, Float>(this){
            final /* synthetic */ CityStateFunctions this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Float invoke(@Nullable Spy it) {
                return Float.valueOf(CityStateFunctions.access$holdElections$getVotesFromSpy(this.this$0, it));
            }
        });
        Civilization civilization = winner2 = spy != null ? spy.getCivInfo() : null;
        if (winner2 != null) {
            Civilization civilization2;
            String string = this.civInfo.getAllyCiv();
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                civilization2 = this.civInfo.getGameInfo().getCivilization(it);
            } else {
                civilization2 = null;
            }
            Civilization allyCiv = civilization2;
            for (Civilization civ : SequencesKt.toList(this.civInfo.getKnownCivs())) {
                String[] stringArray;
                boolean bl;
                block14: {
                    float influence = Intrinsics.areEqual(civ, winner2) ? 20.0f : -5.0f;
                    DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(civ);
                    Intrinsics.checkNotNull(diplomacyManager);
                    diplomacyManager.addInfluence(influence);
                    if (Intrinsics.areEqual(civ, winner2)) {
                        String[] bl2 = new String[]{"OtherIcons/Spy"};
                        civ.addNotification("Your spy successfully rigged the election in [" + this.civInfo.getCivName() + "]!", capital.getLocation(), Notification.NotificationCategory.Espionage, bl2);
                        continue;
                    }
                    Iterable $this$any$iv = spies;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Spy it = (Spy)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual(it.getCivInfo(), civ)) continue;
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    stringArray = new String[]{"OtherIcons/Spy"};
                    civ.addNotification("Your spy lost the election in [" + this.civInfo.getCivName() + "] to [" + winner2.getCivName() + "]!", capital.getLocation(), Notification.NotificationCategory.Espionage, stringArray);
                    continue;
                }
                if (!Intrinsics.areEqual(civ, allyCiv)) continue;
                stringArray = new String[]{"OtherIcons/Spy"};
                allyCiv.addNotification("The election in [" + this.civInfo.getCivName() + "] were rigged by [" + winner2.getCivName() + "]!", capital.getLocation(), Notification.NotificationCategory.Espionage, stringArray);
            }
        } else {
            for (Spy spy2 : spies) {
                DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(spy2.getCivInfo());
                Intrinsics.checkNotNull(diplomacyManager);
                diplomacyManager.addInfluence(-5.0f);
                String[] stringArray = new String[]{"OtherIcons/Spy"};
                spy2.getCivInfo().addNotification("Your spy lost the election in [" + capital + "]!", capital.getLocation(), Notification.NotificationCategory.Espionage, stringArray);
            }
        }
    }

    public final int turnsForGreatPersonFromCityState() {
        return (int)((float)(37 + Random.Default.nextInt(7)) * this.civInfo.getGameInfo().getSpeed().getModifier());
    }

    /*
     * Unable to fully structure code
     */
    public final void giveGreatPersonToPatron(@NotNull Civilization receivingCiv) {
        Intrinsics.checkNotNullParameter(receivingCiv, "receivingCiv");
        v0 = this.civInfo.getGameInfo().getRuleset().getUnits().values();
        Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var5_5 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (BaseUnit)element$iv$iv;
            $i$a$-filter-CityStateFunctions$giveGreatPersonToPatron$giftableUnits$1 = false;
            if (!it.isGreatPerson()) ** GOTO lbl-1000
            Intrinsics.checkNotNull(it);
            if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.MayFoundReligion, null, 2, null)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (!v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        giftableUnits = (List)destination$iv$iv;
        if (giftableUnits.isEmpty()) {
            return;
        }
        v2 = CollectionsKt.random(giftableUnits, Random.Default);
        Intrinsics.checkNotNullExpressionValue(v2, "random(...)");
        giftedUnit = (BaseUnit)v2;
        v3 = NextTurnAutomation.INSTANCE.getClosestCities(receivingCiv, this.civInfo);
        if (v3 == null) {
            return;
        }
        cities = v3;
        v4 = UnitManager.placeUnitNearTile$default(receivingCiv.getUnits(), cities.getCity1().getLocation(), giftedUnit, null, 4, null);
        if (v4 == null) {
            return;
        }
        placedUnit = v4;
        var7_8 = new Vector2[]{placedUnit.getTile().getPosition(), cities.getCity2().getLocation()};
        locations = LocationAction.Companion.invoke((Vector2[])var7_8);
        var7_8 = new String[]{this.civInfo.getCivName(), giftedUnit.getName()};
        receivingCiv.addNotification('[' + this.civInfo.getCivName() + "] gave us a [" + giftedUnit.getName() + "] as a gift!", locations, Notification.NotificationCategory.Units, (String[])var7_8);
    }

    public final void giveMilitaryUnitToPatron(@NotNull Civilization receivingCiv) {
        Object[] objectArray;
        Object unique;
        Intrinsics.checkNotNullParameter(receivingCiv, "receivingCiv");
        NextTurnAutomation.CityDistance cityDistance = NextTurnAutomation.INSTANCE.getClosestCities(receivingCiv, this.civInfo);
        if (cityDistance == null) {
            return;
        }
        NextTurnAutomation.CityDistance cities = cityDistance;
        City city2 = cities.getCity1();
        BaseUnit baseUnit = CityStateFunctions.giveMilitaryUnitToPatron$giftableUniqueUnit(this, receivingCiv);
        if (baseUnit == null && (baseUnit = CityStateFunctions.giveMilitaryUnitToPatron$randomGiftableUnit(city2)) == null) {
            return;
        }
        BaseUnit militaryUnit = baseUnit;
        MapUnit mapUnit = receivingCiv.getUnits().placeUnitNearTile(city2.getLocation(), militaryUnit.getName());
        if (mapUnit == null) {
            return;
        }
        MapUnit placedUnit = mapUnit;
        City city3 = Civilization.getCapital$default(this.civInfo, false, 1, null);
        Intrinsics.checkNotNull(city3);
        militaryUnit.addConstructionBonuses(placedUnit, city3.getCityConstructions());
        Iterator iterator2 = Civilization.getMatchingUniques$default(receivingCiv, UniqueType.CityStateGiftedUnitsStartWithXp, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            unique = (Unique)iterator2.next();
            objectArray = placedUnit.getPromotions();
            objectArray.setXP(objectArray.getXP() + Integer.parseInt(((Unique)unique).getParams().get(0)));
        }
        unique = new MapUnitAction[]{new MapUnitAction(placedUnit)};
        Sequence unitAction2 = SequencesKt.sequenceOf(unique);
        objectArray = new Vector2[]{cities.getCity2().getLocation(), city2.getLocation()};
        Sequence<LocationAction> notificationActions2 = SequencesKt.plus(unitAction2, LocationAction.Companion.invoke((Vector2[])objectArray));
        objectArray = new String[]{this.civInfo.getCivName(), militaryUnit.getName()};
        receivingCiv.addNotification('[' + this.civInfo.getCivName() + "] gave us a [" + militaryUnit.getName() + "] as gift near [" + city2.getName() + "]!", notificationActions2, Notification.NotificationCategory.Units, (String[])objectArray);
    }

    public final int influenceGainedByGift(@NotNull Civilization donorCiv, int giftAmount) {
        Intrinsics.checkNotNullParameter(donorCiv, "donorCiv");
        float influenceGained = (float)Math.pow(giftAmount, 1.01f) / 9.8f;
        Speed speed = this.civInfo.getGameInfo().getSpeed();
        float gameProgressApproximate = Math.min((float)this.civInfo.getGameInfo().getTurns() / (400.0f * speed.getModifier()), 1.0f);
        influenceGained *= 1.0f - 0.6666667f * gameProgressApproximate;
        influenceGained *= speed.getGoldGiftModifier();
        Iterator iterator2 = Civilization.getMatchingUniques$default(donorCiv, UniqueType.CityStateGoldGiftsProvideMoreInfluence, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)iterator2.next();
            influenceGained *= 1.0f + Float.parseFloat(unique.getParams().get(0)) / 100.0f;
        }
        influenceGained *= this.civInfo.getQuestManager().getInvestmentMultiplier(donorCiv.getCivName());
        if ((influenceGained -= influenceGained % (float)5) < 5.0f) {
            influenceGained = 5.0f;
        }
        return (int)influenceGained;
    }

    public final void receiveGoldGift(@NotNull Civilization donorCiv, int giftAmount) {
        Intrinsics.checkNotNullParameter(donorCiv, "donorCiv");
        if (!this.civInfo.isCityState()) {
            throw new Exception("You can only gain influence with City-States!");
        }
        donorCiv.addGold(-giftAmount);
        this.civInfo.addGold(giftAmount);
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(donorCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        diplomacyManager.addInfluence(this.influenceGainedByGift(donorCiv, giftAmount));
        this.civInfo.getQuestManager().receivedGoldGift(donorCiv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Civilization> getProtectorCivs() {
        void $this$mapTo$iv$iv;
        DiplomacyManager it;
        Iterable $this$filterTo$iv$iv;
        if (this.civInfo.isMajorCiv()) {
            return CollectionsKt.emptyList();
        }
        Collection<DiplomacyManager> collection = this.civInfo.getDiplomacy().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DiplomacyManager)element$iv$iv;
            boolean bl = false;
            if (!(!it.otherCiv().isDefeated() && it.getDiplomaticStatus() == DiplomaticStatus.Protector)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (DiplomacyManager)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.otherCiv());
        }
        return (List)destination$iv$iv;
    }

    public final void addProtectorCiv(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (!this.otherCivCanPledgeProtection(otherCiv)) {
            return;
        }
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv.getCivName());
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diplomacy = diplomacyManager;
        diplomacy.setDiplomaticStatus(DiplomaticStatus.Protector);
        diplomacy.setFlag(DiplomacyFlags.RecentlyPledgedProtection, 10);
    }

    public final void removeProtectorCiv(@NotNull Civilization otherCiv, boolean forced) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (!forced && !this.otherCivCanWithdrawProtection(otherCiv)) {
            return;
        }
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diplomacy = diplomacyManager;
        diplomacy.setDiplomaticStatus(DiplomaticStatus.Peace);
        diplomacy.setFlag(DiplomacyFlags.RecentlyWithdrewProtection, 20);
        diplomacy.addInfluence(-20.0f);
    }

    public static /* synthetic */ void removeProtectorCiv$default(CityStateFunctions cityStateFunctions, Civilization civilization, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        cityStateFunctions.removeProtectorCiv(civilization, bl);
    }

    public final boolean otherCivCanPledgeProtection(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (!this.civInfo.isCityState() || !otherCiv.isMajorCiv() || otherCiv.isDefeated() || !this.civInfo.knows(otherCiv)) {
            return false;
        }
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diplomacy = diplomacyManager;
        if (diplomacy.hasFlag(DiplomacyFlags.RecentlyWithdrewProtection)) {
            return false;
        }
        if (diplomacy.getInfluence() < 0.0f) {
            return false;
        }
        if (this.civInfo.isAtWarWith(otherCiv)) {
            return false;
        }
        return diplomacy.getDiplomaticStatus() != DiplomaticStatus.Protector;
    }

    public final boolean otherCivCanWithdrawProtection(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (!this.civInfo.isCityState() || !otherCiv.isMajorCiv() || otherCiv.isDefeated() || !this.civInfo.knows(otherCiv)) {
            return false;
        }
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diplomacy = diplomacyManager;
        if (diplomacy.hasFlag(DiplomacyFlags.RecentlyPledgedProtection)) {
            return false;
        }
        return diplomacy.getDiplomaticStatus() == DiplomaticStatus.Protector;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateAllyCivForCityState() {
        Object object;
        Object v0;
        Iterator $this$filterTo$iv$iv;
        String newAllyName = null;
        if (!this.civInfo.isCityState()) {
            return;
        }
        Map $this$filter$iv = this.civInfo.getDiplomacy();
        boolean $i$f$filter22 = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(((DiplomacyManager)it.getValue()).otherCiv().isMajorCiv() && !((DiplomacyManager)it.getValue()).otherCiv().isDefeated())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Iterable $i$f$filter22 = destination$iv$iv.entrySet();
        $this$filterTo$iv$iv = $i$f$filter22.iterator();
        if (!$this$filterTo$iv$iv.hasNext()) {
            v0 = null;
        } else {
            object = $this$filterTo$iv$iv.next();
            if (!$this$filterTo$iv$iv.hasNext()) {
                v0 = object;
            } else {
                Map.Entry it22 = (Map.Entry)object;
                boolean bl2 = false;
                float it22 = ((DiplomacyManager)it22.getValue()).getInfluence();
                do {
                    Object bl2 = $this$filterTo$iv$iv.next();
                    Map.Entry it32 = (Map.Entry)bl2;
                    boolean $i$a$-maxByOrNull-CityStateFunctions$updateAllyCivForCityState$maxInfluence$3 = false;
                    float it32 = ((DiplomacyManager)it32.getValue()).getInfluence();
                    if (Float.compare(it22, it32) >= 0) continue;
                    object = bl2;
                    it22 = it32;
                } while ($this$filterTo$iv$iv.hasNext());
                v0 = object;
            }
        }
        Map.Entry maxInfluence = v0;
        if (maxInfluence != null && ((DiplomacyManager)maxInfluence.getValue()).getInfluence() >= 60.0f) {
            newAllyName = (String)maxInfluence.getKey();
        }
        if (!Intrinsics.areEqual(this.civInfo.getAllyCiv(), newAllyName)) {
            String text2;
            String oldAllyName = this.civInfo.getAllyCiv();
            this.civInfo.setAllyCiv(newAllyName);
            if (newAllyName != null) {
                void $this$filterTo$iv$iv2;
                Civilization newAllyCiv = this.civInfo.getGameInfo().getCivilization(newAllyName);
                text2 = "We have allied with [" + this.civInfo.getCivName() + "].";
                object = new String[]{this.civInfo.getCivName(), "OtherIcons/Diplomacy"};
                newAllyCiv.addNotification(text2, (Sequence<? extends NotificationAction>)this.getNotificationActions(), Notification.NotificationCategory.Diplomacy, (String)object);
                CivInfoTransientCache.updateViewableTiles$default(newAllyCiv.getCache(), null, 1, null);
                newAllyCiv.getCache().updateCivResources();
                object = Civilization.getMatchingUniques$default(newAllyCiv, UniqueType.CityStateCanBeBoughtForGold, null, 2, null).iterator();
                while (object.hasNext()) {
                    Unique unique = (Unique)object.next();
                    DiplomacyManager diplomacyManager = newAllyCiv.getDiplomacyManager(this.civInfo);
                    Intrinsics.checkNotNull(diplomacyManager);
                    diplomacyManager.setFlag(DiplomacyFlags.MarriageCooldown, Integer.parseInt(unique.getParams().get(0)));
                }
                Iterable $this$filter$iv2 = this.civInfo.getGameInfo().getCivilizations();
                boolean $i$f$filter = false;
                Iterable it32 = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    Civilization it = (Civilization)element$iv$iv;
                    boolean bl = false;
                    if (!(it.isAtWarWith(newAllyCiv) && it.isAlive())) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                for (Civilization newEnemy : (List)destination$iv$iv2) {
                    if (this.civInfo.isAtWarWith(newEnemy)) continue;
                    if (!this.civInfo.knows(newEnemy)) {
                        this.civInfo.getDiplomacyFunctions().makeCivilizationsMeet(newEnemy, true);
                    }
                    DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(newEnemy);
                    Intrinsics.checkNotNull(diplomacyManager);
                    diplomacyManager.declareWar(new DeclareWarReason(WarType.CityStateAllianceWar, newAllyCiv));
                }
            }
            if (oldAllyName != null && this.civInfo.isAlive()) {
                Civilization oldAllyCiv = this.civInfo.getGameInfo().getCivilization(oldAllyName);
                text2 = "We have lost alliance with [" + this.civInfo.getCivName() + "].";
                object = new String[]{this.civInfo.getCivName(), "OtherIcons/Diplomacy"};
                oldAllyCiv.addNotification(text2, (Sequence<? extends NotificationAction>)this.getNotificationActions(), Notification.NotificationCategory.Diplomacy, (String)object);
                CivInfoTransientCache.updateViewableTiles$default(oldAllyCiv.getCache(), null, 1, null);
                oldAllyCiv.getCache().updateCivResources();
            }
        }
    }

    @NotNull
    public final Sequence<NotificationAction> getNotificationActions() {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super NotificationAction>, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CityStateFunctions this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        capital = Civilization.getCapital$default(this.this$0.getCivInfo(), false, 1, null);
                        if (capital != null) {
                            this.L$0 = $this$sequence;
                            this.label = 1;
                            v0 = $this$sequence.yield(new LocationAction(capital.getLocation()), this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 2;
                        v1 = $this$sequence.yield(new DiplomacyAction(this.this$0.getCivInfo().getCivName(), false, 2, null), this);
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl27
                    }
                    case 2: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl27:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super NotificationAction>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super NotificationAction> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public final int getDiplomaticMarriageCost() {
        int cost = (int)((float)500 * this.civInfo.getGameInfo().getSpeed().getGoldCostModifier());
        Iterator<MapUnit> iterator2 = this.civInfo.getUnits().getCivUnits().iterator();
        while (iterator2.hasNext()) {
            MapUnit unit = iterator2.next();
            cost += unit.getBaseUnit().getDisbandGold(this.civInfo);
        }
        cost /= 5;
        return cost *= 5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canBeMarriedBy(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (this.civInfo.isDefeated()) return false;
        if (!this.civInfo.isCityState()) return false;
        if (!CollectionsKt.any((Iterable)this.civInfo.getCities())) return false;
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        if (!diplomacyManager.isRelationshipLevelEQ(RelationshipLevel.Ally)) return false;
        DiplomacyManager diplomacyManager2 = otherCiv.getDiplomacyManager(this.civInfo);
        Intrinsics.checkNotNull(diplomacyManager2);
        if (diplomacyManager2.hasFlag(DiplomacyFlags.MarriageCooldown)) return false;
        if (!SequencesKt.any(Civilization.getMatchingUniques$default(otherCiv, UniqueType.CityStateCanBeBoughtForGold, null, 2, null))) return false;
        if (otherCiv.getGold() < this.getDiplomaticMarriageCost()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void diplomaticMarriage(@NotNull Civilization otherCiv) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (!this.canBeMarriedBy(otherCiv)) {
            return;
        }
        otherCiv.addGold(-this.getDiplomaticMarriageCost());
        City city2 = Civilization.getCapital$default(this.civInfo, false, 1, null);
        Intrinsics.checkNotNull(city2);
        Vector2 notificationLocation = city2.getLocation();
        Object object = new String[]{this.civInfo.getCivName(), "OtherIcons/Diplomacy", otherCiv.getCivName()};
        otherCiv.addNotification("We have married into the ruling family of [" + this.civInfo.getCivName() + "], bringing them under our control.", notificationLocation, Notification.NotificationCategory.Diplomacy, (String[])object);
        Iterable $this$filter$iv = this.civInfo.getGameInfo().getCivilizations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it, otherCiv))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Civilization civ : (List)destination$iv$iv) {
            String[] stringArray = new String[]{this.civInfo.getCivName(), "OtherIcons/Diplomacy", otherCiv.getCivName()};
            civ.addNotification('[' + otherCiv.getCivName() + "] has married into the ruling family of [" + this.civInfo.getCivName() + "], bringing them under their control.", notificationLocation, Notification.NotificationCategory.Diplomacy, stringArray);
        }
        object = this.civInfo.getUnits().getCivUnits().iterator();
        while (object.hasNext()) {
            MapUnit unit = (MapUnit)object.next();
            unit.gift(otherCiv);
        }
        Sequence<City> $this$forEach$iv = SequencesKt.filter(this.civInfo.getGameInfo().getCities(), (Function1)new Function1<City, Boolean>(this){
            final /* synthetic */ CityStateFunctions this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull City it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getFoundingCiv(), this.this$0.getCivInfo().getCivName());
            }
        });
        boolean $i$f$forEach = false;
        Iterator<City> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            City element$iv;
            City it = element$iv = iterator2.next();
            boolean bl = false;
            it.setFoundingCiv("");
            it.setOriginalCapital(false);
        }
        for (City city3 : this.civInfo.getCities()) {
            city3.moveToCiv(otherCiv);
            city3.setPuppet(true);
        }
        this.civInfo.destroy(notificationLocation);
    }

    public final int getTributeWillingness(@NotNull Civilization demandingCiv, boolean demandingWorker) {
        Intrinsics.checkNotNullParameter(demandingCiv, "demandingCiv");
        Collection collection = CityStateFunctions.getTributeModifiers$default(this, demandingCiv, demandingWorker, false, 4, null).values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return CollectionsKt.sumOfInt(collection);
    }

    public static /* synthetic */ int getTributeWillingness$default(CityStateFunctions cityStateFunctions, Civilization civilization, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return cityStateFunctions.getTributeWillingness(civilization, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HashMap<String, Integer> getTributeModifiers(@NotNull Civilization demandingCiv, boolean demandingWorker, boolean requireWholeList) {
        int n;
        int n2;
        Tile tile;
        Object object;
        Sequence<Tile> inRangeTiles;
        Integer recentBullying;
        boolean bl;
        LinkedHashMap modifiers;
        block25: {
            Intrinsics.checkNotNullParameter(demandingCiv, "demandingCiv");
            modifiers = new LinkedHashMap();
            if (!this.civInfo.isCityState()) {
                ((Map)modifiers).put("Major Civ", -999);
                return modifiers;
            }
            if (this.civInfo.getCities().isEmpty() || Civilization.getCapital$default(this.civInfo, false, 1, null) == null) {
                ((Map)modifiers).put("No Cities", -999);
                return modifiers;
            }
            ((Map)modifiers).put("Base value", -110);
            if (this.civInfo.getCityStatePersonality() == CityStatePersonality.Hostile) {
                ((Map)modifiers).put("Hostile", -10);
            }
            if (this.civInfo.getAllyCiv() != null && !Intrinsics.areEqual(this.civInfo.getAllyCiv(), demandingCiv.getCivName())) {
                ((Map)modifiers).put("Has Ally", -10);
            }
            Iterable $this$any$iv = this.getProtectorCivs();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual(it, demandingCiv))) continue;
                    bl = true;
                    break block25;
                }
                bl = false;
            }
        }
        if (bl) {
            ((Map)modifiers).put("Has Protector", -20);
        }
        if (demandingWorker) {
            ((Map)modifiers).put("Demanding a Worker", -30);
        }
        if (demandingWorker) {
            City city2 = Civilization.getCapital$default(this.civInfo, false, 1, null);
            Intrinsics.checkNotNull(city2);
            if (city2.getPopulation().getPopulation() < 4) {
                ((Map)modifiers).put("Demanding a Worker from small City-State", -300);
            }
        }
        if ((recentBullying = this.civInfo.getRecentBullyingCountdown()) != null && recentBullying > 10) {
            ((Map)modifiers).put("Very recently paid tribute", -300);
        } else if (recentBullying != null && recentBullying > 0) {
            ((Map)modifiers).put("Recently paid tribute", -40);
        }
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(demandingCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        if (diplomacyManager.getInfluence() < -30.0f) {
            ((Map)modifiers).put("Influence below -30", -300);
        }
        if (!requireWholeList) {
            Collection collection = modifiers.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            if (CollectionsKt.sumOfInt(collection) < -200) {
                return modifiers;
            }
        }
        Iterable $this$sortedByDescending$iv = this.civInfo.getGameInfo().getAliveMajorCivs();
        boolean $i$f$sortedByDescending = false;
        int forceRank = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Civilization it = (Civilization)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getStatForRanking(RankingType.Force));
                it = (Civilization)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getStatForRanking(RankingType.Force));
            }
        }).indexOf(demandingCiv);
        ((Map)modifiers).put("Military Rank", 100 - 100 / this.civInfo.getGameInfo().getGameParameters().getPlayers().size() * forceRank);
        if (!requireWholeList) {
            Collection collection = modifiers.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            if (CollectionsKt.sumOfInt(collection) < -100) {
                return modifiers;
            }
        }
        int bullyRange = RangesKt.coerceIn(this.civInfo.getGameInfo().getTileMap().getTileMatrix().size() / 10, 5, 10);
        City city3 = Civilization.getCapital$default(this.civInfo, false, 1, null);
        Intrinsics.checkNotNull(city3);
        Sequence<Tile> bl2 = inRangeTiles = city3.getCenterTile().getTilesInDistanceRange(new IntRange(1, bullyRange));
        int n3 = 0;
        Iterator<Tile> iterator2 = bl2.iterator();
        while (iterator2.hasNext()) {
            int n4;
            void it;
            object = iterator2.next();
            tile = object;
            n2 = n3;
            boolean bl3 = false;
            MapUnit mapUnit = it.getMilitaryUnit();
            if (Intrinsics.areEqual(mapUnit != null ? mapUnit.getCiv() : null, demandingCiv)) {
                MapUnit mapUnit2 = it.getMilitaryUnit();
                Intrinsics.checkNotNull(mapUnit2);
                n4 = mapUnit2.getForceEvaluation();
            } else {
                n4 = 0;
            }
            n = n4;
            n3 = n2 + n;
        }
        int forceNearCity = n3;
        City city4 = Civilization.getCapital$default(this.civInfo, false, 1, null);
        Intrinsics.checkNotNull(city4);
        Sequence<Tile> sequence = inRangeTiles;
        n2 = (int)Math.pow(ICombatant.DefaultImpls.getDefendingStrength$default(new CityCombatant(city4), false, 1, null), 1.5f);
        int n5 = 0;
        object = sequence.iterator();
        while (object.hasNext()) {
            int n6;
            void it;
            Tile bl3 = tile = object.next();
            n = n5;
            boolean bl4 = false;
            MapUnit mapUnit = it.getMilitaryUnit();
            if (Intrinsics.areEqual(mapUnit != null ? mapUnit.getCiv() : null, this.civInfo)) {
                MapUnit mapUnit3 = it.getMilitaryUnit();
                Intrinsics.checkNotNull(mapUnit3);
                n6 = mapUnit3.getForceEvaluation();
            } else {
                n6 = 0;
            }
            int n7 = n6;
            n5 = n + n7;
        }
        n = n5;
        int csForce = n2 + n;
        float forceRatio = (float)forceNearCity / (float)csForce;
        ((Map)modifiers).put("Military near City-State", forceRatio > 3.0f ? 100 : (forceRatio > 2.0f ? 80 : (forceRatio > 1.5f ? 60 : (forceRatio > 1.0f ? 40 : (forceRatio > 0.5f ? 20 : 0)))));
        return modifiers;
    }

    public static /* synthetic */ HashMap getTributeModifiers$default(CityStateFunctions cityStateFunctions, Civilization civilization, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return cityStateFunctions.getTributeModifiers(civilization, bl, bl2);
    }

    public final int goldGainedByTribute() {
        int gold = (int)((float)10 * this.civInfo.getGameInfo().getSpeed().getGoldGiftModifier()) * 5;
        float turnsToIncrement = this.civInfo.getGameInfo().getSpeed().getCityStateTributeScalingInterval();
        return gold += 5 * (int)((float)this.civInfo.getGameInfo().getTurns() / turnsToIncrement);
    }

    public final void tributeGold(@NotNull Civilization demandingCiv) {
        Intrinsics.checkNotNullParameter(demandingCiv, "demandingCiv");
        if (!this.civInfo.isCityState()) {
            throw new Exception("You can only demand gold from City-States!");
        }
        int goldAmount = this.goldGainedByTribute();
        demandingCiv.addGold(goldAmount);
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(demandingCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        diplomacyManager.addInfluence(-15.0f);
        this.cityStateBullied(demandingCiv);
        this.civInfo.addFlag("RecentlyBullied", 20);
    }

    /*
     * WARNING - void declaration
     */
    public final void tributeWorker(@NotNull Civilization demandingCiv) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(demandingCiv, "demandingCiv");
        if (!this.civInfo.isCityState()) {
            throw new Exception("You can only demand workers from City-States!");
        }
        Map $this$filter$iv = this.civInfo.getGameInfo().getRuleset().getUnits();
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            boolean bl2 = IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it.getValue(), UniqueType.BuildImprovements, null, 2, null) && ((BaseUnit)it.getValue()).isCivilian() && ((BaseUnit)it.getValue()).isBuildable(this.civInfo);
            if (!bl2) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map buildableWorkerLikeUnits = destination$iv$iv;
        if (buildableWorkerLikeUnits.isEmpty()) {
            return;
        }
        UnitManager unitManager = demandingCiv.getUnits();
        City city2 = Civilization.getCapital$default(this.civInfo, false, 1, null);
        Intrinsics.checkNotNull(city2);
        UnitManager.placeUnitNearTile$default(unitManager, city2.getLocation(), (BaseUnit)CollectionsKt.random(buildableWorkerLikeUnits.values(), Random.Default), null, 4, null);
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(demandingCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        diplomacyManager.addInfluence(-50.0f);
        this.cityStateBullied(demandingCiv);
        this.civInfo.addFlag("RecentlyBullied", 20);
    }

    public final boolean canProvideStat(@NotNull Stat statType) {
        Intrinsics.checkNotNullParameter((Object)statType, "statType");
        if (!this.civInfo.isCityState()) {
            return false;
        }
        Iterator iterator2 = CityStateFunctions.getCityStateBonuses$default(this, this.civInfo.getCityStateType(), RelationshipLevel.Ally, null, 4, null).iterator();
        while (iterator2.hasNext()) {
            Unique bonus = (Unique)iterator2.next();
            if (!(bonus.getStats().get(statType) > 0.0f)) continue;
            return true;
        }
        return false;
    }

    public final void updateDiplomaticRelationshipForCityState() {
        if (this.getNumThreateningBarbarians() > 0) {
            return;
        }
        for (Civilization otherCiv : SequencesKt.toList(SequencesKt.filter(this.civInfo.getKnownCivs(), updateDiplomaticRelationshipForCityState.1.INSTANCE))) {
            DiplomacyManager diplomacy;
            if (this.civInfo.isAtWarWith(otherCiv) || Civilization.hasUnique$default(otherCiv, UniqueType.CityStateTerritoryAlwaysFriendly, null, 2, null)) continue;
            Intrinsics.checkNotNull(this.civInfo.getDiplomacyManager(otherCiv));
            if (diplomacy.hasFlag(DiplomacyFlags.AngerFreeIntrusion)) continue;
            Sequence<MapUnit> $this$count$iv = otherCiv.getUnits().getCivUnits();
            boolean $i$f$count = false;
            int count$iv = 0;
            Iterator<MapUnit> iterator2 = $this$count$iv.iterator();
            while (iterator2.hasNext()) {
                MapUnit element$iv;
                MapUnit it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(!it.isCivilian() && Intrinsics.areEqual(it.getTile().getOwner(), this.civInfo)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            int unitsInBorder = count$iv;
            if (unitsInBorder <= 0 || !diplomacy.isRelationshipLevelLT(RelationshipLevel.Friend)) continue;
            diplomacy.addInfluence(-10.0f);
            if (diplomacy.hasFlag(DiplomacyFlags.BorderConflict)) continue;
            otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.BorderConflict, this.civInfo.getCivName()));
            diplomacy.setFlag(DiplomacyFlags.BorderConflict, 10);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void getFreeTechForCityState() {
        void $this$filterTo$iv$iv;
        Set<String> set2 = this.civInfo.getGameInfo().getRuleset().getTechnologies().keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        Iterable $this$filter$iv = set2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            TechManager techManager = this.civInfo.getTech();
            Intrinsics.checkNotNull(it);
            if (!techManager.canBeResearched(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List researchableTechs2 = (List)destination$iv$iv;
        for (String tech : researchableTechs2) {
            int n;
            List<Civilization> aliveMajorCivs = this.civInfo.getGameInfo().getAliveMajorCivs();
            Iterable $this$count$iv = aliveMajorCivs;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl = false;
                    TechManager techManager = it.getTech();
                    Intrinsics.checkNotNull(tech);
                    if (!techManager.isResearched(tech) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if (n < aliveMajorCivs.size() / 2) continue;
            TechManager techManager = this.civInfo.getTech();
            Intrinsics.checkNotNull(tech);
            TechManager.addTechnology$default(techManager, tech, false, 2, null);
        }
    }

    public final int getNumThreateningBarbarians() {
        Object v0;
        IsPartOfGameInfoSerialization it;
        block4: {
            if (this.civInfo.getGameInfo().getGameParameters().getNoBarbarians()) {
                return 0;
            }
            Iterable $this$firstOrNull$iv = this.civInfo.getGameInfo().getCivilizations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (Civilization)element$iv;
                boolean bl = false;
                if (!((Civilization)it).isBarbarian()) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        Civilization civilization = v0;
        if (civilization == null) {
            return 0;
        }
        Civilization barbarianCiv = civilization;
        Sequence<MapUnit> $this$count$iv = barbarianCiv.getUnits().getCivUnits();
        boolean $i$f$count = false;
        int count$iv = 0;
        Iterator<Object> iterator2 = $this$count$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            element$iv = iterator2.next();
            it = (MapUnit)element$iv;
            boolean bl = false;
            if (!((MapUnit)it).threatensCiv(this.civInfo) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        return count$iv;
    }

    public final void threateningBarbarianKilledBy(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diplomacy = diplomacyManager;
        if (diplomacy.getDiplomaticStatus() == DiplomaticStatus.War) {
            return;
        }
        diplomacy.addInfluence(12.0f);
        if (diplomacy.hasFlag(DiplomacyFlags.AngerFreeIntrusion)) {
            diplomacy.setFlag(DiplomacyFlags.AngerFreeIntrusion, diplomacy.getFlag(DiplomacyFlags.AngerFreeIntrusion) + 5);
        } else {
            diplomacy.setFlag(DiplomacyFlags.AngerFreeIntrusion, 5);
        }
        String[] stringArray = new String[]{this.civInfo.getCivName()};
        otherCiv.addNotification('[' + this.civInfo.getCivName() + "] is grateful that you killed a Barbarian that was threatening them!", new DiplomacyAction(this.civInfo.getCivName(), false, 2, null), Notification.NotificationCategory.Diplomacy, stringArray);
    }

    private final void cityStateBullied(Civilization bully) {
        if (!this.civInfo.isCityState()) {
            return;
        }
        for (Civilization protector : this.civInfo.getCityStateFunctions().getProtectorCivs()) {
            DiplomacyManager protectorDiplomacy;
            if (!protector.knows(bully)) continue;
            Intrinsics.checkNotNull(protector.getDiplomacyManager(bully));
            if (protectorDiplomacy.hasModifier(DiplomaticModifiers.BulliedProtectedMinor) && protectorDiplomacy.getFlag(DiplomacyFlags.RememberBulliedProtectedMinor) > 50) {
                protectorDiplomacy.addModifier(DiplomaticModifiers.BulliedProtectedMinor, -10.0f);
            } else {
                protectorDiplomacy.addModifier(DiplomaticModifiers.BulliedProtectedMinor, -15.0f);
            }
            protectorDiplomacy.setFlag(DiplomacyFlags.RememberBulliedProtectedMinor, 75);
            if (protector.getPlayerType() != PlayerType.Human) {
                String[] stringArray = new String[]{"OtherIcons/Diplomacy", protector.getCivName()};
                bully.addNotification('[' + protector.getCivName() + "] is upset that you demanded tribute from [" + this.civInfo.getCivName() + "], whom they have pledged to protect!", Notification.NotificationCategory.Diplomacy, stringArray);
                continue;
            }
            protector.getPopupAlerts().add(new PopupAlert(AlertType.BulliedProtectedMinor, bully.getCivName() + '@' + this.civInfo.getCivName()));
        }
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(bully);
        Intrinsics.checkNotNull(diplomacyManager);
        diplomacyManager.setFlag(DiplomacyFlags.Bullied, 20);
        Iterable $this$forEach$iv = this.civInfo.getGameInfo().getAliveCityStates();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Civilization it = (Civilization)element$iv;
            boolean bl = false;
            it.getQuestManager().cityStateBullied(this.civInfo, bully);
        }
    }

    public final void cityStateAttacked(@NotNull Civilization attacker) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        if (!this.civInfo.isCityState()) {
            return;
        }
        if (attacker.isCityState()) {
            return;
        }
        if (attacker.isMinorCivWarmonger()) {
            DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(attacker);
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.becomeWary();
        } else if (attacker.isMinorCivAggressor() && Random.Default.nextBoolean()) {
            DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(attacker);
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.becomeWary();
        }
        if (attacker.isMinorCivAggressor()) {
            for (Civilization cityState : this.civInfo.getGameInfo().getAliveCityStates()) {
                if (Intrinsics.areEqual(cityState, this.civInfo) || Intrinsics.areEqual(cityState.getAllyCiv(), attacker.getCivName()) || !cityState.knows(attacker) || cityState.getQuestManager().wantsDead(this.civInfo.getCivName())) continue;
                int probability = 0;
                if (attacker.isMinorCivWarmonger()) {
                    int n;
                    switch (WhenMappings.$EnumSwitchMapping$0[cityState.getProximity(attacker).ordinal()]) {
                        case 1: {
                            n = 100;
                            break;
                        }
                        case 2: {
                            n = 75;
                            break;
                        }
                        case 3: {
                            n = 50;
                            break;
                        }
                        case 4: {
                            n = 25;
                            break;
                        }
                        default: {
                            n = 0;
                        }
                    }
                    probability = n;
                } else {
                    switch (WhenMappings.$EnumSwitchMapping$0[cityState.getProximity(attacker).ordinal()]) {
                        case 1: {
                            int n = 50;
                            break;
                        }
                        case 2: {
                            int n = 20;
                            break;
                        }
                        default: {
                            int n = probability = 0;
                        }
                    }
                }
                if (cityState.isAtWarWith(attacker)) {
                    probability += 50;
                }
                if (Random.Default.nextInt(100) > probability) continue;
                DiplomacyManager diplomacyManager = cityState.getDiplomacyManager(attacker);
                Intrinsics.checkNotNull(diplomacyManager);
                diplomacyManager.becomeWary();
            }
        }
        for (Civilization protector : this.civInfo.getCityStateFunctions().getProtectorCivs()) {
            DiplomacyManager protectorDiplomacy;
            if (protector.getDiplomacyManager(attacker) == null) continue;
            if (protectorDiplomacy.hasModifier(DiplomaticModifiers.AttackedProtectedMinor) && protectorDiplomacy.getFlag(DiplomacyFlags.RememberAttackedProtectedMinor) > 50) {
                protectorDiplomacy.addModifier(DiplomaticModifiers.AttackedProtectedMinor, -15.0f);
            } else {
                protectorDiplomacy.addModifier(DiplomaticModifiers.AttackedProtectedMinor, -20.0f);
            }
            protectorDiplomacy.setFlag(DiplomacyFlags.RememberAttackedProtectedMinor, 75);
            if (protector.getPlayerType() != PlayerType.Human) {
                String[] stringArray = new String[]{"OtherIcons/Diplomacy", protector.getCivName()};
                attacker.addNotification('[' + protector.getCivName() + "] is upset that you attacked [" + this.civInfo.getCivName() + "], whom they have pledged to protect!", Notification.NotificationCategory.Diplomacy, stringArray);
                continue;
            }
            protector.getPopupAlerts().add(new PopupAlert(AlertType.AttackedProtectedMinor, attacker.getCivName() + '@' + this.civInfo.getCivName()));
        }
        this.civInfo.getQuestManager().wasAttackedBy(attacker);
        DiplomacyManager diplomacyManager = this.civInfo.getDiplomacyManager(attacker);
        Intrinsics.checkNotNull(diplomacyManager);
        diplomacyManager.setFlag(DiplomacyFlags.RecentlyAttacked, 2);
    }

    public final void cityStateDestroyed(@NotNull Civilization attacker) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        if (!this.civInfo.isCityState()) {
            return;
        }
        for (Civilization protector : this.civInfo.getCityStateFunctions().getProtectorCivs()) {
            String[] stringArray;
            DiplomacyManager protectorDiplomacy;
            if (!protector.knows(attacker)) continue;
            Intrinsics.checkNotNull(protector.getDiplomacyManager(attacker));
            if (protectorDiplomacy.hasModifier(DiplomaticModifiers.DestroyedProtectedMinor)) {
                protectorDiplomacy.addModifier(DiplomaticModifiers.DestroyedProtectedMinor, -10.0f);
            } else {
                protectorDiplomacy.addModifier(DiplomaticModifiers.DestroyedProtectedMinor, -40.0f);
            }
            protectorDiplomacy.setFlag(DiplomacyFlags.RememberDestroyedProtectedMinor, 125);
            if (protector.getPlayerType() != PlayerType.Human) {
                stringArray = new String[]{"OtherIcons/Diplomacy", protector.getCivName()};
                attacker.addNotification('[' + protector.getCivName() + "] is outraged that you destroyed [" + this.civInfo.getCivName() + "], whom they had pledged to protect!", Notification.NotificationCategory.Diplomacy, stringArray);
            }
            stringArray = new String[]{attacker.getCivName(), "OtherIcons/DisbandUnit", this.civInfo.getCivName()};
            protector.addNotification('[' + attacker.getCivName() + "] has destroyed [" + this.civInfo.getCivName() + "], whom you had pledged to protect!", Notification.NotificationCategory.Diplomacy, stringArray);
        }
        Iterable $this$forEach$iv = this.civInfo.getGameInfo().getAliveCityStates();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Civilization it = (Civilization)element$iv;
            boolean bl = false;
            it.getQuestManager().cityStateConquered(this.civInfo, attacker);
        }
    }

    public final void askForUnitGifts(@NotNull Civilization attacker) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        if (attacker.isDefeated() || this.civInfo.isDefeated()) {
            return;
        }
        if (this.civInfo.getCities().isEmpty()) {
            return;
        }
        Iterator<Civilization> iterator2 = SequencesKt.filter(this.civInfo.getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(attacker){
            final /* synthetic */ Civilization $attacker;
            {
                this.$attacker = $attacker;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return !Intrinsics.areEqual(it, this.$attacker) && it.isAlive() && it.knows(this.$attacker) && !it.isAtWarWith(this.$attacker) && it.isMajorCiv();
            }
        }).iterator();
        while (iterator2.hasNext()) {
            Civilization thirdCiv = iterator2.next();
            String string = '[' + this.civInfo.getCivName() + "] is being attacked by [" + attacker.getCivName() + "] and asks all major civilizations to help them out by gifting them military units.";
            City city2 = Civilization.getCapital$default(this.civInfo, false, 1, null);
            Intrinsics.checkNotNull(city2);
            String[] stringArray = new String[]{this.civInfo.getCivName(), "OtherIcons/Present"};
            thirdCiv.addNotification(string, city2.getLocation(), Notification.NotificationCategory.Diplomacy, stringArray);
        }
    }

    @NotNull
    public final ResourceSupplyList getCityStateResourcesForAlly() {
        ResourceSupplyList resourceSupplyList;
        ResourceSupplyList $this$getCityStateResourcesForAlly_u24lambda_u2426 = resourceSupplyList = new ResourceSupplyList(false, 1, null);
        boolean bl = false;
        HashMap<String, Float> civResourceModifiers = this.civInfo.getResourceModifiers();
        for (City city2 : this.civInfo.getCities()) {
            $this$getCityStateResourcesForAlly_u24lambda_u2426.addPositiveByResource(city2.getResourcesGeneratedByCity(civResourceModifiers), "City-States");
        }
        return resourceSupplyList;
    }

    @NotNull
    public final Sequence<Unique> getUniquesProvidedByCityStates(@NotNull UniqueType uniqueType, @NotNull StateForConditionals stateForConditionals) {
        Intrinsics.checkNotNullParameter((Object)uniqueType, "uniqueType");
        Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
        if (this.civInfo.isCityState()) {
            return SequencesKt.emptySequence();
        }
        return SequencesKt.filter(SequencesKt.flatMap(SequencesKt.filter(this.civInfo.getKnownCivs(), getUniquesProvidedByCityStates.1.INSTANCE), (Function1)new Function1<Civilization, Sequence<? extends Unique>>(this, uniqueType){
            final /* synthetic */ CityStateFunctions this$0;
            final /* synthetic */ UniqueType $uniqueType;
            {
                this.this$0 = $receiver;
                this.$uniqueType = $uniqueType;
                super(1);
            }

            @NotNull
            public final Sequence<Unique> invoke(@NotNull Civilization it) {
                RelationshipLevel relationshipLevel;
                Intrinsics.checkNotNullParameter(it, "it");
                if (Intrinsics.areEqual(it.getAllyCiv(), this.this$0.getCivInfo().getCivName())) {
                    relationshipLevel = RelationshipLevel.Ally;
                } else {
                    DiplomacyManager diplomacyManager = it.getDiplomacyManager(this.this$0.getCivInfo());
                    Intrinsics.checkNotNull(diplomacyManager);
                    relationshipLevel = diplomacyManager.getInfluence() >= 30.0f ? RelationshipLevel.Friend : RelationshipLevel.Neutral;
                }
                RelationshipLevel relationshipLevel2 = relationshipLevel;
                return this.this$0.getCityStateBonuses(it.getCityStateType(), relationshipLevel2, this.$uniqueType);
            }
        }), (Function1)new Function1<Unique, Boolean>(stateForConditionals){
            final /* synthetic */ StateForConditionals $stateForConditionals;
            {
                this.$stateForConditionals = $stateForConditionals;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Unique it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.conditionalsApply(this.$stateForConditionals);
            }
        });
    }

    @NotNull
    public final Sequence<Unique> getCityStateBonuses(@NotNull CityStateType cityStateType2, @NotNull RelationshipLevel relationshipLevel, @Nullable UniqueType uniqueType) {
        UniqueMap uniqueMap2;
        Intrinsics.checkNotNullParameter(cityStateType2, "cityStateType");
        Intrinsics.checkNotNullParameter((Object)relationshipLevel, "relationshipLevel");
        switch (WhenMappings.$EnumSwitchMapping$1[relationshipLevel.ordinal()]) {
            case 1: {
                uniqueMap2 = cityStateType2.getAllyBonusUniqueMap();
                break;
            }
            case 2: {
                uniqueMap2 = cityStateType2.getFriendBonusUniqueMap();
                break;
            }
            default: {
                return SequencesKt.emptySequence();
            }
        }
        UniqueMap cityStateUniqueMap = uniqueMap2;
        return uniqueType == null ? cityStateUniqueMap.getAllUniques() : cityStateUniqueMap.getUniques(uniqueType);
    }

    public static /* synthetic */ Sequence getCityStateBonuses$default(CityStateFunctions cityStateFunctions, CityStateType cityStateType2, RelationshipLevel relationshipLevel, UniqueType uniqueType, int n, Object object) {
        if ((n & 4) != 0) {
            uniqueType = null;
        }
        return cityStateFunctions.getCityStateBonuses(cityStateType2, relationshipLevel, uniqueType);
    }

    private static final float holdElections$getVotesFromSpy(CityStateFunctions this$0, Spy spy) {
        if (spy == null) {
            return 20.0f;
        }
        float votes = this$0.civInfo.getDiplomacyManagerOrMeet(spy.getCivInfo()).getInfluence$core() / (float)2;
        return votes += (float)((double)spy.getSkillModifierPercent() * spy.getEfficiencyModifier());
    }

    private static final BaseUnit giveMilitaryUnitToPatron$giftableUniqueUnit(CityStateFunctions this$0, Civilization $receivingCiv) {
        BaseUnit baseUnit = (BaseUnit)((Map)this$0.civInfo.getGameInfo().getRuleset().getUnits()).get(this$0.civInfo.getCityStateUniqueUnit());
        if (baseUnit == null) {
            return null;
        }
        BaseUnit uniqueUnit = baseUnit;
        if (!$receivingCiv.getTech().isResearched(uniqueUnit)) {
            return null;
        }
        if ($receivingCiv.getTech().isObsolete(uniqueUnit)) {
            return null;
        }
        return uniqueUnit;
    }

    private static final BaseUnit giveMilitaryUnitToPatron$randomGiftableUnit(City city2) {
        return (BaseUnit)CollectionsKt.randomOrNull((Collection)SequencesKt.toList(SequencesKt.filter(city2.getCityConstructions().getConstructableUnits(), giveMilitaryUnitToPatron.randomGiftableUnit.1.INSTANCE)), Random.Default);
    }

    public static final /* synthetic */ float access$holdElections$getVotesFromSpy(CityStateFunctions this$0, Spy spy) {
        return CityStateFunctions.holdElections$getVotesFromSpy(this$0, spy);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Proximity.values().length];
            try {
                nArray[Proximity.Neighbors.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Proximity.Close.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Proximity.Far.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Proximity.Distant.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RelationshipLevel.values().length];
            try {
                nArray[RelationshipLevel.Ally.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Friend.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

