/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.diplomacy;

import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.DiplomacyAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.diplomacy.DeclareWarReason;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.civilization.diplomacy.WarType;
import com.unciv.logic.trade.Trade;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeRequest;
import com.unciv.models.ruleset.nation.PersonalityValue;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001d\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\rJ\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/unciv/logic/civilization/diplomacy/DeclareWar;", "", "()V", "breakTreaties", "", "diplomacyManager", "Lcom/unciv/logic/civilization/diplomacy/DiplomacyManager;", "callInCityStateAllies", "callInDefensivePactAllies", "changeOpinions", "declareWarReason", "Lcom/unciv/logic/civilization/diplomacy/DeclareWarReason;", "declareWar", "declareWar$core", "handleCityStateDirectAttack", "notifyOfWar", "onWarDeclared", "isOffensiveWar", "", "removeDefensivePacts", "core"})
@SourceDebugExtension(value={"SMAP\nDeclareWar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclareWar.kt\ncom/unciv/logic/civilization/diplomacy/DeclareWar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,347:1\n1855#2,2:348\n819#2:350\n847#2,2:351\n1855#2,2:353\n819#2:355\n847#2,2:356\n1855#2,2:358\n766#2:360\n857#2,2:361\n288#2:363\n1747#2,3:364\n289#2:367\n288#2:368\n1747#2,3:369\n289#2:372\n766#2:373\n857#2,2:374\n*S KotlinDebug\n*F\n+ 1 DeclareWar.kt\ncom/unciv/logic/civilization/diplomacy/DeclareWar\n*L\n78#1:348,2\n95#1:350\n95#1:351,2\n95#1:353,2\n120#1:355\n120#1:356,2\n120#1:358,2\n132#1:360\n132#1:361,2\n271#1:363\n271#1:364,3\n271#1:367\n274#1:368\n274#1:369,3\n274#1:372\n300#1:373\n300#1:374,2\n*E\n"})
public final class DeclareWar {
    @NotNull
    public static final DeclareWar INSTANCE = new DeclareWar();

    private DeclareWar() {
    }

    public final void declareWar$core(@NotNull DiplomacyManager diplomacyManager, @NotNull DeclareWarReason declareWarReason) {
        Intrinsics.checkNotNullParameter(diplomacyManager, "diplomacyManager");
        Intrinsics.checkNotNullParameter(declareWarReason, "declareWarReason");
        Civilization civInfo = diplomacyManager.getCivInfo();
        Civilization otherCiv = diplomacyManager.otherCiv();
        DiplomacyManager otherCivDiplomacy = diplomacyManager.otherCivDiplomacy();
        if (otherCiv.isCityState() && declareWarReason.getWarType() == WarType.DirectWar) {
            this.handleCityStateDirectAttack(diplomacyManager);
        }
        this.notifyOfWar(diplomacyManager, declareWarReason);
        this.onWarDeclared(diplomacyManager, true);
        this.onWarDeclared(otherCivDiplomacy, false);
        this.changeOpinions(diplomacyManager, declareWarReason);
        this.breakTreaties(diplomacyManager);
        if (otherCiv.isMajorCiv()) {
            for (Unique unique : Civilization.getTriggeredUniques$default(civInfo, UniqueType.TriggerUponDeclaringWar, null, 2, null)) {
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, civInfo, null, null, null, null, null, 124, null);
            }
        }
    }

    private final void handleCityStateDirectAttack(DiplomacyManager diplomacyManager) {
        Civilization civInfo = diplomacyManager.getCivInfo();
        Civilization otherCiv = diplomacyManager.otherCiv();
        DiplomacyManager otherCivDiplomacy = diplomacyManager.otherCivDiplomacy();
        otherCivDiplomacy.setInfluence(-60.0f);
        civInfo.setNumMinorCivsAttacked$core(civInfo.getNumMinorCivsAttacked$core() + 1);
        otherCiv.getCityStateFunctions().cityStateAttacked(civInfo);
        if (Intrinsics.areEqual(otherCiv.getAllyCiv(), civInfo.getCivName())) {
            otherCiv.getCityStateFunctions().updateAllyCivForCityState();
            otherCivDiplomacy.setInfluence(-120.0f);
            Iterator<Civilization> iterator2 = civInfo.getKnownCivs().iterator();
            while (iterator2.hasNext()) {
                Civilization knownCiv = iterator2.next();
                DiplomacyManager diplomacyManager2 = knownCiv.getDiplomacyManager(civInfo);
                Intrinsics.checkNotNull(diplomacyManager2);
                diplomacyManager2.addModifier(DiplomaticModifiers.BetrayedDeclarationOfFriendship, -10.0f);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void notifyOfWar(DiplomacyManager diplomacyManager, DeclareWarReason declareWarReason) {
        Civilization civInfo = diplomacyManager.getCivInfo();
        Civilization otherCiv = diplomacyManager.otherCiv();
        switch (WhenMappings.$EnumSwitchMapping$0[declareWarReason.getWarType().ordinal()]) {
            case 1: {
                otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.WarDeclaration, civInfo.getCivName()));
                String[] stringArray = new String[]{otherCiv.getCivName(), "OtherIcons/Pillage", civInfo.getCivName()};
                otherCiv.addNotification('[' + civInfo.getCivName() + "] has declared war on us!", Notification.NotificationCategory.Diplomacy, stringArray);
                Iterable $this$forEach$iv = diplomacyManager.getCommonKnownCivsWithSpectators();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl = false;
                    String[] stringArray2 = new String[]{otherCiv.getCivName(), "OtherIcons/Pillage", civInfo.getCivName()};
                    it.addNotification('[' + civInfo.getCivName() + "] has declared war on [" + otherCiv.getCivName() + "]!", Notification.NotificationCategory.Diplomacy, stringArray2);
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                String[] $this$forEach$iv2;
                Object element$iv$iv;
                Iterator $this$filterNotTo$iv$iv;
                Civilization civilization = declareWarReason.getAllyCiv();
                Intrinsics.checkNotNull(civilization);
                Civilization allyCiv = civilization;
                otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.WarDeclaration, civInfo.getCivName()));
                Civilization agressor = declareWarReason.getWarType() == WarType.DefensivePactWar ? otherCiv : civInfo;
                Civilization defender = declareWarReason.getWarType() == WarType.DefensivePactWar ? civInfo : otherCiv;
                String[] element$iv = new String[]{defender.getCivName(), "OtherIcons/Pillage", allyCiv.getCivName(), agressor.getCivName()};
                defender.addNotification('[' + agressor.getCivName() + "] has joined [" + allyCiv.getCivName() + "] in the war against us!", Notification.NotificationCategory.Diplomacy, element$iv);
                element$iv = new String[]{defender.getCivName(), "OtherIcons/Pillage", allyCiv.getCivName(), agressor.getCivName()};
                agressor.addNotification("We have joined [" + allyCiv.getCivName() + "] in the war against [" + defender.getCivName() + "]!", Notification.NotificationCategory.Diplomacy, element$iv);
                Iterable $this$filterNot$iv = diplomacyManager.getCommonKnownCivsWithSpectators();
                boolean $i$f$filterNot = false;
                Iterable bl = $this$filterNot$iv;
                Collection collection = new ArrayList();
                boolean $i$f$filterNotTo = false;
                Iterator iterator2 = $this$filterNotTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv$iv = iterator2.next();
                    Civilization it = (Civilization)element$iv$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual(it, allyCiv)) continue;
                    collection.add(element$iv$iv);
                }
                $this$filterNot$iv = (List)collection;
                boolean $i$f$forEach = false;
                for (Object t : $this$forEach$iv2) {
                    Civilization it = (Civilization)t;
                    boolean bl3 = false;
                    element$iv$iv = new String[]{defender.getCivName(), "OtherIcons/Pillage", allyCiv.getCivName(), agressor.getCivName()};
                    it.addNotification('[' + agressor.getCivName() + "] has joined [" + allyCiv.getCivName() + "] in the war against [" + defender.getCivName() + "]!", Notification.NotificationCategory.Diplomacy, (String)element$iv$iv);
                }
                $this$forEach$iv2 = new String[]{defender.getCivName(), "OtherIcons/Pillage", allyCiv.getCivName(), agressor.getCivName()};
                allyCiv.addNotification('[' + agressor.getCivName() + "] has joined us in the war against [" + defender.getCivName() + "]!", Notification.NotificationCategory.Diplomacy, $this$forEach$iv2);
                break;
            }
            case 5: {
                void $this$forEach$iv;
                void $this$filterNotTo$iv$iv;
                Civilization civilization = declareWarReason.getAllyCiv();
                Intrinsics.checkNotNull(civilization);
                Civilization allyCiv = civilization;
                if (civInfo.getGameInfo().getCivilizations().indexOf(civInfo) > civInfo.getGameInfo().getCivilizations().indexOf(allyCiv)) {
                    return;
                }
                otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.WarDeclaration, civInfo.getCivName()));
                otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.WarDeclaration, allyCiv.getCivName()));
                String[] agressor = new String[]{otherCiv.getCivName(), "OtherIcons/Pillage", allyCiv.getCivName(), civInfo.getCivName()};
                civInfo.addNotification("You and [" + allyCiv.getCivName() + "] have declared war against [" + otherCiv.getCivName() + "]!", Notification.NotificationCategory.Diplomacy, agressor);
                agressor = new String[]{otherCiv.getCivName(), "OtherIcons/Pillage", civInfo.getCivName(), allyCiv.getCivName()};
                allyCiv.addNotification("You and [" + civInfo.getCivName() + "] have declared war against [" + otherCiv.getCivName() + "]!", Notification.NotificationCategory.Diplomacy, agressor);
                agressor = new String[]{otherCiv.getCivName(), "OtherIcons/Pillage", allyCiv.getCivName(), civInfo.getCivName()};
                otherCiv.addNotification('[' + civInfo.getCivName() + "] and [" + allyCiv.getCivName() + "] have declared war against us!", Notification.NotificationCategory.Diplomacy, agressor);
                Iterable $this$filterNot$iv = diplomacyManager.getCommonKnownCivsWithSpectators();
                boolean $i$f$filterNot = false;
                Iterable $this$forEach$iv2 = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    Civilization it = (Civilization)element$iv$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual(it, allyCiv)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterNot$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl = false;
                    String[] stringArray = new String[]{otherCiv.getCivName(), "OtherIcons/Pillage", allyCiv.getCivName(), civInfo.getCivName()};
                    it.addNotification('[' + civInfo.getCivName() + "] and [" + allyCiv.getCivName() + "] have declared war against [" + otherCiv.getCivName() + "]!", Notification.NotificationCategory.Diplomacy, stringArray);
                }
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void onWarDeclared(DiplomacyManager diplomacyManager, boolean isOffensiveWar) {
        for (Trade trade : diplomacyManager.getTrades()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = trade.getTheirOffers();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TradeOffer it = (TradeOffer)element$iv$iv;
                boolean bl = false;
                if (!(it.getDuration() > 0 && !Intrinsics.areEqual(it.getName(), "Defensive Pact"))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (TradeOffer offer : (List)destination$iv$iv) {
                String[] stringArray = new String[]{diplomacyManager.getOtherCivName(), "StatIcons/Acquire"};
                diplomacyManager.getCivInfo().addNotification('[' + offer.getName() + "] from [" + diplomacyManager.getOtherCivName() + "] has ended", new DiplomacyAction(diplomacyManager.getOtherCivName(), true), Notification.NotificationCategory.Trade, stringArray);
            }
        }
        diplomacyManager.getTrades().clear();
        CollectionsKt.removeAll((List)diplomacyManager.getCivInfo().getTradeRequests(), (Function1)new Function1<TradeRequest, Boolean>(diplomacyManager){
            final /* synthetic */ DiplomacyManager $diplomacyManager;
            {
                this.$diplomacyManager = $diplomacyManager;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TradeRequest it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getRequestingCiv(), this.$diplomacyManager.getOtherCivName());
            }
        });
        diplomacyManager.updateHasOpenBorders();
        Civilization civAtWarWith = diplomacyManager.otherCiv();
        if (isOffensiveWar) {
            this.removeDefensivePacts(diplomacyManager);
        }
        diplomacyManager.setDiplomaticStatus(DiplomaticStatus.War);
        if (diplomacyManager.getCivInfo().isMajorCiv()) {
            if (!isOffensiveWar && !civAtWarWith.isCityState()) {
                this.callInDefensivePactAllies(diplomacyManager);
            }
            this.callInCityStateAllies(diplomacyManager);
        }
        if (diplomacyManager.getCivInfo().isCityState() && diplomacyManager.getCivInfo().getCityStateFunctions().getProtectorCivs().contains(civAtWarWith)) {
            diplomacyManager.getCivInfo().getCityStateFunctions().removeProtectorCiv(civAtWarWith, true);
        }
        diplomacyManager.removeModifier$core(DiplomaticModifiers.YearsOfPeace);
        diplomacyManager.setFlag(DiplomacyFlags.DeclinedPeace, diplomacyManager.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants().getMinimumWarDuration());
        diplomacyManager.setFlag(DiplomacyFlags.DeclaredWar, diplomacyManager.getCivInfo().getGameInfo().getRuleset().getModOptions().getConstants().getMinimumWarDuration());
        diplomacyManager.removeFlag(DiplomacyFlags.BorderConflict);
    }

    private final void changeOpinions(DiplomacyManager diplomacyManager, DeclareWarReason declareWarReason) {
        Civilization civInfo = diplomacyManager.getCivInfo();
        Civilization otherCiv = diplomacyManager.otherCiv();
        DiplomacyManager otherCivDiplomacy = diplomacyManager.otherCivDiplomacy();
        WarType warType = declareWarReason.getWarType();
        otherCivDiplomacy.setModifier(DiplomaticModifiers.DeclaredWarOnUs, -20.0f);
        otherCivDiplomacy.removeModifier$core(DiplomaticModifiers.ReturnedCapturedUnits);
        if (warType == WarType.DirectWar || warType == WarType.JoinWar || warType == WarType.TeamWar) {
            Iterator<Civilization> iterator2 = civInfo.getKnownCivs().iterator();
            while (iterator2.hasNext()) {
                Civilization thirdCiv = iterator2.next();
                if (thirdCiv.isAtWarWith(otherCiv)) continue;
                DiplomacyManager diplomacyManager2 = thirdCiv.getDiplomacyManager(otherCiv);
                if ((diplomacyManager2 != null ? !diplomacyManager2.isRelationshipLevelGT(RelationshipLevel.Competitor) : false) || Intrinsics.areEqual(thirdCiv, declareWarReason.getAllyCiv())) continue;
                DiplomacyManager diplomacyManager3 = thirdCiv.getDiplomacyManager(civInfo);
                Intrinsics.checkNotNull(diplomacyManager3);
                diplomacyManager3.addModifier(DiplomaticModifiers.WarMongerer, -5.0f);
            }
        }
        for (Civilization thirdCiv : diplomacyManager.getCommonKnownCivs()) {
            if ((thirdCiv.isAtWarWith(otherCiv) || Intrinsics.areEqual(thirdCiv, declareWarReason.getAllyCiv())) && !thirdCiv.isAtWarWith(civInfo)) {
                if (thirdCiv.isCityState()) {
                    DiplomacyManager diplomacyManager4 = thirdCiv.getDiplomacyManager(civInfo);
                    Intrinsics.checkNotNull(diplomacyManager4);
                    diplomacyManager4.addInfluence(10.0f);
                    continue;
                }
                DiplomacyManager diplomacyManager5 = thirdCiv.getDiplomacyManager(civInfo);
                Intrinsics.checkNotNull(diplomacyManager5);
                diplomacyManager5.addModifier(DiplomaticModifiers.SharedEnemy, 5.0f * civInfo.getPersonality().modifierFocus(PersonalityValue.Loyal, 0.3f));
                continue;
            }
            if (!thirdCiv.isAtWarWith(civInfo)) continue;
            if (thirdCiv.isCityState()) {
                DiplomacyManager diplomacyManager6 = thirdCiv.getDiplomacyManager(otherCiv);
                Intrinsics.checkNotNull(diplomacyManager6);
                diplomacyManager6.addInfluence(10.0f);
                continue;
            }
            DiplomacyManager diplomacyManager7 = thirdCiv.getDiplomacyManager(otherCiv);
            Intrinsics.checkNotNull(diplomacyManager7);
            diplomacyManager7.addModifier(DiplomaticModifiers.SharedEnemy, 5.0f * civInfo.getPersonality().modifierFocus(PersonalityValue.Loyal, 0.3f));
        }
    }

    private final void breakTreaties(DiplomacyManager diplomacyManager) {
        Civilization otherCiv = diplomacyManager.otherCiv();
        DiplomacyManager otherCivDiplomacy = diplomacyManager.otherCivDiplomacy();
        boolean betrayedFriendship = false;
        boolean betrayedDefensivePact = false;
        if (diplomacyManager.hasFlag(DiplomacyFlags.DeclarationOfFriendship)) {
            betrayedFriendship = true;
            diplomacyManager.removeFlag(DiplomacyFlags.DeclarationOfFriendship);
            otherCivDiplomacy.removeModifier$core(DiplomaticModifiers.DeclarationOfFriendship);
        }
        otherCivDiplomacy.removeFlag(DiplomacyFlags.DeclarationOfFriendship);
        if (diplomacyManager.hasFlag(DiplomacyFlags.DefensivePact)) {
            betrayedDefensivePact = true;
            diplomacyManager.removeFlag(DiplomacyFlags.DefensivePact);
            otherCivDiplomacy.removeModifier$core(DiplomaticModifiers.DefensivePact);
        }
        otherCivDiplomacy.removeFlag(DiplomacyFlags.DefensivePact);
        if (betrayedFriendship || betrayedDefensivePact) {
            Iterator<Civilization> iterator2 = diplomacyManager.getCivInfo().getKnownCivs().iterator();
            while (iterator2.hasNext()) {
                DiplomacyManager diploManager;
                float amount;
                Civilization knownCiv = iterator2.next();
                Intrinsics.checkNotNull(knownCiv.getDiplomacyManager(diplomacyManager.getCivInfo()));
                if (betrayedFriendship) {
                    amount = Intrinsics.areEqual(knownCiv, otherCiv) ? -40.0f : -20.0f;
                    diploManager.addModifier(DiplomaticModifiers.BetrayedDeclarationOfFriendship, amount * knownCiv.getPersonality().modifierFocus(PersonalityValue.Loyal, 0.3f));
                }
                if (betrayedDefensivePact) {
                    amount = Intrinsics.areEqual(knownCiv, otherCiv) ? -20.0f : -10.0f;
                    diploManager.addModifier(DiplomaticModifiers.BetrayedDefensivePact, amount * knownCiv.getPersonality().modifierFocus(PersonalityValue.Loyal, 0.3f));
                }
                diploManager.removeModifier$core(DiplomaticModifiers.DeclaredFriendshipWithOurAllies);
                diploManager.removeModifier$core(DiplomaticModifiers.SignedDefensivePactWithOurAllies);
            }
        }
        if (diplomacyManager.hasFlag(DiplomacyFlags.ResearchAgreement)) {
            diplomacyManager.removeFlag(DiplomacyFlags.ResearchAgreement);
            diplomacyManager.setTotalOfScienceDuringRA$core(0);
            otherCivDiplomacy.setTotalOfScienceDuringRA$core(0);
        }
        otherCivDiplomacy.removeFlag(DiplomacyFlags.ResearchAgreement);
        otherCivDiplomacy.removeModifier$core(DiplomaticModifiers.GaveUsGifts);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeDefensivePacts(DiplomacyManager diplomacyManager) {
        Civilization civAtWarWith = diplomacyManager.otherCiv();
        for (DiplomacyManager thirdPartyDiploManager : diplomacyManager.getCivInfo().getDiplomacy().values()) {
            if (thirdPartyDiploManager.getDiplomaticStatus() != DiplomaticStatus.DefensivePact) continue;
            thirdPartyDiploManager.setDiplomaticStatus(DiplomaticStatus.Peace);
            thirdPartyDiploManager.otherCivDiplomacy().setDiplomaticStatus(DiplomaticStatus.Peace);
            if (!Intrinsics.areEqual(thirdPartyDiploManager.otherCiv(), civAtWarWith)) {
                Object v3;
                block14: {
                    void $this$firstOrNull$iv;
                    Object v1;
                    block12: {
                        void $this$firstOrNull$iv2;
                        Iterable iterable = thirdPartyDiploManager.getTrades();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv2) {
                            boolean bl;
                            block11: {
                                Trade trade = (Trade)element$iv;
                                boolean bl2 = false;
                                Iterable $this$any$iv = trade.getOurOffers();
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl = false;
                                } else {
                                    for (Object element$iv2 : $this$any$iv) {
                                        TradeOffer offer = (TradeOffer)element$iv2;
                                        boolean bl3 = false;
                                        if (!Intrinsics.areEqual(offer.getName(), "Defensive Pact")) continue;
                                        bl = true;
                                        break block11;
                                    }
                                    bl = false;
                                }
                            }
                            if (!bl) continue;
                            v1 = element$iv;
                            break block12;
                        }
                        v1 = null;
                    }
                    Trade defensivePactOffer = v1;
                    TypeIntrinsics.asMutableCollection(thirdPartyDiploManager.getTrades()).remove(defensivePactOffer);
                    Iterable $i$f$firstOrNull = thirdPartyDiploManager.otherCivDiplomacy().getTrades();
                    boolean $i$f$firstOrNull2 = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        boolean bl;
                        block13: {
                            Trade trade = (Trade)element$iv;
                            boolean bl4 = false;
                            Iterable $this$any$iv = trade.getOurOffers();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv3 : $this$any$iv) {
                                    TradeOffer offer = (TradeOffer)element$iv3;
                                    boolean bl5 = false;
                                    if (!Intrinsics.areEqual(offer.getName(), "Defensive Pact")) continue;
                                    bl = true;
                                    break block13;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) continue;
                        v3 = element$iv;
                        break block14;
                    }
                    v3 = null;
                }
                Trade theirDefensivePactOffer = v3;
                TypeIntrinsics.asMutableCollection(thirdPartyDiploManager.otherCivDiplomacy().getTrades()).remove(theirDefensivePactOffer);
                thirdPartyDiploManager.removeFlag(DiplomacyFlags.DefensivePact);
                thirdPartyDiploManager.otherCivDiplomacy().removeFlag(DiplomacyFlags.DefensivePact);
            }
            for (Civilization civ : thirdPartyDiploManager.getCommonKnownCivsWithSpectators()) {
                String[] stringArray = new String[]{diplomacyManager.getCivInfo().getCivName(), "OtherIcons/Diplomacy", thirdPartyDiploManager.getOtherCivName()};
                civ.addNotification('[' + diplomacyManager.getCivInfo().getCivName() + "] cancelled their Defensive Pact with [" + thirdPartyDiploManager.getOtherCivName() + "]!", Notification.NotificationCategory.Diplomacy, stringArray);
            }
            String[] stringArray = new String[]{diplomacyManager.getCivInfo().getCivName(), "OtherIcons/Diplomacy", thirdPartyDiploManager.getOtherCivName()};
            thirdPartyDiploManager.otherCiv().addNotification('[' + diplomacyManager.getCivInfo().getCivName() + "] cancelled their Defensive Pact with us!", Notification.NotificationCategory.Diplomacy, stringArray);
            stringArray = new String[]{"OtherIcons/Diplomacy", thirdPartyDiploManager.getOtherCivName()};
            thirdPartyDiploManager.getCivInfo().addNotification("We have cancelled our Defensive Pact with [" + thirdPartyDiploManager.getOtherCivName() + "]!", Notification.NotificationCategory.Diplomacy, stringArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void callInDefensivePactAllies(DiplomacyManager diplomacyManager) {
        void $this$filterTo$iv$iv;
        Civilization civAtWarWith = diplomacyManager.otherCiv();
        Collection<DiplomacyManager> collection = diplomacyManager.getCivInfo().getDiplomacy().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DiplomacyManager ourDipManager = (DiplomacyManager)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ourDipManager.getDiplomaticStatus() == DiplomaticStatus.DefensivePact && !ourDipManager.otherCiv().isDefeated() && !ourDipManager.otherCiv().isAtWarWith(civAtWarWith);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (DiplomacyManager ourDefensivePact : (List)destination$iv$iv) {
            Civilization ally = ourDefensivePact.otherCiv();
            if (!civAtWarWith.knows(ally)) {
                civAtWarWith.getDiplomacyFunctions().makeCivilizationsMeet(ally, true);
            }
            DiplomacyManager diplomacyManager2 = civAtWarWith.getDiplomacyManager(ally);
            Intrinsics.checkNotNull(diplomacyManager2);
            diplomacyManager2.declareWar(new DeclareWarReason(WarType.DefensivePactWar, diplomacyManager.getCivInfo()));
        }
    }

    private final void callInCityStateAllies(DiplomacyManager diplomacyManager) {
        Civilization civAtWarWith = diplomacyManager.otherCiv();
        Iterator<Civilization> iterator2 = SequencesKt.filter(diplomacyManager.getCivInfo().getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(diplomacyManager){
            final /* synthetic */ DiplomacyManager $diplomacyManager;
            {
                this.$diplomacyManager = $diplomacyManager;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isCityState() && Intrinsics.areEqual(it.getAllyCiv(), this.$diplomacyManager.getCivInfo().getCivName());
            }
        }).iterator();
        while (iterator2.hasNext()) {
            Civilization thirdCiv = iterator2.next();
            if (thirdCiv.isAtWarWith(civAtWarWith)) continue;
            if (!thirdCiv.knows(civAtWarWith)) {
                thirdCiv.getDiplomacyFunctions().makeCivilizationsMeet(civAtWarWith, true);
            }
            DiplomacyManager diplomacyManager2 = thirdCiv.getDiplomacyManager(civAtWarWith);
            Intrinsics.checkNotNull(diplomacyManager2);
            diplomacyManager2.declareWar(new DeclareWarReason(WarType.CityStateAllianceWar, diplomacyManager.getCivInfo()));
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WarType.values().length];
            try {
                nArray[WarType.DirectWar.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WarType.DefensivePactWar.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WarType.CityStateAllianceWar.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WarType.JoinWar.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WarType.TeamWar.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

