/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.unciv.UncivGame;
import com.unciv.logic.VictoryData;
import com.unciv.logic.automation.civilization.NextTurnAutomation;
import com.unciv.logic.city.City;
import com.unciv.logic.city.managers.CityTurnManager;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomacyTurnManager;
import com.unciv.logic.civilization.managers.TurnManager;
import com.unciv.logic.civilization.managers.UnitManager;
import com.unciv.logic.civilization.transients.CivInfoTransientCache;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.UnitTurnManager;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.trade.TradeEvaluation;
import com.unciv.logic.trade.TradeRequest;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueKt;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.Stats;
import com.unciv.ui.components.MayaCalendar;
import com.unciv.ui.screens.worldscreen.status.NextTurnProgress;
import com.unciv.utils.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\bH\u0002J\u0012\u0010\n\u001a\u00020\b2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u00020\b2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fJ\b\u0010\u0014\u001a\u00020\bH\u0002J\b\u0010\u0015\u001a\u00020\bH\u0002J\u0006\u0010\u0016\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/unciv/logic/civilization/managers/TurnManager;", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "(Lcom/unciv/logic/civilization/Civilization;)V", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "automateTurn", "", "doRevoltSpawn", "endTurn", "progressBar", "Lcom/unciv/ui/screens/worldscreen/status/NextTurnProgress;", "getTurnsBeforeRevolt", "", "handleDiplomaticVictoryFlags", "rateTileForRevoltSpawn", "tile", "Lcom/unciv/logic/map/tile/Tile;", "startTurn", "startTurnFlags", "updateRevolts", "updateWinningCiv", "core"})
@SourceDebugExtension(value={"SMAP\nTurnManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TurnManager.kt\ncom/unciv/logic/civilization/managers/TurnManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,352:1\n766#2:353\n857#2,2:354\n766#2:356\n857#2,2:357\n1747#2,3:359\n2624#2,3:362\n1963#2,14:365\n1054#2:421\n1855#2,2:424\n1433#3,14:379\n1433#3,14:393\n1839#3,14:407\n1313#3,2:422\n*S KotlinDebug\n*F\n+ 1 TurnManager.kt\ncom/unciv/logic/civilization/managers/TurnManager\n*L\n44#1:353\n44#1:354,2\n107#1:356\n107#1:357,2\n143#1:359,3\n158#1:362,3\n186#1:365,14\n303#1:421\n312#1:424,2\n187#1:379,14\n191#1:393,14\n277#1:407,14\n311#1:422,2\n*E\n"})
public final class TurnManager {
    @NotNull
    private final Civilization civInfo;

    public TurnManager(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.civInfo = civInfo;
    }

    @NotNull
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    /*
     * WARNING - void declaration
     */
    public final void startTurn(@Nullable NextTurnProgress progressBar) {
        MapUnit unit;
        void $this$filterTo$iv$iv;
        if (this.civInfo.isSpectator()) {
            return;
        }
        this.civInfo.getThreatManager().clear();
        if (this.civInfo.isMajorCiv() && this.civInfo.isAlive()) {
            this.civInfo.getStatsHistory().recordRankingStats(this.civInfo);
        }
        if (!((Collection)this.civInfo.getCities()).isEmpty() && !((Map)this.civInfo.getGameInfo().getRuleset().getTechnologies()).isEmpty()) {
            this.civInfo.getTech().updateResearchProgress();
        }
        this.civInfo.getCache().updateCivResources();
        String[] $this$filter$iv = (String[])this.civInfo.getCivResourceSupply();
        boolean $i$f$filter = false;
        String[] stringArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResourceSupplyList.ResourceSupply it = (ResourceSupplyList.ResourceSupply)element$iv$iv;
            boolean bl = false;
            if (!it.getResource().isStockpiled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (ResourceSupplyList.ResourceSupply stockpiledResource : (List)destination$iv$iv) {
            this.civInfo.getResourceStockpiles().add(stockpiledResource.getResource().getName(), stockpiledResource.getAmount());
        }
        this.civInfo.getCivConstructions().startTurn();
        this.civInfo.getAttacksSinceTurnStart().clear();
        this.civInfo.updateStatsForNextTurn();
        if (this.civInfo.getPlayerType() == PlayerType.AI && IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)this.civInfo.getGameInfo().getRuleset().getModOptions(), UniqueType.ConvertGoldToScience, null, 2, null)) {
            NextTurnAutomation.INSTANCE.automateGoldToSciencePercentage(this.civInfo);
        }
        if (!((Collection)this.civInfo.getCities()).isEmpty()) {
            String greatPerson = this.civInfo.getGreatPeople().getNewGreatPerson();
            while (greatPerson != null) {
                if (this.civInfo.getGameInfo().getRuleset().getUnits().containsKey(greatPerson)) {
                    UnitManager.addUnit$default(this.civInfo.getUnits(), greatPerson, null, 2, null);
                }
                greatPerson = this.civInfo.getGreatPeople().getNewGreatPerson();
            }
            this.civInfo.getReligionManager().startTurn();
            if (this.civInfo.isLongCountActive()) {
                MayaCalendar.INSTANCE.startTurnForMaya(this.civInfo);
            }
        }
        CivInfoTransientCache.updateViewableTiles$default(this.civInfo.getCache(), null, 1, null);
        CivInfoTransientCache.updateCitiesConnectedToCapital$default(this.civInfo.getCache(), false, 1, null);
        this.startTurnFlags();
        this.updateRevolts();
        for (City city2 : this.civInfo.getCities()) {
            NextTurnProgress nextTurnProgress = progressBar;
            if (nextTurnProgress != null) {
                nextTurnProgress.increment();
            }
            new CityTurnManager(city2).startTurn();
        }
        Iterator<Object> iterator2 = this.civInfo.getUnits().getCivUnits().iterator();
        while (iterator2.hasNext()) {
            unit = (MapUnit)iterator2.next();
            new UnitTurnManager(unit).startTurn();
        }
        if (this.civInfo.getPlayerType() == PlayerType.Human && UncivGame.Companion.getCurrent().getSettings().getAutomatedUnitsMoveOnTurnStart()) {
            this.civInfo.setHasMovedAutomatedUnits(true);
            iterator2 = this.civInfo.getUnits().getCivUnits().iterator();
            while (iterator2.hasNext()) {
                unit = (MapUnit)iterator2.next();
                unit.doAction();
            }
        } else {
            this.civInfo.setHasMovedAutomatedUnits(false);
        }
        for (TradeRequest tradeRequest : CollectionsKt.toList((Iterable)this.civInfo.getTradeRequests())) {
            Civilization offeringCiv = this.civInfo.getGameInfo().getCivilization(tradeRequest.getRequestingCiv());
            if (!offeringCiv.isDefeated() && new TradeEvaluation().isTradeValid(tradeRequest.getTrade(), this.civInfo, offeringCiv)) continue;
            this.civInfo.getTradeRequests().remove(tradeRequest);
            stringArray = new String[]{"StatIcons/Acquire"};
            offeringCiv.addNotification("Our proposed trade is no longer relevant!", Notification.NotificationCategory.Trade, stringArray);
        }
        this.updateWinningCiv();
    }

    public static /* synthetic */ void startTurn$default(TurnManager turnManager, NextTurnProgress nextTurnProgress, int n, Object object) {
        if ((n & 1) != 0) {
            nextTurnProgress = null;
        }
        turnManager.startTurn(nextTurnProgress);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final void startTurnFlags() {
        Set<String> set2 = this.civInfo.getFlagsCountdown().keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        Iterator<String> iterator2 = CollectionsKt.toList((Iterable)set2).iterator();
        block7: while (true) {
            block13: {
                if (!iterator2.hasNext()) {
                    this.handleDiplomaticVictoryFlags();
                    return;
                }
                String flag = iterator2.next();
                if (!this.civInfo.getFlagsCountdown().containsKey(flag)) continue;
                switch (flag.hashCode()) {
                    case 949850604: {
                        void $this$filterTo$iv$iv;
                        if (!flag.equals("CityStateGreatPersonGift")) break;
                        List<Civilization> cityStateAllies2 = SequencesKt.toList(SequencesKt.filter(this.civInfo.getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(this){
                            final /* synthetic */ TurnManager this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull Civilization it) {
                                Intrinsics.checkNotNullParameter(it, "it");
                                return it.isCityState() && Intrinsics.areEqual(it.getAllyCiv(), this.this$0.getCivInfo().getCivName());
                            }
                        }));
                        Iterable $this$filter$iv = cityStateAllies2;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            Civilization it = (Civilization)element$iv$iv;
                            boolean bl = false;
                            boolean bl2 = !((Collection)it.getCities()).isEmpty();
                            if (!bl2) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Civilization givingCityState = (Civilization)CollectionsKt.randomOrNull((List)destination$iv$iv, Random.Default);
                        if (!((Collection)cityStateAllies2).isEmpty()) {
                            Map map2 = this.civInfo.getFlagsCountdown();
                            Intrinsics.checkNotNull(flag);
                            Integer n = this.civInfo.getFlagsCountdown().get(flag);
                            Intrinsics.checkNotNull(n);
                            map2.put(flag, ((Number)n).intValue() - 1);
                        }
                        Integer n = this.civInfo.getFlagsCountdown().get(flag);
                        Intrinsics.checkNotNull(n);
                        if (((Number)n).intValue() >= Math.min(cityStateAllies2.size(), 10) || !(!((Collection)this.civInfo.getCities()).isEmpty()) || givingCityState == null) continue block7;
                        givingCityState.getCityStateFunctions().giveGreatPersonToPatron(this.civInfo);
                        Map map3 = this.civInfo.getFlagsCountdown();
                        Intrinsics.checkNotNull(flag);
                        map3.put(flag, this.civInfo.getCityStateFunctions().turnsForGreatPersonFromCityState());
                        continue block7;
                    }
                }
                Integer n = this.civInfo.getFlagsCountdown().get(flag);
                Intrinsics.checkNotNull(n);
                if (((Number)n).intValue() > 0) {
                    Map map4 = this.civInfo.getFlagsCountdown();
                    Intrinsics.checkNotNull(flag);
                    Integer n2 = this.civInfo.getFlagsCountdown().get(flag);
                    Intrinsics.checkNotNull(n2);
                    map4.put(flag, ((Number)n2).intValue() - 1);
                }
                Integer n3 = this.civInfo.getFlagsCountdown().get(flag);
                if (n3 == null || n3 != 0) continue;
                String string = flag;
                switch (string.hashCode()) {
                    case -339985388: {
                        if (string.equals("TurnsTillCityStateElection")) break;
                        break block13;
                    }
                    case 1254619515: {
                        if (string.equals("RevoltSpawning")) {
                            this.doRevoltSpawn();
                        }
                        break block13;
                    }
                }
                this.civInfo.getCityStateFunctions().holdElections();
            }
        }
    }

    private final void handleDiplomaticVictoryFlags() {
        Integer n = this.civInfo.getFlagsCountdown().get("ShouldResetDiplomaticVotes");
        if (n != null && n == 0) {
            this.civInfo.getGameInfo().getDiplomaticVictoryVotesCast().clear();
            this.civInfo.removeFlag("ShowDiplomaticVotingResults");
            this.civInfo.removeFlag("ShouldResetDiplomaticVotes");
        }
        Integer n2 = this.civInfo.getFlagsCountdown().get("ShowDiplomaticVotingResults");
        if (n2 != null && n2 == 0) {
            boolean bl;
            block8: {
                this.civInfo.getGameInfo().processDiplomaticVictory();
                Iterable $this$any$iv = this.civInfo.getGameInfo().getCivilizations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Civilization it = (Civilization)element$iv;
                        boolean bl2 = false;
                        if (!it.getVictoryManager().hasWon()) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                this.civInfo.removeFlag("TurnsTillNextDiplomaticVote");
            } else {
                this.civInfo.addFlag("ShouldResetDiplomaticVotes", 1);
                this.civInfo.addFlag("TurnsTillNextDiplomaticVote", this.civInfo.getTurnsBetweenDiplomaticVotes());
            }
        }
        Integer n3 = this.civInfo.getFlagsCountdown().get("TurnsTillNextDiplomaticVote");
        if (n3 != null && n3 == 0) {
            this.civInfo.addFlag("ShowDiplomaticVotingResults", 1);
        }
    }

    private final void updateRevolts() {
        boolean bl;
        block6: {
            Iterable $this$none$iv = this.civInfo.getGameInfo().getCivilizations();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Civilization it = (Civilization)element$iv;
                    boolean bl2 = false;
                    if (!it.isBarbarian()) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        if (!Civilization.hasUnique$default(this.civInfo, UniqueType.SpawnRebels, null, 2, null)) {
            this.civInfo.removeFlag("RevoltSpawning");
            return;
        }
        if (!this.civInfo.hasFlag("RevoltSpawning")) {
            this.civInfo.addFlag("RevoltSpawning", RangesKt.coerceAtLeast(this.getTurnsBeforeRevolt(), 1));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doRevoltSpawn() {
        Object v5;
        void $this$maxByOrNull$iv;
        Tile tile;
        Object v0;
        Civilization civilization;
        try {
            civilization = this.civInfo.getGameInfo().getBarbarianCivilization();
        }
        catch (NoSuchElementException ex) {
            Log.INSTANCE.error("Barbarian civilization not found", ex);
            this.civInfo.removeFlag("RevoltSpawning");
            return;
        }
        Civilization barbarians = civilization;
        Random.Default random = Random.Default;
        int rebelCount = 1 + random.nextInt(100 + 20 * (this.civInfo.getCities().size() - 1)) / 100;
        Iterable $this$maxByOrNull$iv2 = this.civInfo.getCities();
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv2.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                City it = (City)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = random.nextInt(it.getPopulation().getPopulation() + 10);
                do {
                    Object e$iv = iterator$iv.next();
                    City it2 = (City)e$iv;
                    $i$a$-maxByOrNull-TurnManager$doRevoltSpawn$spawnCity$1 = false;
                    int v$iv = random.nextInt(it2.getPopulation().getPopulation() + 10);
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        City city2 = v0;
        if (city2 == null) {
            return;
        }
        City spawnCity = city2;
        Sequence<Tile> $this$maxByOrNull$iv3 = spawnCity.getTiles();
        boolean $i$f$maxByOrNull2 = false;
        Iterator<Tile> iterator$iv2 = $this$maxByOrNull$iv3.iterator();
        if (!iterator$iv2.hasNext()) {
            tile = null;
        } else {
            Tile maxElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                tile = maxElem$iv;
            } else {
                Tile it = maxElem$iv;
                boolean bl = false;
                int maxValue$iv = this.rateTileForRevoltSpawn(it);
                do {
                    Tile e$iv;
                    Tile it3 = e$iv = iterator$iv2.next();
                    $i$a$-maxByOrNull-TurnManager$doRevoltSpawn$spawnTile$1 = false;
                    int v$iv = this.rateTileForRevoltSpawn(it3);
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv2.hasNext());
                tile = maxElem$iv;
            }
        }
        Tile tile2 = tile;
        if (tile2 == null) {
            return;
        }
        Tile spawnTile = tile2;
        Collection<BaseUnit> collection = this.civInfo.getGameInfo().getRuleset().getUnits().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        iterator$iv2 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), (Function1)new Function1<BaseUnit, Boolean>(this){
            final /* synthetic */ TurnManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull BaseUnit it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getUniqueTo() == null && it.isMelee() && it.isLandUnit() && !IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.CannotAttack, null, 2, null) && it.isBuildable(this.this$0.getCivInfo());
            }
        });
        boolean $i$f$maxByOrNull3 = false;
        Iterator iterator$iv3 = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv3.hasNext()) {
            v5 = null;
        } else {
            Object maxElem$iv = iterator$iv3.next();
            if (!iterator$iv3.hasNext()) {
                v5 = maxElem$iv;
            } else {
                BaseUnit it = (BaseUnit)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = random.nextInt(1000);
                do {
                    Object e$iv = iterator$iv3.next();
                    BaseUnit it4 = (BaseUnit)e$iv;
                    $i$a$-maxByOrNull-TurnManager$doRevoltSpawn$unitToSpawn$2 = false;
                    int v$iv = random.nextInt(1000);
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv3.hasNext());
                v5 = maxElem$iv;
            }
        }
        BaseUnit baseUnit = v5;
        if (baseUnit == null) {
            return;
        }
        BaseUnit unitToSpawn2 = baseUnit;
        int n = 0;
        while (n < rebelCount) {
            int it = n++;
            boolean bl = false;
            TileMap.placeUnitNearTile$default(this.civInfo.getGameInfo().getTileMap(), spawnTile.getPosition(), unitToSpawn2, barbarians, null, 8, null);
        }
        this.civInfo.removeFlag("RevoltSpawning");
        String[] stringArray = new String[]{unitToSpawn2.getName(), "StatIcons/Malcontent"};
        this.civInfo.addNotification("Your citizens are revolting due to very high unhappiness!", spawnTile.getPosition(), Notification.NotificationCategory.General, stringArray);
    }

    private final int rateTileForRevoltSpawn(Tile tile) {
        if (tile.isWater() || tile.getMilitaryUnit() != null || tile.getCivilianUnit() != null || tile.isCityCenter() || tile.isImpassible()) {
            return -1;
        }
        int score = 10;
        if (tile.getImprovement() == null) {
            score += 4;
            if (tile.getResource() != null) {
                score += 3;
            }
        }
        if (Tile.getDefensiveBonus$default(tile, false, 1, null) > 0.0f) {
            score += 4;
        }
        return score;
    }

    private final int getTurnsBeforeRevolt() {
        return (int)((float)(this.civInfo.getGameInfo().getRuleset().getModOptions().getConstants().getBaseTurnsUntilRevolt() + Random.Default.nextInt(3)) * RangesKt.coerceAtLeast(this.civInfo.getGameInfo().getSpeed().getModifier(), 1.0f));
    }

    public final void endTurn(@Nullable NextTurnProgress progressBar) {
        MapUnit element$iv;
        Iterator<City> militaryUnits2;
        Stats stats2;
        if (UncivGame.Companion.getCurrent().getSettings().getCitiesAutoBombardAtEndOfTurn()) {
            NextTurnAutomation.INSTANCE.automateCityBombardment(this.civInfo);
        }
        for (Unique unique : this.civInfo.getTriggeredUniques(UniqueType.TriggerUponTurnEnd, new StateForConditionals(this.civInfo, null, null, null, null, null, null, null, null, false, 1022, null))) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.civInfo, null, null, null, null, null, 124, null);
        }
        ArrayList<Civilization.NotificationsLog> notificationsLog = this.civInfo.getNotificationsLog();
        Civilization.NotificationsLog notificationsThisTurn = new Civilization.NotificationsLog(this.civInfo.getGameInfo().getTurns());
        notificationsThisTurn.getNotifications().addAll((Collection<Notification>)this.civInfo.getNotifications());
        while (notificationsLog.size() >= UncivGame.Companion.getCurrent().getSettings().getNotificationsLogMaxTurns()) {
            CollectionsKt.removeFirst((List)notificationsLog);
        }
        if (!((Collection)notificationsThisTurn.getNotifications()).isEmpty()) {
            notificationsLog.add(notificationsThisTurn);
        }
        this.civInfo.getNotifications().clear();
        if (this.civInfo.isDefeated() || this.civInfo.isSpectator()) {
            return;
        }
        if (this.civInfo.isBarbarian()) {
            stats2 = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        } else {
            this.civInfo.updateStatsForNextTurn();
            stats2 = this.civInfo.getStats().getStatsForNextTurn();
        }
        Stats nextTurnStats = stats2;
        this.civInfo.getPolicies().endTurn((int)nextTurnStats.getCulture());
        Civilization civilization = this.civInfo;
        civilization.setTotalCultureForContests(civilization.getTotalCultureForContests() + (int)nextTurnStats.getCulture());
        if (this.civInfo.isCityState()) {
            this.civInfo.getQuestManager().endTurn();
            if (this.civInfo.getGameInfo().isEspionageEnabled() && !this.civInfo.hasFlag("TurnsTillCityStateElection")) {
                this.civInfo.addFlag("TurnsTillCityStateElection", Random.Default.nextInt(this.civInfo.getGameInfo().getRuleset().getModOptions().getConstants().getCityStateElectionTurns() + 1));
            }
        }
        if (!this.civInfo.isBarbarian() && this.civInfo.getGold() <= -200 && (int)nextTurnStats.getGold() < 0) {
            do {
                MapUnit unitToDisband2;
                MapUnit mapUnit;
                militaryUnits2 = SequencesKt.filter(this.civInfo.getUnits().getCivUnits(), endTurn.militaryUnits.1.INSTANCE);
                String[] $this$minByOrNull$iv = militaryUnits2;
                boolean $i$f$minByOrNull = false;
                Iterator<MapUnit> iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    mapUnit = null;
                } else {
                    MapUnit minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        mapUnit = minElem$iv;
                    } else {
                        MapUnit it = minElem$iv;
                        boolean bl = false;
                        int minValue$iv = it.getBaseUnit().getCost();
                        do {
                            MapUnit e$iv;
                            MapUnit it2 = e$iv = iterator$iv.next();
                            boolean bl2 = false;
                            int v$iv = it2.getBaseUnit().getCost();
                            if (minValue$iv <= v$iv) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        mapUnit = minElem$iv;
                    }
                }
                if ((MapUnit)mapUnit == null) break;
                unitToDisband2.disband();
                String unitName = unitToDisband2.shortDisplayName();
                $this$minByOrNull$iv = new String[]{unitName, "OtherIcons/DisbandUnit"};
                this.civInfo.addNotification("Cannot provide unit upkeep for " + unitName + " - unit has been disbanded!", Notification.NotificationCategory.Units, $this$minByOrNull$iv);
                nextTurnStats = this.civInfo.getStats().getStatsForNextTurn();
            } while (this.civInfo.getGold() <= -200 && (int)nextTurnStats.getGold() < 0);
        }
        this.civInfo.addGold((int)nextTurnStats.getGold());
        if (!((Collection)this.civInfo.getCities()).isEmpty() && !((Map)this.civInfo.getGameInfo().getRuleset().getTechnologies()).isEmpty()) {
            this.civInfo.getTech().endTurn((int)nextTurnStats.getScience());
        }
        this.civInfo.getReligionManager().endTurn((int)nextTurnStats.getFaith());
        militaryUnits2 = this.civInfo;
        ((Civilization)((Object)militaryUnits2)).setTotalFaithForContests(((Civilization)((Object)militaryUnits2)).getTotalFaithForContests() + (int)nextTurnStats.getFaith());
        this.civInfo.getEspionageManager().endTurn();
        if (this.civInfo.isMajorCiv()) {
            this.civInfo.getGreatPeople().addGreatPersonPoints();
        }
        Iterable $this$sortedByDescending$iv = this.civInfo.getCities();
        boolean $i$f$sortedByDescending = false;
        for (City city2 : CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                City it = (City)b;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(it.isBeingRazed());
                it = (City)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.isBeingRazed());
            }
        })) {
            NextTurnProgress nextTurnProgress = progressBar;
            if (nextTurnProgress != null) {
                nextTurnProgress.increment();
            }
            new CityTurnManager(city2).endTurn();
        }
        UniqueKt.endTurn(this.civInfo.getTemporaryUniques());
        this.civInfo.getGoldenAges().endTurn(this.civInfo.getHappiness());
        Object $this$forEach$iv = this.civInfo.getUnits().getCivUnits();
        boolean $i$f$forEach = false;
        Iterator<MapUnit> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            MapUnit it = element$iv = iterator2.next();
            boolean bl = false;
            new UnitTurnManager(it).endTurn();
        }
        Collection<DiplomacyManager> collection = this.civInfo.getDiplomacy().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        $this$forEach$iv = CollectionsKt.toList((Iterable)collection);
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            DiplomacyManager it = (DiplomacyManager)((Object)element$iv);
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            DiplomacyTurnManager.INSTANCE.nextTurn(it);
        }
        this.civInfo.getCache().updateHasActiveEnemyMovementPenalty();
        this.civInfo.setCachedMilitaryMight(-1);
        this.updateWinningCiv();
    }

    public static /* synthetic */ void endTurn$default(TurnManager turnManager, NextTurnProgress nextTurnProgress, int n, Object object) {
        if ((n & 1) != 0) {
            nextTurnProgress = null;
        }
        turnManager.endTurn(nextTurnProgress);
    }

    public final void updateWinningCiv() {
        if (this.civInfo.getGameInfo().getVictoryData() != null) {
            return;
        }
        String victoryType = this.civInfo.getVictoryManager().getVictoryTypeAchieved();
        if (victoryType != null) {
            this.civInfo.getGameInfo().setVictoryData(new VictoryData(this.civInfo.getCivName(), victoryType, this.civInfo.getGameInfo().getTurns()));
            for (Civilization otherCiv : this.civInfo.getGameInfo().getCivilizations()) {
                if (otherCiv.getPlayerType() != PlayerType.Human || Intrinsics.areEqual(otherCiv, this.civInfo)) continue;
                otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.GameHasBeenWon, ""));
            }
        }
    }

    public final void automateTurn() {
        if (this.civInfo.isDefeated()) {
            return;
        }
        NextTurnAutomation.INSTANCE.automateCivMoves(this.civInfo);
        if (this.civInfo.isBarbarian() && !this.civInfo.getGameInfo().getGameParameters().getNoBarbarians()) {
            this.civInfo.getGameInfo().getBarbarians().updateEncampments();
        }
    }
}

