/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.badlogic.gdx.math.Vector2;
import com.unciv.UncivGame;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.MapUnitAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.managers.UnitManager;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u001c\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u000bJ\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aJ\u0006\u0010\u001c\u001a\u00020\bJ\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aH\u0002J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aJ\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aJ\u0010\u0010 \u001a\u0004\u0018\u00010\u000b2\u0006\u0010!\u001a\u00020\bJ)\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010&J\u0018\u0010\"\u001a\u0004\u0018\u00010\u000b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010'\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0006\u0010(\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/unciv/logic/civilization/managers/UnitManager;", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "(Lcom/unciv/logic/civilization/Civilization;)V", "getCivInfo", "()Lcom/unciv/logic/civilization/Civilization;", "nextPotentiallyDueAt", "", "unitList", "", "Lcom/unciv/logic/map/mapunit/MapUnit;", "addUnit", "", "mapUnit", "updateCivInfo", "", "baseUnit", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "city", "Lcom/unciv/logic/city/City;", "unitName", "", "cycleThroughDueUnits", "unitToSkip", "getCivGreatPeople", "Lkotlin/sequences/Sequence;", "getCivUnits", "getCivUnitsSize", "getCivUnitsStartingAtNextDue", "getDueUnits", "getIdleUnits", "getUnitById", "id", "placeUnitNearTile", "location", "Lcom/badlogic/gdx/math/Vector2;", "unitId", "(Lcom/badlogic/gdx/math/Vector2;Lcom/unciv/models/ruleset/unit/BaseUnit;Ljava/lang/Integer;)Lcom/unciv/logic/map/mapunit/MapUnit;", "removeUnit", "shouldGoToDueUnit", "core"})
@SourceDebugExtension(value={"SMAP\nUnitManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitManager.kt\ncom/unciv/logic/civilization/managers/UnitManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,201:1\n766#2:202\n857#2,2:203\n1747#2,3:205\n179#3,2:208\n*S KotlinDebug\n*F\n+ 1 UnitManager.kt\ncom/unciv/logic/civilization/managers/UnitManager\n*L\n58#1:202\n58#1:203,2\n103#1:205,3\n172#1:208,2\n*E\n"})
public final class UnitManager {
    @NotNull
    private final Civilization civInfo;
    @NotNull
    private List<MapUnit> unitList;
    private int nextPotentiallyDueAt;

    public UnitManager(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        this.civInfo = civInfo;
        this.unitList = CollectionsKt.emptyList();
    }

    @NotNull
    public final Civilization getCivInfo() {
        return this.civInfo;
    }

    @Nullable
    public final MapUnit addUnit(@NotNull String unitName, @Nullable City city2) {
        Intrinsics.checkNotNullParameter(unitName, "unitName");
        BaseUnit baseUnit = this.civInfo.getGameInfo().getRuleset().getUnits().get(unitName);
        if (baseUnit == null) {
            return null;
        }
        BaseUnit unit = baseUnit;
        return this.addUnit(unit, city2);
    }

    public static /* synthetic */ MapUnit addUnit$default(UnitManager unitManager, String string, City city2, int n, Object object) {
        if ((n & 2) != 0) {
            city2 = null;
        }
        return unitManager.addUnit(string, city2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MapUnit addUnit(@NotNull BaseUnit baseUnit, @Nullable City city2) {
        MapUnit placedUnit;
        block11: {
            City cityToAddTo;
            block12: {
                City city3;
                Intrinsics.checkNotNullParameter(baseUnit, "baseUnit");
                if (this.civInfo.getCities().isEmpty()) {
                    return null;
                }
                BaseUnit unit = this.civInfo.getEquivalentUnit(baseUnit);
                if (unit.isWaterUnit() && (city2 == null || !city2.isCoastal())) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = this.civInfo.getCities();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        City it = (City)element$iv$iv;
                        boolean bl = false;
                        if (!it.isCoastal()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    city3 = (City)CollectionsKt.randomOrNull((List)destination$iv$iv, Random.Default);
                } else {
                    city3 = city2;
                    if (city3 == null) {
                        city3 = (City)CollectionsKt.random((Collection)this.civInfo.getCities(), Random.Default);
                    }
                }
                if (city3 == null) {
                    return null;
                }
                cityToAddTo = city3;
                MapUnit mapUnit = this.placeUnitNearTile(cityToAddTo.getLocation(), unit.getName());
                if (mapUnit == null) {
                    return null;
                }
                placedUnit = mapUnit;
                if (unit.isGreatPerson()) {
                    String[] stringArray = new String[]{unit.getName()};
                    this.civInfo.addNotification("A [" + unit.getName() + "] has been born in [" + cityToAddTo.getName() + "]!", new MapUnitAction(placedUnit), Notification.NotificationCategory.General, stringArray);
                }
                if (!MapUnit.hasUnique$default(placedUnit, UniqueType.ReligiousUnit, null, false, 6, null) || !this.civInfo.getGameInfo().isReligionEnabled()) break block11;
                if (!MapUnit.hasUnique$default(placedUnit, UniqueType.TakeReligionOverBirthCity, null, false, 6, null)) break block12;
                Religion religion = this.civInfo.getReligionManager().getReligion();
                boolean bl = religion != null ? !religion.isMajorReligion() : false;
                if (!bl) break block11;
            }
            placedUnit.setReligion(cityToAddTo.getReligion().getMajorityReligionName());
        }
        return placedUnit;
    }

    public static /* synthetic */ MapUnit addUnit$default(UnitManager unitManager, BaseUnit baseUnit, City city2, int n, Object object) {
        if ((n & 2) != 0) {
            city2 = null;
        }
        return unitManager.addUnit(baseUnit, city2);
    }

    @Nullable
    public final MapUnit placeUnitNearTile(@NotNull Vector2 location, @NotNull String unitName) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(unitName, "unitName");
        BaseUnit baseUnit = this.civInfo.getGameInfo().getRuleset().getUnits().get(unitName);
        Intrinsics.checkNotNull(baseUnit);
        BaseUnit unit = baseUnit;
        return UnitManager.placeUnitNearTile$default(this, location, unit, null, 4, null);
    }

    @Nullable
    public final MapUnit placeUnitNearTile(@NotNull Vector2 location, @NotNull BaseUnit baseUnit, @Nullable Integer unitId) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(baseUnit, "baseUnit");
        MapUnit unit = this.civInfo.getGameInfo().getTileMap().placeUnitNearTile(location, baseUnit, this.civInfo, unitId);
        if (unit != null) {
            Unique unique2;
            String triggerNotificationText = "due to gaining a [" + unit.getName() + ']';
            Iterator<Unique> iterator2 = unit.getUniques().iterator();
            while (iterator2.hasNext()) {
                unique2 = iterator2.next();
                if (unique2.hasTriggerConditional() || !unique2.conditionalsApply(new StateForConditionals(this.civInfo, null, unit, null, null, null, null, null, null, false, 1018, null))) continue;
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique2, unit, null, triggerNotificationText, 4, null);
            }
            for (Unique unique2 : Civilization.getTriggeredUniques$default(this.civInfo, UniqueType.TriggerUponGainingUnit, null, 2, null)) {
                boolean bl;
                block9: {
                    Iterable $this$any$iv = unique2.getConditionals();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Unique it = (Unique)element$iv;
                            boolean bl2 = false;
                            boolean bl3 = it.getType() == UniqueType.TriggerUponGainingUnit && unit.matchesFilter(it.getParams().get(0));
                            if (!bl3) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique2, unit, null, triggerNotificationText, 4, null);
            }
            if (!((Map)unit.getResourceRequirementsPerTurn()).isEmpty()) {
                this.civInfo.getCache().updateCivResources();
            }
            iterator2 = Civilization.getMatchingUniques$default(this.civInfo, UniqueType.LandUnitsCrossTerrainAfterUnitGained, null, 2, null).iterator();
            while (iterator2.hasNext()) {
                unique2 = iterator2.next();
                if (!unit.matchesFilter(unique2.getParams().get(1))) continue;
                this.civInfo.setPassThroughImpassableUnlocked(true);
                this.civInfo.getPassableImpassables().add(unique2.getParams().get(0));
            }
            if (MapUnit.hasUnique$default(unit, UniqueType.ReligiousUnit, null, false, 6, null) && this.civInfo.getGameInfo().isReligionEnabled()) {
                Religion religion = this.civInfo.getReligionManager().getReligion();
                unit.setReligion(religion != null ? religion.getName() : null);
            }
        }
        return unit;
    }

    public static /* synthetic */ MapUnit placeUnitNearTile$default(UnitManager unitManager, Vector2 vector2, BaseUnit baseUnit, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        return unitManager.placeUnitNearTile(vector2, baseUnit, n);
    }

    public final int getCivUnitsSize() {
        return this.unitList.size();
    }

    @NotNull
    public final Sequence<MapUnit> getCivUnits() {
        return CollectionsKt.asSequence((Iterable)this.unitList);
    }

    @NotNull
    public final Sequence<MapUnit> getCivGreatPeople() {
        return SequencesKt.filter(this.getCivUnits(), getCivGreatPeople.1.INSTANCE);
    }

    private final Sequence<MapUnit> getCivUnitsStartingAtNextDue() {
        List[] listArray = new List[]{CollectionsKt.plus((Collection)this.unitList.subList(this.nextPotentiallyDueAt, this.unitList.size()), (Iterable)this.unitList.subList(0, this.nextPotentiallyDueAt))};
        return SequencesKt.flattenSequenceOfIterable(SequencesKt.sequenceOf(listArray));
    }

    public final void addUnit(@NotNull MapUnit mapUnit, boolean updateCivInfo) {
        Intrinsics.checkNotNullParameter(mapUnit, "mapUnit");
        List<MapUnit> newList = SequencesKt.toMutableList(this.getCivUnitsStartingAtNextDue());
        newList.add(mapUnit);
        this.unitList = newList;
        this.nextPotentiallyDueAt = 0;
        if (updateCivInfo) {
            this.civInfo.updateStatsForNextTurn();
            if (!((Map)mapUnit.getResourceRequirementsPerTurn()).isEmpty()) {
                this.civInfo.getCache().updateCivResources();
            }
        }
    }

    public static /* synthetic */ void addUnit$default(UnitManager unitManager, MapUnit mapUnit, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        unitManager.addUnit(mapUnit, bl);
    }

    public final void removeUnit(@NotNull MapUnit mapUnit) {
        Intrinsics.checkNotNullParameter(mapUnit, "mapUnit");
        List<MapUnit> newList = SequencesKt.toMutableList(this.getCivUnitsStartingAtNextDue());
        newList.remove(mapUnit);
        this.unitList = newList;
        this.nextPotentiallyDueAt = 0;
        this.civInfo.updateStatsForNextTurn();
        if (!((Map)mapUnit.getResourceRequirementsPerTurn()).isEmpty()) {
            this.civInfo.getCache().updateCivResources();
        }
    }

    @NotNull
    public final Sequence<MapUnit> getIdleUnits() {
        return SequencesKt.filter(this.getCivUnits(), getIdleUnits.1.INSTANCE);
    }

    @NotNull
    public final Sequence<MapUnit> getDueUnits() {
        return SequencesKt.filter(this.getCivUnitsStartingAtNextDue(), getDueUnits.1.INSTANCE);
    }

    public final boolean shouldGoToDueUnit() {
        return UncivGame.Companion.getCurrent().getSettings().getCheckForDueUnits() && SequencesKt.any(this.getDueUnits());
    }

    @Nullable
    public final MapUnit getUnitById(int id) {
        MapUnit mapUnit;
        block1: {
            Sequence<MapUnit> $this$firstOrNull$iv = this.getCivUnits();
            boolean $i$f$firstOrNull = false;
            Iterator<MapUnit> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                MapUnit element$iv;
                MapUnit it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(it.getId() == id)) continue;
                mapUnit = element$iv;
                break block1;
            }
            mapUnit = null;
        }
        return mapUnit;
    }

    @Nullable
    public final MapUnit cycleThroughDueUnits(@Nullable MapUnit unitToSkip) {
        if (CollectionsKt.none((Iterable)this.unitList)) {
            return null;
        }
        int returnAt = this.nextPotentiallyDueAt;
        int fallbackAt = -1;
        do {
            if (!this.unitList.get(returnAt).getDue() || !MapUnit.isIdle$default(this.unitList.get(returnAt), false, 1, null)) continue;
            if (!Intrinsics.areEqual(this.unitList.get(returnAt), unitToSkip)) {
                this.nextPotentiallyDueAt = (returnAt + 1) % this.unitList.size();
                return this.unitList.get(returnAt);
            }
            fallbackAt = returnAt;
        } while ((returnAt = (returnAt + 1) % this.unitList.size()) != this.nextPotentiallyDueAt);
        if (fallbackAt >= 0) {
            this.nextPotentiallyDueAt = (fallbackAt + 1) % this.unitList.size();
            return this.unitList.get(fallbackAt);
        }
        return null;
    }

    public static /* synthetic */ MapUnit cycleThroughDueUnits$default(UnitManager unitManager, MapUnit mapUnit, int n, Object object) {
        if ((n & 1) != 0) {
            mapUnit = null;
        }
        return unitManager.cycleThroughDueUnits(mapUnit);
    }
}

