/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.files;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.List;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.unciv.models.UncivSound;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import java.io.File;
import java.io.FileFilter;
import java.util.Comparator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\b\u0016\u0018\u0000 N2\u00020\u0001:\u0003NOPBe\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012@\b\u0002\u0010\b\u001a:\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\tj\u0004\u0018\u0001`\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010A\u001a\u00020\u000f2\u0006\u0010B\u001a\u00020\u0007H\u0002J\b\u0010C\u001a\u00020\u000fH\u0002J\b\u0010D\u001a\u000208H\u0016J\b\u0010E\u001a\u00020\u0007H\u0002J\u0012\u0010F\u001a\u00020\u000f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010G\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010H\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010I\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\nH\u0002J\b\u0010J\u001a\u00020\u000fH\u0002J\u000e\u0010K\u001a\u00020\u000f2\u0006\u0010L\u001a\u00020\u0005J\b\u0010M\u001a\u00020\u000fH\u0002R\u0016\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0013*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0018\"\u0004\b \u0010\u001aR\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010&\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010\u0018\"\u0004\b(\u0010\u001aR\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00101\u001a\u0002002\u0006\u0010\u0015\u001a\u000200@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u000e\u00106\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000RF\u0010\b\u001a:\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f\u0018\u00010\tj\u0004\u0018\u0001`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010>\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u0018\"\u0004\b@\u0010\u001a\u00a8\u0006Q"}, d2={"Lcom/unciv/logic/files/FileChooser;", "Lcom/unciv/ui/popups/Popup;", "stageToShowOn", "Lcom/badlogic/gdx/scenes/scene2d/Stage;", "title", "", "startFile", "Lcom/badlogic/gdx/files/FileHandle;", "resultListener", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "success", "file", "", "Lcom/unciv/logic/files/ResultListener;", "(Lcom/badlogic/gdx/scenes/scene2d/Stage;Ljava/lang/String;Lcom/badlogic/gdx/files/FileHandle;Lkotlin/jvm/functions/Function2;)V", "absoluteExternalPath", "kotlin.jvm.PlatformType", "absoluteLocalPath", "value", "allowFolderSelect", "getAllowFolderSelect", "()Z", "setAllowFolderSelect", "(Z)V", "currentDir", "dirTypeLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "directoryBrowsingEnabled", "getDirectoryBrowsingEnabled", "setDirectoryBrowsingEnabled", "fileList", "Lcom/unciv/logic/files/FileChooser$FileList;", "fileNameCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "fileNameEnabled", "getFileNameEnabled", "setFileNameEnabled", "fileNameInput", "Lcom/unciv/ui/components/widgets/UncivTextField;", "fileNameLabel", "fileNameWrapper", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "fileScroll", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "Ljava/io/FileFilter;", "filter", "getFilter", "()Ljava/io/FileFilter;", "setFilter", "(Ljava/io/FileFilter;)V", "filterWithFolders", "maxHeight", "", "okButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "pathLabel", "pathLabelWrapper", "result", "showAbsolutePath", "getShowAbsolutePath", "setShowAbsolutePath", "changeDirectory", "directory", "enableOKButton", "getMaxHeight", "getResult", "initialDirectory", "makeAbsolute", "makeRelative", "reportResult", "resetList", "setOkButtonText", "text", "switchDomain", "Companion", "FileList", "FileListItem", "core"})
@SourceDebugExtension(value={"SMAP\nFileChooser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileChooser.kt\ncom/unciv/logic/files/FileChooser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,321:1\n1#2:322\n*E\n"})
public class FileChooser
extends Popup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Function2<Boolean, FileHandle, Unit> resultListener;
    @NotNull
    private FileFilter filter;
    private boolean directoryBrowsingEnabled;
    private boolean allowFolderSelect;
    private boolean showAbsolutePath;
    @NotNull
    private final UncivTextField fileNameInput;
    @NotNull
    private final Label fileNameLabel;
    @NotNull
    private final Table fileNameWrapper;
    @NotNull
    private final Cell<Actor> fileNameCell;
    @NotNull
    private final Label dirTypeLabel;
    @NotNull
    private final Label pathLabel;
    @NotNull
    private final Table pathLabelWrapper;
    @NotNull
    private final FileList fileList;
    @NotNull
    private final AutoScrollPane fileScroll;
    @NotNull
    private final TextButton okButton;
    private final float maxHeight;
    private final String absoluteLocalPath;
    private final String absoluteExternalPath;
    @Nullable
    private FileHandle currentDir;
    @Nullable
    private String result;
    @NotNull
    private final FileFilter filterWithFolders;
    @NotNull
    private static final Comparator<FileListItem> dirListComparator = FileChooser::dirListComparator$lambda$7;

    /*
     * WARNING - void declaration
     */
    public FileChooser(final @NotNull Stage stageToShowOn, @Nullable String title, final @Nullable FileHandle startFile, @Nullable Function2<? super Boolean, ? super FileHandle, Unit> resultListener) {
        void $this$pathLabelWrapper_u24lambda_u242;
        Table $this$fileNameWrapper_u24lambda_u241;
        Table table2;
        Intrinsics.checkNotNullParameter(stageToShowOn, "stageToShowOn");
        super(stageToShowOn, Popup.Scrollability.None, 0.0f, 4, null);
        this.resultListener = resultListener;
        this.filter = FileChooser::filter$lambda$0;
        this.directoryBrowsingEnabled = true;
        this.fileNameInput = new UncivTextField("Please enter a file name", null, null, 6, null);
        this.fileNameLabel = Scene2dExtensionsKt.toLabel("File name:");
        Table table3 = table2 = new Table();
        FileChooser fileChooser = this;
        boolean bl = false;
        $this$fileNameWrapper_u24lambda_u241.defaults().space(10.0f);
        $this$fileNameWrapper_u24lambda_u241.add((Actor)this.fileNameLabel).growX().row();
        $this$fileNameWrapper_u24lambda_u241.add((Actor)this.fileNameInput).growX().row();
        Scene2dExtensionsKt.addSeparator$default($this$fileNameWrapper_u24lambda_u241, null, 0, 1.0f, 3, null);
        fileChooser.fileNameWrapper = table2;
        Color color = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "GRAY");
        this.dirTypeLabel = Scene2dExtensionsKt.toLabel$default("", color, 0, 0, false, 14, null);
        Color color2 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color2, "GRAY");
        this.pathLabel = Scene2dExtensionsKt.toLabel$default("", color2, 0, 8, false, 10, null);
        $this$fileNameWrapper_u24lambda_u241 = table2 = new Table();
        fileChooser = this;
        boolean bl2 = false;
        $this$pathLabelWrapper_u24lambda_u242.setTouchable(Touchable.enabled);
        $this$pathLabelWrapper_u24lambda_u242.defaults().space(10.0f);
        $this$pathLabelWrapper_u24lambda_u242.add((Actor)this.dirTypeLabel).pad(2.0f);
        $this$pathLabelWrapper_u24lambda_u242.add((Actor)this.pathLabel).left().growX();
        fileChooser.pathLabelWrapper = table2;
        Skin skin = this.getSkin();
        Intrinsics.checkNotNullExpressionValue(skin, "getSkin(...)");
        this.fileList = new FileList(skin);
        this.fileScroll = new AutoScrollPane((Actor)this.fileList, null, 2, null);
        this.maxHeight = stageToShowOn.getHeight() * 0.6f;
        this.absoluteLocalPath = Gdx.files.local("").file().getAbsoluteFile().getCanonicalPath();
        this.absoluteExternalPath = Gdx.files.isExternalStorageAvailable() ? Gdx.files.external("").file().getAbsoluteFile().getCanonicalPath() : "/\\/\\/";
        this.filterWithFolders = arg_0 -> FileChooser.filterWithFolders$lambda$3(this, arg_0);
        this.getInnerTable().top().left();
        this.fileList.getSelection().setProgrammaticChangeEvents(false);
        this.fileNameInput.setTextFieldListener((arg_0, arg_1) -> FileChooser._init_$lambda$4(this, arg_0, arg_1));
        this.fileNameInput.setTextFieldFilter(FileChooser::_init_$lambda$5);
        if (title != null) {
            Popup.addGoodSizedLabel$default(this, title, 0, false, 6, null).colspan(2).center().row();
            Popup.addSeparator$default(this, null, 0, 1.0f, 3, null);
        }
        this.add((Actor)this.pathLabelWrapper).colspan(2).fillX().row();
        Popup popup2 = this;
        Color color3 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color3, "GRAY");
        Popup.addSeparator$default(popup2, color3, 0, 1.0f, 2, null);
        this.add((Actor)this.fileScroll).colspan(2).fill().row();
        Popup.addSeparator$default(this, null, 0, 1.0f, 3, null);
        Cell<Actor> cell2 = this.add().colspan(2).growX();
        Intrinsics.checkNotNullExpressionValue(cell2, "growX(...)");
        this.fileNameCell = cell2;
        this.row();
        Popup.addCloseButton$default(this, "Cancel", null, null, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.reportResult(false);
            }
        }, 6, null);
        Object t = Popup.addOKButton$default(this, "OK", null, null, null, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.reportResult(true);
            }
        }, 14, null).getActor();
        Intrinsics.checkNotNullExpressionValue(t, "getActor(...)");
        this.okButton = (TextButton)t;
        this.equalizeLastTwoButtonWidths();
        ActivationExtensionsKt.onChange(this.fileList, (Function1<? super ChangeListener.ChangeEvent, Unit>)new Function1<ChangeListener.ChangeEvent, Unit>(){

            @Override
            public final void invoke(@Nullable ChangeListener.ChangeEvent it) {
                FileListItem fileListItem = (FileListItem)fileList.getSelected();
                if (fileListItem == null) {
                    return;
                }
                FileListItem selected = fileListItem;
                if (!selected.getFile().isDirectory()) {
                    result = selected.getFile().name();
                    fileNameInput.setText(result);
                }
                this.enableOKButton();
            }
        });
        ActivationExtensionsKt.onDoubleClick(this.fileList, UncivSound.Companion.getSilent(), new Function0<Unit>(){

            @Override
            public final void invoke() {
                FileListItem fileListItem = (FileListItem)fileList.getSelected();
                if (fileListItem == null) {
                    return;
                }
                FileListItem selected = fileListItem;
                if (selected.getFile().isDirectory()) {
                    this.changeDirectory(selected.getFile());
                } else {
                    this.reportResult(true);
                    this.close();
                }
            }
        });
        ActivationExtensionsKt.onClick(this.pathLabelWrapper, UncivSound.Companion.getSwap(), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.switchDomain();
            }
        });
        this.getShowListeners().add(new Function0<Unit>(){

            @Override
            public final void invoke() {
                if (currentDir == null) {
                    this.initialDirectory(startFile);
                }
                stageToShowOn.setScrollFocus(fileScroll);
                stageToShowOn.setKeyboardFocus(fileNameInput);
            }
        });
    }

    public /* synthetic */ FileChooser(Stage stage, String string, FileHandle fileHandle, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            fileHandle = null;
        }
        if ((n & 8) != 0) {
            function2 = null;
        }
        this(stage, string, fileHandle, function2);
    }

    @NotNull
    public final FileFilter getFilter() {
        return this.filter;
    }

    public final void setFilter(@NotNull FileFilter value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.filter = value;
        this.resetList();
    }

    public final boolean getDirectoryBrowsingEnabled() {
        return this.directoryBrowsingEnabled;
    }

    public final void setDirectoryBrowsingEnabled(boolean value) {
        this.directoryBrowsingEnabled = value;
        this.resetList();
    }

    public final boolean getAllowFolderSelect() {
        return this.allowFolderSelect;
    }

    public final void setAllowFolderSelect(boolean value) {
        this.allowFolderSelect = value;
        this.resetList();
    }

    public final boolean getShowAbsolutePath() {
        return this.showAbsolutePath;
    }

    public final void setShowAbsolutePath(boolean value) {
        this.showAbsolutePath = value;
        this.resetList();
    }

    public final boolean getFileNameEnabled() {
        return this.fileNameCell.hasActor();
    }

    public final void setFileNameEnabled(boolean value) {
        if (value) {
            this.fileNameCell.setActor((Actor)this.fileNameWrapper);
        } else {
            this.fileNameCell.clearActor();
        }
    }

    @Override
    public float getMaxHeight() {
        return this.maxHeight;
    }

    private final void reportResult(boolean success) {
        FileHandle file = this.getResult();
        if (!(success && this.getFileNameEnabled() && file.exists())) {
            Function2<Boolean, FileHandle, Unit> function2 = this.resultListener;
            if (function2 != null) {
                function2.invoke(success, file);
            }
            return;
        }
        new ConfirmPopup(this.getStageToShowOn(), "Do you want to overwrite " + file.name() + '?', "Overwrite", false, (Function0)new Function0<Unit>(this, file){
            final /* synthetic */ FileChooser this$0;
            final /* synthetic */ FileHandle $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                super(0);
            }

            public final void invoke() {
                block0: {
                    Function2 function2 = FileChooser.access$getResultListener$p(this.this$0);
                    if (function2 == null) break block0;
                    function2.invoke(false, this.$file);
                }
            }
        }, (Function0)new Function0<Unit>(this, file){
            final /* synthetic */ FileChooser this$0;
            final /* synthetic */ FileHandle $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                super(0);
            }

            public final void invoke() {
                block0: {
                    Function2 function2 = FileChooser.access$getResultListener$p(this.this$0);
                    if (function2 == null) break block0;
                    function2.invoke(true, this.$file);
                }
            }
        }, 8, null).open(true);
    }

    private final FileHandle makeAbsolute(FileHandle file) {
        if (file.type() == Files.FileType.Absolute) {
            return file;
        }
        FileHandle fileHandle = Gdx.files.absolute(file.file().getAbsoluteFile().getCanonicalPath());
        Intrinsics.checkNotNullExpressionValue(fileHandle, "absolute(...)");
        return fileHandle;
    }

    private final FileHandle makeRelative(FileHandle file) {
        if (file.type() != Files.FileType.Absolute) {
            return file;
        }
        String path = file.path();
        Intrinsics.checkNotNull(path);
        String string = this.absoluteLocalPath;
        Intrinsics.checkNotNullExpressionValue(string, "absoluteLocalPath");
        if (StringsKt.startsWith$default(path, string, false, 2, null)) {
            String string2 = this.absoluteLocalPath;
            Intrinsics.checkNotNullExpressionValue(string2, "absoluteLocalPath");
            String string3 = StringsKt.removePrefix(path, (CharSequence)string2);
            String string4 = File.separator;
            Intrinsics.checkNotNullExpressionValue(string4, "separator");
            FileHandle fileHandle = Gdx.files.local(StringsKt.removePrefix(string3, (CharSequence)string4));
            Intrinsics.checkNotNullExpressionValue(fileHandle, "local(...)");
            return fileHandle;
        }
        String string5 = this.absoluteExternalPath;
        Intrinsics.checkNotNullExpressionValue(string5, "absoluteExternalPath");
        if (StringsKt.startsWith$default(path, string5, false, 2, null)) {
            String string6 = this.absoluteExternalPath;
            Intrinsics.checkNotNullExpressionValue(string6, "absoluteExternalPath");
            String string7 = StringsKt.removePrefix(path, (CharSequence)string6);
            String string8 = File.separator;
            Intrinsics.checkNotNullExpressionValue(string8, "separator");
            FileHandle fileHandle = Gdx.files.external(StringsKt.removePrefix(string7, (CharSequence)string8));
            Intrinsics.checkNotNullExpressionValue(fileHandle, "external(...)");
            return fileHandle;
        }
        return file;
    }

    private final void initialDirectory(FileHandle startFile) {
        FileHandle fileHandle;
        if (startFile == null && Gdx.files.isExternalStorageAvailable()) {
            fileHandle = Gdx.files.absolute(this.absoluteExternalPath);
        } else if (startFile == null) {
            fileHandle = Gdx.files.absolute(this.absoluteLocalPath);
        } else if (startFile.isDirectory()) {
            fileHandle = startFile;
        } else {
            this.fileNameInput.setText(startFile.name());
            this.result = startFile.name();
            fileHandle = startFile.parent();
        }
        FileHandle fileHandle2 = fileHandle;
        Intrinsics.checkNotNull(fileHandle2);
        this.changeDirectory(this.makeAbsolute(fileHandle2));
    }

    /*
     * Unable to fully structure code
     */
    private final void switchDomain() {
        block4: {
            block3: {
                v0 = this.currentDir;
                v1 = v0 != null ? v0.path() : null;
                if (v1 == null) {
                    return;
                }
                current = v1;
                if (Gdx.files.isExternalStorageAvailable()) break block3;
                v2 = this.absoluteLocalPath;
                break block4;
            }
            v3 = this.absoluteExternalPath;
            Intrinsics.checkNotNullExpressionValue(v3, "absoluteExternalPath");
            if (!StringsKt.startsWith$default(current, v3, false, 2, null)) ** GOTO lbl-1000
            v4 = this.absoluteLocalPath;
            Intrinsics.checkNotNullExpressionValue(v4, "absoluteLocalPath");
            if (!StringsKt.startsWith$default(current, v4, false, 2, null)) {
                v2 = this.absoluteLocalPath;
            } else lbl-1000:
            // 2 sources

            {
                v2 = this.absoluteExternalPath;
            }
        }
        var2_2 = Gdx.files.absolute(v2);
        Intrinsics.checkNotNullExpressionValue(var2_2, "absolute(...)");
        this.changeDirectory(var2_2);
    }

    private final void changeDirectory(FileHandle directory) {
        Pair<String, Color> pair;
        this.currentDir = directory;
        FileHandle relativeFile = this.showAbsolutePath ? directory : this.makeRelative(directory);
        Files.FileType fileType = relativeFile.type();
        switch (fileType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[fileType.ordinal()]) {
            case 1: {
                pair = TuplesKt.to("\u24ba", Color.CHARTREUSE);
                break;
            }
            case 2: {
                pair = TuplesKt.to("\u24c1", Color.TAN);
                break;
            }
            default: {
                pair = TuplesKt.to("", Color.WHITE);
            }
        }
        Pair<String, Color> pair2 = pair;
        String label2 = pair2.component1();
        Color color = pair2.component2();
        this.dirTypeLabel.setText(label2);
        this.dirTypeLabel.getColor().set(color);
        this.pathLabel.setText(relativeFile.path());
        FileHandle[] list2 = directory.list(this.filterWithFolders);
        Array<FileListItem> items2 = new Array<FileListItem>(list2.length);
        Intrinsics.checkNotNull(list2);
        for (FileHandle handle2 : list2) {
            if (!this.directoryBrowsingEnabled && handle2.isDirectory() || handle2.file().isHidden()) continue;
            Intrinsics.checkNotNull(handle2);
            items2.add(new FileListItem(handle2));
        }
        items2.sort(dirListComparator);
        if (this.directoryBrowsingEnabled && directory.file().getParentFile() != null) {
            FileHandle fileHandle = directory.parent();
            Intrinsics.checkNotNullExpressionValue(fileHandle, "parent(...)");
            items2.insert(0, new FileListItem("  ..", fileHandle, true));
        }
        this.fileList.setSelected(null);
        this.fileList.setItems(items2);
        this.enableOKButton();
    }

    private final FileHandle getResult() {
        FileHandle fileHandle;
        CharSequence charSequence = this.result;
        if (charSequence == null || charSequence.length() == 0) {
            FileHandle fileHandle2 = this.currentDir;
            fileHandle = fileHandle2;
            Intrinsics.checkNotNull(fileHandle2);
        } else {
            FileHandle fileHandle3 = this.currentDir;
            Intrinsics.checkNotNull(fileHandle3);
            fileHandle = fileHandle3.child(this.result);
        }
        FileHandle fileHandle4 = fileHandle;
        Intrinsics.checkNotNull(fileHandle4);
        return this.makeRelative(fileHandle4);
    }

    private final void resetList() {
        if (!this.hasParent()) {
            return;
        }
        FileHandle fileHandle = this.currentDir;
        Intrinsics.checkNotNull(fileHandle);
        this.changeDirectory(fileHandle);
    }

    private final void enableOKButton() {
        Scene2dExtensionsKt.setEnabled(this.okButton, this.getFileNameEnabled() ? FileChooser.enableOKButton$getSaveEnable(this) : FileChooser.enableOKButton$getLoadEnable(this));
    }

    public final void setOkButtonText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        this.okButton.setText(TranslationsKt.tr$default(text2, false, 1, null));
    }

    private static final boolean filter$lambda$0(File it) {
        return true;
    }

    private static final boolean filterWithFolders$lambda$3(FileChooser this$0, File it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.directoryBrowsingEnabled && it.isDirectory() || this$0.filter.accept(it);
    }

    private static final void _init_$lambda$4(FileChooser this$0, TextField textField, char c) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.result = textField.getText();
        this$0.enableOKButton();
    }

    private static final boolean _init_$lambda$5(TextField textField, char c) {
        return c != File.separatorChar;
    }

    private static final boolean enableOKButton$getLoadEnable(FileChooser this$0) {
        Object object = (FileListItem)this$0.fileList.getSelected();
        if (object == null || (object = ((FileListItem)object).getFile()) == null) {
            return false;
        }
        Object file = object;
        if (!((FileHandle)file).exists()) {
            return false;
        }
        return this$0.allowFolderSelect || !((FileHandle)file).isDirectory();
    }

    private static final boolean enableOKButton$getSaveEnable(FileChooser this$0) {
        boolean bl;
        FileHandle fileHandle = this$0.currentDir;
        if (!(fileHandle != null ? fileHandle.exists() : false)) {
            return false;
        }
        if (this$0.allowFolderSelect) {
            return true;
        }
        String string = this$0.result;
        if (string != null) {
            String $this$enableOKButton_u24getSaveEnable_u24lambda_u246 = string;
            boolean bl2 = false;
            boolean bl3 = ((CharSequence)$this$enableOKButton_u24getSaveEnable_u24lambda_u246).length() == 0 || StringsKt.startsWith$default((CharSequence)$this$enableOKButton_u24getSaveEnable_u24lambda_u246, ' ', false, 2, null) || StringsKt.endsWith$default((CharSequence)$this$enableOKButton_u24getSaveEnable_u24lambda_u246, ' ', false, 2, null);
            bl = !bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final int dirListComparator$lambda$7(FileListItem file1, FileListItem file2) {
        int n;
        if (file1.getFile().isDirectory() && !file2.getFile().isDirectory()) {
            n = -1;
        } else if (!file1.getFile().isDirectory() && file2.getFile().isDirectory()) {
            n = 1;
        } else {
            String string = file1.getFile().name();
            String string2 = file2.getFile().name();
            Intrinsics.checkNotNullExpressionValue(string2, "name(...)");
            n = string.compareTo(string2);
        }
        return n;
    }

    public static final /* synthetic */ Function2 access$getResultListener$p(FileChooser $this) {
        return $this.resultListener;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\fJf\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132@\b\u0002\u0010\u0014\u001a:\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0015j\u0004\u0018\u0001`\u001cJf\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132@\b\u0002\u0010\u0014\u001a:\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0015j\u0004\u0018\u0001`\u001cR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/unciv/logic/files/FileChooser$Companion;", "", "()V", "dirListComparator", "Ljava/util/Comparator;", "Lcom/unciv/logic/files/FileChooser$FileListItem;", "Lkotlin/Comparator;", "createExtensionFilter", "Ljava/io/FileFilter;", "extensions", "", "", "([Ljava/lang/String;)Ljava/io/FileFilter;", "createLoadDialog", "Lcom/unciv/logic/files/FileChooser;", "stage", "Lcom/badlogic/gdx/scenes/scene2d/Stage;", "title", "path", "Lcom/badlogic/gdx/files/FileHandle;", "resultListener", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "success", "file", "", "Lcom/unciv/logic/files/ResultListener;", "createSaveDialog", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileChooser createSaveDialog(@NotNull Stage stage, @Nullable String title, @Nullable FileHandle path, @Nullable Function2<? super Boolean, ? super FileHandle, Unit> resultListener) {
            FileChooser fileChooser;
            Intrinsics.checkNotNullParameter(stage, "stage");
            FileChooser $this$createSaveDialog_u24lambda_u240 = fileChooser = new FileChooser(stage, title, path, resultListener);
            boolean bl = false;
            $this$createSaveDialog_u24lambda_u240.setFileNameEnabled(true);
            $this$createSaveDialog_u24lambda_u240.setOkButtonText("Save");
            return fileChooser;
        }

        public static /* synthetic */ FileChooser createSaveDialog$default(Companion companion, Stage stage, String string, FileHandle fileHandle, Function2 function2, int n, Object object) {
            if ((n & 4) != 0) {
                fileHandle = null;
            }
            if ((n & 8) != 0) {
                function2 = null;
            }
            return companion.createSaveDialog(stage, string, fileHandle, function2);
        }

        @NotNull
        public final FileChooser createLoadDialog(@NotNull Stage stage, @Nullable String title, @Nullable FileHandle path, @Nullable Function2<? super Boolean, ? super FileHandle, Unit> resultListener) {
            FileChooser fileChooser;
            Intrinsics.checkNotNullParameter(stage, "stage");
            FileChooser $this$createLoadDialog_u24lambda_u241 = fileChooser = new FileChooser(stage, title, path, resultListener);
            boolean bl = false;
            $this$createLoadDialog_u24lambda_u241.setFileNameEnabled(false);
            $this$createLoadDialog_u24lambda_u241.setOkButtonText("Load");
            return fileChooser;
        }

        public static /* synthetic */ FileChooser createLoadDialog$default(Companion companion, Stage stage, String string, FileHandle fileHandle, Function2 function2, int n, Object object) {
            if ((n & 4) != 0) {
                fileHandle = null;
            }
            if ((n & 8) != 0) {
                function2 = null;
            }
            return companion.createLoadDialog(stage, string, fileHandle, function2);
        }

        @NotNull
        public final FileFilter createExtensionFilter(String ... extensions) {
            Intrinsics.checkNotNullParameter(extensions, "extensions");
            return arg_0 -> Companion.createExtensionFilter$lambda$2(extensions, arg_0);
        }

        private static final boolean createExtensionFilter$lambda$2(String[] $extensions, File it) {
            Intrinsics.checkNotNullParameter($extensions, "$extensions");
            Intrinsics.checkNotNull(it);
            String string = FilesKt.getExtension(it).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            return ArraysKt.contains($extensions, string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J@\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0016H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/unciv/logic/files/FileChooser$FileList;", "Lcom/badlogic/gdx/scenes/scene2d/ui/List;", "Lcom/unciv/logic/files/FileChooser$FileListItem;", "skin", "Lcom/badlogic/gdx/scenes/scene2d/ui/Skin;", "(Lcom/badlogic/gdx/scenes/scene2d/ui/Skin;)V", "folderColor", "Lcom/badlogic/gdx/graphics/Color;", "getFolderColor", "()Lcom/badlogic/gdx/graphics/Color;", "saveColor", "getSaveColor", "drawItem", "Lcom/badlogic/gdx/graphics/g2d/GlyphLayout;", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "font", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "index", "", "item", "x", "", "y", "width", "core"})
    private static final class FileList
    extends List<FileListItem> {
        @NotNull
        private final Color saveColor;
        @NotNull
        private final Color folderColor;

        public FileList(@NotNull Skin skin) {
            Intrinsics.checkNotNullParameter(skin, "skin");
            super(skin);
            this.saveColor = new Color();
            this.folderColor = new Color(1.0f, 0.86f, 0.5f, 1.0f);
        }

        @NotNull
        public final Color getSaveColor() {
            return this.saveColor;
        }

        @NotNull
        public final Color getFolderColor() {
            return this.folderColor;
        }

        @Override
        @NotNull
        protected GlyphLayout drawItem(@NotNull Batch batch, @NotNull BitmapFont font, int index, @NotNull FileListItem item, float x, float y, float width) {
            Intrinsics.checkNotNullParameter(batch, "batch");
            Intrinsics.checkNotNullParameter(font, "font");
            Intrinsics.checkNotNullParameter(item, "item");
            this.saveColor.set(font.getColor());
            font.setColor(item.isFolder() ? this.folderColor : Color.WHITE);
            GlyphLayout layout = super.drawItem(batch, font, index, item, x, y, width);
            font.setColor(this.saveColor);
            Intrinsics.checkNotNull(layout);
            return layout;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000f\u001a\u00020\u0006H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/unciv/logic/files/FileChooser$FileListItem;", "", "file", "Lcom/badlogic/gdx/files/FileHandle;", "(Lcom/badlogic/gdx/files/FileHandle;)V", "label", "", "isFolder", "", "(Ljava/lang/String;Lcom/badlogic/gdx/files/FileHandle;Z)V", "getFile", "()Lcom/badlogic/gdx/files/FileHandle;", "()Z", "getLabel", "()Ljava/lang/String;", "toString", "core"})
    private static final class FileListItem {
        @NotNull
        private final String label;
        @NotNull
        private final FileHandle file;
        private final boolean isFolder;

        public FileListItem(@NotNull String label2, @NotNull FileHandle file, boolean isFolder) {
            Intrinsics.checkNotNullParameter(label2, "label");
            Intrinsics.checkNotNullParameter(file, "file");
            this.label = label2;
            this.file = file;
            this.isFolder = isFolder;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @NotNull
        public final FileHandle getFile() {
            return this.file;
        }

        public final boolean isFolder() {
            return this.isFolder;
        }

        public FileListItem(@NotNull FileHandle file) {
            Intrinsics.checkNotNullParameter(file, "file");
            this((file.isDirectory() ? "  " : "") + file.name(), file, file.isDirectory());
        }

        @NotNull
        public String toString() {
            return this.label;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Files.FileType.values().length];
            try {
                nArray[Files.FileType.External.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Files.FileType.Local.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

