/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.files;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.SerializationException;
import com.unciv.UncivGame;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.GameInfo;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.GameInfoSerializationVersion;
import com.unciv.logic.UncivShowableException;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.civilization.managers.TurnManager;
import com.unciv.logic.files.Autosaves;
import com.unciv.logic.files.IncompatibleGameInfoVersionException;
import com.unciv.logic.files.LinuxX11SaverLoader;
import com.unciv.logic.files.PlatformSaverLoader;
import com.unciv.logic.files.UncivFiles;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.metadata.GameSettingsMigrationsKt;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.ui.screens.savescreens.Gzip;
import com.unciv.utils.Concurrency;
import com.unciv.utils.Log;
import com.unciv.utils.LogKt;
import java.io.File;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ?2\u00020\u0001:\u0001?B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\n2\b\b\u0002\u0010\u0019\u001a\u00020\u000eJ\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u0012H\u0002J\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\nJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u001fJ\u000e\u0010 \u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\nJ\u0018\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120\u001f2\b\b\u0002\u0010#\u001a\u00020\u000eJ\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00120\u001f2\u0006\u0010!\u001a\u00020\nH\u0002J \u0010$\u001a\u001c\u0012\u0018\u0012\u0016\u0012\f\u0012\n &*\u0004\u0018\u00010\u00120\u0012\u0012\u0004\u0012\u00020'0%0\u001fJ\u000e\u0010(\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\nJ2\u0010*\u001a\u00020+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020+0-2\u0016\u0010.\u001a\u0012\u0012\b\u0012\u00060/j\u0002`0\u0012\u0004\u0012\u00020+0-J\u000e\u00101\u001a\u00020)2\u0006\u0010\u0015\u001a\u00020\u0012J\u000e\u00102\u001a\u0002032\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u00104\u001a\u0002032\u0006\u0010\u0015\u001a\u00020\u0012J\u000e\u00105\u001a\u00020)2\u0006\u0010\u0015\u001a\u00020\u0012J\u000e\u00106\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\nJ4\u00107\u001a\u00020+2\u0006\u00108\u001a\u00020)2\u0006\u0010\u0011\u001a\u00020\u00122\u001c\b\u0002\u00109\u001a\u0016\u0012\f\u0012\n\u0018\u00010/j\u0004\u0018\u0001`0\u0012\u0004\u0012\u00020+0-J4\u00107\u001a\u00020\u00122\u0006\u00108\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\n2\u001c\b\u0002\u00109\u001a\u0016\u0012\f\u0012\n\u0018\u00010/j\u0004\u0018\u0001`0\u0012\u0004\u0012\u00020+0-J4\u00107\u001a\u00020+2\u0006\u00108\u001a\u0002032\u0006\u0010\u0011\u001a\u00020\u00122\u001c\b\u0002\u00109\u001a\u0016\u0012\f\u0012\n\u0018\u00010/j\u0004\u0018\u0001`0\u0012\u0004\u0012\u00020+0-J4\u00107\u001a\u00020\u00122\u0006\u00108\u001a\u0002032\u0006\u0010\u000f\u001a\u00020\n2\u001c\b\u0002\u00109\u001a\u0016\u0012\f\u0012\n\u0018\u00010/j\u0004\u0018\u0001`0\u0012\u0004\u0012\u00020+0-J<\u0010:\u001a\u00020+2\u0006\u00108\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\n2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020+0<2\u0016\u0010.\u001a\u0012\u0012\b\u0012\u00060/j\u0002`0\u0012\u0004\u0012\u00020+0-J\u000e\u0010=\u001a\u00020+2\u0006\u0010>\u001a\u00020\u001bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006@"}, d2={"Lcom/unciv/logic/files/UncivFiles;", "", "files", "Lcom/badlogic/gdx/Files;", "(Lcom/badlogic/gdx/Files;)V", "autosaves", "Lcom/unciv/logic/files/Autosaves;", "getAutosaves", "()Lcom/unciv/logic/files/Autosaves;", "scenarioFolder", "", "getScenarioFolder", "()Ljava/lang/String;", "deleteMultiplayerSave", "", "gameName", "deleteSave", "file", "Lcom/badlogic/gdx/files/FileHandle;", "emptyFile", "Lcom/badlogic/gdx/utils/SerializationException;", "gameFile", "fileWriter", "Ljava/io/Writer;", "path", "append", "getGeneralSettings", "Lcom/unciv/models/metadata/GameSettings;", "getGeneralSettingsFile", "getMultiplayerSave", "getMultiplayerSaves", "Lkotlin/sequences/Sequence;", "getSave", "saveFolder", "getSaves", "autoSaves", "getScenarioFiles", "Lkotlin/Pair;", "kotlin.jvm.PlatformType", "Lcom/unciv/models/ruleset/Ruleset;", "loadGameByName", "Lcom/unciv/logic/GameInfo;", "loadGameFromCustomLocation", "", "onLoaded", "Lkotlin/Function1;", "onError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "loadGameFromFile", "loadGamePreviewByName", "Lcom/unciv/logic/GameInfoPreview;", "loadGamePreviewFromFile", "loadScenario", "pathToFileHandler", "saveGame", "game", "saveCompletionCallback", "saveGameToCustomLocation", "onSaved", "Lkotlin/Function0;", "setGeneralSettings", "gameSettings", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nUncivFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UncivFiles.kt\ncom/unciv/logic/files/UncivFiles\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,501:1\n1#2:502\n2624#3,3:503\n223#3,2:506\n223#3,2:508\n*S KotlinDebug\n*F\n+ 1 UncivFiles.kt\ncom/unciv/logic/files/UncivFiles\n*L\n336#1:503,3\n337#1:506,2\n339#1:508,2\n*E\n"})
public final class UncivFiles {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Files files;
    @NotNull
    private final Autosaves autosaves;
    @NotNull
    private final String scenarioFolder;
    private static boolean saveZipped;
    private static boolean preferExternalStorage;
    @NotNull
    private static PlatformSaverLoader saverLoader;

    public UncivFiles(@NotNull Files files2) {
        Intrinsics.checkNotNullParameter(files2, "files");
        this.files = files2;
        Object[] objectArray = new Object[]{this.files.getLocalStoragePath(), this.files.getExternalStoragePath()};
        LogKt.debug("Creating UncivFiles, localStoragePath: %s, externalStoragePath: %s", objectArray);
        this.autosaves = new Autosaves(this);
        this.scenarioFolder = "scenarios";
    }

    @NotNull
    public final Autosaves getAutosaves() {
        return this.autosaves;
    }

    @NotNull
    public final FileHandle getSave(@NotNull String gameName) {
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        return this.getSave("SaveFiles", gameName);
    }

    @NotNull
    public final FileHandle getMultiplayerSave(@NotNull String gameName) {
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        return this.getSave("MultiplayerGames", gameName);
    }

    private final FileHandle getSave(String saveFolder, String gameName) {
        Object[] objectArray = new Object[]{gameName, saveFolder, preferExternalStorage, this.files.getExternalStoragePath()};
        LogKt.debug("Getting save %s from folder %s, preferExternal: %s", objectArray);
        String location = saveFolder + '/' + gameName;
        FileHandle localFile = this.files.local(location);
        FileHandle externalFile = this.files.external(location);
        FileHandle toReturn = this.files.isExternalStorageAvailable() && (externalFile.exists() && !localFile.exists() || preferExternalStorage && (externalFile.exists() || !localFile.exists())) ? externalFile : localFile;
        Object[] objectArray2 = new Object[]{toReturn.file().getAbsolutePath()};
        LogKt.debug("Save found: %s", objectArray2);
        Intrinsics.checkNotNull(toReturn);
        return toReturn;
    }

    @NotNull
    public final Writer fileWriter(@NotNull String path, boolean append2) {
        Intrinsics.checkNotNullParameter(path, "path");
        FileHandle file = this.pathToFileHandler(path);
        Writer writer = file.writer(append2, Charsets.UTF_8.name());
        Intrinsics.checkNotNullExpressionValue(writer, "writer(...)");
        return writer;
    }

    public static /* synthetic */ Writer fileWriter$default(UncivFiles uncivFiles, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return uncivFiles.fileWriter(string, bl);
    }

    @NotNull
    public final FileHandle pathToFileHandler(@NotNull String path) {
        FileHandle fileHandle;
        Intrinsics.checkNotNullParameter(path, "path");
        if (preferExternalStorage && this.files.isExternalStorageAvailable()) {
            FileHandle fileHandle2 = this.files.external(path);
            fileHandle = fileHandle2;
            Intrinsics.checkNotNullExpressionValue(fileHandle2, "external(...)");
        } else {
            FileHandle fileHandle3 = this.files.local(path);
            fileHandle = fileHandle3;
            Intrinsics.checkNotNullExpressionValue(fileHandle3, "local(...)");
        }
        return fileHandle;
    }

    @NotNull
    public final Sequence<FileHandle> getMultiplayerSaves() {
        return this.getSaves("MultiplayerGames");
    }

    @NotNull
    public final Sequence<FileHandle> getSaves(boolean autoSaves) {
        Sequence<FileHandle> saves = this.getSaves("SaveFiles");
        Sequence<FileHandle> filteredSaves2 = autoSaves ? saves : SequencesKt.filter(saves, getSaves.filteredSaves.1.INSTANCE);
        return filteredSaves2;
    }

    public static /* synthetic */ Sequence getSaves$default(UncivFiles uncivFiles, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return uncivFiles.getSaves(bl);
    }

    private final Sequence<FileHandle> getSaves(String saveFolder) {
        Sequence<Object> sequence;
        Object[] objectArray = new Object[]{saveFolder, this.files.getExternalStoragePath()};
        LogKt.debug("Getting saves from folder %s, externalStoragePath: %s", objectArray);
        FileHandle[] fileHandleArray = this.files.local(saveFolder).list();
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
        Sequence<Object> localFiles = ArraysKt.asSequence((Object[])fileHandleArray);
        if (this.files.isExternalStorageAvailable() && !Intrinsics.areEqual(this.files.local("").file().getAbsolutePath(), this.files.external("").file().getAbsolutePath())) {
            FileHandle[] fileHandleArray2 = this.files.external(saveFolder).list();
            Intrinsics.checkNotNullExpressionValue(fileHandleArray2, "list(...)");
            sequence = ArraysKt.asSequence((Object[])fileHandleArray2);
        } else {
            sequence = SequencesKt.emptySequence();
        }
        Sequence externalFiles = sequence;
        Object[] objectArray2 = new Object[]{new Function0<String>(localFiles){
            final /* synthetic */ Sequence<FileHandle> $localFiles;
            {
                this.$localFiles = $localFiles;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return SequencesKt.joinToString$default(this.$localFiles, null, "[", "]", 0, null, getSaves.1.INSTANCE, 25, null);
            }
        }, new Function0<String>(externalFiles){
            final /* synthetic */ Sequence<FileHandle> $externalFiles;
            {
                this.$externalFiles = $externalFiles;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return SequencesKt.joinToString$default(this.$externalFiles, null, "[", "]", 0, null, getSaves.1.INSTANCE, 25, null);
            }
        }};
        LogKt.debug("Local files: %s, external files: %s", objectArray2);
        return SequencesKt.plus(localFiles, externalFiles);
    }

    public final boolean deleteSave(@NotNull String gameName) {
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        return this.deleteSave(this.getSave(gameName));
    }

    public final boolean deleteMultiplayerSave(@NotNull String gameName) {
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        return this.deleteSave(this.getMultiplayerSave(gameName));
    }

    public final boolean deleteSave(@NotNull FileHandle file) {
        Intrinsics.checkNotNullParameter(file, "file");
        Object[] objectArray = new Object[]{file.path()};
        LogKt.debug("Deleting save %s", objectArray);
        return file.delete();
    }

    @NotNull
    public final FileHandle saveGame(@NotNull GameInfo game, @NotNull String gameName, @NotNull Function1<? super Exception, Unit> saveCompletionCallback) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        Intrinsics.checkNotNullParameter(saveCompletionCallback, "saveCompletionCallback");
        FileHandle file = this.getSave(gameName);
        this.saveGame(game, file, saveCompletionCallback);
        return file;
    }

    public static /* synthetic */ FileHandle saveGame$default(UncivFiles uncivFiles, GameInfo gameInfo2, String string, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = saveGame.1.INSTANCE;
        }
        return uncivFiles.saveGame(gameInfo2, string, (Function1<? super Exception, Unit>)function1);
    }

    public final void saveGame(@NotNull GameInfo game, @NotNull FileHandle file, @NotNull Function1<? super Exception, Unit> saveCompletionCallback) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(saveCompletionCallback, "saveCompletionCallback");
        try {
            Object[] objectArray = new Object[]{game.getGameId(), file.path()};
            LogKt.debug("Saving GameInfo %s to %s", objectArray);
            String string = com.unciv.logic.files.UncivFiles$Companion.gameInfoToString$default(Companion, game, null, false, 6, null);
            file.writeString(string, false, Charsets.UTF_8.name());
            saveCompletionCallback.invoke(null);
        }
        catch (Exception ex) {
            saveCompletionCallback.invoke(ex);
        }
    }

    public static /* synthetic */ void saveGame$default(UncivFiles uncivFiles, GameInfo gameInfo2, FileHandle fileHandle, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = saveGame.2.INSTANCE;
        }
        uncivFiles.saveGame(gameInfo2, fileHandle, (Function1<? super Exception, Unit>)function1);
    }

    @NotNull
    public final FileHandle saveGame(@NotNull GameInfoPreview game, @NotNull String gameName, @NotNull Function1<? super Exception, Unit> saveCompletionCallback) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        Intrinsics.checkNotNullParameter(saveCompletionCallback, "saveCompletionCallback");
        FileHandle file = this.getMultiplayerSave(gameName);
        this.saveGame(game, file, saveCompletionCallback);
        return file;
    }

    public static /* synthetic */ FileHandle saveGame$default(UncivFiles uncivFiles, GameInfoPreview gameInfoPreview, String string, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = saveGame.3.INSTANCE;
        }
        return uncivFiles.saveGame(gameInfoPreview, string, (Function1<? super Exception, Unit>)function1);
    }

    public final void saveGame(@NotNull GameInfoPreview game, @NotNull FileHandle file, @NotNull Function1<? super Exception, Unit> saveCompletionCallback) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(saveCompletionCallback, "saveCompletionCallback");
        try {
            Object[] objectArray = new Object[]{game.getGameId(), file.path()};
            LogKt.debug("Saving GameInfoPreview %s to %s", objectArray);
            UncivJsonKt.json().toJson((Object)game, file);
            saveCompletionCallback.invoke(null);
        }
        catch (Exception ex) {
            saveCompletionCallback.invoke(ex);
        }
    }

    public static /* synthetic */ void saveGame$default(UncivFiles uncivFiles, GameInfoPreview gameInfoPreview, FileHandle fileHandle, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = saveGame.4.INSTANCE;
        }
        uncivFiles.saveGame(gameInfoPreview, fileHandle, (Function1<? super Exception, Unit>)function1);
    }

    public final void saveGameToCustomLocation(@NotNull GameInfo game, @NotNull String gameName, @NotNull Function0<Unit> onSaved, @NotNull Function1<? super Exception, Unit> onError2) {
        Intrinsics.checkNotNullParameter(game, "game");
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        Intrinsics.checkNotNullParameter(onSaved, "onSaved");
        Intrinsics.checkNotNullParameter(onError2, "onError");
        String string = game.getCustomSaveLocation();
        if (string == null) {
            string = Gdx.files.local(gameName).path();
        }
        String saveLocation = string;
        try {
            String data2 = com.unciv.logic.files.UncivFiles$Companion.gameInfoToString$default(Companion, game, null, false, 6, null);
            Object[] objectArray = new Object[]{game.getGameId(), saveLocation};
            LogKt.debug("Initiating UI to save GameInfo %s to custom location %s", objectArray);
            PlatformSaverLoader platformSaverLoader = Companion.getSaverLoader();
            Intrinsics.checkNotNull(saveLocation);
            platformSaverLoader.saveGame(data2, saveLocation, (Function1<? super String, Unit>)new Function1<String, Unit>(game, onSaved){
                final /* synthetic */ GameInfo $game;
                final /* synthetic */ Function0<Unit> $onSaved;
                {
                    this.$game = $game;
                    this.$onSaved = $onSaved;
                    super(1);
                }

                public final void invoke(@NotNull String location) {
                    Intrinsics.checkNotNullParameter(location, "location");
                    this.$game.setCustomSaveLocation(location);
                    Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$onSaved, null){
                        int label;
                        final /* synthetic */ Function0<Unit> $onSaved;
                        {
                            this.$onSaved = $onSaved;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(object);
                                    this.$onSaved.invoke();
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 1, null);
                }
            }, (Function1<? super Exception, Unit>)new Function1<Exception, Unit>(onError2){
                final /* synthetic */ Function1<Exception, Unit> $onError;
                {
                    this.$onError = $onError;
                    super(1);
                }

                public final void invoke(@NotNull Exception it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$onError, it, null){
                        int label;
                        final /* synthetic */ Function1<Exception, Unit> $onError;
                        final /* synthetic */ Exception $it;
                        {
                            this.$onError = $onError;
                            this.$it = $it;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(object);
                                    this.$onError.invoke(this.$it);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 1, null);
                }
            });
        }
        catch (Exception ex) {
            Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(onError2, ex, null){
                int label;
                final /* synthetic */ Function1<Exception, Unit> $onError;
                final /* synthetic */ Exception $ex;
                {
                    this.$onError = $onError;
                    this.$ex = $ex;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            this.$onError.invoke(this.$ex);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
        }
    }

    @NotNull
    public final GameInfo loadGameByName(@NotNull String gameName) {
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        return this.loadGameFromFile(this.getSave(gameName));
    }

    @NotNull
    public final GameInfo loadGameFromFile(@NotNull FileHandle gameFile) {
        Intrinsics.checkNotNullParameter(gameFile, "gameFile");
        String gameData = gameFile.readString(Charsets.UTF_8.name());
        CharSequence charSequence = gameData;
        if (charSequence == null || StringsKt.isBlank(charSequence)) {
            throw this.emptyFile(gameFile);
        }
        Intrinsics.checkNotNull(gameData);
        return Companion.gameInfoFromString(gameData);
    }

    @NotNull
    public final GameInfoPreview loadGamePreviewByName(@NotNull String gameName) {
        Intrinsics.checkNotNullParameter(gameName, "gameName");
        return this.loadGamePreviewFromFile(this.getMultiplayerSave(gameName));
    }

    @NotNull
    public final GameInfoPreview loadGamePreviewFromFile(@NotNull FileHandle gameFile) {
        Intrinsics.checkNotNullParameter(gameFile, "gameFile");
        GameInfoPreview gameInfoPreview = UncivJsonKt.json().fromJson(GameInfoPreview.class, gameFile);
        if (gameInfoPreview == null) {
            throw this.emptyFile(gameFile);
        }
        return gameInfoPreview;
    }

    private final SerializationException emptyFile(FileHandle gameFile) {
        return new SerializationException("The file for the game " + gameFile.name() + " is empty");
    }

    public final void loadGameFromCustomLocation(@NotNull Function1<? super GameInfo, Unit> onLoaded, @NotNull Function1<? super Exception, Unit> onError2) {
        Intrinsics.checkNotNullParameter(onLoaded, "onLoaded");
        Intrinsics.checkNotNullParameter(onError2, "onError");
        Companion.getSaverLoader().loadGame((Function2<? super String, ? super String, Unit>)new Function2<String, String, Unit>(onLoaded, onError2){
            final /* synthetic */ Function1<GameInfo, Unit> $onLoaded;
            final /* synthetic */ Function1<Exception, Unit> $onError;
            {
                this.$onLoaded = $onLoaded;
                this.$onError = $onError;
                super(2);
            }

            public final void invoke(@NotNull String data2, @NotNull String location) {
                Intrinsics.checkNotNullParameter(data2, "data");
                Intrinsics.checkNotNullParameter(location, "location");
                try {
                    GameInfo game = UncivFiles.Companion.gameInfoFromString(data2);
                    game.setCustomSaveLocation(location);
                    Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$onLoaded, game, null){
                        int label;
                        final /* synthetic */ Function1<GameInfo, Unit> $onLoaded;
                        final /* synthetic */ GameInfo $game;
                        {
                            this.$onLoaded = $onLoaded;
                            this.$game = $game;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(object);
                                    this.$onLoaded.invoke(this.$game);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 1, null);
                }
                catch (Exception ex) {
                    Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$onError, ex, null){
                        int label;
                        final /* synthetic */ Function1<Exception, Unit> $onError;
                        final /* synthetic */ Exception $ex;
                        {
                            this.$onError = $onError;
                            this.$ex = $ex;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(object);
                                    this.$onError.invoke(this.$ex);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, 1, null);
                }
            }
        }, (Function1<? super Exception, Unit>)new Function1<Exception, Unit>(onError2){
            final /* synthetic */ Function1<Exception, Unit> $onError;
            {
                this.$onError = $onError;
                super(1);
            }

            public final void invoke(@NotNull Exception it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$onError, it, null){
                    int label;
                    final /* synthetic */ Function1<Exception, Unit> $onError;
                    final /* synthetic */ Exception $it;
                    {
                        this.$onError = $onError;
                        this.$it = $it;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                this.$onError.invoke(this.$it);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 1, null);
            }
        });
    }

    private final FileHandle getGeneralSettingsFile() {
        FileHandle fileHandle;
        if (UncivGame.Companion.getCurrent().isConsoleMode()) {
            fileHandle = new FileHandle("GameSettings.json");
        } else {
            FileHandle fileHandle2 = this.files.local("GameSettings.json");
            fileHandle = fileHandle2;
            Intrinsics.checkNotNullExpressionValue(fileHandle2, "local(...)");
        }
        return fileHandle;
    }

    @NotNull
    public final GameSettings getGeneralSettings() {
        GameSettings gameSettings;
        FileHandle settingsFile = this.getGeneralSettingsFile();
        GameSettings settings = null;
        if (settingsFile.exists()) {
            try {
                settings = UncivJsonKt.json().fromJson(GameSettings.class, settingsFile);
                if (GameSettingsMigrationsKt.isMigrationNecessary(settings)) {
                    JsonValue jsonValue = new JsonReader().parse(settingsFile);
                    Intrinsics.checkNotNullExpressionValue(jsonValue, "parse(...)");
                    GameSettingsMigrationsKt.doMigrations(settings, jsonValue);
                }
            }
            catch (Exception ex) {
                Log.INSTANCE.error("Error reading settings file", ex);
            }
        }
        if ((gameSettings = settings) == null) {
            GameSettings gameSettings2;
            GameSettings $this$getGeneralSettings_u24lambda_u240 = gameSettings2 = new GameSettings();
            boolean bl = false;
            $this$getGeneralSettings_u24lambda_u240.setFreshlyCreated(true);
            gameSettings = gameSettings2;
        }
        return gameSettings;
    }

    public final void setGeneralSettings(@NotNull GameSettings gameSettings) {
        Intrinsics.checkNotNullParameter(gameSettings, "gameSettings");
        this.getGeneralSettingsFile().writeString(UncivJsonKt.json().toJson(gameSettings), false, Charsets.UTF_8.name());
    }

    @NotNull
    public final String getScenarioFolder() {
        return this.scenarioFolder;
    }

    @NotNull
    public final Sequence<Pair<FileHandle, Ruleset>> getScenarioFiles() {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Pair<? extends FileHandle, ? extends Ruleset>>, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ UncivFiles this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        var3_4 = RulesetCache.INSTANCE.values().iterator();
                        while (var3_4.hasNext()) {
                            mod = var3_4.next();
                            if (mod.getFolderLocation() == null || !(scenarioFolder = modFolder.child(this.this$0.getScenarioFolder())).exists()) continue;
                            var8_10 = scenarioFolder.list();
                            Intrinsics.checkNotNullExpressionValue(var8_10, "list(...)");
                            var7_8 = var8_10;
                            var8_9 = 0;
                            var9_11 = var7_8.length;
lbl15:
                            // 2 sources

                            while (var8_9 < var9_11) {
                                file = var7_8[var8_9];
                                this.L$0 = $this$sequence;
                                this.L$1 = var3_4;
                                this.L$2 = mod;
                                this.L$3 = var7_8;
                                this.I$0 = var8_9;
                                this.I$1 = var9_11;
                                this.label = 1;
                                v0 = $this$sequence.yield(new Pair<FileHandle, Ruleset>(file, mod), this);
                                if (v0 == var11_2) {
                                    return var11_2;
                                }
                                ** GOTO lbl39
                            }
                        }
                        break;
                    }
                    case 1: {
                        var9_11 = this.I$1;
                        var8_9 = this.I$0;
                        var7_8 = (FileHandle[])this.L$3;
                        mod = (Ruleset)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl39:
                        // 2 sources

                        ++var8_9;
                        ** GOTO lbl15
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super Pair<? extends FileHandle, ? extends Ruleset>>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super Pair<? extends FileHandle, Ruleset>> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @NotNull
    public final GameInfo loadScenario(@NotNull FileHandle gameFile) {
        GameInfo gameInfo2;
        Object element$iv2;
        GameInfo game;
        block9: {
            boolean $i$f$first;
            Iterable $this$first$iv;
            Civilization it;
            boolean bl;
            block7: {
                Intrinsics.checkNotNullParameter(gameFile, "gameFile");
                game = this.loadGameFromFile(gameFile);
                CollectionsKt.removeAll(game.getCivilizations(), (Function1)loadScenario.1.INSTANCE);
                for (Civilization civ : game.getCivilizations()) {
                    civ.getDiplomacy().remove("Spectator");
                }
                Iterable $this$none$iv = game.getCivilizations();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$none$iv) {
                        it = (Civilization)element$iv2;
                        boolean bl2 = false;
                        if (!it.isHuman()) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
            if (bl) {
                block8: {
                    $this$first$iv = game.getCivilizations();
                    $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        it = (Civilization)element$iv2;
                        boolean bl3 = false;
                        if (!it.isMajorCiv()) continue;
                        break block8;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                ((Civilization)element$iv2).setPlayerType(PlayerType.Human);
            }
            $this$first$iv = game.getCivilizations();
            gameInfo2 = game;
            $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                it = (Civilization)element$iv2;
                boolean bl4 = false;
                if (!(it.getPlayerType() == PlayerType.Human)) continue;
                break block9;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        gameInfo2.setCurrentPlayerCiv((Civilization)element$iv2);
        game.setCurrentPlayer(game.getCurrentPlayerCiv().getCivName());
        TurnManager.startTurn$default(new TurnManager(game.getCurrentPlayerCiv()), null, 1, null);
        return game;
    }

    static {
        saverLoader = PlatformSaverLoader.Companion.getNone();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015J)\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00132\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0017J\u0010\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u0015R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001c\u0010\f\u001a\u00020\r8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/unciv/logic/files/UncivFiles$Companion;", "", "()V", "preferExternalStorage", "", "getPreferExternalStorage", "()Z", "setPreferExternalStorage", "(Z)V", "saveZipped", "getSaveZipped", "setSaveZipped", "saverLoader", "Lcom/unciv/logic/files/PlatformSaverLoader;", "getSaverLoader", "()Lcom/unciv/logic/files/PlatformSaverLoader;", "setSaverLoader", "(Lcom/unciv/logic/files/PlatformSaverLoader;)V", "gameInfoFromString", "Lcom/unciv/logic/GameInfo;", "gameData", "", "gameInfoPreviewFromString", "Lcom/unciv/logic/GameInfoPreview;", "gameInfoToString", "game", "forceZip", "updateChecksum", "(Lcom/unciv/logic/GameInfo;Ljava/lang/Boolean;Z)Ljava/lang/String;", "getSettingsForPlatformLaunchers", "Lcom/unciv/models/metadata/GameSettings;", "base", "core"})
    @SourceDebugExtension(value={"SMAP\nUncivFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UncivFiles.kt\ncom/unciv/logic/files/UncivFiles$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,501:1\n1#2:502\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getSaveZipped() {
            return saveZipped;
        }

        public final void setSaveZipped(boolean bl) {
            saveZipped = bl;
        }

        public final boolean getPreferExternalStorage() {
            return preferExternalStorage;
        }

        public final void setPreferExternalStorage(boolean bl) {
            preferExternalStorage = bl;
        }

        @NotNull
        public final PlatformSaverLoader getSaverLoader() {
            if (Intrinsics.areEqual(saverLoader.getClass().getSimpleName(), "DesktopSaverLoader") && LinuxX11SaverLoader.Companion.isRequired()) {
                saverLoader = new LinuxX11SaverLoader();
            }
            return saverLoader;
        }

        public final void setSaverLoader(@NotNull PlatformSaverLoader platformSaverLoader) {
            Intrinsics.checkNotNullParameter(platformSaverLoader, "<set-?>");
            saverLoader = platformSaverLoader;
        }

        @NotNull
        public final GameSettings getSettingsForPlatformLaunchers(@NotNull String base) {
            GameSettings gameSettings;
            Intrinsics.checkNotNullParameter(base, "base");
            FileHandle file = new FileHandle(base + File.separator + "GameSettings.json");
            if (file.exists()) {
                gameSettings = UncivJsonKt.fromJsonFile(UncivJsonKt.json(), GameSettings.class, file);
            } else {
                GameSettings gameSettings2;
                GameSettings $this$getSettingsForPlatformLaunchers_u24lambda_u240 = gameSettings2 = new GameSettings();
                boolean bl = false;
                $this$getSettingsForPlatformLaunchers_u24lambda_u240.setFreshlyCreated(true);
                gameSettings = gameSettings2;
            }
            return gameSettings;
        }

        public static /* synthetic */ GameSettings getSettingsForPlatformLaunchers$default(Companion companion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = ".";
            }
            return companion.getSettingsForPlatformLaunchers(string);
        }

        @NotNull
        public final GameInfo gameInfoFromString(@NotNull String gameData) {
            GameInfo gameInfo2;
            String string;
            Intrinsics.checkNotNullParameter(gameData, "gameData");
            try {
                string = Gzip.INSTANCE.unzip(((Object)StringsKt.trim((CharSequence)gameData)).toString());
            }
            catch (Exception _) {
                string = ((Object)StringsKt.trim((CharSequence)gameData)).toString();
            }
            String unzippedJson = string;
            try {
                gameInfo2 = UncivJsonKt.json().fromJson(GameInfo.class, unzippedJson);
            }
            catch (Exception ex) {
                Log.INSTANCE.error("Exception while deserializing GameInfo JSON", ex);
                GameInfoSerializationVersion onlyVersion = UncivJsonKt.json().fromJson(GameInfoSerializationVersion.class, unzippedJson);
                throw new IncompatibleGameInfoVersionException(onlyVersion.getVersion(), (Throwable)ex);
            }
            GameInfo gameInfo3 = gameInfo2;
            if (gameInfo3 == null) {
                throw new UncivShowableException("The file data seems to be corrupted.", null, 2, null);
            }
            GameInfo gameInfo4 = gameInfo3;
            if (gameInfo4.getVersion().compareTo(GameInfo.Companion.getCURRENT_COMPATIBILITY_VERSION()) > 0) {
                throw new IncompatibleGameInfoVersionException(gameInfo4.getVersion(), null, 2, null);
            }
            gameInfo4.setTransients();
            return gameInfo4;
        }

        @NotNull
        public final GameInfoPreview gameInfoPreviewFromString(@NotNull String gameData) {
            Intrinsics.checkNotNullParameter(gameData, "gameData");
            GameInfoPreview gameInfoPreview = UncivJsonKt.json().fromJson(GameInfoPreview.class, Gzip.INSTANCE.unzip(gameData));
            Intrinsics.checkNotNullExpressionValue(gameInfoPreview, "fromJson(...)");
            return gameInfoPreview;
        }

        @NotNull
        public final String gameInfoToString(@NotNull GameInfo game, @Nullable Boolean forceZip, boolean updateChecksum) {
            String string;
            Intrinsics.checkNotNullParameter(game, "game");
            game.setVersion(GameInfo.Companion.getCURRENT_COMPATIBILITY_VERSION());
            if (updateChecksum) {
                game.setChecksum(game.calculateChecksum());
            }
            String plainJson = UncivJsonKt.json().toJson(game);
            Boolean bl = forceZip;
            if (bl != null ? bl.booleanValue() : this.getSaveZipped()) {
                Intrinsics.checkNotNull(plainJson);
                string = Gzip.INSTANCE.zip(plainJson);
            } else {
                Intrinsics.checkNotNull(plainJson);
                string = plainJson;
            }
            return string;
        }

        public static /* synthetic */ String gameInfoToString$default(Companion companion, GameInfo gameInfo2, Boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = null;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            return companion.gameInfoToString(gameInfo2, bl, bl2);
        }

        @NotNull
        public final String gameInfoToString(@NotNull GameInfoPreview game) {
            Intrinsics.checkNotNullParameter(game, "game");
            String string = UncivJsonKt.json().toJson(game);
            Intrinsics.checkNotNullExpressionValue(string, "toJson(...)");
            return Gzip.INSTANCE.zip(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

