/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.github;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.Json;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.BackwardCompatibility;
import com.unciv.logic.UncivShowableException;
import com.unciv.logic.github.Github;
import com.unciv.logic.github.GithubAPI;
import com.unciv.logic.github.RateLimit;
import com.unciv.logic.github.Zip;
import com.unciv.models.ruleset.ModOptions;
import com.unciv.utils.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00042\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0002J$\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00040\u001a2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u0016\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0010J\"\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00152\b\b\u0002\u0010\"\u001a\u00020\u0004J\b\u0010#\u001a\u0004\u0018\u00010$J\"\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00042\b\u0010)\u001a\u0004\u0018\u00010\u0004J\n\u0010*\u001a\u00020\u0004*\u00020\u0004J\u0014\u0010+\u001a\u00020\u000e*\u00020\u00102\u0006\u0010,\u001a\u00020\u0010H\u0002J\u0014\u0010-\u001a\u00020\u0004*\u00020\u00042\b\b\u0002\u0010.\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/unciv/logic/github/Github;", "", "()V", "attachmentDispositionPrefix", "", "contentDispositionHeader", "outerBlankReplacement", "", "download", "Ljava/io/InputStream;", "url", "action", "Lkotlin/Function1;", "Ljava/net/HttpURLConnection;", "", "downloadAndExtract", "Lcom/badlogic/gdx/files/FileHandle;", "repo", "Lcom/unciv/logic/github/GithubAPI$Repo;", "folderFileHandle", "getRepoSize", "", "isValidModFolder", "", "dir", "resolveZipStructure", "Lkotlin/Pair;", "defaultModName", "rewriteModOptions", "modFolder", "tryGetGithubReposWithTopic", "Lcom/unciv/logic/github/GithubAPI$RepoSearch;", "amountPerPage", "page", "searchRequest", "tryGetGithubTopics", "Lcom/unciv/logic/github/GithubAPI$TopicSearchResponse;", "tryGetPreviewImage", "Lcom/badlogic/gdx/graphics/Pixmap;", "modUrl", "defaultBranch", "avatarUrl", "folderNameToRepoName", "renameOrMove", "dest", "repoNameToFolderName", "onlyOuterBlanks", "core"})
@SourceDebugExtension(value={"SMAP\nGithub.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Github.kt\ncom/unciv/logic/github/Github\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,357:1\n6442#2:358\n1549#3:359\n1620#3,3:360\n1549#3:363\n1620#3,3:364\n1747#3,3:367\n1#4:370\n*S KotlinDebug\n*F\n+ 1 Github.kt\ncom/unciv/logic/github/Github\n*L\n139#1:358\n154#1:359\n154#1:360,3\n156#1:363\n156#1:364,3\n161#1:367,3\n*E\n"})
public final class Github {
    @NotNull
    public static final Github INSTANCE = new Github();
    @NotNull
    private static final String contentDispositionHeader = "Content-Disposition";
    @NotNull
    private static final String attachmentDispositionPrefix = "attachment;filename=";
    private static final char outerBlankReplacement = '=';

    private Github() {
    }

    @Nullable
    public final InputStream download(@NotNull String url2, @NotNull Function1<? super HttpURLConnection, Unit> action2) {
        Intrinsics.checkNotNullParameter(url2, "url");
        Intrinsics.checkNotNullParameter(action2, "action");
        try {
            URLConnection uRLConnection = new URL(url2).openConnection();
            Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection $this$download_u24lambda_u240 = (HttpURLConnection)uRLConnection;
            boolean bl = false;
            action2.invoke($this$download_u24lambda_u240);
            try {
                return $this$download_u24lambda_u240.getInputStream();
            }
            catch (Exception ex) {
                BufferedReader reader = new BufferedReader(new InputStreamReader($this$download_u24lambda_u240.getErrorStream(), Charsets.UTF_8));
                Object[] objectArray = new Object[]{TextStreamsKt.readText(reader)};
                Log.INSTANCE.error("Message from GitHub: %s", objectArray);
                throw ex;
            }
        }
        catch (Exception ex) {
            Log.INSTANCE.error("Exception during GitHub download", ex);
            return null;
        }
    }

    public static /* synthetic */ InputStream download$default(Github github, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = download.1.INSTANCE;
        }
        return github.download(string, function1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FileHandle downloadAndExtract(@NotNull GithubAPI.Repo repo, @NotNull FileHandle folderFileHandle) {
        void $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter(repo, "repo");
        Intrinsics.checkNotNullParameter(folderFileHandle, "folderFileHandle");
        Ref.ObjectRef<String> modNameFromFileName = new Ref.ObjectRef<String>();
        modNameFromFileName.element = repo.getName();
        String defaultBranch = repo.getDefault_branch();
        String zipUrl = null;
        String tempName = null;
        if (((CharSequence)repo.getDirect_zip_url()).length() == 0) {
            String gitRepoUrl = repo.getHtml_url();
            zipUrl = GithubAPI.INSTANCE.getUrlForBranchZip$core(gitRepoUrl, defaultBranch);
            StringBuilder stringBuilder = new StringBuilder().append("temp-");
            String string = Integer.toString(gitRepoUrl.hashCode(), CharsKt.checkRadix(16));
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            tempName = stringBuilder.append(string).toString();
        } else {
            zipUrl = repo.getDirect_zip_url();
            StringBuilder stringBuilder = new StringBuilder().append("temp-");
            String string = Integer.toString(repo.toString().hashCode(), CharsKt.checkRadix(16));
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            tempName = stringBuilder.append(string).toString();
        }
        InputStream inputStream2 = this.download(zipUrl, (Function1<? super HttpURLConnection, Unit>)new Function1<HttpURLConnection, Unit>(modNameFromFileName){
            final /* synthetic */ Ref.ObjectRef<String> $modNameFromFileName;
            {
                this.$modNameFromFileName = $modNameFromFileName;
                super(1);
            }

            public final void invoke(@NotNull HttpURLConnection it) {
                Intrinsics.checkNotNullParameter(it, "it");
                String disposition = it.getHeaderField("Content-Disposition");
                Intrinsics.checkNotNull(disposition);
                if (StringsKt.startsWith$default(disposition, "attachment;filename=", false, 2, null)) {
                    this.$modNameFromFileName.element = StringsKt.replace$default(StringsKt.removeSuffix(StringsKt.removePrefix(disposition, (CharSequence)"attachment;filename="), (CharSequence)".zip"), '.', ' ', false, 4, null);
                }
            }
        });
        if (inputStream2 == null) {
            return null;
        }
        InputStream inputStream3 = inputStream2;
        FileHandle tempZipFileHandle = folderFileHandle.child(tempName + ".zip");
        tempZipFileHandle.write(inputStream3, false);
        FileHandle unzipDestination = tempZipFileHandle.sibling(tempName);
        if (unzipDestination.exists()) {
            if (unzipDestination.isDirectory()) {
                unzipDestination.deleteDirectory();
            } else {
                unzipDestination.delete();
            }
        }
        try {
            Intrinsics.checkNotNull(tempZipFileHandle);
            Intrinsics.checkNotNull(unzipDestination);
            Zip.INSTANCE.extractFolder(tempZipFileHandle, unzipDestination);
        }
        catch (ZipException ex) {
            throw new UncivShowableException("That is not a valid ZIP file", ex);
        }
        Pair<FileHandle, String> pair = this.resolveZipStructure(unzipDestination, (String)modNameFromFileName.element);
        FileHandle innerFolder = pair.component1();
        String modName = pair.component2();
        String finalDestinationName = Github.repoNameToFolderName$default(this, StringsKt.replace$default(modName, '-' + defaultBranch, "", false, 4, null), false, 1, null);
        FileHandle finalDestination = folderFileHandle.child(finalDestinationName);
        FileHandle tempBackup = null;
        if (finalDestination.exists()) {
            tempBackup = finalDestination.sibling(finalDestinationName + ".updating");
            Intrinsics.checkNotNull(finalDestination);
            this.renameOrMove(finalDestination, tempBackup);
        }
        finalDestination.mkdirs();
        FileHandle[] fileHandleArray = innerFolder.list();
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
        Object[] objectArray = fileHandleArray;
        boolean $i$f$sortedBy = false;
        for (FileHandle innerFileOrFolder : ArraysKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                FileHandle file = (FileHandle)a;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(Intrinsics.areEqual(file.extension(), "atlas"));
                file = (FileHandle)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, Intrinsics.areEqual(file.extension(), "atlas"));
            }
        })) {
            Intrinsics.checkNotNull(innerFileOrFolder);
            Intrinsics.checkNotNull(finalDestination);
            this.renameOrMove(innerFileOrFolder, finalDestination);
        }
        tempZipFileHandle.delete();
        unzipDestination.deleteDirectory();
        if (tempBackup != null) {
            if (tempBackup.isDirectory()) {
                tempBackup.deleteDirectory();
            } else {
                tempBackup.delete();
            }
        }
        return finalDestination;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isValidModFolder(FileHandle dir) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        String[] stringArray = new String[]{"Images", "jsons", "maps", "music", "sounds", "Images\\..*"};
        Iterable $this$map$iv2 = CollectionsKt.listOf(stringArray);
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Regex((String)it, RegexOption.IGNORE_CASE));
        }
        List goodFolders = (List)destination$iv$iv;
        Object $i$f$map22 = new String[]{".*\\.atlas", ".*\\.png", "preview.jpg", ".*\\.md", "Atlases.json", ".nomedia", "license"};
        $i$f$map22 = CollectionsKt.listOf($i$f$map22);
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String bl = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(new Regex((String)it, RegexOption.IGNORE_CASE));
        }
        List goodFiles = (List)destination$iv$iv2;
        int good = 0;
        int bad = 0;
        FileHandle[] fileHandleArray = dir.list();
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
        for (FileHandle file : fileHandleArray) {
            boolean bl;
            block7: {
                List goodList = file.isDirectory() ? goodFolders : goodFiles;
                Iterable $this$any$iv = goodList;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Regex it = (Regex)element$iv;
                        boolean bl3 = false;
                        String string = file.name();
                        Intrinsics.checkNotNullExpressionValue(string, "name(...)");
                        if (!it.matches(string)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                ++good;
                continue;
            }
            ++bad;
        }
        return good > 0 && good > bad;
    }

    private final Pair<FileHandle, String> resolveZipStructure(FileHandle dir, String defaultModName) {
        if (this.isValidModFolder(dir)) {
            return TuplesKt.to(dir, defaultModName);
        }
        FileHandle[] subdirs = dir.list(Github::resolveZipStructure$lambda$5);
        if (subdirs.length == 1) {
            FileHandle fileHandle = subdirs[0];
            Intrinsics.checkNotNullExpressionValue(fileHandle, "get(...)");
            if (this.isValidModFolder(fileHandle)) {
                return TuplesKt.to(subdirs[0], subdirs[0].name());
            }
        }
        throw new UncivShowableException("Invalid Mod archive structure", null, 2, null);
    }

    private final void renameOrMove(FileHandle $this$renameOrMove, FileHandle dest) {
        if ($this$renameOrMove.type() == Files.FileType.Local && $this$renameOrMove.isDirectory()) {
            if ($this$renameOrMove.file().renameTo(dest.child($this$renameOrMove.name()).file())) {
                return;
            }
            if ($this$renameOrMove.file().renameTo(dest.file())) {
                return;
            }
        }
        $this$renameOrMove.moveTo(dest);
    }

    @Nullable
    public final GithubAPI.RepoSearch tryGetGithubReposWithTopic(int amountPerPage, int page, @NotNull String searchRequest) {
        Intrinsics.checkNotNullParameter(searchRequest, "searchRequest");
        String link = GithubAPI.INSTANCE.getUrlForModListing$core(searchRequest, amountPerPage, page);
        Ref.IntRef retries = new Ref.IntRef();
        retries.element = 2;
        while (retries.element > 0) {
            int n = retries.element;
            retries.element = n + -1;
            if (RateLimit.INSTANCE.waitForLimit()) {
                return null;
            }
            InputStream inputStream2 = this.download(link, (Function1<? super HttpURLConnection, Unit>)new Function1<HttpURLConnection, Unit>(page, retries){
                final /* synthetic */ int $page;
                final /* synthetic */ Ref.IntRef $retries;
                {
                    this.$page = $page;
                    this.$retries = $retries;
                    super(1);
                }

                public final void invoke(@NotNull HttpURLConnection it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    if (it.getResponseCode() == 403 || it.getResponseCode() == 200 && this.$page == 1 && this.$retries.element == 1) {
                        RateLimit.INSTANCE.notifyHttpResponse(it);
                        int n = this.$retries.element;
                        this.$retries.element = n + 1;
                    }
                }
            });
            if (inputStream2 == null) continue;
            InputStream inputStream3 = inputStream2;
            InputStream inputStream4 = inputStream3;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream4, charset);
            int n2 = 8192;
            return UncivJsonKt.json().fromJson(GithubAPI.RepoSearch.class, TextStreamsKt.readText(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2)));
        }
        return null;
    }

    public static /* synthetic */ GithubAPI.RepoSearch tryGetGithubReposWithTopic$default(Github github, int n, int n2, String string, int n3, Object object) {
        if ((n3 & 4) != 0) {
            string = "";
        }
        return github.tryGetGithubReposWithTopic(n, n2, string);
    }

    @Nullable
    public final Pixmap tryGetPreviewImage(@NotNull String modUrl, @NotNull String defaultBranch, @Nullable String avatarUrl) {
        Intrinsics.checkNotNullParameter(modUrl, "modUrl");
        Intrinsics.checkNotNullParameter(defaultBranch, "defaultBranch");
        String fileLocation = GithubAPI.INSTANCE.getUrlForPreview$core(modUrl, defaultBranch);
        try {
            InputStream inputStream2 = Github.download$default(this, fileLocation + ".jpg", null, 2, null);
            if (inputStream2 == null && (inputStream2 = Github.download$default(this, fileLocation + ".png", null, 2, null)) == null) {
                InputStream inputStream3;
                String string = avatarUrl;
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    inputStream3 = Github.download$default(INSTANCE, it, null, 2, null);
                } else {
                    inputStream3 = inputStream2 = null;
                }
                if (inputStream3 == null) {
                    return null;
                }
            }
            InputStream file = inputStream2;
            byte[] byteArray = ByteStreamsKt.readBytes(file);
            ByteBuffer buffer = ByteBuffer.allocateDirect(byteArray.length).put(byteArray).position(0);
            return new Pixmap(buffer);
        }
        catch (Throwable _) {
            return null;
        }
    }

    public final int getRepoSize(@NotNull GithubAPI.Repo repo) {
        Intrinsics.checkNotNullParameter(repo, "repo");
        String link = GithubAPI.INSTANCE.getUrlForTreeQuery$core(repo);
        Ref.IntRef retries = new Ref.IntRef();
        retries.element = 2;
        while (retries.element > 0) {
            int n = retries.element;
            retries.element = n + -1;
            if (RateLimit.INSTANCE.waitForLimit()) {
                return -1;
            }
            InputStream inputStream2 = this.download(link, (Function1<? super HttpURLConnection, Unit>)new Function1<HttpURLConnection, Unit>(retries){
                final /* synthetic */ Ref.IntRef $retries;
                {
                    this.$retries = $retries;
                    super(1);
                }

                public final void invoke(@NotNull HttpURLConnection it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    if (it.getResponseCode() == 403 || it.getResponseCode() == 200 && this.$retries.element == 1) {
                        RateLimit.INSTANCE.notifyHttpResponse(it);
                        int n = this.$retries.element;
                        this.$retries.element = n + 1;
                    }
                }
            });
            if (inputStream2 == null) continue;
            InputStream inputStream3 = inputStream2;
            InputStream inputStream4 = inputStream3;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream4, charset);
            int n2 = 8192;
            GithubAPI.Tree tree = UncivJsonKt.json().fromJson(GithubAPI.Tree.class, TextStreamsKt.readText(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2)));
            if (tree.getTruncated()) {
                return -1;
            }
            long totalSizeBytes = 0L;
            for (GithubAPI.Tree.TreeFile file : tree.getTree()) {
                totalSizeBytes += file.getSize();
            }
            return (int)((totalSizeBytes + (long)512) / (long)1024);
        }
        return -1;
    }

    @Nullable
    public final GithubAPI.TopicSearchResponse tryGetGithubTopics() {
        String link = "https://api.github.com/search/topics?q=unciv-mod+repositories:%3E1&sort=name&order=asc";
        Ref.IntRef retries = new Ref.IntRef();
        retries.element = 2;
        while (retries.element > 0) {
            int n = retries.element;
            retries.element = n + -1;
            if (RateLimit.INSTANCE.waitForLimit()) {
                return null;
            }
            InputStream inputStream2 = this.download(link, (Function1<? super HttpURLConnection, Unit>)new Function1<HttpURLConnection, Unit>(retries){
                final /* synthetic */ Ref.IntRef $retries;
                {
                    this.$retries = $retries;
                    super(1);
                }

                public final void invoke(@NotNull HttpURLConnection it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    if (it.getResponseCode() == 403 || it.getResponseCode() == 200 && this.$retries.element == 1) {
                        RateLimit.INSTANCE.notifyHttpResponse(it);
                        int n = this.$retries.element;
                        this.$retries.element = n + 1;
                    }
                }
            });
            if (inputStream2 == null) continue;
            InputStream inputStream3 = inputStream2;
            InputStream inputStream4 = inputStream3;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream4, charset);
            int n2 = 8192;
            return UncivJsonKt.json().fromJson(GithubAPI.TopicSearchResponse.class, TextStreamsKt.readText(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2)));
        }
        return null;
    }

    public final void rewriteModOptions(@NotNull GithubAPI.Repo repo, @NotNull FileHandle modFolder) {
        boolean overwriteAlways;
        ModOptions modOptions;
        Intrinsics.checkNotNullParameter(repo, "repo");
        Intrinsics.checkNotNullParameter(modFolder, "modFolder");
        FileHandle modOptionsFile = modFolder.child("jsons/ModOptions.json");
        if (modOptionsFile.exists()) {
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(modOptionsFile);
            modOptions = UncivJsonKt.fromJsonFile(json, ModOptions.class, modOptionsFile);
        } else {
            modOptions = new ModOptions();
        }
        ModOptions modOptions2 = modOptions;
        boolean bl = overwriteAlways = ((CharSequence)repo.getDirect_zip_url()).length() == 0;
        if (overwriteAlways || ((CharSequence)modOptions2.getModUrl()).length() == 0) {
            modOptions2.setModUrl(repo.getHtml_url());
        }
        if (overwriteAlways || Intrinsics.areEqual(modOptions2.getDefaultBranch(), "master") && ((CharSequence)repo.getDefault_branch()).length() > 0) {
            modOptions2.setDefaultBranch(repo.getDefault_branch());
        }
        if (overwriteAlways || ((CharSequence)modOptions2.getLastUpdated()).length() == 0) {
            modOptions2.setLastUpdated(repo.getPushed_at());
        }
        if (overwriteAlways || ((CharSequence)modOptions2.getAuthor()).length() == 0) {
            modOptions2.setAuthor(repo.getOwner().getLogin());
        }
        if (overwriteAlways || modOptions2.getModSize() == 0) {
            modOptions2.setModSize(repo.getSize());
        }
        if (overwriteAlways || modOptions2.getTopics().isEmpty()) {
            modOptions2.setTopics(repo.getTopics());
        }
        BackwardCompatibility.INSTANCE.updateDeprecations(modOptions2);
        UncivJsonKt.json().toJson((Object)modOptions2, modOptionsFile);
    }

    @NotNull
    public final String repoNameToFolderName(@NotNull String $this$repoNameToFolderName, boolean onlyOuterBlanks) {
        String result2;
        Intrinsics.checkNotNullParameter($this$repoNameToFolderName, "<this>");
        String string = result2 = onlyOuterBlanks ? $this$repoNameToFolderName : StringsKt.replace$default($this$repoNameToFolderName, '-', ' ', false, 4, null);
        if (StringsKt.endsWith$default((CharSequence)result2, ' ', false, 2, null)) {
            result2 = ((Object)StringsKt.trimEnd((CharSequence)result2)).toString() + '=';
        }
        if (StringsKt.startsWith$default((CharSequence)result2, ' ', false, 2, null)) {
            char c = '=';
            String string2 = ((Object)StringsKt.trimStart((CharSequence)result2)).toString();
            result2 = c + string2;
        }
        return result2;
    }

    public static /* synthetic */ String repoNameToFolderName$default(Github github, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return github.repoNameToFolderName(string, bl);
    }

    @NotNull
    public final String folderNameToRepoName(@NotNull String $this$folderNameToRepoName) {
        Intrinsics.checkNotNullParameter($this$folderNameToRepoName, "<this>");
        String result2 = StringsKt.replace$default($this$folderNameToRepoName, ' ', '-', false, 4, null);
        if (StringsKt.endsWith$default((CharSequence)result2, '=', false, 2, null)) {
            char[] cArray = new char[]{'='};
            result2 = StringsKt.trimEnd(result2, cArray) + '-';
        }
        if (StringsKt.startsWith$default((CharSequence)result2, '=', false, 2, null)) {
            char c = '-';
            Object object = new char[]{'='};
            object = StringsKt.trimStart(result2, object);
            result2 = c + (String)object;
        }
        return result2;
    }

    private static final boolean resolveZipStructure$lambda$5(File it) {
        return it.isDirectory();
    }
}

