/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map;

import com.unciv.logic.map.TilePriority;
import com.unciv.logic.map.tile.Tile;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u0012\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003H\u0002J\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%2\u0006\u0010&\u001a\u00020\u0003J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030(J\u0006\u0010)\u001a\u00020\u0006J\u000e\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0003J\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020\u0013J\u0006\u0010/\u001a\u00020-J\u000e\u00100\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0003R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000e\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u0010j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0010j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u0010\u0012\f\u0012\n  *\u0004\u0018\u00010\u001c0\u001c0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/unciv/logic/map/AStar;", "", "startingPoint", "Lcom/unciv/logic/map/tile/Tile;", "predicate", "Lkotlin/Function1;", "", "cost", "Lkotlin/Function2;", "", "heuristic", "(Lcom/unciv/logic/map/tile/Tile;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "costCache", "", "Lkotlin/Pair;", "cumulativeTileCost", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "maxSize", "", "getMaxSize", "()I", "setMaxSize", "(I)V", "getStartingPoint", "()Lcom/unciv/logic/map/tile/Tile;", "tilePriorityComparator", "Ljava/util/Comparator;", "Lcom/unciv/logic/map/TilePriority;", "tilesReached", "tilesToCheck", "Ljava/util/PriorityQueue;", "kotlin.jvm.PlatformType", "getCost", "from", "to", "getPathTo", "Lkotlin/sequences/Sequence;", "destination", "getReachedTiles", "", "hasEnded", "hasReachedTile", "tile", "nextStep", "", "size", "stepToEnd", "stepUntilDestination", "core"})
@SourceDebugExtension(value={"SMAP\nAStar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AStar.kt\ncom/unciv/logic/map/AStar\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,186:1\n372#2,7:187\n*S KotlinDebug\n*F\n+ 1 AStar.kt\ncom/unciv/logic/map/AStar\n*L\n61#1:187,7\n*E\n"})
public final class AStar {
    @NotNull
    private final Tile startingPoint;
    @NotNull
    private final Function1<Tile, Boolean> predicate;
    @NotNull
    private final Function2<Tile, Tile, Float> cost;
    @NotNull
    private final Function2<Tile, Tile, Float> heuristic;
    private int maxSize;
    @NotNull
    private final Map<Pair<Tile, Tile>, Float> costCache;
    @NotNull
    private final Comparator<TilePriority> tilePriorityComparator;
    @NotNull
    private final PriorityQueue<TilePriority> tilesToCheck;
    @NotNull
    private final HashMap<Tile, Tile> tilesReached;
    @NotNull
    private final HashMap<Tile, Float> cumulativeTileCost;

    public AStar(@NotNull Tile startingPoint, @NotNull Function1<? super Tile, Boolean> predicate, @NotNull Function2<? super Tile, ? super Tile, Float> cost, @NotNull Function2<? super Tile, ? super Tile, Float> heuristic) {
        Intrinsics.checkNotNullParameter(startingPoint, "startingPoint");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        Intrinsics.checkNotNullParameter(cost, "cost");
        Intrinsics.checkNotNullParameter(heuristic, "heuristic");
        this.startingPoint = startingPoint;
        this.predicate = predicate;
        this.cost = cost;
        this.heuristic = heuristic;
        this.maxSize = Integer.MAX_VALUE;
        this.costCache = new LinkedHashMap();
        this.tilePriorityComparator = AStar::tilePriorityComparator$lambda$1;
        this.tilesToCheck = new PriorityQueue<TilePriority>(27, this.tilePriorityComparator);
        this.tilesReached = new HashMap();
        this.cumulativeTileCost = new HashMap();
        this.tilesToCheck.add(new TilePriority(this.startingPoint, 0.0f));
        ((Map)this.tilesReached).put(this.startingPoint, this.startingPoint);
        ((Map)this.cumulativeTileCost).put(this.startingPoint, Float.valueOf(0.0f));
    }

    @NotNull
    public final Tile getStartingPoint() {
        return this.startingPoint;
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    public final void setMaxSize(int n) {
        this.maxSize = n;
    }

    /*
     * WARNING - void declaration
     */
    private final float getCost(Tile from, Tile to) {
        Object object;
        void $this$getOrPut$iv;
        Map<Pair<Tile, Tile>, Float> map2 = this.costCache;
        Pair<Tile, Tile> key$iv = new Pair<Tile, Tile>(from, to);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Float answer$iv = Float.valueOf(((Number)this.cost.invoke(from, to)).floatValue());
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((Number)object).floatValue();
    }

    public final void stepToEnd() {
        while (!this.hasEnded()) {
            this.nextStep();
        }
    }

    @NotNull
    public final AStar stepUntilDestination(@NotNull Tile destination2) {
        Intrinsics.checkNotNullParameter(destination2, "destination");
        while (!this.tilesReached.containsKey(destination2) && !this.hasEnded()) {
            this.nextStep();
        }
        return this;
    }

    public final void nextStep() {
        if (this.tilesReached.size() >= this.maxSize) {
            this.tilesToCheck.clear();
            return;
        }
        Object object = this.tilesToCheck.poll();
        if (object == null || (object = ((TilePriority)object).getTile()) == null) {
            return;
        }
        Object currentTile = object;
        Iterator<Tile> iterator2 = ((Tile)currentTile).getNeighbors().iterator();
        while (iterator2.hasNext()) {
            Tile neighbor = iterator2.next();
            Float f = this.cumulativeTileCost.get(currentTile);
            Intrinsics.checkNotNull(f);
            float newCost = ((Number)f).floatValue() + this.getCost((Tile)currentTile, neighbor);
            if (!this.predicate.invoke(neighbor).booleanValue()) continue;
            if (this.cumulativeTileCost.containsKey(neighbor)) {
                Float f2 = this.cumulativeTileCost.get(neighbor);
                if (f2 == null) {
                    f2 = Float.valueOf(Float.MAX_VALUE);
                }
                if (!(newCost < ((Number)f2).floatValue())) continue;
            }
            Float f3 = Float.valueOf(newCost);
            ((Map)this.cumulativeTileCost).put(neighbor, f3);
            float priority = newCost + ((Number)this.heuristic.invoke((Tile)currentTile, neighbor)).floatValue();
            this.tilesToCheck.add(new TilePriority(neighbor, priority));
            ((Map)this.tilesReached).put(neighbor, currentTile);
        }
    }

    @NotNull
    public final Sequence<Tile> getPathTo(@NotNull Tile destination2) {
        Intrinsics.checkNotNullParameter(destination2, "destination");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Tile>, Continuation<? super Unit>, Object>(destination2, this, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Tile $destination;
            final /* synthetic */ AStar this$0;
            {
                this.$destination = $destination;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        currentNode = this.$destination;
lbl8:
                        // 2 sources

                        while ((Tile)AStar.access$getTilesReached$p(this.this$0).get(currentNode) != null) {
                            this.L$0 = $this$sequence;
                            this.L$1 = currentNode;
                            this.L$2 = parent;
                            this.label = 1;
                            v0 = $this$sequence.yield(currentNode, this);
                            if (v0 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl24
                        }
                        ** GOTO lbl27
                    }
                    case 1: {
                        parent = (Tile)this.L$2;
                        currentNode = (Tile)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl24:
                        // 2 sources

                        if (Intrinsics.areEqual(currentNode, this.this$0.getStartingPoint())) ** GOTO lbl27
                        currentNode = parent;
                        ** GOTO lbl8
lbl27:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super Tile>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super Tile> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public final boolean hasEnded() {
        return this.tilesToCheck.isEmpty();
    }

    public final boolean hasReachedTile(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        return this.tilesReached.containsKey(tile);
    }

    @NotNull
    public final Set<Tile> getReachedTiles() {
        Set<Tile> set2 = this.tilesReached.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        return set2;
    }

    public final int size() {
        return this.tilesReached.size();
    }

    private static final int tilePriorityComparator$lambda$1(TilePriority tp1, TilePriority tp2) {
        return Float.compare(tp1.getPriority(), tp2.getPriority());
    }

    public static final /* synthetic */ HashMap access$getTilesReached$p(AStar $this) {
        return $this.tilesReached;
    }
}

