/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map;

import com.unciv.logic.map.tile.Tile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00162\u0006\u0010\u0017\u001a\u00020\u0003J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019J\u0006\u0010\u001a\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0003J\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u001e\u001a\u00020\tJ\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0011j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/unciv/logic/map/BFS;", "", "startingPoint", "Lcom/unciv/logic/map/tile/Tile;", "predicate", "Lkotlin/Function1;", "", "(Lcom/unciv/logic/map/tile/Tile;Lkotlin/jvm/functions/Function1;)V", "maxSize", "", "getMaxSize", "()I", "setMaxSize", "(I)V", "getStartingPoint", "()Lcom/unciv/logic/map/tile/Tile;", "tilesReached", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "tilesToCheck", "Lkotlin/collections/ArrayDeque;", "getPathTo", "Lkotlin/sequences/Sequence;", "destination", "getReachedTiles", "", "hasEnded", "hasReachedTile", "tile", "nextStep", "size", "stepToEnd", "", "stepUntilDestination", "core"})
public final class BFS {
    @NotNull
    private final Tile startingPoint;
    @NotNull
    private final Function1<Tile, Boolean> predicate;
    private int maxSize;
    @NotNull
    private final ArrayDeque<Tile> tilesToCheck;
    @NotNull
    private final HashMap<Tile, Tile> tilesReached;

    public BFS(@NotNull Tile startingPoint, @NotNull Function1<? super Tile, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(startingPoint, "startingPoint");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        this.startingPoint = startingPoint;
        this.predicate = predicate;
        this.maxSize = Integer.MAX_VALUE;
        this.tilesToCheck = new ArrayDeque(37);
        this.tilesReached = new HashMap();
        this.tilesToCheck.add(this.startingPoint);
        ((Map)this.tilesReached).put(this.startingPoint, this.startingPoint);
    }

    @NotNull
    public final Tile getStartingPoint() {
        return this.startingPoint;
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    public final void setMaxSize(int n) {
        this.maxSize = n;
    }

    public final void stepToEnd() {
        while (!this.hasEnded()) {
            this.nextStep();
        }
    }

    @NotNull
    public final BFS stepUntilDestination(@NotNull Tile destination2) {
        Intrinsics.checkNotNullParameter(destination2, "destination");
        while (!this.tilesReached.containsKey(destination2) && !this.hasEnded()) {
            this.nextStep();
        }
        return this;
    }

    @Nullable
    public final Tile nextStep() {
        if (this.tilesReached.size() >= this.maxSize) {
            this.tilesToCheck.clear();
            return null;
        }
        Tile tile = this.tilesToCheck.removeFirstOrNull();
        if (tile == null) {
            return null;
        }
        Tile current = tile;
        Iterator<Tile> iterator2 = current.getNeighbors().iterator();
        while (iterator2.hasNext()) {
            Tile neighbor = iterator2.next();
            if (((Map)this.tilesReached).containsKey(neighbor) || !this.predicate.invoke(neighbor).booleanValue()) continue;
            ((Map)this.tilesReached).put(neighbor, current);
            this.tilesToCheck.add(neighbor);
        }
        return current;
    }

    @NotNull
    public final Sequence<Tile> getPathTo(@NotNull Tile destination2) {
        Intrinsics.checkNotNullParameter(destination2, "destination");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Tile>, Continuation<? super Unit>, Object>(destination2, this, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Tile $destination;
            final /* synthetic */ BFS this$0;
            {
                this.$destination = $destination;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        currentNode = this.$destination;
lbl8:
                        // 2 sources

                        while ((Tile)BFS.access$getTilesReached$p(this.this$0).get(currentNode) != null) {
                            this.L$0 = $this$sequence;
                            this.L$1 = currentNode;
                            this.L$2 = parent;
                            this.label = 1;
                            v0 = $this$sequence.yield(currentNode, this);
                            if (v0 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl24
                        }
                        ** GOTO lbl27
                    }
                    case 1: {
                        parent = (Tile)this.L$2;
                        currentNode = (Tile)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl24:
                        // 2 sources

                        if (Intrinsics.areEqual(currentNode, this.this$0.getStartingPoint())) ** GOTO lbl27
                        currentNode = parent;
                        ** GOTO lbl8
lbl27:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super Tile>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super Tile> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public final boolean hasEnded() {
        return this.tilesToCheck.isEmpty();
    }

    public final boolean hasReachedTile(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        return this.tilesReached.containsKey(tile);
    }

    @NotNull
    public final Set<Tile> getReachedTiles() {
        Set<Tile> set2 = this.tilesReached.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        return set2;
    }

    public final int size() {
        return this.tilesReached.size();
    }

    public static final /* synthetic */ HashMap access$getTilesReached$p(BFS $this) {
        return $this.tilesReached;
    }
}

