/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.GameInfo;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.CityDistance;
import com.unciv.logic.map.tile.Tile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0010J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0006\u0010\u001b\u001a\u00020\u0018J\b\u0010\u001c\u001a\u00020\u0018H\u0002J(\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J(\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u0010H\u0002RX\u0010\u0003\u001aL\u0012\u0004\u0012\u00020\u0005\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00040\u0004j.\u0012\u0004\u0012\u00020\u0005\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0004j\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007`\b`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/unciv/logic/map/CityDistanceData;", "", "()V", "data", "Ljava/util/HashMap;", "", "Lcom/badlogic/gdx/math/Vector2;", "Lcom/unciv/logic/map/CityDistance;", "Lkotlin/collections/HashMap;", "game", "Lcom/unciv/logic/GameInfo;", "getGame", "()Lcom/unciv/logic/GameInfo;", "setGame", "(Lcom/unciv/logic/GameInfo;)V", "shouldUpdate", "", "getClosestCityDistance", "tile", "Lcom/unciv/logic/map/tile/Tile;", "player", "Lcom/unciv/logic/civilization/Civilization;", "majorsOnly", "reset", "", "resetPlayer", "identifier", "setDirty", "update", "updateDistanceIfLower", "position", "city", "Lcom/unciv/logic/city/City;", "distance", "", "updateDistances", "thisTile", "owner", "isMajor", "Companion", "core"})
public final class CityDistanceData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public transient GameInfo game;
    private boolean shouldUpdate = true;
    @NotNull
    private HashMap<String, HashMap<Vector2, CityDistance>> data = new HashMap();
    @NotNull
    public static final String IDENTIFIER_ALL_CIVS = "ALL_CIVS";
    @NotNull
    public static final String IDENTIFIER_MAJOR_CIVS = "MAJOR_CIVS";

    @NotNull
    public final GameInfo getGame() {
        GameInfo gameInfo2 = this.game;
        if (gameInfo2 != null) {
            return gameInfo2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("game");
        return null;
    }

    public final void setGame(@NotNull GameInfo gameInfo2) {
        Intrinsics.checkNotNullParameter(gameInfo2, "<set-?>");
        this.game = gameInfo2;
    }

    private final void reset() {
        this.data = new HashMap();
        ((Map)this.data).put(IDENTIFIER_ALL_CIVS, new HashMap());
        ((Map)this.data).put(IDENTIFIER_MAJOR_CIVS, new HashMap());
    }

    private final void resetPlayer(String identifier) {
        ((Map)this.data).put(identifier, new HashMap());
    }

    private final void updateDistanceIfLower(String identifier, Vector2 position, City city2, int distance) {
        HashMap<Vector2, CityDistance> hashMap = this.data.get(identifier);
        Intrinsics.checkNotNull(hashMap);
        CityDistance currentDistance = hashMap.get(position);
        CityDistance newDistance = new CityDistance(city2, distance);
        HashMap<Vector2, CityDistance> hashMap2 = this.data.get(identifier);
        Intrinsics.checkNotNull(hashMap2);
        ((Map)hashMap2).put(position, CityDistance.Companion.compare(currentDistance, newDistance));
    }

    private final void updateDistances(Tile thisTile, City city2, Civilization owner, boolean isMajor) {
        Tile cityTile = city2.getCenterTile();
        int distance = thisTile.aerialDistanceTo(cityTile);
        this.updateDistanceIfLower(IDENTIFIER_ALL_CIVS, thisTile.getPosition(), city2, distance);
        if (isMajor) {
            this.updateDistanceIfLower(IDENTIFIER_MAJOR_CIVS, thisTile.getPosition(), city2, distance);
            this.updateDistanceIfLower(owner.getCivName(), thisTile.getPosition(), city2, distance);
        }
    }

    private final void update() {
        this.reset();
        for (Civilization player : this.getGame().getCivilizations()) {
            if (player.isDefeated()) continue;
            boolean isMajor = player.isMajorCiv();
            if (isMajor) {
                this.resetPlayer(player.getCivName());
            }
            Iterator iterator2 = CollectionsKt.asSequence((Iterable)player.getCities()).iterator();
            while (iterator2.hasNext()) {
                City city2 = (City)iterator2.next();
                Iterator<Tile> iterator3 = city2.getCenterTile().getTilesInDistance(4).iterator();
                while (iterator3.hasNext()) {
                    Tile otherTile = iterator3.next();
                    this.updateDistances(otherTile, city2, player, isMajor);
                }
            }
        }
        this.shouldUpdate = false;
    }

    @Nullable
    public final CityDistance getClosestCityDistance(@NotNull Tile tile, @Nullable Civilization player, boolean majorsOnly) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (this.shouldUpdate) {
            this.update();
        }
        String identifier = player != null && player.isMajorCiv() ? player.getCivName() : (majorsOnly ? IDENTIFIER_MAJOR_CIVS : IDENTIFIER_ALL_CIVS);
        HashMap<Vector2, CityDistance> hashMap = this.data.get(identifier);
        Intrinsics.checkNotNull(hashMap);
        return hashMap.get(tile.getPosition());
    }

    public static /* synthetic */ CityDistance getClosestCityDistance$default(CityDistanceData cityDistanceData, Tile tile, Civilization civilization, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            civilization = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return cityDistanceData.getClosestCityDistance(tile, civilization, bl);
    }

    public final void setDirty() {
        this.shouldUpdate = true;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/map/CityDistanceData$Companion;", "", "()V", "IDENTIFIER_ALL_CIVS", "", "IDENTIFIER_MAJOR_CIVS", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

