/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map;

import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.AStar;
import com.unciv.logic.map.MapPathing;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.utils.Log;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000bJ\u0082\u0001\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000b2\u001e\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u00112\u001e\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J&\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0005J \u0010\u0017\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/unciv/logic/map/MapPathing;", "", "()V", "getConnection", "", "Lcom/unciv/logic/map/tile/Tile;", "civ", "Lcom/unciv/logic/civilization/Civilization;", "startTile", "endTile", "predicate", "Lkotlin/Function2;", "", "getPath", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "cost", "Lkotlin/Function3;", "", "heuristic", "getRoadPath", "isValidRoadPathTile", "tile", "roadPreferredMovementCost", "from", "to", "core"})
public final class MapPathing {
    @NotNull
    public static final MapPathing INSTANCE = new MapPathing();

    private MapPathing() {
    }

    private final float roadPreferredMovementCost(MapUnit unit, Tile from, Tile to) {
        if (to.hasRoadConnection(unit.getCiv(), false) || to.hasRailroadConnection(false)) {
            return 0.5f;
        }
        return 1.0f;
    }

    public final boolean isValidRoadPathTile(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        TileImprovement tileImprovement = tile.getRuleset().getRoadImprovement();
        if (tileImprovement == null) {
            return false;
        }
        TileImprovement roadImprovement2 = tileImprovement;
        TileImprovement tileImprovement2 = tile.getRuleset().getRailroadImprovement();
        if (tileImprovement2 == null) {
            return false;
        }
        TileImprovement railRoadImprovement = tileImprovement2;
        return tile.isLand() && !tile.isImpassible() && unit.getCiv().hasExplored(tile) && tile.canCivPassThrough(unit.getCiv()) && (tile.hasRoadConnection(unit.getCiv(), false) || tile.hasRailroadConnection(false) || tile.getImprovementFunctions().canBuildImprovement(roadImprovement2, unit.getCiv())) || tile.getImprovementFunctions().canBuildImprovement(railRoadImprovement, unit.getCiv());
    }

    @Nullable
    public final List<Tile> getRoadPath(@NotNull MapUnit unit, @NotNull Tile startTile, @NotNull Tile endTile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(startTile, "startTile");
        Intrinsics.checkNotNullParameter(endTile, "endTile");
        return this.getPath(unit, startTile, endTile, (Function2<? super MapUnit, ? super Tile, Boolean>)new Function2<MapUnit, Tile, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull MapUnit p0, @NotNull Tile p1) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p1, "p1");
                return ((MapPathing)this.receiver).isValidRoadPathTile(p0, p1);
            }
        }, (Function3<? super MapUnit, ? super Tile, ? super Tile, Float>)new Function3<MapUnit, Tile, Tile, Float>((Object)this){

            @NotNull
            public final Float invoke(@NotNull MapUnit p0, @NotNull Tile p1, @NotNull Tile p2) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p1, "p1");
                Intrinsics.checkNotNullParameter(p2, "p2");
                return Float.valueOf(MapPathing.access$roadPreferredMovementCost((MapPathing)this.receiver, p0, p1, p2));
            }
        }, getRoadPath.3.INSTANCE);
    }

    private final List<Tile> getPath(MapUnit unit, Tile startTile, Tile endTile, Function2<? super MapUnit, ? super Tile, Boolean> predicate, Function3<? super MapUnit, ? super Tile, ? super Tile, Float> cost, Function3<? super MapUnit, ? super Tile, ? super Tile, Float> heuristic) {
        AStar astar2 = new AStar(startTile, (Function1<? super Tile, Boolean>)new Function1<Tile, Boolean>(predicate, unit){
            final /* synthetic */ Function2<MapUnit, Tile, Boolean> $predicate;
            final /* synthetic */ MapUnit $unit;
            {
                this.$predicate = $predicate;
                this.$unit = $unit;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile tile) {
                Intrinsics.checkNotNullParameter(tile, "tile");
                return this.$predicate.invoke(this.$unit, tile);
            }
        }, (Function2<? super Tile, ? super Tile, Float>)new Function2<Tile, Tile, Float>(cost, unit){
            final /* synthetic */ Function3<MapUnit, Tile, Tile, Float> $cost;
            final /* synthetic */ MapUnit $unit;
            {
                this.$cost = $cost;
                this.$unit = $unit;
                super(2);
            }

            @NotNull
            public final Float invoke(@NotNull Tile from, @NotNull Tile to) {
                Intrinsics.checkNotNullParameter(from, "from");
                Intrinsics.checkNotNullParameter(to, "to");
                return this.$cost.invoke(this.$unit, from, to);
            }
        }, (Function2<? super Tile, ? super Tile, Float>)new Function2<Tile, Tile, Float>(heuristic, unit){
            final /* synthetic */ Function3<MapUnit, Tile, Tile, Float> $heuristic;
            final /* synthetic */ MapUnit $unit;
            {
                this.$heuristic = $heuristic;
                this.$unit = $unit;
                super(2);
            }

            @NotNull
            public final Float invoke(@NotNull Tile from, @NotNull Tile to) {
                Intrinsics.checkNotNullParameter(from, "from");
                Intrinsics.checkNotNullParameter(to, "to");
                return this.$heuristic.invoke(this.$unit, from, to);
            }
        });
        while (true) {
            if (astar2.hasEnded()) {
                Log.INSTANCE.debug("getPath failed at AStar search size " + astar2.size(), new Object[0]);
                return null;
            }
            if (astar2.hasReachedTile(endTile)) break;
            astar2.nextStep();
        }
        return CollectionsKt.reversed((Iterable)SequencesKt.toList(astar2.getPathTo(endTile)));
    }

    @Nullable
    public final List<Tile> getConnection(@NotNull Civilization civ, @NotNull Tile startTile, @NotNull Tile endTile, @NotNull Function2<? super Civilization, ? super Tile, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        Intrinsics.checkNotNullParameter(startTile, "startTile");
        Intrinsics.checkNotNullParameter(endTile, "endTile");
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        AStar astar2 = new AStar(startTile, (Function1<? super Tile, Boolean>)new Function1<Tile, Boolean>(predicate, civ){
            final /* synthetic */ Function2<Civilization, Tile, Boolean> $predicate;
            final /* synthetic */ Civilization $civ;
            {
                this.$predicate = $predicate;
                this.$civ = $civ;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile tile) {
                Intrinsics.checkNotNullParameter(tile, "tile");
                return this.$predicate.invoke(this.$civ, tile);
            }
        }, getConnection.astar.2.INSTANCE, getConnection.astar.3.INSTANCE);
        while (true) {
            if (astar2.hasEnded()) {
                Log.INSTANCE.debug("getConnection failed at AStar search size " + astar2.size(), new Object[0]);
                return null;
            }
            if (astar2.hasReachedTile(endTile)) break;
            astar2.nextStep();
        }
        return CollectionsKt.reversed((Iterable)SequencesKt.toList(astar2.getPathTo(endTile)));
    }

    public static final /* synthetic */ float access$roadPreferredMovementCost(MapPathing $this, MapUnit unit, Tile from, Tile to) {
        return $this.roadPreferredMovementCost(unit, from, to);
    }
}

