/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.GameInfo;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.BFS;
import com.unciv.logic.map.HexMath;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapgenerator.MapLandmassGenerator;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.UnitPromotions;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.metadata.Player;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueMap;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.ui.components.extensions.CollectionExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\b\u00a2\u0001\u00a3\u0001\u00a4\u0001\u00a5\u0001B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB)\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bB\u000f\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ \u0010_\u001a\u00020\u00072\u0006\u0010`\u001a\u00020\u00182\u0006\u0010a\u001a\u00020I2\b\b\u0002\u0010b\u001a\u00020cJ\u000e\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020gJ\u0006\u0010h\u001a\u00020eJ\u0006\u0010i\u001a\u00020\u0000J\u0011\u0010j\u001a\u00020\u00072\u0006\u0010k\u001a\u00020lH\u0086\u0002J\u0016\u0010j\u001a\u00020\u00072\u0006\u0010m\u001a\u00020\u00032\u0006\u0010n\u001a\u00020\u0003J\u0011\u0010o\u001a\u00020I2\u0006\u0010k\u001a\u00020lH\u0086\u0002J\u0019\u0010o\u001a\u00020I2\u0006\u0010m\u001a\u00020\u00032\u0006\u0010n\u001a\u00020\u0003H\u0086\u0002J\u0018\u0010p\u001a\u0004\u0018\u00010I2\u0006\u0010a\u001a\u00020I2\u0006\u0010q\u001a\u00020\u0003J\u0018\u0010r\u001a\u0004\u0018\u00010I2\u0006\u0010m\u001a\u00020\u00032\u0006\u0010n\u001a\u00020\u0003J\u0016\u0010s\u001a\u00020\u00032\u0006\u0010a\u001a\u00020I2\u0006\u0010t\u001a\u00020IJ\u0016\u0010u\u001a\u00020l2\u0006\u0010a\u001a\u00020I2\u0006\u0010t\u001a\u00020IJ\u001a\u0010v\u001a\u0004\u0018\u00010I2\u0006\u0010m\u001a\u00020\u00032\u0006\u0010n\u001a\u00020\u0003H\u0002J\u001e\u0010w\u001a\u0012\u0012\u0004\u0012\u00020\u00180Hj\b\u0012\u0004\u0012\u00020\u0018`J2\u0006\u0010\u0004\u001a\u00020\u0005J\u001c\u0010x\u001a\b\u0012\u0004\u0012\u00020I0y2\u0006\u0010z\u001a\u00020l2\u0006\u0010{\u001a\u00020\u0003J\u001c\u0010|\u001a\b\u0012\u0004\u0012\u00020I0y2\u0006\u0010z\u001a\u00020l2\u0006\u0010{\u001a\u00020\u0003J\u001c\u0010}\u001a\b\u0012\u0004\u0012\u00020I0y2\u0006\u0010z\u001a\u00020l2\u0006\u0010~\u001a\u00020\u007fJ\u0017\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u00020I0y2\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001J\u0010\u0010\u0083\u0001\u001a\u00020l2\u0007\u0010\u0084\u0001\u001a\u00020lJ*\u0010\u0085\u0001\u001a\b\u0012\u0004\u0012\u00020I0U2\u0007\u0010\u0084\u0001\u001a\u00020l2\u0007\u0010\u0086\u0001\u001a\u00020\u00032\t\b\u0002\u0010\u0087\u0001\u001a\u00020\u0007J\u0007\u0010\u0088\u0001\u001a\u00020\u0007J\u0007\u0010\u0089\u0001\u001a\u00020\u0007J:\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u00012\u0007\u0010\u0084\u0001\u001a\u00020l2\b\u0010\u008c\u0001\u001a\u00030\u008d\u00012\b\u0010\u008e\u0001\u001a\u00030\u008f\u00012\u000b\b\u0002\u0010\u0090\u0001\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0003\u0010\u0091\u0001J9\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u00012\u0007\u0010\u0084\u0001\u001a\u00020l2\u0007\u0010\u0092\u0001\u001a\u00020\u00182\b\u0010\u008e\u0001\u001a\u00030\u008f\u00012\u000b\b\u0002\u0010\u0090\u0001\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0003\u0010\u0093\u0001J\u0010\u0010\u0094\u0001\u001a\u00020e2\u0007\u0010\u0095\u0001\u001a\u00020\u0005J\u0017\u0010\u0096\u0001\u001a\u00020\u00072\u0006\u0010`\u001a\u00020\u00182\u0006\u0010a\u001a\u00020IJ\u0010\u0010\u0097\u0001\u001a\u00020e2\u0007\u0010\u0084\u0001\u001a\u00020lJ\u000f\u0010\u0097\u0001\u001a\u00020e2\u0006\u0010`\u001a\u00020\u0018J\u0007\u0010\u0098\u0001\u001a\u00020eJ\u0007\u0010\u0099\u0001\u001a\u00020eJ\u001e\u0010\u009a\u0001\u001a\u00020e2\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\t\b\u0002\u0010\u009b\u0001\u001a\u00020\u0007J\u0011\u0010\u009c\u0001\u001a\u00020e2\b\u0010\u009d\u0001\u001a\u00030\u009e\u0001J\u001b\u0010\u009f\u0001\u001a\u00020e2\b\u0010\u009d\u0001\u001a\u00030\u009e\u00012\b\u0010\u00a0\u0001\u001a\u00030\u00a1\u0001R\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\rR-\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0013j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003`\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0010\"\u0004\b%\u0010\rR\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001b\u0010,\u001a\u00020-8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b.\u0010/R\u001b\u00102\u001a\u00020-8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u00101\u001a\u0004\b3\u0010/R!\u00105\u001a\b\u0012\u0004\u0012\u00020\u0018068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u00101\u001a\u0004\b7\u00108R!\u0010:\u001a\b\u0012\u0004\u0012\u00020\u0018068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b<\u00101\u001a\u0004\b;\u00108R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R!\u0010A\u001a\u0012\u0012\u0004\u0012\u00020C0Bj\b\u0012\u0004\u0012\u00020C`D\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FRM\u0010G\u001a>\u0012\u0004\u0012\u00020\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020I0Hj\b\u0012\u0004\u0012\u00020I`J0\u0013j\u001e\u0012\u0004\u0012\u00020\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020I0Hj\b\u0012\u0004\u0012\u00020I`J`\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\u0016R*\u0010L\u001a\u0012\u0012\u0004\u0012\u00020I0Bj\b\u0012\u0004\u0012\u00020I`DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010F\"\u0004\bN\u0010ORR\u0010P\u001a:\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010I0Bj\n\u0012\u0006\u0012\u0004\u0018\u00010I`D0Bj\u001c\u0012\u0018\u0012\u0016\u0012\u0006\u0012\u0004\u0018\u00010I0Bj\n\u0012\u0006\u0012\u0004\u0018\u00010I`D`DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010F\"\u0004\bR\u0010OR,\u0010S\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180U\u0012\u0004\u0012\u00020V0TX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010X\"\u0004\bY\u0010ZR\u0017\u0010[\u001a\b\u0012\u0004\u0012\u00020I0\\8F\u00a2\u0006\u0006\u001a\u0004\b]\u0010^\u00a8\u0006\u00a6\u0001"}, d2={"Lcom/unciv/logic/map/TileMap;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "radius", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "worldWrap", "", "(ILcom/unciv/models/ruleset/Ruleset;Z)V", "width", "height", "(IILcom/unciv/models/ruleset/Ruleset;Z)V", "initialCapacity", "(I)V", "bottomY", "getBottomY", "()I", "setBottomY", "continentSizes", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getContinentSizes", "()Ljava/util/HashMap;", "description", "", "getDescription", "()Ljava/lang/String;", "setDescription", "(Ljava/lang/String;)V", "gameInfo", "Lcom/unciv/logic/GameInfo;", "getGameInfo", "()Lcom/unciv/logic/GameInfo;", "setGameInfo", "(Lcom/unciv/logic/GameInfo;)V", "leftX", "getLeftX", "setLeftX", "mapParameters", "Lcom/unciv/logic/map/MapParameters;", "getMapParameters", "()Lcom/unciv/logic/map/MapParameters;", "setMapParameters", "(Lcom/unciv/logic/map/MapParameters;)V", "maxLatitude", "", "getMaxLatitude", "()F", "maxLatitude$delegate", "Lkotlin/Lazy;", "maxLongitude", "getMaxLongitude", "maxLongitude$delegate", "naturalWonders", "", "getNaturalWonders", "()Ljava/util/Set;", "naturalWonders$delegate", "resources", "getResources", "resources$delegate", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "setRuleset", "(Lcom/unciv/models/ruleset/Ruleset;)V", "startingLocations", "Ljava/util/ArrayList;", "Lcom/unciv/logic/map/TileMap$StartingLocation;", "Lkotlin/collections/ArrayList;", "getStartingLocations", "()Ljava/util/ArrayList;", "startingLocationsByNation", "Ljava/util/HashSet;", "Lcom/unciv/logic/map/tile/Tile;", "Lkotlin/collections/HashSet;", "getStartingLocationsByNation", "tileList", "getTileList", "setTileList", "(Ljava/util/ArrayList;)V", "tileMatrix", "getTileMatrix", "setTileMatrix", "tileUniqueMapCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/unciv/models/ruleset/unique/UniqueMap;", "getTileUniqueMapCache", "()Ljava/util/concurrent/ConcurrentHashMap;", "setTileUniqueMapCache", "(Ljava/util/concurrent/ConcurrentHashMap;)V", "values", "", "getValues", "()Ljava/util/Collection;", "addStartingLocation", "nationName", "tile", "usage", "Lcom/unciv/logic/map/TileMap$StartingLocation$Usage;", "assignContinents", "", "mode", "Lcom/unciv/logic/map/TileMap$AssignContinentsMode;", "clearStartingLocations", "clone", "contains", "vector", "Lcom/badlogic/gdx/math/Vector2;", "x", "y", "get", "getClockPositionNeighborTile", "clockPosition", "getIfTileExistsOrNull", "getNeighborTileClockPosition", "otherTile", "getNeighborTilePositionAsWorldCoords", "getOrNull", "getRulesetIncompatibility", "getTilesAtDistance", "Lkotlin/sequences/Sequence;", "origin", "distance", "getTilesInDistance", "getTilesInDistanceRange", "range", "Lkotlin/ranges/IntRange;", "getTilesInRectangle", "rectangle", "Lcom/badlogic/gdx/math/Rectangle;", "getUnWrappedPosition", "position", "getViewableTiles", "sightDistance", "forAttack", "hasGameInfo", "isWaterMap", "placeUnitNearTile", "Lcom/unciv/logic/map/mapunit/MapUnit;", "baseUnit", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "unitId", "(Lcom/badlogic/gdx/math/Vector2;Lcom/unciv/models/ruleset/unit/BaseUnit;Lcom/unciv/logic/civilization/Civilization;Ljava/lang/Integer;)Lcom/unciv/logic/map/mapunit/MapUnit;", "unitName", "(Lcom/badlogic/gdx/math/Vector2;Ljava/lang/String;Lcom/unciv/logic/civilization/Civilization;Ljava/lang/Integer;)Lcom/unciv/logic/map/mapunit/MapUnit;", "removeMissingTerrainModReferences", "ruleSet", "removeStartingLocation", "removeStartingLocations", "setNeutralTransients", "setStartingLocationsTransients", "setTransients", "setUnitCivTransients", "stripPlayer", "player", "Lcom/unciv/models/metadata/Player;", "switchPlayersNation", "newNation", "Lcom/unciv/models/ruleset/nation/Nation;", "AssignContinentsMode", "Preview", "StartingLocation", "ViewableTile", "core"})
@SourceDebugExtension(value={"SMAP\nTileMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileMap.kt\ncom/unciv/logic/map/TileMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,773:1\n1#2:774\n766#3:775\n857#3,2:776\n766#3:778\n857#3,2:779\n1549#3:781\n1620#3,3:782\n766#3:785\n857#3,2:786\n1549#3:788\n1620#3,3:789\n1549#3:792\n1620#3,3:793\n1054#3:800\n288#3,2:801\n1855#3,2:803\n1855#3,2:805\n1855#3,2:807\n766#3:809\n857#3,2:810\n2624#3,3:812\n1855#3,2:815\n766#3:817\n857#3,2:818\n1855#3,2:820\n1855#3,2:822\n766#3:824\n857#3,2:825\n204#4,4:796\n*S KotlinDebug\n*F\n+ 1 TileMap.kt\ncom/unciv/logic/map/TileMap\n*L\n408#1:775\n408#1:776,2\n421#1:778\n421#1:779,2\n421#1:781\n421#1:782,3\n423#1:785\n423#1:786,2\n423#1:788\n423#1:789,3\n432#1:792\n432#1:793,3\n575#1:800\n576#1:801,2\n580#1:803,2\n623#1:805,2\n640#1:807,2\n646#1:809\n646#1:810,2\n648#1:812,3\n722#1:815,2\n737#1:817\n737#1:818,2\n742#1:820,2\n747#1:822,2\n754#1:824\n754#1:825,2\n452#1:796,4\n*E\n"})
public final class TileMap
implements IsPartOfGameInfoSerialization {
    @NotNull
    private MapParameters mapParameters;
    @NotNull
    private ArrayList<Tile> tileList;
    @NotNull
    private final ArrayList<StartingLocation> startingLocations;
    @NotNull
    private String description;
    public transient GameInfo gameInfo;
    @Nullable
    private transient Ruleset ruleset;
    @NotNull
    private transient ConcurrentHashMap<List<String>, UniqueMap> tileUniqueMapCache;
    @NotNull
    private transient ArrayList<ArrayList<Tile>> tileMatrix;
    private transient int leftX;
    private transient int bottomY;
    @NotNull
    private final transient Lazy maxLatitude$delegate;
    @NotNull
    private final transient Lazy maxLongitude$delegate;
    @NotNull
    private final transient Lazy naturalWonders$delegate;
    @NotNull
    private final transient Lazy resources$delegate;
    @NotNull
    private final transient HashMap<String, HashSet<Tile>> startingLocationsByNation;
    @NotNull
    private final transient HashMap<Integer, Integer> continentSizes;

    public TileMap(int initialCapacity) {
        this.mapParameters = new MapParameters();
        this.tileList = new ArrayList(initialCapacity);
        this.startingLocations = new ArrayList();
        this.description = "";
        this.tileUniqueMapCache = new ConcurrentHashMap();
        this.tileMatrix = new ArrayList();
        this.maxLatitude$delegate = LazyKt.lazy((Function0)new Function0<Float>(this){
            final /* synthetic */ TileMap this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Float invoke() {
                float f;
                if (this.this$0.getValues().isEmpty()) {
                    f = 0.0f;
                } else {
                    Iterator<T> iterator2 = ((Iterable)this.this$0.getValues()).iterator();
                    if (!iterator2.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Tile it = (Tile)iterator2.next();
                    boolean bl = false;
                    float f2 = Math.abs(it.getLatitude());
                    while (iterator2.hasNext()) {
                        Tile it2 = (Tile)iterator2.next();
                        $i$a$-maxOf-TileMap$maxLatitude$2$1 = false;
                        float f3 = Math.abs(it2.getLatitude());
                        f2 = Math.max(f2, f3);
                    }
                    f = f2;
                }
                return Float.valueOf(f);
            }
        });
        this.maxLongitude$delegate = LazyKt.lazy((Function0)new Function0<Float>(this){
            final /* synthetic */ TileMap this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Float invoke() {
                float f;
                if (this.this$0.getValues().isEmpty()) {
                    f = 0.0f;
                } else {
                    Iterator<T> iterator2 = ((Iterable)this.this$0.getValues()).iterator();
                    if (!iterator2.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Tile it = (Tile)iterator2.next();
                    boolean bl = false;
                    float f2 = Math.abs(it.getLongitude());
                    while (iterator2.hasNext()) {
                        Tile it2 = (Tile)iterator2.next();
                        $i$a$-maxOf-TileMap$maxLongitude$2$1 = false;
                        float f3 = Math.abs(it2.getLongitude());
                        f2 = Math.max(f2, f3);
                    }
                    f = f2;
                }
                return Float.valueOf(f);
            }
        });
        this.naturalWonders$delegate = LazyKt.lazy((Function0)new Function0<Set<? extends String>>(this){
            final /* synthetic */ TileMap this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Set<String> invoke() {
                return SequencesKt.toSet(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.this$0.getTileList()), naturalWonders.1.INSTANCE), naturalWonders.2.INSTANCE));
            }
        });
        this.resources$delegate = LazyKt.lazy((Function0)new Function0<Set<? extends String>>(this){
            final /* synthetic */ TileMap this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Set<String> invoke() {
                return SequencesKt.toSet(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.this$0.getTileList()), resources.1.INSTANCE), resources.2.INSTANCE));
            }
        });
        this.startingLocationsByNation = new HashMap();
        this.continentSizes = new HashMap();
    }

    public /* synthetic */ TileMap(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    @NotNull
    public final MapParameters getMapParameters() {
        return this.mapParameters;
    }

    public final void setMapParameters(@NotNull MapParameters mapParameters) {
        Intrinsics.checkNotNullParameter(mapParameters, "<set-?>");
        this.mapParameters = mapParameters;
    }

    @NotNull
    public final ArrayList<Tile> getTileList() {
        return this.tileList;
    }

    public final void setTileList(@NotNull ArrayList<Tile> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.tileList = arrayList;
    }

    @NotNull
    public final ArrayList<StartingLocation> getStartingLocations() {
        return this.startingLocations;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.description = string;
    }

    @NotNull
    public final GameInfo getGameInfo() {
        GameInfo gameInfo2 = this.gameInfo;
        if (gameInfo2 != null) {
            return gameInfo2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("gameInfo");
        return null;
    }

    public final void setGameInfo(@NotNull GameInfo gameInfo2) {
        Intrinsics.checkNotNullParameter(gameInfo2, "<set-?>");
        this.gameInfo = gameInfo2;
    }

    @Nullable
    public final Ruleset getRuleset() {
        return this.ruleset;
    }

    public final void setRuleset(@Nullable Ruleset ruleset2) {
        this.ruleset = ruleset2;
    }

    @NotNull
    public final ConcurrentHashMap<List<String>, UniqueMap> getTileUniqueMapCache() {
        return this.tileUniqueMapCache;
    }

    public final void setTileUniqueMapCache(@NotNull ConcurrentHashMap<List<String>, UniqueMap> concurrentHashMap) {
        Intrinsics.checkNotNullParameter(concurrentHashMap, "<set-?>");
        this.tileUniqueMapCache = concurrentHashMap;
    }

    @NotNull
    public final ArrayList<ArrayList<Tile>> getTileMatrix() {
        return this.tileMatrix;
    }

    public final void setTileMatrix(@NotNull ArrayList<ArrayList<Tile>> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, "<set-?>");
        this.tileMatrix = arrayList;
    }

    public final int getLeftX() {
        return this.leftX;
    }

    public final void setLeftX(int n) {
        this.leftX = n;
    }

    public final int getBottomY() {
        return this.bottomY;
    }

    public final void setBottomY(int n) {
        this.bottomY = n;
    }

    public final float getMaxLatitude() {
        Lazy lazy = this.maxLatitude$delegate;
        return ((Number)lazy.getValue()).floatValue();
    }

    public final float getMaxLongitude() {
        Lazy lazy = this.maxLongitude$delegate;
        return ((Number)lazy.getValue()).floatValue();
    }

    @NotNull
    public final Set<String> getNaturalWonders() {
        Lazy lazy = this.naturalWonders$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final Set<String> getResources() {
        Lazy lazy = this.resources$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final Collection<Tile> getValues() {
        return this.tileList;
    }

    @NotNull
    public final HashMap<String, HashSet<Tile>> getStartingLocationsByNation() {
        return this.startingLocationsByNation;
    }

    @NotNull
    public final HashMap<Integer, Integer> getContinentSizes() {
        return this.continentSizes;
    }

    /*
     * WARNING - void declaration
     */
    public TileMap(int radius, @NotNull Ruleset ruleset2, boolean worldWrap) {
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        this(HexMath.INSTANCE.getNumberOfTilesInHexagon(radius));
        this.startingLocations.clear();
        String firstAvailableLandTerrain = MapLandmassGenerator.Companion.getInitializationTerrain$core(ruleset2, TerrainType.Land);
        Vector2 vector2 = Vector2.Zero;
        Intrinsics.checkNotNullExpressionValue(vector2, "Zero");
        for (Vector2 vector : HexMath.INSTANCE.getVectorsInDistance(vector2, radius, worldWrap)) {
            void $this$_init__u24lambda_u240;
            Tile tile;
            Tile tile2 = tile = new Tile();
            ArrayList<Tile> arrayList = this.tileList;
            boolean bl = false;
            $this$_init__u24lambda_u240.setPosition(vector);
            $this$_init__u24lambda_u240.setBaseTerrain(firstAvailableLandTerrain);
            arrayList.add(tile);
        }
        TileMap.setTransients$default(this, ruleset2, false, 2, null);
    }

    public /* synthetic */ TileMap(int n, Ruleset ruleset2, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(n, ruleset2, bl);
    }

    /*
     * WARNING - void declaration
     */
    public TileMap(int width, int height, @NotNull Ruleset ruleset2, boolean worldWrap) {
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        this(width * height);
        this.startingLocations.clear();
        String firstAvailableLandTerrain = MapLandmassGenerator.Companion.getInitializationTerrain$core(ruleset2, TerrainType.Land);
        int wrapAdjustedWidth = worldWrap && width % 2 != 0 ? width - 1 : width;
        int column = -wrapAdjustedWidth / 2;
        int n = (wrapAdjustedWidth - 1) / 2;
        if (column <= n) {
            while (true) {
                int n2;
                int row;
                if ((row = -height / 2) <= (n2 = (height - 1) / 2)) {
                    while (true) {
                        void $this$_init__u24lambda_u241;
                        Tile tile;
                        Tile tile2 = tile = new Tile();
                        ArrayList<Tile> arrayList = this.tileList;
                        boolean bl = false;
                        $this$_init__u24lambda_u241.setPosition(HexMath.INSTANCE.getTileCoordsFromColumnRow(column, row));
                        $this$_init__u24lambda_u241.setBaseTerrain(firstAvailableLandTerrain);
                        arrayList.add(tile);
                        if (row == n2) break;
                        ++row;
                    }
                }
                if (column == n) break;
                ++column;
            }
        }
        TileMap.setTransients$default(this, ruleset2, false, 2, null);
    }

    public /* synthetic */ TileMap(int n, int n2, Ruleset ruleset2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            bl = false;
        }
        this(n, n2, ruleset2, bl);
    }

    @NotNull
    public final TileMap clone() {
        TileMap toReturn = new TileMap(this.tileList.size());
        CollectionsKt.addAll((Collection)toReturn.tileList, SequencesKt.map(CollectionsKt.asSequence((Iterable)this.tileList), clone.1.INSTANCE));
        toReturn.mapParameters = this.mapParameters;
        toReturn.ruleset = this.ruleset;
        toReturn.startingLocations.clear();
        toReturn.startingLocations.ensureCapacity(this.startingLocations.size());
        toReturn.startingLocations.addAll((Collection<StartingLocation>)this.startingLocations);
        toReturn.description = this.description;
        toReturn.tileUniqueMapCache = this.tileUniqueMapCache;
        return toReturn;
    }

    public final boolean contains(@NotNull Vector2 vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        return this.contains((int)vector.x, (int)vector.y);
    }

    @NotNull
    public final Tile get(@NotNull Vector2 vector) {
        Intrinsics.checkNotNullParameter(vector, "vector");
        return this.get((int)vector.x, (int)vector.y);
    }

    public final boolean contains(int x, int y) {
        return this.getOrNull(x, y) != null;
    }

    @NotNull
    public final Tile get(int x, int y) {
        Tile tile = this.tileMatrix.get(x - this.leftX).get(y - this.bottomY);
        Intrinsics.checkNotNull(tile);
        return tile;
    }

    private final Tile getOrNull(int x, int y) {
        ArrayList arrayList = (ArrayList)CollectionsKt.getOrNull((List)this.tileMatrix, x - this.leftX);
        return arrayList != null ? (Tile)CollectionsKt.getOrNull(arrayList, y - this.bottomY) : null;
    }

    public final boolean hasGameInfo() {
        return this.gameInfo != null;
    }

    @NotNull
    public final Sequence<Tile> getTilesInDistance(@NotNull Vector2 origin2, int distance) {
        Intrinsics.checkNotNullParameter(origin2, "origin");
        return this.getTilesInDistanceRange(origin2, new IntRange(0, distance));
    }

    @NotNull
    public final Sequence<Tile> getTilesInDistanceRange(@NotNull Vector2 origin2, @NotNull IntRange range) {
        Intrinsics.checkNotNullParameter(origin2, "origin");
        Intrinsics.checkNotNullParameter(range, "range");
        return SequencesKt.flatMap(CollectionsKt.asSequence(range), (Function1)new Function1<Integer, Sequence<? extends Tile>>(this, origin2){
            final /* synthetic */ TileMap this$0;
            final /* synthetic */ Vector2 $origin;
            {
                this.this$0 = $receiver;
                this.$origin = $origin;
                super(1);
            }

            @NotNull
            public final Sequence<Tile> invoke(int it) {
                return this.this$0.getTilesAtDistance(this.$origin, it);
            }
        });
    }

    @NotNull
    public final Sequence<Tile> getTilesAtDistance(@NotNull Vector2 origin2, int distance) {
        Sequence<Tile> sequence;
        Intrinsics.checkNotNullParameter(origin2, "origin");
        if (distance <= 0) {
            Tile[] tileArray = new Tile[]{this.get(origin2)};
            sequence = SequencesKt.sequenceOf(tileArray);
        } else {
            sequence = SequencesKt.filterNotNull(SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Tile>, Continuation<? super Unit>, Object>(origin2, distance, this, null){
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                int I$4;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Vector2 $origin;
                final /* synthetic */ int $distance;
                final /* synthetic */ TileMap this$0;
                {
                    this.$origin = $origin;
                    this.$distance = $distance;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(var1_1);
                            $this$sequence = (SequenceScope)this.L$0;
                            centerX = (int)this.$origin.x;
                            centerY = (int)this.$origin.y;
                            currentX = centerX - this.$distance;
                            currentY = centerY - this.$distance;
                            i = 0;
lbl11:
                            // 2 sources

                            while (i < this.$distance) {
                                this.L$0 = $this$sequence;
                                this.I$0 = centerX;
                                this.I$1 = centerY;
                                this.I$2 = currentX;
                                this.I$3 = currentY;
                                this.I$4 = i;
                                this.label = 1;
                                v0 = $this$sequence.yield(this.this$0.getIfTileExistsOrNull(currentX, currentY), this);
                                if (v0 == var8_2) {
                                    return var8_2;
                                }
                                ** GOTO lbl33
                            }
                            break;
                        }
                        case 1: {
                            i = this.I$4;
                            currentY = this.I$3;
                            currentX = this.I$2;
                            centerY = this.I$1;
                            centerX = this.I$0;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl33:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.I$0 = centerX;
                            this.I$1 = centerY;
                            this.I$2 = currentX;
                            this.I$3 = currentY;
                            this.I$4 = i;
                            this.label = 2;
                            v1 = $this$sequence.yield(this.this$0.getIfTileExistsOrNull(2 * centerX - currentX, 2 * centerY - currentY), this);
                            if (v1 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl53
                        }
                        case 2: {
                            i = this.I$4;
                            currentY = this.I$3;
                            currentX = this.I$2;
                            centerY = this.I$1;
                            centerX = this.I$0;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v1 = $result;
lbl53:
                            // 2 sources

                            ++currentX;
                            ++i;
                            ** GOTO lbl11
                        }
                    }
                    i = 0;
lbl57:
                    // 2 sources

                    while (i < this.$distance) {
                        this.L$0 = $this$sequence;
                        this.I$0 = centerX;
                        this.I$1 = centerY;
                        this.I$2 = currentX;
                        this.I$3 = currentY;
                        this.I$4 = i;
                        this.label = 3;
                        v2 = $this$sequence.yield(this.this$0.getIfTileExistsOrNull(currentX, currentY), this);
                        if (v2 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl79
                    }
                    {
                        break;
                        case 3: {
                            i = this.I$4;
                            currentY = this.I$3;
                            currentX = this.I$2;
                            centerY = this.I$1;
                            centerX = this.I$0;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v2 = $result;
lbl79:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.I$0 = centerX;
                            this.I$1 = centerY;
                            this.I$2 = currentX;
                            this.I$3 = currentY;
                            this.I$4 = i;
                            this.label = 4;
                            v3 = $this$sequence.yield(this.this$0.getIfTileExistsOrNull(2 * centerX - currentX, 2 * centerY - currentY), this);
                            if (v3 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl99
                        }
                        case 4: {
                            i = this.I$4;
                            currentY = this.I$3;
                            currentX = this.I$2;
                            centerY = this.I$1;
                            centerX = this.I$0;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v3 = $result;
lbl99:
                            // 2 sources

                            ++currentX;
                            ++currentY;
                            ++i;
                            ** GOTO lbl57
                        }
                    }
                    i = 0;
lbl105:
                    // 2 sources

                    while (i < this.$distance) {
                        this.L$0 = $this$sequence;
                        this.I$0 = centerX;
                        this.I$1 = centerY;
                        this.I$2 = currentX;
                        this.I$3 = currentY;
                        this.I$4 = i;
                        this.label = 5;
                        v4 = $this$sequence.yield(this.this$0.getIfTileExistsOrNull(currentX, currentY), this);
                        if (v4 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl127
                    }
                    {
                        break;
                        case 5: {
                            i = this.I$4;
                            currentY = this.I$3;
                            currentX = this.I$2;
                            centerY = this.I$1;
                            centerX = this.I$0;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v4 = $result;
lbl127:
                            // 2 sources

                            this.L$0 = $this$sequence;
                            this.I$0 = centerX;
                            this.I$1 = centerY;
                            this.I$2 = currentX;
                            this.I$3 = currentY;
                            this.I$4 = i;
                            this.label = 6;
                            v5 = $this$sequence.yield(this.this$0.getIfTileExistsOrNull(2 * centerX - currentX, 2 * centerY - currentY), this);
                            if (v5 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl147
                        }
                        case 6: {
                            i = this.I$4;
                            currentY = this.I$3;
                            currentX = this.I$2;
                            centerY = this.I$1;
                            centerX = this.I$0;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v5 = $result;
lbl147:
                            // 2 sources

                            ++currentY;
                            ++i;
                            ** GOTO lbl105
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<SequenceScope<? super Tile>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)((Object)function2);
                }

                @Nullable
                public final Object invoke(@NotNull SequenceScope<? super Tile> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
        return sequence;
    }

    @NotNull
    public final Sequence<Tile> getTilesInRectangle(@NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter(rectangle, "rectangle");
        return SequencesKt.filterNotNull(SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Tile>, Continuation<? super Unit>, Object>(rectangle, this, null){
            int I$0;
            int I$1;
            int I$2;
            int I$3;
            int I$4;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Rectangle $rectangle;
            final /* synthetic */ TileMap this$0;
            {
                this.$rectangle = $rectangle;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                block7: {
                    var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    block0 : switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(var1_1);
                            $this$sequence = (SequenceScope)this.L$0;
                            x = (int)this.$rectangle.x;
                            y = (int)this.$rectangle.y;
                            worldColumnNumber = x;
                            var6_7 = x + (int)this.$rectangle.width;
lbl10:
                            // 2 sources

                            while (worldColumnNumber < var6_7) {
                                worldRowNumber = y;
                                var8_9 = y + (int)this.$rectangle.height;
lbl13:
                                // 2 sources

                                while (worldRowNumber < var8_9) {
                                    hexCoords = HexMath.INSTANCE.getTileCoordsFromColumnRow(worldColumnNumber, worldRowNumber);
                                    this.L$0 = $this$sequence;
                                    this.I$0 = y;
                                    this.I$1 = worldColumnNumber;
                                    this.I$2 = var6_7;
                                    this.I$3 = worldRowNumber;
                                    this.I$4 = var8_9;
                                    this.label = 1;
                                    v0 = $this$sequence.yield(this.this$0.getIfTileExistsOrNull((int)hexCoords.x, (int)hexCoords.y), this);
                                    if (v0 == var10_2) {
                                        return var10_2;
                                    }
                                    ** GOTO lbl37
                                }
                                break block0;
                            }
                            break block7;
                        }
                        case 1: {
                            var8_9 = this.I$4;
                            worldRowNumber = this.I$3;
                            var6_7 = this.I$2;
                            worldColumnNumber = this.I$1;
                            y = this.I$0;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl37:
                            // 2 sources

                            ++worldRowNumber;
                            ** GOTO lbl13
                        }
                    }
                    ++worldColumnNumber;
                    ** GOTO lbl10
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super Tile>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super Tile> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Nullable
    public final Tile getIfTileExistsOrNull(int x, int y) {
        if (this.contains(x, y)) {
            return this.get(x, y);
        }
        if (!this.mapParameters.getWorldWrap()) {
            return null;
        }
        int radius = this.mapParameters.getMapSize().getRadius();
        if (Intrinsics.areEqual(this.mapParameters.getShape(), "Rectangular")) {
            radius = this.mapParameters.getMapSize().getWidth() / 2;
        }
        if (this.contains(x + radius, y - radius)) {
            return this.get(x + radius, y - radius);
        }
        if (this.contains(x - radius, y + radius)) {
            return this.get(x - radius, y + radius);
        }
        return null;
    }

    public final int getNeighborTileClockPosition(@NotNull Tile tile, @NotNull Tile otherTile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(otherTile, "otherTile");
        int radius = Intrinsics.areEqual(this.mapParameters.getShape(), "Rectangular") ? this.mapParameters.getMapSize().getWidth() / 2 : this.mapParameters.getMapSize().getRadius();
        int x1 = (int)tile.getPosition().x;
        int y1 = (int)tile.getPosition().y;
        int x2 = (int)otherTile.getPosition().x;
        int y2 = (int)otherTile.getPosition().y;
        int xDifference = x1 - x2;
        int yDifference = y1 - y2;
        int xWrapDifferenceBottom = radius < 3 ? 0 : x1 - (x2 - radius);
        int yWrapDifferenceBottom = radius < 3 ? 0 : y1 - (y2 - radius);
        int xWrapDifferenceTop = radius < 3 ? 0 : x1 - (x2 + radius);
        int yWrapDifferenceTop = radius < 3 ? 0 : y1 - (y2 + radius);
        return xDifference == 1 && yDifference == 1 ? 6 : (xDifference == -1 && yDifference == -1 ? 12 : (xDifference == 1 || xWrapDifferenceBottom == 1 ? 4 : (yDifference == 1 || yWrapDifferenceBottom == 1 ? 8 : (xDifference == -1 || xWrapDifferenceTop == -1 ? 10 : (yDifference == -1 || yWrapDifferenceTop == -1 ? 2 : -1)))));
    }

    @Nullable
    public final Tile getClockPositionNeighborTile(@NotNull Tile tile, int clockPosition) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Vector2 difference = HexMath.INSTANCE.getClockPositionToHexVector(clockPosition);
        if (Intrinsics.areEqual(difference, Vector2.Zero)) {
            return null;
        }
        Vector2 possibleNeighborPosition = tile.getPosition().cpy().add(difference);
        return this.getIfTileExistsOrNull((int)possibleNeighborPosition.x, (int)possibleNeighborPosition.y);
    }

    @NotNull
    public final Vector2 getNeighborTilePositionAsWorldCoords(@NotNull Tile tile, @NotNull Tile otherTile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(otherTile, "otherTile");
        return HexMath.INSTANCE.getClockPositionToWorldVector(this.getNeighborTileClockPosition(tile, otherTile));
    }

    @NotNull
    public final Vector2 getUnWrappedPosition(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        if (!this.contains(position)) {
            return position;
        }
        int radius = Intrinsics.areEqual(this.mapParameters.getShape(), "Rectangular") ? this.mapParameters.getMapSize().getWidth() / 2 : this.mapParameters.getMapSize().getRadius();
        Vector2 vectorUnwrappedLeft = new Vector2(position.x + (float)radius, position.y - (float)radius);
        Vector2 vectorUnwrappedRight = new Vector2(position.x - (float)radius, position.y + (float)radius);
        return vectorUnwrappedRight.len() < vectorUnwrappedLeft.len() ? vectorUnwrappedRight : vectorUnwrappedLeft;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Tile> getViewableTiles(@NotNull Vector2 position, int sightDistance, boolean forAttack) {
        void $this$map$iv;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$map;
        ViewableTile it;
        void $this$filterTo$iv$iv;
        Collection destination$iv$iv;
        boolean $i$f$filter;
        Iterable<ViewableTile> tilesToAddInDistanceI;
        Intrinsics.checkNotNullParameter(position, "position");
        int aUnitHeight = this.get(position).getUnitHeight();
        ViewableTile[] viewableTileArray = new ViewableTile[]{new ViewableTile(this.get(position), aUnitHeight, true, false)};
        List<ViewableTile> viewableTiles = CollectionsKt.mutableListOf(viewableTileArray);
        int i = 1;
        int n = sightDistance + 1;
        if (i <= n) {
            while (true) {
                tilesToAddInDistanceI = new ArrayList();
                Iterator<Tile> iterator2 = this.getTilesAtDistance(position, i).iterator();
                while (iterator2.hasNext()) {
                    void $this$filterTo$iv$iv2;
                    void $this$filter$iv;
                    Tile cTile = iterator2.next();
                    int cTileHeight = cTile.getTileHeight();
                    if (i == sightDistance + 1 && (cTileHeight <= aUnitHeight || forAttack)) continue;
                    Iterable iterable = viewableTiles;
                    boolean $i$f$filter22 = false;
                    void var15_32 = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                        ViewableTile it2 = (ViewableTile)element$iv$iv;
                        boolean bl = false;
                        if (!(it2.getTile().aerialDistanceTo(cTile) == 1)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    Iterator $i$f$filter22 = ((Iterable)((List)destination$iv$iv2)).iterator();
                    if (!$i$f$filter22.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    ViewableTile it3 = (ViewableTile)$i$f$filter22.next();
                    boolean bl = false;
                    int n2 = it3.getMaxHeightSeenToTile();
                    while ($i$f$filter22.hasNext()) {
                        ViewableTile it4 = (ViewableTile)$i$f$filter22.next();
                        $i$a$-minOf-TileMap$getViewableTiles$bMinimumHighestSeenTerrainSoFar$2 = false;
                        int n3 = it4.getMaxHeightSeenToTile();
                        if (n2 <= n3) continue;
                        n2 = n3;
                    }
                    int bMinimumHighestSeenTerrainSoFar = n2;
                    ((ArrayList)tilesToAddInDistanceI).add(new ViewableTile(cTile, Integer.max(cTileHeight, bMinimumHighestSeenTerrainSoFar), aUnitHeight >= bMinimumHighestSeenTerrainSoFar || cTileHeight > bMinimumHighestSeenTerrainSoFar, aUnitHeight >= bMinimumHighestSeenTerrainSoFar || cTile.getUnitHeight() > bMinimumHighestSeenTerrainSoFar));
                }
                viewableTiles.addAll((Collection)tilesToAddInDistanceI);
                if (i == n) break;
                ++i;
            }
        }
        if (forAttack) {
            void $this$map$iv2;
            Iterable $this$filter$iv = viewableTiles;
            $i$f$filter = false;
            tilesToAddInDistanceI = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ViewableTile)element$iv$iv;
                boolean bl = false;
                if (!it.isAttackable()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ViewableTile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getTile());
            }
            return (List)destination$iv$iv;
        }
        Iterable $this$filter$iv = viewableTiles;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ViewableTile)element$iv$iv;
            boolean bl = false;
            if (!it.isVisible()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ViewableTile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getTile());
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getViewableTiles$default(TileMap tileMap, Vector2 vector2, int n, boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return tileMap.getViewableTiles(vector2, n, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HashSet<String> getRulesetIncompatibility(@NotNull Ruleset ruleset2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        HashSet<String> rulesetIncompatibilities = new HashSet<String>();
        Iterable $this$map$iv = this.getValues();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tile tile = (Tile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getRulesetIncompatibility(ruleset2));
        }
        for (HashSet set2 : (List)destination$iv$iv) {
            rulesetIncompatibilities.addAll(set2);
        }
        try {
            TileMap.setTransients$default(this, ruleset2, false, 2, null);
        }
        catch (Exception _) {
            return rulesetIncompatibilities;
        }
        this.setStartingLocationsTransients();
        Iterator<Object> iterator2 = this.startingLocations.iterator();
        while (iterator2.hasNext()) {
            String nationName = ((StartingLocation)iterator2.next()).component2();
            if (((Map)ruleset2.getNations()).containsKey(nationName)) continue;
            rulesetIncompatibilities.add("Nation [" + nationName + "] does not exist in ruleset!");
        }
        rulesetIncompatibilities.remove("");
        return rulesetIncompatibilities;
    }

    public final boolean isWaterMap() {
        int n;
        this.assignContinents(AssignContinentsMode.Ensure);
        Map $this$count$iv = this.continentSizes;
        boolean $i$f$count = false;
        if ($this$count$iv.isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            Iterator iterator2 = $this$count$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator2.next();
                boolean bl = false;
                if (!(((Number)it.getValue()).intValue() > 20)) continue;
                ++count$iv;
            }
            n = count$iv;
        }
        int bigIslands = n;
        int players = this.getGameInfo().getGameParameters().getPlayers().size();
        return bigIslands >= players;
    }

    public final void setTransients(@Nullable Ruleset ruleset2, boolean setUnitCivTransients) {
        int rightX2;
        if (ruleset2 != null) {
            this.ruleset = ruleset2;
        }
        if (!(this.ruleset != null)) {
            boolean $i$a$-check-TileMap$setTransients$22 = false;
            String $i$a$-check-TileMap$setTransients$22 = "TileMap.setTransients called without ruleset";
            throw new IllegalStateException($i$a$-check-TileMap$setTransients$22.toString());
        }
        if (this.tileMatrix.isEmpty()) {
            Object r = SequencesKt.maxOrNull(SequencesKt.map(CollectionsKt.asSequence((Iterable)this.tileList), setTransients.topY.1.INSTANCE));
            Intrinsics.checkNotNull(r);
            int topY2 = ((Number)r).intValue();
            Object r2 = SequencesKt.minOrNull(SequencesKt.map(CollectionsKt.asSequence((Iterable)this.tileList), setTransients.2.INSTANCE));
            Intrinsics.checkNotNull(r2);
            this.bottomY = ((Number)r2).intValue();
            Object r3 = SequencesKt.maxOrNull(SequencesKt.map(CollectionsKt.asSequence((Iterable)this.tileList), setTransients.rightX.1.INSTANCE));
            Intrinsics.checkNotNull(r3);
            rightX2 = ((Number)r3).intValue();
            Object r4 = SequencesKt.minOrNull(SequencesKt.map(CollectionsKt.asSequence((Iterable)this.tileList), setTransients.3.INSTANCE));
            Intrinsics.checkNotNull(r4);
            this.leftX = ((Number)r4).intValue();
            this.tileMatrix.ensureCapacity(rightX2 - this.leftX + 1);
            int x = this.leftX;
            if (x <= rightX2) {
                while (true) {
                    ArrayList<Object> row = new ArrayList<Object>(topY2 - this.bottomY + 1);
                    int y = this.bottomY;
                    if (y <= topY2) {
                        while (true) {
                            row.add(null);
                            if (y == topY2) break;
                            ++y;
                        }
                    }
                    this.tileMatrix.add(row);
                    if (x != rightX2) {
                        ++x;
                        continue;
                    }
                    break;
                }
            }
        } else {
            int n = -2 * this.leftX;
            rightX2 = 3 - 2 * this.leftX;
            int n2 = this.tileMatrix.size();
            if (!(n <= n2 ? n2 <= rightX2 : false)) {
                boolean $i$a$-check-TileMap$setTransients$52 = false;
                String $i$a$-check-TileMap$setTransients$52 = "TileMap.setTransients called on existing tileMatrix of different size";
                throw new IllegalStateException($i$a$-check-TileMap$setTransients$52.toString());
            }
        }
        for (Tile tileInfo : this.getValues()) {
            this.tileMatrix.get((int)tileInfo.getPosition().x - this.leftX).set((int)tileInfo.getPosition().y - this.bottomY, tileInfo);
        }
        for (Tile tileInfo : this.getValues()) {
            tileInfo.setTileMap(this);
            Ruleset ruleset3 = this.ruleset;
            Intrinsics.checkNotNull(ruleset3);
            tileInfo.setRuleset(ruleset3);
            tileInfo.setTerrainTransients();
            tileInfo.setUnitTransients(setUnitCivTransients);
        }
    }

    public static /* synthetic */ void setTransients$default(TileMap tileMap, Ruleset ruleset2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            ruleset2 = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        tileMap.setTransients(ruleset2, bl);
    }

    public final void setNeutralTransients() {
        for (Tile tileInfo : this.getValues()) {
            tileInfo.setOwnerTransients();
        }
    }

    public final void removeMissingTerrainModReferences(@NotNull Ruleset ruleSet) {
        Intrinsics.checkNotNullParameter(ruleSet, "ruleSet");
        for (Tile tile : this.getValues()) {
            tile.removeMissingTerrainModReferences(ruleSet);
        }
        for (StartingLocation startingLocation : CollectionsKt.toList((Iterable)this.startingLocations)) {
            if (((Map)ruleSet.getNations()).containsKey(startingLocation.getNation())) continue;
            this.startingLocations.remove(startingLocation);
        }
    }

    @Nullable
    public final MapUnit placeUnitNearTile(@NotNull Vector2 position, @NotNull String unitName, @NotNull Civilization civInfo, @Nullable Integer unitId) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(unitName, "unitName");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        BaseUnit baseUnit = this.getGameInfo().getRuleset().getUnits().get(unitName);
        Intrinsics.checkNotNull(baseUnit);
        BaseUnit unit = baseUnit;
        return this.placeUnitNearTile(position, unit, civInfo, unitId);
    }

    public static /* synthetic */ MapUnit placeUnitNearTile$default(TileMap tileMap, Vector2 vector2, String string, Civilization civilization, Integer n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        return tileMap.placeUnitNearTile(vector2, string, civilization, n);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MapUnit placeUnitNearTile(@NotNull Vector2 position, @NotNull BaseUnit baseUnit, @NotNull Civilization civInfo, @Nullable Integer unitId) {
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(baseUnit, "baseUnit");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        MapUnit unit = baseUnit.getMapUnit(civInfo, unitId);
        unit.assignOwner(civInfo, false);
        unit.setOriginalOwner(civInfo.getCivName());
        Tile unitToPlaceTile = null;
        Tile currentTile = this.get(position);
        unit.setCurrentTile(currentTile);
        if (UnitMovement.canMoveTo$default(unit.getMovement(), currentTile, false, false, false, 14, null)) {
            unitToPlaceTile = currentTile;
        }
        if (unitToPlaceTile == null) {
            int tryCount = 0;
            Set potentialCandidates = TileMap.placeUnitNearTile$getPassableNeighbours(unit, currentTile);
            while (unitToPlaceTile == null && tryCount++ < 10) {
                Object v0;
                block9: {
                    void $this$firstOrNull$iv;
                    Iterable $this$sortedByDescending$iv;
                    Iterable iterable = potentialCandidates;
                    boolean $i$f$sortedByDescending = false;
                    $this$sortedByDescending$iv = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(unit){
                        final /* synthetic */ MapUnit $unit$inlined;
                        {
                            this.$unit$inlined = mapUnit;
                        }

                        public final int compare(T a, T b) {
                            Tile it = (Tile)b;
                            boolean bl = false;
                            boolean bl2 = this.$unit$inlined.getBaseUnit().isLandUnit() && !this.$unit$inlined.getCache().getCanMoveOnWater() ? it.isLand() : true;
                            it = (Tile)a;
                            Comparable comparable = Boolean.valueOf(bl2);
                            bl = false;
                            return ComparisonsKt.compareValues(comparable, this.$unit$inlined.getBaseUnit().isLandUnit() && !this.$unit$inlined.getCache().getCanMoveOnWater() ? it.isLand() : true);
                        }
                    });
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Tile it = (Tile)element$iv;
                        boolean bl = false;
                        if (!UnitMovement.canMoveTo$default(unit.getMovement(), it, false, false, false, 14, null)) continue;
                        v0 = element$iv;
                        break block9;
                    }
                    v0 = null;
                }
                if ((unitToPlaceTile = (Tile)v0) != null) continue;
                Set newPotentialCandidates = new LinkedHashSet();
                Iterable $this$forEach$iv = potentialCandidates;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Tile it = (Tile)element$iv;
                    boolean bl = false;
                    newPotentialCandidates.addAll((Collection)TileMap.placeUnitNearTile$getPassableNeighbours(unit, it));
                }
                potentialCandidates = newPotentialCandidates;
            }
        }
        if (unitToPlaceTile == null) {
            civInfo.getUnits().removeUnit(unit);
            return null;
        }
        unit.putInTile(unitToPlaceTile);
        unit.setCurrentMovement(unit.getMaxMovement());
        unit.addMovementMemory();
        for (String promotion2 : unit.getBaseUnit().getPromotions()) {
            UnitPromotions unitPromotions = unit.getPromotions();
            Intrinsics.checkNotNull(promotion2);
            unitPromotions.addPromotion(promotion2, true);
        }
        Iterator<String> iterator2 = Civilization.getMatchingUniques$default(civInfo, UniqueType.UnitsGainPromotion, null, 2, null).iterator();
        while (iterator2.hasNext()) {
            Unique unique = (Unique)((Object)iterator2.next());
            if (!unit.matchesFilter(unique.getParams().get(0))) continue;
            unit.getPromotions().addPromotion(unique.getParams().get(1), true);
        }
        civInfo.updateStatsForNextTurn();
        if (!((Map)unit.getResourceRequirementsPerTurn()).isEmpty()) {
            civInfo.getCache().updateCivResources();
        }
        return unit;
    }

    public static /* synthetic */ MapUnit placeUnitNearTile$default(TileMap tileMap, Vector2 vector2, BaseUnit baseUnit, Civilization civilization, Integer n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        return tileMap.placeUnitNearTile(vector2, baseUnit, civilization, n);
    }

    public final void stripPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Iterable $this$forEach$iv = this.tileList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tile it = (Tile)element$iv;
            boolean bl = false;
            Iterator<MapUnit> iterator2 = it.getUnits().iterator();
            while (iterator2.hasNext()) {
                MapUnit unit = iterator2.next();
                if (!Intrinsics.areEqual(unit.getOwner(), player.getChosenCiv())) continue;
                unit.removeFromTile();
            }
        }
        CollectionsKt.removeAll((List)this.startingLocations, (Function1)new Function1<StartingLocation, Boolean>(player){
            final /* synthetic */ Player $player;
            {
                this.$player = $player;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull StartingLocation it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getNation(), this.$player.getChosenCiv());
            }
        });
        this.startingLocationsByNation.remove(player.getChosenCiv());
    }

    /*
     * WARNING - void declaration
     */
    public final void switchPlayersNation(@NotNull Player player, @NotNull Nation newNation) {
        void $this$filterTo$iv$iv;
        Object element$iv2;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(newNation, "newNation");
        Civilization civilization = new Civilization(newNation.getName());
        Civilization $this$switchPlayersNation_u24lambda_u2416 = civilization;
        boolean bl = false;
        $this$switchPlayersNation_u24lambda_u2416.setNation(newNation);
        Civilization newCiv = civilization;
        Iterable $this$forEach$iv = this.tileList;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Tile it = (Tile)element$iv2;
            boolean bl2 = false;
            Iterator<MapUnit> iterator2 = it.getUnits().iterator();
            while (iterator2.hasNext()) {
                MapUnit unit = iterator2.next();
                if (!Intrinsics.areEqual(unit.getOwner(), player.getChosenCiv())) continue;
                unit.setOwner(newNation.getName());
                unit.setCiv(newCiv);
            }
        }
        Iterable $this$filter$iv = this.startingLocations;
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (MapUnit element$iv$iv : $this$filterTo$iv$iv) {
            StartingLocation it = (StartingLocation)((Object)element$iv$iv);
            boolean bl3 = false;
            if (!(!Intrinsics.areEqual(it.getNation(), player.getChosenCiv()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (StartingLocation element : (List)destination$iv$iv) {
            boolean bl4;
            block7: {
                this.startingLocations.remove(element);
                Iterable $this$none$iv = this.startingLocations;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl4 = true;
                } else {
                    for (Object element$iv3 : $this$none$iv) {
                        StartingLocation it = (StartingLocation)element$iv3;
                        boolean bl5 = false;
                        if (!(Intrinsics.areEqual(it.getNation(), newNation.getName()) && Intrinsics.areEqual(it.getPosition(), element.getPosition()))) continue;
                        bl4 = false;
                        break block7;
                    }
                    bl4 = true;
                }
            }
            if (!bl4) continue;
            this.startingLocations.add(new StartingLocation(element.getPosition(), newNation.getName(), null, 4, null));
        }
        this.setStartingLocationsTransients();
    }

    public final void setStartingLocationsTransients() {
        this.startingLocationsByNation.clear();
        for (StartingLocation startingLocation : this.startingLocations) {
            Vector2 position = startingLocation.component1();
            String nationName = startingLocation.component2();
            CollectionExtensionsKt.addToMapOfSets(this.startingLocationsByNation, nationName, this.get(position));
        }
    }

    public final boolean addStartingLocation(@NotNull String nationName, @NotNull Tile tile, @NotNull StartingLocation.Usage usage) {
        Intrinsics.checkNotNullParameter(nationName, "nationName");
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter((Object)usage, "usage");
        if (CollectionExtensionsKt.contains(this.startingLocationsByNation, nationName, tile)) {
            return false;
        }
        this.startingLocations.add(new StartingLocation(tile.getPosition(), nationName, usage));
        return CollectionExtensionsKt.addToMapOfSets(this.startingLocationsByNation, nationName, tile);
    }

    public static /* synthetic */ boolean addStartingLocation$default(TileMap tileMap, String string, Tile tile, StartingLocation.Usage usage, int n, Object object) {
        if ((n & 4) != 0) {
            usage = StartingLocation.Usage.Player;
        }
        return tileMap.addStartingLocation(string, tile, usage);
    }

    public final boolean removeStartingLocation(@NotNull String nationName, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(nationName, "nationName");
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!CollectionExtensionsKt.contains(this.startingLocationsByNation, nationName, tile)) {
            return false;
        }
        this.startingLocations.remove(new StartingLocation(tile.getPosition(), nationName, null, 4, null));
        HashSet<Tile> hashSet = this.startingLocationsByNation.get(nationName);
        Intrinsics.checkNotNull(hashSet);
        return hashSet.remove(tile);
    }

    public final void removeStartingLocations(@NotNull String nationName) {
        Intrinsics.checkNotNullParameter(nationName, "nationName");
        if (this.startingLocationsByNation.get(nationName) == null) {
            return;
        }
        HashSet<Tile> hashSet = this.startingLocationsByNation.get(nationName);
        Intrinsics.checkNotNull(hashSet);
        for (Tile tile : hashSet) {
            this.startingLocations.remove(new StartingLocation(tile.getPosition(), nationName, null, 4, null));
        }
        HashSet<Tile> hashSet2 = this.startingLocationsByNation.get(nationName);
        Intrinsics.checkNotNull(hashSet2);
        hashSet2.clear();
    }

    public final void removeStartingLocations(@NotNull Vector2 position) {
        Intrinsics.checkNotNullParameter(position, "position");
        CollectionsKt.removeAll((List)this.startingLocations, (Function1)new Function1<StartingLocation, Boolean>(position){
            final /* synthetic */ Vector2 $position;
            {
                this.$position = $position;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull StartingLocation it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getPosition(), this.$position);
            }
        });
        this.setStartingLocationsTransients();
    }

    public final void clearStartingLocations() {
        this.startingLocations.clear();
        this.startingLocationsByNation.clear();
    }

    /*
     * WARNING - void declaration
     */
    public final void assignContinents(@NotNull AssignContinentsMode mode) {
        void $this$filterTo$iv$iv;
        Object element$iv2;
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        if (mode == AssignContinentsMode.Clear) {
            Iterable $this$forEach$iv = this.getValues();
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                Tile it = (Tile)element$iv2;
                boolean bl = false;
                it.clearContinent();
            }
            this.continentSizes.clear();
            return;
        }
        if (mode == AssignContinentsMode.Ensure) {
            if (!((Map)this.continentSizes).isEmpty()) {
                return;
            }
            for (Tile tile : this.getValues()) {
                int continent = tile.getContinent();
                if (continent == -1) continue;
                element$iv2 = this.continentSizes;
                Integer it = continent;
                Integer n = this.continentSizes.get(continent);
                if (n == null) {
                    n = 0;
                }
                Integer bl = 1 + ((Number)n).intValue();
                element$iv2.put(it, bl);
            }
            if (!((Map)this.continentSizes).isEmpty()) {
                return;
            }
        }
        Iterable $this$filter$iv = this.getValues();
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Tile it = (Tile)element$iv$iv;
            boolean bl = false;
            if (!(it.isLand() && !it.isImpassible())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List landTiles = (List)destination$iv$iv;
        int currentContinent = 0;
        this.continentSizes.clear();
        if (mode == AssignContinentsMode.Reassign) {
            Iterable $this$forEach$iv = this.getValues();
            boolean $i$f$forEach = false;
            for (Object element$iv3 : $this$forEach$iv) {
                Tile it = (Tile)element$iv3;
                boolean bl = false;
                it.clearContinent();
            }
        }
        while (CollectionsKt.any(landTiles)) {
            void $this$filterTo$iv$iv2;
            Object element$iv42;
            BFS bfs2 = new BFS((Tile)CollectionsKt.random(landTiles, Random.Default), assignContinents.bfs.1.INSTANCE);
            bfs2.stepToEnd();
            Iterable $this$forEach$iv = bfs2.getReachedTiles();
            int $i$f$forEach = 0;
            for (Object element$iv42 : $this$forEach$iv) {
                Tile it = (Tile)element$iv42;
                boolean bl = false;
                it.setContinent(currentContinent);
            }
            Set<Tile> continent = bfs2.getReachedTiles();
            ((Map)this.continentSizes).put(currentContinent, continent.size());
            $i$f$forEach = currentContinent;
            currentContinent = $i$f$forEach + 1;
            Iterable $this$filter$iv2 = landTiles;
            boolean $i$f$filter2 = false;
            element$iv42 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Tile it = (Tile)element$iv$iv;
                boolean bl = false;
                if (!(!continent.contains(it))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            landTiles = (List)destination$iv$iv2;
        }
    }

    private static final Set<Tile> placeUnitNearTile$getPassableNeighbours(MapUnit unit, Tile tile) {
        return SequencesKt.toSet(SequencesKt.filter(tile.getNeighbors(), (Function1)new Function1<Tile, Boolean>(unit){
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return UnitMovement.canPassThrough$default(this.$unit.getMovement(), it, false, 2, null);
            }
        }));
    }

    public TileMap() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/logic/map/TileMap$AssignContinentsMode;", "", "(Ljava/lang/String;I)V", "Assign", "Reassign", "Ensure", "Clear", "core"})
    public static final class AssignContinentsMode
    extends Enum<AssignContinentsMode> {
        public static final /* enum */ AssignContinentsMode Assign = new AssignContinentsMode();
        public static final /* enum */ AssignContinentsMode Reassign = new AssignContinentsMode();
        public static final /* enum */ AssignContinentsMode Ensure = new AssignContinentsMode();
        public static final /* enum */ AssignContinentsMode Clear = new AssignContinentsMode();
        private static final /* synthetic */ AssignContinentsMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AssignContinentsMode[] values() {
            return (AssignContinentsMode[])$VALUES.clone();
        }

        public static AssignContinentsMode valueOf(String value) {
            return Enum.valueOf(AssignContinentsMode.class, value);
        }

        @NotNull
        public static EnumEntries<AssignContinentsMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = assignContinentsModeArray = new AssignContinentsMode[]{AssignContinentsMode.Assign, AssignContinentsMode.Reassign, AssignContinentsMode.Ensure, AssignContinentsMode.Clear};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/unciv/logic/map/TileMap$Preview;", "", "()V", "mapParameters", "Lcom/unciv/logic/map/MapParameters;", "getMapParameters", "()Lcom/unciv/logic/map/MapParameters;", "startingLocations", "Ljava/util/ArrayList;", "Lcom/unciv/logic/map/TileMap$StartingLocation;", "Lkotlin/collections/ArrayList;", "getDeclaredNations", "Lkotlin/sequences/Sequence;", "", "getNationsForHumanPlayer", "core"})
    public static final class Preview {
        @NotNull
        private final MapParameters mapParameters = new MapParameters();
        @NotNull
        private final ArrayList<StartingLocation> startingLocations = new ArrayList();

        @NotNull
        public final MapParameters getMapParameters() {
            return this.mapParameters;
        }

        @NotNull
        public final Sequence<String> getDeclaredNations() {
            return SequencesKt.distinct(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.startingLocations), getDeclaredNations.1.INSTANCE), getDeclaredNations.2.INSTANCE));
        }

        @NotNull
        public final Sequence<String> getNationsForHumanPlayer() {
            return SequencesKt.distinct(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.startingLocations), getNationsForHumanPlayer.1.INSTANCE), getNationsForHumanPlayer.2.INSTANCE));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001aB#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/unciv/logic/map/TileMap$StartingLocation;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "position", "Lcom/badlogic/gdx/math/Vector2;", "nation", "", "usage", "Lcom/unciv/logic/map/TileMap$StartingLocation$Usage;", "(Lcom/badlogic/gdx/math/Vector2;Ljava/lang/String;Lcom/unciv/logic/map/TileMap$StartingLocation$Usage;)V", "getNation", "()Ljava/lang/String;", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "getUsage", "()Lcom/unciv/logic/map/TileMap$StartingLocation$Usage;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Usage", "core"})
    public static final class StartingLocation
    implements IsPartOfGameInfoSerialization {
        @NotNull
        private final Vector2 position;
        @NotNull
        private final String nation;
        @NotNull
        private final Usage usage;

        public StartingLocation(@NotNull Vector2 position, @NotNull String nation2, @NotNull Usage usage) {
            Intrinsics.checkNotNullParameter(position, "position");
            Intrinsics.checkNotNullParameter(nation2, "nation");
            Intrinsics.checkNotNullParameter((Object)usage, "usage");
            this.position = position;
            this.nation = nation2;
            this.usage = usage;
        }

        public /* synthetic */ StartingLocation(Vector2 vector2, String string, Usage usage, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                Vector2 vector22 = Vector2.Zero;
                Intrinsics.checkNotNullExpressionValue(vector22, "Zero");
                vector2 = vector22;
            }
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                usage = Usage.Companion.getDefault();
            }
            this(vector2, string, usage);
        }

        @NotNull
        public final Vector2 getPosition() {
            return this.position;
        }

        @NotNull
        public final String getNation() {
            return this.nation;
        }

        @NotNull
        public final Usage getUsage() {
            return this.usage;
        }

        @NotNull
        public final Vector2 component1() {
            return this.position;
        }

        @NotNull
        public final String component2() {
            return this.nation;
        }

        @NotNull
        public final Usage component3() {
            return this.usage;
        }

        @NotNull
        public final StartingLocation copy(@NotNull Vector2 position, @NotNull String nation2, @NotNull Usage usage) {
            Intrinsics.checkNotNullParameter(position, "position");
            Intrinsics.checkNotNullParameter(nation2, "nation");
            Intrinsics.checkNotNullParameter((Object)usage, "usage");
            return new StartingLocation(position, nation2, usage);
        }

        public static /* synthetic */ StartingLocation copy$default(StartingLocation startingLocation, Vector2 vector2, String string, Usage usage, int n, Object object) {
            if ((n & 1) != 0) {
                vector2 = startingLocation.position;
            }
            if ((n & 2) != 0) {
                string = startingLocation.nation;
            }
            if ((n & 4) != 0) {
                usage = startingLocation.usage;
            }
            return startingLocation.copy(vector2, string, usage);
        }

        @NotNull
        public String toString() {
            return "StartingLocation(position=" + this.position + ", nation=" + this.nation + ", usage=" + (Object)((Object)this.usage) + ')';
        }

        public int hashCode() {
            int result2 = this.position.hashCode();
            result2 = result2 * 31 + this.nation.hashCode();
            result2 = result2 * 31 + this.usage.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StartingLocation)) {
                return false;
            }
            StartingLocation startingLocation = (StartingLocation)other;
            if (!Intrinsics.areEqual(this.position, startingLocation.position)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.nation, startingLocation.nation)) {
                return false;
            }
            return this.usage == startingLocation.usage;
        }

        public StartingLocation() {
            this(null, null, null, 7, null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\nB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u000b"}, d2={"Lcom/unciv/logic/map/TileMap$StartingLocation$Usage;", "", "label", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getLabel", "()Ljava/lang/String;", "Normal", "Player", "Human", "Companion", "core"})
        public static final class Usage
        extends Enum<Usage> {
            @NotNull
            public static final Companion Companion;
            @NotNull
            private final String label;
            public static final /* enum */ Usage Normal;
            public static final /* enum */ Usage Player;
            public static final /* enum */ Usage Human;
            private static final /* synthetic */ Usage[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Usage(String label2) {
                this.label = label2;
            }

            @NotNull
            public final String getLabel() {
                return this.label;
            }

            public static Usage[] values() {
                return (Usage[])$VALUES.clone();
            }

            public static Usage valueOf(String value) {
                return Enum.valueOf(Usage.class, value);
            }

            @NotNull
            public static EnumEntries<Usage> getEntries() {
                return $ENTRIES;
            }

            static {
                Normal = new Usage("None");
                Player = new Usage("Player");
                Human = new Usage("Human");
                $VALUES = usageArray = new Usage[]{Usage.Normal, Usage.Player, Usage.Human};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/logic/map/TileMap$StartingLocation$Usage$Companion;", "", "()V", "default", "Lcom/unciv/logic/map/TileMap$StartingLocation$Usage;", "getDefault", "()Lcom/unciv/logic/map/TileMap$StartingLocation$Usage;", "core"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final Usage getDefault() {
                    return Player;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/unciv/logic/map/TileMap$ViewableTile;", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "maxHeightSeenToTile", "", "isVisible", "", "isAttackable", "(Lcom/unciv/logic/map/tile/Tile;IZZ)V", "()Z", "getMaxHeightSeenToTile", "()I", "getTile", "()Lcom/unciv/logic/map/tile/Tile;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "core"})
    public static final class ViewableTile {
        @NotNull
        private final Tile tile;
        private final int maxHeightSeenToTile;
        private final boolean isVisible;
        private final boolean isAttackable;

        public ViewableTile(@NotNull Tile tile, int maxHeightSeenToTile, boolean isVisible, boolean isAttackable) {
            Intrinsics.checkNotNullParameter(tile, "tile");
            this.tile = tile;
            this.maxHeightSeenToTile = maxHeightSeenToTile;
            this.isVisible = isVisible;
            this.isAttackable = isAttackable;
        }

        @NotNull
        public final Tile getTile() {
            return this.tile;
        }

        public final int getMaxHeightSeenToTile() {
            return this.maxHeightSeenToTile;
        }

        public final boolean isVisible() {
            return this.isVisible;
        }

        public final boolean isAttackable() {
            return this.isAttackable;
        }

        @NotNull
        public final Tile component1() {
            return this.tile;
        }

        public final int component2() {
            return this.maxHeightSeenToTile;
        }

        public final boolean component3() {
            return this.isVisible;
        }

        public final boolean component4() {
            return this.isAttackable;
        }

        @NotNull
        public final ViewableTile copy(@NotNull Tile tile, int maxHeightSeenToTile, boolean isVisible, boolean isAttackable) {
            Intrinsics.checkNotNullParameter(tile, "tile");
            return new ViewableTile(tile, maxHeightSeenToTile, isVisible, isAttackable);
        }

        public static /* synthetic */ ViewableTile copy$default(ViewableTile viewableTile, Tile tile, int n, boolean bl, boolean bl2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                tile = viewableTile.tile;
            }
            if ((n2 & 2) != 0) {
                n = viewableTile.maxHeightSeenToTile;
            }
            if ((n2 & 4) != 0) {
                bl = viewableTile.isVisible;
            }
            if ((n2 & 8) != 0) {
                bl2 = viewableTile.isAttackable;
            }
            return viewableTile.copy(tile, n, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "ViewableTile(tile=" + this.tile + ", maxHeightSeenToTile=" + this.maxHeightSeenToTile + ", isVisible=" + this.isVisible + ", isAttackable=" + this.isAttackable + ')';
        }

        public int hashCode() {
            int result2 = this.tile.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.maxHeightSeenToTile);
            result2 = result2 * 31 + Boolean.hashCode(this.isVisible);
            result2 = result2 * 31 + Boolean.hashCode(this.isAttackable);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ViewableTile)) {
                return false;
            }
            ViewableTile viewableTile = (ViewableTile)other;
            if (!Intrinsics.areEqual(this.tile, viewableTile.tile)) {
                return false;
            }
            if (this.maxHeightSeenToTile != viewableTile.maxHeightSeenToTile) {
                return false;
            }
            if (this.isVisible != viewableTile.isVisible) {
                return false;
            }
            return this.isAttackable == viewableTile.isAttackable;
        }
    }
}

