/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapgenerator;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapgenerator.MapGenerationRandomness;
import com.unciv.logic.map.mapgenerator.RiverGenerator;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.utils.LogKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0003\u001a\u001b\u001cB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u0010\b\u0002\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0016J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u000fH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/unciv/logic/map/mapgenerator/RiverGenerator;", "", "tileMap", "Lcom/unciv/logic/map/TileMap;", "randomness", "Lcom/unciv/logic/map/mapgenerator/MapGenerationRandomness;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "(Lcom/unciv/logic/map/TileMap;Lcom/unciv/logic/map/mapgenerator/MapGenerationRandomness;Lcom/unciv/models/ruleset/Ruleset;)V", "maxRiverLength", "", "minRiverLength", "riverCountMultiplier", "", "getClosestWaterTile", "Lcom/unciv/logic/map/tile/Tile;", "tile", "spawnRiver", "", "initialPosition", "endPosition", "resultingTiles", "", "spawnRivers", "isFarEnoughFromWater", "", "Companion", "RiverCoordinate", "RiverDirections", "core"})
@SourceDebugExtension(value={"SMAP\nRiverGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiverGenerator.kt\ncom/unciv/logic/map/mapgenerator/RiverGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,290:1\n2624#2,3:291\n1774#2,4:294\n766#2:298\n857#2,2:299\n766#2:301\n857#2,2:302\n1247#3,2:304\n1247#3,2:306\n988#3:308\n1017#3,3:309\n1020#3,3:319\n372#4,7:312\n1#5:322\n*S KotlinDebug\n*F\n+ 1 RiverGenerator.kt\ncom/unciv/logic/map/mapgenerator/RiverGenerator\n*L\n28#1:291,3\n29#1:294,4\n35#1:298\n35#1:299,2\n38#1:301\n38#1:302,2\n48#1:304,2\n77#1:306,2\n81#1:308\n81#1:309,3\n81#1:319,3\n81#1:312,7\n*E\n"})
public final class RiverGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TileMap tileMap;
    @NotNull
    private final MapGenerationRandomness randomness;
    private final float riverCountMultiplier;
    private final int minRiverLength;
    private final int maxRiverLength;

    public RiverGenerator(@NotNull TileMap tileMap, @NotNull MapGenerationRandomness randomness, @NotNull Ruleset ruleset2) {
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        Intrinsics.checkNotNullParameter(randomness, "randomness");
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        this.tileMap = tileMap;
        this.randomness = randomness;
        this.riverCountMultiplier = ruleset2.getModOptions().getConstants().getRiverCountMultiplier();
        this.minRiverLength = ruleset2.getModOptions().getConstants().getMinRiverLength();
        this.maxRiverLength = ruleset2.getModOptions().getConstants().getMaxRiverLength();
    }

    /*
     * WARNING - void declaration
     */
    public final void spawnRivers(@Nullable Set<Tile> resultingTiles) {
        Tile it;
        Iterable $this$filterTo$iv$iv;
        int n;
        Object it2;
        boolean bl;
        block12: {
            Iterable $this$none$iv = this.tileMap.getValues();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    it2 = (Tile)element$iv;
                    boolean bl2 = false;
                    if (!((Tile)it2).isWater()) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        Iterable $this$count$iv = this.tileMap.getValues();
        boolean $i$f$count2 = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Tile it3 = (Tile)element$iv;
                boolean bl3 = false;
                if (!it3.isLand() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int numberOfRivers = MathKt.roundToInt((float)n * this.riverCountMultiplier);
        List<Tile> optionalTiles2 = SequencesKt.toMutableList(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.tileMap.getValues()), (Function1)new Function1<Tile, Boolean>(this){
            final /* synthetic */ RiverGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getBaseTerrain(), "Mountain") && RiverGenerator.access$isFarEnoughFromWater(this.this$0, it);
            }
        }));
        if (optionalTiles2.size() < numberOfRivers) {
            void $this$filter$iv;
            Iterable $i$f$count2 = this.tileMap.getValues();
            List<Tile> list2 = optionalTiles2;
            boolean $i$f$filter = false;
            it2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Tile)element$iv$iv;
                boolean bl4 = false;
                if (!(it.isHill() && this.isFarEnoughFromWater(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2.addAll((List)destination$iv$iv);
        }
        if (optionalTiles2.size() < numberOfRivers) {
            Iterable $this$filter$iv = this.tileMap.getValues();
            boolean $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Tile)element$iv$iv;
                boolean bl5 = false;
                if (!(it.isLand() && this.isFarEnoughFromWater(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            optionalTiles2 = CollectionsKt.toMutableList((List)destination$iv$iv);
        }
        int mapRadius = this.tileMap.getMapParameters().getMapSize().getRadius();
        ArrayList<Tile> riverStarts = this.randomness.chooseSpreadOutLocations(numberOfRivers, optionalTiles2, mapRadius);
        for (Tile tile : riverStarts) {
            Intrinsics.checkNotNull(tile);
            this.spawnRiver(tile, resultingTiles);
        }
    }

    public static /* synthetic */ void spawnRivers$default(RiverGenerator riverGenerator, Set set2, int n, Object object) {
        if ((n & 1) != 0) {
            set2 = null;
        }
        riverGenerator.spawnRivers(set2);
    }

    private final boolean isFarEnoughFromWater(Tile $this$isFarEnoughFromWater) {
        int n = this.minRiverLength;
        for (int distance = 1; distance < n; ++distance) {
            boolean bl;
            block2: {
                Sequence<Tile> $this$any$iv = $this$isFarEnoughFromWater.getTilesAtDistance(distance);
                boolean $i$f$any = false;
                Iterator<Tile> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    Tile element$iv;
                    Tile it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!it.isWater()) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public final Tile getClosestWaterTile(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        int distance = 1;
        int n = this.maxRiverLength;
        if (distance <= n) {
            while (true) {
                Sequence<Tile> waterTiles2;
                if (SequencesKt.any(waterTiles2 = SequencesKt.filter(tile.getTilesAtDistance(distance), getClosestWaterTile.waterTiles.1.INSTANCE))) {
                    return (Tile)CollectionsKt.random((Collection)SequencesKt.toList(waterTiles2), this.randomness.getRNG());
                }
                if (distance == n) break;
                ++distance;
            }
        }
        return null;
    }

    private final void spawnRiver(Tile initialPosition, Set<Tile> resultingTiles) {
        Tile tile = this.getClosestWaterTile(initialPosition);
        if (tile == null) {
            throw new IllegalStateException("No water found for river destination".toString());
        }
        Tile endPosition = tile;
        this.spawnRiver(initialPosition, endPosition, resultingTiles);
    }

    /*
     * WARNING - void declaration
     */
    public final void spawnRiver(@NotNull Tile initialPosition, @NotNull Tile endPosition, @Nullable Set<Tile> resultingTiles) {
        Intrinsics.checkNotNullParameter(initialPosition, "initialPosition");
        Intrinsics.checkNotNullParameter(endPosition, "endPosition");
        RiverCoordinate riverCoordinate = null;
        riverCoordinate = new RiverCoordinate(this.tileMap, initialPosition.getPosition(), ArraysKt.random(RiverCoordinate.BottomRightOrLeft.values(), this.randomness.getRNG()));
        int n = this.maxRiverLength;
        for (int i = 0; i < n; ++i) {
            Object v3;
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            boolean bl;
            Tile it;
            Object object;
            block12: {
                int it2 = i;
                boolean bl2 = false;
                Sequence<Tile> $this$any$iv = riverCoordinate.getAdjacentTiles();
                boolean $i$f$any = false;
                object = $this$any$iv.iterator();
                while (object.hasNext()) {
                    Tile element$iv;
                    it = element$iv = object.next();
                    boolean bl3 = false;
                    if (!it.isWater()) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
            if (bl) {
                return;
            }
            Sequence<RiverCoordinate> possibleCoordinates = riverCoordinate.getAdjacentPositions();
            if (SequencesKt.none(possibleCoordinates)) {
                return;
            }
            object = possibleCoordinates;
            boolean $i$f$groupBy = false;
            it = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                RiverCoordinate newCoordinate2 = (RiverCoordinate)element$iv$iv;
                boolean bl4 = false;
                Object r = SequencesKt.minOrNull(SequencesKt.map(newCoordinate2.getAdjacentTiles(), (Function1)new Function1<Tile, Integer>(endPosition){
                    final /* synthetic */ Tile $endPosition;
                    {
                        this.$endPosition = $endPosition;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(@NotNull Tile it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return it.aerialDistanceTo(this.$endPosition);
                    }
                }));
                Intrinsics.checkNotNull(r);
                Integer key$iv$iv = ((Number)r).intValue();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            Iterable iterable = destination$iv$iv.entrySet();
            Iterator iterator2 = iterable.iterator();
            if (!iterator2.hasNext()) {
                v3 = null;
            } else {
                Object object3 = iterator2.next();
                if (!iterator2.hasNext()) {
                    v3 = object3;
                } else {
                    Map.Entry it3 = (Map.Entry)object3;
                    boolean bl6 = false;
                    int n2 = ((Number)it3.getKey()).intValue();
                    do {
                        Iterator iterator3 = iterator2.next();
                        Map.Entry it4 = (Map.Entry)((Object)iterator3);
                        $i$a$-minByOrNull-RiverGenerator$spawnRiver$1$newCoordinate$2 = false;
                        int n3 = ((Number)it4.getKey()).intValue();
                        if (n2 <= n3) continue;
                        object3 = iterator3;
                        n2 = n3;
                    } while (iterator2.hasNext());
                    v3 = object3;
                }
            }
            Map.Entry entry = v3;
            Intrinsics.checkNotNull(entry);
            RiverCoordinate newCoordinate3 = (RiverCoordinate)CollectionsKt.random((Collection)entry.getValue(), this.randomness.getRNG());
            riverCoordinate.paintTo(newCoordinate3, resultingTiles);
            riverCoordinate = newCoordinate3;
        }
        LogKt.debug("River reached max length!", new Object[0]);
    }

    public static final /* synthetic */ boolean access$isFarEnoughFromWater(RiverGenerator $this, Tile $receiver) {
        return $this.isFarEnoughFromWater($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/logic/map/mapgenerator/RiverGenerator$Companion;", "", "()V", "continueRiverOn", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "core"})
    @SourceDebugExtension(value={"SMAP\nRiverGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiverGenerator.kt\ncom/unciv/logic/map/mapgenerator/RiverGenerator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,290:1\n1726#2,3:291\n2624#2,3:294\n1477#2:297\n1502#2,3:298\n1505#2,3:308\n372#3,7:301\n1#4:311\n*S KotlinDebug\n*F\n+ 1 RiverGenerator.kt\ncom/unciv/logic/map/mapgenerator/RiverGenerator$Companion\n*L\n276#1:291,3\n279#1:294,3\n282#1:297\n282#1:298,3\n282#1:308,3\n282#1:301,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final boolean continueRiverOn(@NotNull Tile tile) {
            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000#\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\b\u00a8\u0006\u0016"}, d2={"com/unciv/logic/map/mapgenerator/RiverGenerator$Companion$continueRiverOn$NeighborData", "", "otherTile", "Lcom/unciv/logic/map/tile/Tile;", "(Lcom/unciv/logic/map/TileMap;Lcom/unciv/logic/map/tile/Tile;Lcom/unciv/logic/map/tile/Tile;)V", "clockPosition", "", "getClockPosition", "()I", "connectedRiverCount", "getConnectedRiverCount", "edgeLeadsToSea", "", "getEdgeLeadsToSea", "()Z", "isConnectedByRiver", "getOtherTile", "()Lcom/unciv/logic/map/tile/Tile;", "verticesFormYCount", "getVerticesFormYCount", "getPriority", "edgeToSeaPriority", "core"})
            @SourceDebugExtension(value={"SMAP\nRiverGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiverGenerator.kt\ncom/unciv/logic/map/mapgenerator/RiverGenerator$Companion$continueRiverOn$NeighborData\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,290:1\n1268#2,3:291\n1268#2,3:294\n*S KotlinDebug\n*F\n+ 1 RiverGenerator.kt\ncom/unciv/logic/map/mapgenerator/RiverGenerator$Companion$continueRiverOn$NeighborData\n*L\n249#1:291,3\n253#1:294,3\n*E\n"})
            public final class NeighborData {
                @NotNull
                private final Tile otherTile;
                private final int clockPosition;
                private final boolean isConnectedByRiver;
                private final boolean edgeLeadsToSea;
                private final int connectedRiverCount;
                private final int verticesFormYCount;

                /*
                 * Unable to fully structure code
                 */
                public NeighborData(@NotNull TileMap $tileMap, @NotNull Tile $tile, @NotNull Tile otherTile) {
                    Intrinsics.checkNotNullParameter($tileMap, "$tileMap");
                    Intrinsics.checkNotNullParameter($tile, "$tile");
                    Intrinsics.checkNotNullParameter(otherTile, "otherTile");
                    super();
                    this.otherTile = otherTile;
                    this.clockPosition = $tileMap.getNeighborTileClockPosition($tile, this.otherTile);
                    this.isConnectedByRiver = $tile.isConnectedByRiver(this.otherTile);
                    leftSharedNeighbor = $tileMap.getClockPositionNeighborTile($tile, (this.clockPosition - 2) % 12);
                    rightSharedNeighbor = $tileMap.getClockPositionNeighborTile($tile, (this.clockPosition + 2) % 12);
                    v0 = leftSharedNeighbor;
                    if (v0 != null ? v0.isWater() : false) ** GOTO lbl-1000
                    v1 = rightSharedNeighbor;
                    v2 = v1 != null ? v1.isWater() : false;
                    if (v2) lbl-1000:
                    // 2 sources

                    {
                        v3 = true;
                    } else {
                        v3 = false;
                    }
                    this.edgeLeadsToSea = v3;
                    var6_6 = SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Boolean>, Continuation<? super Unit>, Object>(leftSharedNeighbor, $tile, this, rightSharedNeighbor, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ Tile $leftSharedNeighbor;
                        final /* synthetic */ Tile $tile;
                        final /* synthetic */ NeighborData this$0;
                        final /* synthetic */ Tile $rightSharedNeighbor;
                        {
                            this.$leftSharedNeighbor = $leftSharedNeighbor;
                            this.$tile = $tile;
                            this.this$0 = $receiver;
                            this.$rightSharedNeighbor = $rightSharedNeighbor;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(var1_1);
                                    $this$sequence = (SequenceScope)this.L$0;
                                    v0 = this.$leftSharedNeighbor;
                                    this.L$0 = $this$sequence;
                                    this.label = 1;
                                    v1 = $this$sequence.yield(v0 != null ? Boxing.boxBoolean(v0.isConnectedByRiver(this.$tile)) : null, this);
                                    if (v1 == var3_2) {
                                        return var3_2;
                                    }
                                    ** GOTO lbl17
                                }
                                case 1: {
                                    $this$sequence = (SequenceScope)this.L$0;
                                    ResultKt.throwOnFailure($result);
                                    v1 = $result;
lbl17:
                                    // 2 sources

                                    v2 = this.$leftSharedNeighbor;
                                    this.L$0 = $this$sequence;
                                    this.label = 2;
                                    v3 = $this$sequence.yield(v2 != null ? Boxing.boxBoolean(v2.isConnectedByRiver(this.this$0.getOtherTile())) : null, this);
                                    if (v3 == var3_2) {
                                        return var3_2;
                                    }
                                    ** GOTO lbl28
                                }
                                case 2: {
                                    $this$sequence = (SequenceScope)this.L$0;
                                    ResultKt.throwOnFailure($result);
                                    v3 = $result;
lbl28:
                                    // 2 sources

                                    v4 = this.$rightSharedNeighbor;
                                    this.L$0 = $this$sequence;
                                    this.label = 3;
                                    v5 = $this$sequence.yield(v4 != null ? Boxing.boxBoolean(v4.isConnectedByRiver(this.$tile)) : null, this);
                                    if (v5 == var3_2) {
                                        return var3_2;
                                    }
                                    ** GOTO lbl39
                                }
                                case 3: {
                                    $this$sequence = (SequenceScope)this.L$0;
                                    ResultKt.throwOnFailure($result);
                                    v5 = $result;
lbl39:
                                    // 2 sources

                                    v6 = this.$rightSharedNeighbor;
                                    this.L$0 = null;
                                    this.label = 4;
                                    v7 = $this$sequence.yield(v6 != null ? Boxing.boxBoolean(v6.isConnectedByRiver(this.this$0.getOtherTile())) : null, this);
                                    if (v7 == var3_2) {
                                        return var3_2;
                                    }
                                    ** GOTO lbl49
                                }
                                case 4: {
                                    ResultKt.throwOnFailure($result);
                                    v7 = $result;
lbl49:
                                    // 2 sources

                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            Function2<SequenceScope<? super Boolean>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                            function2.L$0 = value;
                            return (Continuation)((Object)function2);
                        }

                        @Nullable
                        public final Object invoke(@NotNull SequenceScope<? super Boolean> p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    });
                    var13_7 = this;
                    $i$f$count = false;
                    count$iv = 0;
                    var9_10 = $this$count$iv.iterator();
                    while (var9_10.hasNext()) {
                        element$iv = var9_10.next();
                        it = (Boolean)element$iv;
                        $i$a$-count-RiverGenerator$Companion$continueRiverOn$NeighborData$2 = false;
                        if (!Intrinsics.areEqual(it, true) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    var13_7.connectedRiverCount = var14_14 = count$iv;
                    $this$count$iv = SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Boolean>, Continuation<? super Unit>, Object>(leftSharedNeighbor, rightSharedNeighbor, $tile, this, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ Tile $leftSharedNeighbor;
                        final /* synthetic */ Tile $rightSharedNeighbor;
                        final /* synthetic */ Tile $tile;
                        final /* synthetic */ NeighborData this$0;
                        {
                            this.$leftSharedNeighbor = $leftSharedNeighbor;
                            this.$rightSharedNeighbor = $rightSharedNeighbor;
                            this.$tile = $tile;
                            this.this$0 = $receiver;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(var1_1);
                                    v0 = $this$sequence = (SequenceScope)this.L$0;
                                    v1 = this.$leftSharedNeighbor;
                                    if (v1 != null) {
                                        var3_4 = v1;
                                        var4_5 = this.$tile;
                                        var5_6 = this.this$0;
                                        $this$invokeSuspend_u24lambda_u240 = var3_4;
                                        var8_8 = v0;
                                        $i$a$-run-RiverGenerator$Companion$continueRiverOn$NeighborData$3$1 = false;
                                        v2 = Boxing.boxBoolean($this$invokeSuspend_u24lambda_u240.isConnectedByRiver(var4_5) != false && $this$invokeSuspend_u24lambda_u240.isConnectedByRiver(var5_6.getOtherTile()) != false);
                                        v0 = var8_8;
                                    } else {
                                        v2 = null;
                                    }
                                    this.L$0 = $this$sequence;
                                    this.label = 1;
                                    v3 = v0.yield(v2, this);
                                    if (v3 == var9_2) {
                                        return var9_2;
                                    }
                                    ** GOTO lbl29
                                }
                                case 1: {
                                    $this$sequence = (SequenceScope)this.L$0;
                                    ResultKt.throwOnFailure($result);
                                    v3 = $result;
lbl29:
                                    // 2 sources

                                    v4 = $this$sequence;
                                    v5 = this.$rightSharedNeighbor;
                                    if (v5 != null) {
                                        var3_4 = v5;
                                        var4_5 = this.$tile;
                                        var5_6 = this.this$0;
                                        $this$invokeSuspend_u24lambda_u241 = var3_4;
                                        var8_8 = v4;
                                        $i$a$-run-RiverGenerator$Companion$continueRiverOn$NeighborData$3$2 = false;
                                        v6 = Boxing.boxBoolean($this$invokeSuspend_u24lambda_u241.isConnectedByRiver(var4_5) != false && $this$invokeSuspend_u24lambda_u241.isConnectedByRiver(var5_6.getOtherTile()) != false);
                                        v4 = var8_8;
                                    } else {
                                        v6 = null;
                                    }
                                    this.L$0 = null;
                                    this.label = 2;
                                    v7 = v4.yield(v6, this);
                                    if (v7 == var9_2) {
                                        return var9_2;
                                    }
                                    ** GOTO lbl51
                                }
                                case 2: {
                                    ResultKt.throwOnFailure($result);
                                    v7 = $result;
lbl51:
                                    // 2 sources

                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            Function2<SequenceScope<? super Boolean>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                            function2.L$0 = value;
                            return (Continuation)((Object)function2);
                        }

                        @Nullable
                        public final Object invoke(@NotNull SequenceScope<? super Boolean> p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    });
                    var13_7 = this;
                    $i$f$count = false;
                    count$iv = 0;
                    var9_10 = $this$count$iv.iterator();
                    while (var9_10.hasNext()) {
                        element$iv = var9_10.next();
                        it = (Boolean)element$iv;
                        $i$a$-count-RiverGenerator$Companion$continueRiverOn$NeighborData$4 = false;
                        if (!Intrinsics.areEqual(it, true) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    var13_7.verticesFormYCount = var14_14 = count$iv;
                }

                @NotNull
                public final Tile getOtherTile() {
                    return this.otherTile;
                }

                public final int getClockPosition() {
                    return this.clockPosition;
                }

                public final boolean isConnectedByRiver() {
                    return this.isConnectedByRiver;
                }

                public final boolean getEdgeLeadsToSea() {
                    return this.edgeLeadsToSea;
                }

                public final int getConnectedRiverCount() {
                    return this.connectedRiverCount;
                }

                public final int getVerticesFormYCount() {
                    return this.verticesFormYCount;
                }

                public final int getPriority(int edgeToSeaPriority) {
                    return this.isConnectedByRiver ? -9 : (this.edgeLeadsToSea ? edgeToSeaPriority + this.connectedRiverCount - 3 * this.verticesFormYCount : (this.verticesFormYCount == 2 ? -2 : (this.verticesFormYCount == 1 ? this.connectedRiverCount * 2 - 5 : this.connectedRiverCount * 2)));
                }
            }
            Object t;
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            Object element$iv3;
            boolean bl;
            List viableNeighbors2;
            block16: {
                boolean bl2;
                block15: {
                    Intrinsics.checkNotNullParameter(tile, "tile");
                    if (!tile.isLand()) {
                        return false;
                    }
                    TileMap tileMap = tile.getTileMap();
                    viableNeighbors2 = SequencesKt.toList(SequencesKt.map(SequencesKt.filter(tile.getNeighbors(), continueRiverOn.viableNeighbors.1.INSTANCE), (Function1)new Function1<Tile, NeighborData>(tileMap, tile){
                        final /* synthetic */ TileMap $tileMap;
                        final /* synthetic */ Tile $tile;
                        {
                            this.$tileMap = $tileMap;
                            this.$tile = $tile;
                            super(1);
                        }

                        @NotNull
                        public final NeighborData invoke(@NotNull Tile it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            return new NeighborData(this.$tileMap, this.$tile, it);
                        }
                    }));
                    Iterable $this$all$iv = viableNeighbors2;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            NeighborData it = (NeighborData)element$iv2;
                            boolean bl3 = false;
                            if (it.isConnectedByRiver()) continue;
                            bl2 = false;
                            break block15;
                        }
                        bl2 = true;
                    }
                }
                if (bl2) {
                    return false;
                }
                Iterable $this$none$iv = viableNeighbors2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv3 : $this$none$iv) {
                        NeighborData it = (NeighborData)element$iv3;
                        boolean bl4 = false;
                        if (!(it.isConnectedByRiver() && it.getEdgeLeadsToSea())) continue;
                        bl = false;
                        break block16;
                    }
                    bl = true;
                }
            }
            int edgeToSeaPriority = bl ? 9 : -1;
            Iterable $i$f$none = viableNeighbors2;
            boolean $i$f$groupBy = false;
            element$iv3 = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                NeighborData it = (NeighborData)element$iv$iv;
                boolean bl5 = false;
                Integer key$iv$iv = it.getPriority(edgeToSeaPriority);
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl6 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Iterable iterable = destination$iv$iv.entrySet();
            Iterator iterator2 = iterable.iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            Object t2 = iterator2.next();
            if (!iterator2.hasNext()) {
                t = t2;
            } else {
                Map.Entry it = (Map.Entry)t2;
                boolean bl7 = false;
                int n = ((Number)it.getKey()).intValue();
                do {
                    Object t3 = iterator2.next();
                    Map.Entry it2 = (Map.Entry)t3;
                    $i$a$-maxByOrThrow-RiverGenerator$Companion$continueRiverOn$choice$2 = false;
                    int n2 = ((Number)it2.getKey()).intValue();
                    if (n >= n2) continue;
                    t2 = t3;
                    n = n2;
                } while (iterator2.hasNext());
                t = t2;
            }
            NeighborData choice = (NeighborData)CollectionsKt.random((Collection)((Map.Entry)t).getValue(), Random.Default);
            return tile.setConnectedByRiver(choice.getOtherTile(), true, true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u001fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00000\u0014J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0014J\u0006\u0010\u0016\u001a\u00020\u0011J\u0018\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u001aH\u0002J\u0018\u0010\u001c\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u001aH\u0002J\u001e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00002\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u001aR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/unciv/logic/map/mapgenerator/RiverGenerator$RiverCoordinate;", "", "tileMap", "Lcom/unciv/logic/map/TileMap;", "position", "Lcom/badlogic/gdx/math/Vector2;", "bottomRightOrLeft", "Lcom/unciv/logic/map/mapgenerator/RiverGenerator$RiverCoordinate$BottomRightOrLeft;", "(Lcom/unciv/logic/map/TileMap;Lcom/badlogic/gdx/math/Vector2;Lcom/unciv/logic/map/mapgenerator/RiverGenerator$RiverCoordinate$BottomRightOrLeft;)V", "myBottomCenter", "Lcom/unciv/logic/map/tile/Tile;", "myBottomLeft", "myBottomRight", "myTile", "myTopLeft", "myTopRight", "x", "", "y", "getAdjacentPositions", "Lkotlin/sequences/Sequence;", "getAdjacentTiles", "numberOfConnectedRivers", "paintBottom", "", "resultingTiles", "", "paintBottomLeft", "paintBottomRight", "paintTo", "newCoordinate", "BottomRightOrLeft", "core"})
    @SourceDebugExtension(value={"SMAP\nRiverGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiverGenerator.kt\ncom/unciv/logic/map/mapgenerator/RiverGenerator$RiverCoordinate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,290:1\n1#2:291\n1268#3,3:292\n*S KotlinDebug\n*F\n+ 1 RiverGenerator.kt\ncom/unciv/logic/map/mapgenerator/RiverGenerator$RiverCoordinate\n*L\n197#1:292,3\n*E\n"})
    public static final class RiverCoordinate {
        @NotNull
        private final TileMap tileMap;
        @NotNull
        private final Vector2 position;
        @NotNull
        private final BottomRightOrLeft bottomRightOrLeft;
        private final int x;
        private final int y;
        @NotNull
        private final Tile myTile;
        @Nullable
        private final Tile myTopLeft;
        @Nullable
        private final Tile myBottomLeft;
        @Nullable
        private final Tile myTopRight;
        @Nullable
        private final Tile myBottomRight;
        @Nullable
        private final Tile myBottomCenter;

        public RiverCoordinate(@NotNull TileMap tileMap, @NotNull Vector2 position, @NotNull BottomRightOrLeft bottomRightOrLeft) {
            Intrinsics.checkNotNullParameter(tileMap, "tileMap");
            Intrinsics.checkNotNullParameter(position, "position");
            Intrinsics.checkNotNullParameter((Object)bottomRightOrLeft, "bottomRightOrLeft");
            this.tileMap = tileMap;
            this.position = position;
            this.bottomRightOrLeft = bottomRightOrLeft;
            this.x = (int)this.position.x;
            this.y = (int)this.position.y;
            this.myTile = this.tileMap.get(this.position);
            this.myTopLeft = this.tileMap.getIfTileExistsOrNull(this.x + 1, this.y);
            this.myBottomLeft = this.tileMap.getIfTileExistsOrNull(this.x, this.y - 1);
            this.myTopRight = this.tileMap.getIfTileExistsOrNull(this.x, this.y + 1);
            this.myBottomRight = this.tileMap.getIfTileExistsOrNull(this.x - 1, this.y);
            this.myBottomCenter = this.tileMap.getIfTileExistsOrNull(this.x - 1, this.y - 1);
        }

        @NotNull
        public final Sequence<RiverCoordinate> getAdjacentPositions() {
            return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super RiverCoordinate>, Continuation<? super Unit>, Object>(this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ RiverCoordinate this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(var1_1);
                            $this$sequence = (SequenceScope)this.L$0;
                            if (RiverCoordinate.access$getBottomRightOrLeft$p(this.this$0) != BottomRightOrLeft.BottomLeft) break;
                            this.L$0 = $this$sequence;
                            this.label = 1;
                            v0 = $this$sequence.yield(new RiverCoordinate(RiverCoordinate.access$getTileMap$p(this.this$0), RiverCoordinate.access$getPosition$p(this.this$0), BottomRightOrLeft.BottomRight), this);
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl17
                        }
                        case 1: {
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            if (RiverCoordinate.access$getMyTopLeft$p(this.this$0) != null) {
                                this.L$0 = $this$sequence;
                                this.label = 2;
                                v1 = $this$sequence.yield(new RiverCoordinate(RiverCoordinate.access$getTileMap$p(this.this$0), RiverCoordinate.access$getMyTopLeft$p(this.this$0).getPosition(), BottomRightOrLeft.BottomRight), this);
                                if (v1 == var3_2) {
                                    return var3_2;
                                }
                            }
                            ** GOTO lbl28
                        }
                        case 2: {
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v1 = $result;
lbl28:
                            // 2 sources

                            if (RiverCoordinate.access$getMyBottomLeft$p(this.this$0) != null) {
                                this.L$0 = null;
                                this.label = 3;
                                v2 = $this$sequence.yield(new RiverCoordinate(RiverCoordinate.access$getTileMap$p(this.this$0), RiverCoordinate.access$getMyBottomLeft$p(this.this$0).getPosition(), BottomRightOrLeft.BottomRight), this);
                                if (v2 == var3_2) {
                                    return var3_2;
                                }
                            }
                            ** GOTO lbl70
                        }
                        case 3: {
                            ResultKt.throwOnFailure($result);
                            v2 = $result;
                            ** GOTO lbl70
                        }
                    }
                    this.L$0 = $this$sequence;
                    this.label = 4;
                    v3 = $this$sequence.yield(new RiverCoordinate(RiverCoordinate.access$getTileMap$p(this.this$0), RiverCoordinate.access$getPosition$p(this.this$0), BottomRightOrLeft.BottomLeft), this);
                    if (v3 == var3_2) {
                        return var3_2;
                    }
                    ** GOTO lbl49
                    {
                        case 4: {
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v3 = $result;
lbl49:
                            // 2 sources

                            if (RiverCoordinate.access$getMyTopRight$p(this.this$0) != null) {
                                this.L$0 = $this$sequence;
                                this.label = 5;
                                v4 = $this$sequence.yield(new RiverCoordinate(RiverCoordinate.access$getTileMap$p(this.this$0), RiverCoordinate.access$getMyTopRight$p(this.this$0).getPosition(), BottomRightOrLeft.BottomLeft), this);
                                if (v4 == var3_2) {
                                    return var3_2;
                                }
                            }
                            ** GOTO lbl60
                        }
                        case 5: {
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v4 = $result;
lbl60:
                            // 2 sources

                            if (RiverCoordinate.access$getMyBottomRight$p(this.this$0) != null) {
                                this.L$0 = null;
                                this.label = 6;
                                v5 = $this$sequence.yield(new RiverCoordinate(RiverCoordinate.access$getTileMap$p(this.this$0), RiverCoordinate.access$getMyBottomRight$p(this.this$0).getPosition(), BottomRightOrLeft.BottomLeft), this);
                                if (v5 == var3_2) {
                                    return var3_2;
                                }
                            }
                            ** GOTO lbl70
                        }
                        case 6: {
                            ResultKt.throwOnFailure($result);
                            v5 = $result;
lbl70:
                            // 4 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<SequenceScope<? super RiverCoordinate>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)((Object)function2);
                }

                @Nullable
                public final Object invoke(@NotNull SequenceScope<? super RiverCoordinate> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
        }

        @NotNull
        public final Sequence<Tile> getAdjacentTiles() {
            return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Tile>, Continuation<? super Unit>, Object>(this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ RiverCoordinate this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    block15: {
                        block14: {
                            var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure(var1_1);
                                    $this$sequence = (SequenceScope)this.L$0;
                                    this.L$0 = $this$sequence;
                                    this.label = 1;
                                    v0 = $this$sequence.yield(RiverCoordinate.access$getMyTile$p(this.this$0), this);
                                    if (v0 == var5_2) {
                                        return var5_2;
                                    }
                                    ** GOTO lbl16
                                }
                                case 1: {
                                    $this$sequence = (SequenceScope)this.L$0;
                                    ResultKt.throwOnFailure($result);
                                    v0 = $result;
lbl16:
                                    // 2 sources

                                    v1 = RiverCoordinate.access$getMyBottomCenter$p(this.this$0);
                                    if (v1 == null) break;
                                    it = v1;
                                    $i$a$-let-RiverGenerator$RiverCoordinate$getAdjacentTiles$1$1 = false;
                                    this.L$0 = $this$sequence;
                                    this.label = 2;
                                    v2 = $this$sequence.yield(it, this);
                                    if (v2 == var5_2) {
                                        return var5_2;
                                    }
                                    break;
                                }
                                case 2: {
                                    $i$a$-let-RiverGenerator$RiverCoordinate$getAdjacentTiles$1$1 = false;
                                    $this$sequence = (SequenceScope)this.L$0;
                                    ResultKt.throwOnFailure($result);
                                    v2 = $result;
                                    break;
                                }
                            }
                            if (RiverCoordinate.access$getBottomRightOrLeft$p(this.this$0) != BottomRightOrLeft.BottomLeft) break block14;
                            v3 = RiverCoordinate.access$getMyBottomLeft$p(this.this$0);
                            if (v3 != null) {
                                it = v3;
                                $i$a$-let-RiverGenerator$RiverCoordinate$getAdjacentTiles$1$2 = false;
                                this.L$0 = null;
                                this.label = 3;
                                v4 = $this$sequence.yield(it, this);
                                if (v4 == var5_2) {
                                    return var5_2;
                                }
                            }
                            break block15;
                            {
                                case 3: {
                                    $i$a$-let-RiverGenerator$RiverCoordinate$getAdjacentTiles$1$2 = false;
                                    ResultKt.throwOnFailure($result);
                                    v4 = $result;
                                    break;
                                }
                            }
                        }
                        v5 = RiverCoordinate.access$getMyBottomRight$p(this.this$0);
                        if (v5 != null) {
                            it = v5;
                            $i$a$-let-RiverGenerator$RiverCoordinate$getAdjacentTiles$1$3 = false;
                            this.L$0 = null;
                            this.label = 4;
                            v6 = $this$sequence.yield(it, this);
                            if (v6 == var5_2) {
                                return var5_2;
                            }
                        }
                        break block15;
                        {
                            case 4: {
                                $i$a$-let-RiverGenerator$RiverCoordinate$getAdjacentTiles$1$3 = false;
                                ResultKt.throwOnFailure($result);
                                v6 = $result;
                            }
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<SequenceScope<? super Tile>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)((Object)function2);
                }

                @Nullable
                public final Object invoke(@NotNull SequenceScope<? super Tile> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
        }

        public final void paintTo(@NotNull RiverCoordinate newCoordinate2, @Nullable Set<Tile> resultingTiles) {
            Intrinsics.checkNotNullParameter(newCoordinate2, "newCoordinate");
            if (Intrinsics.areEqual(newCoordinate2.position, this.position)) {
                this.paintBottom(resultingTiles);
            } else if (this.bottomRightOrLeft == BottomRightOrLeft.BottomRight) {
                if (SequencesKt.contains(newCoordinate2.getAdjacentTiles(), this.myTile)) {
                    this.paintBottomRight(resultingTiles);
                } else {
                    newCoordinate2.paintBottomLeft(resultingTiles);
                }
            } else if (SequencesKt.contains(newCoordinate2.getAdjacentTiles(), this.myTile)) {
                this.paintBottomLeft(resultingTiles);
            } else {
                newCoordinate2.paintBottomRight(resultingTiles);
            }
        }

        private final void paintBottom(Set<Tile> resultingTiles) {
            block1: {
                this.myTile.setHasBottomRiver(true);
                if (resultingTiles == null) {
                    return;
                }
                resultingTiles.add(this.myTile);
                Tile tile = this.myBottomCenter;
                if (tile == null) break block1;
                Tile it = tile;
                boolean bl = false;
                resultingTiles.add(it);
            }
        }

        private final void paintBottomLeft(Set<Tile> resultingTiles) {
            block1: {
                this.myTile.setHasBottomLeftRiver(true);
                if (resultingTiles == null) {
                    return;
                }
                resultingTiles.add(this.myTile);
                Tile tile = this.myBottomLeft;
                if (tile == null) break block1;
                Tile it = tile;
                boolean bl = false;
                resultingTiles.add(it);
            }
        }

        private final void paintBottomRight(Set<Tile> resultingTiles) {
            block1: {
                this.myTile.setHasBottomRightRiver(true);
                if (resultingTiles == null) {
                    return;
                }
                resultingTiles.add(this.myTile);
                Tile tile = this.myBottomRight;
                if (tile == null) break block1;
                Tile it = tile;
                boolean bl = false;
                resultingTiles.add(it);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final int numberOfConnectedRivers() {
            void var3_3;
            Sequence $this$count$iv = SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Boolean>, Continuation<? super Unit>, Object>(this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ RiverCoordinate this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(var1_1);
                            $this$sequence = (SequenceScope)this.L$0;
                            this.L$0 = $this$sequence;
                            this.label = 1;
                            v0 = $this$sequence.yield(Boxing.boxBoolean(RiverCoordinate.access$getMyTile$p(this.this$0).getHasBottomRiver()), this);
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl16
                        }
                        case 1: {
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl16:
                            // 2 sources

                            if (RiverCoordinate.access$getBottomRightOrLeft$p(this.this$0) != BottomRightOrLeft.BottomLeft) break;
                            this.L$0 = $this$sequence;
                            this.label = 2;
                            v1 = $this$sequence.yield(Boxing.boxBoolean(RiverCoordinate.access$getMyTile$p(this.this$0).getHasBottomLeftRiver()), this);
                            if (v1 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl27
                        }
                        case 2: {
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v1 = $result;
lbl27:
                            // 2 sources

                            v2 = RiverCoordinate.access$getMyBottomLeft$p(this.this$0);
                            this.L$0 = null;
                            this.label = 3;
                            v3 = $this$sequence.yield(Boxing.boxBoolean(v2 != null ? v2.getHasBottomRightRiver() : false), this);
                            if (v3 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl58
                        }
                        case 3: {
                            ResultKt.throwOnFailure($result);
                            v3 = $result;
                            ** GOTO lbl58
                        }
                    }
                    this.L$0 = $this$sequence;
                    this.label = 4;
                    v4 = $this$sequence.yield(Boxing.boxBoolean(RiverCoordinate.access$getMyTile$p(this.this$0).getHasBottomRightRiver()), this);
                    if (v4 == var3_2) {
                        return var3_2;
                    }
                    ** GOTO lbl48
                    {
                        case 4: {
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v4 = $result;
lbl48:
                            // 2 sources

                            v5 = RiverCoordinate.access$getMyBottomRight$p(this.this$0);
                            this.L$0 = null;
                            this.label = 5;
                            v6 = $this$sequence.yield(Boxing.boxBoolean(v5 != null ? v5.getHasBottomLeftRiver() : false), this);
                            if (v6 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl58
                        }
                        case 5: {
                            ResultKt.throwOnFailure($result);
                            v6 = $result;
lbl58:
                            // 4 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<SequenceScope<? super Boolean>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)((Object)function2);
                }

                @Nullable
                public final Object invoke(@NotNull SequenceScope<? super Boolean> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            });
            boolean $i$f$count = false;
            int count$iv = 0;
            Iterator iterator2 = $this$count$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                boolean it = (Boolean)element$iv;
                boolean bl = false;
                if (!it || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            return (int)var3_3;
        }

        public static final /* synthetic */ BottomRightOrLeft access$getBottomRightOrLeft$p(RiverCoordinate $this) {
            return $this.bottomRightOrLeft;
        }

        public static final /* synthetic */ TileMap access$getTileMap$p(RiverCoordinate $this) {
            return $this.tileMap;
        }

        public static final /* synthetic */ Vector2 access$getPosition$p(RiverCoordinate $this) {
            return $this.position;
        }

        public static final /* synthetic */ Tile access$getMyTopLeft$p(RiverCoordinate $this) {
            return $this.myTopLeft;
        }

        public static final /* synthetic */ Tile access$getMyBottomLeft$p(RiverCoordinate $this) {
            return $this.myBottomLeft;
        }

        public static final /* synthetic */ Tile access$getMyTopRight$p(RiverCoordinate $this) {
            return $this.myTopRight;
        }

        public static final /* synthetic */ Tile access$getMyBottomRight$p(RiverCoordinate $this) {
            return $this.myBottomRight;
        }

        public static final /* synthetic */ Tile access$getMyTile$p(RiverCoordinate $this) {
            return $this.myTile;
        }

        public static final /* synthetic */ Tile access$getMyBottomCenter$p(RiverCoordinate $this) {
            return $this.myBottomCenter;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/unciv/logic/map/mapgenerator/RiverGenerator$RiverCoordinate$BottomRightOrLeft;", "", "(Ljava/lang/String;I)V", "BottomLeft", "BottomRight", "core"})
        public static final class BottomRightOrLeft
        extends Enum<BottomRightOrLeft> {
            public static final /* enum */ BottomRightOrLeft BottomLeft = new BottomRightOrLeft();
            public static final /* enum */ BottomRightOrLeft BottomRight = new BottomRightOrLeft();
            private static final /* synthetic */ BottomRightOrLeft[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static BottomRightOrLeft[] values() {
                return (BottomRightOrLeft[])$VALUES.clone();
            }

            public static BottomRightOrLeft valueOf(String value) {
                return Enum.valueOf(BottomRightOrLeft.class, value);
            }

            @NotNull
            public static EnumEntries<BottomRightOrLeft> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = bottomRightOrLeftArray = new BottomRightOrLeft[]{BottomRightOrLeft.BottomLeft, BottomRightOrLeft.BottomRight};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000f"}, d2={"Lcom/unciv/logic/map/mapgenerator/RiverGenerator$RiverDirections;", "", "clockPosition", "", "(Ljava/lang/String;II)V", "getNeighborTile", "Lcom/unciv/logic/map/tile/Tile;", "selectedTile", "North", "NorthEast", "SouthEast", "South", "SouthWest", "NorthWest", "Companion", "core"})
    public static final class RiverDirections
    extends Enum<RiverDirections> {
        @NotNull
        public static final Companion Companion;
        private final int clockPosition;
        public static final /* enum */ RiverDirections North;
        public static final /* enum */ RiverDirections NorthEast;
        public static final /* enum */ RiverDirections SouthEast;
        public static final /* enum */ RiverDirections South;
        public static final /* enum */ RiverDirections SouthWest;
        public static final /* enum */ RiverDirections NorthWest;
        private static final /* synthetic */ RiverDirections[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private RiverDirections(int clockPosition) {
            this.clockPosition = clockPosition;
        }

        @Nullable
        public final Tile getNeighborTile(@NotNull Tile selectedTile) {
            Intrinsics.checkNotNullParameter(selectedTile, "selectedTile");
            return selectedTile.getTileMap().getClockPositionNeighborTile(selectedTile, this.clockPosition);
        }

        public static RiverDirections[] values() {
            return (RiverDirections[])$VALUES.clone();
        }

        public static RiverDirections valueOf(String value) {
            return Enum.valueOf(RiverDirections.class, value);
        }

        @NotNull
        public static EnumEntries<RiverDirections> getEntries() {
            return $ENTRIES;
        }

        static {
            North = new RiverDirections(12);
            NorthEast = new RiverDirections(2);
            SouthEast = new RiverDirections(4);
            South = new RiverDirections(6);
            SouthWest = new RiverDirections(8);
            NorthWest = new RiverDirections(10);
            $VALUES = riverDirectionsArray = new RiverDirections[]{RiverDirections.North, RiverDirections.NorthEast, RiverDirections.SouthEast, RiverDirections.South, RiverDirections.SouthWest, RiverDirections.NorthWest};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/logic/map/mapgenerator/RiverGenerator$RiverDirections$Companion;", "", "()V", "names", "", "", "getNames", "()Ljava/util/List;", "core"})
        @SourceDebugExtension(value={"SMAP\nRiverGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiverGenerator.kt\ncom/unciv/logic/map/mapgenerator/RiverGenerator$RiverDirections$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,290:1\n11065#2:291\n11400#2,3:292\n*S KotlinDebug\n*F\n+ 1 RiverGenerator.kt\ncom/unciv/logic/map/mapgenerator/RiverGenerator$RiverDirections$Companion\n*L\n210#1:291\n210#1:292,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<String> getNames() {
                void $this$mapTo$iv$iv;
                RiverDirections[] $this$map$iv = RiverDirections.values();
                boolean $i$f$map = false;
                RiverDirections[] riverDirectionsArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.name());
                }
                return (List)destination$iv$iv;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

