/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapunit;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.UnitManager;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.UnitUpgradeManager;
import com.unciv.models.ModConstants;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nJ'\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\b2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/unciv/logic/map/mapunit/UnitUpgradeManager;", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "(Lcom/unciv/logic/map/mapunit/MapUnit;)V", "getUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "canUpgrade", "", "unitToUpgradeTo", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "ignoreRequirements", "ignoreResources", "getCostOfUpgrade", "", "performUpgrade", "", "upgradedUnit", "isFree", "goldCostOfUpgrade", "(Lcom/unciv/models/ruleset/unit/BaseUnit;ZLjava/lang/Integer;)V", "core"})
public final class UnitUpgradeManager {
    @NotNull
    private final MapUnit unit;

    public UnitUpgradeManager(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        this.unit = unit;
    }

    @NotNull
    public final MapUnit getUnit() {
        return this.unit;
    }

    public final boolean canUpgrade(@NotNull BaseUnit unitToUpgradeTo2, boolean ignoreRequirements, boolean ignoreResources) {
        Intrinsics.checkNotNullParameter(unitToUpgradeTo2, "unitToUpgradeTo");
        if (Intrinsics.areEqual(this.unit.getName(), unitToUpgradeTo2.getName())) {
            return false;
        }
        Sequence rejectionReasons = BaseUnit.getRejectionReasons$default(unitToUpgradeTo2, this.unit.getCiv(), null, this.unit.getResourceRequirementsPerTurn(), 2, null);
        Sequence relevantRejectionReasons2 = SequencesKt.filterNot(rejectionReasons, canUpgrade.relevantRejectionReasons.1.INSTANCE);
        if (ignoreRequirements) {
            relevantRejectionReasons2 = SequencesKt.filterNot(relevantRejectionReasons2, canUpgrade.1.INSTANCE);
        }
        if (ignoreResources) {
            relevantRejectionReasons2 = SequencesKt.filterNot(relevantRejectionReasons2, canUpgrade.2.INSTANCE);
        }
        return SequencesKt.none(relevantRejectionReasons2);
    }

    public static /* synthetic */ boolean canUpgrade$default(UnitUpgradeManager unitUpgradeManager, BaseUnit baseUnit, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return unitUpgradeManager.canUpgrade(baseUnit, bl, bl2);
    }

    public final int getCostOfUpgrade(@NotNull BaseUnit unitToUpgradeTo2) {
        Intrinsics.checkNotNullParameter(unitToUpgradeTo2, "unitToUpgradeTo");
        int goldCostOfUpgrade = 0;
        Ruleset ruleset2 = this.unit.getCiv().getGameInfo().getRuleset();
        ModConstants.UnitUpgradeCost constants = ruleset2.getModOptions().getConstants().getUnitUpgradeCost();
        float civModifier = 1.0f;
        StateForConditionals stateForConditionals = new StateForConditionals(this.unit.getCiv(), null, this.unit, null, null, null, null, null, null, false, 1018, null);
        Iterator<Unique> iterator2 = this.unit.getCiv().getMatchingUniques(UniqueType.UnitUpgradeCost, stateForConditionals).iterator();
        while (iterator2.hasNext()) {
            Unique unique = iterator2.next();
            civModifier *= FormattingExtensionsKt.toPercent(unique.getParams().get(0));
        }
        float cost = constants.getBase();
        cost += RangesKt.coerceAtLeast(constants.getPerProduction() * (float)(unitToUpgradeTo2.getCost() - this.unit.getBaseUnit().getCost()), 0.0f);
        Era era2 = unitToUpgradeTo2.era(ruleset2);
        if (era2 != null) {
            cost *= 1.0f + (float)era2.getEraNumber() * constants.getEraMultiplier();
        }
        cost = (float)Math.pow(cost * civModifier, constants.getExponent());
        return goldCostOfUpgrade += (int)((cost *= this.unit.getCiv().getGameInfo().getSpeed().getModifier()) / (float)constants.getRoundTo()) * constants.getRoundTo();
    }

    public final void performUpgrade(@NotNull BaseUnit upgradedUnit, boolean isFree, @Nullable Integer goldCostOfUpgrade) {
        Intrinsics.checkNotNullParameter(upgradedUnit, "upgradedUnit");
        this.unit.destroy(false);
        Civilization civ = this.unit.getCiv();
        Vector2 position = this.unit.getCurrentTile().getPosition();
        MapUnit newUnit = civ.getUnits().placeUnitNearTile(position, upgradedUnit, this.unit.getId());
        if (newUnit == null) {
            MapUnit mapUnit = UnitManager.placeUnitNearTile$default(civ.getUnits(), position, this.unit.getBaseUnit(), null, 4, null);
            Intrinsics.checkNotNull(mapUnit);
            MapUnit resurrectedUnit = mapUnit;
            this.unit.copyStatisticsTo(resurrectedUnit);
            return;
        }
        if (!isFree) {
            Integer n = goldCostOfUpgrade;
            civ.addGold(-(n != null ? n.intValue() : this.getCostOfUpgrade(upgradedUnit)));
        }
        this.unit.copyStatisticsTo(newUnit);
        newUnit.setCurrentMovement(0.0f);
        if (newUnit.isFortified() && !newUnit.canFortify(true)) {
            newUnit.setAction(null);
        }
    }

    public static /* synthetic */ void performUpgrade$default(UnitUpgradeManager unitUpgradeManager, BaseUnit baseUnit, boolean bl, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        unitUpgradeManager.performUpgrade(baseUnit, bl, n);
    }
}

