/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapunit.movement;

import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.MapUnitCache;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\fH\u0002J(\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001c\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/unciv/logic/map/mapunit/movement/MovementCost;", "", "()V", "getEnemyMovementPenalty", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "enemyUnit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "getMovementCostBetweenAdjacentTiles", "unit", "from", "Lcom/unciv/logic/map/tile/Tile;", "to", "considerZoneOfControl", "", "getTilesExertingZoneOfControl", "Lkotlin/sequences/Sequence;", "tile", "hasDoubleMovement", "terrainName", "", "target", "Lcom/unciv/logic/map/mapunit/MapUnitCache$DoubleMovementTerrainTarget;", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "doubleMovement", "Lcom/unciv/logic/map/mapunit/MapUnitCache$DoubleMovement;", "isMovementAffectedByZoneOfControl", "core"})
@SourceDebugExtension(value={"SMAP\nMovementCost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MovementCost.kt\ncom/unciv/logic/map/mapunit/movement/MovementCost\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,180:1\n1747#2,3:181\n187#3,3:184\n2159#4,2:187\n*S KotlinDebug\n*F\n+ 1 MovementCost.kt\ncom/unciv/logic/map/mapunit/movement/MovementCost\n*L\n70#1:181,3\n91#1:184,3\n155#1:187,2\n*E\n"})
public final class MovementCost {
    @NotNull
    public static final MovementCost INSTANCE = new MovementCost();

    private MovementCost() {
    }

    public final float getMovementCostBetweenAdjacentTiles(@NotNull MapUnit unit, @NotNull Tile from, @NotNull Tile to, boolean considerZoneOfControl) {
        boolean bl;
        float terrainCost;
        float extraCost;
        block26: {
            Object it;
            boolean bl2;
            boolean $i$f$any;
            Object $this$any$iv;
            StateForConditionals stateForConditionals;
            Civilization civ;
            block25: {
                boolean areConnectedByRiver;
                Intrinsics.checkNotNullParameter(unit, "unit");
                Intrinsics.checkNotNullParameter(from, "from");
                Intrinsics.checkNotNullParameter(to, "to");
                civ = unit.getCiv();
                if (unit.getCache().getCannotMove()) {
                    return 100.0f;
                }
                if (from.isLand() != to.isLand() && unit.getBaseUnit().isLandUnit() && !unit.getCache().getCanMoveOnWater()) {
                    float f;
                    if (from.isWater() && to.isLand()) {
                        Float f2 = unit.getCache().getCostToDisembark();
                        f = f2 != null ? f2.floatValue() : 100.0f;
                    } else {
                        Float f3 = unit.getCache().getCostToEmbark();
                        f = f3 != null ? f3.floatValue() : 100.0f;
                    }
                    return f;
                }
                if (considerZoneOfControl && this.isMovementAffectedByZoneOfControl(unit, from, to)) {
                    return 100.0f;
                }
                if (unit.getCache().getAllTilesCosts1()) {
                    return 1.0f;
                }
                Civilization toOwner = to.getOwner();
                float f = extraCost = toOwner != null && toOwner.getHasActiveEnemyMovementPenalty() && civ.isAtWarWith(toOwner) ? this.getEnemyMovementPenalty(toOwner, unit) : 0.0f;
                if (from.getUnpillagedRoad() == RoadStatus.Railroad && to.getUnpillagedRoad() == RoadStatus.Railroad) {
                    return RoadStatus.Railroad.getMovement() + extraCost;
                }
                boolean areConnectedByRoad = from.hasConnection(civ) && to.hasConnection(civ);
                boolean bl3 = areConnectedByRiver = from.isAdjacentToRiver() && to.isAdjacentToRiver() && from.isConnectedByRiver(to);
                if (areConnectedByRoad && (!areConnectedByRiver || civ.getTech().getRoadsConnectAcrossRivers())) {
                    return unit.getCiv().getTech().getMovementSpeedOnRoads() + extraCost;
                }
                if (unit.getCache().getIgnoresTerrainCost()) {
                    return 1.0f + extraCost;
                }
                if (areConnectedByRiver) {
                    return 100.0f;
                }
                terrainCost = to.getLastTerrain().getMovementCost();
                if (unit.getCache().getNoTerrainMovementUniques()) {
                    return terrainCost + extraCost;
                }
                stateForConditionals = new StateForConditionals(unit.getCiv(), null, unit, to, null, null, null, null, null, false, 1010, null);
                $this$any$iv = to.getTerrainFeatures();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    Iterator<Object> iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object t = iterator2.next();
                        it = (String)t;
                        boolean bl4 = false;
                        if (!INSTANCE.hasDoubleMovement(unit, (String)it, MapUnitCache.DoubleMovementTerrainTarget.Feature, stateForConditionals)) continue;
                        bl2 = true;
                        break block25;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return terrainCost * 0.5f + extraCost;
            }
            if (unit.getCache().getRoughTerrainPenalty() && to.isRoughTerrain()) {
                return 100.0f;
            }
            if (civ.getNation().getIgnoreHillMovementCost() && to.isHill()) {
                return 1.0f + extraCost;
            }
            if (unit.getCache().getNoBaseTerrainOrHillDoubleMovementUniques()) {
                return terrainCost + extraCost;
            }
            if (this.hasDoubleMovement(unit, to.getBaseTerrain(), MapUnitCache.DoubleMovementTerrainTarget.Base, stateForConditionals)) {
                return terrainCost * 0.5f + extraCost;
            }
            if (this.hasDoubleMovement(unit, "Hill", MapUnitCache.DoubleMovementTerrainTarget.Hill, stateForConditionals) && to.isHill()) {
                return terrainCost * 0.5f + extraCost;
            }
            if (unit.getCache().getNoFilteredDoubleMovementUniques()) {
                return terrainCost + extraCost;
            }
            $this$any$iv = unit.getCache().getDoubleMovementInTerrain();
            $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                for (Map.Entry entry : $this$any$iv.entrySet()) {
                    it = entry;
                    boolean bl5 = false;
                    boolean bl4 = INSTANCE.hasDoubleMovement((MapUnitCache.DoubleMovement)it.getValue(), MapUnitCache.DoubleMovementTerrainTarget.Filter, stateForConditionals) && Tile.matchesFilter$default(to, (String)it.getKey(), null, false, 6, null);
                    if (!bl4) continue;
                    bl = true;
                    break block26;
                }
                bl = false;
            }
        }
        if (bl) {
            return terrainCost * 0.5f + extraCost;
        }
        return terrainCost + extraCost;
    }

    public static /* synthetic */ float getMovementCostBetweenAdjacentTiles$default(MovementCost movementCost, MapUnit mapUnit, Tile tile, Tile tile2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return movementCost.getMovementCostBetweenAdjacentTiles(mapUnit, tile, tile2, bl);
    }

    private final boolean hasDoubleMovement(MapUnitCache.DoubleMovement doubleMovement, MapUnitCache.DoubleMovementTerrainTarget target, StateForConditionals stateForConditionals) {
        if (doubleMovement.getTerrainTarget() != target) {
            return false;
        }
        return !(!((Collection)doubleMovement.getUnique().getConditionals()).isEmpty()) || doubleMovement.getUnique().conditionalsApply(stateForConditionals);
    }

    private final boolean hasDoubleMovement(MapUnit unit, String terrainName, MapUnitCache.DoubleMovementTerrainTarget target, StateForConditionals stateForConditionals) {
        MapUnitCache.DoubleMovement doubleMovement = unit.getCache().getDoubleMovementInTerrain().get(terrainName);
        if (doubleMovement == null) {
            return false;
        }
        MapUnitCache.DoubleMovement doubleMovement2 = doubleMovement;
        return this.hasDoubleMovement(doubleMovement2, target, stateForConditionals);
    }

    /*
     * WARNING - void declaration
     */
    private final float getEnemyMovementPenalty(Civilization civInfo, MapUnit enemyUnit) {
        if (civInfo.getEnemyMovementPenaltyUniques() != null) {
            Sequence<Unique> sequence = civInfo.getEnemyMovementPenaltyUniques();
            Intrinsics.checkNotNull(sequence);
            if (SequencesKt.any(sequence)) {
                Sequence<Unique> sequence2 = civInfo.getEnemyMovementPenaltyUniques();
                Intrinsics.checkNotNull(sequence2);
                Sequence<Unique> sequence3 = sequence2;
                int n = 0;
                Iterator<Unique> iterator2 = sequence3.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    Unique unique;
                    Unique unique2 = unique = iterator2.next();
                    int n2 = n;
                    boolean bl = false;
                    UniqueType uniqueType = it.getType();
                    Intrinsics.checkNotNull((Object)uniqueType);
                    int n3 = uniqueType == UniqueType.EnemyUnitsSpendExtraMovement && enemyUnit.matchesFilter(it.getParams().get(0)) ? Integer.parseInt(it.getParams().get(1)) : 0;
                    n = n2 + n3;
                }
                return n;
            }
        }
        return 0.0f;
    }

    private final boolean isMovementAffectedByZoneOfControl(MapUnit unit, Tile from, Tile to) {
        boolean bl;
        block2: {
            Sequence<Tile> tilesExertingZoneOfControl;
            Sequence<Tile> $this$none$iv = tilesExertingZoneOfControl = this.getTilesExertingZoneOfControl(unit, from);
            boolean $i$f$none = false;
            Iterator<Tile> iterator2 = $this$none$iv.iterator();
            while (iterator2.hasNext()) {
                Tile element$iv;
                Tile it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!(to.aerialDistanceTo(it) == 1)) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        if (bl) {
            return false;
        }
        return !unit.getCache().getIgnoresZoneOfControl();
    }

    private final Sequence<Tile> getTilesExertingZoneOfControl(MapUnit unit, Tile tile) {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super Tile>, Continuation<? super Unit>, Object>(tile, unit, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Tile $tile;
            final /* synthetic */ MapUnit $unit;
            {
                this.$tile = $tile;
                this.$unit = $unit;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2;
                Object object3;
                Iterator<Tile> iterator2;
                SequenceScope $this$sequence;
                Object object4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        $this$sequence = (SequenceScope)this.L$0;
                        iterator2 = this.$tile.getNeighbors().iterator();
                        break;
                    }
                    case 1: {
                        void $result;
                        iterator2 = (Iterator<Tile>)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        object3 = $result;
                        break;
                    }
                    case 2: {
                        void $result;
                        iterator2 = (Iterator)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        object2 = $result;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (iterator2.hasNext()) {
                    Tile neighbor = iterator2.next();
                    if (neighbor.isCityCenter()) {
                        Civilization civilization = this.$unit.getCiv();
                        Civilization civilization2 = neighbor.getOwner();
                        Intrinsics.checkNotNull(civilization2);
                        if (civilization.isAtWarWith(civilization2)) {
                            this.L$0 = $this$sequence;
                            this.L$1 = iterator2;
                            this.label = 1;
                            object3 = $this$sequence.yield(neighbor, this);
                            if (object3 != object4) continue;
                            return object4;
                        }
                    }
                    if (neighbor.getMilitaryUnit() == null) continue;
                    Civilization civilization = this.$unit.getCiv();
                    MapUnit mapUnit = neighbor.getMilitaryUnit();
                    Intrinsics.checkNotNull(mapUnit);
                    if (!civilization.isAtWarWith(mapUnit.getCiv())) continue;
                    MapUnit mapUnit2 = neighbor.getMilitaryUnit();
                    Intrinsics.checkNotNull(mapUnit2);
                    if (!mapUnit2.getType().isWaterUnit()) {
                        if (!this.$unit.getType().isLandUnit()) continue;
                        MapUnit mapUnit3 = neighbor.getMilitaryUnit();
                        Intrinsics.checkNotNull(mapUnit3);
                        if (mapUnit3.isEmbarked()) continue;
                    }
                    this.L$0 = $this$sequence;
                    this.L$1 = iterator2;
                    this.label = 2;
                    object2 = $this$sequence.yield(neighbor, this);
                    if (object2 != object4) continue;
                    return object4;
                }
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super Tile>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super Tile> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }
}

