/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapunit.movement;

import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.PathsToTilesWithinTurn;
import com.unciv.logic.map.tile.Tile;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\nJ\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0007\u001a\u00020\u0006J\b\u0010\u0015\u001a\u00020\nH\u0002J\u0016\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u000bJ\u001c\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/unciv/logic/map/mapunit/movement/PathfindingCache;", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "(Lcom/unciv/logic/map/mapunit/MapUnit;)V", "currentTile", "Lcom/unciv/logic/map/tile/Tile;", "destination", "distanceToTilesCache", "", "", "Lcom/unciv/logic/map/mapunit/movement/PathsToTilesWithinTurn;", "movement", "", "shortestPathCache", "", "clear", "", "getDistanceToTiles", "zoneOfControl", "getShortestPathCache", "isValid", "setDistanceToTiles", "paths", "setShortestPathCache", "newShortestPath", "core"})
public final class PathfindingCache {
    @NotNull
    private final MapUnit unit;
    @NotNull
    private List<Tile> shortestPathCache;
    @Nullable
    private Tile destination;
    @NotNull
    private final Map<Boolean, PathsToTilesWithinTurn> distanceToTilesCache;
    private float movement;
    @Nullable
    private Tile currentTile;

    public PathfindingCache(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        this.unit = unit;
        this.shortestPathCache = CollectionsKt.emptyList();
        this.distanceToTilesCache = new LinkedHashMap();
        this.movement = -1.0f;
    }

    private final boolean isValid() {
        return this.movement == this.unit.getCurrentMovement() && Intrinsics.areEqual(this.unit.getTile(), this.currentTile);
    }

    @NotNull
    public final List<Tile> getShortestPathCache(@NotNull Tile destination2) {
        Intrinsics.checkNotNullParameter(destination2, "destination");
        if (this.unit.getCiv().isHuman()) {
            return CollectionsKt.emptyList();
        }
        if (this.isValid() && Intrinsics.areEqual(this.destination, destination2)) {
            return this.shortestPathCache;
        }
        return CollectionsKt.emptyList();
    }

    public final void setShortestPathCache(@NotNull Tile destination2, @NotNull List<Tile> newShortestPath) {
        Intrinsics.checkNotNullParameter(destination2, "destination");
        Intrinsics.checkNotNullParameter(newShortestPath, "newShortestPath");
        if (this.unit.getCiv().isHuman()) {
            return;
        }
        if (this.isValid()) {
            this.shortestPathCache = newShortestPath;
            this.destination = destination2;
        }
    }

    @Nullable
    public final PathsToTilesWithinTurn getDistanceToTiles(boolean zoneOfControl) {
        if (this.unit.getCiv().isHuman()) {
            return null;
        }
        if (this.isValid()) {
            return this.distanceToTilesCache.get(zoneOfControl);
        }
        return null;
    }

    public final void setDistanceToTiles(boolean zoneOfControl, @NotNull PathsToTilesWithinTurn paths) {
        Intrinsics.checkNotNullParameter(paths, "paths");
        if (this.unit.getCiv().isHuman()) {
            return;
        }
        if (!this.isValid()) {
            this.clear();
        }
        Boolean bl = zoneOfControl;
        this.distanceToTilesCache.put(bl, paths);
    }

    public final void clear() {
        this.distanceToTilesCache.clear();
        this.movement = this.unit.getCurrentMovement();
        this.currentTile = this.unit.getTile();
        this.destination = null;
        this.shortestPathCache = CollectionsKt.emptyList();
    }
}

