/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.metadata;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Json;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.github.Github;
import com.unciv.logic.github.GithubAPI;
import com.unciv.models.metadata.ModCategories;
import com.unciv.ui.components.widgets.TranslatedSelectBox;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/unciv/models/metadata/ModCategories;", "Ljava/util/ArrayList;", "Lcom/unciv/models/metadata/ModCategories$Category;", "Lkotlin/collections/ArrayList;", "()V", "fromSelectBox", "selectBox", "Lcom/unciv/ui/components/widgets/TranslatedSelectBox;", "mergeOnline", "", "save", "", "Category", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nModCategories.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModCategories.kt\ncom/unciv/models/metadata/ModCategories\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n288#2,2:89\n1045#2:91\n288#2,2:92\n1#3:94\n*S KotlinDebug\n*F\n+ 1 ModCategories.kt\ncom/unciv/models/metadata/ModCategories\n*L\n69#1:89,2\n75#1:91\n76#1:92,2\n*E\n"})
public final class ModCategories
extends ArrayList<Category> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final String fileLocation = "jsons/ModCategories.json";
    @NotNull
    private static final ModCategories INSTANCE;

    private final void save() {
        Json json = UncivJsonKt.json();
        String compact = json.toJson((Object)this, ModCategories.class, Category.class);
        String verbose = json.prettyPrint(compact);
        Gdx.files.local(fileLocation).writeString(verbose, false, Charsets.UTF_8.name());
    }

    @NotNull
    public final Category fromSelectBox(@NotNull TranslatedSelectBox selectBox) {
        Category category;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(selectBox, "selectBox");
            String selected = ((TranslatedSelectBox.TranslatedString)selectBox.getSelected()).getValue();
            Iterable $this$firstOrNull$iv = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Category it = (Category)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getLabel(), selected)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((category = (Category)v0) == null) {
            category = Category.Companion.getAll();
        }
        return category;
    }

    @NotNull
    public final String mergeOnline() {
        GithubAPI.TopicSearchResponse topicSearchResponse = Github.INSTANCE.tryGetGithubTopics();
        if (topicSearchResponse == null) {
            return "Failed";
        }
        GithubAPI.TopicSearchResponse topics = topicSearchResponse;
        int newCount = 0;
        Iterable $this$sortedBy$iv = topics.getItems();
        boolean $i$f$sortedBy = false;
        for (GithubAPI.TopicSearchResponse.Topic topic : CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                GithubAPI.TopicSearchResponse.Topic it = (GithubAPI.TopicSearchResponse.Topic)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (GithubAPI.TopicSearchResponse.Topic)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
            }
        })) {
            Object v1;
            block4: {
                Iterable $this$firstOrNull$iv = this;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Category it = (Category)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getTopic(), topic.getName())) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            Category existing = v1;
            if (existing != null) {
                existing.setModifyDate(topic.getUpdated_at());
                continue;
            }
            this.add(new Category(topic));
            ++newCount;
        }
        this.save();
        return newCount + " new categories";
    }

    static {
        ModCategories modCategories;
        Companion = new Companion(null);
        FileHandle file = Gdx.files.internal(fileLocation);
        if (file.exists()) {
            ModCategories modCategories2 = UncivJsonKt.json().fromJson(ModCategories.class, Category.class, file);
            Intrinsics.checkNotNullExpressionValue(modCategories2, "fromJson(...)");
            modCategories = modCategories2;
        } else {
            ModCategories modCategories3;
            ModCategories $this$_init__u24lambda_u243 = modCategories3 = new ModCategories();
            boolean bl = false;
            $this$_init__u24lambda_u243.add(Companion.default());
            modCategories = modCategories3;
        }
        INSTANCE = modCategories;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B-\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u0016\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u001a\u0010\u000b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0003\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/unciv/models/metadata/ModCategories$Category;", "", "()V", "topic", "Lcom/unciv/logic/github/GithubAPI$TopicSearchResponse$Topic;", "(Lcom/unciv/logic/github/GithubAPI$TopicSearchResponse$Topic;)V", "label", "", "hidden", "", "createDate", "modifyDate", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;)V", "getCreateDate", "()Ljava/lang/String;", "getHidden", "()Z", "getLabel", "getModifyDate", "setModifyDate", "(Ljava/lang/String;)V", "getTopic", "equals", "other", "hashCode", "", "toString", "Companion", "core"})
    public static final class Category {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String label;
        @NotNull
        private final String topic;
        private final boolean hidden;
        @NotNull
        private final String createDate;
        @NotNull
        private String modifyDate;
        @NotNull
        private static final Category All = new Category("All mods", "unciv-mod", false, "", "");

        public Category(@NotNull String label2, @NotNull String topic, boolean hidden, @NotNull String createDate, @NotNull String modifyDate) {
            Intrinsics.checkNotNullParameter(label2, "label");
            Intrinsics.checkNotNullParameter(topic, "topic");
            Intrinsics.checkNotNullParameter(createDate, "createDate");
            Intrinsics.checkNotNullParameter(modifyDate, "modifyDate");
            this.label = label2;
            this.topic = topic;
            this.hidden = hidden;
            this.createDate = createDate;
            this.modifyDate = modifyDate;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @NotNull
        public final String getTopic() {
            return this.topic;
        }

        public final boolean getHidden() {
            return this.hidden;
        }

        @NotNull
        public final String getCreateDate() {
            return this.createDate;
        }

        @NotNull
        public final String getModifyDate() {
            return this.modifyDate;
        }

        public final void setModifyDate(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.modifyDate = string;
        }

        public Category() {
            this("", "", false, "", "");
        }

        public Category(@NotNull GithubAPI.TopicSearchResponse.Topic topic) {
            Intrinsics.checkNotNullParameter(topic, "topic");
            this(Companion.labelSuggestion(topic), topic.getName(), true, topic.getCreated_at(), topic.getUpdated_at());
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof Category && Intrinsics.areEqual(this.topic, ((Category)other).topic);
        }

        public int hashCode() {
            return this.topic.hashCode();
        }

        @NotNull
        public String toString() {
            return this.label;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/unciv/models/metadata/ModCategories$Category$Companion;", "", "()V", "All", "Lcom/unciv/models/metadata/ModCategories$Category;", "getAll", "()Lcom/unciv/models/metadata/ModCategories$Category;", "labelSuggestion", "", "topic", "Lcom/unciv/logic/github/GithubAPI$TopicSearchResponse$Topic;", "core"})
        @SourceDebugExtension(value={"SMAP\nModCategories.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModCategories.kt\ncom/unciv/models/metadata/ModCategories$Category$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Category getAll() {
                return All;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final String labelSuggestion(@NotNull GithubAPI.TopicSearchResponse.Topic topic) {
                String string;
                block6: {
                    String string2;
                    block5: {
                        Intrinsics.checkNotNullParameter(topic, "topic");
                        string = topic.getDisplay_name();
                        if (string == null) break block5;
                        String it = string2 = string;
                        boolean bl = false;
                        string = !StringsKt.isBlank(it) ? string2 : null;
                        if (string != null) break block6;
                    }
                    if (((CharSequence)(string2 = StringsKt.removePrefix(topic.getName(), (CharSequence)"unciv-mod-"))).length() > 0) {
                        void p0;
                        char it = string2.charAt(0);
                        StringBuilder stringBuilder = new StringBuilder();
                        boolean bl = false;
                        StringBuilder stringBuilder2 = stringBuilder.append((Object)CharsKt.titlecase((char)p0));
                        String string3 = string2;
                        int n = 1;
                        String string4 = string3.substring(n);
                        Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
                        string = stringBuilder2.append(string4).toString();
                    } else {
                        string = string2;
                    }
                }
                return string;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0086\u0002J\u0006\u0010\u0010\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/unciv/models/metadata/ModCategories$Companion;", "", "()V", "INSTANCE", "Lcom/unciv/models/metadata/ModCategories;", "fileLocation", "", "asSequence", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/metadata/ModCategories$Category;", "default", "fromSelectBox", "selectBox", "Lcom/unciv/ui/components/widgets/TranslatedSelectBox;", "iterator", "", "mergeOnline", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Category default() {
            return Category.Companion.getAll();
        }

        @NotNull
        public final String mergeOnline() {
            return INSTANCE.mergeOnline();
        }

        @NotNull
        public final Category fromSelectBox(@NotNull TranslatedSelectBox selectBox) {
            Intrinsics.checkNotNullParameter(selectBox, "selectBox");
            return INSTANCE.fromSelectBox(selectBox);
        }

        @NotNull
        public final Sequence<Category> asSequence() {
            return SequencesKt.filter(CollectionsKt.asSequence(INSTANCE), asSequence.1.INSTANCE);
        }

        @NotNull
        public final Iterator<Category> iterator() {
            return this.asSequence().iterator();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

