/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.GameInfo;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.ReligionManager;
import com.unciv.models.Counter;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.Milestone;
import com.unciv.models.ruleset.MilestoneType;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.PolicyBranch;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a2\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0013J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0\b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020\u0013J\u000e\u0010%\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u0013J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0018\u001a\u00020\u0013H\u0002R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006("}, d2={"Lcom/unciv/models/ruleset/Milestone;", "", "uniqueDescription", "", "parentVictory", "Lcom/unciv/models/ruleset/Victory;", "(Ljava/lang/String;Lcom/unciv/models/ruleset/Victory;)V", "params", "", "getParams", "()Ljava/util/List;", "type", "Lcom/unciv/models/ruleset/MilestoneType;", "getType", "()Lcom/unciv/models/ruleset/MilestoneType;", "getUniqueDescription", "()Ljava/lang/String;", "civsWithPotentialCapitalsToOwn", "", "Lcom/unciv/logic/civilization/Civilization;", "gameInfo", "Lcom/unciv/logic/GameInfo;", "getFocus", "Lcom/unciv/models/ruleset/Victory$Focus;", "civInfo", "getIncompleteSpaceshipParts", "Lcom/unciv/models/Counter;", "getMilestoneButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "text", "achieved", "", "getVictoryScreenButtonHeaderText", "completed", "getVictoryScreenButtons", "completionStatus", "Lcom/unciv/models/ruleset/Victory$CompletionStatus;", "hasBeenCompletedBy", "originalMajorCapitalsOwned", "", "core"})
@SourceDebugExtension(value={"SMAP\nVictory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Victory.kt\ncom/unciv/models/ruleset/Milestone\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,328:1\n1282#2,2:329\n1774#3,4:331\n766#3:335\n857#3,2:336\n1747#3,3:338\n1963#3,14:343\n766#3:357\n857#3,2:358\n1726#3,3:360\n1774#3,4:363\n1774#3,4:367\n1774#3,4:371\n1774#3,4:375\n766#3:379\n857#3,2:380\n766#3:387\n857#3,2:388\n1549#3:390\n1620#3,3:391\n1747#3,3:394\n1247#4,2:341\n674#4:382\n704#4,4:383\n*S KotlinDebug\n*F\n+ 1 Victory.kt\ncom/unciv/models/ruleset/Milestone\n*L\n75#1:329,2\n85#1:331,4\n93#1:335\n93#1:336,2\n100#1:338,3\n116#1:343,14\n122#1:357\n122#1:358,2\n123#1:360,3\n160#1:363,4\n163#1:367,4\n180#1:371,4\n186#1:375,4\n244#1:379\n244#1:380,2\n276#1:387\n276#1:388,2\n311#1:390\n311#1:391,3\n316#1:394,3\n110#1:341,2\n246#1:382\n246#1:383,4\n*E\n"})
public final class Milestone {
    @NotNull
    private final String uniqueDescription;
    @NotNull
    private final Victory parentVictory;
    @Nullable
    private final MilestoneType type;
    @NotNull
    private final List<String> params;

    /*
     * WARNING - void declaration
     */
    public Milestone(@NotNull String uniqueDescription, @NotNull Victory parentVictory) {
        Object v0;
        block1: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter(uniqueDescription, "uniqueDescription");
            Intrinsics.checkNotNullParameter(parentVictory, "parentVictory");
            this.uniqueDescription = uniqueDescription;
            this.parentVictory = parentVictory;
            MilestoneType[] milestoneTypeArray = MilestoneType.values();
            Milestone milestone = this;
            boolean $i$f$firstOrNull = false;
            int n = ((void)$this$firstOrNull$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv;
                void it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual(TranslationsKt.getPlaceholderText(this.uniqueDescription), TranslationsKt.getPlaceholderText(it.getText()))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        milestone.type = v0;
        this.params = TranslationsKt.getPlaceholderParameters(this.uniqueDescription);
    }

    @NotNull
    public final String getUniqueDescription() {
        return this.uniqueDescription;
    }

    @Nullable
    public final MilestoneType getType() {
        return this.type;
    }

    @NotNull
    public final List<String> getParams() {
        return this.params;
    }

    private final Counter<String> getIncompleteSpaceshipParts(Civilization civInfo) {
        Object incompleteSpaceshipParts = this.parentVictory.getRequiredSpaceshipPartsAsCounter().clone();
        ((Counter)incompleteSpaceshipParts).remove(civInfo.getVictoryManager().getCurrentsSpaceshipParts());
        return incompleteSpaceshipParts;
    }

    private final int originalMajorCapitalsOwned(Civilization civInfo) {
        int n;
        Iterable $this$count$iv = civInfo.getCities();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                City it = (City)element$iv;
                boolean bl = false;
                if (!(it.isOriginalCapital() && !Intrinsics.areEqual(it.getFoundingCiv(), "") && civInfo.getGameInfo().getCivilization(it.getFoundingCiv()).isMajorCiv()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Civilization> civsWithPotentialCapitalsToOwn(GameInfo gameInfo2) {
        void $this$filterTo$iv$iv;
        Set civsWithCapitals2 = SequencesKt.toSet(SequencesKt.filter(SequencesKt.map(SequencesKt.filter(gameInfo2.getCities(), civsWithPotentialCapitalsToOwn.civsWithCapitals.1.INSTANCE), (Function1)new Function1<City, Civilization>(gameInfo2){
            final /* synthetic */ GameInfo $gameInfo;
            {
                this.$gameInfo = $gameInfo;
                super(1);
            }

            @NotNull
            public final Civilization invoke(@NotNull City it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$gameInfo.getCivilization(it.getFoundingCiv());
            }
        }), civsWithPotentialCapitalsToOwn.civsWithCapitals.3.INSTANCE));
        Iterable $this$filter$iv = gameInfo2.getCivilizations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(it.isMajorCiv() && !it.isDefeated())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List livingCivs = (List)destination$iv$iv;
        return CollectionsKt.union(civsWithCapitals2, livingCivs);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasBeenCompletedBy(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        MilestoneType milestoneType = this.type;
        Intrinsics.checkNotNull((Object)milestoneType);
        switch (WhenMappings.$EnumSwitchMapping$0[milestoneType.ordinal()]) {
            case 1: {
                City it;
                Iterable $this$any$iv = civInfo.getCities();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator iterator2 = $this$any$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return false;
                    Object element$iv = iterator2.next();
                    it = (City)element$iv;
                    boolean bl = false;
                } while (!it.getCityConstructions().isBuilt(this.params.get(0)));
                return true;
            }
            case 2: {
                boolean bl = this.getIncompleteSpaceshipParts(civInfo).isEmpty();
                return bl;
            }
            case 3: {
                boolean bl = Intrinsics.areEqual(civInfo.getGameInfo().getAliveMajorCivs(), CollectionsKt.listOf(civInfo));
                return bl;
            }
            case 4: {
                if (this.originalMajorCapitalsOwned(civInfo) != this.civsWithPotentialCapitalsToOwn(civInfo.getGameInfo()).size()) return false;
                return true;
            }
            case 5: {
                if (civInfo.getPolicies().getCompletedBranches().size() < Integer.parseInt(this.params.get(0))) return false;
                return true;
            }
            case 6: {
                City it;
                Sequence<City> $this$any$iv = civInfo.getGameInfo().getCities();
                boolean $i$f$any = false;
                Iterator<City> iterator3 = $this$any$iv.iterator();
                do {
                    City element$iv;
                    if (!iterator3.hasNext()) return false;
                    it = element$iv = iterator3.next();
                    boolean bl = false;
                } while (!it.getCityConstructions().isBuilt(this.params.get(0)));
                return true;
            }
            case 7: {
                boolean bl = civInfo.getVictoryManager().getHasEverWonDiplomaticVote();
                return bl;
            }
            case 8: {
                Object v2;
                void $this$maxByOrNull$iv;
                if (civInfo.getGameInfo().getTurns() < civInfo.getGameInfo().getGameParameters().getMaxTurns()) return false;
                Iterable $this$any$iv = civInfo.getGameInfo().getCivilizations();
                Civilization civilization = civInfo;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v2 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v2 = maxElem$iv;
                    } else {
                        Civilization it = (Civilization)maxElem$iv;
                        boolean bl = false;
                        double maxValue$iv = it.calculateTotalScore();
                        do {
                            Object e$iv = iterator$iv.next();
                            Civilization it2 = (Civilization)e$iv;
                            $i$a$-maxByOrNull-Milestone$hasBeenCompletedBy$3 = false;
                            double v$iv = it2.calculateTotalScore();
                            if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v2 = maxElem$iv;
                    }
                }
                if (!Intrinsics.areEqual(civilization, v2)) return false;
                return true;
            }
            case 9: {
                Religion religion;
                ReligionManager religionManager;
                void $this$filterTo$iv$iv;
                if (!civInfo.getGameInfo().isReligionEnabled()) return false;
                if (civInfo.getReligionManager().getReligion() == null) return false;
                Iterable $this$filter$iv = civInfo.getGameInfo().getCivilizations();
                boolean $i$f$filter = false;
                Iterable iterator$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Civilization it = (Civilization)element$iv$iv;
                    boolean bl = false;
                    if (!(it.isMajorCiv() && it.isAlive())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$all$iv = (List)destination$iv$iv;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    return true;
                }
                Iterator iterator4 = $this$all$iv.iterator();
                do {
                    if (!iterator4.hasNext()) return true;
                    Object element$iv = iterator4.next();
                    Civilization it = (Civilization)element$iv;
                    boolean bl = false;
                    religionManager = it.getReligionManager();
                    religion = civInfo.getReligionManager().getReligion();
                    Intrinsics.checkNotNull(religion);
                } while (religionManager.isMajorityReligionForCiv(religion));
                return false;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final TextButton getMilestoneButton(String text2, boolean achieved) {
        TextButton textButton = Scene2dExtensionsKt.toTextButton$default(text2, null, false, 3, null);
        if (achieved) {
            textButton.setColor(Color.GREEN);
        } else {
            textButton.setColor(Color.GRAY);
        }
        return textButton;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final String getVictoryScreenButtonHeaderText(boolean completed, @NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        v0 = this.type;
        Intrinsics.checkNotNull((Object)v0);
        switch (WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                v1 = this.uniqueDescription;
                break;
            }
            case 5: {
                amountToDo = TranslationsKt.tr$default(this.params.get(0), false, 1, null);
                amountDone = completed != false ? amountToDo : TranslationsKt.tr(civInfo.getCompletedPolicyBranchesCount());
                v1 = '{' + this.uniqueDescription + "} (" + amountDone + '/' + amountToDo + ')';
                break;
            }
            case 4: {
                amountToDo = this.civsWithPotentialCapitalsToOwn(civInfo.getGameInfo()).size();
                v2 = amountDone = completed != false ? amountToDo : this.originalMajorCapitalsOwned(civInfo);
                if (civInfo.hideCivCount()) {
                    v1 = '{' + this.uniqueDescription + "} (" + TranslationsKt.tr(amountDone) + "/?)";
                    break;
                }
                v1 = '{' + this.uniqueDescription + "} (" + TranslationsKt.tr(amountDone) + '/' + TranslationsKt.tr(amountToDo) + ')';
                break;
            }
            case 3: {
                $this$count$iv = civInfo.getGameInfo().getCivilizations();
                $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    v3 = 0;
                } else {
                    count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        it = (Civilization)element$iv;
                        $i$a$-count-Milestone$getVictoryScreenButtonHeaderText$amountToDo$1 = false;
                        if (!it.isMajorCiv() || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    v3 = count$iv;
                }
                amountToDo = v3 - 1;
                if (completed) {
                    v4 = amountToDo;
                } else {
                    $i$f$count = civInfo.getGameInfo().getAliveMajorCivs();
                    var12_35 = amountToDo;
                    $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        v5 = 0;
                    } else {
                        count$iv = 0;
                        for (E element$iv : $this$count$iv) {
                            it = (Civilization)element$iv;
                            $i$a$-count-Milestone$getVictoryScreenButtonHeaderText$amountDone$1 = false;
                            if (!(Intrinsics.areEqual(it, civInfo) == false) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        v5 = count$iv;
                    }
                    var13_38 = v5;
                    v4 = amountDone = var12_35 - var13_38;
                }
                if (civInfo.hideCivCount()) {
                    v1 = '{' + this.uniqueDescription + "} (" + TranslationsKt.tr(amountDone) + "/?)";
                    break;
                }
                v1 = '{' + this.uniqueDescription + "} (" + TranslationsKt.tr(amountDone) + '/' + TranslationsKt.tr(amountToDo) + ')';
                break;
            }
            case 2: {
                completeSpaceshipParts = civInfo.getVictoryManager().getCurrentsSpaceshipParts();
                incompleteSpaceshipParts = this.parentVictory.getRequiredSpaceshipPartsAsCounter().clone();
                amountToDo = incompleteSpaceshipParts.sumValues();
                incompleteSpaceshipParts.remove(completeSpaceshipParts);
                amountDone = amountToDo - incompleteSpaceshipParts.sumValues();
                v1 = '{' + this.uniqueDescription + "} (" + TranslationsKt.tr(amountDone) + '/' + TranslationsKt.tr(amountToDo) + ')';
                break;
            }
            case 9: {
                $this$count$iv = civInfo.getGameInfo().getCivilizations();
                $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    v6 = 0;
                } else {
                    count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        it = (Civilization)element$iv;
                        $i$a$-count-Milestone$getVictoryScreenButtonHeaderText$amountToDo$2 = false;
                        if (!(it.isMajorCiv() != false && it.isAlive() != false) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    v6 = count$iv;
                }
                amountToDo = v6 - 1;
                if (!completed) ** GOTO lbl87
                v7 = amountToDo;
                ** GOTO lbl117
lbl87:
                // 1 sources

                if (civInfo.getReligionManager().getReligion() != null) ** GOTO lbl90
                v7 = 0;
                ** GOTO lbl117
lbl90:
                // 1 sources

                v8 = civInfo.getReligionManager().getReligion();
                Intrinsics.checkNotNull(v8);
                if (!v8.isPantheon()) ** GOTO lbl95
                v7 = 1;
                ** GOTO lbl117
lbl95:
                // 1 sources

                $this$count$iv = civInfo.getGameInfo().getCivilizations();
                $i$f$count = false;
                if (!($this$count$iv instanceof Collection) || !((Collection)$this$count$iv).isEmpty()) ** GOTO lbl100
                v7 = 0;
                ** GOTO lbl117
lbl100:
                // 1 sources

                count$iv = 0;
                for (T element$iv : $this$count$iv) {
                    it = (Civilization)element$iv;
                    $i$a$-count-Milestone$getVictoryScreenButtonHeaderText$amountDone$2 = false;
                    if (!it.isMajorCiv() || !it.isAlive()) ** GOTO lbl-1000
                    v9 = it.getReligionManager();
                    v10 = civInfo.getReligionManager().getReligion();
                    Intrinsics.checkNotNull(v10);
                    if (v9.isMajorityReligionForCiv(v10)) {
                        v11 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v11 = false;
                    }
                    if (!v11 || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v7 = count$iv;
lbl117:
                // 5 sources

                amountDone = v7;
                v1 = '{' + this.uniqueDescription + "} (" + TranslationsKt.tr(amountDone) + '/' + TranslationsKt.tr(amountToDo) + ')';
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextButton> getVictoryScreenButtons(@NotNull Victory.CompletionStatus completionStatus, @NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter((Object)completionStatus, "completionStatus");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        TextButton headerButton = this.getMilestoneButton(this.getVictoryScreenButtonHeaderText(completionStatus == Victory.CompletionStatus.Completed, civInfo), completionStatus == Victory.CompletionStatus.Completed);
        if (completionStatus == Victory.CompletionStatus.Completed || completionStatus == Victory.CompletionStatus.Incomplete) {
            return CollectionsKt.listOf(headerButton);
        }
        TextButton[] textButtonArray = new TextButton[]{headerButton};
        List<TextButton> buttons = CollectionsKt.mutableListOf(textButtonArray);
        MilestoneType milestoneType = this.type;
        switch (milestoneType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[milestoneType.ordinal()]) {
            case -1: 
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                int it;
                int n;
                int n2;
                Counter<String> completedSpaceshipParts = civInfo.getVictoryManager().getCurrentsSpaceshipParts();
                Counter<String> incompleteSpaceshipParts = this.getIncompleteSpaceshipParts(civInfo);
                for (Map.Entry part3 : ((Map)completedSpaceshipParts).entrySet()) {
                    n2 = ((Number)part3.getValue()).intValue();
                    n = 0;
                    while (n < n2) {
                        it = n++;
                        boolean bl = false;
                        buttons.add(this.getMilestoneButton((String)part3.getKey(), true));
                    }
                }
                for (Map.Entry part3 : ((Map)incompleteSpaceshipParts).entrySet()) {
                    n2 = ((Number)part3.getValue()).intValue();
                    n = 0;
                    while (n < n2) {
                        it = n++;
                        boolean bl = false;
                        buttons.add(this.getMilestoneButton((String)part3.getKey(), false));
                    }
                }
                break;
            }
            case 3: {
                boolean hideCivCount = civInfo.hideCivCount();
                for (Civilization civ : civInfo.getGameInfo().getCivilizations()) {
                    if (Intrinsics.areEqual(civ, civInfo) || !civ.isMajorCiv() || hideCivCount && !civInfo.knows(civ)) continue;
                    String milestoneText = civInfo.knows(civ) || civ.isDefeated() ? "Destroy [" + civ.getCivName() + ']' : "Destroy [???]";
                    buttons.add(this.getMilestoneButton(milestoneText, civ.isDefeated()));
                }
                if (!hideCivCount) break;
                buttons.add(this.getMilestoneButton("Destroy ? * [???]", false));
                break;
            }
            case 4: {
                void $this$associateByTo$iv$iv;
                Iterator $this$associateBy$iv;
                void $this$filterTo$iv$iv;
                boolean hideCivCount = civInfo.hideCivCount();
                Iterable $this$filter$iv = civInfo.getGameInfo().getCivilizations();
                boolean $i$f$filter22 = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Civilization it = (Civilization)element$iv$iv;
                    boolean bl = false;
                    if (!it.isMajorCiv()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List majorCivs2 = (List)destination$iv$iv;
                Sequence<City> $i$f$filter22 = SequencesKt.filter(civInfo.getGameInfo().getCities(), getVictoryScreenButtons.originalCapitals.1.INSTANCE);
                boolean $i$f$associateBy = false;
                destination$iv$iv = $this$associateBy$iv;
                Map destination$iv$iv2 = new LinkedHashMap();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    City bl = (City)element$iv$iv;
                    Map map2 = destination$iv$iv2;
                    boolean bl2 = false;
                    map2.put(it.getFoundingCiv(), element$iv$iv);
                }
                Map originalCapitals2 = destination$iv$iv2;
                for (Civilization civ2 : majorCivs2) {
                    City city2 = (City)originalCapitals2.get(civ2.getCivName());
                    if (city2 != null) {
                        boolean isKnown2 = civInfo.hasExplored(city2.getCenterTile());
                        if (hideCivCount && !isKnown2) continue;
                        String milestoneText = isKnown2 ? "Capture [" + city2.getName() + ']' : "Capture [???]";
                        buttons.add(this.getMilestoneButton(milestoneText, Intrinsics.areEqual(city2.getCiv(), civInfo)));
                        continue;
                    }
                    String milestoneText = civInfo.knows(civ2) || civ2.isDefeated() ? "Destroy [" + civ2.getCivName() + ']' : "Destroy [???]";
                    buttons.add(this.getMilestoneButton(milestoneText, civ2.isDefeated()));
                }
                if (!hideCivCount) break;
                buttons.add(this.getMilestoneButton("Capture ? * [???]", false));
                break;
            }
            case 5: {
                for (PolicyBranch branch : civInfo.getGameInfo().getRuleset().getPolicyBranches().values()) {
                    String finisher = ((Policy)CollectionsKt.last((List)branch.getPolicies())).getName();
                    buttons.add(this.getMilestoneButton(finisher, civInfo.getPolicies().isAdopted(finisher)));
                }
                break;
            }
            case 9: {
                void $this$filterTo$iv$iv;
                boolean hideCivCount = civInfo.hideCivCount();
                Iterable $this$filter$iv = civInfo.getGameInfo().getCivilizations();
                boolean $i$f$filter = false;
                Object civ2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Civilization it = (Civilization)element$iv$iv;
                    boolean bl = false;
                    if (!(it.isMajorCiv() && it.isAlive())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List majorCivs3 = (List)destination$iv$iv;
                Religion civReligion = civInfo.getReligionManager().getReligion();
                for (Object civ2 : majorCivs3) {
                    if (hideCivCount && !civInfo.knows((Civilization)civ2)) continue;
                    String milestoneText = civInfo.knows((Civilization)civ2) ? "Majority religion of [" + ((Civilization)civ2).getCivName() + ']' : "Majority religion of [???]";
                    boolean milestoneMet = civReligion != null && (!civReligion.isPantheon() || Intrinsics.areEqual(civInfo, civ2)) && ((Civilization)civ2).getReligionManager().isMajorityReligionForCiv(civReligion);
                    buttons.add(this.getMilestoneButton(milestoneText, milestoneMet));
                }
                if (!hideCivCount) break;
                buttons.add(this.getMilestoneButton("Majority religion of ? * [???]", false));
            }
        }
        return buttons;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final Victory.Focus getFocus(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        ruleset = civInfo.getGameInfo().getRuleset();
        v0 = this.type;
        Intrinsics.checkNotNull((Object)v0);
        switch (WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
            case 1: {
                v1 = ruleset.getBuildings().get(this.params.get(0));
                Intrinsics.checkNotNull(v1);
                building = v1;
                if (!civInfo.getTech().isResearched(building)) {
                }
                v2 = Victory.Focus.Production;
                break;
            }
            case 6: {
                v3 = ruleset.getBuildings().get(this.params.get(0));
                Intrinsics.checkNotNull(v3);
                building = v3;
                if (!civInfo.getTech().isResearched(building)) {
                }
                v2 = Victory.Focus.Production;
                break;
            }
            case 2: {
                v4 = this.getIncompleteSpaceshipParts(civInfo).keySet();
                Intrinsics.checkNotNullExpressionValue(v4, "<get-keys>(...)");
                $this$map$iv = v4;
                $i$f$map = false;
                var6_8 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var11_15 = (String)item$iv$iv;
                    var13_17 = destination$iv$iv;
                    $i$a$-map-Milestone$getFocus$constructions$1 = false;
                    v5 = ruleset.getBuildings();
                    Intrinsics.checkNotNull(it);
                    if (v5.containsKey(it)) {
                        v6 = ruleset.getBuildings().get(it);
                        Intrinsics.checkNotNull(v6);
                        v7 = v6;
                    } else {
                        v8 = ruleset.getUnits().get(it);
                        Intrinsics.checkNotNull(v8);
                        v7 = v8;
                    }
                    var13_17.add(v7);
                }
                constructions = (List)destination$iv$iv;
                $this$any$iv = constructions;
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl54
                v9 = false;
                ** GOTO lbl61
lbl54:
                // 2 sources

                for (E element$iv : $this$any$iv) {
                    it = (IHasUniques)element$iv;
                    $i$a$-any-Milestone$getFocus$1 = false;
                    if (!(civInfo.getTech().isResearched((INonPerpetualConstruction)it) == false)) continue;
                    v9 = true;
                    ** GOTO lbl61
                }
                v9 = false;
lbl61:
                // 3 sources

                if (v9) {
                }
                v2 = Victory.Focus.Production;
                break;
            }
            case 3: 
            case 4: {
                v2 = Victory.Focus.Military;
                break;
            }
            case 5: {
                v2 = Victory.Focus.Culture;
                break;
            }
            case 7: {
                v2 = Victory.Focus.CityStates;
                break;
            }
            case 8: {
                v2 = Victory.Focus.Score;
                break;
            }
            case 9: {
                v2 = Victory.Focus.Faith;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v2;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MilestoneType.values().length];
            try {
                nArray[MilestoneType.BuiltBuilding.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.AddedSSPartsInCapital.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.DestroyAllPlayers.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.CaptureAllCapitals.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.CompletePolicyBranches.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.BuildingBuiltGlobally.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.WinDiplomaticVote.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.ScoreAfterTimeOut.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MilestoneType.WorldReligion.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

