/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset;

import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/unciv/models/ruleset/PerpetualStatConversion;", "Lcom/unciv/models/ruleset/PerpetualConstruction;", "stat", "Lcom/unciv/models/stats/Stat;", "(Lcom/unciv/models/stats/Stat;)V", "getStat", "()Lcom/unciv/models/stats/Stat;", "getConversionRate", "", "city", "Lcom/unciv/logic/city/City;", "getProductionTooltip", "", "withIcon", "", "isBuildable", "cityConstructions", "Lcom/unciv/logic/city/CityConstructions;", "core"})
@SourceDebugExtension(value={"SMAP\nIConstruction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IConstruction.kt\ncom/unciv/models/ruleset/PerpetualStatConversion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,281:1\n1247#2,2:282\n*S KotlinDebug\n*F\n+ 1 IConstruction.kt\ncom/unciv/models/ruleset/PerpetualStatConversion\n*L\n278#1:282,2\n*E\n"})
public class PerpetualStatConversion
extends PerpetualConstruction {
    @NotNull
    private final Stat stat;

    public PerpetualStatConversion(@NotNull Stat stat) {
        Intrinsics.checkNotNullParameter((Object)stat, "stat");
        super(stat.name(), "Convert production to [" + stat.name() + "] at a rate of [rate] to 1");
        this.stat = stat;
    }

    @NotNull
    public final Stat getStat() {
        return this.stat;
    }

    @Override
    @NotNull
    public String getProductionTooltip(@NotNull City city2, boolean withIcon) {
        Intrinsics.checkNotNullParameter(city2, "city");
        return "\r\n" + MathKt.roundToInt(city2.getCityStats().getCurrentCityStats().getProduction() / (float)this.getConversionRate(city2)) + (withIcon ? Character.valueOf(this.stat.getCharacter()) : "") + "/\u23f3";
    }

    public final int getConversionRate(@NotNull City city2) {
        Intrinsics.checkNotNullParameter(city2, "city");
        return MathKt.roundToInt(1.0f / city2.getCityStats().getStatConversionRate(this.stat));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isBuildable(@NotNull CityConstructions cityConstructions) {
        boolean bl;
        block2: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter(cityConstructions, "cityConstructions");
            City city2 = cityConstructions.getCity();
            if (this.stat == Stat.Faith && !city2.getCiv().getGameInfo().isReligionEnabled()) {
                return false;
            }
            StateForConditionals stateForConditionals = new StateForConditionals(city2.getCiv(), city2, null, city2.getCenterTile(), null, null, null, null, null, false, 1012, null);
            Sequence<Unique> sequence = city2.getCiv().getMatchingUniques(UniqueType.EnablesCivWideStatProduction, stateForConditionals);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Unique it = (Unique)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getParams().get(0), this.stat.name())) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }
}

