/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.tech;

import com.unciv.Constants;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.TechColumn;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.ui.objectdescriptions.TechnologyDescriptions;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001f\u001a\u00020\u0011J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010!\u001a\u00020\"H\u0016J\u000e\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020*H\u0016J\u0006\u0010+\u001a\u00020,J\b\u0010-\u001a\u00020\u0011H\u0016J\u000e\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020\u0011J\u000e\u00100\u001a\u00020,2\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020,2\u0006\u00101\u001a\u000202R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR*\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\f\"\u0004\b\u001e\u0010\u000e\u00a8\u00064"}, d2={"Lcom/unciv/models/ruleset/tech/Technology;", "Lcom/unciv/models/ruleset/RulesetObject;", "()V", "column", "Lcom/unciv/models/ruleset/tech/TechColumn;", "getColumn", "()Lcom/unciv/models/ruleset/tech/TechColumn;", "setColumn", "(Lcom/unciv/models/ruleset/tech/TechColumn;)V", "cost", "", "getCost", "()I", "setCost", "(I)V", "prerequisites", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getPrerequisites", "()Ljava/util/HashSet;", "setPrerequisites", "(Ljava/util/HashSet;)V", "quote", "getQuote", "()Ljava/lang/String;", "setQuote", "(Ljava/lang/String;)V", "row", "getRow", "setRow", "era", "Lcom/unciv/models/ruleset/tech/Era;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getCivilopediaTextLines", "", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "getDescription", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "getUniqueTarget", "Lcom/unciv/models/ruleset/unique/UniqueTarget;", "isContinuallyResearchable", "", "makeLink", "matchesFilter", "filter", "uniqueIsNotRequirementForThisTech", "unique", "Lcom/unciv/models/ruleset/unique/Unique;", "uniqueIsRequirementForThisTech", "core"})
@SourceDebugExtension(value={"SMAP\nTechnology.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Technology.kt\ncom/unciv/models/ruleset/tech/Technology\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class Technology
extends RulesetObject {
    private int cost;
    @NotNull
    private HashSet<String> prerequisites = new HashSet();
    @Nullable
    private TechColumn column;
    private int row;
    @NotNull
    private String quote = "";

    public final int getCost() {
        return this.cost;
    }

    public final void setCost(int n) {
        this.cost = n;
    }

    @NotNull
    public final HashSet<String> getPrerequisites() {
        return this.prerequisites;
    }

    public final void setPrerequisites(@NotNull HashSet<String> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.prerequisites = hashSet;
    }

    @Override
    @NotNull
    public UniqueTarget getUniqueTarget() {
        return UniqueTarget.Tech;
    }

    @Nullable
    public final TechColumn getColumn() {
        return this.column;
    }

    public final void setColumn(@Nullable TechColumn techColumn2) {
        this.column = techColumn2;
    }

    public final int getRow() {
        return this.row;
    }

    public final void setRow(int n) {
        this.row = n;
    }

    @NotNull
    public final String getQuote() {
        return this.quote;
    }

    public final void setQuote(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.quote = string;
    }

    @NotNull
    public final String era() {
        TechColumn techColumn2 = this.column;
        Intrinsics.checkNotNull(techColumn2);
        return techColumn2.getEra();
    }

    public final boolean isContinuallyResearchable() {
        return IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)this, UniqueType.ResearchableMultipleTimes, null, 2, null);
    }

    @NotNull
    public final String getDescription(@NotNull Civilization viewingCiv) {
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        return TechnologyDescriptions.INSTANCE.getDescription(this, viewingCiv);
    }

    @Override
    @NotNull
    public String makeLink() {
        return "Technology/" + this.getName();
    }

    @Override
    @NotNull
    public List<FormattedLine> getCivilopediaTextLines(@NotNull Ruleset ruleset2) {
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        return TechnologyDescriptions.INSTANCE.getCivilopediaTextLines(this, ruleset2);
    }

    @Override
    @Nullable
    public Era era(@NotNull Ruleset ruleset2) {
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        return ruleset2.getEras().get(this.era());
    }

    public final boolean matchesFilter(@NotNull String filter2) {
        Intrinsics.checkNotNullParameter(filter2, "filter");
        String string = filter2;
        return Constants.INSTANCE.getAll().contains(string) ? true : (Intrinsics.areEqual(string, this.getName()) ? true : (Intrinsics.areEqual(string, this.era()) ? true : this.getUniques().contains(filter2)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean uniqueIsRequirementForThisTech(@NotNull Unique unique) {
        Intrinsics.checkNotNullParameter(unique, "unique");
        if (unique.getType() != UniqueType.OnlyAvailable) return false;
        if (unique.getConditionals().size() != 1) return false;
        Unique it = unique.getConditionals().get(0);
        boolean bl = false;
        if (it.getType() != UniqueType.ConditionalTech) return false;
        if (!Intrinsics.areEqual(it.getParams().get(0), this.getName())) return false;
        return true;
    }

    public final boolean uniqueIsNotRequirementForThisTech(@NotNull Unique unique) {
        Intrinsics.checkNotNullParameter(unique, "unique");
        return !this.uniqueIsRequirementForThisTech(unique);
    }
}

