/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.unique;

import com.unciv.logic.GameInfo;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.stats.Stat;
import com.unciv.models.translations.TranslationsKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/unciv/models/ruleset/unique/Countables;", "", "()V", "getCountableAmount", "", "countable", "", "stateForConditionals", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "(Ljava/lang/String;Lcom/unciv/models/ruleset/unique/StateForConditionals;)Ljava/lang/Integer;", "core"})
@SourceDebugExtension(value={"SMAP\nCountables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Countables.kt\ncom/unciv/models/ruleset/unique/Countables\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n1774#2,4:43\n1268#3,3:47\n1268#3,3:51\n1#4:50\n*S KotlinDebug\n*F\n+ 1 Countables.kt\ncom/unciv/models/ruleset/unique/Countables\n*L\n26#1:43,4\n30#1:47,3\n34#1:51,3\n*E\n"})
public final class Countables {
    @NotNull
    public static final Countables INSTANCE = new Countables();

    private Countables() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Integer getCountableAmount(@NotNull String countable, @NotNull StateForConditionals stateForConditionals) {
        Stat relevantStat;
        Intrinsics.checkNotNullParameter(countable, "countable");
        Intrinsics.checkNotNullParameter(stateForConditionals, "stateForConditionals");
        if (StringsKt.toIntOrNull(countable) != null) {
            return Integer.parseInt(countable);
        }
        Stat stat = relevantStat = Stat.Companion.safeValueOf(countable);
        if (stat != null) {
            return stateForConditionals.getStatAmount(stat);
        }
        GameInfo gameInfo2 = stateForConditionals.getGameInfo();
        if (gameInfo2 == null) {
            return null;
        }
        GameInfo gameInfo3 = gameInfo2;
        if (Intrinsics.areEqual(countable, "turns")) {
            return gameInfo3.getTurns();
        }
        if (Intrinsics.areEqual(countable, "year")) {
            return gameInfo3.getYear(gameInfo3.getTurns());
        }
        Civilization civilization = stateForConditionals.getRelevantCiv();
        if (civilization == null) {
            return null;
        }
        Civilization civInfo = civilization;
        if (Intrinsics.areEqual(countable, "Cities")) {
            return civInfo.getCities().size();
        }
        List<String> placeholderParameters = TranslationsKt.getPlaceholderParameters(countable);
        if (TranslationsKt.equalsPlaceholderText(countable, "[] Cities")) {
            int n;
            Iterable $this$count$iv = civInfo.getCities();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    City it = (City)element$iv;
                    boolean bl = false;
                    if (!City.matchesFilter$default(it, placeholderParameters.get(0), null, 2, null) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            return n;
        }
        if (Intrinsics.areEqual(countable, "Units")) {
            return civInfo.getUnits().getCivUnitsSize();
        }
        if (TranslationsKt.equalsPlaceholderText(countable, "[] Units")) {
            Sequence<MapUnit> $this$count$iv = civInfo.getUnits().getCivUnits();
            boolean $i$f$count = false;
            int count$iv = 0;
            Iterator<MapUnit> iterator2 = $this$count$iv.iterator();
            while (iterator2.hasNext()) {
                MapUnit element$iv;
                MapUnit it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!it.matchesFilter(placeholderParameters.get(0)) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            return count$iv;
        }
        if (TranslationsKt.equalsPlaceholderText(countable, "[] Buildings")) {
            Iterable iterable = civInfo.getCities();
            int n = 0;
            for (Object t : iterable) {
                void $this$count$iv;
                void it;
                City element$iv = (City)t;
                int n2 = n;
                boolean bl = false;
                Sequence<Building> bl2 = it.getCityConstructions().getBuiltBuildings();
                boolean $i$f$count = false;
                int count$iv = 0;
                for (Object element$iv2 : $this$count$iv) {
                    Building it2 = (Building)element$iv2;
                    boolean bl3 = false;
                    if (!it2.matchesFilter(placeholderParameters.get(0)) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                int n3 = count$iv;
                n = n2 + n3;
            }
            return n;
        }
        if (gameInfo3.getRuleset().getTileResources().containsKey(countable)) {
            return stateForConditionals.getResourceAmount(countable);
        }
        return null;
    }
}

