/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.validation;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Json;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.UncivShowableException;
import com.unciv.models.ruleset.ModOptions;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.validation.RulesetError;
import com.unciv.models.ruleset.validation.RulesetErrorSeverity;
import com.unciv.models.ruleset.validation.RulesetValidator;
import com.unciv.models.ruleset.validation.Suppression;
import com.unciv.models.translations.TranslationsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J7\u0010\u0016\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u000e\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0004J\u0018\u0010\"\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/unciv/models/ruleset/validation/Suppression;", "", "()V", "deprecationWarningPattern", "", "minimumSelectivity", "", "parameterDocDescription", "parameterDocExample", "uniqueDocDescription", "untypedWarningPattern", "autoSuppressAllWarnings", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "toModOptions", "Lcom/unciv/models/ruleset/ModOptions;", "hasCommonSubstringLength", "", "x", "y", "minCommonLength", "isErrorSuppressed", "globalSuppressionFilters", "", "sourceObject", "Lcom/unciv/models/ruleset/unique/IHasUniques;", "sourceUnique", "Lcom/unciv/models/ruleset/unique/Unique;", "error", "Lcom/unciv/models/ruleset/validation/RulesetError;", "isErrorSuppressed$core", "isValidFilter", "parameterText", "matchesFilter", "filter", "core"})
@SourceDebugExtension(value={"SMAP\nSuppression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Suppression.kt\ncom/unciv/models/ruleset/validation/Suppression\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n766#2:127\n857#2,2:128\n1549#2:130\n1620#2,3:131\n*S KotlinDebug\n*F\n+ 1 Suppression.kt\ncom/unciv/models/ruleset/validation/Suppression\n*L\n92#1:127\n92#1:128,2\n92#1:130\n92#1:131,3\n*E\n"})
public final class Suppression {
    @NotNull
    public static final Suppression INSTANCE = new Suppression();
    private static final int minimumSelectivity = 12;
    @NotNull
    public static final String uniqueDocDescription = "Allows suppressing specific validation warnings. Errors, deprecation warnings, or warnings about untyped and non-filtering uniques should be heeded, not suppressed, and are therefore not accepted. Note that this can be used in ModOptions, in the uniques a warning is about, or as modifier on the unique triggering a warning - but you still need to be specific. Even in the modifier case you will need to specify a sufficiently selective portion of the warning text as parameter.";
    @NotNull
    public static final String parameterDocDescription = "Suppresses one specific Ruleset validation warning. This can specify the full text verbatim including correct upper/lower case, or it can be a wildcard case-insensitive simple pattern starting and ending in an asterisk ('*'). If the suppression unique is used within an object or as modifier (not ModOptions), the wildcard symbols can be omitted, as selectivity is better due to the limited scope.";
    @NotNull
    public static final String parameterDocExample = "Tinman is supposed to automatically upgrade at tech Clockwork, and therefore Servos for its upgrade Mecha may not yet be researched! -or- *is supposed to automatically upgrade*";
    @NotNull
    private static final String deprecationWarningPattern = "unique \"~\" is deprecated as of ~, replace with";
    @NotNull
    private static final String untypedWarningPattern = "unique \"~\" not found in Unciv's unique types, and is not used as a filtering unique";

    private Suppression() {
    }

    public final boolean isValidFilter(@NotNull String parameterText) {
        Intrinsics.checkNotNullParameter(parameterText, "parameterText");
        return StringsKt.contains$default((CharSequence)parameterText, '{', false, 2, null) || StringsKt.contains$default((CharSequence)parameterText, '<', false, 2, null) ? false : (this.hasCommonSubstringLength(parameterText, deprecationWarningPattern, 12) ? false : (this.hasCommonSubstringLength(parameterText, untypedWarningPattern, 12) ? false : (StringsKt.startsWith$default((CharSequence)parameterText, '*', false, 2, null) != StringsKt.endsWith$default((CharSequence)parameterText, '*', false, 2, null) ? false : parameterText.length() >= 14)));
    }

    private final boolean matchesFilter(RulesetError error2, String filter2) {
        if (Intrinsics.areEqual(error2.getText(), filter2)) {
            return true;
        }
        if (!StringsKt.endsWith$default((CharSequence)filter2, '*', false, 2, null) || !StringsKt.startsWith$default((CharSequence)filter2, '*', false, 2, null)) {
            return false;
        }
        return StringsKt.contains((CharSequence)error2.getText(), StringsKt.removeSurrounding(filter2, (CharSequence)"*", (CharSequence)"*"), true);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isErrorSuppressed$core(@NotNull Collection<String> globalSuppressionFilters2, @Nullable IHasUniques sourceObject, @Nullable Unique sourceUnique, @NotNull RulesetError error2) {
        Object object;
        Intrinsics.checkNotNullParameter(globalSuppressionFilters2, "globalSuppressionFilters");
        Intrinsics.checkNotNullParameter(error2, "error");
        if (error2.getErrorSeverityToReport().compareTo((Enum)RulesetErrorSeverity.Error) >= 0) {
            return false;
        }
        if (sourceObject == null && globalSuppressionFilters2.isEmpty()) {
            return false;
        }
        Sequence suppressions = CollectionsKt.asSequence((Iterable)globalSuppressionFilters2);
        if (sourceObject != null) {
            suppressions = SequencesKt.plus(suppressions, SequencesKt.map(sourceObject.getMatchingUniques(UniqueType.SuppressWarnings, StateForConditionals.Companion.getIgnoreConditionals()), isErrorSuppressed.1.INSTANCE));
        }
        if (sourceUnique != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Unique it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            object = sourceUnique.getConditionals();
            Sequence sequence = suppressions;
            boolean $i$f$filter = false;
            void var8_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Unique)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() == UniqueType.SuppressWarnings)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Unique)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Suppression.isErrorSuppressed$getWildcardFilter(it));
            }
            suppressions = SequencesKt.plus(sequence, (List)destination$iv$iv);
        }
        object = suppressions.iterator();
        while (object.hasNext()) {
            String filter2 = (String)object.next();
            if (!this.matchesFilter(error2, filter2)) continue;
            return true;
        }
        return false;
    }

    public final void autoSuppressAllWarnings(@NotNull Ruleset ruleset2, @NotNull ModOptions toModOptions) {
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        Intrinsics.checkNotNullParameter(toModOptions, "toModOptions");
        if (ruleset2.getFolderLocation() == null) {
            throw new UncivShowableException("autoSuppressAllWarnings needs Ruleset.folderLocation", null, 2, null);
        }
        for (RulesetError error2 : RulesetValidator.getErrorList$default(new RulesetValidator(ruleset2), false, 1, null)) {
            if (error2.getErrorSeverityToReport().compareTo((Enum)RulesetErrorSeverity.Error) >= 0) continue;
            Collection collection = toModOptions.getUniques();
            String[] stringArray = new String[]{error2.getText()};
            collection.add(TranslationsKt.fillPlaceholders(UniqueType.SuppressWarnings.getText(), stringArray));
        }
        Json json = UncivJsonKt.json();
        FileHandle fileHandle = ruleset2.getFolderLocation();
        Intrinsics.checkNotNull(fileHandle);
        json.toJson((Object)toModOptions, fileHandle.child("jsons/ModOptions.json"));
    }

    private final boolean hasCommonSubstringLength(String x, String y, int minCommonLength) {
        int n = x.length() - minCommonLength;
        for (int xIndex = 0; xIndex < n; ++xIndex) {
            Intrinsics.checkNotNullExpressionValue(x.substring(xIndex), "substring(...)");
            int n2 = y.length() - minCommonLength;
            for (int yIndex = 0; yIndex < n2; ++yIndex) {
                String xSub;
                CharSequence charSequence = xSub;
                String string = y.substring(yIndex);
                Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                if (StringsKt.commonPrefixWith(charSequence, string, true).length() < minCommonLength) continue;
                return true;
            }
        }
        return false;
    }

    private static final String isErrorSuppressed$getWildcardFilter(Unique unique) {
        String it = unique.getParams().get(0);
        boolean bl = false;
        return StringsKt.startsWith$default((CharSequence)it, '*', false, 2, null) ? it : '*' + it + '*';
    }

    public static final /* synthetic */ String access$isErrorSuppressed$getWildcardFilter(Unique unique) {
        return Suppression.isErrorSuppressed$getWildcardFilter(unique);
    }
}

