/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.skins;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.unciv.UncivGame;
import com.unciv.models.skins.SkinCache;
import com.unciv.models.skins.SkinConfig;
import com.unciv.ui.images.ImageGetter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00032\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\"J&\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020\u00032\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\"R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0011\u0010\u0016\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0011\u0010\u001a\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/unciv/models/skins/SkinStrings;", "", "skin", "", "(Ljava/lang/String;)V", "checkboxPressedShape", "getCheckboxPressedShape", "()Ljava/lang/String;", "checkboxShape", "getCheckboxShape", "rectangleWithOutlineShape", "getRectangleWithOutlineShape", "roundedEdgeRectangleMidBorderShape", "getRoundedEdgeRectangleMidBorderShape", "roundedEdgeRectangleMidShape", "getRoundedEdgeRectangleMidShape", "roundedEdgeRectangleShape", "getRoundedEdgeRectangleShape", "roundedEdgeRectangleSmallShape", "getRoundedEdgeRectangleSmallShape", "roundedTopEdgeRectangleSmallBorderShape", "getRoundedTopEdgeRectangleSmallBorderShape", "roundedTopEdgeRectangleSmallShape", "getRoundedTopEdgeRectangleSmallShape", "selectBoxPressedShape", "getSelectBoxPressedShape", "selectBoxShape", "getSelectBoxShape", "skinConfig", "Lcom/unciv/models/skins/SkinConfig;", "getSkinConfig", "()Lcom/unciv/models/skins/SkinConfig;", "skinLocation", "getUIColor", "Lcom/badlogic/gdx/graphics/Color;", "path", "default", "getUiBackground", "Lcom/badlogic/gdx/scenes/scene2d/utils/NinePatchDrawable;", "tintColor", "core"})
@SourceDebugExtension(value={"SMAP\nSkinStrings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkinStrings.kt\ncom/unciv/models/skins/SkinStrings\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class SkinStrings {
    @NotNull
    private final String skinLocation;
    @NotNull
    private final SkinConfig skinConfig;
    @NotNull
    private final String roundedEdgeRectangleSmallShape;
    @NotNull
    private final String roundedTopEdgeRectangleSmallShape;
    @NotNull
    private final String roundedTopEdgeRectangleSmallBorderShape;
    @NotNull
    private final String roundedEdgeRectangleMidShape;
    @NotNull
    private final String roundedEdgeRectangleMidBorderShape;
    @NotNull
    private final String roundedEdgeRectangleShape;
    @NotNull
    private final String rectangleWithOutlineShape;
    @NotNull
    private final String selectBoxShape;
    @NotNull
    private final String selectBoxPressedShape;
    @NotNull
    private final String checkboxShape;
    @NotNull
    private final String checkboxPressedShape;

    public SkinStrings(@NotNull String skin) {
        Intrinsics.checkNotNullParameter(skin, "skin");
        this.skinLocation = "Skins/" + skin + '/';
        SkinConfig skinConfig = (SkinConfig)SkinCache.INSTANCE.get((Object)skin);
        if (skinConfig == null) {
            skinConfig = new SkinConfig();
        }
        this.skinConfig = skinConfig;
        this.roundedEdgeRectangleSmallShape = this.skinLocation + "roundedEdgeRectangle-small";
        this.roundedTopEdgeRectangleSmallShape = this.skinLocation + "roundedTopEdgeRectangle-small";
        this.roundedTopEdgeRectangleSmallBorderShape = this.skinLocation + "roundedTopEdgeRectangle-small-border";
        this.roundedEdgeRectangleMidShape = this.skinLocation + "roundedEdgeRectangle-mid";
        this.roundedEdgeRectangleMidBorderShape = this.skinLocation + "roundedEdgeRectangle-mid-border";
        this.roundedEdgeRectangleShape = this.skinLocation + "roundedEdgeRectangle";
        this.rectangleWithOutlineShape = this.skinLocation + "rectangleWithOutline";
        this.selectBoxShape = this.skinLocation + "select-box";
        this.selectBoxPressedShape = this.skinLocation + "select-box-pressed";
        this.checkboxShape = this.skinLocation + "checkbox";
        this.checkboxPressedShape = this.skinLocation + "checkbox-pressed";
    }

    public /* synthetic */ SkinStrings(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = UncivGame.Companion.getCurrent().getSettings().getSkin();
        }
        this(string);
    }

    @NotNull
    public final SkinConfig getSkinConfig() {
        return this.skinConfig;
    }

    @NotNull
    public final String getRoundedEdgeRectangleSmallShape() {
        return this.roundedEdgeRectangleSmallShape;
    }

    @NotNull
    public final String getRoundedTopEdgeRectangleSmallShape() {
        return this.roundedTopEdgeRectangleSmallShape;
    }

    @NotNull
    public final String getRoundedTopEdgeRectangleSmallBorderShape() {
        return this.roundedTopEdgeRectangleSmallBorderShape;
    }

    @NotNull
    public final String getRoundedEdgeRectangleMidShape() {
        return this.roundedEdgeRectangleMidShape;
    }

    @NotNull
    public final String getRoundedEdgeRectangleMidBorderShape() {
        return this.roundedEdgeRectangleMidBorderShape;
    }

    @NotNull
    public final String getRoundedEdgeRectangleShape() {
        return this.roundedEdgeRectangleShape;
    }

    @NotNull
    public final String getRectangleWithOutlineShape() {
        return this.rectangleWithOutlineShape;
    }

    @NotNull
    public final String getSelectBoxShape() {
        return this.selectBoxShape;
    }

    @NotNull
    public final String getSelectBoxPressedShape() {
        return this.selectBoxPressedShape;
    }

    @NotNull
    public final String getCheckboxShape() {
        return this.checkboxShape;
    }

    @NotNull
    public final String getCheckboxPressedShape() {
        return this.checkboxPressedShape;
    }

    @NotNull
    public final NinePatchDrawable getUiBackground(@NotNull String path, @Nullable String string, @Nullable Color tintColor) {
        Object object;
        SkinConfig.SkinElement skinVariant;
        Intrinsics.checkNotNullParameter(path, "path");
        String locationByName = this.skinLocation + path;
        SkinConfig.SkinElement skinElement = skinVariant = this.skinConfig.getSkinVariants().get(path);
        String locationByConfigVariant = (skinElement != null ? skinElement.getImage() : null) != null ? this.skinLocation + skinVariant.getImage() : null;
        Object object2 = skinVariant;
        if (object2 == null || (object2 = ((SkinConfig.SkinElement)object2).getTint()) == null) {
            object2 = tintColor;
        }
        if (object2 != null) {
            Object $this$getUiBackground_u24lambda_u241 = object2;
            boolean bl = false;
            SkinConfig.SkinElement skinElement2 = skinVariant;
            if ((skinElement2 != null ? skinElement2.getAlpha() : null) == null) {
                object = $this$getUiBackground_u24lambda_u241;
            } else {
                Color color;
                Color $this$getUiBackground_u24lambda_u241_u24lambda_u240 = color = ((Color)$this$getUiBackground_u24lambda_u241).cpy();
                boolean bl2 = false;
                $this$getUiBackground_u24lambda_u241_u24lambda_u240.a = skinVariant.getAlpha().floatValue();
                object = color;
            }
        } else {
            object = null;
        }
        Object tint = object;
        String location = locationByConfigVariant != null && ImageGetter.INSTANCE.ninePatchImageExists(locationByConfigVariant) ? locationByConfigVariant : (ImageGetter.INSTANCE.ninePatchImageExists(locationByName) ? locationByName : string);
        return ImageGetter.INSTANCE.getNinePatch(location, (Color)tint);
    }

    public static /* synthetic */ NinePatchDrawable getUiBackground$default(SkinStrings skinStrings, String string, String string2, Color color, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            color = null;
        }
        return skinStrings.getUiBackground(string, string2, color);
    }

    @NotNull
    public final Color getUIColor(@NotNull String path, @Nullable Color color) {
        Intrinsics.checkNotNullParameter(path, "path");
        Object object = this.skinConfig.getSkinVariants().get(path);
        if ((object == null || (object = ((SkinConfig.SkinElement)object).getTint()) == null) && (object = color) == null) {
            object = this.skinConfig.getClearColor();
        }
        return object;
    }

    public static /* synthetic */ Color getUIColor$default(SkinStrings skinStrings, String string, Color color, int n, Object object) {
        if ((n & 2) != 0) {
            color = null;
        }
        return skinStrings.getUIColor(string, color);
    }

    public SkinStrings() {
        this(null, 1, null);
    }
}

