/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.audio;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.files.FileHandle;
import com.unciv.UncivGame;
import com.unciv.logic.multiplayer.storage.DropBox;
import com.unciv.models.metadata.GameSettings;
import com.unciv.ui.audio.MusicController;
import com.unciv.ui.audio.MusicTrackChooserFlags;
import com.unciv.ui.audio.MusicTrackController;
import com.unciv.utils.Concurrency;
import com.unciv.utils.Log;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.concurrent.TimersKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b'\u0018\u0000 j2\u00020\u0001:\u0003jklB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J(\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u00020\t2\f\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0002J*\u00103\u001a\u00020\u00172\b\b\u0002\u0010.\u001a\u00020\t2\b\b\u0002\u0010/\u001a\u00020\t2\u000e\b\u0002\u00100\u001a\b\u0012\u0004\u0012\u00020201J.\u00103\u001a\u00020\u00172\b\b\u0002\u0010.\u001a\u00020\t2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\t052\u000e\b\u0002\u00100\u001a\b\u0012\u0004\u0012\u00020201J\b\u00106\u001a\u00020\u0014H\u0002J\b\u00107\u001a\u00020\u0014H\u0002J\b\u00108\u001a\u00020\u0014H\u0002J\b\u00109\u001a\u00020\tH\u0002J\u0006\u0010:\u001a\u00020\u0014J\u0010\u0010;\u001a\u00020\u00142\b\b\u0002\u0010<\u001a\u00020\u0004J\b\u0010=\u001a\u00020\u0014H\u0002J\u0010\u0010=\u001a\u00020\u00142\u0006\u0010>\u001a\u00020\u0013H\u0002J\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00130@J\u0016\u0010A\u001a\u0010\u0012\f\u0012\n B*\u0004\u0018\u00010-0-0@H\u0002J\u0018\u0010C\u001a\u0014\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00140DJ\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00140FJ\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00130@J&\u0010H\u001a\u0010\u0012\f\u0012\n B*\u0004\u0018\u00010-0-0@2\u0006\u0010I\u001a\u00020\t2\u0006\u0010J\u001a\u00020\tH\u0002J(\u0010K\u001a\b\u0012\u0004\u0012\u00020-0@2\b\b\u0002\u0010I\u001a\u00020\t2\u000e\b\u0002\u0010L\u001a\b\u0012\u0004\u0012\u00020-0FH\u0002J\u0006\u0010M\u001a\u00020\u0014J\u0006\u0010N\u001a\u00020\u0017J\u0006\u0010O\u001a\u00020\u0017J\u0006\u0010P\u001a\u00020\u0017J\u0006\u0010Q\u001a\u00020\u0017J\b\u0010R\u001a\u00020\u0014H\u0002J\u001c\u0010S\u001a\u00020\u00142\u0014\u0010T\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012J\u0010\u0010U\u001a\u00020\u00142\b\b\u0002\u0010V\u001a\u00020\u0004J\b\u0010W\u001a\u00020\u0014H\u0002J&\u0010X\u001a\u00020\u00142\u0006\u0010Y\u001a\u00020-2\u0006\u0010Z\u001a\u00020\u00042\u0006\u0010[\u001a\u00020\u00172\u0006\u0010\\\u001a\u00020\u0017J6\u0010X\u001a\u00020\u00142\u0006\u0010J\u001a\u00020\t2\b\b\u0002\u0010I\u001a\u00020\t2\b\b\u0002\u0010Z\u001a\u00020\u00042\b\b\u0002\u0010[\u001a\u00020\u00172\b\b\u0002\u0010\\\u001a\u00020\u0017J\u000e\u0010]\u001a\u00020\u00142\u0006\u0010J\u001a\u00020\tJ\u0010\u0010^\u001a\u00020\u00142\b\b\u0002\u0010V\u001a\u00020\u0004J\b\u0010_\u001a\u00020\u0014H\u0002J\u001e\u0010`\u001a\u00020\u00142\u0016\u0010a\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nJ\u000e\u0010b\u001a\u00020\u00142\u0006\u0010Z\u001a\u00020\u0004J\b\u0010c\u001a\u00020\u0014H\u0002J\b\u0010d\u001a\u00020\u0014H\u0002J \u0010e\u001a\u00020\u00172\u0006\u0010f\u001a\u00020-2\u000e\b\u0002\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0002J\u000e\u0010e\u001a\u00020\u00172\u0006\u0010>\u001a\u00020\u0013J\u0006\u0010g\u001a\u00020\u0014J\b\u0010h\u001a\u00020\u0014H\u0002J\f\u0010i\u001a\u00020\u0014*\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR$\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006m"}, d2={"Lcom/unciv/ui/audio/MusicController;", "", "()V", "baseVolume", "", "current", "Lcom/unciv/ui/audio/MusicTrackController;", "mods", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "musicHistory", "Lkotlin/collections/ArrayDeque;", "musicTimer", "Ljava/util/Timer;", "next", "onTrackChangeListeners", "", "Lkotlin/Function1;", "Lcom/unciv/ui/audio/MusicController$MusicTrackInfo;", "", "overlay", "overlayPausing", "", "settings", "Lcom/unciv/models/metadata/GameSettings;", "getSettings", "()Lcom/unciv/models/metadata/GameSettings;", "value", "silenceLength", "getSilenceLength", "()F", "setSilenceLength", "(F)V", "silenceLengthInTicks", "", "state", "Lcom/unciv/ui/audio/MusicController$ControllerState;", "ticksOfSilence", "audioExceptionHandler", "ex", "", "music", "Lcom/badlogic/gdx/audio/Music;", "chooseFile", "Lcom/badlogic/gdx/files/FileHandle;", "prefix", "suffix", "flags", "Ljava/util/EnumSet;", "Lcom/unciv/ui/audio/MusicTrackChooserFlags;", "chooseTrack", "suffixes", "", "clearCurrent", "clearNext", "clearOverlay", "currentlyPlaying", "downloadDefaultFile", "fadeoutToSilence", "duration", "fireOnChange", "trackInfo", "getAllMusicFileInfo", "Lkotlin/sequences/Sequence;", "getAllMusicFiles", "kotlin.jvm.PlatformType", "getAudioExceptionHandler", "Lkotlin/Function2;", "getAudioLoopCallback", "Lkotlin/Function0;", "getHistory", "getMatchingFiles", "folder", "name", "getMusicFolders", "getDefault", "gracefulShutdown", "isDefaultFileAvailable", "isMusicAvailable", "isPlaying", "isVoicesAvailable", "musicTimerTask", "onChange", "listener", "pause", "speedFactor", "pauseOverlay", "playOverlay", "file", "volume", "isLooping", "fadeIn", "playVoice", "resume", "resumeOverlay", "setModList", "newMods", "setVolume", "shutdown", "startTimer", "startTrack", "musicFile", "stopOverlay", "stopTimer", "overlayTick", "Companion", "ControllerState", "MusicTrackInfo", "core"})
public final class MusicController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float baseVolume;
    private int silenceLengthInTicks;
    @NotNull
    private HashSet<String> mods;
    @NotNull
    private ControllerState state;
    private int ticksOfSilence;
    @Nullable
    private Timer musicTimer;
    @Nullable
    private MusicTrackController current;
    @Nullable
    private MusicTrackController next;
    @Nullable
    private MusicTrackController overlay;
    private boolean overlayPausing;
    @NotNull
    private final ArrayDeque<String> musicHistory;
    @NotNull
    private List<Function1<MusicTrackInfo, Unit>> onTrackChangeListeners;
    @NotNull
    private static final Files.FileType musicLocation = Files.FileType.Local;
    @NotNull
    private static final String musicPath = "music";
    @NotNull
    private static final String modPath = "mods";
    @NotNull
    private static final String musicFallbackLocation = "/music/thatched-villagers.mp3";
    @NotNull
    private static final String musicFallbackLocalName = "music/Thatched Villagers - Ambient.mp3";
    private static final float maxVolume = 0.6f;
    private static final float ticksPerSecondGdx = 58.3f;
    private static final float ticksPerSecondOwn = 20.0f;
    private static final float defaultFadeDuration = 0.9f;
    private static final float defaultFadingStepGdx = 0.01905851f;
    private static final float defaultFadingStepOwn = 0.055555556f;
    private static final int musicHistorySize = 8;
    @NotNull
    private static final List<String> gdxSupportedFileExtensions;
    private static boolean needOwnTimer;
    private static float ticksPerSecond;
    private static float defaultFadingStep;

    public MusicController() {
        FileHandle newFallbackFile;
        FileHandle oldFallbackFile = Gdx.files.local(StringsKt.removePrefix(musicFallbackLocation, (CharSequence)"/"));
        if (oldFallbackFile.exists() && !(newFallbackFile = Gdx.files.local(musicFallbackLocalName)).exists()) {
            oldFallbackFile.moveTo(newFallbackFile);
        }
        this.baseVolume = this.getSettings().getMusicVolume();
        this.silenceLengthInTicks = MathKt.roundToInt((float)this.getSettings().getPauseBetweenTracks() * ticksPerSecond);
        this.mods = new HashSet();
        this.state = ControllerState.Idle;
        this.musicHistory = new ArrayDeque(8);
        this.onTrackChangeListeners = new ArrayList();
    }

    public final float getSilenceLength() {
        return (float)this.silenceLengthInTicks / ticksPerSecond;
    }

    public final void setSilenceLength(float value) {
        this.silenceLengthInTicks = (int)(ticksPerSecond * value);
    }

    @NotNull
    public final Function0<Unit> getAudioLoopCallback() {
        needOwnTimer = false;
        ticksPerSecond = 58.3f;
        defaultFadingStep = 0.01905851f;
        return new Function0<Unit>(this){
            final /* synthetic */ MusicController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                MusicController.access$musicTimerTask(this.this$0);
            }
        };
    }

    @NotNull
    public final Function2<Throwable, Music, Unit> getAudioExceptionHandler() {
        return new Function2<Throwable, Music, Unit>(this){
            final /* synthetic */ MusicController this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull Throwable ex, @NotNull Music music) {
                Intrinsics.checkNotNullParameter(ex, "ex");
                Intrinsics.checkNotNullParameter(music, "music");
                MusicController.access$audioExceptionHandler(this.this$0, ex, music);
            }
        };
    }

    private final String currentlyPlaying() {
        String string;
        if (this.state.getShowTrack()) {
            string = this.musicHistory.lastOrNull();
            if (string == null) {
                string = "";
            }
        } else {
            string = "";
        }
        return string;
    }

    public final void onChange(@Nullable Function1<? super MusicTrackInfo, Unit> listener) {
        if (listener == null) {
            this.onTrackChangeListeners.clear();
        } else {
            this.onTrackChangeListeners.add(listener);
        }
        this.fireOnChange();
    }

    public final boolean isMusicAvailable() {
        return SequencesKt.any(this.getAllMusicFiles());
    }

    public final boolean isPlaying() {
        MusicTrackController musicTrackController = this.current;
        return musicTrackController != null ? musicTrackController.isPlaying() : false;
    }

    @NotNull
    public final Sequence<MusicTrackInfo> getHistory() {
        return SequencesKt.map(CollectionsKt.asSequence((Iterable)this.musicHistory), getHistory.1.INSTANCE);
    }

    @NotNull
    public final Sequence<MusicTrackInfo> getAllMusicFileInfo() {
        return SequencesKt.map(this.getAllMusicFiles(), getAllMusicFileInfo.1.INSTANCE);
    }

    private final GameSettings getSettings() {
        return UncivGame.Companion.getCurrent().getSettings();
    }

    private final void clearCurrent() {
        MusicTrackController musicTrackController = this.current;
        if (musicTrackController != null) {
            musicTrackController.clear();
        }
        this.current = null;
    }

    private final void clearNext() {
        MusicTrackController musicTrackController = this.next;
        if (musicTrackController != null) {
            musicTrackController.clear();
        }
        this.next = null;
    }

    private final void startTimer() {
        Timer timer2;
        if (!needOwnTimer || this.musicTimer != null) {
            return;
        }
        long timerPeriod = MathKt.roundToInt(1000.0f / ticksPerSecond);
        String string = "MusicTimer";
        boolean bl = true;
        long l = 0L;
        Timer timer3 = timer2 = TimersKt.timer(string, bl);
        timer3.schedule(new TimerTask(this){
            final /* synthetic */ MusicController this$0;
            {
                this.this$0 = musicController;
            }

            public void run() {
                TimerTask $this$startTimer_u24lambda_u240 = this;
                boolean bl = false;
                MusicController.access$musicTimerTask(this.this$0);
            }
        }, l, timerPeriod);
        this.musicTimer = timer2;
    }

    private final void stopTimer() {
        if (this.musicTimer == null) {
            return;
        }
        Timer timer2 = this.musicTimer;
        if (timer2 != null) {
            timer2.cancel();
        }
        this.musicTimer = null;
    }

    private final void musicTimerTask() {
        MusicTrackController musicTrackController = this.overlay;
        if (musicTrackController != null) {
            this.overlayTick(musicTrackController);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                return;
            }
            case 2: 
            case 3: {
                if (this.current == null) {
                    if (this.next == null) {
                        this.ticksOfSilence = 0;
                        this.state = this.state == ControllerState.PlaySingle ? ControllerState.Shutdown : ControllerState.Silence;
                        this.fireOnChange();
                        break;
                    }
                    MusicTrackController musicTrackController2 = this.next;
                    Intrinsics.checkNotNull(musicTrackController2);
                    if (!musicTrackController2.getState().getCanPlay()) break;
                    this.current = this.next;
                    this.next = null;
                    MusicTrackController musicTrackController3 = this.current;
                    Intrinsics.checkNotNull(musicTrackController3);
                    if (!musicTrackController3.play()) {
                        this.ticksOfSilence = -this.silenceLengthInTicks - 1000;
                        this.state = ControllerState.Silence;
                        break;
                    }
                    this.fireOnChange();
                    break;
                }
                MusicTrackController musicTrackController4 = this.current;
                Intrinsics.checkNotNull(musicTrackController4);
                if (!musicTrackController4.isPlaying()) {
                    this.clearCurrent();
                    break;
                }
                MusicTrackController musicTrackController5 = this.current;
                if ((musicTrackController5 != null ? musicTrackController5.timerTick() : null) == MusicTrackController.State.Idle) {
                    this.clearCurrent();
                }
                MusicTrackController musicTrackController6 = this.next;
                if (musicTrackController6 != null) {
                    musicTrackController6.timerTick();
                }
                break;
            }
            case 4: {
                ++this.ticksOfSilence;
                if (this.ticksOfSilence <= this.silenceLengthInTicks) break;
                this.ticksOfSilence = 0;
                MusicController.chooseTrack$default(this, null, null, null, 7, null);
                break;
            }
            case 5: {
                MusicTrackController musicTrackController7 = this.current;
                if (musicTrackController7 != null ? !musicTrackController7.shutdownTick() : false) break;
                MusicTrackController musicTrackController8 = this.next;
                if (musicTrackController8 != null ? !musicTrackController8.shutdownTick() : false) break;
                this.state = ControllerState.Cleanup;
                break;
            }
            case 6: {
                this.shutdown();
                break;
            }
            case 7: {
                MusicTrackController musicTrackController9 = this.current;
                if (musicTrackController9 == null) break;
                musicTrackController9.timerTick();
                break;
            }
        }
    }

    private final void shutdown() {
        this.state = ControllerState.Idle;
        this.fireOnChange();
        this.stopTimer();
        this.clearNext();
        this.clearCurrent();
        this.clearOverlay();
        this.musicHistory.clear();
        Log.INSTANCE.debug("MusicController shut down.", new Object[0]);
    }

    private final void audioExceptionHandler(Throwable ex, Music music) {
        music.dispose();
        MusicTrackController musicTrackController = this.next;
        if (Intrinsics.areEqual(music, musicTrackController != null ? musicTrackController.getMusic() : null)) {
            this.clearNext();
        }
        MusicTrackController musicTrackController2 = this.current;
        if (Intrinsics.areEqual(music, musicTrackController2 != null ? musicTrackController2.getMusic() : null)) {
            this.clearCurrent();
        }
        MusicTrackController musicTrackController3 = this.overlay;
        if (Intrinsics.areEqual(music, musicTrackController3 != null ? musicTrackController3.getMusic() : null)) {
            this.clearOverlay();
        }
        Log.INSTANCE.error("Error playing music", ex);
        ThreadsKt.thread$default(false, true, null, null, 0, new Function0<Unit>(this){
            final /* synthetic */ MusicController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Thread.sleep(2000L);
                Gdx.app.postRunnable(() -> audioExceptionHandler.1.invoke$lambda$0(this.this$0));
            }

            private static final void invoke$lambda$0(MusicController this$0) {
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                MusicController.chooseTrack$default(this$0, null, null, null, 7, null);
            }
        }, 29, null);
    }

    private final Sequence<FileHandle> getMusicFolders(String folder, Function0<? extends FileHandle> getDefault) {
        return SequencesKt.filter(SequencesKt.sequence((Function2)new Function2<SequenceScope<? super FileHandle>, Continuation<? super Unit>, Object>(this, getDefault, folder, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MusicController this$0;
            final /* synthetic */ Function0<FileHandle> $getDefault;
            final /* synthetic */ String $folder;
            {
                this.this$0 = $receiver;
                this.$getDefault = $getDefault;
                this.$folder = $folder;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v0 = $this$sequence.yieldAll(SequencesKt.map(CollectionsKt.asSequence((Iterable)SetsKt.plus((Set)MusicController.access$getSettings(this.this$0).getVisualMods(), MusicController.access$getMods$p(this.this$0))), (Function1)new Function1<String, FileHandle>(this.$folder){
                            final /* synthetic */ String $folder;
                            {
                                this.$folder = $folder;
                                super(1);
                            }

                            public final FileHandle invoke(@NotNull String it) {
                                Intrinsics.checkNotNullParameter(it, "it");
                                return com.unciv.ui.audio.MusicController$Companion.access$getFile(MusicController.Companion, "mods").child(it).child(this.$folder);
                            }
                        }), (Continuation<Unit>)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 2;
                        v1 = $this$sequence.yield(this.$getDefault.invoke(), this);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl25
                    }
                    case 2: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl25:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super FileHandle>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super FileHandle> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), getMusicFolders.3.INSTANCE);
    }

    static /* synthetic */ Sequence getMusicFolders$default(MusicController musicController, String string, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            string = musicPath;
        }
        if ((n & 2) != 0) {
            function0 = new Function0<FileHandle>(string){
                final /* synthetic */ String $folder;
                {
                    this.$folder = $folder;
                    super(0);
                }

                public final FileHandle invoke() {
                    FileHandle fileHandle = com.unciv.ui.audio.MusicController$Companion.access$getFile(MusicController.Companion, this.$folder);
                    Intrinsics.checkNotNullExpressionValue(fileHandle, "access$getFile(...)");
                    return fileHandle;
                }
            };
        }
        return musicController.getMusicFolders(string, function0);
    }

    private final Sequence<FileHandle> getAllMusicFiles() {
        return SequencesKt.filter(SequencesKt.flatMap(MusicController.getMusicFolders$default(this, null, null, 3, null), getAllMusicFiles.1.INSTANCE), getAllMusicFiles.2.INSTANCE);
    }

    private final FileHandle chooseFile(String prefix2, String suffix, EnumSet<MusicTrackChooserFlags> flags) {
        FileHandle defaultFile;
        if (flags.contains((Object)MusicTrackChooserFlags.PlayDefaultFile) && (defaultFile = MusicController.Companion.getFile(musicFallbackLocalName)).exists()) {
            return defaultFile;
        }
        boolean prefixMustMatch = flags.contains((Object)MusicTrackChooserFlags.PrefixMustMatch);
        boolean suffixMustMatch = flags.contains((Object)MusicTrackChooserFlags.SuffixMustMatch);
        Function1[] function1Array = new Function1[]{new Function1<FileHandle, Comparable<?>>(prefix2){
            final /* synthetic */ String $prefix;
            {
                this.$prefix = $prefix;
                super(1);
            }

            @Nullable
            public final Comparable<?> invoke(FileHandle it) {
                String string = it.nameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue(string, "nameWithoutExtension(...)");
                return StringsKt.startsWith$default(string, this.$prefix, false, 2, null) ? (Comparable)Integer.valueOf(0) : (Comparable)Integer.valueOf(1);
            }
        }, new Function1<FileHandle, Comparable<?>>(suffix){
            final /* synthetic */ String $suffix;
            {
                this.$suffix = $suffix;
                super(1);
            }

            @Nullable
            public final Comparable<?> invoke(FileHandle it) {
                String string = it.nameWithoutExtension();
                Intrinsics.checkNotNullExpressionValue(string, "nameWithoutExtension(...)");
                return StringsKt.endsWith$default(string, this.$suffix, false, 2, null) ? (Comparable)Integer.valueOf(0) : (Comparable)Integer.valueOf(1);
            }
        }, new Function1<FileHandle, Comparable<?>>(this){
            final /* synthetic */ MusicController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Comparable<?> invoke(FileHandle it) {
                return MusicController.access$getMusicHistory$p(this.this$0).contains(it.path()) ? (Comparable)Integer.valueOf(1) : (Comparable)Integer.valueOf(0);
            }
        }};
        return SequencesKt.firstOrNull(SequencesKt.sortedWith(SequencesKt.shuffled(SequencesKt.filter(this.getAllMusicFiles(), (Function1)new Function1<FileHandle, Boolean>(prefixMustMatch, prefix2, suffixMustMatch, suffix){
            final /* synthetic */ boolean $prefixMustMatch;
            final /* synthetic */ String $prefix;
            final /* synthetic */ boolean $suffixMustMatch;
            final /* synthetic */ String $suffix;
            {
                this.$prefixMustMatch = $prefixMustMatch;
                this.$prefix = $prefix;
                this.$suffixMustMatch = $suffixMustMatch;
                this.$suffix = $suffix;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(FileHandle it) {
                boolean bl;
                block3: {
                    block4: {
                        block2: {
                            if (!this.$prefixMustMatch) break block2;
                            String string = it.nameWithoutExtension();
                            Intrinsics.checkNotNullExpressionValue(string, "nameWithoutExtension(...)");
                            if (!StringsKt.startsWith$default(string, this.$prefix, false, 2, null)) break block3;
                        }
                        if (!this.$suffixMustMatch) break block4;
                        String string = it.nameWithoutExtension();
                        Intrinsics.checkNotNullExpressionValue(string, "nameWithoutExtension(...)");
                        if (!StringsKt.endsWith$default(string, this.$suffix, false, 2, null)) break block3;
                    }
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
        })), ComparisonsKt.compareBy(function1Array)));
    }

    private final void fireOnChange() {
        if (this.onTrackChangeListeners.isEmpty()) {
            return;
        }
        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ MusicController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        MusicController.access$fireOnChange(this.this$0, MusicTrackInfo.Companion.parse(MusicController.access$currentlyPlaying(this.this$0)));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    private final void fireOnChange(MusicTrackInfo trackInfo) {
        try {
            for (Function1<MusicTrackInfo, Unit> listener : this.onTrackChangeListeners) {
                listener.invoke(trackInfo);
            }
        }
        catch (Throwable ex) {
            Log.INSTANCE.debug("onTrackChange event invoke failed", ex);
            this.onTrackChangeListeners.clear();
        }
    }

    public final void setModList(@NotNull HashSet<String> newMods) {
        Intrinsics.checkNotNullParameter(newMods, "newMods");
        this.mods = newMods;
    }

    public final boolean chooseTrack(@NotNull String prefix2, @NotNull String suffix, @NotNull EnumSet<MusicTrackChooserFlags> flags) {
        Intrinsics.checkNotNullParameter(prefix2, "prefix");
        Intrinsics.checkNotNullParameter(suffix, "suffix");
        Intrinsics.checkNotNullParameter(flags, "flags");
        if (this.baseVolume == 0.0f) {
            return false;
        }
        FileHandle musicFile = this.chooseFile(prefix2, suffix, flags);
        if (musicFile == null) {
            Object[] objectArray = new Object[]{prefix2, suffix, flags};
            Log.INSTANCE.debug("No music found for prefix=%s, suffix=%s, flags=%s", objectArray);
            return false;
        }
        Object[] objectArray = new Object[]{musicFile.path(), prefix2, suffix, flags};
        Log.INSTANCE.debug("Track chosen: %s for prefix=%s, suffix=%s, flags=%s", objectArray);
        return this.startTrack(musicFile, flags);
    }

    public static /* synthetic */ boolean chooseTrack$default(MusicController musicController, String string, String string2, EnumSet enumSet, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "Ambient";
        }
        if ((n & 4) != 0) {
            enumSet = MusicTrackChooserFlags.Companion.getDefault();
        }
        return musicController.chooseTrack(string, string2, enumSet);
    }

    private final boolean startTrack(FileHandle musicFile, EnumSet<MusicTrackChooserFlags> flags) {
        if (Intrinsics.areEqual(musicFile.path(), this.currentlyPlaying())) {
            return true;
        }
        if (!musicFile.exists()) {
            return false;
        }
        MusicTrackController musicTrackController = this.next;
        if (musicTrackController != null) {
            musicTrackController.clear();
        }
        MusicTrackController musicTrackController2 = this.next = new MusicTrackController(this.baseVolume * 0.6f, 0.0f, 2, null);
        Intrinsics.checkNotNull(musicTrackController2);
        musicTrackController2.load(musicFile, (Function1<? super MusicTrackController, Unit>)new Function1<MusicTrackController, Unit>(this){
            final /* synthetic */ MusicController this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MusicTrackController it) {
                Intrinsics.checkNotNullParameter(it, "it");
                MusicController.access$setTicksOfSilence$p(this.this$0, 0);
                MusicController.access$setState$p(this.this$0, ControllerState.Silence);
                MusicController.access$setNext$p(this.this$0, null);
            }
        }, (Function1<? super MusicTrackController, Unit>)new Function1<MusicTrackController, Unit>(musicFile, this, flags){
            final /* synthetic */ FileHandle $musicFile;
            final /* synthetic */ MusicController this$0;
            final /* synthetic */ EnumSet<MusicTrackChooserFlags> $flags;
            {
                this.$musicFile = $musicFile;
                this.this$0 = $receiver;
                this.$flags = $flags;
                super(1);
            }

            public final void invoke(@NotNull MusicTrackController it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Object[] objectArray = new Object[]{this.$musicFile.path()};
                Log.INSTANCE.debug("Music queued: %s", objectArray);
                if (MusicController.access$getMusicHistory$p(this.this$0).size() >= 8) {
                    MusicController.access$getMusicHistory$p(this.this$0).removeFirst();
                }
                ArrayDeque arrayDeque = MusicController.access$getMusicHistory$p(this.this$0);
                String string = this.$musicFile.path();
                Intrinsics.checkNotNullExpressionValue(string, "path(...)");
                arrayDeque.addLast(string);
                it.play();
                float fadingStep = MusicController.Companion.getDefaultFadingStep$core() / (float)(this.$flags.contains((Object)((Object)MusicTrackChooserFlags.SlowFade)) ? 5 : 1);
                it.startFade(MusicTrackController.State.FadeIn, fadingStep);
                switch (startTrack.WhenMappings.$EnumSwitchMapping$0[MusicController.access$getState$p(this.this$0).ordinal()]) {
                    case 1: 
                    case 2: {
                        MusicTrackController musicTrackController = MusicController.access$getCurrent$p(this.this$0);
                        if (musicTrackController != null) {
                            musicTrackController.startFade(MusicTrackController.State.FadeOut, fadingStep);
                        }
                        break;
                    }
                    case 3: {
                        MusicTrackController musicTrackController = MusicController.access$getCurrent$p(this.this$0);
                        if ((musicTrackController != null ? musicTrackController.getState() : null) != MusicTrackController.State.Idle) break;
                        MusicController.access$clearCurrent(this.this$0);
                        break;
                    }
                }
            }
        });
        this.state = flags.contains((Object)MusicTrackChooserFlags.PlaySingle) ? ControllerState.PlaySingle : ControllerState.Playing;
        this.startTimer();
        return true;
    }

    static /* synthetic */ boolean startTrack$default(MusicController musicController, FileHandle fileHandle, EnumSet enumSet, int n, Object object) {
        if ((n & 2) != 0) {
            enumSet = MusicTrackChooserFlags.Companion.getDefault();
        }
        return musicController.startTrack(fileHandle, enumSet);
    }

    public final boolean chooseTrack(@NotNull String prefix2, @NotNull List<String> suffixes, @NotNull EnumSet<MusicTrackChooserFlags> flags) {
        Intrinsics.checkNotNullParameter(prefix2, "prefix");
        Intrinsics.checkNotNullParameter(suffixes, "suffixes");
        Intrinsics.checkNotNullParameter(flags, "flags");
        for (String suffix : suffixes) {
            if (!this.chooseTrack(prefix2, suffix, flags)) continue;
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean chooseTrack$default(MusicController musicController, String string, List list2, EnumSet enumSet, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            enumSet = MusicTrackChooserFlags.Companion.getNone();
        }
        return musicController.chooseTrack(string, list2, enumSet);
    }

    public final boolean startTrack(@NotNull MusicTrackInfo trackInfo) {
        Intrinsics.checkNotNullParameter(trackInfo, "trackInfo");
        if (((CharSequence)trackInfo.getTrack()).length() == 0) {
            return false;
        }
        MusicTrackInfo $this$startTrack_u24lambda_u241 = trackInfo;
        boolean bl = false;
        String path = ((CharSequence)$this$startTrack_u24lambda_u241.getMod()).length() == 0 ? "music/" + $this$startTrack_u24lambda_u241.getTrack() + '.' + $this$startTrack_u24lambda_u241.getType() : "mods/" + $this$startTrack_u24lambda_u241.getMod() + "/music/" + $this$startTrack_u24lambda_u241.getTrack() + '.' + $this$startTrack_u24lambda_u241.getType();
        FileHandle fileHandle = MusicController.Companion.getFile(path);
        Intrinsics.checkNotNullExpressionValue(fileHandle, "access$getFile(...)");
        return MusicController.startTrack$default(this, fileHandle, null, 2, null);
    }

    public final void pause(float speedFactor) {
        Log.INSTANCE.debug("MusicTrackController.pause called", new Object[0]);
        if (!this.state.getCanPause()) {
            return;
        }
        this.state = ControllerState.Pause;
        float fadingStep = defaultFadingStep * ((Number)RangesKt.coerceIn((Comparable)Float.valueOf(speedFactor), RangesKt.rangeTo(0.001f, 1000.0f))).floatValue();
        MusicTrackController musicTrackController = this.current;
        if (musicTrackController != null) {
            musicTrackController.startFade(MusicTrackController.State.FadeOut, fadingStep);
        }
        MusicTrackController musicTrackController2 = this.next;
        if ((musicTrackController2 != null ? musicTrackController2.getState() : null) == MusicTrackController.State.FadeIn) {
            MusicTrackController musicTrackController3 = this.next;
            Intrinsics.checkNotNull(musicTrackController3);
            MusicTrackController.startFade$default(musicTrackController3, MusicTrackController.State.FadeOut, 0.0f, 2, null);
        }
        this.pauseOverlay();
    }

    public static /* synthetic */ void pause$default(MusicController musicController, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        musicController.pause(f);
    }

    public final void resume(float speedFactor) {
        Log.INSTANCE.debug("MusicTrackController.resume called", new Object[0]);
        if (this.state == ControllerState.Pause && this.current != null) {
            float fadingStep = defaultFadingStep * ((Number)RangesKt.coerceIn((Comparable)Float.valueOf(speedFactor), RangesKt.rangeTo(0.001f, 1000.0f))).floatValue();
            MusicTrackController musicTrackController = this.current;
            Intrinsics.checkNotNull(musicTrackController);
            musicTrackController.startFade(MusicTrackController.State.FadeIn, fadingStep);
            this.state = ControllerState.Playing;
            MusicTrackController musicTrackController2 = this.current;
            Intrinsics.checkNotNull(musicTrackController2);
            musicTrackController2.play();
        } else if (this.state == ControllerState.Cleanup || this.state == ControllerState.Pause) {
            MusicController.chooseTrack$default(this, null, null, null, 7, null);
        }
        this.resumeOverlay();
    }

    public static /* synthetic */ void resume$default(MusicController musicController, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        musicController.resume(f);
    }

    public final void fadeoutToSilence(float duration) {
        float fadingStep = 1.0f / ticksPerSecond / duration;
        MusicTrackController musicTrackController = this.current;
        if (musicTrackController != null) {
            musicTrackController.startFade(MusicTrackController.State.FadeOut, fadingStep);
        }
        MusicTrackController musicTrackController2 = this.next;
        if (musicTrackController2 != null) {
            musicTrackController2.startFade(MusicTrackController.State.FadeOut, fadingStep);
        }
        MusicTrackController musicTrackController3 = this.overlay;
        if (musicTrackController3 != null) {
            musicTrackController3.startFade(MusicTrackController.State.FadeOut, fadingStep);
        }
        this.state = ControllerState.Shutdown;
    }

    public static /* synthetic */ void fadeoutToSilence$default(MusicController musicController, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 4.5f;
        }
        musicController.fadeoutToSilence(f);
    }

    public final void setVolume(float volume) {
        this.baseVolume = volume;
        if ((double)volume < 0.01) {
            this.shutdown();
        } else if (this.isPlaying()) {
            MusicTrackController musicTrackController = this.current;
            Intrinsics.checkNotNull(musicTrackController);
            musicTrackController.setVolume(this.baseVolume * 0.6f);
        }
    }

    public final void gracefulShutdown() {
        if (this.state == ControllerState.Cleanup) {
            this.shutdown();
        } else {
            this.fadeoutToSilence(0.9f);
        }
    }

    public final void downloadDefaultFile() {
        InputStream file = DropBox.INSTANCE.downloadFile(musicFallbackLocation);
        MusicController.Companion.getFile(musicFallbackLocalName).write(file, false);
    }

    public final boolean isDefaultFileAvailable() {
        return MusicController.Companion.getFile(musicFallbackLocalName).exists();
    }

    private final Sequence<FileHandle> getMatchingFiles(String folder, String name2) {
        return SequencesKt.flatMap(this.getMusicFolders(folder, (Function0<? extends FileHandle>)new Function0<FileHandle>(folder){
            final /* synthetic */ String $folder;
            {
                this.$folder = $folder;
                super(0);
            }

            @NotNull
            public final FileHandle invoke() {
                FileHandle fileHandle = Gdx.files.internal(this.$folder);
                Intrinsics.checkNotNullExpressionValue(fileHandle, "internal(...)");
                return fileHandle;
            }
        }), (Function1)new Function1<FileHandle, Sequence<? extends FileHandle>>(name2){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            @NotNull
            public final Sequence<FileHandle> invoke(@NotNull FileHandle it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return SequencesKt.filter(SequencesKt.map(CollectionsKt.asSequence((Iterable)MusicController.Companion.getGdxSupportedFileExtensions()), (Function1)new Function1<String, FileHandle>(it, this.$name){
                    final /* synthetic */ FileHandle $it;
                    final /* synthetic */ String $name;
                    {
                        this.$it = $it;
                        this.$name = $name;
                        super(1);
                    }

                    public final FileHandle invoke(@NotNull String extension) {
                        Intrinsics.checkNotNullParameter(extension, "extension");
                        return this.$it.child(this.$name + '.' + extension);
                    }
                }), getMatchingFiles.2.INSTANCE);
            }
        });
    }

    public final void playOverlay(@NotNull String name2, @NotNull String folder, float volume, boolean isLooping, boolean fadeIn) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(folder, "folder");
        FileHandle fileHandle = SequencesKt.firstOrNull(this.getMatchingFiles(folder, name2));
        if (fileHandle == null) {
            return;
        }
        FileHandle file = fileHandle;
        this.playOverlay(file, volume, isLooping, fadeIn);
    }

    public static /* synthetic */ void playOverlay$default(MusicController musicController, String string, String string2, float f, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "sounds";
        }
        if ((n & 4) != 0) {
            f = musicController.getSettings().getSoundEffectsVolume();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        musicController.playOverlay(string, string2, f, bl, bl2);
    }

    public final void playVoice(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        MusicController.playOverlay$default(this, name2, "voices", this.getSettings().getVoicesVolume(), false, false, 24, null);
    }

    public final boolean isVoicesAvailable() {
        return SequencesKt.any(MusicController.getMusicFolders$default(this, "voices", null, 2, null));
    }

    public final void playOverlay(@NotNull FileHandle file, float volume, boolean isLooping, boolean fadeIn) {
        Intrinsics.checkNotNullParameter(file, "file");
        this.clearOverlay();
        MusicTrackController.load$default(new MusicTrackController(volume, fadeIn ? 0.0f : 1.0f), file, null, new Function1<MusicTrackController, Unit>(isLooping, this){
            final /* synthetic */ boolean $isLooping;
            final /* synthetic */ MusicController this$0;
            {
                this.$isLooping = $isLooping;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MusicTrackController it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Music music = it.getMusic();
                if (music != null) {
                    music.setLooping(this.$isLooping);
                }
                it.play();
                MusicTrackController.startFade$default(it, MusicTrackController.State.FadeIn, 0.0f, 2, null);
                MusicController.access$setOverlay$p(this.this$0, it);
            }
        }, 2, null);
    }

    public final void stopOverlay() {
        block0: {
            this.overlayPausing = false;
            MusicTrackController musicTrackController = this.overlay;
            if (musicTrackController == null) break block0;
            MusicTrackController.startFade$default(musicTrackController, MusicTrackController.State.FadeOut, 0.0f, 2, null);
        }
    }

    private final void pauseOverlay() {
        block0: {
            this.overlayPausing = true;
            MusicTrackController musicTrackController = this.overlay;
            if (musicTrackController == null) break block0;
            MusicTrackController.startFade$default(musicTrackController, MusicTrackController.State.FadeOut, 0.0f, 2, null);
        }
    }

    private final void resumeOverlay() {
        block1: {
            MusicTrackController musicTrackController = this.overlay;
            if (musicTrackController == null) break block1;
            MusicTrackController $this$resumeOverlay_u24lambda_u242 = musicTrackController;
            boolean bl = false;
            if (!$this$resumeOverlay_u24lambda_u242.getState().getCanPlay() || $this$resumeOverlay_u24lambda_u242.getState() == MusicTrackController.State.Playing) {
                return;
            }
            MusicTrackController.startFade$default($this$resumeOverlay_u24lambda_u242, MusicTrackController.State.FadeIn, 0.0f, 2, null);
            $this$resumeOverlay_u24lambda_u242.play();
        }
    }

    private final void overlayTick(MusicTrackController $this$overlayTick) {
        if (!$this$overlayTick.timerTick().getCanPlay()) {
            return;
        }
        if (!this.overlayPausing && !$this$overlayTick.isPlaying()) {
            this.clearOverlay();
        }
    }

    private final void clearOverlay() {
        MusicTrackController musicTrackController = this.overlay;
        if (musicTrackController != null) {
            musicTrackController.clear();
        }
        this.overlay = null;
    }

    public static final /* synthetic */ void access$musicTimerTask(MusicController $this) {
        $this.musicTimerTask();
    }

    public static final /* synthetic */ void access$audioExceptionHandler(MusicController $this, Throwable ex, Music music) {
        $this.audioExceptionHandler(ex, music);
    }

    public static final /* synthetic */ GameSettings access$getSettings(MusicController $this) {
        return $this.getSettings();
    }

    public static final /* synthetic */ HashSet access$getMods$p(MusicController $this) {
        return $this.mods;
    }

    public static final /* synthetic */ ArrayDeque access$getMusicHistory$p(MusicController $this) {
        return $this.musicHistory;
    }

    public static final /* synthetic */ void access$fireOnChange(MusicController $this, MusicTrackInfo trackInfo) {
        $this.fireOnChange(trackInfo);
    }

    public static final /* synthetic */ String access$currentlyPlaying(MusicController $this) {
        return $this.currentlyPlaying();
    }

    public static final /* synthetic */ void access$setTicksOfSilence$p(MusicController $this, int n) {
        $this.ticksOfSilence = n;
    }

    public static final /* synthetic */ void access$setState$p(MusicController $this, ControllerState controllerState) {
        $this.state = controllerState;
    }

    public static final /* synthetic */ void access$setNext$p(MusicController $this, MusicTrackController musicTrackController) {
        $this.next = musicTrackController;
    }

    public static final /* synthetic */ ControllerState access$getState$p(MusicController $this) {
        return $this.state;
    }

    public static final /* synthetic */ MusicTrackController access$getCurrent$p(MusicController $this) {
        return $this.current;
    }

    public static final /* synthetic */ void access$clearCurrent(MusicController $this) {
        $this.clearCurrent();
    }

    public static final /* synthetic */ void access$setOverlay$p(MusicController $this, MusicTrackController musicTrackController) {
        $this.overlay = musicTrackController;
    }

    static {
        String[] stringArray = new String[]{"mp3", "ogg", "wav"};
        gdxSupportedFileExtensions = CollectionsKt.listOf(stringArray);
        needOwnTimer = true;
        ticksPerSecond = 20.0f;
        defaultFadingStep = 0.055555556f;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001f\u001a\n !*\u0004\u0018\u00010 0 2\u0006\u0010\"\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/unciv/ui/audio/MusicController$Companion;", "", "()V", "defaultFadeDuration", "", "defaultFadingStep", "getDefaultFadingStep$core", "()F", "setDefaultFadingStep$core", "(F)V", "defaultFadingStepGdx", "defaultFadingStepOwn", "gdxSupportedFileExtensions", "", "", "getGdxSupportedFileExtensions", "()Ljava/util/List;", "maxVolume", "modPath", "musicFallbackLocalName", "musicFallbackLocation", "musicHistorySize", "", "musicLocation", "Lcom/badlogic/gdx/Files$FileType;", "musicPath", "needOwnTimer", "", "ticksPerSecond", "ticksPerSecondGdx", "ticksPerSecondOwn", "getFile", "Lcom/badlogic/gdx/files/FileHandle;", "kotlin.jvm.PlatformType", "path", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getGdxSupportedFileExtensions() {
            return gdxSupportedFileExtensions;
        }

        private final FileHandle getFile(String path) {
            return musicLocation == Files.FileType.External && Gdx.files.isExternalStorageAvailable() ? Gdx.files.external(path) : Gdx.files.local(path);
        }

        public final float getDefaultFadingStep$core() {
            return defaultFadingStep;
        }

        public final void setDefaultFadingStep$core(float f) {
            defaultFadingStep = f;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001b\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/audio/MusicController$ControllerState;", "", "canPause", "", "showTrack", "(Ljava/lang/String;IZZ)V", "getCanPause", "()Z", "getShowTrack", "Idle", "Cleanup", "Playing", "PlaySingle", "Silence", "Pause", "Shutdown", "core"})
    private static final class ControllerState
    extends Enum<ControllerState> {
        private final boolean canPause;
        private final boolean showTrack;
        public static final /* enum */ ControllerState Idle = new ControllerState("Idle", 0, false, false, 3, null);
        public static final /* enum */ ControllerState Cleanup = new ControllerState("Cleanup", 1, false, false, 3, null);
        public static final /* enum */ ControllerState Playing = new ControllerState(true, true);
        public static final /* enum */ ControllerState PlaySingle = new ControllerState(true, true);
        public static final /* enum */ ControllerState Silence = new ControllerState("Silence", 4, true, false, 2, null);
        public static final /* enum */ ControllerState Pause = new ControllerState("Pause", 5, false, true, 1, null);
        public static final /* enum */ ControllerState Shutdown = new ControllerState("Shutdown", 6, false, false, 3, null);
        private static final /* synthetic */ ControllerState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ControllerState(boolean canPause, boolean showTrack) {
            this.canPause = canPause;
            this.showTrack = showTrack;
        }

        /* synthetic */ ControllerState(String string, int n, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = false;
            }
            if ((n2 & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2);
        }

        public final boolean getCanPause() {
            return this.canPause;
        }

        public final boolean getShowTrack() {
            return this.showTrack;
        }

        public static ControllerState[] values() {
            return (ControllerState[])$VALUES.clone();
        }

        public static ControllerState valueOf(String value) {
            return Enum.valueOf(ControllerState.class, value);
        }

        @NotNull
        public static EnumEntries<ControllerState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = controllerStateArray = new ControllerState[]{ControllerState.Idle, ControllerState.Cleanup, ControllerState.Playing, ControllerState.PlaySingle, ControllerState.Silence, ControllerState.Pause, ControllerState.Shutdown};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/unciv/ui/audio/MusicController$MusicTrackInfo;", "", "mod", "", "track", "type", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getMod", "()Ljava/lang/String;", "getTrack", "getType", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "core"})
    public static final class MusicTrackInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String mod;
        @NotNull
        private final String track;
        @NotNull
        private final String type;

        public MusicTrackInfo(@NotNull String mod, @NotNull String track, @NotNull String type2) {
            Intrinsics.checkNotNullParameter(mod, "mod");
            Intrinsics.checkNotNullParameter(track, "track");
            Intrinsics.checkNotNullParameter(type2, "type");
            this.mod = mod;
            this.track = track;
            this.type = type2;
        }

        @NotNull
        public final String getMod() {
            return this.mod;
        }

        @NotNull
        public final String getTrack() {
            return this.track;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public String toString() {
            return ((CharSequence)this.track).length() == 0 ? "\u2014Paused\u2014" : (((CharSequence)this.mod).length() == 0 ? this.track : this.mod + ": " + this.track);
        }

        @NotNull
        public final String component1() {
            return this.mod;
        }

        @NotNull
        public final String component2() {
            return this.track;
        }

        @NotNull
        public final String component3() {
            return this.type;
        }

        @NotNull
        public final MusicTrackInfo copy(@NotNull String mod, @NotNull String track, @NotNull String type2) {
            Intrinsics.checkNotNullParameter(mod, "mod");
            Intrinsics.checkNotNullParameter(track, "track");
            Intrinsics.checkNotNullParameter(type2, "type");
            return new MusicTrackInfo(mod, track, type2);
        }

        public static /* synthetic */ MusicTrackInfo copy$default(MusicTrackInfo musicTrackInfo, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = musicTrackInfo.mod;
            }
            if ((n & 2) != 0) {
                string2 = musicTrackInfo.track;
            }
            if ((n & 4) != 0) {
                string3 = musicTrackInfo.type;
            }
            return musicTrackInfo.copy(string, string2, string3);
        }

        public int hashCode() {
            int result2 = this.mod.hashCode();
            result2 = result2 * 31 + this.track.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MusicTrackInfo)) {
                return false;
            }
            MusicTrackInfo musicTrackInfo = (MusicTrackInfo)other;
            if (!Intrinsics.areEqual(this.mod, musicTrackInfo.mod)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.track, musicTrackInfo.track)) {
                return false;
            }
            return Intrinsics.areEqual(this.type, musicTrackInfo.type);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/audio/MusicController$MusicTrackInfo$Companion;", "", "()V", "parse", "Lcom/unciv/ui/audio/MusicController$MusicTrackInfo;", "fileName", "", "core"})
        @SourceDebugExtension(value={"SMAP\nMusicController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MusicController.kt\ncom/unciv/ui/audio/MusicController$MusicTrackInfo$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,678:1\n288#2,2:679\n*S KotlinDebug\n*F\n+ 1 MusicController.kt\ncom/unciv/ui/audio/MusicController$MusicTrackInfo$Companion\n*L\n96#1:679,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final MusicTrackInfo parse(@NotNull String fileName) {
                String string;
                Object v0;
                String trackName;
                String modName;
                block3: {
                    void $this$firstOrNull$iv;
                    Intrinsics.checkNotNullParameter(fileName, "fileName");
                    if (((CharSequence)fileName).length() == 0) {
                        return new MusicTrackInfo("", "", "");
                    }
                    char[] cArray = new char[]{'/'};
                    List fileNameParts = StringsKt.split$default((CharSequence)fileName, cArray, false, 0, 6, null);
                    modName = fileNameParts.size() > 1 && Intrinsics.areEqual(fileNameParts.get(0), MusicController.modPath) ? (String)fileNameParts.get(1) : "";
                    trackName = null;
                    trackName = (String)fileNameParts.get(fileNameParts.size() > 3 && Intrinsics.areEqual(fileNameParts.get(2), MusicController.musicPath) ? 3 : 1);
                    Iterable iterable = MusicController.Companion.getGdxSupportedFileExtensions();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        if (!StringsKt.endsWith$default(trackName, '.' + it, false, 2, null)) continue;
                        v0 = element$iv;
                        break block3;
                    }
                    v0 = null;
                }
                if ((string = (String)v0) == null) {
                    string = "";
                }
                String type2 = string;
                trackName = StringsKt.removeSuffix(trackName, (CharSequence)('.' + type2));
                return new MusicTrackInfo(modName, trackName, type2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ControllerState.values().length];
            try {
                nArray[ControllerState.Idle.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ControllerState.Playing.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ControllerState.PlaySingle.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ControllerState.Silence.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ControllerState.Shutdown.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ControllerState.Cleanup.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ControllerState.Pause.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

