/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.fonts;

import com.unciv.utils.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UInt;
import kotlin.UShort;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharCategory;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\t\u0018\u0000 \u001a2\u00020\u0001:\u0004\u0019\u001a\u001b\u001cB/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/unciv/ui/components/fonts/DiacriticSupport;", "", "enabled", "", "range", "Lkotlin/ranges/CharRange;", "leftDiacritics", "", "rightDiacritics", "joinerDiacritics", "(ZLkotlin/ranges/CharRange;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "charClassMap", "", "", "Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass;", "createReplacementChar", "joined", "getCharClass", "char", "getKnownCombinations", "", "getReplacementChar", "isEnabled", "remapDiacritics", "value", "CharClass", "Companion", "LineData", "TranslationKeys", "core"})
public final class DiacriticSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean enabled;
    @NotNull
    private final Map<Character, CharClass> charClassMap;
    private static final short startingReplacementCodepoint = -1793;
    @NotNull
    private static final Map<CharCategory, CharClass> charCategoryToClass;
    private static final char defaultRangeStart = '!';
    private static final char defaultRangeEnd = '\uffee';
    private static short nextFreeDiacriticReplacementCodepoint;
    @NotNull
    private static final Map<Character, String> fakeAlphabet;
    @NotNull
    private static final Map<String, Character> inverseMap;

    public DiacriticSupport(boolean enabled, @NotNull CharRange range, @NotNull String leftDiacritics, @NotNull String rightDiacritics, @NotNull String joinerDiacritics) {
        Intrinsics.checkNotNullParameter(range, "range");
        Intrinsics.checkNotNullParameter(leftDiacritics, "leftDiacritics");
        Intrinsics.checkNotNullParameter(rightDiacritics, "rightDiacritics");
        Intrinsics.checkNotNullParameter(joinerDiacritics, "joinerDiacritics");
        this.enabled = enabled;
        this.charClassMap = new LinkedHashMap();
        if (this.enabled) {
            Character c;
            int n;
            int rangeEnd;
            char rangeStart = range.isEmpty() ? (char)'!' : (char)range.getFirst();
            char c2 = rangeStart;
            if (c2 <= (rangeEnd = range.isEmpty() ? 65518 : (int)range.getLast())) {
                while (true) {
                    Map<Character, CharClass> map2 = this.charClassMap;
                    Character c3 = Character.valueOf(c2);
                    if (charCategoryToClass.get((Object)CharsKt.getCategory(c2)) != null) {
                        CharClass charClass;
                        map2.put(c3, charClass);
                    }
                    if (c2 == rangeEnd) break;
                    c2 = (char)(c2 + '\u0001');
                }
            }
            int n2 = leftDiacritics.length();
            for (n = 0; n < n2; ++n) {
                char = leftDiacritics.charAt(n);
                c = Character.valueOf(char);
                this.charClassMap.put(c, CharClass.LeftJoiner);
            }
            n2 = rightDiacritics.length();
            for (n = 0; n < n2; ++n) {
                char = rightDiacritics.charAt(n);
                c = Character.valueOf(char);
                this.charClassMap.put(c, CharClass.RightJoiner);
            }
            n2 = joinerDiacritics.length();
            for (n = 0; n < n2; ++n) {
                char = joinerDiacritics.charAt(n);
                c = Character.valueOf(char);
                this.charClassMap.put(c, CharClass.LeftRightJoiner);
            }
        }
    }

    public /* synthetic */ DiacriticSupport(boolean bl, CharRange charRange, String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl, charRange, string, string2, string3);
    }

    @VisibleForTesting
    @NotNull
    public final Set<String> getKnownCombinations() {
        return inverseMap.keySet();
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    private final CharClass getCharClass(char c) {
        CharClass charClass = this.charClassMap.get(Character.valueOf(c));
        if (charClass == null) {
            charClass = CharClass.None;
        }
        return charClass;
    }

    private final char getReplacementChar(String joined) {
        Character c = inverseMap.get(joined);
        return c != null ? c.charValue() : this.createReplacementChar(joined);
    }

    private final char createReplacementChar(String joined) {
        char c = Companion.getCurrentFreeCode();
        int n = nextFreeDiacriticReplacementCodepoint;
        short s = nextFreeDiacriticReplacementCodepoint = UShort.constructor-impl((short)(n + -1));
        n = UInt.constructor-impl(57344);
        if (Integer.compareUnsigned(UInt.constructor-impl(s & 0xFFFF), n) < 0) {
            throw new IllegalStateException("DiacriticsSupport has exhausted the Unicode private use area");
        }
        Character c2 = Character.valueOf(c);
        fakeAlphabet.put(c2, joined);
        c2 = Character.valueOf(c);
        inverseMap.put(joined, c2);
        return c;
    }

    @NotNull
    public final String remapDiacritics(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (!this.enabled) {
            throw new IllegalStateException("DiacriticSupport not set up properly for translation processing");
        }
        LineData data2 = new LineData(value.length());
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            char c = value.charAt(i);
            this.getCharClass(c).process(data2, c);
        }
        return data2.result();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(CharCategory.UPPERCASE_LETTER, CharClass.Base), TuplesKt.to(CharCategory.LOWERCASE_LETTER, CharClass.Base), TuplesKt.to(CharCategory.TITLECASE_LETTER, CharClass.Base), TuplesKt.to(CharCategory.OTHER_LETTER, CharClass.Base), TuplesKt.to(CharCategory.MODIFIER_LETTER, CharClass.Base), TuplesKt.to(CharCategory.DECIMAL_DIGIT_NUMBER, CharClass.Base), TuplesKt.to(CharCategory.LETTER_NUMBER, CharClass.Base), TuplesKt.to(CharCategory.OTHER_NUMBER, CharClass.Base), TuplesKt.to(CharCategory.COMBINING_SPACING_MARK, CharClass.LeftJoiner), TuplesKt.to(CharCategory.NON_SPACING_MARK, CharClass.LeftJoiner), TuplesKt.to(CharCategory.ENCLOSING_MARK, CharClass.LeftJoiner), TuplesKt.to(CharCategory.SURROGATE, CharClass.Surrogate)};
        charCategoryToClass = MapsKt.mapOf(pairArray);
        nextFreeDiacriticReplacementCodepoint = (short)-1793;
        fakeAlphabet = new LinkedHashMap();
        inverseMap = new LinkedHashMap();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nR\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass;", "", "expectsRightJoin", "", "(Ljava/lang/String;IZ)V", "getExpectsRightJoin", "()Z", "process", "", "data", "Lcom/unciv/ui/components/fonts/DiacriticSupport$LineData;", "Lcom/unciv/ui/components/fonts/DiacriticSupport;", "char", "", "None", "Base", "LeftJoiner", "RightJoiner", "LeftRightJoiner", "Surrogate", "core"})
    private static final abstract class CharClass
    extends Enum<CharClass> {
        private final boolean expectsRightJoin;
        public static final /* enum */ CharClass None = new None("None", 0);
        public static final /* enum */ CharClass Base = new Base("Base", 1);
        public static final /* enum */ CharClass LeftJoiner = new LeftJoiner("LeftJoiner", 2);
        public static final /* enum */ CharClass RightJoiner = new RightJoiner("RightJoiner", 3);
        public static final /* enum */ CharClass LeftRightJoiner = new LeftRightJoiner("LeftRightJoiner", 4);
        public static final /* enum */ CharClass Surrogate = new Surrogate("Surrogate", 5);
        private static final /* synthetic */ CharClass[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private CharClass(boolean expectsRightJoin) {
            this.expectsRightJoin = expectsRightJoin;
        }

        /* synthetic */ CharClass(String string, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final boolean getExpectsRightJoin() {
            return this.expectsRightJoin;
        }

        public abstract void process(@NotNull LineData var1, char var2);

        public static CharClass[] values() {
            return (CharClass[])$VALUES.clone();
        }

        public static CharClass valueOf(String value) {
            return Enum.valueOf(CharClass.class, value);
        }

        @NotNull
        public static EnumEntries<CharClass> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ CharClass(String $enum$name, int $enum$ordinal, boolean expectsRightJoin, DefaultConstructorMarker $constructor_marker) {
            this(expectsRightJoin);
        }

        static {
            $VALUES = charClassArray = new CharClass[]{CharClass.None, CharClass.Base, CharClass.LeftJoiner, CharClass.RightJoiner, CharClass.LeftRightJoiner, CharClass.Surrogate};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass$Base;", "Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass;", "process", "", "data", "Lcom/unciv/ui/components/fonts/DiacriticSupport$LineData;", "Lcom/unciv/ui/components/fonts/DiacriticSupport;", "char", "", "core"})
        static final class Base
        extends CharClass {
            /*
             * WARNING - void declaration
             */
            Base() {
                void var1_1;
            }

            @Override
            public void process(@NotNull LineData data2, char c) {
                Intrinsics.checkNotNullParameter(data2, "data");
                data2.flushAccumulate(c);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass$LeftJoiner;", "Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass;", "process", "", "data", "Lcom/unciv/ui/components/fonts/DiacriticSupport$LineData;", "Lcom/unciv/ui/components/fonts/DiacriticSupport;", "char", "", "core"})
        static final class LeftJoiner
        extends CharClass {
            /*
             * WARNING - void declaration
             */
            LeftJoiner() {
                void var1_1;
            }

            @Override
            public void process(@NotNull LineData data2, char c) {
                Intrinsics.checkNotNullParameter(data2, "data");
                data2.accumulate(c);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass$LeftRightJoiner;", "Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass;", "process", "", "data", "Lcom/unciv/ui/components/fonts/DiacriticSupport$LineData;", "Lcom/unciv/ui/components/fonts/DiacriticSupport;", "char", "", "core"})
        static final class LeftRightJoiner
        extends CharClass {
            /*
             * WARNING - void declaration
             */
            LeftRightJoiner() {
                void var1_1;
            }

            @Override
            public void process(@NotNull LineData data2, char c) {
                Intrinsics.checkNotNullParameter(data2, "data");
                data2.accumulate(c);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass$None;", "Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass;", "process", "", "data", "Lcom/unciv/ui/components/fonts/DiacriticSupport$LineData;", "Lcom/unciv/ui/components/fonts/DiacriticSupport;", "char", "", "core"})
        static final class None
        extends CharClass {
            /*
             * WARNING - void declaration
             */
            None() {
                void var1_1;
            }

            @Override
            public void process(@NotNull LineData data2, char c) {
                Intrinsics.checkNotNullParameter(data2, "data");
                data2.flushAppend(c);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass$RightJoiner;", "Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass;", "process", "", "data", "Lcom/unciv/ui/components/fonts/DiacriticSupport$LineData;", "Lcom/unciv/ui/components/fonts/DiacriticSupport;", "char", "", "core"})
        static final class RightJoiner
        extends CharClass {
            /*
             * WARNING - void declaration
             */
            RightJoiner() {
                void var1_1;
            }

            @Override
            public void process(@NotNull LineData data2, char c) {
                Intrinsics.checkNotNullParameter(data2, "data");
                data2.flushAccumulate(c);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass$Surrogate;", "Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass;", "process", "", "data", "Lcom/unciv/ui/components/fonts/DiacriticSupport$LineData;", "Lcom/unciv/ui/components/fonts/DiacriticSupport;", "char", "", "core"})
        static final class Surrogate
        extends CharClass {
            /*
             * WARNING - void declaration
             */
            Surrogate() {
                void var1_1;
            }

            @Override
            public void process(@NotNull LineData data2, char c) {
                Intrinsics.checkNotNullParameter(data2, "data");
                data2.surrogate(c);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\bJ-\u0010\u0017\u001a\u00020\u00182\"\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u001aj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f`\u001bH\u0086\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u0013R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0016\u0010\u0011\u001a\u00020\u000fX\u0082T\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0010\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001f"}, d2={"Lcom/unciv/ui/components/fonts/DiacriticSupport$Companion;", "", "()V", "charCategoryToClass", "", "Lkotlin/text/CharCategory;", "Lcom/unciv/ui/components/fonts/DiacriticSupport$CharClass;", "defaultRangeEnd", "", "defaultRangeStart", "fakeAlphabet", "", "", "inverseMap", "nextFreeDiacriticReplacementCodepoint", "Lkotlin/UShort;", "S", "startingReplacementCodepoint", "freeTranslationData", "", "getCurrentFreeCode", "getStringFor", "char", "invoke", "Lcom/unciv/ui/components/fonts/DiacriticSupport;", "translations", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "isEmpty", "", "reset", "core"})
    @SourceDebugExtension(value={"SMAP\nDiacriticSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiacriticSupport.kt\ncom/unciv/ui/components/fonts/DiacriticSupport$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,252:1\n1477#2:253\n1502#2,3:254\n1505#2,3:264\n372#3,7:257\n*S KotlinDebug\n*F\n+ 1 DiacriticSupport.kt\ncom/unciv/ui/components/fonts/DiacriticSupport$Companion\n*L\n92#1:253\n92#1:254,3\n92#1:264,3\n92#1:257,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void reset() {
            fakeAlphabet.clear();
            this.freeTranslationData();
            nextFreeDiacriticReplacementCodepoint = (short)-1793;
        }

        @NotNull
        public final String getStringFor(char c) {
            String string = (String)fakeAlphabet.get(Character.valueOf(c));
            if (string == null) {
                string = String.valueOf(c);
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        public final void freeTranslationData() {
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = inverseMap.keySet();
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                String it = (String)element$iv$iv;
                boolean bl = false;
                Integer key$iv$iv = it.length();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            for (Map.Entry entry : ((Map)MapsKt.toSortedMap(destination$iv$iv)).entrySet()) {
                Integer length = (Integer)entry.getKey();
                List examples = (List)entry.getValue();
                Object[] objectArray = new Object[2];
                objectArray[0] = length;
                Intrinsics.checkNotNull(examples);
                objectArray[1] = CollectionsKt.first(examples);
                Log.INSTANCE.debug("Length %d - example %s", objectArray);
            }
            inverseMap.clear();
        }

        public final char getCurrentFreeCode() {
            return (char)(nextFreeDiacriticReplacementCodepoint & 0xFFFF);
        }

        public final boolean isEmpty() {
            return fakeAlphabet.isEmpty();
        }

        @NotNull
        public final DiacriticSupport invoke(@NotNull HashMap<String, String> translations) {
            Intrinsics.checkNotNullParameter(translations, "translations");
            Regex stripCommentRegex = new Regex("^\"?(.*?)\"?(?:\\s*#.*)?$");
            boolean enable = Intrinsics.areEqual(com.unciv.ui.components.fonts.DiacriticSupport$Companion.invoke$parseDiacriticEntry(translations.get("diacritics_support"), stripCommentRegex), "true");
            String rangeStart = com.unciv.ui.components.fonts.DiacriticSupport$Companion.invoke$parseDiacriticEntry(translations.get("unicode_block_start_character"), stripCommentRegex);
            String rangeEnd = com.unciv.ui.components.fonts.DiacriticSupport$Companion.invoke$parseDiacriticEntry(translations.get("unicode_block_end_character"), stripCommentRegex);
            CharRange range = ((CharSequence)rangeStart).length() == 0 || ((CharSequence)rangeEnd).length() == 0 ? CharRange.Companion.getEMPTY() : new CharRange(StringsKt.first(rangeStart), StringsKt.first(rangeEnd));
            String leftDiacritics = com.unciv.ui.components.fonts.DiacriticSupport$Companion.invoke$parseDiacriticEntry(translations.get("left_joining_diacritics"), stripCommentRegex);
            String rightDiacritics = com.unciv.ui.components.fonts.DiacriticSupport$Companion.invoke$parseDiacriticEntry(translations.get("right_joining_diacritics"), stripCommentRegex);
            String joinerDiacritics = com.unciv.ui.components.fonts.DiacriticSupport$Companion.invoke$parseDiacriticEntry(translations.get("left_and_right_joiners"), stripCommentRegex);
            return new DiacriticSupport(enable, range, leftDiacritics, rightDiacritics, joinerDiacritics);
        }

        private static final String invoke$parseDiacriticEntry(String $this$invoke_u24parseDiacriticEntry, Regex stripCommentRegex) {
            CharSequence charSequence = $this$invoke_u24parseDiacriticEntry;
            if (charSequence == null || charSequence.length() == 0) {
                return "";
            }
            MatchResult matchResult = stripCommentRegex.matchEntire($this$invoke_u24parseDiacriticEntry);
            Intrinsics.checkNotNull(matchResult);
            char[] cArray = new char[]{' '};
            List tokens = SequencesKt.toMutableList(StringsKt.splitToSequence$default((CharSequence)matchResult.getGroupValues().get(1), cArray, false, 0, 6, null));
            int n = tokens.size();
            for (int index = 0; index < n; ++index) {
                String token2 = (String)tokens.get(index);
                if (token2.length() == 1) continue;
                if (StringsKt.startsWith(token2, "u+", true)) {
                    int n2 = Integer.parseInt(StringsKt.drop(token2, 2), CharsKt.checkRadix(16));
                    if (n2 < 0 || n2 > 65535) {
                        throw new IllegalArgumentException("Invalid Char code: " + n2);
                    }
                    tokens.set(index, String.valueOf((char)n2));
                    continue;
                }
                if (tokens.size() == 1) continue;
                throw new IllegalArgumentException("Invalid diacritic definition: \"" + token2 + "\" is not a single character or unicode codepoint notation");
            }
            return CollectionsKt.joinToString$default(tokens, "", null, null, 0, null, null, 62, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0013J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rJ\u0006\u0010\u001a\u001a\u00020\u0013J\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rR\u0015\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\n\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/unciv/ui/components/fonts/DiacriticSupport$LineData;", "", "capacity", "", "(Lcom/unciv/ui/components/fonts/DiacriticSupport;I)V", "accumulator", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getAccumulator", "()Ljava/lang/StringBuilder;", "output", "getOutput", "waitingHighSurrogate", "", "getWaitingHighSurrogate", "()C", "setWaitingHighSurrogate", "(C)V", "accumulate", "", "char", "expectsJoin", "", "flush", "flushAccumulate", "flushAppend", "forbidWaitingHighSurrogate", "result", "", "surrogate", "core"})
    private final class LineData {
        @NotNull
        private final StringBuilder output;
        @NotNull
        private final StringBuilder accumulator;
        private char waitingHighSurrogate;

        public LineData(int capacity) {
            this.output = new StringBuilder(capacity);
            this.accumulator = new StringBuilder(9);
        }

        @NotNull
        public final StringBuilder getOutput() {
            return this.output;
        }

        @NotNull
        public final StringBuilder getAccumulator() {
            return this.accumulator;
        }

        public final char getWaitingHighSurrogate() {
            return this.waitingHighSurrogate;
        }

        public final void setWaitingHighSurrogate(char c) {
            this.waitingHighSurrogate = c;
        }

        public final boolean expectsJoin() {
            return ((CharSequence)this.accumulator).length() > 0 && DiacriticSupport.this.getCharClass(StringsKt.last(this.accumulator)).getExpectsRightJoin();
        }

        public final void flush() {
            if (this.accumulator.length() <= 1) {
                this.output.append((CharSequence)this.accumulator);
            } else {
                String string = this.accumulator.toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                this.output.append(DiacriticSupport.this.getReplacementChar(string));
            }
            StringsKt.clear(this.accumulator);
        }

        public final void forbidWaitingHighSurrogate() {
            if (this.waitingHighSurrogate != '\u0000') {
                throw new IllegalArgumentException("Invalid Unicode: High surrogate without low surrogate");
            }
        }

        public final void accumulate(char c) {
            this.forbidWaitingHighSurrogate();
            this.accumulator.append(c);
        }

        public final void flushAccumulate(char c) {
            this.forbidWaitingHighSurrogate();
            if (!this.expectsJoin()) {
                this.flush();
            }
            this.accumulator.append(c);
        }

        public final void flushAppend(char c) {
            this.forbidWaitingHighSurrogate();
            this.flush();
            this.output.append(c);
        }

        public final void surrogate(char c) {
            if (Character.isHighSurrogate(c)) {
                this.forbidWaitingHighSurrogate();
                this.waitingHighSurrogate = c;
            } else {
                if (this.waitingHighSurrogate == '\u0000') {
                    throw new IllegalArgumentException("Invalid Unicode: Low surrogate without high surrogate");
                }
                if (!this.expectsJoin()) {
                    this.flush();
                }
                this.accumulator.append(this.waitingHighSurrogate);
                this.accumulator.append(c);
                this.waitingHighSurrogate = '\u0000';
            }
        }

        @NotNull
        public final String result() {
            this.flush();
            String string = this.output.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/components/fonts/DiacriticSupport$TranslationKeys;", "", "()V", "enable", "", "joiner", "left", "rangeEnd", "rangeStart", "right", "core"})
    private static final class TranslationKeys {
        @NotNull
        public static final TranslationKeys INSTANCE = new TranslationKeys();
        @NotNull
        public static final String enable = "diacritics_support";
        @NotNull
        public static final String rangeStart = "unicode_block_start_character";
        @NotNull
        public static final String rangeEnd = "unicode_block_end_character";
        @NotNull
        public static final String left = "left_joining_diacritics";
        @NotNull
        public static final String right = "right_joining_diacritics";
        @NotNull
        public static final String joiner = "left_and_right_joiners";

        private TranslationKeys() {
        }
    }
}

