/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.fonts;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.fonts.FontMetricsCommon;
import com.unciv.ui.components.fonts.FontRulesetIcons;
import com.unciv.ui.components.fonts.Fonts;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import java.util.HashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\tJ\u001c\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040&2\u0006\u0010$\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R-\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R-\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\b0\u0007j\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\b`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0012\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/unciv/ui/components/fonts/FontRulesetIcons;", "", "()V", "UNUSED_CHARACTER_CODES_END", "", "UNUSED_CHARACTER_CODES_START", "charToRulesetImageActor", "Ljava/util/HashMap;", "", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "Lkotlin/collections/HashMap;", "getCharToRulesetImageActor", "()Ljava/util/HashMap;", "frameBuffer", "Lcom/badlogic/gdx/graphics/glutils/FrameBuffer;", "getFrameBuffer", "()Lcom/badlogic/gdx/graphics/glutils/FrameBuffer;", "frameBuffer$delegate", "Lkotlin/Lazy;", "nextUnusedCharacterNumber", "rulesetObjectNameToChar", "", "getRulesetObjectNameToChar", "spriteBatch", "Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "getSpriteBatch", "()Lcom/badlogic/gdx/graphics/g2d/SpriteBatch;", "spriteBatch$delegate", "transform", "Lcom/badlogic/gdx/math/Matrix4;", "addRulesetImages", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getPixmapFromActor", "Lcom/badlogic/gdx/graphics/Pixmap;", "actor", "scaleAndPositionActor", "Lkotlin/Pair;", "core"})
@SourceDebugExtension(value={"SMAP\nFontRulesetIcons.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FontRulesetIcons.kt\ncom/unciv/ui/components/fonts/FontRulesetIcons\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
public final class FontRulesetIcons {
    @NotNull
    public static final FontRulesetIcons INSTANCE = new FontRulesetIcons();
    public static final int UNUSED_CHARACTER_CODES_START = 57344;
    private static final int UNUSED_CHARACTER_CODES_END = 63743;
    @NotNull
    private static final HashMap<String, Character> rulesetObjectNameToChar = new HashMap();
    @NotNull
    private static final HashMap<Character, Actor> charToRulesetImageActor = new HashMap();
    private static int nextUnusedCharacterNumber = 57344;
    @NotNull
    private static final Lazy frameBuffer$delegate = LazyKt.lazy(frameBuffer.2.INSTANCE);
    @NotNull
    private static final Lazy spriteBatch$delegate = LazyKt.lazy(spriteBatch.2.INSTANCE);
    @NotNull
    private static final Matrix4 transform = new Matrix4();

    private FontRulesetIcons() {
    }

    @NotNull
    public final HashMap<String, Character> getRulesetObjectNameToChar() {
        return rulesetObjectNameToChar;
    }

    @NotNull
    public final HashMap<Character, Actor> getCharToRulesetImageActor() {
        return charToRulesetImageActor;
    }

    /*
     * WARNING - void declaration
     */
    public final void addRulesetImages(@NotNull Ruleset ruleset2) {
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        rulesetObjectNameToChar.clear();
        charToRulesetImageActor.clear();
        nextUnusedCharacterNumber = 57344;
        for (String resourceName : ruleset2.getTileResources().keySet()) {
            Intrinsics.checkNotNull(resourceName);
            FontRulesetIcons.addRulesetImages$addChar(resourceName, ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, resourceName, 50.0f, 0, 4, null));
        }
        for (String buildingName : ruleset2.getBuildings().keySet()) {
            Intrinsics.checkNotNull(buildingName);
            FontRulesetIcons.addRulesetImages$addChar(buildingName, ImageGetter.INSTANCE.getConstructionPortrait(buildingName, 50.0f));
        }
        for (String unitName : ruleset2.getUnits().keySet()) {
            Intrinsics.checkNotNull(unitName);
            FontRulesetIcons.addRulesetImages$addChar(unitName, ImageGetter.INSTANCE.getConstructionPortrait(unitName, 50.0f));
        }
        for (String promotionName : ruleset2.getUnitPromotions().keySet()) {
            Intrinsics.checkNotNull(promotionName);
            FontRulesetIcons.addRulesetImages$addChar(promotionName, ImageGetter.INSTANCE.getPromotionPortrait(promotionName, 50.0f));
        }
        for (String improvementName : ruleset2.getTileImprovements().keySet()) {
            Intrinsics.checkNotNull(improvementName);
            FontRulesetIcons.addRulesetImages$addChar(improvementName, ImageGetter.getImprovementPortrait$default(ImageGetter.INSTANCE, improvementName, 50.0f, false, false, 12, null));
        }
        for (String techName : ruleset2.getTechnologies().keySet()) {
            Intrinsics.checkNotNull(techName);
            FontRulesetIcons.addRulesetImages$addChar(techName, ImageGetter.INSTANCE.getTechIconPortrait(techName, 50.0f));
        }
        for (Nation nation2 : ruleset2.getNations().values()) {
            String string = nation2.getName();
            Intrinsics.checkNotNull(nation2);
            FontRulesetIcons.addRulesetImages$addChar(string, ImageGetter.INSTANCE.getNationPortrait(nation2, 50.0f));
        }
        for (Policy policy2 : ruleset2.getPolicies().values()) {
            void $this$addRulesetImages_u24lambda_u240;
            Image image2;
            String fileLocation = ((Map)ruleset2.getPolicyBranches()).containsKey(policy2.getName()) ? "PolicyBranchIcons/" + policy2.getName() : "PolicyIcons/" + policy2.getName();
            if (!ImageGetter.INSTANCE.imageExists(fileLocation)) continue;
            Image image3 = image2 = ImageGetter.INSTANCE.getImage(fileLocation);
            String string = policy2.getName();
            boolean bl = false;
            Scene2dExtensionsKt.setSize((Image)$this$addRulesetImages_u24lambda_u240, 50.0f);
            FontRulesetIcons.addRulesetImages$addChar(string, image2);
        }
    }

    private final FrameBuffer getFrameBuffer() {
        Lazy lazy = frameBuffer$delegate;
        return (FrameBuffer)lazy.getValue();
    }

    private final SpriteBatch getSpriteBatch() {
        Lazy lazy = spriteBatch$delegate;
        return (SpriteBatch)lazy.getValue();
    }

    @NotNull
    public final Pixmap getPixmapFromActor(@NotNull Actor actor) {
        Intrinsics.checkNotNullParameter(actor, "actor");
        Pair<Integer, Integer> pair = this.scaleAndPositionActor(actor);
        int boxWidth = ((Number)pair.component1()).intValue();
        int boxHeight = ((Number)pair.component2()).intValue();
        Pixmap pixmap = new Pixmap(boxWidth, boxHeight, Pixmap.Format.RGBA8888);
        this.getFrameBuffer().begin();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Gdx.gl.glClear(16384);
        this.getSpriteBatch().begin();
        actor.draw(this.getSpriteBatch(), 1.0f);
        this.getSpriteBatch().end();
        Gdx.gl.glReadPixels(0, 0, boxWidth, boxHeight, 6408, 5121, pixmap.getPixels());
        this.getFrameBuffer().end();
        return pixmap;
    }

    private final Pair<Integer, Integer> scaleAndPositionActor(Actor actor) {
        float border;
        FontMetricsCommon metrics = Fonts.INSTANCE.getFontImplementation().getMetrics();
        float scaledActorHeight = metrics.getAscent() * 0.93f;
        float scaledActorWidth = actor.getWidth() * (scaledActorHeight / actor.getHeight());
        int boxHeight = (int)Math.ceil(metrics.getHeight());
        int boxWidth = (int)Math.ceil(scaledActorWidth);
        Portrait portrait = actor instanceof Portrait ? (Portrait)actor : null;
        float f = border = portrait != null ? portrait.getBorderSize() : 0.0f;
        if (actor instanceof Group) {
            ((Group)actor).setTransform(true);
            float scale = scaledActorWidth / ((Group)actor).getWidth();
            actor.setScale(scale, -scale);
            actor.setPosition(0.0f, metrics.getLeading() + metrics.getAscent() + border * scale + 1.0f);
        } else {
            actor.setPosition(0.0f, metrics.getLeading() + border);
            actor.setSize(scaledActorWidth, scaledActorHeight);
            transform.idt().scl(1.0f, -1.0f, 1.0f).trn(0.0f, boxHeight, 0.0f);
            this.getSpriteBatch().setTransformMatrix(transform);
        }
        return TuplesKt.to(boxWidth, boxHeight);
    }

    private static final void addRulesetImages$addChar(String objectName, Actor objectActor) {
        if (nextUnusedCharacterNumber > 63743) {
            return;
        }
        int n = nextUnusedCharacterNumber;
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Invalid Char code: " + n);
        }
        char c = (char)n;
        int n2 = nextUnusedCharacterNumber;
        nextUnusedCharacterNumber = n2 + 1;
        Character c2 = Character.valueOf(c);
        ((Map)rulesetObjectNameToChar).put(objectName, c2);
        c2 = Character.valueOf(c);
        ((Map)charToRulesetImageActor).put(c2, objectActor);
    }
}

