/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.SequenceAction;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.GUI;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Spy;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.tilegroups.AirUnitTable;
import com.unciv.ui.components.tilegroups.CityButton;
import com.unciv.ui.components.tilegroups.CityTable;
import com.unciv.ui.components.tilegroups.DefenceTable;
import com.unciv.ui.components.tilegroups.InfluenceTable;
import com.unciv.ui.components.tilegroups.StatusTable;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.cityscreen.CityReligionInfoTable;
import com.unciv.ui.screens.cityscreen.CityScreen;
import com.unciv.ui.screens.diplomacyscreen.DiplomacyScreen;
import com.unciv.ui.screens.worldscreen.unit.UnitTable;
import com.unciv.utils.DebugUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 (2\u00020\u0001:\u0002()B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\fH\u0002J\u001a\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0018H\u0016J\b\u0010\u001e\u001a\u00020\u0016H\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0002J\u0006\u0010\"\u001a\u00020\u0016J\u0006\u0010#\u001a\u00020\u0016J\b\u0010$\u001a\u00020\u0016H\u0002J\u000e\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\fJ\u0010\u0010'\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006*"}, d2={"Lcom/unciv/ui/components/tilegroups/CityButton;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "city", "Lcom/unciv/logic/city/City;", "tileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "(Lcom/unciv/logic/city/City;Lcom/unciv/ui/components/tilegroups/TileGroup;)V", "getCity", "()Lcom/unciv/logic/city/City;", "cityTable", "Lcom/unciv/ui/components/tilegroups/CityTable;", "isButtonMoved", "", "isViewable", "listOfHiddenUnitMarkers", "", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "viewingPlayer", "Lcom/unciv/logic/civilization/Civilization;", "getViewingPlayer", "()Lcom/unciv/logic/civilization/Civilization;", "act", "", "delta", "", "belongsToViewingCiv", "draw", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "foreignCityInfoPopup", "insertHiddenUnitMarker", "pos", "Lcom/unciv/ui/components/tilegroups/CityButton$HiddenUnitMarkerPosition;", "moveButtonDown", "moveButtonUp", "setButtonActions", "update", "isCityViewable", "updateHiddenUnitMarkers", "Companion", "HiddenUnitMarkerPosition", "core"})
public final class CityButton
extends Table {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final City city;
    @NotNull
    private final TileGroup tileGroup;
    private CityTable cityTable;
    @NotNull
    private final List<Actor> listOfHiddenUnitMarkers;
    private boolean isButtonMoved;
    private boolean isViewable;
    @NotNull
    private final Civilization viewingPlayer;
    @NotNull
    private static final Color ColorConstruction = Scene2dExtensionsKt.colorFromRGB(196, 140, 62);
    @NotNull
    private static final Color ColorGrowth = Scene2dExtensionsKt.colorFromRGB(130, 225, 78);

    public CityButton(@NotNull City city2, @NotNull TileGroup tileGroup) {
        Intrinsics.checkNotNullParameter(city2, "city");
        Intrinsics.checkNotNullParameter(tileGroup, "tileGroup");
        super(BaseScreen.Companion.getSkin());
        this.city = city2;
        this.tileGroup = tileGroup;
        this.setTouchable(Touchable.disabled);
        this.listOfHiddenUnitMarkers = new ArrayList();
        this.isViewable = true;
        this.viewingPlayer = GUI.INSTANCE.getViewingPlayer();
    }

    @NotNull
    public final City getCity() {
        return this.city;
    }

    @NotNull
    public final Civilization getViewingPlayer() {
        return this.viewingPlayer;
    }

    public final void update(boolean isCityViewable) {
        this.isViewable = isCityViewable;
        this.clear();
        this.setButtonActions();
        if (isCityViewable && !((Collection)this.tileGroup.getTile().getAirUnits()).isEmpty()) {
            this.add((Actor)new AirUnitTable(this.city, this.tileGroup.getTile().getAirUnits().size(), 0.0f, 4, null)).padBottom(5.0f).row();
        }
        this.add((Actor)new DefenceTable(this.city)).row();
        this.cityTable = new CityTable(this.city, false, 2, null);
        CityTable cityTable = this.cityTable;
        if (cityTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cityTable");
            cityTable = null;
        }
        this.add((Actor)cityTable).row();
        Civilization selectedPlayer = GUI.INSTANCE.getSelectedPlayer();
        if (this.city.getCiv().isCityState() && this.city.getCiv().knows(selectedPlayer)) {
            DiplomacyManager diplomacyManager = this.city.getCiv().getDiplomacyManager(selectedPlayer);
            Intrinsics.checkNotNull(diplomacyManager);
            DiplomacyManager diplomacyManager2 = diplomacyManager;
            this.add((Actor)new InfluenceTable(diplomacyManager2.getInfluence(), diplomacyManager2.relationshipLevel(), 0.0f, 0.0f, 12, null)).padTop(1.0f).row();
        }
        this.add((Actor)new StatusTable(this.city, 0.0f, 2, null)).padTop(3.0f);
        this.pack();
        if (isCityViewable && (float)this.city.getHealth() < (float)this.city.getMaxHealth$core()) {
            Table healthBar = ImageGetter.INSTANCE.getHealthBar(this.city.getHealth(), this.city.getMaxHealth$core(), 100.0f, 3.0f);
            this.addActor(healthBar);
            Scene2dExtensionsKt.center((Actor)healthBar, this);
            CityTable cityTable2 = this.cityTable;
            if (cityTable2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("cityTable");
                cityTable2 = null;
            }
            float f = cityTable2.getY();
            CityTable cityTable3 = this.cityTable;
            if (cityTable3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("cityTable");
                cityTable3 = null;
            }
            healthBar.setY(f + cityTable3.getHeight() - healthBar.getHeight() - 1.0f);
        }
        this.setOrigin(1);
        Scene2dExtensionsKt.centerX((Actor)this, this.tileGroup);
        this.updateHiddenUnitMarkers(isCityViewable);
    }

    private final void updateHiddenUnitMarkers(boolean isCityViewable) {
        for (Actor marker : this.listOfHiddenUnitMarkers) {
            CityTable cityTable = this.cityTable;
            if (cityTable == null) {
                Intrinsics.throwUninitializedPropertyAccessException("cityTable");
                cityTable = null;
            }
            cityTable.removeActor(marker);
        }
        this.listOfHiddenUnitMarkers.clear();
        if (!isCityViewable) {
            return;
        }
        if (!this.isButtonMoved && this.tileGroup.getTile().getCivilianUnit() != null) {
            this.insertHiddenUnitMarker(HiddenUnitMarkerPosition.Center);
        }
        Sequence<Tile> tilesAroundCity2 = this.tileGroup.getTile().getNeighbors();
        Iterator<Tile> iterator2 = tilesAroundCity2.iterator();
        while (iterator2.hasNext()) {
            Tile tile = iterator2.next();
            Vector2 direction = this.tileGroup.getTile().getPosition().cpy().sub(tile.getPosition());
            if (this.isButtonMoved) {
                if (tile.getCivilianUnit() != null && direction.epsilonEquals(0.0f, 1.0f)) {
                    this.insertHiddenUnitMarker(HiddenUnitMarkerPosition.Left);
                    continue;
                }
                if (tile.getMilitaryUnit() != null && !tile.hasEnemyInvisibleUnit(this.viewingPlayer) && direction.epsilonEquals(1.0f, 1.0f)) {
                    this.insertHiddenUnitMarker(HiddenUnitMarkerPosition.Center);
                    continue;
                }
                if (tile.getCivilianUnit() == null || !direction.epsilonEquals(1.0f, 0.0f)) continue;
                this.insertHiddenUnitMarker(HiddenUnitMarkerPosition.Right);
                continue;
            }
            if (tile.getMilitaryUnit() == null || tile.hasEnemyInvisibleUnit(this.viewingPlayer)) continue;
            if (direction.epsilonEquals(0.0f, 1.0f)) {
                this.insertHiddenUnitMarker(HiddenUnitMarkerPosition.Left);
                continue;
            }
            if (!direction.epsilonEquals(1.0f, 0.0f)) continue;
            this.insertHiddenUnitMarker(HiddenUnitMarkerPosition.Right);
        }
    }

    private final void insertHiddenUnitMarker(HiddenUnitMarkerPosition pos) {
        Image image2;
        CityTable cityTable = this.cityTable;
        if (cityTable == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cityTable");
            cityTable = null;
        }
        float positionX = cityTable.getWidth() / (float)2 + (float)(pos.ordinal() - 1) * 60.0f;
        Image $this$insertHiddenUnitMarker_u24lambda_u240 = image2 = ImageGetter.INSTANCE.getTriangle();
        boolean bl = false;
        $this$insertHiddenUnitMarker_u24lambda_u240.setColor(this.city.getCiv().getNation().getInnerColor());
        $this$insertHiddenUnitMarker_u24lambda_u240.setSize(12.0f, 8.0f);
        $this$insertHiddenUnitMarker_u24lambda_u240.setOrigin(1);
        if (!this.isButtonMoved) {
            $this$insertHiddenUnitMarker_u24lambda_u240.setRotation(180.0f);
            $this$insertHiddenUnitMarker_u24lambda_u240.setPosition(positionX - $this$insertHiddenUnitMarker_u24lambda_u240.getWidth() / (float)2, -$this$insertHiddenUnitMarker_u24lambda_u240.getHeight());
        } else {
            $this$insertHiddenUnitMarker_u24lambda_u240.setPosition(positionX - $this$insertHiddenUnitMarker_u24lambda_u240.getWidth() / (float)2, -$this$insertHiddenUnitMarker_u24lambda_u240.getHeight());
        }
        Image indicator = image2;
        CityTable cityTable2 = this.cityTable;
        if (cityTable2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("cityTable");
            cityTable2 = null;
        }
        cityTable2.addActor(indicator);
        this.listOfHiddenUnitMarkers.add(indicator);
    }

    private final boolean belongsToViewingCiv() {
        return Intrinsics.areEqual(this.city.getCiv(), this.viewingPlayer);
    }

    private final void setButtonActions() {
        UnitTable unitTable = GUI.INSTANCE.getUnitTable();
        this.setTouchable(Touchable.childrenOnly);
        ActivationExtensionsKt.onClick(this, new Function0<Unit>(this, unitTable){
            final /* synthetic */ CityButton this$0;
            final /* synthetic */ UnitTable $unitTable;
            {
                this.this$0 = $receiver;
                this.$unitTable = $unitTable;
                super(0);
            }

            public final void invoke() {
                block5: {
                    block6: {
                        block4: {
                            if (!CityButton.access$isButtonMoved$p(this.this$0)) break block4;
                            CityButton.access$setButtonActions$enterCityOrInfoPopup(this.this$0, this.$unitTable);
                            break block5;
                        }
                        this.this$0.moveButtonDown();
                        if (this.$unitTable.getSelectedUnit() == null) break block6;
                        MapUnit mapUnit = this.$unitTable.getSelectedUnit();
                        Intrinsics.checkNotNull(mapUnit);
                        if (!(mapUnit.getCurrentMovement() == 0.0f)) break block5;
                    }
                    if (CityButton.access$belongsToViewingCiv(this.this$0)) {
                        this.$unitTable.citySelected(this.this$0.getCity());
                    }
                }
            }
        });
        ActivationExtensionsKt.onRightClick$default(this, null, new Function0<Unit>(this, unitTable){
            final /* synthetic */ CityButton this$0;
            final /* synthetic */ UnitTable $unitTable;
            {
                this.this$0 = $receiver;
                this.$unitTable = $unitTable;
                super(0, Intrinsics.Kotlin.class, "enterCityOrInfoPopup", "setButtonActions$enterCityOrInfoPopup(Lcom/unciv/ui/components/tilegroups/CityButton;Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;)V", 0);
            }

            public final void invoke() {
                CityButton.access$setButtonActions$enterCityOrInfoPopup(this.this$0, this.$unitTable);
            }
        }, 1, null);
        if (!Intrinsics.areEqual(unitTable.getSelectedCity(), this.city)) {
            MapUnit mapUnit = unitTable.getSelectedUnit();
            if (!Intrinsics.areEqual(mapUnit != null ? mapUnit.getCurrentTile() : null, this.city.getCenterTile()) && unitTable.getSelectedSpy() == null) {
                this.moveButtonUp();
            }
        }
    }

    public final void moveButtonDown() {
        if (this.isButtonMoved) {
            return;
        }
        SequenceAction moveButtonAction = Actions.sequence((Action)Actions.moveTo(this.tileGroup.getX(), this.tileGroup.getY() - this.getHeight(), 0.4f, Interpolation.swingOut), (Action)Actions.run(() -> CityButton.moveButtonDown$lambda$1(this)));
        this.getParent().addAction(moveButtonAction);
    }

    public final void moveButtonUp() {
        if (!this.isButtonMoved) {
            return;
        }
        SequenceAction floatAction = Actions.sequence((Action)Actions.moveTo(this.tileGroup.getX(), this.tileGroup.getY(), 0.4f, Interpolation.sine), (Action)Actions.run(() -> CityButton.moveButtonUp$lambda$2(this)));
        this.getParent().addAction(floatAction);
    }

    private final void foreignCityInfoPopup() {
        Popup popup2;
        if (!this.city.getCiv().getGameInfo().isReligionEnabled()) {
            CityButton.foreignCityInfoPopup$openDiplomacy(this);
            return;
        }
        Popup $this$foreignCityInfoPopup_u24lambda_u243 = popup2 = new Popup(GUI.INSTANCE.getWorldScreen(), null, 0.0f, 6, null);
        boolean bl = false;
        $this$foreignCityInfoPopup_u24lambda_u243.setName("ForeignCityInfoPopup");
        $this$foreignCityInfoPopup_u24lambda_u243.add((Actor)new CityTable(this.city, true)).fillX().padBottom(5.0f).colspan(3).row();
        $this$foreignCityInfoPopup_u24lambda_u243.add((Actor)new CityReligionInfoTable(this.city.getReligion(), true)).colspan(3).row();
        Popup.addOKButton$default($this$foreignCityInfoPopup_u24lambda_u243, "Diplomacy", null, null, null, new Function0<Unit>(this){
            final /* synthetic */ CityButton this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                CityButton.access$foreignCityInfoPopup$openDiplomacy(this.this$0);
            }
        }, 14, null);
        $this$foreignCityInfoPopup_u24lambda_u243.add().expandX();
        Popup.addCloseButton$default($this$foreignCityInfoPopup_u24lambda_u243, null, null, null, foreignCityInfoPopup.popup.1.2.INSTANCE, 7, null);
        Popup popup3 = popup2;
        Popup.open$default(popup3, false, 1, null);
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    @Override
    public void act(float delta) {
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final void setButtonActions$enterCityOrInfoPopup(CityButton this$0, UnitTable unitTable) {
        block4: {
            block3: {
                if (DebugUtils.INSTANCE.getVISIBLE_MAP() || this$0.viewingPlayer.isSpectator() || this$0.belongsToViewingCiv() && !CollectionsKt.contains((Iterable)this$0.tileGroup.getTile().getAirUnits(), unitTable.getSelectedUnit())) break block3;
                if (!this$0.city.getCiv().getGameInfo().isEspionageEnabled()) break block4;
                Spy spy = this$0.viewingPlayer.getEspionageManager().getSpyAssignedToCity(this$0.city);
                boolean bl = spy != null ? spy.isSetUp() : false;
                if (!bl) break block4;
            }
            GUI.INSTANCE.pushScreen(new CityScreen(this$0.city, null, null, null, 14, null));
            return;
        }
        if (!this$0.viewingPlayer.knows(this$0.city.getCiv())) return;
        this$0.foreignCityInfoPopup();
    }

    private static final void moveButtonDown$lambda$1(CityButton this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.isButtonMoved = true;
        this$0.updateHiddenUnitMarkers(this$0.isViewable);
    }

    private static final void moveButtonUp$lambda$2(CityButton this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.isButtonMoved = false;
        this$0.updateHiddenUnitMarkers(this$0.isViewable);
    }

    private static final void foreignCityInfoPopup$openDiplomacy(CityButton this$0) {
        GUI.INSTANCE.pushScreen(new DiplomacyScreen(this$0.viewingPlayer, this$0.city.getCiv(), null, false, 12, null));
    }

    public static final /* synthetic */ boolean access$isButtonMoved$p(CityButton $this) {
        return $this.isButtonMoved;
    }

    public static final /* synthetic */ void access$setButtonActions$enterCityOrInfoPopup(CityButton this$0, UnitTable unitTable) {
        CityButton.setButtonActions$enterCityOrInfoPopup(this$0, unitTable);
    }

    public static final /* synthetic */ boolean access$belongsToViewingCiv(CityButton $this) {
        return $this.belongsToViewingCiv();
    }

    public static final /* synthetic */ void access$foreignCityInfoPopup$openDiplomacy(CityButton this$0) {
        CityButton.foreignCityInfoPopup$openDiplomacy(this$0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/components/tilegroups/CityButton$Companion;", "", "()V", "ColorConstruction", "Lcom/badlogic/gdx/graphics/Color;", "getColorConstruction", "()Lcom/badlogic/gdx/graphics/Color;", "ColorGrowth", "getColorGrowth", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getColorConstruction() {
            return ColorConstruction;
        }

        @NotNull
        public final Color getColorGrowth() {
            return ColorGrowth;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/components/tilegroups/CityButton$HiddenUnitMarkerPosition;", "", "(Ljava/lang/String;I)V", "Left", "Center", "Right", "core"})
    private static final class HiddenUnitMarkerPosition
    extends Enum<HiddenUnitMarkerPosition> {
        public static final /* enum */ HiddenUnitMarkerPosition Left = new HiddenUnitMarkerPosition();
        public static final /* enum */ HiddenUnitMarkerPosition Center = new HiddenUnitMarkerPosition();
        public static final /* enum */ HiddenUnitMarkerPosition Right = new HiddenUnitMarkerPosition();
        private static final /* synthetic */ HiddenUnitMarkerPosition[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static HiddenUnitMarkerPosition[] values() {
            return (HiddenUnitMarkerPosition[])$VALUES.clone();
        }

        public static HiddenUnitMarkerPosition valueOf(String value) {
            return Enum.valueOf(HiddenUnitMarkerPosition.class, value);
        }

        @NotNull
        public static EnumEntries<HiddenUnitMarkerPosition> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = hiddenUnitMarkerPositionArray = new HiddenUnitMarkerPosition[]{HiddenUnitMarkerPosition.Left, HiddenUnitMarkerPosition.Center, HiddenUnitMarkerPosition.Right};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

