/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import com.unciv.GUI;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.tilegroups.CityButton;
import com.unciv.ui.components.widgets.BorderedTable;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.utils.DebugUtils;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\r"}, d2={"Lcom/unciv/ui/components/tilegroups/CityTable;", "Lcom/unciv/ui/components/widgets/BorderedTable;", "city", "Lcom/unciv/logic/city/City;", "forPopup", "", "(Lcom/unciv/logic/city/City;Z)V", "addCityConstruction", "", "addCityGrowthBar", "addCityPopNumber", "addCityText", "addCivIcon", "core"})
@SourceDebugExtension(value={"SMAP\nCityButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityButton.kt\ncom/unciv/ui/components/tilegroups/CityTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,622:1\n1#2:623\n*E\n"})
final class CityTable
extends BorderedTable {
    public CityTable(@NotNull City city2, boolean forPopup) {
        Color color;
        Color color2;
        Intrinsics.checkNotNullParameter(city2, "city");
        super("WorldScreen/CityButton/IconTable", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleMidShape(), BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleMidBorderShape());
        this.setTransform(false);
        this.setTouchable(Touchable.enabled);
        Civilization selectedCiv = GUI.INSTANCE.getSelectedPlayer();
        Civilization viewingCiv = GUI.INSTANCE.getViewingPlayer();
        if (Intrinsics.areEqual(city2.getCiv(), selectedCiv)) {
            color2 = Scene2dExtensionsKt.colorFromRGB(233, 233, 172);
        } else if (city2.getCiv().isAtWarWith(selectedCiv)) {
            color2 = Scene2dExtensionsKt.colorFromRGB(230, 51, 0);
        } else {
            Color color3 = Color.BLACK;
            color2 = color3;
            Intrinsics.checkNotNullExpressionValue(color3, "BLACK");
        }
        this.setBgBorderColor(color2);
        this.setBorderSize(Intrinsics.areEqual(city2.getCiv(), selectedCiv) ? 4.0f : (city2.getCiv().isAtWarWith(selectedCiv) ? 4.0f : 2.0f));
        Color color4 = color = city2.getCiv().getNation().getOuterColor().cpy();
        CityTable cityTable = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.a = 0.9f;
        Color color5 = color;
        Intrinsics.checkNotNullExpressionValue(color5, "apply(...)");
        cityTable.setBgColor(color5);
        this.setBorderOnTop(Intrinsics.areEqual(city2.getCiv(), selectedCiv));
        this.pad(0.0f);
        this.defaults().pad(0.0f);
        boolean isShowDetailedInfo = DebugUtils.INSTANCE.getVISIBLE_MAP() || Intrinsics.areEqual(city2.getCiv(), selectedCiv) || viewingCiv.isSpectator();
        this.addCityPopNumber(city2);
        if (isShowDetailedInfo) {
            this.addCityGrowthBar(city2);
        }
        this.addCityText(city2, forPopup);
        if (isShowDetailedInfo) {
            this.addCityConstruction(city2);
        }
        if (!Intrinsics.areEqual(city2.getCiv(), viewingCiv)) {
            this.addCivIcon(city2);
        }
        this.getCells().first().padLeft(4.0f);
        Array<Cell> array = this.getCells();
        Intrinsics.checkNotNullExpressionValue(array, "getCells(...)");
        ((Cell)CollectionsKt.last((Iterable)array)).padRight(4.0f);
    }

    public /* synthetic */ CityTable(City city2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(city2, bl);
    }

    private final void addCityPopNumber(City city2) {
        Color textColor = city2.getCiv().getNation().getInnerColor();
        Label popLabel = Scene2dExtensionsKt.toLabel$default(String.valueOf(city2.getPopulation().getPopulation()), textColor, 18, 1, false, 8, null);
        this.add((Actor)popLabel).minWidth(26.0f);
    }

    private final void addCityGrowthBar(City city2) {
        String turnLabelText;
        Integer turnsToStarvation;
        Integer turnsToGrowth;
        Color textColor = city2.getCiv().getNation().getInnerColor();
        Table table2 = new Table();
        float growthPercentage = (float)city2.getPopulation().getFoodStored() / (float)city2.getPopulation().getFoodToNextPopulation();
        if (growthPercentage < 0.0f) {
            growthPercentage = 0.0f;
        }
        if (growthPercentage > 1.0f) {
            growthPercentage = 1.0f;
        }
        float f = city2.isStarving() ? 1.0f : growthPercentage;
        Color color = city2.isStarving() ? Color.RED : CityButton.Companion.getColorGrowth();
        Intrinsics.checkNotNull(color);
        Color color2 = Color.BLACK;
        Intrinsics.checkNotNullExpressionValue(color2, "BLACK");
        ImageGetter.ProgressBar growthBar = ImageGetter.INSTANCE.getProgressBarVertical(4.0f, 30.0f, f, color, color2, 1.0f);
        growthBar.getColor().a = 0.8f;
        String string = city2.isGrowing() ? ((turnsToGrowth = city2.getPopulation().getNumTurnsToNewPopulation()) != null && turnsToGrowth < 100 ? turnsToGrowth.toString() : "\u221e") : (city2.isStarving() ? ((turnsToStarvation = city2.getPopulation().getNumTurnsToStarvation()) != null && turnsToStarvation < 100 ? turnsToStarvation.toString() : "\u221e") : (turnLabelText = "-"));
        if (city2.isGrowing()) {
            float nextTurnPercentage = (float)(city2.foodForNextTurn() + city2.getPopulation().getFoodStored()) / (float)city2.getPopulation().getFoodToNextPopulation();
            if (nextTurnPercentage < 0.0f) {
                nextTurnPercentage = 0.0f;
            }
            if (nextTurnPercentage > 1.0f) {
                nextTurnPercentage = 1.0f;
            }
            Color color3 = CityButton.Companion.getColorGrowth().cpy();
            Intrinsics.checkNotNullExpressionValue(color3, "cpy(...)");
            growthBar.setSemiProgress(Scene2dExtensionsKt.darken(color3, 0.4f), nextTurnPercentage, 1.0f);
        }
        Label turnLabel = Scene2dExtensionsKt.toLabel$default(turnLabelText, textColor, 13, 0, false, 12, null);
        table2.add((Actor)growthBar).padRight(2.0f);
        table2.add((Actor)turnLabel).expandY().bottom();
        this.add((Actor)table2).minWidth(6.0f).padLeft(2.0f);
    }

    private final void addCityText(City city2, boolean forPopup) {
        Religion cityReligion;
        Color textColor = city2.getCiv().getNation().getInnerColor();
        Table table2 = new Table();
        Actor $this$addCityText_u24lambda_u241 = table2;
        boolean bl = false;
        ((Group)$this$addCityText_u24lambda_u241).setTransform(false);
        Table table3 = table2;
        if (city2.isCapital()) {
            Actor actor;
            if (city2.getCiv().isCityState()) {
                Actor $this$addCityText_u24lambda_u242 = $this$addCityText_u24lambda_u241 = ImageGetter.INSTANCE.getNationIcon("CityState");
                boolean bl2 = false;
                $this$addCityText_u24lambda_u242.setColor(textColor);
                actor = $this$addCityText_u24lambda_u241;
            } else {
                actor = ImageGetter.INSTANCE.getImage("OtherIcons/Capital");
            }
            Image capitalIcon = actor;
            table3.add((Actor)capitalIcon).size(20.0f).padRight(5.0f);
        }
        Label cityName = Scene2dExtensionsKt.toLabel$default(city2.getName(), textColor, 0, 1, true, 2, null);
        table3.add((Actor)cityName).growY().center();
        if (!forPopup && (cityReligion = city2.getReligion().getMajorityReligion()) != null) {
            Image image2;
            Image $this$addCityText_u24lambda_u243 = image2 = ImageGetter.INSTANCE.getReligionIcon(cityReligion.getIconName());
            boolean bl3 = false;
            $this$addCityText_u24lambda_u243.setColor(textColor);
            Group religionImage = Scene2dExtensionsKt.toGroup(image2, 20.0f);
            table3.add((Actor)religionImage).size(20.0f).padLeft(5.0f);
        }
        table3.pack();
        this.add((Actor)table3).minHeight(34.0f).padLeft(10.0f).padRight(10.0f).expandY().center();
    }

    private final void addCityConstruction(City city2) {
        Color textColor = city2.getCiv().getNation().getInnerColor();
        CityConstructions cityConstructions = city2.getCityConstructions();
        IConstruction cityCurrentConstruction = cityConstructions.getCurrentConstruction();
        Table progressTable = new Table();
        float nextTurnPercentage = 0.0f;
        float percentage = 0.0f;
        String turns = "-";
        Group icon = null;
        if (((CharSequence)cityConstructions.getCurrentConstructionFromQueue()).length() > 0) {
            if (!(cityCurrentConstruction instanceof PerpetualConstruction)) {
                int turnsToConstruction = CityConstructions.turnsToConstruction$default(cityConstructions, cityCurrentConstruction.getName(), false, 2, null);
                if (turnsToConstruction < 100) {
                    turns = String.valueOf(turnsToConstruction);
                }
                float f = cityConstructions.getWorkDone(cityCurrentConstruction.getName());
                Intrinsics.checkNotNull(cityCurrentConstruction, "null cannot be cast to non-null type com.unciv.models.ruleset.INonPerpetualConstruction");
                percentage = f / (float)((INonPerpetualConstruction)cityCurrentConstruction).getProductionCost(cityConstructions.getCity().getCiv(), cityConstructions.getCity());
                nextTurnPercentage = ((float)cityConstructions.getWorkDone(cityCurrentConstruction.getName()) + city2.getCityStats().getCurrentCityStats().getProduction()) / (float)((INonPerpetualConstruction)cityCurrentConstruction).getProductionCost(cityConstructions.getCity().getCiv(), cityConstructions.getCity());
                if (nextTurnPercentage > 1.0f) {
                    nextTurnPercentage = 1.0f;
                }
                if (nextTurnPercentage < 0.0f) {
                    nextTurnPercentage = 0.0f;
                }
            } else {
                turns = "\u221e";
            }
            icon = ImageGetter.INSTANCE.getConstructionPortrait(cityCurrentConstruction.getName(), 24.0f);
        }
        Color color = CityButton.Companion.getColorConstruction();
        Color color2 = Color.BLACK;
        Intrinsics.checkNotNullExpressionValue(color2, "BLACK");
        ImageGetter.ProgressBar productionBar = ImageGetter.INSTANCE.getProgressBarVertical(4.0f, 30.0f, percentage, color, color2, 1.0f);
        Color color3 = CityButton.Companion.getColorConstruction().cpy();
        Intrinsics.checkNotNullExpressionValue(color3, "cpy(...)");
        productionBar.setSemiProgress(Scene2dExtensionsKt.darken(color3, 0.4f), nextTurnPercentage, 1.0f);
        productionBar.getColor().a = 0.8f;
        progressTable.add((Actor)Scene2dExtensionsKt.toLabel$default(turns, textColor, 13, 0, false, 12, null)).expandY().bottom();
        progressTable.add((Actor)productionBar).padLeft(2.0f);
        this.add((Actor)progressTable).minWidth(6.0f).padRight(2.0f);
        this.add((Actor)icon).minWidth(26.0f);
    }

    private final void addCivIcon(City city2) {
        Image icon = city2.getCiv().isMajorCiv() ? ImageGetter.INSTANCE.getNationIcon(city2.getCiv().getNation().getName()) : ImageGetter.INSTANCE.getImage("CityStateIcons/" + city2.getCiv().getCityStateType().getName());
        icon.setColor(city2.getCiv().getNation().getInnerColor());
        this.add((Actor)Scene2dExtensionsKt.toGroup(icon, 20.0f)).minWidth(26.0f);
    }
}

