/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.GUI;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.TutorialTrigger;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/ui/components/tilegroups/StatusTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "city", "Lcom/unciv/logic/city/City;", "iconSize", "", "(Lcom/unciv/logic/city/City;F)V", "core"})
final class StatusTable
extends Table {
    public StatusTable(@NotNull City city2, float iconSize) {
        Intrinsics.checkNotNullParameter(city2, "city");
        float padBetween = 2.0f;
        Civilization selectedCiv = GUI.INSTANCE.getSelectedPlayer();
        if (Intrinsics.areEqual(city2.getCiv(), selectedCiv)) {
            Image connectionImage;
            if (city2.isBlockaded()) {
                connectionImage = ImageGetter.INSTANCE.getImage("OtherIcons/Blockade");
                this.add((Actor)connectionImage).size(iconSize);
                BaseScreen.displayTutorial$default(GUI.INSTANCE.getWorldScreen(), TutorialTrigger.CityBlockade, null, 2, null);
            } else if (!city2.isCapital() && City.isConnectedToCapital$default(city2, null, 1, null)) {
                connectionImage = ImageGetter.INSTANCE.getStatIcon("CityConnection");
                this.add((Actor)connectionImage).size(iconSize);
            }
        }
        if (city2.isInResistance()) {
            Image resistanceImage = ImageGetter.INSTANCE.getImage("StatIcons/Resistance");
            this.add((Actor)resistanceImage).size(iconSize).padLeft(padBetween);
        }
        if (city2.isPuppet()) {
            Image puppetImage = ImageGetter.INSTANCE.getImage("OtherIcons/Puppet");
            this.add((Actor)puppetImage).size(iconSize).padLeft(padBetween);
        }
        if (city2.isBeingRazed()) {
            Image fireImage = ImageGetter.INSTANCE.getImage("OtherIcons/Fire");
            this.add((Actor)fireImage).size(iconSize).padLeft(padBetween);
        }
        if (Intrinsics.areEqual(city2.getCiv(), selectedCiv) && city2.isWeLoveTheKingDayActive()) {
            Image wltkdImage = ImageGetter.INSTANCE.getImage("OtherIcons/WLTKD");
            this.add((Actor)wltkdImage).size(iconSize).padLeft(padBetween);
        }
    }

    public /* synthetic */ StatusTable(City city2, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 18.0f;
        }
        this(city2, f);
    }
}

