/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.layers;

import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.tilesets.TileSetCache;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.TileSetStrings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0014J\u001c\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH$J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u001a\u0010\u0016\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u001b\u0010\u0017\u001a\u00020\u0018*\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/unciv/ui/components/tilegroups/layers/TileLayer;", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "tileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "size", "", "(Lcom/unciv/ui/components/tilegroups/TileGroup;F)V", "getTileGroup", "()Lcom/unciv/ui/components/tilegroups/TileGroup;", "determineVisibility", "", "doUpdate", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "isViewable", "", "strings", "Lcom/unciv/ui/components/tilegroups/TileSetStrings;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "update", "setHexagonSize", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "scale", "(Lcom/badlogic/gdx/scenes/scene2d/ui/Image;Ljava/lang/Float;)Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "core"})
public abstract class TileLayer
extends Group {
    @NotNull
    private final TileGroup tileGroup;

    public TileLayer(@NotNull TileGroup tileGroup, float size2) {
        Intrinsics.checkNotNullParameter(tileGroup, "tileGroup");
        this.tileGroup = tileGroup;
        this.setTouchable(Touchable.disabled);
        this.setTransform(false);
        this.setSize(size2, size2);
    }

    @NotNull
    public final TileGroup getTileGroup() {
        return this.tileGroup;
    }

    @NotNull
    public final Tile tile() {
        return this.tileGroup.getTile();
    }

    @NotNull
    public final TileSetStrings strings() {
        return this.tileGroup.getTileSetStrings();
    }

    @NotNull
    public final Image setHexagonSize(@NotNull Image $this$setHexagonSize, @Nullable Float scale) {
        Intrinsics.checkNotNullParameter($this$setHexagonSize, "<this>");
        $this$setHexagonSize.setSize(this.tileGroup.getHexagonImageWidth(), $this$setHexagonSize.getHeight() * this.tileGroup.getHexagonImageWidth() / $this$setHexagonSize.getWidth());
        $this$setHexagonSize.setOrigin(((Number)this.tileGroup.getHexagonImageOrigin().getFirst()).floatValue(), ((Number)this.tileGroup.getHexagonImageOrigin().getSecond()).floatValue());
        $this$setHexagonSize.setX(((Number)this.tileGroup.getHexagonImagePosition().getFirst()).floatValue());
        $this$setHexagonSize.setY(((Number)this.tileGroup.getHexagonImagePosition().getSecond()).floatValue());
        Float f = scale;
        $this$setHexagonSize.setScale(f != null ? f.floatValue() : TileSetCache.INSTANCE.getCurrent().getConfig().getTileScale());
        return $this$setHexagonSize;
    }

    public static /* synthetic */ Image setHexagonSize$default(TileLayer tileLayer, Image image2, Float f, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setHexagonSize");
        }
        if ((n & 1) != 0) {
            f = null;
        }
        return tileLayer.setHexagonSize(image2, f);
    }

    public final boolean isViewable(@NotNull Civilization viewingCiv) {
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        return this.tileGroup.isViewable(viewingCiv);
    }

    public final void update(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        this.doUpdate(viewingCiv, localUniqueCache);
        this.determineVisibility();
    }

    public static /* synthetic */ void update$default(TileLayer tileLayer, Civilization civilization, LocalUniqueCache localUniqueCache, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 2) != 0) {
            localUniqueCache = new LocalUniqueCache(false);
        }
        tileLayer.update(civilization, localUniqueCache);
    }

    protected void determineVisibility() {
        this.setVisible(this.hasChildren());
    }

    protected abstract void doUpdate(@Nullable Civilization var1, @NotNull LocalUniqueCache var2);

    public static /* synthetic */ void doUpdate$default(TileLayer tileLayer, Civilization civilization, LocalUniqueCache localUniqueCache, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doUpdate");
        }
        if ((n & 2) != 0) {
            localUniqueCache = new LocalUniqueCache(false);
        }
        tileLayer.doUpdate(civilization, localUniqueCache);
    }
}

