/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.layers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.HexMath;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.ui.components.MapArrowType;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.tilegroups.CityTileGroup;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.WorldTileGroup;
import com.unciv.ui.components.tilegroups.YieldGroup;
import com.unciv.ui.components.tilegroups.layers.MapArrow;
import com.unciv.ui.components.tilegroups.layers.TileLayer;
import com.unciv.ui.components.tilegroups.layers.TileLayerMisc;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import com.unciv.utils.DebugUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0005H\u0016J\u0016\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020\u000bJ\b\u0010.\u001a\u00020#H\u0002J\b\u0010/\u001a\u00020#H\u0014J\u000e\u00100\u001a\u00020#2\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020#2\u0006\u00101\u001a\u000202J\u000e\u00104\u001a\u00020#2\u0006\u00101\u001a\u000202J\u000e\u00105\u001a\u00020#2\u0006\u00101\u001a\u000202J\u001a\u00106\u001a\u00020#2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020:H\u0014J\u0006\u0010;\u001a\u00020#J\"\u0010<\u001a\u0004\u0018\u00010\u000b2\u0006\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\u00052\u0006\u0010?\u001a\u000202H\u0016J\u000e\u0010@\u001a\u00020#2\u0006\u0010*\u001a\u00020+J\u0016\u0010@\u001a\u00020#2\u0006\u0010*\u001a\u00020+2\u0006\u0010A\u001a\u00020\u0005J\u0006\u0010B\u001a\u00020#J\u0006\u0010C\u001a\u00020#J\u000e\u0010D\u001a\u00020#2\u0006\u00109\u001a\u00020:J\u0006\u0010E\u001a\u00020#J\u000e\u0010F\u001a\u00020#2\u0006\u0010G\u001a\u000202J\b\u0010H\u001a\u00020#H\u0002J\u001a\u0010I\u001a\u00020#2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u0010J\u001a\u000202H\u0002J\u001a\u0010K\u001a\u00020#2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u0010J\u001a\u000202H\u0002J\u0010\u0010L\u001a\u00020#2\u0006\u0010J\u001a\u000202H\u0002J\"\u0010M\u001a\u00020#2\b\u00107\u001a\u0004\u0018\u0001082\u0006\u0010J\u001a\u0002022\u0006\u00109\u001a\u00020:H\u0002RJ\u0010\u0007\u001a>\u0012\u0004\u0012\u00020\t\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f0\bj\u001e\u0012\u0004\u0012\u00020\t\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\nj\b\u0012\u0004\u0012\u00020\u000f`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/unciv/ui/components/tilegroups/layers/TileLayerMisc;", "Lcom/unciv/ui/components/tilegroups/layers/TileLayer;", "tileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "size", "", "(Lcom/unciv/ui/components/tilegroups/TileGroup;F)V", "arrows", "Ljava/util/HashMap;", "Lcom/unciv/logic/map/tile/Tile;", "Ljava/util/ArrayList;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "Lkotlin/collections/ArrayList;", "Lkotlin/collections/HashMap;", "arrowsToDraw", "Lcom/unciv/ui/components/tilegroups/layers/MapArrow;", "hexOutlineIcon", "<set-?>", "improvementIcon", "getImprovementIcon", "()Lcom/badlogic/gdx/scenes/scene2d/Actor;", "improvementPlusPillagedID", "", "resourceAmount", "", "resourceIcon", "resourceName", "startingLocationIcons", "", "terrainOverlay", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "workedIcon", "yields", "Lcom/unciv/ui/components/tilegroups/YieldGroup;", "act", "", "delta", "addArrow", "targetTile", "type", "Lcom/unciv/ui/components/MapArrowType;", "addHexOutline", "color", "Lcom/badlogic/gdx/graphics/Color;", "addWorkedIcon", "icon", "clearArrows", "determineVisibility", "dimImprovement", "dim", "", "dimPopulation", "dimResource", "dimYields", "doUpdate", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "hideTerrainOverlay", "hit", "x", "y", "touchable", "overlayTerrain", "alpha", "removeHexOutline", "removeWorkedIcon", "reset", "resetArrows", "setYieldVisible", "isVisible", "updateArrows", "updateImprovementIcon", "show", "updateResourceIcon", "updateStartingLocationIcon", "updateYieldIcon", "core"})
@SourceDebugExtension(value={"SMAP\nTileLayerMisc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileLayerMisc.kt\ncom/unciv/ui/components/tilegroups/layers/TileLayerMisc\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,412:1\n1855#2,2:413\n1#3:415\n*S KotlinDebug\n*F\n+ 1 TileLayerMisc.kt\ncom/unciv/ui/components/tilegroups/layers/TileLayerMisc\n*L\n211#1:413,2\n*E\n"})
public final class TileLayerMisc
extends TileLayer {
    @NotNull
    private final Image terrainOverlay;
    @NotNull
    private final YieldGroup yields;
    @NotNull
    private final ArrayList<MapArrow> arrowsToDraw;
    @NotNull
    private final HashMap<Tile, ArrayList<Actor>> arrows;
    @Nullable
    private Actor hexOutlineIcon;
    @Nullable
    private String resourceName;
    private int resourceAmount;
    @Nullable
    private Actor resourceIcon;
    @Nullable
    private Actor workedIcon;
    @Nullable
    private String improvementPlusPillagedID;
    @Nullable
    private Actor improvementIcon;
    @NotNull
    private final List<Actor> startingLocationIcons;

    /*
     * WARNING - void declaration
     */
    public TileLayerMisc(@NotNull TileGroup tileGroup, float size2) {
        void $this$yields_u24lambda_u240;
        YieldGroup yieldGroup;
        Intrinsics.checkNotNullParameter(tileGroup, "tileGroup");
        super(tileGroup, size2);
        this.terrainOverlay = TileLayer.setHexagonSize$default(this, ImageGetter.INSTANCE.getImage(this.strings().getHexagon()), null, 1, null);
        this.terrainOverlay.setVisible(false);
        this.addActor(this.terrainOverlay);
        YieldGroup yieldGroup2 = yieldGroup = new YieldGroup();
        TileLayerMisc tileLayerMisc = this;
        boolean bl = false;
        $this$yields_u24lambda_u240.setVisible(false);
        $this$yields_u24lambda_u240.setOrigin(1);
        $this$yields_u24lambda_u240.setScale(0.7f);
        $this$yields_u24lambda_u240.setY(tileGroup.getHeight() * 0.25f - $this$yields_u24lambda_u240.getHeight() / (float)2);
        this.addActor((Actor)$this$yields_u24lambda_u240);
        tileLayerMisc.yields = yieldGroup;
        this.arrowsToDraw = new ArrayList();
        this.arrows = new HashMap();
        this.resourceAmount = -1;
        this.startingLocationIcons = new ArrayList();
    }

    @Override
    public void act(float delta) {
    }

    @Override
    @Nullable
    public Actor hit(float x, float y, boolean touchable) {
        Actor actor;
        if (this.workedIcon == null) {
            actor = null;
        } else {
            Vector2 coords = new Vector2(x, y);
            Actor actor2 = this.workedIcon;
            Intrinsics.checkNotNull(actor2);
            actor2.parentToLocalCoordinates(coords);
            Actor actor3 = this.workedIcon;
            Intrinsics.checkNotNull(actor3);
            actor = actor3.hit(coords.x, coords.y, touchable);
        }
        return actor;
    }

    @Nullable
    public final Actor getImprovementIcon() {
        return this.improvementIcon;
    }

    private final void clearArrows() {
        for (ArrayList<Actor> actorList : this.arrows.values()) {
            for (Actor actor : actorList) {
                actor.remove();
            }
        }
        this.arrows.clear();
    }

    private final void updateArrows() {
        this.clearArrows();
        float tileScale = 40.0f;
        for (MapArrow arrowToAdd : this.arrowsToDraw) {
            Tile targetTile = arrowToAdd.getTargetTile();
            Vector2 targetPos = new Vector2(targetTile.getPosition());
            if (this.tile().getTileMap().getMapParameters().getWorldWrap()) {
                targetPos = HexMath.INSTANCE.getUnwrappedNearestTo(targetPos, this.tile().getPosition(), Float.valueOf(this.tile().getTileMap().getMaxLongitude()));
            }
            Vector2 targetRelative = HexMath.INSTANCE.hex2WorldCoords(targetPos).sub(HexMath.INSTANCE.hex2WorldCoords(this.tile().getPosition()));
            float targetDistance = (float)Math.sqrt((float)Math.pow(targetRelative.x, 2) + (float)Math.pow(targetRelative.y, 2));
            float targetAngle = (float)Math.atan2(targetRelative.y, targetRelative.x);
            if (!((Map)this.arrows).containsKey(targetTile)) {
                ((Map)this.arrows).put(targetTile, new ArrayList());
            }
            Image arrowImage = arrowToAdd.getImage();
            arrowImage.moveBy(25.0f, -5.0f);
            arrowImage.setSize(tileScale * targetDistance, 60.0f);
            arrowImage.setOrigin(0.0f, 30.0f);
            arrowImage.setRotation(targetAngle / (float)Math.PI * (float)180);
            ArrayList<Actor> arrayList = this.arrows.get(targetTile);
            Intrinsics.checkNotNull(arrayList);
            arrayList.add(arrowImage);
            this.addActor(arrowImage);
        }
    }

    private final void updateImprovementIcon(Civilization viewingCiv, boolean show) {
        String newImprovementPlusPillagedID;
        String improvementToShow = this.tile().getShownImprovement(viewingCiv);
        String string = improvementToShow == null ? null : (newImprovementPlusPillagedID = this.tile().getImprovementIsPillaged() ? improvementToShow + "-Pillaged" : improvementToShow);
        if (!Intrinsics.areEqual(this.improvementPlusPillagedID, newImprovementPlusPillagedID)) {
            this.improvementPlusPillagedID = newImprovementPlusPillagedID;
            Actor actor = this.improvementIcon;
            if (actor != null) {
                actor.remove();
            }
            this.improvementIcon = null;
        }
        if (this.improvementPlusPillagedID != null && show && this.improvementIcon == null) {
            String string2 = improvementToShow;
            Intrinsics.checkNotNull(string2);
            Portrait icon = ImageGetter.getImprovementPortrait$default(ImageGetter.INSTANCE, string2, 0.0f, false, this.tile().getImprovementIsPillaged(), 2, null);
            Scene2dExtensionsKt.center((Actor)icon, this.getTileGroup());
            icon.setX(icon.getX() - (float)22);
            icon.setY(icon.getY() - (float)12);
            this.addActor(icon);
            this.improvementIcon = icon;
        }
        Actor actor = this.improvementIcon;
        if (actor != null) {
            actor.setVisible(show);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void updateResourceIcon(Civilization viewingCiv, boolean show) {
        block8: {
            block9: {
                block7: {
                    if (!this.getTileGroup().isForceVisible()) break block7;
                    v0 = show;
                    break block8;
                }
                if (!show || viewingCiv != null) break block9;
                v0 = true;
                break block8;
            }
            if (!show) ** GOTO lbl-1000
            v1 = this.tile();
            v2 = viewingCiv;
            Intrinsics.checkNotNull(v2);
            if (v1.hasViewableResource(v2)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = effectiveVisible = false;
            }
        }
        if (!Intrinsics.areEqual(this.resourceName, this.tile().getResource()) || this.resourceAmount != this.tile().getResourceAmount()) {
            this.resourceName = this.tile().getResource();
            this.resourceAmount = this.tile().getResourceAmount();
            v3 = this.resourceIcon;
            if (v3 != null) {
                v3.remove();
            }
            this.resourceIcon = null;
        }
        if (this.resourceName != null && effectiveVisible && this.resourceIcon == null) {
            v4 = this.resourceName;
            Intrinsics.checkNotNull(v4);
            icon = ImageGetter.INSTANCE.getResourcePortrait(v4, 20.0f, this.resourceAmount);
            Scene2dExtensionsKt.center((Actor)icon, this.getTileGroup());
            icon.setX(icon.getX() - (float)22);
            icon.setY(icon.getY() + (float)10);
            this.addActor(icon);
            this.resourceIcon = icon;
        }
        v5 = this.resourceIcon;
        if (v5 != null) {
            v5.setVisible(effectiveVisible);
        }
        if (this.resourceIcon != null) {
            isViewable = viewingCiv == null || this.isViewable(viewingCiv) != false;
            this.dimResource(isViewable == false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateStartingLocationIcon(boolean show) {
        Object newNationIcon;
        Object nation2;
        TileMap tilemap;
        Function1[] $this$updateStartingLocationIcon_u24lambda_u244;
        Unit unit;
        List<Actor> list2;
        String string;
        Iterable $this$forEach$iv = this.startingLocationIcons;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Actor it = (Actor)element$iv;
            boolean bl = false;
            it.remove();
        }
        this.startingLocationIcons.clear();
        if (!show || this.getTileGroup().isForMapEditorIcon()) {
            return;
        }
        if (DebugUtils.INSTANCE.getSHOW_TILE_COORDS()) {
            Label $this$updateStartingLocationIcon_u24lambda_u243;
            Object element$iv;
            String label2 = FormattingExtensionsKt.toPrettyString(this.tile().getPosition());
            Object object = Color.BLACK.cpy();
            element$iv = object;
            string = label2;
            list2 = this.startingLocationIcons;
            boolean bl = false;
            $this$updateStartingLocationIcon_u24lambda_u242.a = 0.7f;
            unit = Unit.INSTANCE;
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue(object2, "apply(...)");
            Label $i$f$forEach2 = Scene2dExtensionsKt.toLabel$default(string, (Color)object2, 14, 0, false, 12, null);
            object = $i$f$forEach2;
            boolean bl2 = false;
            this.getTileGroup().getLayerMisc().addActor($this$updateStartingLocationIcon_u24lambda_u243);
            $this$updateStartingLocationIcon_u24lambda_u243.setOrigin(1);
            Scene2dExtensionsKt.center((Actor)$this$updateStartingLocationIcon_u24lambda_u243, this.getTileGroup());
            $this$updateStartingLocationIcon_u24lambda_u243.moveBy(15.4f, -0.6f);
            list2.add($i$f$forEach2);
            Color color = Color.FIREBRICK;
            Intrinsics.checkNotNullExpressionValue(color, "FIREBRICK");
            $this$updateStartingLocationIcon_u24lambda_u243 = $i$f$forEach2 = Scene2dExtensionsKt.toLabel$default(label2, color, 14, 0, false, 12, null);
            list2 = this.startingLocationIcons;
            boolean bl3 = false;
            this.getTileGroup().getLayerMisc().addActor((Actor)$this$updateStartingLocationIcon_u24lambda_u244);
            $this$updateStartingLocationIcon_u24lambda_u244.setOrigin(1);
            Scene2dExtensionsKt.center((Actor)$this$updateStartingLocationIcon_u24lambda_u244, this.getTileGroup());
            $this$updateStartingLocationIcon_u24lambda_u244.moveBy(15.0f, 0.0f);
            list2.add($i$f$forEach2);
        }
        if ((tilemap = this.tile().getTileMap()).getStartingLocationsByNation().isEmpty()) {
            return;
        }
        $this$updateStartingLocationIcon_u24lambda_u244 = new Function1[]{updateStartingLocationIcon.nations.4.INSTANCE, updateStartingLocationIcon.nations.5.INSTANCE};
        List nations2 = SequencesKt.toList(SequencesKt.sortedWith(SequencesKt.map(SequencesKt.filter(SequencesKt.filter(MapsKt.asSequence((Map)tilemap.getStartingLocationsByNation()), (Function1)new Function1<Map.Entry<? extends String, ? extends HashSet<Tile>>, Boolean>(this){
            final /* synthetic */ TileLayerMisc this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<String, ? extends HashSet<Tile>> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getValue().contains(this.this$0.tile());
            }
        }), (Function1)new Function1<Map.Entry<? extends String, ? extends HashSet<Tile>>, Boolean>(tilemap){
            final /* synthetic */ TileMap $tilemap;
            {
                this.$tilemap = $tilemap;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<String, ? extends HashSet<Tile>> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Ruleset ruleset2 = this.$tilemap.getRuleset();
                Intrinsics.checkNotNull(ruleset2);
                return ((Map)ruleset2.getNations()).containsKey(it.getKey());
            }
        }), (Function1)new Function1<Map.Entry<? extends String, ? extends HashSet<Tile>>, Pair<? extends String, ? extends Nation>>(tilemap){
            final /* synthetic */ TileMap $tilemap;
            {
                this.$tilemap = $tilemap;
                super(1);
            }

            @NotNull
            public final Pair<String, Nation> invoke(@NotNull Map.Entry<String, ? extends HashSet<Tile>> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                String string = it.getKey();
                Ruleset ruleset2 = this.$tilemap.getRuleset();
                Intrinsics.checkNotNull(ruleset2);
                Nation nation2 = ruleset2.getNations().get(it.getKey());
                Intrinsics.checkNotNull(nation2);
                return TuplesKt.to(string, nation2);
            }
        }), ComparisonsKt.compareBy($this$updateStartingLocationIcon_u24lambda_u244)));
        if (nations2.isEmpty()) {
            return;
        }
        int displayCount = Math.min(nations2.size(), 3);
        float offsetX = 0.0f;
        offsetX = (float)(displayCount - 1) * 4.0f;
        float offsetY = 0.0f;
        offsetY = (float)(displayCount - 1) * 2.0f;
        Object object = CollectionsKt.asReversed(CollectionsKt.take(nations2, 3)).iterator();
        while (object.hasNext()) {
            Color color;
            nation2 = (Pair)object.next();
            Object b = ((Pair)nation2).getSecond();
            Intrinsics.checkNotNullExpressionValue(b, "<get-second>(...)");
            newNationIcon = ImageGetter.INSTANCE.getNationPortrait((Nation)b, 20.0f);
            this.getTileGroup().getLayerMisc().addActor((Actor)newNationIcon);
            Object $this$updateStartingLocationIcon_u24lambda_u246 = newNationIcon;
            boolean bl = false;
            ((Actor)$this$updateStartingLocationIcon_u24lambda_u246).setSize(20.0f, 20.0f);
            Scene2dExtensionsKt.center((Actor)$this$updateStartingLocationIcon_u24lambda_u246, this.getTileGroup());
            ((Actor)$this$updateStartingLocationIcon_u24lambda_u246).moveBy(offsetX, offsetY);
            Color color2 = color = Color.WHITE.cpy();
            Object object3 = $this$updateStartingLocationIcon_u24lambda_u246;
            boolean bl4 = false;
            $this$updateStartingLocationIcon_u24lambda_u246_u24lambda_u245.a = 0.6f;
            ((Actor)object3).setColor(color);
            this.startingLocationIcons.add((Actor)newNationIcon);
            offsetX -= 8.0f;
            offsetY -= 4.0f;
        }
        if (nations2.size() > 3) {
            void $this$updateStartingLocationIcon_u24lambda_u249;
            Object $this$updateStartingLocationIcon_u24lambda_u248;
            newNationIcon = nation2 = Color.BLACK.cpy();
            string = String.valueOf(nations2.size());
            list2 = this.startingLocationIcons;
            boolean bl = false;
            $this$updateStartingLocationIcon_u24lambda_u247.a = 0.7f;
            unit = Unit.INSTANCE;
            Object object4 = nation2;
            Intrinsics.checkNotNullExpressionValue(object4, "apply(...)");
            nation2 = object = Scene2dExtensionsKt.toLabel$default(string, (Color)object4, 14, 0, false, 12, null);
            boolean bl5 = false;
            this.getTileGroup().getLayerMisc().addActor((Actor)$this$updateStartingLocationIcon_u24lambda_u248);
            ((Actor)$this$updateStartingLocationIcon_u24lambda_u248).setOrigin(1);
            Scene2dExtensionsKt.center((Actor)$this$updateStartingLocationIcon_u24lambda_u248, this.getTileGroup());
            ((Actor)$this$updateStartingLocationIcon_u24lambda_u248).moveBy(14.4f, -9.0f);
            list2.add((Actor)object);
            String string2 = String.valueOf(nations2.size());
            Color color = Color.FIREBRICK;
            Intrinsics.checkNotNullExpressionValue(color, "FIREBRICK");
            $this$updateStartingLocationIcon_u24lambda_u248 = object = Scene2dExtensionsKt.toLabel$default(string2, color, 14, 0, false, 12, null);
            list2 = this.startingLocationIcons;
            boolean bl6 = false;
            this.getTileGroup().getLayerMisc().addActor((Actor)$this$updateStartingLocationIcon_u24lambda_u249);
            $this$updateStartingLocationIcon_u24lambda_u249.setOrigin(1);
            Scene2dExtensionsKt.center((Actor)$this$updateStartingLocationIcon_u24lambda_u249, this.getTileGroup());
            $this$updateStartingLocationIcon_u24lambda_u249.moveBy(14.0f, -8.4f);
            list2.add((Actor)object);
        }
    }

    private final void updateYieldIcon(Civilization viewingCiv, boolean show, LocalUniqueCache localUniqueCache) {
        boolean effectiveVisible = show && !this.getTileGroup().isForMapEditorIcon() && (viewingCiv != null || !this.getTileGroup().isForceVisible());
        this.yields.setVisible(false);
        if (effectiveVisible) {
            YieldGroup $this$updateYieldIcon_u24lambda_u2410 = this.yields;
            boolean bl = false;
            if (this.getTileGroup() instanceof CityTileGroup) {
                $this$updateYieldIcon_u24lambda_u2410.setStats(this.tile().getStats().getTileStats(((CityTileGroup)this.getTileGroup()).getCity(), viewingCiv, localUniqueCache));
            } else {
                $this$updateYieldIcon_u24lambda_u2410.setStats(this.tile().getStats().getTileStats(viewingCiv, localUniqueCache));
            }
            $this$updateYieldIcon_u24lambda_u2410.toFront();
            Scene2dExtensionsKt.centerX((Actor)$this$updateYieldIcon_u24lambda_u2410, this.getTileGroup());
            $this$updateYieldIcon_u24lambda_u2410.setVisible(true);
        }
    }

    public final void removeWorkedIcon() {
        Actor actor = this.workedIcon;
        if (actor != null) {
            actor.remove();
        }
        this.workedIcon = null;
        this.determineVisibility();
    }

    public final void addWorkedIcon(@NotNull Actor icon) {
        Intrinsics.checkNotNullParameter(icon, "icon");
        this.workedIcon = icon;
        this.addActor(this.workedIcon);
        this.determineVisibility();
    }

    public final void addHexOutline(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        Actor actor = this.hexOutlineIcon;
        if (actor != null) {
            actor.remove();
        }
        Actor actor2 = this.hexOutlineIcon = (Actor)this.setHexagonSize(ImageGetter.INSTANCE.getImage("OtherIcons/HexagonOutline"), Float.valueOf(1.0f));
        Intrinsics.checkNotNull(actor2);
        actor2.setColor(color);
        this.addActor(this.hexOutlineIcon);
        Actor actor3 = this.hexOutlineIcon;
        Intrinsics.checkNotNull(actor3);
        actor3.toBack();
        this.determineVisibility();
    }

    public final void removeHexOutline() {
        Actor actor = this.hexOutlineIcon;
        if (actor != null) {
            actor.remove();
        }
        this.hexOutlineIcon = null;
        this.determineVisibility();
    }

    public final void overlayTerrain(@NotNull Color color) {
        Color color2;
        Intrinsics.checkNotNullParameter(color, "color");
        Color color3 = color2 = Scene2dExtensionsKt.brighten(color, 0.3f);
        Image image2 = this.terrainOverlay;
        boolean bl = false;
        $this$overlayTerrain_u24lambda_u2411.a = 0.4f;
        image2.setColor(color2);
        this.terrainOverlay.setVisible(true);
        this.determineVisibility();
    }

    public final void overlayTerrain(@NotNull Color color, float alpha) {
        Color color2;
        Intrinsics.checkNotNullParameter(color, "color");
        Color color3 = color2 = color.cpy();
        Image image2 = this.terrainOverlay;
        boolean bl = false;
        $this$overlayTerrain_u24lambda_u2412.a = alpha;
        image2.setColor(color2);
        this.terrainOverlay.setVisible(true);
        this.determineVisibility();
    }

    public final void hideTerrainOverlay() {
        this.terrainOverlay.setVisible(false);
        this.determineVisibility();
    }

    public final void addArrow(@NotNull Tile targetTile, @NotNull MapArrowType type2) {
        Intrinsics.checkNotNullParameter(targetTile, "targetTile");
        Intrinsics.checkNotNullParameter(type2, "type");
        if (!Intrinsics.areEqual(targetTile.getPosition(), this.tile().getPosition())) {
            this.arrowsToDraw.add(new MapArrow(targetTile, type2, this.strings()));
        }
    }

    public final void resetArrows() {
        this.arrowsToDraw.clear();
    }

    public final void dimImprovement(boolean dim) {
        Actor actor = this.improvementIcon;
        if ((actor != null ? actor.getColor() : null) != null) {
            (actor != null ? actor.getColor() : null).a = dim ? 0.5f : 1.0f;
        }
    }

    public final void dimResource(boolean dim) {
        Actor actor = this.resourceIcon;
        if ((actor != null ? actor.getColor() : null) != null) {
            (actor != null ? actor.getColor() : null).a = dim ? 0.5f : 1.0f;
        }
    }

    public final void dimYields(boolean dim) {
        this.yields.getColor().a = dim ? 0.5f : 1.0f;
    }

    public final void dimPopulation(boolean dim) {
        Actor actor = this.workedIcon;
        if ((actor != null ? actor.getColor() : null) != null) {
            (actor != null ? actor.getColor() : null).a = dim ? 0.4f : 1.0f;
        }
    }

    public final void setYieldVisible(boolean isVisible) {
        this.yields.setVisible(isVisible);
        this.determineVisibility();
    }

    @Override
    protected void doUpdate(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        boolean showResourcesAndImprovements = true;
        boolean showTileYields = true;
        if (this.getTileGroup() instanceof WorldTileGroup) {
            showResourcesAndImprovements = UncivGame.Companion.getCurrent().getSettings().getShowResourcesAndImprovements();
            showTileYields = UncivGame.Companion.getCurrent().getSettings().getShowTileYields();
        }
        this.updateImprovementIcon(viewingCiv, showResourcesAndImprovements);
        this.updateYieldIcon(viewingCiv, showTileYields, localUniqueCache);
        this.updateResourceIcon(viewingCiv, showResourcesAndImprovements);
        if (!(this.getTileGroup() instanceof WorldTileGroup) || DebugUtils.INSTANCE.getSHOW_TILE_COORDS()) {
            this.updateStartingLocationIcon(true);
        }
        this.updateArrows();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void determineVisibility() {
        if (this.yields.isVisible()) ** GOTO lbl-1000
        v0 = this.resourceIcon;
        if (v0 != null ? v0.isVisible() : false) ** GOTO lbl-1000
        v1 = this.improvementIcon;
        v2 = v1 != null ? v1.isVisible() : false;
        if (v2 || this.workedIcon != null || this.hexOutlineIcon != null || ((Map)this.arrows).isEmpty() == false || ((Collection)this.startingLocationIcons).isEmpty() == false || this.terrainOverlay.isVisible()) lbl-1000:
        // 3 sources

        {
            v3 = true;
        } else {
            v3 = false;
        }
        this.setVisible(v3);
    }

    public final void reset(@NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        this.updateImprovementIcon(null, false);
        this.updateYieldIcon(null, false, localUniqueCache);
        this.updateResourceIcon(null, false);
        this.updateStartingLocationIcon(false);
        this.clearArrows();
    }
}

