/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.crashhandling;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.files.UncivFiles;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.crashhandling.CrashScreen;
import com.unciv.ui.images.IconTextButton;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.utils.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\b\u0010\u001b\u001a\u00020\rH\u0002J\b\u0010\u001c\u001a\u00020\rH\u0002R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/unciv/ui/crashhandling/CrashScreen;", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "exception", "", "(Ljava/lang/Throwable;)V", "<set-?>", "", "copied", "getCopied", "()Z", "getException", "()Ljava/lang/Throwable;", "lastScreenType", "", "text", "getText", "()Ljava/lang/String;", "formatReport", "message", "makeActionButtonsTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "makeErrorScroll", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "makeInstructionLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "makeLayoutTable", "makeTitleLabel", "tryGetSaveGame", "tryGetSaveMods", "Companion", "core"})
public final class CrashScreen
extends BaseScreen {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Throwable exception;
    @NotNull
    private final String lastScreenType;
    @NotNull
    private final String text;
    private boolean copied;

    /*
     * WARNING - void declaration
     */
    public CrashScreen(@NotNull Throwable exception2) {
        String string;
        CrashScreen crashScreen;
        Intrinsics.checkNotNullParameter(exception2, "exception");
        this.exception = exception2;
        CrashScreen crashScreen2 = this;
        try {
            crashScreen = crashScreen2;
            BaseScreen baseScreen = UncivGame.Companion.getCurrent().getScreen();
            Intrinsics.checkNotNull(baseScreen);
            string = String.valueOf(Reflection.getOrCreateKotlinClass(baseScreen.getClass()).getQualifiedName());
        }
        catch (Throwable throwable) {
            void e;
            crashScreen = crashScreen2;
            string = "Could not get screen type: " + e;
        }
        crashScreen.lastScreenType = string;
        this.text = this.formatReport(Companion.stringify(this.exception));
        this.getStage().addActor(this.makeLayoutTable());
    }

    @NotNull
    public final Throwable getException() {
        return this.exception;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final boolean getCopied() {
        return this.copied;
    }

    /*
     * WARNING - void declaration
     */
    private final String tryGetSaveGame() {
        String string;
        StringBuilder stringBuilder;
        GameInfo gameInfo2 = UncivGame.Companion.getGameInfoOrNull();
        if (gameInfo2 == null) {
            return "";
        }
        GameInfo gameInfo3 = gameInfo2;
        StringBuilder stringBuilder2 = new StringBuilder().append("\n**Save Data:**\n<details><summary>Show Saved Game</summary>\n\n```\n");
        try {
            stringBuilder = stringBuilder2;
            string = UncivFiles.Companion.gameInfoToString$default(UncivFiles.Companion, gameInfo3, true, false, 4, null);
        }
        catch (Throwable throwable) {
            void e;
            stringBuilder = stringBuilder2;
            string = "No save data: " + e;
        }
        return stringBuilder.append(string).append("\n```\n</details>\n").toString();
    }

    private final String tryGetSaveMods() {
        HashSet<String> visualMods;
        StringBuilder sb = new StringBuilder(160);
        GameInfo gameInfo2 = UncivGame.Companion.getGameInfoOrNull();
        if (gameInfo2 != null) {
            sb.append("\n**Save Mods:**\n```\n");
            try {
                sb.append(gameInfo2.getGameParameters().getModsAndBaseRuleset().toString());
            }
            catch (Throwable e) {
                sb.append("No mod data: " + e);
            }
            sb.append("\n```\n");
        }
        if ((visualMods = UncivGame.Companion.getCurrent().getSettings().getVisualMods()).isEmpty()) {
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }
        sb.append("**Permanent audiovisual Mods**:\n```\n");
        sb.append(visualMods.toString());
        sb.append("\n```\n");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final String formatReport(String message2) {
        String indent = StringsKt.repeat(" ", 4);
        String baseIndent = StringsKt.repeat(indent, 3);
        String subIndent = baseIndent + indent;
        return StringsKt.trimIndent("\n            **Platform:** " + CrashScreen.formatReport$prependIndentToOnlyNewLines(Gdx.app.getType().toString(), subIndent) + "\n            **Version:** " + CrashScreen.formatReport$prependIndentToOnlyNewLines(UncivGame.Companion.getVERSION().toNiceString(), subIndent) + "\n            **Rulesets:** " + CrashScreen.formatReport$prependIndentToOnlyNewLines(RulesetCache.INSTANCE.keySet().toString(), subIndent) + "\n            **Last Screen:** `" + this.lastScreenType + "`\n\n            --------------------------------\n\n            " + CrashScreen.formatReport$prependIndentToOnlyNewLines(Log.INSTANCE.getSystemInfo(), baseIndent) + "\n\n            --------------------------------\n\n\n            **Message:**\n            ```\n            " + CrashScreen.formatReport$prependIndentToOnlyNewLines(message2, baseIndent) + "\n            ```\n            ") + this.tryGetSaveMods() + this.tryGetSaveGame();
    }

    private final Table makeLayoutTable() {
        Table table2;
        Table it = table2 = new Table();
        boolean bl = false;
        it.setWidth(this.getStage().getWidth());
        it.setHeight(this.getStage().getHeight());
        Table layoutTable = table2;
        layoutTable.add((Actor)this.makeTitleLabel()).padBottom(15.0f).width(this.getStage().getWidth()).row();
        layoutTable.add(this.makeErrorScroll()).maxWidth(this.getStage().getWidth() * 0.7f).maxHeight(this.getStage().getHeight() * 0.5f).minHeight(this.getStage().getHeight() * 0.2f).row();
        layoutTable.add((Actor)this.makeInstructionLabel()).padTop(15.0f).width(this.getStage().getWidth()).row();
        layoutTable.add((Actor)this.makeActionButtonsTable()).padTop(10.0f);
        return layoutTable;
    }

    private final Label makeTitleLabel() {
        Label label2;
        Label $this$makeTitleLabel_u24lambda_u241 = label2 = Scene2dExtensionsKt.toLabel$default("An unrecoverable error has occurred in Unciv:", null, 24, 0, false, 13, null);
        boolean bl = false;
        $this$makeTitleLabel_u24lambda_u241.setWrap(true);
        $this$makeTitleLabel_u24lambda_u241.setAlignment(1);
        return label2;
    }

    private final Actor makeErrorScroll() {
        Label label2;
        Label $this$makeErrorScroll_u24lambda_u242 = label2 = new Label((CharSequence)this.text, BaseScreen.Companion.getSkin());
        boolean bl = false;
        Scene2dExtensionsKt.setFontSize($this$makeErrorScroll_u24lambda_u242, 15);
        Label errorLabel = label2;
        Table errorTable = new Table();
        errorTable.add((Actor)errorLabel).pad(10.0f);
        Actor actor = new AutoScrollPane((Actor)errorTable, null, 2, null);
        Color color = Color.DARK_GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "DARK_GRAY");
        return Scene2dExtensionsKt.addBorder$default(actor, 4.0f, color, false, 4, null);
    }

    private final Label makeInstructionLabel() {
        Label label2;
        Label $this$makeInstructionLabel_u24lambda_u243 = label2 = Scene2dExtensionsKt.toLabel("{If this keeps happening, you can try disabling mods.}\n{You can also report this on the issue tracker.}");
        boolean bl = false;
        $this$makeInstructionLabel_u24lambda_u243.setWrap(true);
        $this$makeInstructionLabel_u24lambda_u243.setAlignment(1);
        return label2;
    }

    private final Table makeActionButtonsTable() {
        Cell<Actor> cell2;
        Actor copyButton2 = ActivationExtensionsKt.onClick(new IconTextButton("Copy", null, 24, null, 10, null), new Function0<Unit>(this){
            final /* synthetic */ CrashScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                try {
                    Gdx.app.getClipboard().setContents(this.this$0.getText());
                    CrashScreen.access$setCopied$p(this.this$0, true);
                    new ToastPopup("Error report copied.", this.this$0, 0L, 4, null);
                }
                catch (Exception ex) {
                    Log.INSTANCE.debug("Could not copy to clipboard", ex);
                    new ToastPopup("Could not copy to clipboard!", this.this$0, 0L, 4, null);
                }
            }
        });
        Actor reportButton2 = ActivationExtensionsKt.onClick(new IconTextButton("Open Issue Tracker", (Actor)ImageGetter.INSTANCE.getImage("OtherIcons/Link"), 24, null, 8, null), new Function0<Unit>(this){
            final /* synthetic */ CrashScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (this.this$0.getCopied()) {
                    Gdx.net.openURI("https://github.com/yairm210/Unciv/issues");
                } else {
                    new ToastPopup("Please copy the error report first.", this.this$0, 0L, 4, null);
                }
            }
        });
        Actor closeButton2 = ActivationExtensionsKt.onClick(new IconTextButton("Close Unciv", null, 24, null, 10, null), makeActionButtonsTable.closeButton.1.INSTANCE);
        Table buttonsTable = new Table();
        buttonsTable.add(copyButton2).pad(10.0f);
        Cell<Actor> it = cell2 = buttonsTable.add(reportButton2).pad(10.0f);
        boolean bl = false;
        if (this.isCrampedPortrait()) {
            it.row();
            buttonsTable.add();
        }
        buttonsTable.add(closeButton2).pad(10.0f);
        return buttonsTable;
    }

    private static final String formatReport$prependIndentToOnlyNewLines(String $this$formatReport_u24prependIndentToOnlyNewLines, String indent) {
        return StringsKt.removePrefix(StringsKt.prependIndent($this$formatReport_u24prependIndentToOnlyNewLines, indent), (CharSequence)indent);
    }

    public static final /* synthetic */ void access$setCopied$p(CrashScreen $this, boolean bl) {
        $this.copied = bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/crashhandling/CrashScreen$Companion;", "", "()V", "stringify", "", "", "core"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String stringify(@NotNull Throwable $this$stringify) {
            Intrinsics.checkNotNullParameter($this$stringify, "<this>");
            StringWriter out2 = new StringWriter();
            $this$stringify.printStackTrace(new PrintWriter(out2));
            String string = out2.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

