/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.images;

import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.unciv.logic.civilization.Civilization;
import com.unciv.ui.components.tilegroups.TileSetStrings;
import com.unciv.ui.images.ImageGetter;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bJ\b\u0010\u0012\u001a\u0004\u0018\u00010\u000bJ.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0018\u001a\u00020\u0019J'\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0019\u0010\u001b\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u001c\u00a2\u0006\u0002\b\u001dJ-\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u001f\u0010\u001f\u001a\u001b\u0012\u0017\u0012\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u001c\u00a2\u0006\u0002\b\u001d0 R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lcom/unciv/ui/images/ImageAttempter;", "T", "", "scope", "(Ljava/lang/Object;)V", "<set-?>", "", "imageFound", "getImageFound", "()Z", "lastTriedFileName", "", "getScope", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getImage", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "getPath", "getPathOrNull", "tryEraImage", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "locationToCheck", "style", "tileSetStrings", "Lcom/unciv/ui/components/tilegroups/TileSetStrings;", "tryImage", "fileName", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "tryImages", "fileNames", "Lkotlin/sequences/Sequence;", "core"})
public final class ImageAttempter<T> {
    @NotNull
    private final T scope;
    @Nullable
    private String lastTriedFileName;
    private boolean imageFound;

    public ImageAttempter(@NotNull T scope2) {
        Intrinsics.checkNotNullParameter(scope2, "scope");
        this.scope = scope2;
    }

    @NotNull
    public final T getScope() {
        return this.scope;
    }

    public final boolean getImageFound() {
        return this.imageFound;
    }

    @NotNull
    public final ImageAttempter<T> tryImage(@NotNull Function1<? super T, String> fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        if (!this.imageFound) {
            String imagePath = fileName.invoke(this.scope);
            String string = imagePath;
            if (string == null) {
                string = this.lastTriedFileName = this.lastTriedFileName;
            }
            if (imagePath != null && ImageGetter.INSTANCE.imageExists(imagePath)) {
                this.imageFound = true;
            }
        }
        return this;
    }

    @NotNull
    public final ImageAttempter<T> tryImages(@NotNull Sequence<? extends Function1<? super T, String>> fileNames) {
        Intrinsics.checkNotNullParameter(fileNames, "fileNames");
        Iterator<Function1<T, String>> iterator2 = fileNames.iterator();
        while (iterator2.hasNext()) {
            Function1<? super T, String> fileName = iterator2.next();
            this.tryImage(fileName);
        }
        return this;
    }

    @NotNull
    public final ImageAttempter<T> tryEraImage(@NotNull Civilization civInfo, @NotNull String locationToCheck, @Nullable String style, @NotNull TileSetStrings tileSetStrings) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(locationToCheck, "locationToCheck");
        Intrinsics.checkNotNullParameter(tileSetStrings, "tileSetStrings");
        return this.tryImages(SequencesKt.map(CollectionsKt.asSequence(RangesKt.downTo(civInfo.getEraNumber(), 0)), new Function1<Integer, Function1<? super T, ? extends String>>(civInfo, style, tileSetStrings, locationToCheck){
            final /* synthetic */ Civilization $civInfo;
            final /* synthetic */ String $style;
            final /* synthetic */ TileSetStrings $tileSetStrings;
            final /* synthetic */ String $locationToCheck;
            {
                this.$civInfo = $civInfo;
                this.$style = $style;
                this.$tileSetStrings = $tileSetStrings;
                this.$locationToCheck = $locationToCheck;
                super(1);
            }

            @NotNull
            public final Function1<T, String> invoke(int it) {
                return new Function1<T, String>(this.$civInfo, it, this.$style, this.$tileSetStrings, this.$locationToCheck){
                    final /* synthetic */ Civilization $civInfo;
                    final /* synthetic */ int $it;
                    final /* synthetic */ String $style;
                    final /* synthetic */ TileSetStrings $tileSetStrings;
                    final /* synthetic */ String $locationToCheck;
                    {
                        this.$civInfo = $civInfo;
                        this.$it = $it;
                        this.$style = $style;
                        this.$tileSetStrings = $tileSetStrings;
                        this.$locationToCheck = $locationToCheck;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(@NotNull T $this$null) {
                        String string;
                        Intrinsics.checkNotNullParameter($this$null, "$this$null");
                        Set<String> set2 = this.$civInfo.getGameInfo().getRuleset().getEras().keySet();
                        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
                        T t = CollectionsKt.elementAt((Iterable)set2, this.$it);
                        Intrinsics.checkNotNullExpressionValue(t, "elementAt(...)");
                        String era2 = (String)t;
                        if (this.$style != null) {
                            String[] stringArray = new String[]{this.$locationToCheck, this.$tileSetStrings.getTag(), this.$style, this.$tileSetStrings.getTag(), era2};
                            string = this.$tileSetStrings.getString(stringArray);
                        } else {
                            String[] stringArray = new String[]{this.$locationToCheck, this.$tileSetStrings.getTag(), era2};
                            string = this.$tileSetStrings.getString(stringArray);
                        }
                        return string;
                    }
                };
            }
        }));
    }

    @Nullable
    public final String getPath() {
        return this.lastTriedFileName;
    }

    @Nullable
    public final String getPathOrNull() {
        return this.imageFound ? this.lastTriedFileName : null;
    }

    @NotNull
    public final Image getImage() {
        return ImageGetter.INSTANCE.getImage(this.lastTriedFileName);
    }
}

