/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.images;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.stats.Stats;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/unciv/ui/images/PortraitImprovement;", "Lcom/unciv/ui/images/Portrait;", "name", "", "size", "", "dim", "", "isPillaged", "(Ljava/lang/String;FZZ)V", "getColorFromStats", "Lcom/badlogic/gdx/graphics/Color;", "stats", "Lcom/unciv/models/stats/Stats;", "getDefaultInnerBackgroundTint", "core"})
@SourceDebugExtension(value={"SMAP\nPortrait.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Portrait.kt\ncom/unciv/ui/images/PortraitImprovement\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,319:1\n2159#2,2:320\n1433#2,14:322\n*S KotlinDebug\n*F\n+ 1 Portrait.kt\ncom/unciv/ui/images/PortraitImprovement\n*L\n227#1:320,2\n229#1:322,14\n*E\n"})
public final class PortraitImprovement
extends Portrait {
    public PortraitImprovement(@NotNull String name2, float size2, boolean dim, boolean isPillaged) {
        Intrinsics.checkNotNullParameter(name2, "name");
        super(Portrait.Type.Improvement, name2, size2, 0.0f, 8, null);
        if (dim) {
            this.getImage().getColor().a = 0.7f;
            this.getBackground().getColor().a = 0.7f;
        }
        if (isPillaged) {
            Image pillagedIcon = ImageGetter.INSTANCE.getImage("OtherIcons/Fire");
            pillagedIcon.setSize(this.getWidth() / (float)2, this.getHeight() / (float)2);
            pillagedIcon.setPosition(this.getWidth(), 0.0f, 20);
            this.addActor(pillagedIcon);
        }
    }

    public /* synthetic */ PortraitImprovement(String string, float f, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(string, f, bl, bl2);
    }

    private final Color getColorFromStats(Stats stats2) {
        Stats.StatValuePair statValuePair;
        boolean bl;
        Stats.StatValuePair it;
        block7: {
            Sequence<Stats.StatValuePair> $this$none$iv = stats2.asSequence();
            boolean $i$f$none = false;
            Iterator<Stats.StatValuePair> iterator2 = $this$none$iv.iterator();
            while (iterator2.hasNext()) {
                Stats.StatValuePair element$iv;
                it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!(it.getValue() > 0.0f)) continue;
                bl = false;
                break block7;
            }
            bl = true;
        }
        if (bl) {
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color, "WHITE");
            return color;
        }
        Sequence<Stats.StatValuePair> $this$maxByOrNull$iv = stats2.asSequence();
        boolean $i$f$maxByOrNull = false;
        Iterator<Stats.StatValuePair> iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            statValuePair = null;
        } else {
            Stats.StatValuePair maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                statValuePair = maxElem$iv;
            } else {
                it = maxElem$iv;
                boolean bl3 = false;
                float maxValue$iv = it.getValue();
                do {
                    Stats.StatValuePair e$iv;
                    Stats.StatValuePair it2 = e$iv = iterator$iv.next();
                    $i$a$-maxByOrNull-PortraitImprovement$getColorFromStats$2 = false;
                    float v$iv = it2.getValue();
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                statValuePair = maxElem$iv;
            }
        }
        Intrinsics.checkNotNull(statValuePair);
        return ((Stats.StatValuePair)statValuePair).getKey().getColor();
    }

    @Override
    @NotNull
    public Color getDefaultInnerBackgroundTint() {
        TileImprovement improvement2 = ImageGetter.INSTANCE.getRuleset().getTileImprovements().get(this.getImageName());
        if (improvement2 != null) {
            return this.getColorFromStats(improvement2);
        }
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue(color, "WHITE");
        return color;
    }
}

