/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.objectdescriptions;

import com.unciv.logic.city.City;
import com.unciv.models.Counter;
import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.objectdescriptions.BuildingDescriptions;
import com.unciv.ui.objectdescriptions.DescriptionHelpersKt;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006J0\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u001a\u001a\u00020\u00142\u0016\b\u0002\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001cJ6\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u000b2\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fJ*\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016*\u00020\u00062\u0016\b\u0002\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001cH\u0002J*\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016*\u00020\u00062\u0016\b\u0002\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001cH\u0002\u00a8\u0006#"}, d2={"Lcom/unciv/ui/objectdescriptions/BuildingDescriptions;", "", "()V", "additionalDescription", "", "building", "Lcom/unciv/models/ruleset/Building;", "city", "Lcom/unciv/logic/city/City;", "lines", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getCivilopediaTextLines", "", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getDescription", "showAdditionalInfo", "", "getDifferences", "Lkotlin/sequences/Sequence;", "originalBuilding", "replacementBuilding", "getShortDescription", "multiline", "uniqueInclusionFilter", "Lkotlin/Function1;", "Lcom/unciv/models/ruleset/unique/Unique;", "missingCityText", "filter", "getUniquesStrings", "filterUniques", "getUniquesStringsWithoutDisablers", "core"})
@SourceDebugExtension(value={"SMAP\nBuildingDescriptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildingDescriptions.kt\ncom/unciv/ui/objectdescriptions/BuildingDescriptions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,292:1\n1#2:293\n766#3:294\n857#3,2:295\n1855#3,2:297\n1747#3,3:299\n*S KotlinDebug\n*F\n+ 1 BuildingDescriptions.kt\ncom/unciv/ui/objectdescriptions/BuildingDescriptions\n*L\n101#1:294\n101#1:295,2\n235#1:297,2\n248#1:299,3\n*E\n"})
public final class BuildingDescriptions {
    @NotNull
    public static final BuildingDescriptions INSTANCE = new BuildingDescriptions();

    private BuildingDescriptions() {
    }

    @NotNull
    public final String getShortDescription(@NotNull Building building, boolean multiline, @Nullable Function1<? super Unique, Boolean> uniqueInclusionFilter) {
        Intrinsics.checkNotNullParameter(building, "building");
        Building $this$getShortDescription_u24lambda_u241 = building;
        boolean bl = false;
        List infoList = new ArrayList();
        String string = $this$getShortDescription_u24lambda_u241.clone().toString();
        String it = string;
        boolean bl2 = false;
        if (((CharSequence)it).length() > 0) {
            ((Collection)infoList).add(it);
        }
        for (Stats.StatValuePair statValuePair : Building.getStatPercentageBonuses$default($this$getShortDescription_u24lambda_u241, null, null, 2, null)) {
            Stat key = statValuePair.component1();
            float value = statValuePair.component2();
            ((Collection)infoList).add("" + '+' + (int)value + "% " + TranslationsKt.tr$default(key.name(), false, 1, null));
        }
        if ($this$getShortDescription_u24lambda_u241.getRequiredNearbyImprovedResources() != null) {
            Collection collection = infoList;
            StringBuilder stringBuilder = new StringBuilder().append("Requires worked [");
            List<String> list2 = $this$getShortDescription_u24lambda_u241.getRequiredNearbyImprovedResources();
            Intrinsics.checkNotNull(list2);
            collection.add(stringBuilder.append(CollectionsKt.joinToString$default(list2, "/", null, null, 0, null, getShortDescription.1.2.INSTANCE, 30, null)).append("] near city").toString());
        }
        if (!((Collection)$this$getShortDescription_u24lambda_u241.getUniques()).isEmpty()) {
            if (((CharSequence)$this$getShortDescription_u24lambda_u241.getReplacementTextForUniques()).length() > 0) {
                ((Collection)infoList).add($this$getShortDescription_u24lambda_u241.getReplacementTextForUniques());
            } else {
                CollectionsKt.addAll((Collection)infoList, INSTANCE.getUniquesStringsWithoutDisablers($this$getShortDescription_u24lambda_u241, uniqueInclusionFilter));
            }
        }
        if ($this$getShortDescription_u24lambda_u241.getCityStrength() != 0) {
            ((Collection)infoList).add("{City strength} +" + $this$getShortDescription_u24lambda_u241.getCityStrength());
        }
        if ($this$getShortDescription_u24lambda_u241.getCityHealth() != 0) {
            ((Collection)infoList).add("{City health} +" + $this$getShortDescription_u24lambda_u241.getCityHealth());
        }
        String separator = multiline ? "\n" : "; ";
        return CollectionsKt.joinToString$default(infoList, separator, null, null, 0, null, getShortDescription.1.3.INSTANCE, 30, null);
    }

    public static /* synthetic */ String getShortDescription$default(BuildingDescriptions buildingDescriptions, Building building, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        return buildingDescriptions.getShortDescription(building, bl, function1);
    }

    @NotNull
    public final String getDescription(@NotNull Building building, @NotNull City city2, boolean showAdditionalInfo) {
        Intrinsics.checkNotNullParameter(building, "building");
        Intrinsics.checkNotNullParameter(city2, "city");
        Building $this$getDescription_u24lambda_u242 = building;
        boolean bl = false;
        Stats stats2 = Building.getStats$default($this$getDescription_u24lambda_u242, city2, null, 2, null);
        ArrayList<String> translatedLines = new ArrayList<String>();
        boolean isFree = city2.getCiv().getCivConstructions().hasFreeBuilding(city2, $this$getDescription_u24lambda_u242);
        if ($this$getDescription_u24lambda_u242.getUniqueTo() != null) {
            ((Collection)translatedLines).add($this$getDescription_u24lambda_u242.getReplaces() == null ? TranslationsKt.tr$default("Unique to [" + $this$getDescription_u24lambda_u242.getUniqueTo() + ']', false, 1, null) : TranslationsKt.tr$default("Unique to [" + $this$getDescription_u24lambda_u242.getUniqueTo() + "], replaces [" + $this$getDescription_u24lambda_u242.getReplaces() + ']', false, 1, null));
        }
        if ($this$getDescription_u24lambda_u242.isWonder()) {
            ((Collection)translatedLines).add(TranslationsKt.tr$default("Wonder", false, 1, null));
        }
        if ($this$getDescription_u24lambda_u242.isNationalWonder()) {
            ((Collection)translatedLines).add(TranslationsKt.tr$default("National Wonder", false, 1, null));
        }
        if (!isFree) {
            for (Map.Entry object : ((Map)$this$getDescription_u24lambda_u242.getResourceRequirementsPerTurn(new StateForConditionals(city2.getCiv(), city2, null, null, null, null, null, null, null, false, 1020, null))).entrySet()) {
                TileResource tileResource;
                String resourceName = (String)object.getKey();
                int amount = ((Number)object.getValue()).intValue();
                int available = city2.getAvailableResourceAmount(resourceName);
                if (city2.getRuleset().getTileResources().get(resourceName) == null) continue;
                Intrinsics.checkNotNull(tileResource);
                TileResource resource2 = tileResource;
                String consumesString = FormattingExtensionsKt.getConsumesAmountString(resourceName, amount, resource2.isStockpiled());
                ((Collection)translatedLines).add(showAdditionalInfo ? TranslationsKt.tr$default(consumesString + " ({[" + available + "] available})", false, 1, null) : TranslationsKt.tr$default(consumesString, false, 1, null));
            }
        }
        if (!((Collection)$this$getDescription_u24lambda_u242.getUniques()).isEmpty()) {
            if (((CharSequence)$this$getDescription_u24lambda_u242.getReplacementTextForUniques()).length() > 0) {
                ((Collection)translatedLines).add(TranslationsKt.tr$default($this$getDescription_u24lambda_u242.getReplacementTextForUniques(), false, 1, null));
            } else {
                CollectionsKt.addAll((Collection)translatedLines, SequencesKt.map(INSTANCE.getUniquesStringsWithoutDisablers($this$getDescription_u24lambda_u242, getDescription.1.1.INSTANCE), getDescription.1.2.INSTANCE));
            }
        }
        if (!stats2.isEmpty()) {
            ((Collection)translatedLines).add(stats2.toString());
        }
        for (Stats.StatValuePair statValuePair : Building.getStatPercentageBonuses$default($this$getDescription_u24lambda_u242, city2, null, 2, null)) {
            Stat stat = statValuePair.component1();
            float value = statValuePair.component2();
            if (value == 0.0f) continue;
            ((Collection)translatedLines).add(TranslationsKt.tr$default("" + '+' + (int)value + "% {" + stat.name() + '}', false, 1, null));
        }
        for (Map.Entry entry : ((Map)$this$getDescription_u24lambda_u242.getGreatPersonPoints()).entrySet()) {
            String greatPersonName = (String)entry.getKey();
            int value = ((Number)entry.getValue()).intValue();
            ((Collection)translatedLines).add("" + '+' + value + ' ' + TranslationsKt.tr$default('[' + greatPersonName + "] points", false, 1, null));
        }
        for (Map.Entry entry : ((Map)$this$getDescription_u24lambda_u242.newSpecialists()).entrySet()) {
            String specialistName = (String)entry.getKey();
            int amount = ((Number)entry.getValue()).intValue();
            ((Collection)translatedLines).add("" + '+' + amount + ' ' + TranslationsKt.tr$default('[' + specialistName + "] slots", false, 1, null));
        }
        if ($this$getDescription_u24lambda_u242.getRequiredNearbyImprovedResources() != null) {
            Collection collection = translatedLines;
            StringBuilder stringBuilder = new StringBuilder().append("Requires worked [");
            List<String> list2 = $this$getDescription_u24lambda_u242.getRequiredNearbyImprovedResources();
            Intrinsics.checkNotNull(list2);
            collection.add(TranslationsKt.tr$default(stringBuilder.append(CollectionsKt.joinToString$default(list2, "/", null, null, 0, null, getDescription.1.3.INSTANCE, 30, null)).append("] near city").toString(), false, 1, null));
        }
        if ($this$getDescription_u24lambda_u242.getCityStrength() != 0) {
            ((Collection)translatedLines).add(TranslationsKt.tr$default("{City strength} +" + $this$getDescription_u24lambda_u242.getCityStrength(), false, 1, null));
        }
        if ($this$getDescription_u24lambda_u242.getCityHealth() != 0) {
            ((Collection)translatedLines).add(TranslationsKt.tr$default("{City health} +" + $this$getDescription_u24lambda_u242.getCityHealth(), false, 1, null));
        }
        if ($this$getDescription_u24lambda_u242.getMaintenance() != 0 && !isFree) {
            ((Collection)translatedLines).add(TranslationsKt.tr$default("{Maintenance cost}: " + $this$getDescription_u24lambda_u242.getMaintenance() + " {Gold}", false, 1, null));
        }
        if (showAdditionalInfo) {
            INSTANCE.additionalDescription(building, city2, translatedLines);
        }
        return ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default(translatedLines, "\n", null, null, 0, null, null, 62, null))).toString();
    }

    public final void additionalDescription(@NotNull Building building, @NotNull City city2, @NotNull ArrayList<String> lines2) {
        Intrinsics.checkNotNullParameter(building, "building");
        Intrinsics.checkNotNullParameter(city2, "city");
        Intrinsics.checkNotNullParameter(lines2, "lines");
        for (Unique unique : building.getUniqueObjects()) {
            if (unique.getType() != UniqueType.OnlyAvailable && unique.getType() != UniqueType.CanOnlyBeBuiltWhen) continue;
            for (Unique conditional : unique.getConditionals()) {
                if (conditional.getType() != UniqueType.ConditionalBuildingBuiltAll) continue;
                this.missingCityText(conditional.getParams().get(0), city2, conditional.getParams().get(1), lines2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void missingCityText(@NotNull String building, @NotNull City city2, @NotNull String filter2, @NotNull ArrayList<String> lines2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(building, "building");
        Intrinsics.checkNotNullParameter(city2, "city");
        Intrinsics.checkNotNullParameter(filter2, "filter");
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterable $this$filter$iv = city2.getCiv().getCities();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            City it = (City)element$iv$iv;
            boolean bl = false;
            if (!(City.matchesFilter$default(it, filter2, null, 2, null) && !it.getCityConstructions().containsBuildingOrEquivalent(building))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List missingCities = (List)destination$iv$iv;
        if (!((Collection)missingCities).isEmpty()) {
            ((Collection)lines2).add('\n' + TranslationsKt.tr$default("" + '[' + city2.getCiv().getEquivalentBuilding(building) + "] required:", false, 1, null) + ' ' + CollectionsKt.joinToString$default(missingCities, ", ", null, null, 0, null, missingCityText.1.INSTANCE, 30, null));
        }
    }

    @NotNull
    public final Sequence<FormattedLine> getDifferences(@NotNull Building originalBuilding, @NotNull Building replacementBuilding) {
        Intrinsics.checkNotNullParameter(originalBuilding, "originalBuilding");
        Intrinsics.checkNotNullParameter(replacementBuilding, "replacementBuilding");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super FormattedLine>, Continuation<? super Unit>, Object>(replacementBuilding, originalBuilding, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Building $replacementBuilding;
            final /* synthetic */ Building $originalBuilding;
            {
                this.$replacementBuilding = $replacementBuilding;
                this.$originalBuilding = $originalBuilding;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        var3_4 = this.$replacementBuilding.iterator();
lbl7:
                        // 4 sources

                        while (var3_4.hasNext()) {
                            var4_5 = var3_4.next();
                            key = var4_5.component1();
                            value = var4_5.component2();
                            if (value == this.$originalBuilding.get(key)) continue;
                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.label = 1;
                            v0 = $this$sequence.yield(new FormattedLine(TranslationsKt.tr$default(key.name(), false, 1, null) + ' ' + TranslationsKt.tr$default("" + '[' + (int)value + "] vs [" + (int)this.$originalBuilding.get(key) + ']', false, 1, null), null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                            if (v0 != var13_2) continue;
                            return var13_2;
                        }
                        break;
                    }
                    case 1: {
                        var3_4 = (Iterator<Stats.StatValuePair>)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
                        ** GOTO lbl7
                    }
                }
                originalStatBonus = Building.getStatPercentageBonuses$default(this.$originalBuilding, null, null, 2, null);
                var4_5 = Building.getStatPercentageBonuses$default(this.$replacementBuilding, null, null, 2, null).iterator();
lbl27:
                // 4 sources

                while (var4_5.hasNext()) {
                    var5_6 = (Stats.StatValuePair)var4_5.next();
                    key = var5_6.component1();
                    value = var5_6.component2();
                    if (value == originalStatBonus.get(key)) continue;
                    this.L$0 = $this$sequence;
                    this.L$1 = originalStatBonus;
                    this.L$2 = var4_5;
                    this.label = 2;
                    v1 = $this$sequence.yield(new FormattedLine(TranslationsKt.tr$default("" + '[' + (int)value + "]% ", false, 1, null) + TranslationsKt.tr$default(key.name(), false, 1, null) + TranslationsKt.tr$default(" vs [" + (int)originalStatBonus.get(key) + "]% ", false, 1, null) + TranslationsKt.tr$default(key.name(), false, 1, null), null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                    if (v1 != var13_2) continue;
                    return var13_2;
                }
                {
                    break;
                    case 2: {
                        var4_5 = (Iterator)this.L$2;
                        originalStatBonus = (Stats)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
                        ** GOTO lbl27
                    }
                }
                if (this.$replacementBuilding.getMaintenance() != this.$originalBuilding.getMaintenance()) {
                    this.L$0 = $this$sequence;
                    this.L$1 = null;
                    this.L$2 = null;
                    this.label = 3;
                    v2 = $this$sequence.yield(new FormattedLine(TranslationsKt.tr$default("{Maintenance} ", false, 1, null) + TranslationsKt.tr$default("" + '[' + this.$replacementBuilding.getMaintenance() + "] vs [" + this.$originalBuilding.getMaintenance() + ']', false, 1, null), null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                    if (v2 == var13_2) {
                        return var13_2;
                    }
                }
                ** GOTO lbl60
                {
                    case 3: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl60:
                        // 2 sources

                        if (this.$replacementBuilding.getCost() != this.$originalBuilding.getCost()) {
                            this.L$0 = $this$sequence;
                            this.L$1 = null;
                            this.L$2 = null;
                            this.label = 4;
                            v3 = $this$sequence.yield(new FormattedLine(TranslationsKt.tr$default("{Cost} ", false, 1, null) + TranslationsKt.tr$default("" + '[' + this.$replacementBuilding.getCost() + "] vs [" + this.$originalBuilding.getCost() + ']', false, 1, null), null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                            if (v3 == var13_2) {
                                return var13_2;
                            }
                        }
                        ** GOTO lbl73
                    }
                    case 4: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
lbl73:
                        // 2 sources

                        if (this.$replacementBuilding.getCityStrength() != this.$originalBuilding.getCityStrength()) {
                            this.L$0 = $this$sequence;
                            this.L$1 = null;
                            this.L$2 = null;
                            this.label = 5;
                            v4 = $this$sequence.yield(new FormattedLine(TranslationsKt.tr$default("{City strength} ", false, 1, null) + TranslationsKt.tr$default("" + '[' + this.$replacementBuilding.getCityStrength() + "] vs [" + this.$originalBuilding.getCityStrength() + ']', false, 1, null), null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                            if (v4 == var13_2) {
                                return var13_2;
                            }
                        }
                        ** GOTO lbl86
                    }
                    case 5: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v4 = $result;
lbl86:
                        // 2 sources

                        if (this.$replacementBuilding.getCityHealth() != this.$originalBuilding.getCityHealth()) {
                            this.L$0 = $this$sequence;
                            this.L$1 = null;
                            this.L$2 = null;
                            this.label = 6;
                            v5 = $this$sequence.yield(new FormattedLine(TranslationsKt.tr$default("{City health} ", false, 1, null) + TranslationsKt.tr$default("" + '[' + this.$replacementBuilding.getCityHealth() + "] vs [" + this.$originalBuilding.getCityHealth() + ']', false, 1, null), null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                            if (v5 == var13_2) {
                                return var13_2;
                            }
                        }
                        ** GOTO lbl99
                    }
                    case 6: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v5 = $result;
lbl99:
                        // 2 sources

                        if (!(((CharSequence)this.$replacementBuilding.getReplacementTextForUniques()).length() > 0)) break;
                        this.L$0 = $this$sequence;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.label = 7;
                        v6 = $this$sequence.yield(new FormattedLine(this.$replacementBuilding.getReplacementTextForUniques(), null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                        if (v6 == var13_2) {
                            return var13_2;
                        }
                        break;
                    }
                    case 7: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v6 = $result;
                        break;
                    }
                }
                newAbilityPredicate = new Function1<Unique, Boolean>(this.$originalBuilding){
                    final /* synthetic */ Building $originalBuilding;
                    {
                        this.$originalBuilding = $originalBuilding;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Unique it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return this.$originalBuilding.getUniques().contains(it.getText()) || it.isHiddenToUsers();
                    }
                };
                $this$filterNot$iv = this.$replacementBuilding.getUniqueObjects();
                $i$f$filterNot = false;
                var8_14 = $this$filterNot$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterNotTo = false;
                for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                    if (((Boolean)newAbilityPredicate.invoke(element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                var5_6 = ((List)destination$iv$iv).iterator();
lbl125:
                // 3 sources

                while (var5_6.hasNext()) {
                    unique = (Unique)var5_6.next();
                    this.L$0 = $this$sequence;
                    this.L$1 = var5_6;
                    this.L$2 = null;
                    this.label = 8;
                    v7 = $this$sequence.yield(new FormattedLine(unique.getDisplayText(), null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                    if (v7 != var13_2) continue;
                    return var13_2;
                }
                {
                    break;
                    case 8: {
                        var5_6 = (Iterator)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v7 = $result;
                        ** GOTO lbl125
                    }
                }
                lostAbilityPredicate = new Function1<Unique, Boolean>(this.$replacementBuilding){
                    final /* synthetic */ Building $replacementBuilding;
                    {
                        this.$replacementBuilding = $replacementBuilding;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Unique it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return this.$replacementBuilding.getUniques().contains(it.getText()) || it.isHiddenToUsers();
                    }
                };
                $this$filterNot$iv = this.$originalBuilding.getUniqueObjects();
                $i$f$filterNot = false;
                $this$filterNotTo$iv$iv = $this$filterNot$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterNotTo = false;
                for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                    if (((Boolean)lostAbilityPredicate.invoke(element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                var5_6 = ((List)destination$iv$iv).iterator();
lbl153:
                // 3 sources

                while (var5_6.hasNext()) {
                    unique = (Unique)var5_6.next();
                    this.L$0 = $this$sequence;
                    this.L$1 = var5_6;
                    this.L$2 = null;
                    this.label = 9;
                    v8 = $this$sequence.yield(new FormattedLine("Lost ability (vs [" + this.$originalBuilding.getName() + "]): [" + TranslationsKt.tr$default(unique.getText(), false, 1, null) + ']', null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                    if (v8 != var13_2) continue;
                    return var13_2;
                }
                {
                    break;
                    case 9: {
                        var5_6 = (Iterator)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v8 = $result;
                        ** GOTO lbl153
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super FormattedLine>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super FormattedLine> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @NotNull
    public final List<FormattedLine> getCivilopediaTextLines(@NotNull Building building, @NotNull Ruleset ruleset2) {
        Object object;
        Intrinsics.checkNotNullParameter(building, "building");
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        Building $this$getCivilopediaTextLines_u24lambda_u247 = building;
        boolean bl = false;
        ArrayList textList = new ArrayList();
        if ($this$getCivilopediaTextLines_u24lambda_u247.isAnyWonder()) {
            Collection collection = textList;
            object = $this$getCivilopediaTextLines_u24lambda_u247.isWonder() ? "Wonder" : "National Wonder";
            collection.add(new FormattedLine((String)object, null, null, null, 0.0f, 0, 3, 0, 0.0f, "#CA4", false, false, false, false, 15806, null));
        }
        if ($this$getCivilopediaTextLines_u24lambda_u247.getUniqueTo() != null) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("Unique to [" + $this$getCivilopediaTextLines_u24lambda_u247.getUniqueTo() + ']', "Nation/" + $this$getCivilopediaTextLines_u24lambda_u247.getUniqueTo(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            if ($this$getCivilopediaTextLines_u24lambda_u247.getReplaces() != null) {
                Building replacesBuilding = (Building)((Map)ruleset2.getBuildings()).get($this$getCivilopediaTextLines_u24lambda_u247.getReplaces());
                object = textList;
                String string = "Replaces [" + $this$getCivilopediaTextLines_u24lambda_u247.getReplaces() + ']';
                Object object2 = replacesBuilding;
                if (object2 == null || (object2 = ((Building)object2).makeLink()) == null) {
                    object2 = "";
                }
                object.add(new FormattedLine(string, (String)object2, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        if ($this$getCivilopediaTextLines_u24lambda_u247.getCost() > 0) {
            object = new String[]{"" + $this$getCivilopediaTextLines_u24lambda_u247.getCost() + '\u2699'};
            List<String> stats2 = CollectionsKt.mutableListOf(object);
            if ($this$getCivilopediaTextLines_u24lambda_u247.canBePurchasedWithStat(null, Stat.Gold)) {
                ((Collection)stats2).add("" + $this$getCivilopediaTextLines_u24lambda_u247.getCivilopediaGoldCost() + '\u00a4');
            }
            ((Collection)textList).add(new FormattedLine(CollectionsKt.joinToString$default(stats2, "/", "{Cost}: ", null, 0, null, null, 60, null), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        if ($this$getCivilopediaTextLines_u24lambda_u247.getRequiredTech() != null) {
            ((Collection)textList).add(new FormattedLine("Required tech: [" + $this$getCivilopediaTextLines_u24lambda_u247.getRequiredTech() + ']', "Technology/" + $this$getCivilopediaTextLines_u24lambda_u247.getRequiredTech(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
        }
        if ($this$getCivilopediaTextLines_u24lambda_u247.getRequiredBuilding() != null) {
            ((Collection)textList).add(new FormattedLine("Requires [" + $this$getCivilopediaTextLines_u24lambda_u247.getRequiredBuilding() + "] to be built in the city", "Building/" + $this$getCivilopediaTextLines_u24lambda_u247.getRequiredBuilding(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
        }
        if ($this$getCivilopediaTextLines_u24lambda_u247.getRequiredResource() != null) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            TileResource resource2 = (TileResource)((Map)ruleset2.getTileResources()).get($this$getCivilopediaTextLines_u24lambda_u247.getRequiredResource());
            Collection collection = textList;
            String string = $this$getCivilopediaTextLines_u24lambda_u247.getRequiredResource();
            Intrinsics.checkNotNull(string);
            TileResource tileResource = resource2;
            Intrinsics.checkNotNull(tileResource);
            collection.add(new FormattedLine(FormattingExtensionsKt.getConsumesAmountString(string, 1, tileResource.isStockpiled()), "Resources/" + $this$getCivilopediaTextLines_u24lambda_u247.getRequiredResource(), null, null, 0.0f, 0, 0, 0, 0.0f, "#F42", false, false, false, false, 15868, null));
        }
        Stats stats2 = $this$getCivilopediaTextLines_u24lambda_u247.cloneStats();
        Stats percentStats = Building.getStatPercentageBonuses$default($this$getCivilopediaTextLines_u24lambda_u247, null, null, 2, null);
        Counter<String> specialists = $this$getCivilopediaTextLines_u24lambda_u247.newSpecialists();
        if (!((Collection)$this$getCivilopediaTextLines_u24lambda_u247.getUniques()).isEmpty() || !stats2.isEmpty() || !percentStats.isEmpty() || !((Map)$this$getCivilopediaTextLines_u24lambda_u247.getGreatPersonPoints()).isEmpty() || !((Map)specialists).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
        }
        if (((CharSequence)$this$getCivilopediaTextLines_u24lambda_u247.getReplacementTextForUniques()).length() > 0) {
            ((Collection)textList).add(new FormattedLine($this$getCivilopediaTextLines_u24lambda_u247.getReplacementTextForUniques(), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        } else {
            DescriptionHelpersKt.uniquesToCivilopediaTextLines$default($this$getCivilopediaTextLines_u24lambda_u247, textList, null, false, true, null, 22, null);
        }
        if (!stats2.isEmpty()) {
            ((Collection)textList).add(new FormattedLine(stats2.toString(), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        if (!percentStats.isEmpty()) {
            for (Stats.StatValuePair object3 : percentStats) {
                Stat key = object3.component1();
                float value = object3.component2();
                if (value == 0.0f) continue;
                ((Collection)textList).add(new FormattedLine(BuildingDescriptions.getCivilopediaTextLines$lambda$7$formatSignedInt(value) + "% {" + (Object)((Object)key) + '}', null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            }
        }
        for (Map.Entry entry : ((Map)$this$getCivilopediaTextLines_u24lambda_u247.getGreatPersonPoints()).entrySet()) {
            String greatPersonName = (String)entry.getKey();
            int value = ((Number)entry.getValue()).intValue();
            ((Collection)textList).add(new FormattedLine("" + '+' + value + ' ' + TranslationsKt.tr$default('[' + greatPersonName + "] points", false, 1, null), "Unit/" + greatPersonName, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
        }
        if (!((Map)specialists).isEmpty()) {
            for (Map.Entry entry : ((Map)specialists).entrySet()) {
                String specialistName = (String)entry.getKey();
                int amount = ((Number)entry.getValue()).intValue();
                ((Collection)textList).add(new FormattedLine("" + '+' + amount + ' ' + TranslationsKt.tr$default('[' + (String)specialistName + "] slots", false, 1, null), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            }
        }
        if ($this$getCivilopediaTextLines_u24lambda_u247.getRequiredNearbyImprovedResources() != null) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("Requires at least one of the following resources worked near the city:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            List<String> list2 = $this$getCivilopediaTextLines_u24lambda_u247.getRequiredNearbyImprovedResources();
            Intrinsics.checkNotNull(list2);
            Iterable $this$forEach$iv = list2;
            boolean bl2 = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl22 = false;
                Collection collection = textList;
                String string = "Resource/" + it;
                collection.add(new FormattedLine(it, string, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        if ($this$getCivilopediaTextLines_u24lambda_u247.getCityStrength() != 0 || $this$getCivilopediaTextLines_u24lambda_u247.getCityHealth() != 0 || $this$getCivilopediaTextLines_u24lambda_u247.getMaintenance() != 0) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
        }
        if ($this$getCivilopediaTextLines_u24lambda_u247.getCityStrength() != 0) {
            ((Collection)textList).add(new FormattedLine("{City strength} +" + $this$getCivilopediaTextLines_u24lambda_u247.getCityStrength(), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        if ($this$getCivilopediaTextLines_u24lambda_u247.getCityHealth() != 0) {
            ((Collection)textList).add(new FormattedLine("{City health} +" + $this$getCivilopediaTextLines_u24lambda_u247.getCityHealth(), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        if ($this$getCivilopediaTextLines_u24lambda_u247.getMaintenance() != 0) {
            ((Collection)textList).add(new FormattedLine("{Maintenance cost}: " + $this$getCivilopediaTextLines_u24lambda_u247.getMaintenance() + " {Gold}", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        ArrayList seeAlso2 = new ArrayList();
        for (Building seeAlsoBuilding : ruleset2.getBuildings().values()) {
            if (!Intrinsics.areEqual(seeAlsoBuilding.getReplaces(), $this$getCivilopediaTextLines_u24lambda_u247.getName())) {
                boolean bl3;
                block34: {
                    Iterable $this$any$iv = seeAlsoBuilding.getUniqueObjects();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            boolean bl4;
                            block33: {
                                Unique unique = (Unique)element$iv;
                                boolean bl5 = false;
                                Iterable $this$any$iv2 = unique.getParams();
                                boolean $i$f$any2 = false;
                                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                    bl4 = false;
                                } else {
                                    for (Object element$iv2 : $this$any$iv2) {
                                        String it = (String)element$iv2;
                                        boolean bl6 = false;
                                        if (!Intrinsics.areEqual(it, $this$getCivilopediaTextLines_u24lambda_u247.getName())) continue;
                                        bl4 = true;
                                        break block33;
                                    }
                                    bl4 = false;
                                }
                            }
                            if (!bl4) continue;
                            bl3 = true;
                            break block34;
                        }
                        bl3 = false;
                    }
                }
                if (!bl3) continue;
            }
            ((Collection)seeAlso2).add(new FormattedLine(seeAlsoBuilding.getName(), seeAlsoBuilding.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
        }
        CollectionsKt.addAll((Collection)seeAlso2, Belief.Companion.getCivilopediaTextMatching($this$getCivilopediaTextLines_u24lambda_u247.getName(), ruleset2, false));
        if (!((Collection)seeAlso2).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{See also}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            CollectionsKt.addAll((Collection)textList, seeAlso2);
        }
        return textList;
    }

    private final Sequence<String> getUniquesStrings(Building $this$getUniquesStrings, Function1<? super Unique, Boolean> filterUniques) {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>($this$getUniquesStrings, filterUniques, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Building $this_getUniquesStrings;
            final /* synthetic */ Function1<Unique, Boolean> $filterUniques;
            {
                this.$this_getUniquesStrings = $receiver;
                this.$filterUniques = $filterUniques;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        tileBonusHashmap = new HashMap<K, V>();
                        var4_5 /* !! */  = this.$this_getUniquesStrings.getUniqueObjects().iterator();
lbl8:
                        // 5 sources

                        while (var4_5 /* !! */ .hasNext()) {
                            unique = var4_5 /* !! */ .next();
                            if (this.$filterUniques != null && !this.$filterUniques.invoke(unique).booleanValue()) continue;
                            if (unique.getType() == UniqueType.StatsFromTiles && Intrinsics.areEqual(unique.getParams().get(2), "in this city")) {
                                stats = unique.getParams().get(0);
                                if (!tileBonusHashmap.containsKey(stats)) {
                                    ((Map)tileBonusHashmap).put(stats, new ArrayList<E>());
                                }
                                v0 = tileBonusHashmap.get(stats);
                                Intrinsics.checkNotNull(v0);
                                ((ArrayList)v0).add(unique.getParams().get(1));
                                continue;
                            }
                            this.L$0 = $this$sequence;
                            this.L$1 = tileBonusHashmap;
                            this.L$2 = var4_5 /* !! */ ;
                            this.label = 1;
                            v1 = $this$sequence.yield(unique.getDisplayText(), this);
                            if (v1 != var10_2) continue;
                            return var10_2;
                        }
                        break;
                    }
                    case 1: {
                        var4_5 /* !! */  = (Iterator<Unique>)this.L$2;
                        tileBonusHashmap = (HashMap<K, V>)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
                        ** GOTO lbl8
                    }
                }
                var4_5 /* !! */  = ((Map)tileBonusHashmap).entrySet().iterator();
lbl37:
                // 3 sources

                while (var4_5 /* !! */ .hasNext()) {
                    var5_6 = (Map.Entry)var4_5 /* !! */ .next();
                    key = (String)var5_6.getKey();
                    value = (ArrayList)var5_6.getValue();
                    var8_9 = new String[2];
                    var8_9[0] = key;
                    var9_10 = value.size() == 1 ? (String)value.get(0) : CollectionsKt.joinToString$default(value, null, null, null, 0, null, getUniquesStrings.1.INSTANCE, 31, null);
                    Intrinsics.checkNotNull(var9_10);
                    var8_9[1] = var9_10;
                    this.L$0 = $this$sequence;
                    this.L$1 = var4_5 /* !! */ ;
                    this.L$2 = null;
                    this.label = 2;
                    v2 = $this$sequence.yield(TranslationsKt.fillPlaceholders("[stats] from [tileFilter] tiles in this city", var8_9), this);
                    if (v2 != var10_2) continue;
                    return var10_2;
                }
                {
                    break;
                    case 2: {
                        var4_5 /* !! */  = (Iterator)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
                        ** GOTO lbl37
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super String> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    static /* synthetic */ Sequence getUniquesStrings$default(BuildingDescriptions buildingDescriptions, Building building, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return buildingDescriptions.getUniquesStrings(building, function1);
    }

    private final Sequence<String> getUniquesStringsWithoutDisablers(Building $this$getUniquesStringsWithoutDisablers, Function1<? super Unique, Boolean> filterUniques) {
        return this.getUniquesStrings($this$getUniquesStringsWithoutDisablers, (Function1<? super Unique, Boolean>)new Function1<Unique, Boolean>(filterUniques){
            final /* synthetic */ Function1<Unique, Boolean> $filterUniques;
            {
                this.$filterUniques = $filterUniques;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Unique it) {
                boolean bl;
                Intrinsics.checkNotNullParameter(it, "it");
                if (!it.isHiddenToUsers()) {
                    Function1<Unique, Boolean> function1 = this.$filterUniques;
                    if (function1 != null ? function1.invoke(it) : true) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        });
    }

    static /* synthetic */ Sequence getUniquesStringsWithoutDisablers$default(BuildingDescriptions buildingDescriptions, Building building, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return buildingDescriptions.getUniquesStringsWithoutDisablers(building, function1);
    }

    private static final String getCivilopediaTextLines$lambda$7$formatSignedInt(float $this$getCivilopediaTextLines_u24lambda_u247_u24formatSignedInt) {
        return ($this$getCivilopediaTextLines_u24lambda_u247_u24formatSignedInt > 0.0f ? "+" : "") + (int)$this$getCivilopediaTextLines_u24lambda_u247_u24formatSignedInt;
    }
}

