/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.popups;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.GUI;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.popups.AnimatedMenuPopup;
import com.unciv.ui.popups.CityScreenConstructionMenu;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001c\u001a\u00020\fH\u0002J\b\u0010\u001d\u001a\u00020\fH\u0002J\b\u0010\u001e\u001a\u00020\fH\u0002J\u001c\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020 0\"H\u0002J\b\u0010#\u001a\u00020 H\u0002J\b\u0010$\u001a\u00020 H\u0002J\b\u0010%\u001a\u00020 H\u0002J\b\u0010&\u001a\u00020 H\u0002J\b\u0010'\u001a\u00020 H\u0002J\b\u0010(\u001a\u00020 H\u0002J\b\u0010)\u001a\u00020 H\u0002J\b\u0010*\u001a\u00020 H\u0002J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00070,H\u0002J\n\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u00020\fH\u0002J\b\u00100\u001a\u00020\fH\u0002J\u001c\u00101\u001a\u00020\f2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\f0\"H\u0002J\b\u00103\u001a\u00020\fH\u0002J\b\u00104\u001a\u00020\fH\u0002J\b\u00105\u001a\u00020\fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0013j\b\u0012\u0004\u0012\u00020\u0011`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/unciv/ui/popups/CityScreenConstructionMenu;", "Lcom/unciv/ui/popups/AnimatedMenuPopup;", "stage", "Lcom/badlogic/gdx/scenes/scene2d/Stage;", "positionNextTo", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "city", "Lcom/unciv/logic/city/City;", "construction", "Lcom/unciv/models/ruleset/IConstruction;", "onButtonClicked", "Lkotlin/Function0;", "", "(Lcom/badlogic/gdx/scenes/scene2d/Stage;Lcom/badlogic/gdx/scenes/scene2d/Actor;Lcom/unciv/logic/city/City;Lcom/unciv/models/ruleset/IConstruction;Lkotlin/jvm/functions/Function0;)V", "cityConstructions", "Lcom/unciv/logic/city/CityConstructions;", "constructionName", "", "disabledAutoAssignConstructions", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "myIndex", "", "queueSizeWithoutPerpetual", "getQueueSizeWithoutPerpetual", "()I", "settings", "Lcom/unciv/models/metadata/GameSettings;", "addAllQueues", "addAllQueuesTop", "addQueueTop", "allCitiesEntryValid", "", "predicate", "Lkotlin/Function1;", "canAddAllQueues", "canAddAllQueuesTop", "canAddQueueTop", "canDisable", "canEnable", "canMoveQueueEnd", "canMoveQueueTop", "canRemoveAllQueues", "candidateCities", "Lkotlin/sequences/Sequence;", "createContentTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "disableEntry", "enableEntry", "forAllCities", "action", "moveQueueEnd", "moveQueueTop", "removeAllQueues", "core"})
@SourceDebugExtension(value={"SMAP\nCityScreenConstructionMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityScreenConstructionMenu.kt\ncom/unciv/ui/popups/CityScreenConstructionMenu\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1774#2,4:135\n1247#3,2:139\n1313#3,2:141\n1#4:143\n*S KotlinDebug\n*F\n+ 1 CityScreenConstructionMenu.kt\ncom/unciv/ui/popups/CityScreenConstructionMenu\n*L\n38#1:135,4\n49#1:139,2\n51#1:141,2\n*E\n"})
public final class CityScreenConstructionMenu
extends AnimatedMenuPopup {
    @NotNull
    private final City city;
    @NotNull
    private final IConstruction construction;
    @NotNull
    private final Function0<Unit> onButtonClicked;
    @NotNull
    private final CityConstructions cityConstructions;
    @NotNull
    private final String constructionName;
    private final int myIndex;
    @NotNull
    private final GameSettings settings;
    @NotNull
    private final HashSet<String> disabledAutoAssignConstructions;

    public CityScreenConstructionMenu(@NotNull Stage stage, @NotNull Actor positionNextTo, @NotNull City city2, @NotNull IConstruction construction2, @NotNull Function0<Unit> onButtonClicked) {
        Intrinsics.checkNotNullParameter(stage, "stage");
        Intrinsics.checkNotNullParameter(positionNextTo, "positionNextTo");
        Intrinsics.checkNotNullParameter(city2, "city");
        Intrinsics.checkNotNullParameter(construction2, "construction");
        Intrinsics.checkNotNullParameter(onButtonClicked, "onButtonClicked");
        super(stage, AnimatedMenuPopup.Companion.getActorTopRight(positionNextTo));
        this.city = city2;
        this.construction = construction2;
        this.onButtonClicked = onButtonClicked;
        this.cityConstructions = this.city.getCityConstructions();
        this.constructionName = this.construction.getName();
        this.myIndex = this.cityConstructions.getConstructionQueue().indexOf(this.constructionName);
        this.settings = GUI.INSTANCE.getSettings();
        this.disabledAutoAssignConstructions = this.settings.getDisabledAutoAssignConstructions();
        this.getCloseListeners().add(new Function0<Unit>(){

            @Override
            public final void invoke() {
                if (this.getAnyButtonWasClicked()) {
                    onButtonClicked.invoke();
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final int getQueueSizeWithoutPerpetual() {
        int n;
        Iterable $this$count$iv = this.cityConstructions.getConstructionQueue();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                boolean bl2 = !PerpetualConstruction.Companion.getPerpetualConstructionsMap().containsKey(it);
                if (!bl2 || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    private final Sequence<City> candidateCities() {
        return SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)this.city.getCiv().getCities()), candidateCities.1.INSTANCE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean allCitiesEntryValid(Function1<? super CityConstructions, Boolean> predicate) {
        Object element$iv;
        boolean bl;
        if (this.city.getCiv().getCities().size() <= 1) return false;
        IConstruction iConstruction = this.construction;
        Building building = iConstruction instanceof Building ? (Building)iConstruction : null;
        if (building != null) {
            if (building.isAnyWonder()) {
                return false;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return false;
        Sequence $this$any$iv = SequencesKt.map(this.candidateCities(), allCitiesEntryValid.1.INSTANCE);
        boolean $i$f$any = false;
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
        } while (!predicate.invoke((CityConstructions)(element$iv = iterator2.next())).booleanValue());
        return true;
    }

    private final void forAllCities(Function1<? super CityConstructions, Unit> action2) {
        Sequence $this$forEach$iv = SequencesKt.map(this.candidateCities(), forAllCities.1.INSTANCE);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            action2.invoke((CityConstructions)element$iv);
        }
    }

    @Override
    @Nullable
    public Table createContentTable() {
        Table table2;
        Table table3 = super.createContentTable();
        Intrinsics.checkNotNull(table3);
        Table table4 = table3;
        if (this.canMoveQueueTop()) {
            table4.add((Actor)this.getButton("Move to the top of the queue", KeyboardBinding.RaisePriority, new Function0<Unit>((Object)this){

                public final void invoke() {
                    CityScreenConstructionMenu.access$moveQueueTop((CityScreenConstructionMenu)this.receiver);
                }
            })).row();
        }
        if (this.canMoveQueueEnd()) {
            table4.add((Actor)this.getButton("Move to the end of the queue", KeyboardBinding.LowerPriority, new Function0<Unit>((Object)this){

                public final void invoke() {
                    CityScreenConstructionMenu.access$moveQueueEnd((CityScreenConstructionMenu)this.receiver);
                }
            })).row();
        }
        if (this.canAddQueueTop()) {
            table4.add((Actor)this.getButton("Add to the top of the queue", KeyboardBinding.AddConstructionTop, new Function0<Unit>((Object)this){

                public final void invoke() {
                    CityScreenConstructionMenu.access$addQueueTop((CityScreenConstructionMenu)this.receiver);
                }
            })).row();
        }
        if (this.canAddAllQueues()) {
            table4.add((Actor)this.getButton("Add to the queue in all cities", KeyboardBinding.AddConstructionAll, new Function0<Unit>((Object)this){

                public final void invoke() {
                    CityScreenConstructionMenu.access$addAllQueues((CityScreenConstructionMenu)this.receiver);
                }
            })).row();
        }
        if (this.canAddAllQueuesTop()) {
            table4.add((Actor)this.getButton("Add or move to the top in all cities", KeyboardBinding.AddConstructionAllTop, new Function0<Unit>((Object)this){

                public final void invoke() {
                    CityScreenConstructionMenu.access$addAllQueuesTop((CityScreenConstructionMenu)this.receiver);
                }
            })).row();
        }
        if (this.canRemoveAllQueues()) {
            table4.add((Actor)this.getButton("Remove from the queue in all cities", KeyboardBinding.RemoveConstructionAll, new Function0<Unit>((Object)this){

                public final void invoke() {
                    CityScreenConstructionMenu.access$removeAllQueues((CityScreenConstructionMenu)this.receiver);
                }
            })).row();
        }
        if (this.canDisable()) {
            table4.add((Actor)this.getButton("Disable", KeyboardBinding.BuildDisabled, new Function0<Unit>((Object)this){

                public final void invoke() {
                    CityScreenConstructionMenu.access$disableEntry((CityScreenConstructionMenu)this.receiver);
                }
            })).row();
        }
        if (this.canEnable()) {
            table4.add((Actor)this.getButton("Enable", KeyboardBinding.BuildDisabled, new Function0<Unit>((Object)this){

                public final void invoke() {
                    CityScreenConstructionMenu.access$enableEntry((CityScreenConstructionMenu)this.receiver);
                }
            })).row();
        }
        Table it = table2 = table4;
        boolean bl = false;
        return !it.getCells().isEmpty() ? table2 : null;
    }

    private final boolean canMoveQueueTop() {
        if (this.construction instanceof PerpetualConstruction) {
            return false;
        }
        return this.myIndex > 0;
    }

    private final void moveQueueTop() {
        this.cityConstructions.moveEntryToTop(this.myIndex);
    }

    private final boolean canMoveQueueEnd() {
        if (this.construction instanceof PerpetualConstruction) {
            return false;
        }
        int n = this.getQueueSizeWithoutPerpetual() - 1;
        int n2 = this.myIndex;
        return 0 <= n2 ? n2 < n : false;
    }

    private final void moveQueueEnd() {
        this.cityConstructions.moveEntryToEnd(this.myIndex);
    }

    private final boolean canAddQueueTop() {
        return !(this.construction instanceof PerpetualConstruction) && this.cityConstructions.canAddToQueue(this.construction);
    }

    private final void addQueueTop() {
        this.cityConstructions.addToQueue(this.construction, true);
    }

    private final boolean canAddAllQueues() {
        return this.allCitiesEntryValid((Function1<? super CityConstructions, Boolean>)new Function1<CityConstructions, Boolean>(this){
            final /* synthetic */ CityScreenConstructionMenu this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull CityConstructions it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.canAddToQueue(CityScreenConstructionMenu.access$getConstruction$p(this.this$0)) && (!(CityScreenConstructionMenu.access$getConstruction$p(this.this$0) instanceof PerpetualConstruction) || !it.isBeingConstructedOrEnqueued(CityScreenConstructionMenu.access$getConstructionName$p(this.this$0)));
            }
        });
    }

    private final void addAllQueues() {
        this.forAllCities((Function1<? super CityConstructions, Unit>)new Function1<CityConstructions, Unit>(this){
            final /* synthetic */ CityScreenConstructionMenu this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull CityConstructions it) {
                Intrinsics.checkNotNullParameter(it, "it");
                CityConstructions.addToQueue$default(it, CityScreenConstructionMenu.access$getConstruction$p(this.this$0), false, 2, null);
            }
        });
    }

    private final boolean canAddAllQueuesTop() {
        return !(this.construction instanceof PerpetualConstruction) && this.allCitiesEntryValid((Function1<? super CityConstructions, Boolean>)new Function1<CityConstructions, Boolean>(this){
            final /* synthetic */ CityScreenConstructionMenu this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull CityConstructions it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.canAddToQueue(CityScreenConstructionMenu.access$getConstruction$p(this.this$0)) || it.isEnqueuedForLater(CityScreenConstructionMenu.access$getConstructionName$p(this.this$0));
            }
        });
    }

    private final void addAllQueuesTop() {
        this.forAllCities((Function1<? super CityConstructions, Unit>)new Function1<CityConstructions, Unit>(this){
            final /* synthetic */ CityScreenConstructionMenu this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull CityConstructions it) {
                Intrinsics.checkNotNullParameter(it, "it");
                int index = it.getConstructionQueue().indexOf(CityScreenConstructionMenu.access$getConstructionName$p(this.this$0));
                if (index > 0) {
                    it.moveEntryToTop(index);
                } else {
                    it.addToQueue(CityScreenConstructionMenu.access$getConstruction$p(this.this$0), true);
                }
            }
        });
    }

    private final boolean canRemoveAllQueues() {
        return this.allCitiesEntryValid((Function1<? super CityConstructions, Boolean>)new Function1<CityConstructions, Boolean>(this){
            final /* synthetic */ CityScreenConstructionMenu this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull CityConstructions it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isBeingConstructedOrEnqueued(CityScreenConstructionMenu.access$getConstructionName$p(this.this$0));
            }
        });
    }

    private final void removeAllQueues() {
        this.forAllCities((Function1<? super CityConstructions, Unit>)new Function1<CityConstructions, Unit>(this){
            final /* synthetic */ CityScreenConstructionMenu this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull CityConstructions it) {
                Intrinsics.checkNotNullParameter(it, "it");
                it.removeAllByName(CityScreenConstructionMenu.access$getConstructionName$p(this.this$0));
            }
        });
    }

    private final boolean canDisable() {
        return !this.disabledAutoAssignConstructions.contains(this.constructionName) && !Intrinsics.areEqual(this.construction, PerpetualConstruction.Companion.getIdle());
    }

    private final void disableEntry() {
        this.disabledAutoAssignConstructions.add(this.constructionName);
        this.settings.save();
    }

    private final boolean canEnable() {
        return this.disabledAutoAssignConstructions.contains(this.constructionName);
    }

    private final void enableEntry() {
        this.disabledAutoAssignConstructions.remove(this.constructionName);
        this.settings.save();
    }

    public static final /* synthetic */ void access$moveQueueTop(CityScreenConstructionMenu $this) {
        $this.moveQueueTop();
    }

    public static final /* synthetic */ void access$moveQueueEnd(CityScreenConstructionMenu $this) {
        $this.moveQueueEnd();
    }

    public static final /* synthetic */ void access$addQueueTop(CityScreenConstructionMenu $this) {
        $this.addQueueTop();
    }

    public static final /* synthetic */ void access$addAllQueues(CityScreenConstructionMenu $this) {
        $this.addAllQueues();
    }

    public static final /* synthetic */ void access$addAllQueuesTop(CityScreenConstructionMenu $this) {
        $this.addAllQueuesTop();
    }

    public static final /* synthetic */ void access$removeAllQueues(CityScreenConstructionMenu $this) {
        $this.removeAllQueues();
    }

    public static final /* synthetic */ void access$disableEntry(CityScreenConstructionMenu $this) {
        $this.disableEntry();
    }

    public static final /* synthetic */ void access$enableEntry(CityScreenConstructionMenu $this) {
        $this.enableEntry();
    }

    public static final /* synthetic */ IConstruction access$getConstruction$p(CityScreenConstructionMenu $this) {
        return $this.construction;
    }

    public static final /* synthetic */ String access$getConstructionName$p(CityScreenConstructionMenu $this) {
        return $this.constructionName;
    }
}

