/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.popups.options;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.UncivGame;
import com.unciv.models.UncivSound;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.MusicController;
import com.unciv.ui.audio.MusicTrackChooserFlags;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.UncivSlider;
import com.unciv.ui.components.widgets.WrappableLabel;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.options.OptionsPopup;
import com.unciv.ui.popups.options.SoundTabKt;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u001e\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b\u001a\u0018\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a \u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a \u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u000e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a:\u0010\u0013\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00010\u001bH\u0002\u00a8\u0006\u001c"}, d2={"addCitySoundsVolumeSlider", "", "table", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "settings", "Lcom/unciv/models/metadata/GameSettings;", "addDownloadMusic", "optionsPopup", "Lcom/unciv/ui/popups/options/OptionsPopup;", "addMusicControls", "music", "Lcom/unciv/ui/audio/MusicController;", "addMusicCurrentlyPlaying", "addMusicPauseSlider", "addMusicVolumeSlider", "addSimplePlayerControls", "addSoundEffectsVolumeSlider", "addVoicesVolumeSlider", "soundTab", "addVolumeSlider", "text", "", "initial", "", "silent", "", "onChange", "Lkotlin/Function1;", "core"})
public final class SoundTabKt {
    @NotNull
    public static final Table soundTab(@NotNull OptionsPopup optionsPopup) {
        Table table2;
        Intrinsics.checkNotNullParameter(optionsPopup, "optionsPopup");
        Table $this$soundTab_u24lambda_u240 = table2 = new Table(BaseScreen.Companion.getSkin());
        boolean bl = false;
        $this$soundTab_u24lambda_u240.pad(10.0f);
        $this$soundTab_u24lambda_u240.defaults().pad(5.0f);
        GameSettings settings = optionsPopup.getSettings();
        MusicController music = UncivGame.Companion.getCurrent().getMusicController();
        SoundTabKt.addSoundEffectsVolumeSlider($this$soundTab_u24lambda_u240, settings);
        SoundTabKt.addCitySoundsVolumeSlider($this$soundTab_u24lambda_u240, settings);
        if (UncivGame.Companion.getCurrent().getMusicController().isVoicesAvailable()) {
            SoundTabKt.addVoicesVolumeSlider($this$soundTab_u24lambda_u240, settings);
        }
        if (UncivGame.Companion.getCurrent().getMusicController().isMusicAvailable()) {
            SoundTabKt.addMusicControls($this$soundTab_u24lambda_u240, settings, music);
        }
        if (!UncivGame.Companion.getCurrent().getMusicController().isDefaultFileAvailable()) {
            SoundTabKt.addDownloadMusic($this$soundTab_u24lambda_u240, optionsPopup);
        }
        return table2;
    }

    private static final void addDownloadMusic(Table table2, OptionsPopup optionsPopup) {
        TextButton downloadMusicButton = Scene2dExtensionsKt.toTextButton$default("Download music", null, false, 3, null);
        table2.add((Actor)downloadMusicButton).colspan(2).row();
        Table errorTable = new Table();
        table2.add((Actor)errorTable).colspan(2).row();
        ActivationExtensionsKt.onClick(downloadMusicButton, new Function0<Unit>(downloadMusicButton, errorTable, optionsPopup){
            final /* synthetic */ TextButton $downloadMusicButton;
            final /* synthetic */ Table $errorTable;
            final /* synthetic */ OptionsPopup $optionsPopup;
            {
                this.$downloadMusicButton = $downloadMusicButton;
                this.$errorTable = $errorTable;
                this.$optionsPopup = $optionsPopup;
                super(0);
            }

            public final void invoke() {
                Scene2dExtensionsKt.disable(this.$downloadMusicButton);
                this.$errorTable.clear();
                this.$errorTable.add((Actor)Scene2dExtensionsKt.toLabel("Downloading..."));
                Concurrency.run$default(Concurrency.INSTANCE, "MusicDownload", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$optionsPopup, this.$errorTable, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ OptionsPopup $optionsPopup;
                    final /* synthetic */ Table $errorTable;
                    {
                        this.$optionsPopup = $optionsPopup;
                        this.$errorTable = $errorTable;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                CoroutineScope $this$run = (CoroutineScope)this.L$0;
                                try {
                                    UncivGame.Companion.getCurrent().getMusicController().downloadDefaultFile();
                                    ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$optionsPopup, null){
                                        int label;
                                        final /* synthetic */ OptionsPopup $optionsPopup;
                                        {
                                            this.$optionsPopup = $optionsPopup;
                                            super(2, $completion);
                                        }

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object object) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure(object);
                                                    this.$optionsPopup.getTabs().replacePage("Sound", (Actor)SoundTabKt.soundTab(this.$optionsPopup));
                                                    MusicController.chooseTrack$default(UncivGame.Companion.getCurrent().getMusicController(), null, null, MusicTrackChooserFlags.Companion.getSetPlayDefault(), 3, null);
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }, 1, null);
                                }
                                catch (Exception exception2) {
                                    ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$errorTable, null){
                                        int label;
                                        final /* synthetic */ Table $errorTable;
                                        {
                                            this.$errorTable = $errorTable;
                                            super(2, $completion);
                                        }

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object object) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure(object);
                                                    this.$errorTable.clear();
                                                    Color color = Color.RED;
                                                    Intrinsics.checkNotNullExpressionValue(color, "RED");
                                                    this.$errorTable.add((Actor)Scene2dExtensionsKt.toLabel$default("Could not download music!", color, 0, 0, false, 14, null));
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }, 1, null);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)((Object)function2);
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 2, null);
            }
        });
    }

    private static final void addVolumeSlider(Table $this$addVolumeSlider, String text2, float initial, boolean silent, Function1<? super Float, Unit> onChange) {
        $this$addVolumeSlider.add(TranslationsKt.tr$default(text2, false, 1, null)).left().fillX();
        UncivSlider volumeSlider2 = new UncivSlider(0.0f, 1.0f, 0.05f, false, false, initial, silent ? UncivSound.Companion.getSilent() : UncivSound.Companion.getSlider(), null, new Function1<Float, String>((Object)UncivSlider.Companion){

            @NotNull
            public final String invoke(float p0) {
                return ((UncivSlider.Companion)this.receiver).formatPercent(p0);
            }
        }, onChange, 152, null);
        $this$addVolumeSlider.add((Actor)volumeSlider2).pad(5.0f).row();
    }

    static /* synthetic */ void addVolumeSlider$default(Table table2, String string, float f, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        SoundTabKt.addVolumeSlider(table2, string, f, bl, function1);
    }

    private static final void addSoundEffectsVolumeSlider(Table table2, GameSettings settings) {
        SoundTabKt.addVolumeSlider$default(table2, "Sound effects volume", settings.getSoundEffectsVolume(), false, new Function1<Float, Unit>(settings){
            final /* synthetic */ GameSettings $settings;
            {
                this.$settings = $settings;
                super(1);
            }

            public final void invoke(float it) {
                this.$settings.setSoundEffectsVolume(it);
            }
        }, 4, null);
    }

    private static final void addCitySoundsVolumeSlider(Table table2, GameSettings settings) {
        SoundTabKt.addVolumeSlider$default(table2, "City ambient sound volume", settings.getCitySoundsVolume(), false, new Function1<Float, Unit>(settings){
            final /* synthetic */ GameSettings $settings;
            {
                this.$settings = $settings;
                super(1);
            }

            public final void invoke(float it) {
                this.$settings.setCitySoundsVolume(it);
            }
        }, 4, null);
    }

    private static final void addVoicesVolumeSlider(Table table2, GameSettings settings) {
        SoundTabKt.addVolumeSlider$default(table2, "Leader voices volume", settings.getVoicesVolume(), false, new Function1<Float, Unit>(settings){
            final /* synthetic */ GameSettings $settings;
            {
                this.$settings = $settings;
                super(1);
            }

            public final void invoke(float it) {
                this.$settings.setVoicesVolume(it);
            }
        }, 4, null);
    }

    private static final void addMusicVolumeSlider(Table table2, GameSettings settings, MusicController music) {
        SoundTabKt.addVolumeSlider(table2, TranslationsKt.tr$default("Music volume", false, 1, null), settings.getMusicVolume(), true, (Function1<? super Float, Unit>)new Function1<Float, Unit>(settings, music){
            final /* synthetic */ GameSettings $settings;
            final /* synthetic */ MusicController $music;
            {
                this.$settings = $settings;
                this.$music = $music;
                super(1);
            }

            public final void invoke(float it) {
                this.$settings.setMusicVolume(it);
                this.$music.setVolume(it);
                if (!this.$music.isPlaying()) {
                    MusicController.chooseTrack$default(this.$music, null, null, MusicTrackChooserFlags.Companion.getSetPlayDefault(), 3, null);
                }
            }
        });
    }

    private static final void addMusicPauseSlider(Table table2, GameSettings settings, MusicController music) {
        Function1 getTipText2 = addMusicPauseSlider.getTipText.1.INSTANCE;
        table2.add(TranslationsKt.tr$default("Pause between tracks", false, 1, null)).left().fillX();
        UncivSlider pauseLengthSlider2 = new UncivSlider(0.0f, 30.0f, 1.0f, false, false, SoundTabKt.addMusicPauseSlider$lengthToPos(music.getSilenceLength()), UncivSound.Companion.getSilent(), null, getTipText2, new Function1<Float, Unit>(music, settings){
            final /* synthetic */ MusicController $music;
            final /* synthetic */ GameSettings $settings;
            {
                this.$music = $music;
                this.$settings = $settings;
                super(1);
            }

            public final void invoke(float it) {
                this.$music.setSilenceLength(SoundTabKt.access$addMusicPauseSlider$posToLength(it));
                this.$settings.setPauseBetweenTracks((int)this.$music.getSilenceLength());
            }
        }, 152, null);
        table2.add((Actor)pauseLengthSlider2).pad(5.0f).row();
    }

    private static final void addMusicCurrentlyPlaying(Table table2, MusicController music) {
        block0: {
            WrappableLabel label2 = new WrappableLabel("", table2.getWidth() - 10.0f, new Color(-3100673), 16, false, 16, null);
            label2.setWrap(true);
            table2.add((Actor)label2).padTop(20.0f).colspan(2).fillX().row();
            music.onChange((Function1<? super MusicController.MusicTrackInfo, Unit>)new Function1<MusicController.MusicTrackInfo, Unit>(label2){
                final /* synthetic */ WrappableLabel $label;
                {
                    this.$label = $label;
                    super(1);
                }

                public final void invoke(@NotNull MusicController.MusicTrackInfo it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    this.$label.setText(TranslationsKt.tr$default("Currently playing: [" + it + ']', false, 1, null));
                }
            });
            Popup popup2 = table2.firstAscendant(Popup.class);
            if (popup2 == null) break block0;
            Popup $this$addMusicCurrentlyPlaying_u24lambda_u241 = popup2;
            boolean bl = false;
            $this$addMusicCurrentlyPlaying_u24lambda_u241.getCloseListeners().add(new Function0<Unit>(music){
                final /* synthetic */ MusicController $music;
                {
                    this.$music = $music;
                    super(0);
                }

                public final void invoke() {
                    this.$music.onChange(null);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void addSimplePlayerControls(Table table2, MusicController music) {
        void $this$addSimplePlayerControls_u24lambda_u242;
        Table table3;
        Table table4 = table3 = new Table();
        Table table5 = table2;
        boolean bl = false;
        $this$addSimplePlayerControls_u24lambda_u242.defaults().space(25.0f);
        Color color = Color.GOLD;
        Intrinsics.checkNotNullExpressionValue(color, "GOLD");
        $this$addSimplePlayerControls_u24lambda_u242.add(ActivationExtensionsKt.onClick(SoundTabKt.addSimplePlayerControls$toImageButton("OtherIcons/Pause", color), new Function0<Unit>(music){
            final /* synthetic */ MusicController $music;
            {
                this.$music = $music;
                super(0);
            }

            public final void invoke() {
                this.$music.pause(0.5f);
            }
        }));
        Color color2 = Color.LIME;
        Intrinsics.checkNotNullExpressionValue(color2, "LIME");
        $this$addSimplePlayerControls_u24lambda_u242.add(ActivationExtensionsKt.onClick(SoundTabKt.addSimplePlayerControls$toImageButton("OtherIcons/ForwardArrow", color2), new Function0<Unit>(music){
            final /* synthetic */ MusicController $music;
            {
                this.$music = $music;
                super(0);
            }

            public final void invoke() {
                this.$music.resume(0.5f);
            }
        }));
        Color color3 = Color.VIOLET;
        Intrinsics.checkNotNullExpressionValue(color3, "VIOLET");
        $this$addSimplePlayerControls_u24lambda_u242.add(ActivationExtensionsKt.onClick(SoundTabKt.addSimplePlayerControls$toImageButton("OtherIcons/Loading", color3), new Function0<Unit>(music){
            final /* synthetic */ MusicController $music;
            {
                this.$music = $music;
                super(0);
            }

            public final void invoke() {
                MusicController.chooseTrack$default(this.$music, null, null, MusicTrackChooserFlags.Companion.getNone(), 3, null);
            }
        }));
        table5.add((Actor)table3).colspan(2).center().row();
    }

    public static final void addMusicControls(@NotNull Table table2, @NotNull GameSettings settings, @NotNull MusicController music) {
        Intrinsics.checkNotNullParameter(table2, "table");
        Intrinsics.checkNotNullParameter(settings, "settings");
        Intrinsics.checkNotNullParameter(music, "music");
        SoundTabKt.addMusicVolumeSlider(table2, settings, music);
        SoundTabKt.addMusicPauseSlider(table2, settings, music);
        SoundTabKt.addMusicCurrentlyPlaying(table2, music);
        SoundTabKt.addSimplePlayerControls(table2, music);
    }

    private static final float addMusicPauseSlider$posToLength(float pos) {
        float f;
        block1: {
            float f2;
            block0: {
                f2 = pos;
                boolean bl = 0.0f <= f2 ? f2 <= 10.0f : false;
                if (!bl) break block0;
                f = pos;
                break block1;
            }
            f = (11.0f <= f2 ? f2 <= 20.0f : false) ? pos * 2.0f - 10.0f : ((21.0f <= f2 ? f2 <= 26.0f : false) ? pos * 5.0f - 70.0f : pos * 15.0f - 330.0f);
        }
        return f;
    }

    private static final float addMusicPauseSlider$lengthToPos(float length) {
        float f;
        block1: {
            float f2;
            block0: {
                f2 = length;
                boolean bl = 0.0f <= f2 ? f2 <= 10.0f : false;
                if (!bl) break block0;
                f = length;
                break block1;
            }
            f = (11.0f <= f2 ? f2 <= 30.0f : false) ? (length + 10.0f) / 2.0f : ((31.0f <= f2 ? f2 <= 60.0f : false) ? (length + 10.0f) / 5.0f : (length + 330.0f) / 15.0f);
        }
        return (float)Math.floor(f);
    }

    private static final Group addSimplePlayerControls$toImageButton(String $this$addSimplePlayerControls_u24toImageButton, Color overColor) {
        Color color = Color.CLEAR;
        Intrinsics.checkNotNullExpressionValue(color, "CLEAR");
        return Scene2dExtensionsKt.toImageButton($this$addSimplePlayerControls_u24toImageButton, 30.0f, 30.0f, color, overColor);
    }

    public static final /* synthetic */ float access$addMusicPauseSlider$posToLength(float pos) {
        return SoundTabKt.addMusicPauseSlider$posToLength(pos);
    }
}

