/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.cityscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityFocus;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.cityscreen.CityScreen;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010J\u0006\u0010\u0012\u001a\u00020\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/unciv/ui/screens/cityscreen/CitizenManagementTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "cityScreen", "Lcom/unciv/ui/screens/cityscreen/CityScreen;", "(Lcom/unciv/ui/screens/cityscreen/CityScreen;)V", "city", "Lcom/unciv/logic/city/City;", "getCity", "()Lcom/unciv/logic/city/City;", "getCityScreen", "()Lcom/unciv/ui/screens/cityscreen/CityScreen;", "numCol", "", "asExpander", "Lcom/unciv/ui/components/widgets/ExpanderTab;", "onChange", "Lkotlin/Function0;", "", "update", "core"})
public final class CitizenManagementTable
extends Table {
    @NotNull
    private final CityScreen cityScreen;
    @NotNull
    private final City city;
    private final int numCol;

    public CitizenManagementTable(@NotNull CityScreen cityScreen) {
        Intrinsics.checkNotNullParameter(cityScreen, "cityScreen");
        super(BaseScreen.Companion.getSkin());
        this.cityScreen = cityScreen;
        this.city = this.cityScreen.getCity$core();
        this.numCol = 4;
    }

    @NotNull
    public final CityScreen getCityScreen() {
        return this.cityScreen;
    }

    @NotNull
    public final City getCity() {
        return this.city;
    }

    public final void update() {
        this.clear();
        Color colorSelected = BaseScreen.Companion.getSkin().getColor("selection");
        Color colorButton = BaseScreen.Companion.getSkin().getColor("color");
        Table topTable = new Table();
        Label resetLabel = Scene2dExtensionsKt.toLabel("Reset Citizens");
        Table resetCell = new Table();
        resetCell.add((Actor)resetLabel).pad(5.0f);
        if (this.cityScreen.canCityBeChanged()) {
            resetCell.setTouchable(Touchable.enabled);
            ActivationExtensionsKt.onActivation$default(resetCell, null, KeyboardBinding.ResetCitizens, new Function0<Unit>(this){
                final /* synthetic */ CitizenManagementTable this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.getCity().reassignPopulation(true);
                    this.this$0.getCityScreen().update$core();
                }
            }, 1, null);
        }
        resetCell.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CitizenManagementTable/ResetCell", null, colorButton, 2, null));
        topTable.add((Actor)resetCell).pad(3.0f);
        Label avoidLabel = Scene2dExtensionsKt.toLabel("Avoid Growth");
        Table avoidCell = new Table();
        avoidCell.add((Actor)avoidLabel).pad(5.0f);
        if (this.cityScreen.canCityBeChanged()) {
            avoidCell.setTouchable(Touchable.enabled);
            ActivationExtensionsKt.onActivation$default(avoidCell, null, KeyboardBinding.AvoidGrowth, new Function0<Unit>(this){
                final /* synthetic */ CitizenManagementTable this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.getCity().setAvoidGrowth(!this.this$0.getCity().getAvoidGrowth());
                    City.reassignPopulation$default(this.this$0.getCity(), false, 1, null);
                    this.this$0.getCityScreen().update$core();
                }
            }, 1, null);
        }
        avoidCell.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CitizenManagementTable/AvoidCell", null, this.city.getAvoidGrowth() ? colorSelected : colorButton, 2, null));
        topTable.add((Actor)avoidCell).pad(3.0f);
        this.add((Actor)topTable).colspan(this.numCol).growX();
        this.row();
        Label focusLabel = Scene2dExtensionsKt.toLabel("Citizen Focus");
        Table focusCell = new Table();
        focusCell.add((Actor)focusLabel).pad(5.0f);
        this.add((Actor)focusCell).colspan(this.numCol).growX().pad(3.0f);
        this.row();
        int currCol = this.numCol;
        Table defaultTable = new Table();
        for (CityFocus focus : CityFocus.values()) {
            if (!focus.getTableEnabled() || focus == CityFocus.FaithFocus && !this.city.getCiv().getGameInfo().isReligionEnabled()) continue;
            Label label2 = Scene2dExtensionsKt.toLabel(focus.getLabel());
            Table cell2 = new Table();
            cell2.add((Actor)label2).pad(5.0f);
            if (this.cityScreen.canCityBeChanged()) {
                cell2.setTouchable(Touchable.enabled);
                KeyboardBinding binding = this.city.getCityFocus() == focus ? focus.getBinding() : KeyboardBinding.None;
                ActivationExtensionsKt.onActivation$default(cell2, null, binding, new Function0<Unit>(this, focus){
                    final /* synthetic */ CitizenManagementTable this$0;
                    final /* synthetic */ CityFocus $focus;
                    {
                        this.this$0 = $receiver;
                        this.$focus = $focus;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.getCity().setCityFocus(this.$focus);
                        City.reassignPopulation$default(this.this$0.getCity(), false, 1, null);
                        this.this$0.getCityScreen().update$core();
                    }
                }, 1, null);
            }
            cell2.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "CityScreen/CitizenManagementTable/FocusCell", null, this.city.getCityFocus() == focus ? colorSelected : colorButton, 2, null));
            if (focus == CityFocus.NoFocus) {
                defaultTable.add((Actor)cell2).growX().pad(3.0f);
                continue;
            }
            if (focus == CityFocus.Manual) {
                defaultTable.add((Actor)cell2).growX().pad(3.0f);
                this.add((Actor)defaultTable).colspan(this.numCol).growX();
                this.row();
                continue;
            }
            cell2.padTop(5.0f);
            this.add((Actor)cell2).growX().pad(3.0f);
            if (--currCol != 0) continue;
            this.row();
            currCol = this.numCol;
        }
        this.pack();
    }

    @NotNull
    public final ExpanderTab asExpander(@Nullable Function0<Unit> onChange) {
        KeyboardBinding keyboardBinding = KeyboardBinding.CitizenManagement;
        return new ExpanderTab("{Citizen Management}", 18, null, false, 0.0f, 0.0f, 0.0f, "CityStatsTable.CitizenManagement", keyboardBinding, onChange, new Function1<Table, Unit>(this){
            final /* synthetic */ CitizenManagementTable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Table it) {
                Intrinsics.checkNotNullParameter(it, "it");
                it.add((Actor)this.this$0);
                this.this$0.update();
            }
        }, 116, null);
    }
}

