/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.civilopediascreen;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.utils.Array;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.stats.INamed;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.basescreen.TutorialController;
import com.unciv.ui.screens.civilopediascreen.CivilopediaCategories;
import com.unciv.ui.screens.civilopediascreen.CivilopediaScreen;
import com.unciv.ui.screens.civilopediascreen.CivilopediaSearchPopup;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.ICivilopediaText;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002&'B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001c\u001a\u00020\tH\u0002J\b\u0010\u001d\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\u0014\u0010 \u001a\u00020\t*\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0014\u0010$\u001a\u00020\t*\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\f\u0010%\u001a\u00020\t*\u00020!H\u0002R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/unciv/ui/screens/civilopediascreen/CivilopediaSearchPopup;", "Lcom/unciv/ui/popups/Popup;", "pediaScreen", "Lcom/unciv/ui/screens/civilopediascreen/CivilopediaScreen;", "tutorialController", "Lcom/unciv/ui/screens/basescreen/TutorialController;", "linkAction", "Lkotlin/Function1;", "", "", "(Lcom/unciv/ui/screens/civilopediascreen/CivilopediaScreen;Lcom/unciv/ui/screens/basescreen/TutorialController;Lkotlin/jvm/functions/Function1;)V", "checkLine", "", "modSelect", "Lcom/unciv/ui/screens/civilopediascreen/CivilopediaSearchPopup$ModSelectBox;", "resultCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "resultExpander", "Lcom/unciv/ui/components/widgets/ExpanderTab;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "searchButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "searchJob", "Lkotlinx/coroutines/Job;", "searchText", "Lcom/unciv/ui/components/widgets/UncivTextField;", "finishSearch", "isSearchRunning", "startSearch", "text", "addResult", "Lkotlinx/coroutines/CoroutineScope;", "entry", "Lcom/unciv/ui/screens/civilopediascreen/ICivilopediaText;", "searchEntry", "searchLoop", "ModSelectBox", "ModSelectEntry", "core"})
public final class CivilopediaSearchPopup
extends Popup {
    @NotNull
    private final CivilopediaScreen pediaScreen;
    @NotNull
    private final TutorialController tutorialController;
    @NotNull
    private final Function1<String, Unit> linkAction;
    @NotNull
    private Ruleset ruleset;
    @NotNull
    private final UncivTextField searchText;
    @NotNull
    private final ModSelectBox modSelect;
    private ExpanderTab resultExpander;
    @NotNull
    private final Cell<Actor> resultCell;
    @NotNull
    private final TextButton searchButton;
    @Nullable
    private Job searchJob;
    @NotNull
    private Function1<? super String, Boolean> checkLine;

    public CivilopediaSearchPopup(@NotNull CivilopediaScreen pediaScreen, @NotNull TutorialController tutorialController2, @NotNull Function1<? super String, Unit> linkAction) {
        Intrinsics.checkNotNullParameter(pediaScreen, "pediaScreen");
        Intrinsics.checkNotNullParameter(tutorialController2, "tutorialController");
        Intrinsics.checkNotNullParameter(linkAction, "linkAction");
        super(pediaScreen, null, 0.0f, 6, null);
        this.pediaScreen = pediaScreen;
        this.tutorialController = tutorialController2;
        this.linkAction = linkAction;
        this.ruleset = this.pediaScreen.getRuleset();
        this.searchText = new UncivTextField("", null, null, 6, null);
        this.modSelect = new ModSelectBox();
        this.checkLine = checkLine.1.INSTANCE;
        this.searchText.setMaxLength(100);
        this.add((Actor)Scene2dExtensionsKt.toLabel("Search text:"));
        this.add((Actor)this.searchText).growX().row();
        this.add((Actor)Scene2dExtensionsKt.toLabel("Mod filter:"));
        this.add((Actor)this.modSelect).growX().row();
        Cell<Actor> cell2 = this.add().colspan(2).growX();
        Intrinsics.checkNotNullExpressionValue(cell2, "growX(...)");
        this.resultCell = cell2;
        this.row();
        Object t = Popup.addButton$default((Popup)this, "Search!", KeyCharAndCode.Companion.getRETURN(), null, (Function0)new Function0<Unit>(){

            @Override
            public final void invoke() {
                String string = searchText.getText();
                Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                this.startSearch(string);
            }
        }, 4, null).getActor();
        Intrinsics.checkNotNullExpressionValue(t, "getActor(...)");
        this.searchButton = (TextButton)t;
        Popup.addCloseButton$default(this, null, null, null, null, 15, null);
        this.getShowListeners().add(new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.setKeyboardFocus(searchText);
                searchText.selectAll();
            }
        });
        this.getCloseListeners().add(new Function0<Unit>(){

            @Override
            public final void invoke() {
                if (this.isSearchRunning()) {
                    Job job2 = searchJob;
                    Intrinsics.checkNotNull(job2);
                    Job.DefaultImpls.cancel$default(job2, null, 1, null);
                }
            }
        });
    }

    private final boolean isSearchRunning() {
        Job job2 = this.searchJob;
        return job2 != null ? job2.isActive() : false;
    }

    private final void startSearch(String text2) {
        Scene2dExtensionsKt.disable(this.searchButton);
        Gdx.input.setOnscreenKeyboardVisible(false);
        if (((CharSequence)text2).length() == 0) {
            this.checkLine = startSearch.1.INSTANCE;
        } else if (StringsKt.contains$default((CharSequence)text2, ".*", false, 2, null) || StringsKt.contains$default((CharSequence)text2, '\\', false, 2, null) || StringsKt.contains$default((CharSequence)text2, '|', false, 2, null)) {
            try {
                Regex regex = new Regex(text2, RegexOption.IGNORE_CASE);
                this.checkLine = new Function1<String, Boolean>(regex){
                    final /* synthetic */ Regex $regex;
                    {
                        this.$regex = $regex;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return this.$regex.containsMatchIn(it);
                    }
                };
            }
            catch (Exception ex) {
                new ToastPopup("Invalid regular expression", this.pediaScreen, 4000L);
                Scene2dExtensionsKt.enable(this.searchButton);
                return;
            }
        } else {
            char[] cArray = new char[]{' '};
            Set<String> words = CollectionsKt.toSet(StringsKt.split$default((CharSequence)text2, cArray, false, 0, 6, null));
            this.checkLine = new Function1<String, Boolean>(words){
                final /* synthetic */ Set<String> $words;
                {
                    this.$words = $words;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull String line) {
                    boolean bl;
                    block3: {
                        Intrinsics.checkNotNullParameter(line, "line");
                        Iterable $this$all$iv = this.$words;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                String it = (String)element$iv;
                                boolean bl2 = false;
                                if (StringsKt.contains((CharSequence)line, it, true)) continue;
                                bl = false;
                                break block3;
                            }
                            bl = true;
                        }
                    }
                    return bl;
                }
            };
        }
        this.ruleset = this.modSelect.selectedRuleset();
        if (this.resultExpander != null) {
            ExpanderTab expanderTab2 = this.resultExpander;
            if (expanderTab2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("resultExpander");
                expanderTab2 = null;
            }
            expanderTab2.getInnerTable().clear();
        } else {
            this.resultExpander = new ExpanderTab("Results", 0, null, false, 0.0f, 0.0f, 0.0f, null, null, null, startSearch.4.INSTANCE, 1022, null);
            ExpanderTab expanderTab3 = this.resultExpander;
            if (expanderTab3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("resultExpander");
                expanderTab3 = null;
            }
            this.resultCell.setActor((Actor)expanderTab3);
            ExpanderTab expanderTab4 = this.resultExpander;
            if (expanderTab4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("resultExpander");
                expanderTab4 = null;
            }
            expanderTab4.getInnerTable().defaults().growX().pad(2.0f);
        }
        Job job2 = this.searchJob = Concurrency.run$default(Concurrency.INSTANCE, "PediaSearch", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CivilopediaSearchPopup this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$run = (CoroutineScope)this.L$0;
                        CivilopediaSearchPopup.access$searchLoop(this.this$0, $this$run);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        Intrinsics.checkNotNull(job2);
        job2.invokeOnCompletion((Function1<? super Throwable, Unit>)new Function1<Throwable, Unit>(this){
            final /* synthetic */ CivilopediaSearchPopup this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable Throwable it) {
                CivilopediaSearchPopup.access$setSearchJob$p(this.this$0, null);
                Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                    int label;
                    final /* synthetic */ CivilopediaSearchPopup this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                CivilopediaSearchPopup.access$finishSearch(this.this$0);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 1, null);
            }
        });
    }

    private final void searchLoop(CoroutineScope $this$searchLoop) {
        block0: for (CivilopediaCategories category : CivilopediaCategories.values()) {
            if (!CoroutineScopeKt.isActive($this$searchLoop)) break;
            if (!this.ruleset.getModOptions().isBaseRuleset() && category == CivilopediaCategories.Tutorial) continue;
            for (ICivilopediaText entry : category.getGetCategoryIterator().invoke(this.ruleset, this.tutorialController)) {
                if (!CoroutineScopeKt.isActive($this$searchLoop)) continue block0;
                if (!(entry instanceof INamed)) continue;
                if (!this.ruleset.getModOptions().isBaseRuleset()) {
                    int sort = entry.getSortGroup(this.ruleset);
                    if (category == CivilopediaCategories.UnitType && sort < 2 || category == CivilopediaCategories.Belief && sort == 0) continue;
                }
                this.searchEntry($this$searchLoop, entry);
            }
        }
    }

    private final void searchEntry(CoroutineScope $this$searchEntry, ICivilopediaText entry) {
        Sequence scope2 = SequencesKt.sequence((Function2)new Function2<SequenceScope<? super FormattedLine>, Continuation<? super Unit>, Object>(entry, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ ICivilopediaText $entry;
            final /* synthetic */ CivilopediaSearchPopup this$0;
            {
                this.$entry = $entry;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        v0 = this.$entry.getCivilopediaTextHeader();
                        if (v0 == null) break;
                        it = v0;
                        $i$a$-let-CivilopediaSearchPopup$searchEntry$scope$1$1 = false;
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v1 = $this$sequence.yield(it, this);
                        if (v1 == var5_2) {
                            return var5_2;
                        }
                        break;
                    }
                    case 1: {
                        $i$a$-let-CivilopediaSearchPopup$searchEntry$scope$1$1 = false;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
                        break;
                    }
                }
                this.L$0 = $this$sequence;
                this.label = 2;
                v2 = $this$sequence.yieldAll((Iterable)this.$entry.getCivilopediaText(), (Continuation<Unit>)this);
                if (v2 == var5_2) {
                    return var5_2;
                }
                ** GOTO lbl35
                {
                    case 2: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl35:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 3;
                        v3 = $this$sequence.yieldAll((Iterable)this.$entry.getCivilopediaTextLines(CivilopediaSearchPopup.access$getRuleset$p(this.this$0)), (Continuation<Unit>)this);
                        if (v3 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl44
                    }
                    case 3: {
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
lbl44:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super FormattedLine>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super FormattedLine> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        Iterator iterator2 = scope2.iterator();
        while (iterator2.hasNext()) {
            FormattedLine line = (FormattedLine)iterator2.next();
            if (!CoroutineScopeKt.isActive($this$searchEntry)) break;
            String lineText = TranslationsKt.tr(line.getText(), true);
            if (!this.checkLine.invoke(lineText).booleanValue()) continue;
            this.addResult($this$searchEntry, entry);
            break;
        }
    }

    private final void addResult(CoroutineScope $this$addResult, ICivilopediaText entry) {
        ConcurrencyKt.launchOnGLThread$default($this$addResult, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(entry, this, null){
            int label;
            final /* synthetic */ ICivilopediaText $entry;
            final /* synthetic */ CivilopediaSearchPopup this$0;
            {
                this.$entry = $entry;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        Label actor = Scene2dExtensionsKt.toLabel$default(this.$entry.getIconName(), null, 0, 8, false, 11, null);
                        String link = this.$entry.makeLink();
                        ExpanderTab expanderTab2 = CivilopediaSearchPopup.access$getResultExpander$p(this.this$0);
                        if (expanderTab2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("resultExpander");
                            expanderTab2 = null;
                        }
                        expanderTab2.getInnerTable().add((Actor)actor).row();
                        ActivationExtensionsKt.onClick(actor, new Function0<Unit>(this.this$0, link){
                            final /* synthetic */ CivilopediaSearchPopup this$0;
                            final /* synthetic */ String $link;
                            {
                                this.this$0 = $receiver;
                                this.$link = $link;
                                super(0);
                            }

                            public final void invoke() {
                                CivilopediaSearchPopup.access$getLinkAction$p(this.this$0).invoke(this.$link);
                                this.this$0.close();
                            }
                        });
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    private final void finishSearch() {
        Scene2dExtensionsKt.enable(this.searchButton);
        ExpanderTab expanderTab2 = this.resultExpander;
        if (expanderTab2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("resultExpander");
            expanderTab2 = null;
        }
        if (!expanderTab2.getInnerTable().getCells().isEmpty()) {
            return;
        }
        Actor nothingFound = FormattedLine.render$default(new FormattedLine("Nothing found!", null, null, null, 0.0f, 0, 3, 0, 0.0f, "#f53", false, false, true, false, 11710, null), 0.0f, null, 2, null);
        ExpanderTab expanderTab3 = this.resultExpander;
        if (expanderTab3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("resultExpander");
            expanderTab3 = null;
        }
        expanderTab3.getInnerTable().add(nothingFound);
    }

    public static final /* synthetic */ void access$searchLoop(CivilopediaSearchPopup $this, CoroutineScope $receiver) {
        $this.searchLoop($receiver);
    }

    public static final /* synthetic */ void access$setSearchJob$p(CivilopediaSearchPopup $this, Job job2) {
        $this.searchJob = job2;
    }

    public static final /* synthetic */ void access$finishSearch(CivilopediaSearchPopup $this) {
        $this.finishSearch();
    }

    public static final /* synthetic */ Ruleset access$getRuleset$p(CivilopediaSearchPopup $this) {
        return $this.ruleset;
    }

    public static final /* synthetic */ ExpanderTab access$getResultExpander$p(CivilopediaSearchPopup $this) {
        return $this.resultExpander;
    }

    public static final /* synthetic */ Function1 access$getLinkAction$p(CivilopediaSearchPopup $this) {
        return $this.linkAction;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/screens/civilopediascreen/CivilopediaSearchPopup$ModSelectBox;", "Lcom/badlogic/gdx/scenes/scene2d/ui/SelectBox;", "Lcom/unciv/ui/screens/civilopediascreen/CivilopediaSearchPopup$ModSelectEntry;", "(Lcom/unciv/ui/screens/civilopediascreen/CivilopediaSearchPopup;)V", "selectedRuleset", "Lcom/unciv/models/ruleset/Ruleset;", "core"})
    private final class ModSelectBox
    extends SelectBox<ModSelectEntry> {
        public ModSelectBox() {
            super(BaseScreen.Companion.getSkin());
            LinkedHashSet<String> mods = CivilopediaSearchPopup.this.pediaScreen.getRuleset().getMods();
            Array<ModSelectEntry> entries2 = new Array<ModSelectEntry>(mods.size() + 1);
            entries2.add(new ModSelectEntry("-Combined-", true));
            Iterable iterable = mods;
            Set<String> set2 = RulesetCache.INSTANCE.keySet();
            Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
            for (String mod : CollectionsKt.intersect(iterable, (Iterable)set2)) {
                entries2.add(new ModSelectEntry(mod, false, 2, null));
            }
            this.setItems(entries2);
            this.setSelectedIndex(0);
        }

        @NotNull
        public final Ruleset selectedRuleset() {
            Ruleset ruleset2;
            if (this.getSelectedIndex() == 0) {
                ruleset2 = CivilopediaSearchPopup.this.pediaScreen.getRuleset();
            } else {
                Object object = RulesetCache.INSTANCE.get((Object)((ModSelectEntry)this.getSelected()).getKey());
                Intrinsics.checkNotNull(object);
                ruleset2 = (Ruleset)object;
            }
            return ruleset2;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/unciv/ui/screens/civilopediascreen/CivilopediaSearchPopup$ModSelectEntry;", "", "key", "", "translate", "", "(Ljava/lang/String;Z)V", "getKey", "()Ljava/lang/String;", "getTranslate", "()Z", "toString", "core"})
    public static final class ModSelectEntry {
        @NotNull
        private final String key;
        private final boolean translate;

        public ModSelectEntry(@NotNull String key, boolean translate) {
            Intrinsics.checkNotNullParameter(key, "key");
            this.key = key;
            this.translate = translate;
        }

        public /* synthetic */ ModSelectEntry(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            this(string, bl);
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        public final boolean getTranslate() {
            return this.translate;
        }

        @NotNull
        public String toString() {
            return this.translate ? TranslationsKt.tr$default(this.key, false, 1, null) : this.key;
        }
    }
}

