/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.diplomacyscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.UncivGame;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOfferType;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.diplomacyscreen.DiplomacyScreen;
import com.unciv.ui.screens.diplomacyscreen.LeaderIntroTable;
import com.unciv.ui.screens.diplomacyscreen.TradeTable;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0006J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/unciv/ui/screens/diplomacyscreen/MajorCivDiplomacyTable;", "", "diplomacyScreen", "Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen;", "(Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen;)V", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "getViewingCiv", "()Lcom/unciv/logic/civilization/Civilization;", "getDeclareFriendshipButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "otherCiv", "getDemandsTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "getDenounceButton", "diplomacyManager", "Lcom/unciv/logic/civilization/diplomacy/DiplomacyManager;", "getDiplomacyModifiersTable", "otherCivDiplomacyManager", "getMajorCivDiplomacyTable", "getNegotiatePeaceMajorCivButton", "getPromisesTable", "getTradeButton", "core"})
@SourceDebugExtension(value={"SMAP\nMajorCivDiplomacyTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MajorCivDiplomacyTable.kt\ncom/unciv/ui/screens/diplomacyscreen/MajorCivDiplomacyTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n1747#2,3:236\n1747#2,3:239\n*S KotlinDebug\n*F\n+ 1 MajorCivDiplomacyTable.kt\ncom/unciv/ui/screens/diplomacyscreen/MajorCivDiplomacyTable\n*L\n155#1:236,3\n218#1:239,3\n*E\n"})
public final class MajorCivDiplomacyTable {
    @NotNull
    private final DiplomacyScreen diplomacyScreen;
    @NotNull
    private final Civilization viewingCiv;

    public MajorCivDiplomacyTable(@NotNull DiplomacyScreen diplomacyScreen) {
        Intrinsics.checkNotNullParameter(diplomacyScreen, "diplomacyScreen");
        this.diplomacyScreen = diplomacyScreen;
        this.viewingCiv = this.diplomacyScreen.getViewingCiv$core();
    }

    @NotNull
    public final Civilization getViewingCiv() {
        return this.viewingCiv;
    }

    @NotNull
    public final Table getMajorCivDiplomacyTable(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        DiplomacyManager diplomacyManager = otherCiv.getDiplomacyManager(this.viewingCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager otherCivDiplomacyManager = diplomacyManager;
        Table diplomacyTable = new Table();
        diplomacyTable.defaults().pad(10.0f);
        String helloText = null;
        String helloVoice = null;
        if (otherCivDiplomacyManager.isRelationshipLevelLE(RelationshipLevel.Enemy)) {
            helloText = otherCiv.getNation().getHateHello();
            helloVoice = otherCiv.getCivName() + ".hateHello";
        } else {
            helloText = otherCiv.getNation().getNeutralHello();
            helloVoice = otherCiv.getCivName() + ".neutralHello";
        }
        LeaderIntroTable leaderIntroTable = new LeaderIntroTable(otherCiv, helloText);
        diplomacyTable.add((Actor)leaderIntroTable).row();
        Scene2dExtensionsKt.addSeparator$default(diplomacyTable, null, 0, 0.0f, 7, null);
        boolean diplomaticRelationshipsCanChange = !IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)this.viewingCiv.getGameInfo().getRuleset().getModOptions(), UniqueType.DiplomaticRelationshipsCannotChange, null, 2, null);
        DiplomacyManager diplomacyManager2 = this.viewingCiv.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager2);
        DiplomacyManager diplomacyManager3 = diplomacyManager2;
        if (!this.viewingCiv.isAtWarWith(otherCiv)) {
            diplomacyTable.add((Actor)this.getTradeButton(otherCiv)).row();
            if (!diplomacyManager3.hasFlag(DiplomacyFlags.DeclarationOfFriendship)) {
                diplomacyTable.add((Actor)this.getDeclareFriendshipButton(otherCiv)).row();
            }
            if (!diplomacyManager3.hasFlag(DiplomacyFlags.Denunciation) && !diplomacyManager3.hasFlag(DiplomacyFlags.DeclarationOfFriendship)) {
                diplomacyTable.add((Actor)this.getDenounceButton(otherCiv, diplomacyManager3)).row();
            }
            if (diplomaticRelationshipsCanChange) {
                diplomacyTable.add((Actor)this.diplomacyScreen.getDeclareWarButton$core(diplomacyManager3, otherCiv)).row();
            }
        } else if (diplomaticRelationshipsCanChange) {
            TextButton negotiatePeaceButton = this.getNegotiatePeaceMajorCivButton(otherCiv, otherCivDiplomacyManager);
            diplomacyTable.add((Actor)negotiatePeaceButton).row();
        }
        TextButton demandsButton = Scene2dExtensionsKt.toTextButton$default("Demands", null, false, 3, null);
        ActivationExtensionsKt.onClick(demandsButton, new Function0<Unit>(this, otherCiv){
            final /* synthetic */ MajorCivDiplomacyTable this$0;
            final /* synthetic */ Civilization $otherCiv;
            {
                this.this$0 = $receiver;
                this.$otherCiv = $otherCiv;
                super(0);
            }

            public final void invoke() {
                MajorCivDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).getRightSideTable$core().clear();
                MajorCivDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).getRightSideTable$core().add((Actor)MajorCivDiplomacyTable.access$getDemandsTable(this.this$0, this.this$0.getViewingCiv(), this.$otherCiv));
            }
        });
        diplomacyTable.add((Actor)demandsButton).row();
        if (this.diplomacyScreen.isNotPlayersTurn$core()) {
            Scene2dExtensionsKt.disable(demandsButton);
        }
        if (Civilization.getCapital$default(otherCiv, false, 1, null) != null) {
            City city2 = Civilization.getCapital$default(otherCiv, false, 1, null);
            Intrinsics.checkNotNull(city2);
            if (this.viewingCiv.hasExplored(city2.getCenterTile())) {
                diplomacyTable.add((Actor)this.diplomacyScreen.getGoToOnMapButton$core(otherCiv)).row();
            }
        }
        if (!otherCiv.isHuman()) {
            diplomacyTable.add((Actor)this.diplomacyScreen.getRelationshipTable$core(otherCivDiplomacyManager)).row();
            diplomacyTable.add((Actor)this.getDiplomacyModifiersTable(otherCivDiplomacyManager)).row();
            Table promisesTable = this.getPromisesTable(diplomacyManager3, otherCivDiplomacyManager);
            if (promisesTable != null) {
                diplomacyTable.add((Actor)promisesTable).row();
            }
        }
        UncivGame.Companion.getCurrent().getMusicController().playVoice(helloVoice);
        return diplomacyTable;
    }

    private final TextButton getNegotiatePeaceMajorCivButton(Civilization otherCiv, DiplomacyManager otherCivDiplomacyManager) {
        TextButton negotiatePeaceButton = Scene2dExtensionsKt.toTextButton$default("Negotiate Peace", null, false, 3, null);
        ActivationExtensionsKt.onClick(negotiatePeaceButton, new Function0<Unit>(this, otherCiv){
            final /* synthetic */ MajorCivDiplomacyTable this$0;
            final /* synthetic */ Civilization $otherCiv;
            {
                this.this$0 = $receiver;
                this.$otherCiv = $otherCiv;
                super(0);
            }

            public final void invoke() {
                TradeTable tradeTable = MajorCivDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).setTrade$core(this.$otherCiv);
                TradeOffer peaceTreaty = new TradeOffer("Peace Treaty", TradeOfferType.Treaty, 0, null, 12, null);
                tradeTable.getTradeLogic$core().getCurrentTrade().getTheirOffers().add(peaceTreaty);
                tradeTable.getTradeLogic$core().getCurrentTrade().getOurOffers().add(peaceTreaty);
                tradeTable.getOfferColumnsTable$core().update();
                tradeTable.enableOfferButton(true);
            }
        });
        if (this.diplomacyScreen.isNotPlayersTurn$core()) {
            Scene2dExtensionsKt.disable(negotiatePeaceButton);
        }
        if (otherCivDiplomacyManager.hasFlag(DiplomacyFlags.DeclaredWar)) {
            Scene2dExtensionsKt.disable(negotiatePeaceButton);
            int turnsLeft = otherCivDiplomacyManager.getFlag(DiplomacyFlags.DeclaredWar);
            negotiatePeaceButton.setText(negotiatePeaceButton.getText() + '\n' + TranslationsKt.tr(turnsLeft) + '\u23f3');
        }
        return negotiatePeaceButton;
    }

    private final TextButton getDenounceButton(Civilization otherCiv, DiplomacyManager diplomacyManager) {
        TextButton denounceButton = Scene2dExtensionsKt.toTextButton$default("Denounce ([30] turns)", null, false, 3, null);
        ActivationExtensionsKt.onClick(denounceButton, new Function0<Unit>(this, otherCiv, diplomacyManager){
            final /* synthetic */ MajorCivDiplomacyTable this$0;
            final /* synthetic */ Civilization $otherCiv;
            final /* synthetic */ DiplomacyManager $diplomacyManager;
            {
                this.this$0 = $receiver;
                this.$otherCiv = $otherCiv;
                this.$diplomacyManager = $diplomacyManager;
                super(0);
            }

            public final void invoke() {
                Popup.open$default(new ConfirmPopup(MajorCivDiplomacyTable.access$getDiplomacyScreen$p(this.this$0), "Denounce [" + this.$otherCiv.getCivName() + "]?", "Denounce ([30] turns)", false, null, (Function0)new Function0<Unit>(this.$diplomacyManager, this.this$0, this.$otherCiv){
                    final /* synthetic */ DiplomacyManager $diplomacyManager;
                    final /* synthetic */ MajorCivDiplomacyTable this$0;
                    final /* synthetic */ Civilization $otherCiv;
                    {
                        this.$diplomacyManager = $diplomacyManager;
                        this.this$0 = $receiver;
                        this.$otherCiv = $otherCiv;
                        super(0);
                    }

                    public final void invoke() {
                        this.$diplomacyManager.denounce();
                        MajorCivDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).updateLeftSideTable$core(this.$otherCiv);
                        MajorCivDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).setRightSideFlavorText$core(this.$otherCiv, "We will remember this.", "Very well.");
                    }
                }, 24, null), false, 1, null);
            }
        });
        if (this.diplomacyScreen.isNotPlayersTurn$core()) {
            Scene2dExtensionsKt.disable(denounceButton);
        }
        return denounceButton;
    }

    private final TextButton getDeclareFriendshipButton(Civilization otherCiv) {
        TextButton declareFriendshipButton;
        block9: {
            block8: {
                boolean bl;
                block7: {
                    declareFriendshipButton = Scene2dExtensionsKt.toTextButton$default("Offer Declaration of Friendship ([30] turns)", null, false, 3, null);
                    ActivationExtensionsKt.onClick(declareFriendshipButton, new Function0<Unit>(otherCiv, this, declareFriendshipButton){
                        final /* synthetic */ Civilization $otherCiv;
                        final /* synthetic */ MajorCivDiplomacyTable this$0;
                        final /* synthetic */ TextButton $declareFriendshipButton;
                        {
                            this.$otherCiv = $otherCiv;
                            this.this$0 = $receiver;
                            this.$declareFriendshipButton = $declareFriendshipButton;
                            super(0);
                        }

                        public final void invoke() {
                            this.$otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.DeclarationOfFriendship, this.this$0.getViewingCiv().getCivName()));
                            Scene2dExtensionsKt.disable(this.$declareFriendshipButton);
                        }
                    });
                    if (this.diplomacyScreen.isNotPlayersTurn$core()) break block8;
                    Iterable $this$any$iv = otherCiv.getPopupAlerts();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            PopupAlert it = (PopupAlert)element$iv;
                            boolean bl2 = false;
                            if (!(it.getType() == AlertType.DeclarationOfFriendship && Intrinsics.areEqual(it.getValue(), this.viewingCiv.getCivName()))) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block9;
            }
            Scene2dExtensionsKt.disable(declareFriendshipButton);
        }
        return declareFriendshipButton;
    }

    private final TextButton getTradeButton(Civilization otherCiv) {
        TextButton tradeButton = Scene2dExtensionsKt.toTextButton$default("Trade", null, false, 3, null);
        ActivationExtensionsKt.onClick(tradeButton, new Function0<Unit>(this, otherCiv){
            final /* synthetic */ MajorCivDiplomacyTable this$0;
            final /* synthetic */ Civilization $otherCiv;
            {
                this.this$0 = $receiver;
                this.$otherCiv = $otherCiv;
                super(0);
            }

            public final void invoke() {
                TradeTable tradeTable;
                TradeTable $this$invoke_u24lambda_u240 = tradeTable = MajorCivDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).setTrade$core(this.$otherCiv);
                boolean bl = false;
                $this$invoke_u24lambda_u240.getOfferColumnsTable$core().update();
            }
        });
        if (this.diplomacyScreen.isNotPlayersTurn$core()) {
            Scene2dExtensionsKt.disable(tradeButton);
        }
        return tradeButton;
    }

    private final Table getPromisesTable(DiplomacyManager diplomacyManager, DiplomacyManager otherCivDiplomacyManager) {
        String text2;
        Table promisesTable = new Table();
        DiplomacyFlags flag = DiplomacyFlags.AgreedToNotSettleNearUs;
        if (otherCivDiplomacyManager.hasFlag(flag)) {
            text2 = "We promised not to settle near them ([" + otherCivDiplomacyManager.getFlag(flag) + "] turns remaining)";
            Color color = Color.LIGHT_GRAY;
            Intrinsics.checkNotNullExpressionValue(color, "LIGHT_GRAY");
            promisesTable.add((Actor)Scene2dExtensionsKt.toLabel$default(text2, color, 0, 0, false, 14, null)).row();
        }
        if (diplomacyManager.hasFlag(flag)) {
            text2 = "They promised not to settle near us ([" + diplomacyManager.getFlag(flag) + "] turns remaining)";
            Color color = Color.LIGHT_GRAY;
            Intrinsics.checkNotNullExpressionValue(color, "LIGHT_GRAY");
            promisesTable.add((Actor)Scene2dExtensionsKt.toLabel$default(text2, color, 0, 0, false, 14, null)).row();
        }
        return promisesTable.getCells().isEmpty() ? null : promisesTable;
    }

    private final Table getDiplomacyModifiersTable(DiplomacyManager otherCivDiplomacyManager) {
        Table diplomacyModifiersTable = new Table();
        for (Map.Entry modifier : ((Map)otherCivDiplomacyManager.getDiplomaticModifiers()).entrySet()) {
            DiplomaticModifiers diplomaticModifier;
            if (Intrinsics.areEqual(modifier.getKey(), "AttackedProtectedMinor") && otherCivDiplomacyManager.hasModifier(DiplomaticModifiers.DestroyedProtectedMinor) || DiplomaticModifiers.Companion.safeValueOf((String)modifier.getKey()) == null) continue;
            String text2 = TranslationsKt.tr$default(diplomaticModifier.getText(), false, 1, null) + ' ';
            if (((Number)modifier.getValue()).floatValue() > 0.0f) {
                text2 = text2 + '+';
            }
            text2 = text2 + MathKt.roundToInt(((Number)modifier.getValue()).floatValue());
            Color color = ((Number)modifier.getValue()).floatValue() < 0.0f ? Color.RED : Color.GREEN;
            Intrinsics.checkNotNull(color);
            diplomacyModifiersTable.add((Actor)Scene2dExtensionsKt.toLabel$default(text2, color, 0, 0, false, 14, null)).row();
        }
        return diplomacyModifiersTable;
    }

    private final Table getDemandsTable(Civilization viewingCiv, Civilization otherCiv) {
        boolean bl;
        TextButton dontSettleCitiesButton;
        Table demandsTable;
        block4: {
            demandsTable = new Table();
            demandsTable.defaults().pad(10.0f);
            dontSettleCitiesButton = Scene2dExtensionsKt.toTextButton$default("Please don't settle new cities near us.", null, false, 3, null);
            Iterable $this$any$iv = otherCiv.getPopupAlerts();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PopupAlert it = (PopupAlert)element$iv;
                    boolean bl2 = false;
                    if (!(it.getType() == AlertType.DemandToStopSettlingCitiesNear && Intrinsics.areEqual(it.getValue(), viewingCiv.getCivName()))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            Scene2dExtensionsKt.disable(dontSettleCitiesButton);
        }
        ActivationExtensionsKt.onClick(dontSettleCitiesButton, new Function0<Unit>(otherCiv, viewingCiv, dontSettleCitiesButton){
            final /* synthetic */ Civilization $otherCiv;
            final /* synthetic */ Civilization $viewingCiv;
            final /* synthetic */ TextButton $dontSettleCitiesButton;
            {
                this.$otherCiv = $otherCiv;
                this.$viewingCiv = $viewingCiv;
                this.$dontSettleCitiesButton = $dontSettleCitiesButton;
                super(0);
            }

            public final void invoke() {
                this.$otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.DemandToStopSettlingCitiesNear, this.$viewingCiv.getCivName()));
                Scene2dExtensionsKt.disable(this.$dontSettleCitiesButton);
            }
        });
        demandsTable.add((Actor)dontSettleCitiesButton).row();
        demandsTable.add(ActivationExtensionsKt.onClick(Scene2dExtensionsKt.toTextButton$default("Close", null, false, 3, null), new Function0<Unit>(this, otherCiv){
            final /* synthetic */ MajorCivDiplomacyTable this$0;
            final /* synthetic */ Civilization $otherCiv;
            {
                this.this$0 = $receiver;
                this.$otherCiv = $otherCiv;
                super(0);
            }

            public final void invoke() {
                MajorCivDiplomacyTable.access$getDiplomacyScreen$p(this.this$0).updateRightSide$core(this.$otherCiv);
            }
        }));
        return demandsTable;
    }

    public static final /* synthetic */ DiplomacyScreen access$getDiplomacyScreen$p(MajorCivDiplomacyTable $this) {
        return $this.diplomacyScreen;
    }

    public static final /* synthetic */ Table access$getDemandsTable(MajorCivDiplomacyTable $this, Civilization viewingCiv, Civilization otherCiv) {
        return $this.getDemandsTable(viewingCiv, otherCiv);
    }
}

