/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.mapeditorscreen;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.UncivShowableException;
import com.unciv.logic.files.FileChooser;
import com.unciv.logic.map.HexMath;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.MapSize;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetStatsObject;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.mapeditorscreen.MapEditorScreen;
import com.unciv.ui.screens.mapeditorscreen.MapEditorWesnothImporter;
import com.unciv.utils.Concurrency;
import com.unciv.utils.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 22\u00020\u0001:\u00012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\"\u001a\u00020#H\u0016J\u0006\u0010$\u001a\u00020#J\b\u0010%\u001a\u00020#H\u0002J\u0010\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00070*2\b\u0010+\u001a\u0004\u0018\u00010\u0007H\u0002J\u001c\u0010,\u001a\u00020#*\u00020-2\u0006\u0010.\u001a\u00020\u00072\u0006\u0010/\u001a\u000200H\u0002J\f\u00101\u001a\u000200*\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000b\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000b\u001a\u0004\b\u0017\u0010\u0018RM\u0010\u001a\u001a4\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001c0\u001bj\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00070\u001cj\b\u0012\u0004\u0012\u00020\u0007`\u001e`\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u000b\u001a\u0004\b\u001f\u0010 \u00a8\u00063"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/MapEditorWesnothImporter;", "Lkotlinx/coroutines/DisposableHandle;", "editorScreen", "Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;", "(Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;)V", "fallback", "", "", "getFallback", "()Ljava/util/List;", "fallback$delegate", "Lkotlin/Lazy;", "ignoreLines", "", "importJob", "Lkotlinx/coroutines/Job;", "parseTerrain", "Lkotlin/text/Regex;", "getParseTerrain", "()Lkotlin/text/Regex;", "parseTerrain$delegate", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "ruleset$delegate", "translationCodes", "Ljava/util/LinkedHashMap;", "Ljava/util/ArrayList;", "Lkotlin/collections/LinkedHashMap;", "Lkotlin/collections/ArrayList;", "getTranslationCodes", "()Ljava/util/LinkedHashMap;", "translationCodes$delegate", "dispose", "", "onImportButtonClicked", "openFileDialog", "startImport", "file", "Lcom/badlogic/gdx/files/FileHandle;", "translateTerrainWML", "Lkotlin/sequences/Sequence;", "code", "paintFromWesnothCode", "Lcom/unciv/logic/map/tile/Tile;", "cellCode", "map", "Lcom/unciv/logic/map/TileMap;", "parse", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMapEditorWesnothImporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapEditorWesnothImporter.kt\ncom/unciv/ui/screens/mapeditorscreen/MapEditorWesnothImporter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,184:1\n603#2:185\n223#3,2:186\n766#3:188\n857#3,2:189\n1549#3:191\n1620#3,3:192\n288#3,2:195\n1#4:197\n*S KotlinDebug\n*F\n+ 1 MapEditorWesnothImporter.kt\ncom/unciv/ui/screens/mapeditorscreen/MapEditorWesnothImporter\n*L\n152#1:185\n156#1:186,2\n158#1:188\n158#1:189,2\n158#1:191\n158#1:192,3\n164#1:195,2\n*E\n"})
public final class MapEditorWesnothImporter
implements DisposableHandle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MapEditorScreen editorScreen;
    @NotNull
    private final Lazy ruleset$delegate;
    @Nullable
    private Job importJob;
    @NotNull
    private final Set<String> ignoreLines;
    @NotNull
    private final Lazy parseTerrain$delegate;
    @NotNull
    private final Lazy translationCodes$delegate;
    @NotNull
    private final Lazy fallback$delegate;
    @Nullable
    private static FileHandle lastFileFolder;

    public MapEditorWesnothImporter(@NotNull MapEditorScreen editorScreen) {
        Intrinsics.checkNotNullParameter(editorScreen, "editorScreen");
        this.editorScreen = editorScreen;
        this.ruleset$delegate = LazyKt.lazy(ruleset.2.INSTANCE);
        String[] stringArray = new String[]{"usage=map", "border_size=1"};
        this.ignoreLines = SetsKt.setOf(stringArray);
        this.parseTerrain$delegate = LazyKt.lazy(parseTerrain.2.INSTANCE);
        this.translationCodes$delegate = LazyKt.lazy(translationCodes.2.INSTANCE);
        this.fallback$delegate = LazyKt.lazy((Function0)new Function0<List<? extends String>>(this){
            final /* synthetic */ MapEditorWesnothImporter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<String> invoke() {
                ArrayList arrayList = (ArrayList)MapEditorWesnothImporter.access$getTranslationCodes(this.this$0).get("fallback");
                return arrayList == null ? CollectionsKt.listOf("Grassland") : (List<String>)arrayList;
            }
        });
    }

    private final Ruleset getRuleset() {
        Lazy lazy = this.ruleset$delegate;
        return (Ruleset)lazy.getValue();
    }

    private final Regex getParseTerrain() {
        Lazy lazy = this.parseTerrain$delegate;
        return (Regex)lazy.getValue();
    }

    private final LinkedHashMap<String, ArrayList<String>> getTranslationCodes() {
        Lazy lazy = this.translationCodes$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "getValue(...)");
        return (LinkedHashMap)t;
    }

    private final List<String> getFallback() {
        Lazy lazy = this.fallback$delegate;
        return (List)lazy.getValue();
    }

    @Override
    public void dispose() {
        block0: {
            Job job2 = this.importJob;
            if (job2 == null) break block0;
            Job.DefaultImpls.cancel$default(job2, null, 1, null);
        }
    }

    public final void onImportButtonClicked() {
        this.editorScreen.askIfDirtyForLoad(new Function0<Unit>((Object)this){

            public final void invoke() {
                MapEditorWesnothImporter.access$openFileDialog((MapEditorWesnothImporter)this.receiver);
            }
        });
    }

    private final void openFileDialog() {
        FileChooser fileChooser;
        FileChooser $this$openFileDialog_u24lambda_u240 = fileChooser = FileChooser.Companion.createLoadDialog(this.editorScreen.getStage(), "Choose a Wesnoth map file", lastFileFolder, (Function2<? super Boolean, ? super FileHandle, Unit>)new Function2<Boolean, FileHandle, Unit>(this){
            final /* synthetic */ MapEditorWesnothImporter this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(boolean success, @NotNull FileHandle file) {
                Intrinsics.checkNotNullParameter(file, "file");
                if (!success) {
                    return;
                }
                MapEditorWesnothImporter.access$startImport(this.this$0, file);
                MapEditorWesnothImporter.Companion.setLastFileFolder(file.parent());
            }
        });
        boolean bl = false;
        String[] stringArray = new String[]{"map"};
        $this$openFileDialog_u24lambda_u240.setFilter(FileChooser.Companion.createExtensionFilter(stringArray));
        Popup.open$default(fileChooser, false, 1, null);
    }

    private final void startImport(FileHandle file) {
        this.dispose();
        this.importJob = Concurrency.run$default(Concurrency.INSTANCE, "Map import", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(file, this, null){
            int label;
            final /* synthetic */ FileHandle $file;
            final /* synthetic */ MapEditorWesnothImporter this$0;
            {
                this.$file = $file;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        try {
                            String mapData = this.$file.readString(Charsets.UTF_8.name());
                            Intrinsics.checkNotNull(mapData);
                            TileMap map2 = MapEditorWesnothImporter.access$parse(this.this$0, mapData);
                            Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, map2, null){
                                int label;
                                final /* synthetic */ MapEditorWesnothImporter this$0;
                                final /* synthetic */ TileMap $map;
                                {
                                    this.this$0 = $receiver;
                                    this.$map = $map;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            MapEditorScreen.loadMap$default(MapEditorWesnothImporter.access$getEditorScreen$p(this.this$0), this.$map, null, 0, 6, null);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        catch (UncivShowableException ex) {
                            Log.INSTANCE.error("Could not load map", ex);
                            Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(ex, this.this$0, null){
                                int label;
                                final /* synthetic */ UncivShowableException $ex;
                                final /* synthetic */ MapEditorWesnothImporter this$0;
                                {
                                    this.$ex = $ex;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            new ToastPopup(this.$ex.getMessage(), MapEditorWesnothImporter.access$getEditorScreen$p(this.this$0), 4000L);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        catch (Throwable ex) {
                            Log.INSTANCE.error("Could not load map", ex);
                            Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ MapEditorWesnothImporter this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            new ToastPopup("Could not load map!", MapEditorWesnothImporter.access$getEditorScreen$p(this.this$0), 0L, 4, null);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final TileMap parse(String $this$parse) {
        MapParameters mapParameters;
        int width;
        int n;
        List<String> lines2 = SequencesKt.toList(SequencesKt.filter(StringsKt.lineSequence($this$parse), (Function1)new Function1<String, Boolean>(this){
            final /* synthetic */ MapEditorWesnothImporter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return !StringsKt.isBlank(it) && !MapEditorWesnothImporter.access$getIgnoreLines$p(this.this$0).contains(it);
            }
        }));
        int height = lines2.size() - 1;
        if (height <= 0) {
            n = 0;
        } else {
            char[] cArray = new char[]{','};
            n = width = StringsKt.split$default((CharSequence)lines2.get(0), cArray, false, 0, 6, null).size() - 2;
        }
        if (width <= 0) {
            throw new UncivShowableException("That map is invalid!", null, 2, null);
        }
        Ruleset ruleset2 = this.getRuleset();
        Intrinsics.checkNotNullExpressionValue(ruleset2, "<get-ruleset>(...)");
        TileMap map2 = new TileMap(width, height, ruleset2, false);
        MapParameters $this$parse_u24lambda_u241 = mapParameters = map2.getMapParameters();
        boolean bl = false;
        $this$parse_u24lambda_u241.setType("Empty");
        $this$parse_u24lambda_u241.setShape("Rectangular");
        $this$parse_u24lambda_u241.setMapSize(new MapSize(width, height));
        int colOffset = 1 + width / 2;
        int rowOffset = height / 2;
        Iterator<String> iterator2 = lines2.iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int row = n2++;
            String line = iterator2.next();
            char[] cArray = new char[]{','};
            Iterator iterator3 = StringsKt.split$default((CharSequence)line, cArray, false, 0, 6, null).iterator();
            int n3 = 0;
            while (iterator3.hasNext()) {
                int column = n3++;
                String cellCode = (String)iterator3.next();
                int effectiveRow = rowOffset - row + column % 2;
                Vector2 pos = HexMath.INSTANCE.getTileCoordsFromColumnRow(column - colOffset, effectiveRow);
                if (!map2.contains(pos)) continue;
                this.paintFromWesnothCode(map2.get(pos), ((Object)StringsKt.trim((CharSequence)cellCode)).toString(), map2);
            }
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    private final void paintFromWesnothCode(Tile $this$paintFromWesnothCode, String cellCode, TileMap map2) {
        Object v4;
        String start2;
        block9: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            RulesetStatsObject it;
            void $this$filterTo$iv$iv;
            Object element$iv2;
            Object object;
            List allObjects2;
            block8: {
                void $this$first$iv;
                Iterable $this$sortedBy$iv;
                Sequence<String> allStrings;
                MatchResult matchResult = this.getParseTerrain().matchEntire(cellCode);
                if (matchResult == null) {
                    throw new UncivShowableException("{That map is invalid!}\n{(\"[" + cellCode + "]\" does not conform to TerrainCodesWML)}", null, 2, null);
                }
                MatchResult matches = matchResult;
                MatchGroup matchGroup = RegexExtensionsJDK8Kt.get(matches.getGroups(), "start");
                start2 = matchGroup != null ? matchGroup.getValue() : null;
                MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get(matches.getGroups(), "base");
                Intrinsics.checkNotNull(matchGroup2);
                String base = matchGroup2.getValue();
                MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get(matches.getGroups(), "layer");
                String layer = matchGroup3 != null ? matchGroup3.getValue() : null;
                Sequence<String> sequence = allStrings = SequencesKt.plus(SequencesKt.plus(this.translateTerrainWML(base), this.translateTerrainWML(layer)), (Iterable)this.getFallback());
                boolean $i$f$sortedBy = false;
                allObjects2 = SequencesKt.toList(SequencesKt.mapNotNull(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        String it = (String)a;
                        boolean bl = false;
                        boolean bl2 = !Intrinsics.areEqual(it, "Hill");
                        it = (String)b;
                        Comparable comparable = Boolean.valueOf(bl2);
                        bl = false;
                        return ComparisonsKt.compareValues(comparable, !Intrinsics.areEqual(it, "Hill"));
                    }
                }), (Function1)new Function1<String, RulesetStatsObject>($this$paintFromWesnothCode){
                    final /* synthetic */ Tile $this_paintFromWesnothCode;
                    {
                        this.$this_paintFromWesnothCode = $receiver;
                        super(1);
                    }

                    @Nullable
                    public final RulesetStatsObject invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        TileImprovement tileImprovement = this.$this_paintFromWesnothCode.getRuleset().getTileImprovements().get(it);
                        return tileImprovement != null ? (RulesetStatsObject)tileImprovement : (RulesetStatsObject)this.$this_paintFromWesnothCode.getRuleset().getTerrains().get(it);
                    }
                }));
                $this$sortedBy$iv = allObjects2;
                object = $this$paintFromWesnothCode;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    RulesetStatsObject it2 = (RulesetStatsObject)element$iv2;
                    boolean bl = false;
                    if (!(it2 instanceof Terrain && ((Terrain)it2).getType().isBaseTerrain())) continue;
                    break block8;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            ((Tile)object).setBaseTerrain(((RulesetStatsObject)element$iv2).getName());
            Iterable $this$filter$iv = allObjects2;
            boolean $i$f$filter = false;
            element$iv2 = $this$filter$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (RulesetStatsObject)element$iv$iv;
                boolean bl = false;
                if (!(it instanceof Terrain && ((Terrain)it).getType() == TerrainType.TerrainFeature)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (RulesetStatsObject)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(it.getName());
            }
            List<String> features = CollectionsKt.distinct((List)destination$iv$iv);
            if (!((Collection)features).isEmpty()) {
                $this$paintFromWesnothCode.setTerrainTransients();
                $this$paintFromWesnothCode.setTerrainFeatures(features);
            }
            Iterable $this$firstOrNull$iv = allObjects2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv3 : $this$firstOrNull$iv) {
                RulesetStatsObject it3 = (RulesetStatsObject)element$iv3;
                boolean bl = false;
                if (!(it3 instanceof TileImprovement)) continue;
                v4 = element$iv3;
                break block9;
            }
            v4 = null;
        }
        RulesetStatsObject rulesetStatsObject = v4;
        if (rulesetStatsObject != null) {
            RulesetStatsObject rulesetStatsObject2;
            RulesetStatsObject $this$paintFromWesnothCode_u24lambda_u247 = rulesetStatsObject2 = rulesetStatsObject;
            boolean bl = false;
            $this$paintFromWesnothCode.setImprovement($this$paintFromWesnothCode_u24lambda_u247.getName());
        }
        if (start2 == null) {
            return;
        }
        TileMap.addStartingLocation$default(map2, "Spectator", $this$paintFromWesnothCode, null, 4, null);
    }

    private final Sequence<String> translateTerrainWML(String code) {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(code, this, null){
            Object L$1;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ String $code;
            final /* synthetic */ MapEditorWesnothImporter this$0;
            {
                this.$code = $code;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2;
                ArrayList arrayList;
                int length;
                boolean bl;
                SequenceScope $this$sequence;
                Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        $this$sequence = (SequenceScope)this.L$0;
                        if (this.$code == null) {
                            return Unit.INSTANCE;
                        }
                        break;
                    }
                    case 1: {
                        void $result;
                        bl = false;
                        length = this.I$0;
                        arrayList = (ArrayList)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        object2 = $result;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                for (length = this.$code.length(); 0 < length; --length) {
                    if ((ArrayList)MapEditorWesnothImporter.access$getTranslationCodes(this.this$0).get(StringsKt.slice(this.$code, RangesKt.until(0, length))) == null) continue;
                    ArrayList it = arrayList;
                    bl = false;
                    this.L$0 = $this$sequence;
                    this.L$1 = arrayList;
                    this.I$0 = length;
                    this.label = 1;
                    object2 = $this$sequence.yieldAll(it, (Continuation<Unit>)this);
                    if (object2 != object3) continue;
                    return object3;
                }
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super String> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public static final /* synthetic */ void access$openFileDialog(MapEditorWesnothImporter $this) {
        $this.openFileDialog();
    }

    public static final /* synthetic */ void access$startImport(MapEditorWesnothImporter $this, FileHandle file) {
        $this.startImport(file);
    }

    public static final /* synthetic */ TileMap access$parse(MapEditorWesnothImporter $this, String $receiver) {
        return $this.parse($receiver);
    }

    public static final /* synthetic */ MapEditorScreen access$getEditorScreen$p(MapEditorWesnothImporter $this) {
        return $this.editorScreen;
    }

    public static final /* synthetic */ Set access$getIgnoreLines$p(MapEditorWesnothImporter $this) {
        return $this.ignoreLines;
    }

    public static final /* synthetic */ LinkedHashMap access$getTranslationCodes(MapEditorWesnothImporter $this) {
        return $this.getTranslationCodes();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/MapEditorWesnothImporter$Companion;", "", "()V", "lastFileFolder", "Lcom/badlogic/gdx/files/FileHandle;", "getLastFileFolder", "()Lcom/badlogic/gdx/files/FileHandle;", "setLastFileFolder", "(Lcom/badlogic/gdx/files/FileHandle;)V", "core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final FileHandle getLastFileFolder() {
            return lastFileFolder;
        }

        public final void setLastFileFolder(@Nullable FileHandle fileHandle) {
            lastFileFolder = fileHandle;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

