/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.mapeditorscreen.tabs;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.UncivGame;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.MusicTrackChooserFlags;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.MarkupRenderer;
import com.unciv.ui.screens.mapeditorscreen.tabs.IMapEditorEditSubTabs;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorEditStartsTab;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorEditTab;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001aH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditStartsTab;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/IMapEditorEditSubTabs;", "editTab", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "(Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab;Lcom/unciv/models/ruleset/Ruleset;)V", "collator", "Ljava/text/Collator;", "usageOptionGroup", "Lcom/badlogic/gdx/scenes/scene2d/ui/ButtonGroup;", "Lcom/badlogic/gdx/scenes/scene2d/ui/CheckBox;", "addNations", "", "firstNation", "Lcom/unciv/models/ruleset/nation/Nation;", "addUsage", "allowedNations", "Lkotlin/sequences/Sequence;", "getNations", "", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "isDisabled", "", "spectatorToAnyCiv", "", "core"})
@SourceDebugExtension(value={"SMAP\nMapEditorEditSubTabs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapEditorEditSubTabs.kt\ncom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditStartsTab\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,499:1\n1#2:500\n*E\n"})
public final class MapEditorEditStartsTab
extends Table
implements IMapEditorEditSubTabs {
    @NotNull
    private final MapEditorEditTab editTab;
    @NotNull
    private final Ruleset ruleset;
    @NotNull
    private final Collator collator;
    @NotNull
    private final ButtonGroup<CheckBox> usageOptionGroup;

    public MapEditorEditStartsTab(@NotNull MapEditorEditTab editTab, @NotNull Ruleset ruleset2) {
        block0: {
            Intrinsics.checkNotNullParameter(editTab, "editTab");
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            super(BaseScreen.Companion.getSkin());
            this.editTab = editTab;
            this.ruleset = ruleset2;
            this.collator = UncivGame.Companion.getCurrent().getSettings().getCollatorFromLocale();
            this.usageOptionGroup = new ButtonGroup();
            this.top();
            this.defaults().pad(10.0f).fillX().left();
            Nation nation2 = SequencesKt.firstOrNull(this.allowedNations());
            if (nation2 == null) break block0;
            Nation it = nation2;
            boolean bl = false;
            this.addNations(it);
        }
    }

    private final String spectatorToAnyCiv(String $this$spectatorToAnyCiv) {
        return Intrinsics.areEqual($this$spectatorToAnyCiv, "Spectator") ? "Any Civ" : $this$spectatorToAnyCiv;
    }

    /*
     * WARNING - void declaration
     */
    private final void addNations(Nation firstNation) {
        void $this$addNations_u24lambda_u241;
        Actor actor;
        String eraserIcon = "Nation/" + firstNation.getName();
        FormattedLine eraser = new FormattedLine("Remove starting locations", null, eraserIcon, null, 0.0f, 24, 0, 0, 0.0f, null, false, false, false, true, 8154, null);
        Actor actor2 = actor = FormattedLine.render$default(eraser, 0.0f, null, 2, null);
        MapEditorEditStartsTab mapEditorEditStartsTab = this;
        boolean bl = false;
        ActivationExtensionsKt.onClick((Actor)$this$addNations_u24lambda_u241, new Function0<Unit>(this, eraserIcon){
            final /* synthetic */ MapEditorEditStartsTab this$0;
            final /* synthetic */ String $eraserIcon;
            {
                this.this$0 = $receiver;
                this.$eraserIcon = $eraserIcon;
                super(0);
            }

            public final void invoke() {
                MapEditorEditStartsTab.access$getEditTab$p(this.this$0).setBrush(MapEditorEditTab.BrushHandlerType.Direct, "Remove", this.$eraserIcon, "", true, addNations.1.1.INSTANCE);
            }
        });
        mapEditorEditStartsTab.add(actor).padBottom(0.0f).row();
        this.addUsage();
        this.add((Actor)MarkupRenderer.render$default(MarkupRenderer.INSTANCE, this.getNations(), 0.0f, 0.0f, FormattedLine.IconDisplay.NoLink, new Function1<String, Unit>(this){
            final /* synthetic */ MapEditorEditStartsTab this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                UncivGame.Companion.getCurrent().getMusicController().chooseTrack(it, "Theme", MusicTrackChooserFlags.Companion.getSetSpecific());
                String icon = "Nation/" + it;
                String pediaLink = Intrinsics.areEqual(it, "Spectator") ? "" : icon;
                Nation nation2 = MapEditorEditStartsTab.access$getRuleset$p(this.this$0).getNations().get(it);
                boolean isMajorCiv2 = nation2 != null ? nation2.isMajorCiv() : false;
                TileMap.StartingLocation.Usage selectedUsage = isMajorCiv2 ? TileMap.StartingLocation.Usage.values()[MapEditorEditStartsTab.access$getUsageOptionGroup$p(this.this$0).getCheckedIndex()] : TileMap.StartingLocation.Usage.Normal;
                MapEditorEditTab.setBrush$default(MapEditorEditStartsTab.access$getEditTab$p(this.this$0), MapEditorEditTab.BrushHandlerType.Direct, MapEditorEditStartsTab.access$spectatorToAnyCiv(this.this$0, it), icon, pediaLink, false, new Function1<Tile, Unit>(it, selectedUsage){
                    final /* synthetic */ String $it;
                    final /* synthetic */ TileMap.StartingLocation.Usage $selectedUsage;
                    {
                        this.$it = $it;
                        this.$selectedUsage = $selectedUsage;
                        super(1);
                    }

                    public final void invoke(@NotNull Tile tile) {
                        Intrinsics.checkNotNullParameter(tile, "tile");
                        if (!tile.getTileMap().addStartingLocation(this.$it, tile, this.$selectedUsage)) {
                            tile.getTileMap().removeStartingLocation(this.$it, tile);
                        }
                    }
                }, 16, null);
            }
        }, 6, null)).padTop(0.0f).row();
    }

    private final Sequence<Nation> allowedNations() {
        Collection<Nation> collection = this.ruleset.getNations().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)collection), allowedNations.1.INSTANCE);
    }

    private final Iterable<FormattedLine> getNations() {
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                Nation it = (Nation)a;
                boolean bl = false;
                boolean bl2 = !it.isSpectator();
                it = (Nation)b;
                Comparable comparable = Boolean.valueOf(bl2);
                bl = false;
                return ComparisonsKt.compareValues(comparable, !it.isSpectator());
            }
        };
        comparator = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Nation it = (Nation)a;
                    boolean bl = false;
                    Comparable comparable = Boolean.valueOf(it.isCityState());
                    it = (Nation)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable2, it.isCityState());
                }
                return n;
            }
        };
        Comparator comparator2 = this.collator;
        return SequencesKt.asIterable(SequencesKt.map(SequencesKt.sortedWith(this.allowedNations(), new Comparator(comparator, comparator2){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = $receiver;
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Nation nation2 = (Nation)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    Nation it = (Nation)b;
                    String string = TranslationsKt.tr(it.getName(), true);
                    bl = false;
                    String string2 = TranslationsKt.tr(it.getName(), true);
                    n = comparator.compare(string, string2);
                }
                return n;
            }
        }), (Function1)new Function1<Nation, FormattedLine>(this){
            final /* synthetic */ MapEditorEditStartsTab this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final FormattedLine invoke(@NotNull Nation it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return new FormattedLine('[' + MapEditorEditStartsTab.access$spectatorToAnyCiv(this.this$0, it.getName()) + "] starting location", it.getName(), "Nation/" + it.getName(), null, 0.0f, 24, 0, 0, 0.0f, null, false, false, false, false, 16344, null);
            }
        }));
    }

    private final void addUsage() {
        Table table2 = new Table();
        table2.defaults().pad(5.0f);
        table2.add((Actor)Scene2dExtensionsKt.toLabel("Use for new game \"Select players\" button:")).colspan(3).row();
        TileMap.StartingLocation.Usage defaultUsage = TileMap.StartingLocation.Usage.Companion.getDefault();
        for (TileMap.StartingLocation.Usage usage : TileMap.StartingLocation.Usage.values()) {
            CheckBox checkBox2 = new CheckBox(TranslationsKt.tr$default(usage.getLabel(), false, 1, null), this.getSkin());
            table2.add((Actor)checkBox2);
            this.usageOptionGroup.add((CheckBox)((Button)checkBox2));
            checkBox2.setChecked(usage == defaultUsage);
        }
        this.add((Actor)table2).row();
    }

    @Override
    public boolean isDisabled() {
        return SequencesKt.none(this.allowedNations());
    }

    public static final /* synthetic */ Ruleset access$getRuleset$p(MapEditorEditStartsTab $this) {
        return $this.ruleset;
    }

    public static final /* synthetic */ ButtonGroup access$getUsageOptionGroup$p(MapEditorEditStartsTab $this) {
        return $this.usageOptionGroup;
    }

    public static final /* synthetic */ MapEditorEditTab access$getEditTab$p(MapEditorEditStartsTab $this) {
        return $this.editTab;
    }

    public static final /* synthetic */ String access$spectatorToAnyCiv(MapEditorEditStartsTab $this, String $receiver) {
        return $this.spectatorToAnyCiv($receiver);
    }
}

