/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.mapeditorscreen.tabs;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.map.BFS;
import com.unciv.logic.map.mapgenerator.MapGenerationRandomness;
import com.unciv.logic.map.mapgenerator.MapGenerator;
import com.unciv.logic.map.mapgenerator.RiverGenerator;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileNormalizer;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.ActorKeyShortcutDispatcher;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.components.widgets.UncivSlider;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.mapeditorscreen.MapEditorScreen;
import com.unciv.ui.screens.mapeditorscreen.tabs.IMapEditorEditSubTabs;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorEditTab;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorOptionsTab;
import com.unciv.utils.Log;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0015\u0018\u0000 J2\u00020\u00012\u00020\u0002:\u0003HIJB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020&H\u0016J \u0010.\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020&H\u0016J\u0010\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\nH\u0002J\u0018\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u00020,H\u0002J\b\u00104\u001a\u00020\u000bH\u0002J\u0010\u00105\u001a\u0002062\u0006\u00100\u001a\u00020\nH\u0002J\u0015\u00107\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b8J\u0010\u00109\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\nH\u0002J\u0010\u0010:\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\nH\u0002J\u0010\u0010;\u001a\u0002062\u0006\u0010*\u001a\u00020\u0014H\u0002J\u0010\u0010<\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\nH\u0002J:\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u00102\u0006\u0010?\u001a\u00020,2\u0006\u0010@\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020,2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tJF\u0010=\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020\u00102\u0006\u0010?\u001a\u00020,2\u0006\u0010@\u001a\u00020,2\b\b\u0002\u0010A\u001a\u00020,2\b\b\u0002\u0010C\u001a\u0002062\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tJ4\u0010=\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020,2\u0006\u0010@\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020,2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0002J>\u0010=\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020,2\u0006\u0010@\u001a\u00020,2\b\b\u0002\u0010A\u001a\u00020,2\b\b\u0002\u0010C\u001a\u0002062\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tJ\u0010\u0010D\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\nH\u0002J\u0014\u0010E\u001a\u00020\u000b*\u00020\n2\u0006\u0010F\u001a\u00020\nH\u0002J\u0014\u0010G\u001a\u000206*\u00020\n2\u0006\u0010F\u001a\u00020\nH\u0002R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0010\u0010!\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/components/widgets/TabbedPager$IPageExtensions;", "editorScreen", "Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;", "headerHeight", "", "(Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;F)V", "brushAction", "Lkotlin/Function1;", "Lcom/unciv/logic/map/tile/Tile;", "", "brushCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "brushHandlerType", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab$BrushHandlerType;", "brushLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "value", "", "brushSize", "getBrushSize$core", "()I", "setBrushSize$core", "(I)V", "brushSlider", "Lcom/unciv/ui/components/widgets/UncivSlider;", "brushTable", "randomness", "Lcom/unciv/logic/map/mapgenerator/MapGenerationRandomness;", "getRandomness$core", "()Lcom/unciv/logic/map/mapgenerator/MapGenerationRandomness;", "riverEndTile", "riverStartTile", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "subTabs", "Lcom/unciv/ui/components/widgets/TabbedPager;", "tileMatchFuzziness", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorOptionsTab$TileMatchFuzziness;", "activated", "index", "caption", "", "pager", "deactivated", "directPaintTile", "tile", "linkCivilopedia", "brushActor", "link", "paintRiverFromTo", "paintTile", "", "paintTilesWithBrush", "paintTilesWithBrush$core", "riverPaintTile", "roadPaintTile", "selectPage", "selectRiverFromOrTo", "setBrush", "handlerType", "name", "icon", "pediaLink", "applyAction", "isRemove", "tileClickHandler", "applyFrom", "other", "isSimilarEnough", "AllEditSubTabs", "BrushHandlerType", "Companion", "core"})
public final class MapEditorEditTab
extends Table
implements TabbedPager.IPageExtensions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MapEditorScreen editorScreen;
    @NotNull
    private final TabbedPager subTabs;
    @NotNull
    private final Table brushTable;
    @NotNull
    private final UncivSlider brushSlider;
    @NotNull
    private final Label brushLabel;
    @NotNull
    private final Cell<Actor> brushCell;
    @NotNull
    private Ruleset ruleset;
    @NotNull
    private final MapGenerationRandomness randomness;
    @NotNull
    private BrushHandlerType brushHandlerType;
    @NotNull
    private Function1<? super Tile, Unit> brushAction;
    private int brushSize;
    @NotNull
    private MapEditorOptionsTab.TileMatchFuzziness tileMatchFuzziness;
    @Nullable
    private Tile riverStartTile;
    @Nullable
    private Tile riverEndTile;

    public MapEditorEditTab(@NotNull MapEditorScreen editorScreen, float headerHeight) {
        Table table2;
        Intrinsics.checkNotNullParameter(editorScreen, "editorScreen");
        super(BaseScreen.Companion.getSkin());
        this.editorScreen = editorScreen;
        this.brushTable = new Table(this.getSkin());
        this.brushLabel = Scene2dExtensionsKt.toLabel("Brush ([1]):");
        this.ruleset = this.editorScreen.getRuleset();
        this.randomness = new MapGenerationRandomness();
        this.brushHandlerType = BrushHandlerType.None;
        this.brushAction = brushAction.1.INSTANCE;
        this.brushSize = 1;
        this.tileMatchFuzziness = MapEditorOptionsTab.TileMatchFuzziness.CompleteMatch;
        this.top();
        Table $this$_init__u24lambda_u240 = table2 = this.brushTable;
        boolean bl = false;
        $this$_init__u24lambda_u240.pad(5.0f);
        $this$_init__u24lambda_u240.defaults().pad(10.0f).left();
        $this$_init__u24lambda_u240.add((Actor)this.brushLabel);
        Cell cell2 = $this$_init__u24lambda_u240.add().padLeft(0.0f);
        Intrinsics.checkNotNullExpressionValue(cell2, "padLeft(...)");
        this.brushCell = cell2;
        UncivSlider.TipType tipType = UncivSlider.TipType.Auto;
        this.brushSlider = new UncivSlider(1.0f, 6.0f, 1.0f, false, false, 1.0f, null, tipType, 1.1.INSTANCE, new Function1<Float, Unit>(this){
            final /* synthetic */ MapEditorEditTab this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(float it) {
                this.this$0.setBrushSize$core(it > 5.0f ? -1 : (int)it);
                MapEditorEditTab.access$getBrushLabel$p(this.this$0).setText(TranslationsKt.tr$default("Brush ([" + com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorEditTab$Companion.access$getBrushTip(MapEditorEditTab.Companion, it, true) + "]):", false, 1, null));
            }
        }, 88, null);
        $this$_init__u24lambda_u240.add((Actor)this.brushSlider).padLeft(0.0f);
        float subTabsHeight = this.editorScreen.getStage().getHeight() - (float)2 * headerHeight - this.brushTable.getPrefHeight() - 2.0f + 10.0f;
        float subTabsWidth = this.editorScreen.getToolsWidth();
        int n = AllEditSubTabs.values().length;
        this.subTabs = new TabbedPager(subTabsWidth, subTabsWidth, subTabsHeight, subTabsHeight, 0, null, null, null, 5.0f, null, null, n, 1776, null);
        for (AllEditSubTabs page : AllEditSubTabs.values()) {
            TabbedPager tabbedPager = this.subTabs;
            String string = page.getCaption();
            Group group = new Group();
            Image image2 = ImageGetter.INSTANCE.getImage(page.getIcon());
            KeyCharAndCode keyCharAndCode = new KeyCharAndCode(page.getKey());
            TabbedPager.addPage$default(tabbedPager, string, group, image2, 20.0f, 0, false, true, keyCharAndCode, 0, false, 816, null);
        }
        TabbedPager.selectPage$default(this.subTabs, 0, false, 2, null);
        this.add((Actor)this.brushTable).fillX().row();
        Table table3 = this;
        Color color = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "GRAY");
        Scene2dExtensionsKt.addSeparator$default(table3, color, 0, 0.0f, 6, null);
        this.add((Actor)this.subTabs).left().fillX().row();
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('t'), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.selectPage(0);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('f'), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.selectPage(1);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('w'), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.selectPage(2);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('r'), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.selectPage(3);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('i'), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.selectPage(4);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('v'), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.selectPage(5);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('s'), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.selectPage(6);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('u'), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.selectPage(7);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('1'), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.setBrushSize$core(1);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('2'), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.setBrushSize$core(2);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('3'), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.setBrushSize$core(3);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('4'), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.setBrushSize$core(4);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this).add(Character.valueOf('5'), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.setBrushSize$core(5);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this).add(KeyCharAndCode.Companion.ctrl('f'), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.setBrushSize$core(-1);
            }
        });
    }

    @NotNull
    public final MapGenerationRandomness getRandomness$core() {
        return this.randomness;
    }

    public final int getBrushSize$core() {
        return this.brushSize;
    }

    public final void setBrushSize$core(int value) {
        this.brushSize = value;
        this.brushSlider.setValue(value < 0 ? 6.0f : (float)value);
    }

    private final boolean selectPage(int index) {
        return TabbedPager.selectPage$default(this.subTabs, index, false, 2, null);
    }

    private final void linkCivilopedia(Actor brushActor, String link) {
        if (((CharSequence)link).length() == 0) {
            return;
        }
        brushActor.setTouchable(Touchable.enabled);
        ActivationExtensionsKt.onActivation(brushActor, new Function0<Unit>(this, link){
            final /* synthetic */ MapEditorEditTab this$0;
            final /* synthetic */ String $link;
            {
                this.this$0 = $receiver;
                this.$link = $link;
                super(0);
            }

            public final void invoke() {
                MapEditorEditTab.access$getEditorScreen$p(this.this$0).openCivilopedia(this.$link);
            }
        });
        ActorKeyShortcutDispatcher.add$default(ActivationExtensionsKt.getKeyShortcuts(brushActor), KeyboardBinding.Civilopedia, 0, 2, null);
    }

    public final void setBrush(@NotNull String name2, @NotNull String icon, @NotNull String pediaLink, boolean isRemove, @NotNull Function1<? super Tile, Unit> applyAction) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(icon, "icon");
        Intrinsics.checkNotNullParameter(pediaLink, "pediaLink");
        Intrinsics.checkNotNullParameter(applyAction, "applyAction");
        this.brushHandlerType = BrushHandlerType.Tile;
        Actor brushActor = FormattedLine.render$default(new FormattedLine(name2, null, icon, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, isRemove, 8186, null), 0.0f, null, 2, null);
        this.linkCivilopedia(brushActor, pediaLink);
        this.brushCell.setActor(brushActor);
        this.brushAction = applyAction;
    }

    public static /* synthetic */ void setBrush$default(MapEditorEditTab mapEditorEditTab, String string, String string2, String string3, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = string2;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        mapEditorEditTab.setBrush(string, string2, string3, bl, (Function1<? super Tile, Unit>)function1);
    }

    private final void setBrush(String name2, Actor icon, String pediaLink, Function1<? super Tile, Unit> applyAction) {
        Table table2;
        this.brushHandlerType = BrushHandlerType.Tile;
        Table $this$setBrush_u24lambda_u241 = table2 = new Table();
        boolean bl = false;
        $this$setBrush_u24lambda_u241.add(icon).padRight(10.0f);
        $this$setBrush_u24lambda_u241.add((Actor)Scene2dExtensionsKt.toLabel(name2));
        Table line = table2;
        this.linkCivilopedia(line, pediaLink);
        this.brushCell.setActor((Actor)line);
        this.brushAction = applyAction;
    }

    public final void setBrush(@NotNull BrushHandlerType handlerType, @NotNull String name2, @NotNull String icon, @NotNull String pediaLink, boolean isRemove, @NotNull Function1<? super Tile, Unit> applyAction) {
        Intrinsics.checkNotNullParameter((Object)handlerType, "handlerType");
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(icon, "icon");
        Intrinsics.checkNotNullParameter(pediaLink, "pediaLink");
        Intrinsics.checkNotNullParameter(applyAction, "applyAction");
        this.setBrush(name2, icon, pediaLink, isRemove, applyAction);
        this.brushHandlerType = handlerType;
    }

    public static /* synthetic */ void setBrush$default(MapEditorEditTab mapEditorEditTab, BrushHandlerType brushHandlerType, String string, String string2, String string3, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = string2;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        mapEditorEditTab.setBrush(brushHandlerType, string, string2, string3, bl, function1);
    }

    public final void setBrush(@NotNull BrushHandlerType handlerType, @NotNull String name2, @NotNull Actor icon, @NotNull String pediaLink, @NotNull Function1<? super Tile, Unit> applyAction) {
        Intrinsics.checkNotNullParameter((Object)handlerType, "handlerType");
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(icon, "icon");
        Intrinsics.checkNotNullParameter(pediaLink, "pediaLink");
        Intrinsics.checkNotNullParameter(applyAction, "applyAction");
        this.setBrush(name2, icon, pediaLink, applyAction);
        this.brushHandlerType = handlerType;
    }

    @Override
    public void activated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        if (this.editorScreen.getEditTabsNeedRefresh()) {
            this.ruleset = this.editorScreen.getRuleset();
            ImageGetter.INSTANCE.setNewRuleset(this.ruleset);
            for (AllEditSubTabs page : AllEditSubTabs.values()) {
                Table tab = page.getInstantiate().invoke(this, this.ruleset);
                this.subTabs.replacePage(page.getCaption(), (Actor)tab);
                String string = page.getCaption();
                Intrinsics.checkNotNull(tab, "null cannot be cast to non-null type com.unciv.ui.screens.mapeditorscreen.tabs.IMapEditorEditSubTabs");
                this.subTabs.setPageDisabled(string, ((IMapEditorEditSubTabs)((Object)tab)).isDisabled());
            }
            this.brushHandlerType = BrushHandlerType.None;
            this.editorScreen.setEditTabsNeedRefresh(false);
        }
        this.editorScreen.setTileClickHandler((Function1<? super Tile, Unit>)new Function1<Tile, Unit>((Object)this){

            public final void invoke(@NotNull Tile p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                MapEditorEditTab.access$tileClickHandler((MapEditorEditTab)this.receiver, p0);
            }
        });
        pager.setScrollDisabled(true);
        this.tileMatchFuzziness = this.editorScreen.getTileMatchFuzziness();
    }

    @Override
    public void deactivated(int index, @NotNull String caption, @NotNull TabbedPager pager) {
        Intrinsics.checkNotNullParameter(caption, "caption");
        Intrinsics.checkNotNullParameter(pager, "pager");
        pager.setScrollDisabled(true);
        this.editorScreen.setTileClickHandler(null);
    }

    private final void tileClickHandler(Tile tile) {
        if (this.brushSize < -1 || this.brushSize > 5 || this.brushHandlerType == BrushHandlerType.None) {
            return;
        }
        if (this.editorScreen.getMapHolder().isPanning() || this.editorScreen.getMapHolder().isZooming()) {
            return;
        }
        this.editorScreen.hideSelection();
        switch (WhenMappings.$EnumSwitchMapping$0[this.brushHandlerType.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                this.selectRiverFromOrTo(tile);
                break;
            }
            default: {
                this.paintTilesWithBrush$core(tile);
            }
        }
    }

    private final void selectRiverFromOrTo(Tile tile) {
        Tile[] tileArray = new Tile[]{tile};
        Set<Tile> tilesToHighlight = SetsKt.mutableSetOf(tileArray);
        if (tile.isLand()) {
            this.riverStartTile = tile;
            if (this.riverEndTile != null) {
                this.paintRiverFromTo();
                return;
            }
            RiverGenerator riverGenerator = new RiverGenerator(this.editorScreen.getTileMap(), this.randomness, this.ruleset);
            this.riverEndTile = riverGenerator.getClosestWaterTile(tile);
            if (this.riverEndTile != null) {
                Collection collection = tilesToHighlight;
                Tile tile2 = this.riverEndTile;
                Intrinsics.checkNotNull(tile2);
                collection.add(tile2);
            }
        } else {
            this.riverEndTile = tile;
            if (this.riverStartTile != null) {
                this.paintRiverFromTo();
                return;
            }
        }
        for (Tile tileToHighlight : tilesToHighlight) {
            Color color = Color.BLUE;
            Intrinsics.checkNotNullExpressionValue(color, "BLUE");
            this.editorScreen.highlightTile(tileToHighlight, color);
        }
    }

    private final void paintRiverFromTo() {
        Set resultingTiles = new LinkedHashSet();
        this.randomness.seedRNG(this.editorScreen.getNewMapParameters().getSeed());
        try {
            RiverGenerator riverGenerator = new RiverGenerator(this.editorScreen.getTileMap(), this.randomness, this.ruleset);
            Tile tile = this.riverStartTile;
            Intrinsics.checkNotNull(tile);
            Tile tile2 = this.riverEndTile;
            Intrinsics.checkNotNull(tile2);
            riverGenerator.spawnRiver(tile, tile2, resultingTiles);
            new MapGenerator(this.ruleset, null, 2, null).convertTerrains(resultingTiles);
        }
        catch (Exception ex) {
            Log.INSTANCE.error("Exception while generating rivers", ex);
            new ToastPopup("River generation failed!", this.editorScreen, 0L, 4, null);
        }
        this.riverStartTile = null;
        this.riverEndTile = null;
        this.editorScreen.setDirty(true);
        for (Tile tile : resultingTiles) {
            Color color = Color.SKY;
            Intrinsics.checkNotNullExpressionValue(color, "SKY");
            this.editorScreen.updateAndHighlight(tile, color);
        }
    }

    public final void paintTilesWithBrush$core(@NotNull Tile tile) {
        Sequence<Tile> sequence;
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (this.brushSize == -1) {
            BFS bfs2 = new BFS(tile, (Function1<? super Tile, Boolean>)new Function1<Tile, Boolean>(this, tile){
                final /* synthetic */ MapEditorEditTab this$0;
                final /* synthetic */ Tile $tile;
                {
                    this.this$0 = $receiver;
                    this.$tile = $tile;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Tile it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return MapEditorEditTab.access$isSimilarEnough(this.this$0, it, this.$tile);
                }
            });
            bfs2.stepToEnd();
            sequence = CollectionsKt.asSequence((Iterable)bfs2.getReachedTiles());
        } else {
            sequence = tile.getTilesInDistance(this.brushSize - 1);
        }
        Sequence<Tile> tiles2 = sequence;
        Iterator<Tile> iterator2 = tiles2.iterator();
        while (iterator2.hasNext()) {
            Tile tileToPaint = iterator2.next();
            switch (WhenMappings.$EnumSwitchMapping$0[this.brushHandlerType.ordinal()]) {
                case 3: {
                    this.directPaintTile(tileToPaint);
                    break;
                }
                case 4: {
                    this.paintTile(tileToPaint);
                    break;
                }
                case 5: {
                    this.roadPaintTile(tileToPaint);
                    break;
                }
                case 6: {
                    this.riverPaintTile(tileToPaint);
                }
            }
        }
    }

    private final void directPaintTile(Tile tile) {
        this.brushAction.invoke(tile);
        this.editorScreen.setDirty(true);
        MapEditorScreen.updateAndHighlight$default(this.editorScreen, tile, null, 2, null);
    }

    private final void riverPaintTile(Tile tile) {
        this.directPaintTile(tile);
        Iterator<Tile> iterator2 = tile.getNeighbors().iterator();
        while (iterator2.hasNext()) {
            Tile neighbor = iterator2.next();
            if (!(neighbor.getPosition().x > tile.getPosition().x) && !(neighbor.getPosition().y > tile.getPosition().y)) continue;
            this.editorScreen.updateTile(neighbor);
        }
    }

    private final void roadPaintTile(Tile tile) {
        if (!this.paintTile(tile)) {
            return;
        }
        Iterator<Tile> iterator2 = tile.getNeighbors().iterator();
        while (iterator2.hasNext()) {
            Tile neighbor = iterator2.next();
            this.editorScreen.updateTile(neighbor);
        }
    }

    private final boolean paintTile(Tile tile) {
        Tile savedTile = tile.clone();
        Tile paintedTile = tile.clone();
        this.brushAction.invoke(paintedTile);
        paintedTile.setRuleset(this.ruleset);
        try {
            paintedTile.setTerrainTransients();
        }
        catch (Exception ex) {
            String string = ex.getMessage();
            if (string == null) {
                throw ex;
            }
            String message2 = string;
            if (!StringsKt.endsWith$default(message2, "not exist in this ruleset!", false, 2, null)) {
                throw ex;
            }
            new ToastPopup(message2, this.editorScreen, 0L, 4, null);
        }
        this.brushAction.invoke(tile);
        tile.setTerrainTransients();
        TileNormalizer.INSTANCE.normalizeToRuleset(tile, this.ruleset);
        if (!this.isSimilarEnough(paintedTile, tile)) {
            this.applyFrom(tile, savedTile);
            return false;
        }
        if (!Intrinsics.areEqual(tile.getNaturalWonder(), savedTile.getNaturalWonder())) {
            this.editorScreen.setNaturalWondersNeedRefresh(true);
        }
        this.editorScreen.setDirty(true);
        MapEditorScreen.updateAndHighlight$default(this.editorScreen, tile, null, 2, null);
        return true;
    }

    private final boolean isSimilarEnough(Tile $this$isSimilarEnough, Tile other) {
        return this.tileMatchFuzziness.compareTo((Enum)MapEditorOptionsTab.TileMatchFuzziness.CompleteMatch) <= 0 && !Intrinsics.areEqual($this$isSimilarEnough.getImprovement(), other.getImprovement()) || $this$isSimilarEnough.getRoadStatus() != other.getRoadStatus() ? false : (this.tileMatchFuzziness.compareTo((Enum)MapEditorOptionsTab.TileMatchFuzziness.NoImprovement) <= 0 && !Intrinsics.areEqual($this$isSimilarEnough.getResource(), other.getResource()) ? false : (this.tileMatchFuzziness.compareTo((Enum)MapEditorOptionsTab.TileMatchFuzziness.BaseAndFeatures) <= 0 && !Intrinsics.areEqual(CollectionsKt.toSet((Iterable)$this$isSimilarEnough.getTerrainFeatures()), CollectionsKt.toSet((Iterable)other.getTerrainFeatures())) ? false : (this.tileMatchFuzziness.compareTo((Enum)MapEditorOptionsTab.TileMatchFuzziness.BaseTerrain) <= 0 && !Intrinsics.areEqual($this$isSimilarEnough.getBaseTerrain(), other.getBaseTerrain()) ? false : (this.tileMatchFuzziness.compareTo((Enum)MapEditorOptionsTab.TileMatchFuzziness.LandOrWater) <= 0 && $this$isSimilarEnough.isLand() != other.isLand() ? false : Intrinsics.areEqual($this$isSimilarEnough.getNaturalWonder(), other.getNaturalWonder())))));
    }

    private final void applyFrom(Tile $this$applyFrom, Tile other) {
        $this$applyFrom.setBaseTerrain(other.getBaseTerrain());
        $this$applyFrom.setTerrainFeatures(other.getTerrainFeatures());
        $this$applyFrom.setResource(other.getResource());
        $this$applyFrom.setImprovement(other.getImprovement());
        $this$applyFrom.setNaturalWonder(other.getNaturalWonder());
        $this$applyFrom.setRoadStatus(other.getRoadStatus());
        $this$applyFrom.setHasBottomLeftRiver(other.getHasBottomLeftRiver());
        $this$applyFrom.setHasBottomRightRiver(other.getHasBottomRightRiver());
        $this$applyFrom.setHasBottomRiver(other.getHasBottomRiver());
        $this$applyFrom.setTerrainTransients();
    }

    @Override
    @Nullable
    public Actor getFixedContent() {
        return TabbedPager.IPageExtensions.DefaultImpls.getFixedContent(this);
    }

    public static final /* synthetic */ MapEditorScreen access$getEditorScreen$p(MapEditorEditTab $this) {
        return $this.editorScreen;
    }

    public static final /* synthetic */ void access$tileClickHandler(MapEditorEditTab $this, Tile tile) {
        $this.tileClickHandler(tile);
    }

    public static final /* synthetic */ boolean access$isSimilarEnough(MapEditorEditTab $this, Tile $receiver, Tile other) {
        return $this.isSimilarEnough($receiver, other);
    }

    public static final /* synthetic */ Label access$getBrushLabel$p(MapEditorEditTab $this) {
        return $this.brushLabel;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B9\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR#\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001a\u00a8\u0006\u001b"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab$AllEditSubTabs;", "", "caption", "", "key", "", "icon", "instantiate", "Lkotlin/Function2;", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab;", "Lcom/unciv/models/ruleset/Ruleset;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "(Ljava/lang/String;ILjava/lang/String;CLjava/lang/String;Lkotlin/jvm/functions/Function2;)V", "getCaption", "()Ljava/lang/String;", "getIcon", "getInstantiate", "()Lkotlin/jvm/functions/Function2;", "getKey", "()C", "Terrain", "TerrainFeatures", "NaturalWonders", "Resources", "Improvements", "Rivers", "StartingLocations", "core"})
    private static final class AllEditSubTabs
    extends Enum<AllEditSubTabs> {
        @NotNull
        private final String caption;
        private final char key;
        @NotNull
        private final String icon;
        @NotNull
        private final Function2<MapEditorEditTab, Ruleset, Table> instantiate;
        public static final /* enum */ AllEditSubTabs Terrain = new AllEditSubTabs("Terrain", 't', "OtherIcons/Terrains", 1.INSTANCE);
        public static final /* enum */ AllEditSubTabs TerrainFeatures = new AllEditSubTabs("Features", 'f', "OtherIcons/Star", 2.INSTANCE);
        public static final /* enum */ AllEditSubTabs NaturalWonders = new AllEditSubTabs("Wonders", 'w', "OtherIcons/Star", 3.INSTANCE);
        public static final /* enum */ AllEditSubTabs Resources = new AllEditSubTabs("Resources", 'r', "OtherIcons/Resources", 4.INSTANCE);
        public static final /* enum */ AllEditSubTabs Improvements = new AllEditSubTabs("Improvements", 'i', "OtherIcons/Improvements", 5.INSTANCE);
        public static final /* enum */ AllEditSubTabs Rivers = new AllEditSubTabs("Rivers", 'v', "OtherIcons/Star", 6.INSTANCE);
        public static final /* enum */ AllEditSubTabs StartingLocations = new AllEditSubTabs("Starting locations", 's', "OtherIcons/Nations", 7.INSTANCE);
        private static final /* synthetic */ AllEditSubTabs[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private AllEditSubTabs(String caption, char key, String icon, Function2<? super MapEditorEditTab, ? super Ruleset, ? extends Table> instantiate) {
            this.caption = caption;
            this.key = key;
            this.icon = icon;
            this.instantiate = instantiate;
        }

        @NotNull
        public final String getCaption() {
            return this.caption;
        }

        public final char getKey() {
            return this.key;
        }

        @NotNull
        public final String getIcon() {
            return this.icon;
        }

        @NotNull
        public final Function2<MapEditorEditTab, Ruleset, Table> getInstantiate() {
            return this.instantiate;
        }

        public static AllEditSubTabs[] values() {
            return (AllEditSubTabs[])$VALUES.clone();
        }

        public static AllEditSubTabs valueOf(String value) {
            return Enum.valueOf(AllEditSubTabs.class, value);
        }

        @NotNull
        public static EnumEntries<AllEditSubTabs> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = allEditSubTabsArray = new AllEditSubTabs[]{AllEditSubTabs.Terrain, AllEditSubTabs.TerrainFeatures, AllEditSubTabs.NaturalWonders, AllEditSubTabs.Resources, AllEditSubTabs.Improvements, AllEditSubTabs.Rivers, AllEditSubTabs.StartingLocations};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab$BrushHandlerType;", "", "(Ljava/lang/String;I)V", "None", "Direct", "Tile", "Road", "River", "RiverFromTo", "core"})
    public static final class BrushHandlerType
    extends Enum<BrushHandlerType> {
        public static final /* enum */ BrushHandlerType None = new BrushHandlerType();
        public static final /* enum */ BrushHandlerType Direct = new BrushHandlerType();
        public static final /* enum */ BrushHandlerType Tile = new BrushHandlerType();
        public static final /* enum */ BrushHandlerType Road = new BrushHandlerType();
        public static final /* enum */ BrushHandlerType River = new BrushHandlerType();
        public static final /* enum */ BrushHandlerType RiverFromTo = new BrushHandlerType();
        private static final /* synthetic */ BrushHandlerType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static BrushHandlerType[] values() {
            return (BrushHandlerType[])$VALUES.clone();
        }

        public static BrushHandlerType valueOf(String value) {
            return Enum.valueOf(BrushHandlerType.class, value);
        }

        @NotNull
        public static EnumEntries<BrushHandlerType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = brushHandlerTypeArray = new BrushHandlerType[]{BrushHandlerType.None, BrushHandlerType.Direct, BrushHandlerType.Tile, BrushHandlerType.Road, BrushHandlerType.River, BrushHandlerType.RiverFromTo};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab$Companion;", "", "()V", "getBrushTip", "", "value", "", "abbreviate", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final String getBrushTip(float value, boolean abbreviate) {
            return value <= 5.0f ? TranslationsKt.tr((int)value) : (abbreviate ? "Floodfill_Abbreviation" : "Floodfill");
        }

        static /* synthetic */ String getBrushTip$default(Companion companion, float f, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.getBrushTip(f, bl);
        }

        public static final /* synthetic */ String access$getBrushTip(Companion $this, float value, boolean abbreviate) {
            return $this.getBrushTip(value, abbreviate);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BrushHandlerType.values().length];
            try {
                nArray[BrushHandlerType.None.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BrushHandlerType.RiverFromTo.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BrushHandlerType.Direct.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BrushHandlerType.Tile.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BrushHandlerType.Road.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BrushHandlerType.River.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

