/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.modmanager;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.models.metadata.ModCategories;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.modmanager.ModDecoratedButton;
import com.unciv.ui.screens.modmanager.ModUIData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J\r\u0010\u0011\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/unciv/ui/screens/modmanager/ModDecoratedButton;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "modInfo", "Lcom/unciv/ui/screens/modmanager/ModUIData;", "(Lcom/unciv/ui/screens/modmanager/ModUIData;)V", "stateImages", "Lcom/unciv/ui/screens/modmanager/ModDecoratedButton$ModStateImages;", "textButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "getColor", "Lcom/badlogic/gdx/graphics/Color;", "setColor", "", "color", "setText", "text", "", "updateIndicators", "()Lkotlin/Unit;", "updateUIData", "newModUIData", "ModStateImages", "core"})
public final class ModDecoratedButton
extends Table {
    @NotNull
    private ModUIData modInfo;
    @Nullable
    private final ModStateImages stateImages;
    @NotNull
    private final TextButton textButton;

    public ModDecoratedButton(@NotNull ModUIData modInfo) {
        Intrinsics.checkNotNullParameter(modInfo, "modInfo");
        this.modInfo = modInfo;
        this.setTouchable(Touchable.enabled);
        List<String> topics = this.modInfo.topics();
        ArrayList categories = new ArrayList();
        Iterator<ModCategories.Category> iterator2 = ModCategories.Companion.iterator();
        while (iterator2.hasNext()) {
            ModCategories.Category category = iterator2.next();
            if (Intrinsics.areEqual(category, ModCategories.Companion.default()) || !topics.contains(category.getTopic())) continue;
            ((Collection)categories).add(category);
        }
        this.textButton = Scene2dExtensionsKt.toTextButton$default(this.modInfo.buttonText(), null, false, 3, null);
        String topicString2 = CollectionsKt.joinToString$default(categories, null, null, null, 0, null, topicString.1.INSTANCE, 31, null);
        if (!((Collection)categories).isEmpty()) {
            this.textButton.row();
            this.textButton.add((Actor)Scene2dExtensionsKt.toLabel$default(topicString2, null, 14, 0, false, 13, null));
        }
        this.add((Actor)this.textButton);
        if (this.modInfo.getRuleset() == null) {
            this.stateImages = null;
        } else {
            this.stateImages = new ModStateImages();
            this.add((Actor)this.stateImages).align(8);
            this.updateIndicators();
        }
    }

    @Nullable
    public final Unit updateIndicators() {
        Unit unit;
        ModStateImages modStateImages = this.stateImages;
        if (modStateImages != null) {
            modStateImages.update(this.modInfo);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public final void setText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter(text2, "text");
        this.textButton.setText(text2);
    }

    @Override
    public void setColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        this.textButton.setColor(color);
    }

    @Override
    @NotNull
    public Color getColor() {
        Color color = this.textButton.getColor();
        Intrinsics.checkNotNullExpressionValue(color, "getColor(...)");
        return color;
    }

    public final void updateUIData(@NotNull ModUIData newModUIData) {
        Intrinsics.checkNotNullParameter(newModUIData, "newModUIData");
        this.modInfo = newModUIData;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/unciv/ui/screens/modmanager/ModDecoratedButton$ModStateImages;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "()V", "hasUpdateImage", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "visualImage", "getMinWidth", "", "update", "", "modInfo", "Lcom/unciv/ui/screens/modmanager/ModUIData;", "core"})
    private static final class ModStateImages
    extends Table {
        @NotNull
        private final Image visualImage = ImageGetter.INSTANCE.getImage("UnitPromotionIcons/Scouting");
        @NotNull
        private final Image hasUpdateImage = ImageGetter.INSTANCE.getImage("OtherIcons/Mods");

        public ModStateImages() {
            this.defaults().size(20.0f).align(10);
        }

        public final void update(@NotNull ModUIData modInfo) {
            Intrinsics.checkNotNullParameter(modInfo, "modInfo");
            this.clear();
            if (modInfo.isVisual()) {
                this.add((Actor)this.visualImage).row();
            }
            if (modInfo.getHasUpdate()) {
                this.add((Actor)this.hasUpdateImage).row();
            }
            this.pack();
        }

        @Override
        public float getMinWidth() {
            return 20.0f;
        }
    }
}

