/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.modmanager;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.github.Github;
import com.unciv.logic.github.GithubAPI;
import com.unciv.models.metadata.BaseRuleset;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.validation.ModCompatibility;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.extensions.UncivDateFormat;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.modmanager.ModUIData;
import com.unciv.utils.Concurrency;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\"\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0002J\u001c\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aJ(\u0010\u001b\u001a\u00020\u000f2\b\b\u0002\u0010\u001c\u001a\u00020\u00042\u0016\b\u0002\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001eJ\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\nH\u0002J\u000e\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#J\u000e\u0010!\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%JD\u0010!\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0002J\u000e\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020)R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R.\u0010\u0007\u001a\"\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\bj\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/unciv/ui/screens/modmanager/ModInfoAndActionPane;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "()V", "enableVisualCheckBox", "", "imageHolder", "isBuiltin", "repoUrlToPreviewImage", "Ljava/util/HashMap;", "", "Lcom/badlogic/gdx/graphics/Texture;", "Lkotlin/collections/HashMap;", "sizeLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "addLocalPreviewImage", "", "modName", "addPreviewImage", "repoUrl", "defaultBranch", "avatarUrl", "addUncivLogo", "addUpdateModButton", "modInfo", "Lcom/unciv/ui/screens/modmanager/ModUIData;", "doDownload", "Lkotlin/Function0;", "addVisualCheckBox", "startsOutChecked", "changeAction", "Lkotlin/Function1;", "setTextureAsPreview", "texture", "update", "repo", "Lcom/unciv/logic/github/GithubAPI$Repo;", "mod", "Lcom/unciv/models/ruleset/Ruleset;", "updatedAt", "author", "modSize", "", "updateSize", "size", "core"})
@SourceDebugExtension(value={"SMAP\nModInfoAndActionPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModInfoAndActionPane.kt\ncom/unciv/ui/screens/modmanager/ModInfoAndActionPane\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n12474#2,2:183\n1#3:185\n*S KotlinDebug\n*F\n+ 1 ModInfoAndActionPane.kt\ncom/unciv/ui/screens/modmanager/ModInfoAndActionPane\n*L\n56#1:183,2\n*E\n"})
public final class ModInfoAndActionPane
extends Table {
    @NotNull
    private final HashMap<String, Texture> repoUrlToPreviewImage = new HashMap();
    @NotNull
    private final Table imageHolder = new Table();
    @NotNull
    private final Label sizeLabel = Scene2dExtensionsKt.toLabel("");
    private boolean isBuiltin;
    private boolean enableVisualCheckBox;

    public ModInfoAndActionPane() {
        this.defaults().pad(10.0f);
    }

    public final void update(@NotNull GithubAPI.Repo repo) {
        Intrinsics.checkNotNullParameter(repo, "repo");
        this.isBuiltin = false;
        this.enableVisualCheckBox = false;
        this.update(repo.getName(), repo.getHtml_url(), repo.getDefault_branch(), repo.getPushed_at(), repo.getOwner().getLogin(), repo.getSize(), repo.getOwner().getAvatar_url());
    }

    /*
     * Unable to fully structure code
     */
    public final void update(@NotNull Ruleset mod) {
        block3: {
            Intrinsics.checkNotNullParameter(mod, "mod");
            modName = mod.getName();
            modOptions = mod.getModOptions();
            v0 = this;
            if (!(((CharSequence)modOptions.getModUrl()).length() == 0)) ** GOTO lbl-1000
            var4_4 = BaseRuleset.values();
            var11_5 = v0;
            $i$f$any = false;
            var7_8 = ((void)$this$any$iv).length;
            for (var6_7 = 0; var6_7 < var7_8; ++var6_7) {
                it = element$iv = $this$any$iv[var6_7];
                $i$a$-any-ModInfoAndActionPane$update$1 = false;
                if (!Intrinsics.areEqual(it.getFullName(), modName)) continue;
                v1 = true;
                break block3;
            }
            v1 = false;
        }
        var12_12 = v1;
        v0 = var11_5;
        if (var12_12) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        v0.isBuiltin = v2;
        this.enableVisualCheckBox = ModCompatibility.INSTANCE.isAudioVisualMod(mod);
        ModInfoAndActionPane.update$default(this, modName, modOptions.getModUrl(), modOptions.getDefaultBranch(), modOptions.getLastUpdated(), modOptions.getAuthor(), modOptions.getModSize(), null, 64, null);
    }

    private final void update(String modName, String repoUrl, String defaultBranch, String updatedAt, String author, int modSize, String avatarUrl) {
        this.clear();
        this.imageHolder.clear();
        if (this.isBuiltin) {
            this.addUncivLogo();
        } else if (((CharSequence)repoUrl).length() == 0) {
            this.addLocalPreviewImage(modName);
        } else {
            this.addPreviewImage(repoUrl, defaultBranch, avatarUrl);
        }
        this.add((Actor)this.imageHolder).row();
        if (((CharSequence)author).length() > 0) {
            this.add((Actor)Scene2dExtensionsKt.toLabel("Author: [" + author + ']')).row();
        }
        this.updateSize(modSize);
        this.add((Actor)this.sizeLabel).padBottom(15.0f).row();
        if (((CharSequence)repoUrl).length() > 0) {
            TextButton githubButton = Scene2dExtensionsKt.toTextButton$default("Open Github page", null, false, 3, null);
            ActivationExtensionsKt.onClick(githubButton, new Function0<Unit>(repoUrl){
                final /* synthetic */ String $repoUrl;
                {
                    this.$repoUrl = $repoUrl;
                    super(0);
                }

                public final void invoke() {
                    Gdx.net.openURI(this.$repoUrl);
                }
            });
            ActivationExtensionsKt.onRightClick$default(githubButton, null, new Function0<Unit>(repoUrl, this){
                final /* synthetic */ String $repoUrl;
                final /* synthetic */ ModInfoAndActionPane this$0;
                {
                    this.$repoUrl = $repoUrl;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    Gdx.app.getClipboard().setContents(this.$repoUrl);
                    Stage stage = this.this$0.getStage();
                    Intrinsics.checkNotNullExpressionValue(stage, "getStage(...)");
                    new ToastPopup("Link copied to clipboard", stage, 0L, 4, null);
                }
            }, 1, null);
            this.add((Actor)githubButton).row();
        }
        if (((CharSequence)updatedAt).length() > 0) {
            Date date = UncivDateFormat.INSTANCE.parseDate(updatedAt);
            String updateString = "{Updated}: " + UncivDateFormat.INSTANCE.formatDate(date);
            this.add((Actor)Scene2dExtensionsKt.toLabel(updateString)).row();
        }
    }

    static /* synthetic */ void update$default(ModInfoAndActionPane modInfoAndActionPane, String string, String string2, String string3, String string4, String string5, int n, String string6, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            string6 = null;
        }
        modInfoAndActionPane.update(string, string2, string3, string4, string5, n, string6);
    }

    public final void updateSize(int size2) {
        String text2 = size2 <= 0 ? "" : (size2 < 2048 ? "Size: [" + size2 + "] kB" : "Size: [" + (size2 + 512) / 1024 + "] MB");
        this.sizeLabel.setText(TranslationsKt.tr$default(text2, false, 1, null));
    }

    public final void addVisualCheckBox(boolean startsOutChecked, @Nullable Function1<? super Boolean, Unit> changeAction) {
        if (this.enableVisualCheckBox) {
            this.add((Actor)Scene2dExtensionsKt.toCheckBox("Permanent audiovisual mod", startsOutChecked, changeAction)).row();
        }
    }

    public static /* synthetic */ void addVisualCheckBox$default(ModInfoAndActionPane modInfoAndActionPane, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        modInfoAndActionPane.addVisualCheckBox(bl, function1);
    }

    public final void addUpdateModButton(@NotNull ModUIData modInfo, @NotNull Function0<Unit> doDownload) {
        Intrinsics.checkNotNullParameter(modInfo, "modInfo");
        Intrinsics.checkNotNullParameter(doDownload, "doDownload");
        if (!modInfo.getHasUpdate()) {
            return;
        }
        TextButton updateModTextbutton = Scene2dExtensionsKt.toTextButton$default("Update [" + modInfo.getName() + ']', null, false, 3, null);
        ActivationExtensionsKt.onClick(updateModTextbutton, new Function0<Unit>(updateModTextbutton, doDownload){
            final /* synthetic */ TextButton $updateModTextbutton;
            final /* synthetic */ Function0<Unit> $doDownload;
            {
                this.$updateModTextbutton = $updateModTextbutton;
                this.$doDownload = $doDownload;
                super(0);
            }

            public final void invoke() {
                this.$updateModTextbutton.setText(TranslationsKt.tr$default("Downloading...", false, 1, null));
                this.$doDownload.invoke();
            }
        });
        this.add((Actor)updateModTextbutton).row();
    }

    private final void addPreviewImage(String repoUrl, String defaultBranch, String avatarUrl) {
        if (!StringsKt.startsWith$default(repoUrl, "http", false, 2, null)) {
            return;
        }
        if (this.repoUrlToPreviewImage.containsKey(repoUrl)) {
            Texture texture = this.repoUrlToPreviewImage.get(repoUrl);
            if (texture != null) {
                this.setTextureAsPreview(texture);
            }
            return;
        }
        Concurrency.run$default(Concurrency.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(repoUrl, defaultBranch, avatarUrl, this, null){
            int label;
            final /* synthetic */ String $repoUrl;
            final /* synthetic */ String $defaultBranch;
            final /* synthetic */ String $avatarUrl;
            final /* synthetic */ ModInfoAndActionPane this$0;
            {
                this.$repoUrl = $repoUrl;
                this.$defaultBranch = $defaultBranch;
                this.$avatarUrl = $avatarUrl;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        Pixmap imagePixmap = Github.INSTANCE.tryGetPreviewImage(this.$repoUrl, this.$defaultBranch, this.$avatarUrl);
                        if (imagePixmap == null) {
                            ((Map)ModInfoAndActionPane.access$getRepoUrlToPreviewImage$p(this.this$0)).put(this.$repoUrl, null);
                            return Unit.INSTANCE;
                        }
                        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(imagePixmap, this.this$0, this.$repoUrl, null){
                            int label;
                            final /* synthetic */ Pixmap $imagePixmap;
                            final /* synthetic */ ModInfoAndActionPane this$0;
                            final /* synthetic */ String $repoUrl;
                            {
                                this.$imagePixmap = $imagePixmap;
                                this.this$0 = $receiver;
                                this.$repoUrl = $repoUrl;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure(object);
                                        Texture texture = new Texture(this.$imagePixmap);
                                        this.$imagePixmap.dispose();
                                        ((Map)ModInfoAndActionPane.access$getRepoUrlToPreviewImage$p(this.this$0)).put(this.$repoUrl, texture);
                                        ModInfoAndActionPane.access$setTextureAsPreview(this.this$0, texture);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    private final void addLocalPreviewImage(String modName) {
        FileHandle fileHandle;
        FileHandle modFolder = Gdx.files.local("mods/" + modName);
        FileHandle it = fileHandle = modFolder.child("preview.jpg");
        boolean bl = false;
        FileHandle fileHandle2 = it.exists() ? fileHandle : null;
        if (fileHandle2 == null) {
            FileHandle fileHandle3;
            FileHandle it2 = fileHandle3 = modFolder.child("preview.png");
            boolean bl2 = false;
            fileHandle2 = it2.exists() ? fileHandle3 : null;
            if (fileHandle2 == null) {
                return;
            }
        }
        FileHandle previewFile = fileHandle2;
        this.setTextureAsPreview(new Texture(previewFile));
    }

    private final void addUncivLogo() {
        this.setTextureAsPreview(new Texture(Gdx.files.internal("ExtraImages/banner.png")));
    }

    private final void setTextureAsPreview(Texture texture) {
        Cell<Actor> cell2 = this.imageHolder.add((Actor)new Image(texture));
        int largestImageSize = Math.max(texture.getWidth(), texture.getHeight());
        if ((float)largestImageSize > 200.0f) {
            float resizeRatio = 200.0f / (float)largestImageSize;
            cell2.size((float)texture.getWidth() * resizeRatio, (float)texture.getHeight() * resizeRatio);
        }
    }

    public static final /* synthetic */ HashMap access$getRepoUrlToPreviewImage$p(ModInfoAndActionPane $this) {
        return $this.repoUrlToPreviewImage;
    }

    public static final /* synthetic */ void access$setTextureAsPreview(ModInfoAndActionPane $this, Texture texture) {
        $this.setTextureAsPreview(texture);
    }
}

